/*
    Gn: A Server for the Internet Gopher Protocol(*).
    File: gn/mod.c
    Version 2.15
    
    Copyright (C) 1994  <by John Franks>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    (*) Gopher is a registered trademark of the Univ. of Minn.

*/

#include <string.h>
#include <ctype.h>
#include "gn.h"

static int	mon2int(),
		comp_date();


int
modified( ip)
Item	*ip;
{
	if ( comp_date( ip->mod_date, inputheader.modsince) >=0 )
		return TRUE;
	else
		return FALSE;
}




static int
comp_date( d1, d2)
char	*d1,
	*d2;
{
	register char	*cp,
			*sp,
			*cp2,
			*sp2;

	char		buf1[SMALLLEN],
			buf2[SMALLLEN];

	int		n1,
			n2,
			day,
			month,
			year;

	strcpy( buf1, d1);
	strcpy( buf2, d2);
	cp = strchr( buf1, '-');
	cp2 = strchr( buf2, '-');
	if( *cp && *cp2 ) {
		*cp = *cp2 = '\0';
		day = strcmp( cp - 2, cp2 - 2);
	}
	else  /* Messed up date, do a GET */
		return (1);

	sp = strchr( ++cp, '-');
	sp2 = strchr( ++cp2, '-');
	if( *sp && *sp2 ) {
		*sp = *sp2 = '\0';
		month = mon2int( cp) - mon2int (cp2);
	}
	else  /* Messed up date, do a GET */
		return (1);

	cp = strchr( ++sp, ' ');
	cp2 = strchr( ++sp2, ' ');
	if( *cp && *cp2 ) {
		*cp++ = *cp2++ = '\0';
		n1 = atoi( sp);
		n1 = ( n1 < 70 ? n1 + 100 : n1);
		n2 = atoi( sp2);
		n2 = ( n2 < 70 ? n2 + 100 : n2);
		year = n1 - n2;
	}
	else  /* Messed up date, do a GET */
		return (1);

	if ( year > 0)
		return 1;
	if ( year < 0)
		return -1;
	if ( month > 0)
		return 1;
	if ( month < 0)
		return -1;
	if ( day > 0)
		return 1;
	if ( day < 0)
		return -1;
	return strncmp( cp, cp2, 8);
}


static int
mon2int( month)
char	*month;
{
	strlower( month);
	switch (*month) {
	case 'a':
		return ( *++month == 'p' ? 4 : 8);
	case 'd':
		return (12);
	case 'f':
		return (2);
	case 'j':
		if ( *++month == 'a' )
			return (1);
		return ( *++month == 'n' ? 6 : 7);
	case 'm':
		return ( *(month+2) == 'r' ? 3 : 5);
	case 'n':
		return (11);
	case 'o':
		return (10);
	case 's':
		return (9);
	default:
		return (0);
	}
}