/**************************************************************************
 *									  *
 * 		 Copyright (C) 1995 Silicon Graphics, Inc.		  *
 *									  *
 *  These coded instructions, statements, and computer programs  where	  *
 *  deveolped by SGI for public use.  If anychanges are made to this code *
 *  please try to get the changes back to the author.  Feel free to make  *
 *  modfications and changes to the code and release it.		  *
 *									  *
 **************************************************************************/

#include <stdio.h>
#include <errno.h>
#include <signal.h>
#ifndef __bsdi__
#include <siginfo.h>
#endif
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <math.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/errno.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <netdb.h>

#include "bench.h"
#include "timefunc.h"
#include "debug.h"
#include "sysdep.h"

#define PROGPATH "/var/tmp/webclient"
#define NCCARGS 4096
#define MAXCLIENTS 256
#define MAXUSERNAME 9
#define MAXPASSWD 9
#define BUFSIZE 4096

static int	savefile = 0;
static int     socknum[MAXCLIENTS];
int	debug = 0;
int	keepalive = 0;
static int	returnval;

FILE	*debugfile = stderr;

static void
usage(const char *progname)
{
char *message;

	strcat(message,"Usage: %s [-a] [-d] -f config_file [-l numloops]\n");
	strcat(message,"          [-p port_num] [-r] [-s] [-t run_time] \n");
	strcat(message,"          [-k]\n");
	strcat(message,"\n");
        strcat(message,"-w webserver URL [URL ...]\n\n");
        strcat(message,"-a print timing information for all clients\n");
        strcat(message,"-d turn on debug statements\n");
        strcat(message,"-f config_file\tfile specifying clients\n");
        strcat(message,"-l number of iterations to retrieve uils\n");
        strcat(message,"-p port number of web server if not 80\n");
        strcat(message,"-r redirect stdout of clients to /tmp/webstone.xxx\n");
        strcat(message,"-s save client gets to /tmp/webstone.data.*\n");
        strcat(message,"-t run_time\tduration of test in minutes\n");
        strcat(message,"-w webserver\tname of webserver host to contact\n");
	strcat(message,"-u URL file\tfilelist of URLs\n");
	strcat(message,"-R record all transaction \n");
	strcat(message,"-k use keep-alive on client connections to webserver\n");

	errexit(message, progname);
}


static int
passivesock(const ushort portnum, const char *protocol, const int qlen)
{
  /*  struct servent     *pse; NOT USED: pointer to service info entry */
  struct protoent    *ppe; /* pointer to protocol info entry */
  struct sockaddr_in sin;  /* Internet endpoint address */
  int    s;                /* socket descriptor */
  int    type;             /* socket type */

  D_PRINTF "Beginning passivesock with errno %d\n",errno D_FLUSH;

  sin.sin_family = AF_INET;
  sin.sin_addr.s_addr = INADDR_ANY;

  D_PRINTF "Zeroing address structure\n" D_FLUSH; 
  memset((char *)&sin, 0, sizeof(sin));
  
  /* NOT USED: Map service name to portnumber */
  D_PRINTF "Mapping portnum errno %d\n",errno D_FLUSH;
  sin.sin_port = htons(portnum);
 
  /* Map protocol name to number */
  D_PRINTF "Mapping protocol name errno %d\n",errno D_FLUSH;
  if ((ppe = getprotobyname(protocol)) == 0)
    {
    errexit("Can't get \"%s\" protocol entry\n", protocol);
    }
  errno = 0;

  /* use protocol to choose socket type */
  D_PRINTF "Changing socket type, errno %d\n",errno D_FLUSH;
  if (strcmp(protocol, "udp") == 0)
    {
      type = SOCK_DGRAM;
	D_PRINTF "Choosing SOCK_DGRAM\n" D_FLUSH;
    }
  else
    {
      type = SOCK_STREAM;
	D_PRINTF "Choosing SOCK_STREAM, errno %d\n",errno D_FLUSH;
    }

  /* allocate a socket */
  s = socket(PF_INET, type, ppe->p_proto);
  if (s < 0)
    {
      D_PRINTF "Socket PF_INET %d %d returned %d with errno %d (%s)\n",
	type, ppe->p_proto, s, errno, strerror(errno) D_FLUSH;
      errexit("Can't create socket: %s\n", strerror(errno));
    }
	D_PRINTF "Socket %d created with errno %d\n",s,errno D_FLUSH;

  /* Bind the socket */
  if (bind(s, (struct sockaddr *)&sin, sizeof(sin)) < 0)
    {
      errexit("Can't bind to port %d: %s\n", portnum, strerror(errno));
    }
	D_PRINTF "Bind succeeded\n" D_FLUSH;

  /* If it's a stream, listen for connections */
  if ((type == SOCK_STREAM) && (listen(s, qlen) < 0))
    {
      errexit("Can't listen on port %s: %s\n", portnum, strerror(errno));
    }
	D_PRINTF "Listen succeeded\n" D_FLUSH;

  /* all done, return socket descriptor */
  return(s);
}  

static void
abort_clients(void)
{
int cnt;

    /*
     * IF WE DID NOT GET ALL OF OUR READYS, THEN WE NEED TO ABORT.
     */
    /*
     * SEND AN ABORT TO ALL THE CLIENTS AND EXIT.
     */
 
    fprintf(stdout,"Aborting for some reason\n");
    for(cnt = 0; cnt < MAXCLIENTS; cnt++)
    {
        if(socknum[cnt] != -1)
        {
            write(socknum[cnt],ABORTSTR,ABORTSTRLEN);
            close(socknum[cnt]);
            socknum[cnt] = 1;
	}
    }
}

static int
echo_client(const int fd)
{
  /* 
   * WRITE TEXT FROM FILE DESCRIPTOR INTO STDOUT 
   */
  char buf[BUFSIZ];
  int  cc;
  D_PRINTF "echo_client running\n" D_FLUSH;

  while (getppid() != 1)
    {
      while (cc = read(fd, buf, sizeof(buf)))
	{
	  if (cc > 0)
	    {
	      write(STDOUT_FILENO, buf, cc);
	    }
	}
    }
  D_PRINTF "Exiting echo_client\n" D_FLUSH;
  return(0);
}

void
main(const int argc, char *argv[])
{

    int		tmpfd;
    int		dumpall = 0;
    int 	numfiles = 0;
    int		testtime = 0;
    int		havewebserver = 0;
    int 	numloops = 0;
    int		portnum = 0;
    int		redirect = 0;
    int		totalnumclients = 0;
    int		record_all_transations =0;
    int		cnt;
    int		len;
    /* int		amclient = 0; */
    int		numclients = 0;
    int		sock;
    /* int		loopcnt = 0; */
    /* int		filecnt; */
    int		i=0;
    int		j=0;
    int		uil_filelist_f;
    char	buffer[NCCARGS];
    char 	webserver[MAXHOSTNAMELEN];
    char	configfile[MAXPATHLEN];
    char	uil_filelist[NCCARGS];
    char 	filelist[256][MAXPATHLEN];
    /* char	connectstr[MAXHOSTNAMELEN+10]; */
    char	hostname[MAXHOSTNAMELEN];
    char	clienthostname[MAXCLIENTS][MAXHOSTNAMELEN];
    char	*tmphostname;
    char 	commandline[NCCARGS];
    char 	tmpcommandline[NCCARGS];
    char	login[MAXUSERNAME];
    char	password[MAXPASSWD];
    char 	*timestr;
    time_t 	starttime;
    time_t	endtime;
    FILE	*fp;
    struct sockaddr_in 	serveraddr;
    /* struct hostent 	*hostid; */
    struct servent	*inetport;
    fd_set	fdset;
    fd_set	tmpfdset;
    fd_set	zerofdset;
    fd_set	leftfdset;
    /* struct timeval	timeout; */
    struct timeval	dtime;
    stats_t	statarray[MAXCLIENTS];
    stats_t	masterstat;
    page_stats_t page_stats[MAXCLIENTS][MAXNUMOFPAGES];
    page_stats_t page_stats_total[MAXNUMOFPAGES];
    int		getoptch;
    int		currarg;
    double	thruput;
    /*    double	seconds;
    double	useconds; */
    extern char	*optarg;
    extern int	optind;

int	bytes_to_read;
void *rptr;

    /* Initalization of variables. */
    memset(buffer, 0, NCCARGS);
    memset(webserver, 0, MAXHOSTNAMELEN);
    memset(configfile, 0, MAXPATHLEN);
    stats_init(&masterstat);
    for (i=0; i < MAXCLIENTS; i++) {
        stats_init(&(statarray[i]));
    }
    for (i=0; i < MAXCLIENTS; i++) {
        for (j=0; j < MAXNUMOFPAGES; j++) {
            page_stats_init(&(page_stats[i][j]));
	}
    }
    for (i=0; i < MAXNUMOFPAGES; i++) {
        page_stats_init(&(page_stats_total[i]));
    }

    uil_filelist_f = 0;
    
    for(cnt = 0; cnt < MAXCLIENTS; cnt++)
    {
        socknum[cnt] = -1;
        statarray[cnt].rs.totalconnects = 0;
    }    

    /* 
     * PARSE THE COMMAND LINE OPTIONS
     */
    while((getoptch = getopt(argc,argv,"f:t:l:p::u:R:w:c:n:arsdk")) != EOF)
    {
        switch(getoptch)
        {
            case 'a':
                dumpall = 1;
                break;
            case 'd':
                debug = 1;
                break;
	    case 'k':
		keepalive = 1;
		break;
            case 'f':
                sprintf(configfile,"%s",optarg);
                break;
	    case 'u':
		sprintf(uil_filelist, "%s", optarg);
		uil_filelist_f = 1;
		break;
            case 'l':
                numloops = atoi(optarg);
	        if(testtime != 0)
                {
	            /*
                     * EITHER numloops OR testtime, BUT NOT BOTH.
                     */
                    usage(argv[0]);
                }
                break;
            case 'p':
                portnum = atoi(optarg);
                break;
	    case 'r':
	        redirect = 1;
                break;
	    case 's':
	        savefile = 1;
                break;
            case 't':
                testtime = atoi(optarg);
	        if(numloops != 0)
                {
	            /*
                     * EITHER numloops OR testtime, BUT NOT BOTH.
                     */
                    usage(argv[0]);
	            exit(2);
                }
                break;
            case 'w':
                havewebserver = 1;
                sprintf(webserver,"%s",optarg);
                break;
	    case 'R':	
		record_all_transations = 1;
		break;
            default:
                usage(argv[0]);
                exit(2);
        }
    }

    if(havewebserver != 1)
    {
        /*
         * THE SERVERS NAME MUST BE SPECIFIED
         */
	
        fprintf(stderr,"No WWW Server specified\n");
        usage(argv[0]);
    }

    if(strlen(configfile) == 0)
    {
        /*
         * THE MASTER MUST HAVE A CONFIGURATION FILE TO READ.
         */
        fprintf(stderr,"No Configuration file specified\n");
        usage(argv[0]);
    }
    /* IF WE DO NOT HAVE A FILE LIST THEN THERE ARE UIL'S AT THE END OF THE
     * COMMAND LINE SO GRAP THEM.
     */
    if (uil_filelist_f == 0)
    {
	currarg = optind;
	numfiles = 0;
	while(currarg != argc)
	{
	   /*
	    * GET THE UILS TO RETRIEVE.
	    */
        
	    sscanf(argv[currarg],"%s",filelist[numfiles]);
	    numfiles++;
	    currarg++;
	}

	if(numfiles == 0)
	{
	   /*
	    * AT LEAST ONE FILE MUST BE SPECIFIED
	    */
	    fprintf(stderr, "No URL resources specified\n");
	    usage(argv[0]);
	}
    }

    /*
     * SET UP THE SOCKET WE ARE GOING TO USE TO SYNCHRONIZE WITH THE CLIENTS.
     */
    D_PRINTF "About to call sock %d %d\n",portnum,MAXCLIENTS D_FLUSH;

    sock = passivesock(0,"tcp",MAXCLIENTS);

    if ((sock < 0) || errno)
    {
        errexit("Couldn't open socket %d: (%d) %s\n",sock,
		errno,strerror(errno));
    }
	D_PRINTF "The passivesock call succeeded\n" D_FLUSH;

    /*
     * BUILD THE PORTIONS OF THE cmdline FOR EACH CLIENT THAT WE CAN BUILD NOW.
     * WE WILL FILL IN THE NUMBER OF CLIENTS LATER WITH AN sprintf.
     */
    if(gethostname(hostname,MAXHOSTNAMELEN) != 0)
    {
	errexit("Could not retrieve local host name");
    }
    len = sizeof(serveraddr);
    if(getsockname(sock,(struct sockaddr *)&serveraddr,&len) < 0)
    {
	errexit("Could not get socket informaton ");
    }

    memcpy(commandline,PROGPATH,strlen(PROGPATH));
    sprintf(tmpcommandline,"%s %s %s",commandline,"-w",webserver);
    strcpy(commandline,tmpcommandline);
    sprintf(commandline,"%s -c %s:%d",commandline,hostname,
	    ntohs(serveraddr.sin_port));

    if(debug)
    {
	  strcat(commandline," -d");
    }
    if(keepalive)
    {
	  strcat(commandline," -k");
    }
    if(numloops != 0)
    {
        sprintf(tmpcommandline,"%s %s %d",commandline,"-l",numloops);
        strcpy(commandline,tmpcommandline);
    }
    if(portnum)
    {
        sprintf(tmpcommandline,"%s %s %d",commandline,"-p",portnum);
        strcpy(commandline,tmpcommandline);
    }
    if(redirect)
    {
        strcat(commandline," -r");
    }
    if(savefile)
    {
        strcat(commandline," -s");
    }
    if(uil_filelist_f)
    {
        strcat(commandline," -u");
	strcat(commandline," ");
	strcat(commandline,uil_filelist);
    }
    if (record_all_transations)
    {
	strcat(commandline," -R");
    }
    if(testtime != 0)
    {
        sprintf(tmpcommandline,"%s %s %d",commandline,"-t",testtime);
        strcpy(commandline,tmpcommandline);
    }

    /*
     * SET UP A SPACE FOR THE NUMBER OF CLIENTS ON THE commandline.
     */
    sprintf(tmpcommandline,"%s %s %s",commandline,"-n","%d");
    strcpy(commandline,tmpcommandline);
    
    if (uil_filelist_f == 0)
    {
	cnt = 0;
	while(cnt < numfiles)
	{
	   /*
	    * PUT THE FILES AT THE END OF THE LIST.
	    */
	    strcat(commandline," ");
	    strcat(commandline,filelist[cnt]);
	    cnt++;
	}
    }
   
   
    fprintf(stdout,"%s\n", commandline);
    fflush(stdout);
   
    /*
     * OPEN UP THE CONFIG FILE. FOR EACH LINE IN THE CONFIG FILE, CHECK
     * ITS VALIDITY AND THEN rexec A COMMAND ON THE CLIENT.
     */
    if((fp = fopen(configfile,"r")) == NULL)
    {
        fprintf(stdout,"Could not open config file %s\n", configfile);
	fflush(stdout);
        perror(NULL);
        exit(1);
    }
   
#ifdef USE_RCMD
    if((inetport = getservbyname("shell","tcp")) == NULL)
    {
        errexit("Could not get service name for shell/tcp\n");
    }
#else
    if((inetport = getservbyname("exec","tcp")) == NULL)
    {
        errexit("Could not get service name for exec/tcp\n");
    }
#endif
    
    cnt = 0;
    totalnumclients = 0;
#ifdef USE_RCMD
    D_PRINTF "rcmd loop\n" D_FLUSH;
#else
    D_PRINTF "rexec loop\n" D_FLUSH;
#endif
    while(fscanf(fp,"%s %s %s %d",clienthostname[cnt],login,password,
							&numclients) == 4)
    {
        totalnumclients += numclients;
        fprintf(stdout,"%d: Client: %s \t Number of Clients: %d\n",
		cnt, clienthostname[cnt], numclients);
	fflush(stdout);
        sprintf(tmpcommandline,commandline,numclients);

        if((tmphostname = (char *)malloc(MAXHOSTNAMELEN+1)) == NULL) 
        { 
            errexit("malloc of tmphopstname failed\n"); 
        }
        tmphostname = strcpy(tmphostname, clienthostname[cnt]);

#ifdef USE_RCMD
		D_PRINTF "%s rcmd %s\n",tmphostname,tmpcommandline D_FLUSH;
        if((tmpfd = rcmd(&tmphostname,inetport->s_port,login,login,
						tmpcommandline,0)) < 0)
        {
            errexit("Could not rcmd: rcmd to client %s, cmdline %s failed\n",
		    clienthostname[cnt],tmpcommandline);
        }
#else
		D_PRINTF "%s rexec %s\n",tmphostname,tmpcommandline D_FLUSH;
        if((tmpfd = rexec(&tmphostname,inetport->s_port,login,password,
						tmpcommandline,0)) < 0)
        {
            errexit("Could not rexec: rexec to client %s, cmdline %s failed\n",
		    clienthostname[cnt],tmpcommandline);
        }
#endif
        if(read(tmpfd,buffer,OKSTRLEN) != OKSTRLEN)
        {
            /*
             * ERROR ON CLIENT.
             */
#ifdef USE_RCMD
            errexit("rcmd to client %s, cmdline %s received error\n",
#else
            errexit("rexec to client %s, cmdline %s received error\n",
#endif
		    clienthostname[cnt],tmpcommandline);
        }
        cnt++;
    }
    fprintf(stdout,"\n");

    /* NOW WE NEED TO HANDLE THE OUTPUT FROM THE REXEC.
     * TO DO THIS, WE FORK, THEN HAVE ONE PROCESS READ FROM TMPFD.
     * THE OTHER PROCESS CONTINUES WITH THE PROGRAM
     */
    D_PRINTF "Forking webclient stderr/stdout process\n" D_FLUSH;
    switch (fork()) 
      { 
      case -1:   /* ERROR */
        errexit("fork: %s\n", strerror(errno));
      case 0:    /* CHILD */
	exit(echo_client(tmpfd)); 
      default:   /* PARENT */
	break;
      } 
 
    /*
     * NOW WE NEED TO ACCEPT ALL THE CONNECTIONS FROM THE CLIENTS,
     * ACCEPT ALL THE READY'S, AND THEN SEND A GO TO EACH.
     */

    FD_ZERO(&fdset);
    FD_ZERO(&zerofdset);
    cnt = totalnumclients;
    D_PRINTF "Beginning accept loop\n" D_FLUSH;
    while(cnt > 0)
    {
	D_PRINTF "(%d",cnt D_FLUSH;

        if(((socknum[cnt-1] = accept(sock,NULL,0))) < 0) /* || errno) */
        {
            /*
             * ERROR accepting FROM THE CLIENTS. WE NEED TO ISSUE AN
             * ABORT TO ALL.
             */
            abort_clients();
            errexit("Error accepting from one of the clients");
        } else
        {
            /*
             * SET THE FD IN THE MASK
             */
            FD_SET(socknum[cnt-1],&fdset); 
        }
	D_PRINTF ",%d) ",socknum[cnt-1] D_FLUSH;

        cnt--;
    }
    D_PRINTF "\n" D_FLUSH;

    /*
     * WAIT FOR A READY.
     */
#ifdef NAP
	fprintf(stdout, "Waiting %d\n", 3 * totalnumclients);
	fflush(stdout);
	nap(3 * totalnumclients);
#else
    sleep(1);
#endif
	fprintf(stdout,"Waiting for READY from %d clients\n",totalnumclients);
    fflush(stdout);
    leftfdset = fdset;

    while(memcmp(&leftfdset,&zerofdset,sizeof(fd_set)))
    {
      tmpfdset = leftfdset;

        if(select(FD_SETSIZE,&tmpfdset,NULL,NULL,NULL) < 0)
        {
            /*
             * ERROR SELECTING. ABORT ALL.
             */
            abort_clients();
            errexit("Error accepting from one of the clients: %d, %s\n",
		errno, strerror(errno));
            break;
        }

        for(cnt = 0; cnt < totalnumclients; cnt++)
        {
            /*
             * SEE WHICH SOCKETS HAVE A INPUT ON THEM PENDING
             * AND RECEIVE IT.
             */
            if((socknum[cnt] != -1) && (FD_ISSET(socknum[cnt],&tmpfdset)))
            {
                /*
                 * GET THE READY FROM THIS GUY. 
                 * DON'T FORGET TO CLEAR HIS BIT IN THE tmpfdset
                 */
                if((len = read(socknum[cnt],buffer,READYSTRLEN)) != READYSTRLEN)
                {
                     abort_clients();
                     errexit("Error reading from one of the clients\n");
                }
                if(memcmp(buffer,READYSTR,READYSTRLEN))
	        {
                     abort_clients();
                     fprintf(stdout,"Received bad READY string: len %d, value %s\n",
						len,buffer);
                }
                FD_CLR(socknum[cnt],&leftfdset);
            }
        }
        /* tmpfdset = leftfdset; */
    }
#ifdef NAP
	nap(10);
#else
    sleep(1);
#endif
    fprintf(stdout,"All READYs received\n");
    fflush(stdout);

    /*
     * START ALL OF THE CLIENTS BY SENDING THEM A GO SIGNAL.
     */
    fprintf(stdout,"Sending GO to all clients\n");
    for(cnt = 0; cnt < totalnumclients; cnt++)
    {
        if(socknum[cnt] > 0)
        {
            /*
             * SEND A GO 
             */
            if(write(socknum[cnt],"GO",2) != 2)
            {
                abort_clients();
                errexit("Error sending GO to client %d\n", cnt);
            }
        }
    }

    /*
     * WAIT FOR ALL OF THE CLIENTS TO COMPLETE.  WE SHOULD GET A REPLY
     * FOR EACH SOCKET WE HAVE OPEN.  THE REPLY WILL BE THE TIMING
     * INFORMATION WE USE.
     */

    starttime = time(NULL);
    timestr = asctime(localtime(&starttime));
    fprintf(stdout,"All clients started at %s\n",timestr);
    fprintf(stdout,"Waiting for clients completion\n");
    fflush(stdout);

    /* IF THIS IS A TIMED TEST, WE MIGHT AS WELL SNOOZE */
    if (testtime) {
      sleep(testtime * 60);
    }

    /* DOESN'T ACTUALLY PRINT UNTIL THE FIRST CLIENT REPORTS */
    fprintf(stdout,"Reading results ");

    /* 
    * COPY THE FILE DESCRIPTORS TO A TMP LIST,
    * PLUS A LIST OF REMAINING FDs
    */
    leftfdset = fdset;

    /* 
     * LOOP UNTIL ALL CLIENTS HAVE REPORTED
     * AND tmpfdset IS EMPTY
     */
    while(memcmp(&leftfdset,&zerofdset,sizeof(fd_set)))
    {
      tmpfdset = leftfdset;
#ifdef NAP
      nap(10);
#else
      sleep(1);
#endif
      returnval = select(FD_SETSIZE, &tmpfdset, 
			 (fd_set *)NULL, (fd_set *)NULL, 
			 (struct timeval *)NULL);
      D_PRINTF "Call to select returned %d, errno %d\n",
	returnval, errno D_FLUSH;
      
      if(returnval < 0)
        {
	  /*
	   * ERROR SELECTING. ABORT ALL.
	   */
	  D_PRINTF "select() error %d: %s\n", errno, strerror(errno) D_FLUSH;
	  abort_clients();
	  errexit("Error %d selecting from one of the clients: %s\n",
		  errno, strerror(errno));
	  break;
        }
      else if (returnval > 0)
	{
	  for(cnt = 0; cnt < totalnumclients; cnt++)
	    {
	      /*
	       * SEE WHICH SOCKETS HAVE A INPUT ON THEM PENDING AND
	       * RECEIVE IT.  
	       */

	      /* IS THIS A VALID SOCKET? IS IT READY TO READ? */
	      if((socknum[cnt] != -1) && (FD_ISSET(socknum[cnt], &tmpfdset)))
		{
		  /*
		   * GET THE TIMING DATA FROM THIS GUY
		   * THEN REMOVE HIM FROM THE tmpfdset
		   */

		  fputc('.', stdout); /* PROGRESS MARKER */
		  fflush(stdout);

		  /* 
		   * READ TIME STATS
		   * DOES READ() RETURN THE CORRECT LENGTH? 
		   */
		  D_PRINTF "About to read timestats, count %d, errno %d\n",
		    cnt, errno D_FLUSH;
		  len = 0;
		  bytes_to_read = sizeof(stats_t);
		  rptr = &statarray[cnt];
		  while (bytes_to_read)
		    {
		      returnval = read(socknum[cnt], rptr, bytes_to_read);
		      D_PRINTF "Read %d of %d bytes\n", returnval, 
			    sizeof(stats_t) D_FLUSH;
		      if (returnval <= 0)
			{
			  abort_clients();
			  errexit("Error %d: %s %s %d %s %d\n",
				      errno, strerror(errno),
				      "\n1st reading timing info: web child ", 
				      cnt, "did not respond.\nBytes read: ", returnval); 
			}
		      len += returnval;
		      rptr += returnval;
		      bytes_to_read -= returnval;
		    }
/*
		  if(len != sizeof(stats_t))
		    {
		      abort_clients();
		      errexit("Error %d: %s %s %d %s %d\n",
			      errno, strerror(errno),
			      "\n1st reading timing info: web child ", 
			      cnt, "did not respond.\nBytes read: ", len); 
		    }
*/
		  if(uil_filelist_f) /* READ PAGE STATS */
		    {
		      /* sleep(2); */
		      D_PRINTF "About to read pagestats, count %d, errno %d\n",
			cnt, errno D_FLUSH;
		      
		      /* DOES READ() RETURN THE CORRECT LENGTH? */
		      len = 0;
		      bytes_to_read = sizeof(page_stats_t) * MAXNUMOFPAGES;
		      rptr = &page_stats[cnt];
		      while (bytes_to_read) {
			returnval = read(socknum[cnt],rptr, bytes_to_read);
			if (returnval <= 0) 
			  {
			    abort_clients();
			    D_PRINTF "Child %d: Read %d bytes, expected %d\n",
			      cnt, len, (sizeof(page_stats_t)*MAXNUMOFPAGES) 
			      D_FLUSH;

			    errexit("Error %d: %s %s %d %s %d\n",
				    errno, strerror(errno), 
				    "\n2nd reading timing info: web child ",
				    cnt, "did not respond.\nBytes read: ", 
				    len);
			  }
			else
			  {
			    len += returnval;
			    rptr += returnval;
			    bytes_to_read -= returnval;
			  }
			D_PRINTF "Read %d bytes, total %d\n", returnval,
			  len D_FLUSH;
#ifdef NAP
            nap(10);
#else
			sleep(1);
#endif
		      }

		      if ( len != (sizeof(page_stats_t)*MAXNUMOFPAGES) )
			{
			  abort_clients();
			  D_PRINTF "Child %d: Read %d bytes, expected %d\n",
			    cnt, len, (sizeof(page_stats_t)*MAXNUMOFPAGES) 
			    D_FLUSH;

			  errexit("Error %d: %s %s %d %s %d\n",
				  errno, strerror(errno), 
				  "\n2nd reading timing info: web child ",
				  cnt, "did not respond.\nBytes read: ", len);
		      
			} /* end if CORRECT LENGTH */
		    } /* end if filelist */
		
		  /* CLEAR FROM LIST OF SOCKETS LEFT TO READ */
		  FD_CLR(socknum[cnt], &leftfdset);
		  
		} /* end if socknum */
	    } /* end for cnt */
	} /* end if/else returnval */

      /* SET TMP EQUAL TO LIST OF SOCKETS LEFT TO READ */
      /* tmpfdset = leftfdset; */
      
    } /* end while memcmp fd */

    /*
     * DONE READING RESULTS FROM CLIENTS
     */

    endtime = time(NULL);
    timestr = asctime(localtime(&endtime));
    fprintf(stdout,"\nAll clients ended at %s\n",timestr);
    fflush(stdout);
 
    /*
     * PRINT EVERYTHING OUT
     */
    stats_init(&masterstat);
    for(cnt = 0; cnt < totalnumclients; cnt++)
    {
      /* GOOD TIME TO CLOSE THE SOCKETS */

     D_PRINTF "Closing socket (%d,%d)\n",cnt,socknum[cnt] D_FLUSH;

      close(socknum[cnt-1]);

        if((statarray[cnt].rs.totalconnects > 0) && (dumpall))
        {
            fprintf(stdout,"----------------------------------\n");
            fprintf(stdout,"Test for host: %s\n",statarray[cnt].hostname);
            fprintf(stdout,"Total number of pages retrieved from server: %u\n", 
				statarray[cnt].totalpages);
	    
	    rqstat_fprint(stdout, &(statarray[cnt].rs));

    	    thruput = thruputpersec((unsigned int)(statarray[cnt].rs.totalbytes),
			&(statarray[cnt].rs.totalresponsetime));
	
    	    fprintf(stdout, "Thruput average per connection: %.0f bytes/sec\n",
			thruput);
        }
        if(statarray[cnt].rs.totalconnects > 0)
        {          
          /*   masterstat.totalpages += statarray[cnt].totalpages; */
            rqstat_sum(&masterstat.rs, &(statarray[cnt].rs));
        }
    }

    for (i=0; i < totalnumclients; i++)
    {
	for (j=0; j < MAXNUMOFPAGES; j++)
	{
	    if (statarray[i].page_numbers[j] != 0)
	    {
		rqst_stats_t *pst_rs;
		rqst_stats_t *ps_rs;

		pst_rs = &(page_stats_total[j].rs);
		ps_rs =  &(page_stats[i][j].rs);

		rqstat_sum(pst_rs, ps_rs);

		page_stats_total[j].totalpages += page_stats[i][j].totalpages;

		/* yes, this is assignement, not sum */
		page_stats_total[j].page_size = page_stats[i][j].page_size;


	        masterstat.totalpages += page_stats[i][j].totalpages;
	        page_stats_total[j].page_valid = 1;
	    }
	}
    } 
   
    for (i = 0; i < MAXNUMOFPAGES; i++)
    {
	if (page_stats_total[i].page_valid == 1)
	{
	    page_stats_t *pst;

	    pst = &(page_stats_total[i]);

	    printf ("===============================================================================\n");
	    printf ("Page # %d\n", i);
	    printf ("Total number of times page was hit %u\n",
			pst->totalpages); 

            rqstat_print(&(pst->rs));

	    printf ("Page size %u \n",
			pst->page_size);
	    printf ("===============================================================================\n\n"); 
	}
    }
    

    fprintf(stdout,"==================================\n");

    /*
    ** Validate run.
    */
    masterstat.total_num_of_files = statarray[0].total_num_of_files;
    for (i=1; i < totalnumclients; i++)
    {
        if ((statarray[i].rs.totalconnects > 0) &&
	    (statarray[i].total_num_of_files != masterstat.total_num_of_files))
	{
	    fprintf(stdout,"**********************************************************************\n");
	    fprintf(stdout,"**** ERROR: number of files in each test configuration is not the same\n");
	    fprintf(stdout,"**** ERROR: Check configuration file %s on each client\n", configfile);
	    fprintf(stdout,"**********************************************************************\n");
	    break;
	}
    }


    /*
    ** Print summary statistics
    */
    fprintf(stdout, "WEBSTONE 1.1 results:\n");
       /* number: %d pages/minute\n",
       masterstat.totalpages/testtime); */

    fprintf(stdout, "Total number of clients: %d\n", totalnumclients);

    if (testtime) 
      { 
	fprintf(stdout, "Connection rate average: %3.2f conn/s\n",
		(double)(masterstat.rs.totalconnects)/(60*testtime));
      

	fprintf(stdout, "Little's Load Factor: %3.2f \n", 
		(double)(masterstat.rs.totalresponsetime.tv_sec)
		/(60*testtime));
      }

    avgtime(&masterstat.rs.totalresponsetime,
		      masterstat.rs.totalconnects, &dtime);

    /*fprintf(stdout, "Average Latency: %4d.%4d sec\n", 
	dtime.tv_sec, dtime.tv_usec); */

    fprintf(stdout, "Average Latency: %4.4f sec\n",
	(double)(dtime.tv_sec + (double)dtime.tv_usec / 1000000));

    fprintf(stdout, "Error Rate: %4.4f err/s\n",
	    (double)(masterstat.rs.totalerrs)/(60*testtime));

    fprintf(stdout, "Thruput average for all connections: %2.2f Mbit/s\n",
	    (double)(8*masterstat.rs.totalbytes)/(60*testtime*1024*1024));

    /* so much for the key metrics */

    thruput = thruputpersec((unsigned int)(masterstat.rs.totalbytes),
			&(masterstat.rs.totalresponsetime))*(8);
	
    fprintf(stdout, "Thruput average per connection: %6.0f bit/s\n",
			thruput);

    fprintf(stdout,"Test time: %d minutes\n", testtime);

    fprintf(stdout,"Total cumulative time of test for all hosts (sec): %u.%u\n", 
	    masterstat.rs.totalresponsetime.tv_sec,
	    masterstat.rs.totalresponsetime.tv_usec);

    fprintf(stdout,"Total number of pages retrieved from server: %u\n", 
				masterstat.totalpages);
   
    /* Remaining stats are the same as usual */

    rqstat_fprint(stdout, &(masterstat.rs));
       
    fflush(stdout);

    exit(0);
}
