/**************************************************************************
 *									  *
 * 		 Copyright (C) 1995 Silicon Graphics, Inc.		  *
 *									  *
 *  These coded instructions, statements, and computer programs  where	  *
 *  deveolped by SGI for public use.  If anychanges are made to this code *
 *  please try to get the changes back to the author.  Feel free to make  *
 *  modfications and changes to the code and release it.		  *
 *									  *
 **************************************************************************/
#include <math.h>

#include "statistics.h"
#include "sysdep.h"

double
mean(const double sum, const int n)
{
  if (n)
    {
      return(sum / n);
    }
  else
    {
      return(0);
    }
}

double
variance(const double sum, const double sumofsquares, const int n)
{
	double	meanofsum;

	meanofsum = mean(sum, n);

	return(mean(sumofsquares,n) - (meanofsum * meanofsum));
}

double
stddev(const double sum, const double sumofsquares, const int n)
{
	return(sqrt(fabs(variance(sum, sumofsquares, n))));
}

#
