/**************************************************************************
 *									  *
 * 		 Copyright (C) 1995 Silicon Graphics, Inc.		  *
 *									  *
 *  These coded instructions, statements, and computer programs  where	  *
 *  deveolped by SGI for public use.  If anychanges are made to this code *
 *  please try to get the changes back to the author.  Feel free to make  *
 *  modfications and changes to the code and release it.		  *
 *									  *
 **************************************************************************/
 
/* THIS IS WHERE WE GO OUT AND FETCH A URL */

#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/errno.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <netinet/in.h>
#include <netdb.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#ifdef SUNOS
#include <unistd.h>
#endif

#include "bench.h"
#include "get.h"
#include "debug.h"
#include "sysdep.h"

#define KEEPALIVE_HEADER "Connection: Keep-Alive\r\n"
#define ACCEPT_COMMAND "Accept: */* HTTP/1.0\r\n"
#define ACCEPT_COMMAND_LEN 24
#define MAXCOMMANDLEN 256
#define READBUFSIZ (30*1024)

extern int	keepalive;
extern int	savefile;
extern int	debug;
extern int	timeexpired;
extern char *   upper_case(char *);
extern FILE *   debugfile;

int
get(char *loc, int port, char *url, rqst_timer_t *timer, int reuse_conn)
{
    int		bytestoread = 0;
    int 	numbytesread = 0;
    int		totalbytesread = 0;
    int		lengthleft = 0;
    int		writelen = 0;
    int		bodylength = 0;
    int		lengthstrsz = 0;
    int 	outputfile = -1;
    int		firstline;
    int		status;
    int 	index;
    int		search_index;
    int 	endofheader;
    char	getcommand[MAXCOMMANDLEN];
    char	acceptcommand[ACCEPT_COMMAND_LEN];
    char	headerbuffer[READBUFSIZ];
    char 	readbuffer[READBUFSIZ];
    char	outputfilename[MAXPATHLEN];

    static int	sock = -1;

    if(gettimeofday(&timer->entertime, NULL) != 0)
    {
       return(returnerr("Error retrieving entertime\n"));
    }
    timer->valid = 1;

    /* combined get & accept is faster */
    sprintf(getcommand, "%s%s%s%s%s\r\n",
				"GET ",
				url,
				" HTTP/1.0\r\n",
				reuse_conn ? KEEPALIVE_HEADER : "",
				ACCEPT_COMMAND );

    if(gettimeofday(&timer->beforeconnect, NULL) != 0)
    {
	return(returnerr("Error retrieving beforeconnect\n"));
    }

    if (sock < 0)
    {
	sock = connectsock(loc,port,"tcp");
	if (sock < 0)
	{
	    D_PRINTF "Call to connectsock returned %d, %d: %s\n", 
	       sock, errno, strerror(errno) D_FLUSH;
	    if (timeexpired) { return(-1); }
	    return(returnerr("Couldn't connect to WWW server: %s\n",
			strerror(errno)));
	}
    }

    if(gettimeofday(&timer->afterconnect, NULL) != 0)
    {
       return(returnerr("Error retrieving afterconnect\n"));
    }

    /*
     * SEND THE GET/ACCEPT COMBO
     */
D_PRINTF "Sending request: %s\n", getcommand D_FLUSH;
    writelen = strlen(getcommand);
    status = write(sock,getcommand,writelen);
    if(status != writelen)
    {
      close(sock);
      sock = -1;
      return(returnerr("Error sending command line to server: %s\n",
		strerror(errno)));
    }

    /* 
     * WE HAVE NOW SENT THE REQUEST SUCCESSFULLY.  
     * WAIT FOR THE REPLY AND FIND THE HEADER 
     */
    if(gettimeofday(&timer->beforeheader, NULL) != 0)
    {
       return(returnerr("Error retrieving beforeheader\n"));
    }
    totalbytesread = 0;
    firstline = 1;
    endofheader = 0;
    while(endofheader == 0)
    {
        index = 0;
        numbytesread=read(sock,headerbuffer,READBUFSIZ);
        totalbytesread += numbytesread;

        if(numbytesread <= 0)
        {
	    D_PRINTF "Did not receive full header\n" D_FLUSH;
            D_PRINTF "Value received from last read call is %d, errno %d: %s\n",
	      numbytesread, errno, strerror(errno) D_FLUSH;
	    if (timeexpired) { return(-1); }
	    return(returnerr("Did not receive full header: %s\n", 
		strerror(errno)));
        }

	while(index < numbytesread)
        {
            if((firstline) 
		    ||
	       (headerbuffer[index] == '\n')) 
			   
            {
	        firstline = 0;
    
                /*
                 * CHECK FOR THE CONTENT LENGTH AT THE START OF THE NEXT LINE.
                 */
	        if((headerbuffer[index+1] == 'C') 
				|| (headerbuffer[index+1] == 'c'))
	        {
		    /*
		     *  CONVERT TO UPPER CASE SO THERE IS NO CONFUSION.
		     */
		    upper_case(&headerbuffer[index+1]);
	            if(!memcmp(&headerbuffer[index+1],LENGTH_STRING,
							    LENGTH_STRING_SIZ))
	            {
                        /*
                         * WE HAVE A MATCH ON THE CONTENT LENGTH. SNAG IT.
                         */
                        lengthstrsz = LENGTH_STRING_SIZ;
	                sscanf(&headerbuffer[index+1+LENGTH_STRING_SIZ],
							"%d",&bodylength);

	                D_PRINTF "Content-Length: %d\n",bodylength D_FLUSH;
                    }
	        } else
	        {
                    /*
                     * CHECK FOR ANOTHER /r/n IMMEDIATELY AFTER THE PREVIOUS
                     */
                    if ((headerbuffer[index+1] == '\r')
			    &&
                       (headerbuffer[index+2] == '\n'))
		      
                    {
                       /*
                        * WE ARE AT THE END OF THE HEADER.  MARK IT BY
                        * SETTING THE INDEX TO THE START OF THE DATA.
	                * BREAK OUT OF THE WHILE LOOP THAT IS CHECKING
	                * THE HEADER.
                        */
                        index += 3;
                        endofheader = 1;
	                break;
                    } /*if CRLF*/
		    
		    else if ((headerbuffer[index] == '\n')
				     &&
			    (headerbuffer[index+1] == '\n'))
		    {
			/*
                        * WE ARE AT THE END OF THE HEADER.  MARK IT BY
                        * SETTING THE INDEX TO THE START OF THE DATA.
	                * BREAK OUT OF THE WHILE LOOP THAT IS CHECKING
	                * THE HEADER.  REMEBER NCSA USINGS A DIFFERENT
			* PROTOCOL. YUK!!
                        */
                        index += 2;
                        endofheader = 1;
	                break;
		    }
	        } /*else-if Content-Line*/
            } /*if firstline or CRLF*/

            index++;

        } /*while(index < numbytesread)*/
    } 

    if(gettimeofday(&timer->afterheader, NULL) != 0)
    {
       return(returnerr("Error retrieving afterheader\n"));
    }

    D_PRINTF "header content is %s\n", headerbuffer D_FLUSH; 
    D_PRINTF "bodylength = %d\n", bodylength D_FLUSH; 

    if(savefile)
    {
        sprintf(outputfilename,"/tmp/webstone.data.%d",getpid());
        if((outputfile = open(outputfilename,(O_WRONLY|O_CREAT),0777)) < 0)
        {
            D_PRINTF "outputfile %d %d\n", outputfile, errno D_FLUSH; 
            return(returnerr("Error saving file: &s",strerror(errno)));
        }
	lseek(outputfile,1,SEEK_END);
    }

    if((outputfile >= 0) && (index < numbytesread))
    {
       /*
        * DUMP THE REMAINING DATA IN THE CURRENT BUFFER.
        */
       write(outputfile,&headerbuffer[index],numbytesread-index);
    }

    /* read the body of the page */
    if (index < numbytesread)
    {
	lengthleft = bodylength - numbytesread + index;
	D_PRINTF "Already have %d bytes of body in what we've read, need to get %d more\n", numbytesread-index, lengthleft D_FLUSH;
    }
    else
    {
	D_PRINTF "No body data in what we've got so far; numbytesread is %d and index is %d\n", numbytesread, index D_FLUSH;
	lengthleft = bodylength;
    }

    while (lengthleft)
    {
        numbytesread=read(sock,readbuffer,READBUFSIZ);
        totalbytesread += numbytesread;
	lengthleft -= numbytesread;
    /*    D_PRINTF "Read %d bytes: %s\n", numbytesread, readbuffer D_FLUSH;
     */
	D_PRINTF "Read %d bytes\n", numbytesread D_FLUSH;
        if (numbytesread < 0)
	  {
	    D_PRINTF "Read returns %d, error %d: %s\n", numbytesread,
	      errno, strerror(errno) D_FLUSH;
	    return(returnerr("Read returns %d, error %d: %s\n", numbytesread,
			     errno, strerror(errno)));
	  }
	else if (numbytesread == 0)
	    break;
        if(outputfile != -1)
	  {
	    write(outputfile,readbuffer,numbytesread);
	  }
    }
    
    if ( bodylength && (totalbytesread - index != bodylength))
      {
	D_PRINTF "Warning: end of file exceeded with %d\n",
	  numbytesread D_FLUSH;
      }
    
    bodylength = totalbytesread - index;
    /* done with the body */

    if(gettimeofday(&timer->afterbody, NULL) != 0)
    {
       return(returnerr("Error retrieving afterbody\n"));
    }

    if(outputfile != -1)
    {
        close(outputfile);
    }

    if (!(reuse_conn && strstr(headerbuffer, "CONNECTION: KEep-Alive")))
    {
	D_PRINTF "Closing connection\n" D_FLUSH;
	close(sock);
	sock = -1;
    }

    D_PRINTF "Read %d bytes, %d of that being body\n",
      totalbytesread, bodylength D_FLUSH;

    if(gettimeofday(&timer->exittime, NULL) != 0)
    {
       D_PRINTF "Error retrieving exit time: %s\n", strerror(errno) D_FLUSH;
       return(returnerr("Error retrieving exit time\n"));
    }
    timer->valid = 2;
    timer->totalbytes = totalbytesread;
    timer->bodybytes = bodylength;

    D_PRINTF "get returning totalbytes %d body %d valid %d\n", 
	timer->totalbytes, timer->bodybytes, timer->valid D_FLUSH;

    D_PRINTF "get returning start %d, end %d\n", 
	timer->entertime.tv_sec, timer->exittime.tv_sec,
	timer->valid D_FLUSH; 
    D_PRINTF "get returning connect %d, request %d, header %d, body %d\n",
	timer->afterconnect.tv_sec, timer->beforeheader.tv_sec, 
	timer->afterheader.tv_sec, timer->afterbody.tv_sec D_FLUSH;

    return(0);
}  
