/**************************************************************************
 *									  *
 * 		 Copyright (C) 1995 Silicon Graphics, Inc.		  *
 *									  *
 *  These coded instructions, statements, and computer programs  where	  *
 *  deveolped by SGI for public use.  If anychanges are made to this code *
 *  please try to get the changes back to the author.  Feel free to make  *
 *  modfications and changes to the code and release it.		  *
 *									  *
 **************************************************************************/

/* errexit call for general error handling */

#include <varargs.h>
#include <stdio.h>

#include "debug.h"
#include "sysdep.h"

/* print an error message and exit */
int
errexit(format, va_alist)
#ifdef __bsdi__
const char *format;
#else
char	*format;
#endif
va_dcl
{
	va_list args;
	va_start(args);
#ifdef __bsdi__
	vfprintf(stderr, format, args);
#else
	_doprnt(format, args, stderr);
#endif
	va_end(args);
	exit(1);
}
/* that's it */

/* print an error message and return -1 */
int
returnerr(format, va_alist)
#ifdef __bsdi__
const char *format;
#else
char    *format;
#endif
va_dcl
{
        va_list args;
        va_start(args);
#ifdef __bsdi__
	vfprintf(stderr, format, args);
#else
        _doprnt(format, args, stderr);
#endif
        va_end(args);
        return(-1);
}
/* that's it */


