#ifndef __BENCH_H__ 
#define __BENCH_H__
/**************************************************************************
 *									  *
 * 		 Copyright (C) 1995 Silicon Graphics, Inc.		  *
 *									  *
 *  These coded instructions, statements, and computer programs  where	  *
 *  deveolped by SGI for public use.  If anychanges are made to this code *
 *  please try to get the changes back to the author.  Feel free to make  *
 *  modfications and changes to the code and release it.		  *
 *									  *
 **************************************************************************/

#include <sys/time.h>

#define USECINSEC 1000000
#define MSECINSEC 1000
#define LENGTH_STRING "CONTENT-LENGTH:"
#define LENGTH_STRING_SIZ sizeof(LENGTH_STRING)-1
#define OKSTR "OK"
#define OKSTRLEN 2
#define GOSTR "GO"
#define GOSTRLEN 2
#define READYSTR "READY"
#define READYSTRLEN 5
#define ABORTSTR "ABORT"
#define ABORTSTRLEN 5
#define FILENAME_SIZE 1024
#define MAXNUMOFFILES 50
#define MAXNUMOFPAGES 100
#define MAXPERCENT_RANGE  100

typedef struct rqst_timer {
    struct timeval	entertime;
    struct timeval	beforeconnect;
    struct timeval	afterconnect;
    struct timeval	beforeheader;
    struct timeval	afterheader;
    struct timeval	afterbody;
    struct timeval	exittime;
    long unsigned int	totalbytes;
    long unsigned int	bodybytes;
    int			valid;
    long unsigned int 	page_number;
} rqst_timer_t;

extern void rqtimer_init(rqst_timer_t *);

typedef struct rqst_stats {
    struct timeval      totalresponsetime;
    double		totalresponsetimesq;
    struct timeval      minresponsetime;
    struct timeval      maxresponsetime;
    struct timeval      totalconnecttime;
    double		totalconnecttimesq;
    struct timeval      minconnecttime;
    struct timeval      maxconnecttime;
    long unsigned int  	totalconnects;
    long unsigned int  	totalerrs;
    double        	totalbytes;
    double        	totalbytessq;
    double        	minbytes;
    double        	maxbytes;
    double       	totalbody;
    double       	totalbodysq;
    double        	minbody;
    double        	maxbody;
} rqst_stats_t;

extern void rqstat_init(rqst_stats_t *);
extern void rqstat_sum(rqst_stats_t *, rqst_stats_t *);
extern void rqstat_print(rqst_stats_t *);
extern void rqstat_fprint(FILE *, rqst_stats_t *);


typedef struct stats {
    char        	hostname[MAXHOSTNAMELEN];
    rqst_stats_t	rs;
    struct timeval      starttime;
    struct timeval      endtime;
    struct timeval	datatime;
    long unsigned int	totalpages;
    long unsigned int	total_num_of_files;
    long unsigned int	page_numbers[MAXNUMOFPAGES];
} stats_t;

extern void stats_init(stats_t *);

typedef struct page_stats {
    rqst_stats_t	rs; 
    long unsigned int	totalpages;
    long unsigned int	page_size;
    int			page_valid;
} page_stats_t;

extern void page_stats_init(page_stats_t *);


/* THIS STRUCTURE DEFINES A PAGE. */
typedef struct file_list {
    int 		load_num;
    int 		num_of_files;
    char 		*filename[MAXNUMOFFILES];
}file_list_t;

#endif /* !__BENCH_H__ */
