/**************************************************************************
 *									  *
 * 		 Copyright (C) 1995 Silicon Graphics, Inc.		  *
 *									  *
 *  These coded instructions, statements, and computer programs  where	  *
 *  deveolped by SGI for public use.  If anychanges are made to this code *
 *  please try to get the changes back to the author.  Feel free to make  *
 *  modfications and changes to the code and release it.		  *
 *									  *
 **************************************************************************/

#include <stdio.h>
#include <math.h>
#include <limits.h>
#include <float.h>
#include <sys/time.h>
#include <sys/param.h>
#ifdef SOLARIS
#include <netdb.h>
#endif

#include "bench.h"
#include "statistics.h"
#include "timefunc.h"
#include "debug.h"
#include "sysdep.h"

extern int     debug;

extern FILE    *debugfile;

void
rqtimer_init(rqst_timer_t *p) {
    memset(p, 0, sizeof(*p));
}

void
rqstat_init(rqst_stats_t *p) {
    memset(p, 0, sizeof(*p));

    p->minbytes = DBL_MAX;
    p->minbody  = DBL_MAX;
    p->minconnecttime.tv_sec = LONG_MAX;
    p->minconnecttime.tv_usec = LONG_MAX;
    p->minresponsetime.tv_sec = LONG_MAX;
    p->minresponsetime.tv_usec = LONG_MAX;
}

void
stats_init(stats_t *p) {
    memset(p, 0, sizeof(*p));

    p->rs.minbytes = DBL_MAX;
    p->rs.minbody  = DBL_MAX;
    p->rs.minconnecttime.tv_sec = LONG_MAX;
    p->rs.minconnecttime.tv_usec = LONG_MAX;
    p->rs.minresponsetime.tv_sec = LONG_MAX;
    p->rs.minresponsetime.tv_usec = LONG_MAX;
}

void
page_stats_init(page_stats_t *p) {
    memset(p, 0, sizeof(*p));

    p->rs.minbytes = 0; /* DBL_MAX; */
    p->rs.minbody  = 0; /* DBL_MAX; */
    p->rs.minconnecttime.tv_sec = 0; /* LONG_MAX; */
    p->rs.minconnecttime.tv_usec = 0; /* LONG_MAX; */
    p->rs.minresponsetime.tv_sec = 0; /* LONG_MAX; */
    p->rs.minresponsetime.tv_usec = 0; /* LONG_MAX; */
}

void
rqstat_times(rqst_stats_t *rs, rqst_timer_t *rt)
{
  /*    struct timeval      dtime; */
  double		t;

    compdifftime(&(rt->exittime), &(rt->entertime),
						 &(rs->totalresponsetime));
    t = timevaldouble(&(rs->totalresponsetime));
    rs->totalresponsetimesq = t * t;

    rs->minresponsetime = rs->totalresponsetime;
    rs->maxresponsetime = rs->totalresponsetime;

    compdifftime(&(rt->afterconnect), &(rt->beforeconnect),
						 &(rs->totalconnecttime));

    t = timevaldouble(&(rs->totalconnecttime));
    rs->totalconnecttimesq = t * t;

    rs->minconnecttime = rs->totalconnecttime;
    rs->maxconnecttime = rs->totalconnecttime;

    rs->totalbody =   rt->bodybytes;
    rs->totalbodysq = ((double)(rt->bodybytes)) * ((double)(rt->bodybytes));
    rs->minbody =     rt->bodybytes;
    rs->maxbody =     rt->bodybytes;

    rs->totalbytes =   rt->totalbytes;
    rs->totalbytessq = ((double)(rt->totalbytes)) * ((double)(rt->totalbytes));
    rs->minbytes =     rt->totalbytes;
    rs->maxbytes =     rt->totalbytes;

    rs->totalconnects = 1;
    rs->totalerrs = 0;
}

#define min(a,b) (((a) < (b)) ? a : b)
#define max(a,b) (((a) > (b)) ? a : b)

void
rqstat_sum(rqst_stats_t *sum, rqst_stats_t *incr)
{
    addtime( &(sum->totalresponsetime),   &(incr->totalresponsetime));
    mintime( &(sum->minresponsetime),     &(incr->minresponsetime));
    maxtime( &(sum->maxresponsetime),     &(incr->maxresponsetime));
    sum->totalresponsetimesq += incr->totalresponsetimesq;

    addtime( &(sum->totalconnecttime),    &(incr->totalconnecttime));
    mintime( &(sum->minconnecttime),      &(incr->minconnecttime));
    maxtime( &(sum->maxconnecttime),      &(incr->maxconnecttime));
    sum->totalconnecttimesq += incr->totalconnecttimesq;

    sum->totalconnects += incr->totalconnects;
    sum->totalerrs     += incr->totalerrs;

    D_PRINTF "Old totalbytes\t %9.0lf + %9.0lf = ",
        sum->totalbytes, incr->totalbytes D_FLUSH;

    sum->totalbytes    += incr->totalbytes;

    D_PRINTF "New totalbytes sum\t %9.0lf\n", sum->totalbytes D_FLUSH;

    sum->totalbytessq  += incr->totalbytessq;
    sum->minbytes      =  min(sum->minbytes, incr->minbytes);
    sum->maxbytes      =  max(sum->maxbytes, incr->maxbytes);

    D_PRINTF "Old totalbody\t %9.0lf + %9.0lf = ",
        sum->totalbody, incr->totalbody D_FLUSH;

    sum->totalbody     += incr->totalbody;

    D_PRINTF "New totalbody sum\t %9.0lf\n", sum->totalbody D_FLUSH;

    sum->totalbodysq   += incr->totalbodysq;
    sum->minbody       =  min(sum->minbody, incr->minbody);
    sum->maxbody       =  max(sum->maxbody, incr->maxbody);

}


void
rqstat_print(rqst_stats_t *stats)
{
	rqstat_fprint(stdout, stats);
}


void
rqstat_fprint(FILE *f, rqst_stats_t *stats)
{
    struct timeval dtime;
    int value;
    double result;

    fprintf(f,"Total number of errors to server: %d\n", 
	    stats->totalerrs);

    fprintf(f,"Total number of connections to server: %d\n", 
	    stats->totalconnects);

    avgtime(&(stats->totalconnecttime), 
				stats->totalconnects, &dtime);

    fprintf(f,"Time to connect mean:     %3d.%6.6d seconds\n", 
				dtime.tv_sec,
				dtime.tv_usec);

    variancetime(&(stats->totalconnecttime),
				stats->totalconnecttimesq,
				stats->totalconnects, &dtime);

/*    fprintf(f,"Time to connect variance: %3d.%6.6d\n",
				dtime.tv_sec,
				dtime.tv_usec); */

    stddevtime(&(stats->totalconnecttime),
				stats->totalconnecttimesq,
				stats->totalconnects, &dtime);

    fprintf(f,"Time to connect std.dev.: %3d.%6.6d seconds\n",
				dtime.tv_sec,
				dtime.tv_usec);

    fprintf(f,"Time to connect minimum:  %3d.%6.6d seconds\n",
				stats->minconnecttime.tv_sec,
				stats->minconnecttime.tv_usec);

    fprintf(f,"Time to connect maximum:  %3d.%6.6d seconds\n",
				stats->maxconnecttime.tv_sec,
				stats->maxconnecttime.tv_usec);


    avgtime(&(stats->totalresponsetime), 
				stats->totalconnects, &dtime);

    fprintf(f,"Time to complete response mean:     %3d.%6.6d seconds\n", 
				dtime.tv_sec,
				dtime.tv_usec);

    variancetime(&(stats->totalresponsetime),
				stats->totalresponsetimesq,
				stats->totalconnects, &dtime);

    /* fprintf(f,"Time to complete response variance: %3d.%6.6d\n",
				dtime.tv_sec,
				dtime.tv_usec); */

    stddevtime(&(stats->totalresponsetime),
				stats->totalresponsetimesq,
				stats->totalconnects, &dtime);

    fprintf(f,"Time to complete response std.dev.: %3d.%6.6d seconds\n",
				dtime.tv_sec,
				dtime.tv_usec);

    fprintf(f,"Time to complete response minimum:  %3d.%6.6d seconds\n",
				stats->minresponsetime.tv_sec,
				stats->minresponsetime.tv_usec);

    fprintf(f,"Time to complete response maximum:  %3d.%6.6d seconds\n",
				stats->maxresponsetime.tv_sec,
				stats->maxresponsetime.tv_usec);


    fprintf(f,"Total bytes body+header moved: \t%9.0lf\n",
				stats->totalbytes);

    fprintf(f,"Total bytes of body moved: \t%9.0lf\n",
				stats->totalbody);

    fprintf(f,"Total bytes of header moved: \t%9.0lf\n",
				(stats->totalbytes - stats->totalbody));


    /* if(stats->totalconnects)
       {
      value = stats->totalbytes/stats->totalconnects;
	}
      else
    {
      value = 0;
      } */

    fprintf(f,"Response size average:  %9.0lf bytes\n", 
	    mean(stats->totalbytes, stats->totalconnects));

    /* fprintf(f,"Response size variance: %9.0lf\n",
			    	variance(stats->totalbytes,
				    stats->totalbytessq,
				    stats->totalconnects)); */

    fprintf(f,"Response size std.dev.: %9.0lf bytes\n",
			    	stddev(stats->totalbytes,
				    stats->totalbytessq,
				    stats->totalconnects));

    fprintf(f,"Response size minimum:  %9.0lf bytes\n", stats->minbytes);
    fprintf(f,"Response size maximum:  %9.0lf bytes\n", stats->maxbytes);


    /* if(stats->totalconnects)
       {
       value = stats->totalbody/stats->totalconnects;
       }
       else
       {
       value = 0;
       } */

    fprintf(f,"Body size average:  %9.0lf bytes\n", 
	    mean(stats->totalbody, stats->totalconnects));

    /* fprintf(f,"Body size variance: %9.0lf\n",
			    	variance(stats->totalbody,
				    stats->totalbodysq,
				    stats->totalconnects)); */

    fprintf(f,"Body size std.dev.: %9.0lf bytes\n",
			    	stddev(stats->totalbody,
				    stats->totalbodysq,
				    stats->totalconnects));

    fprintf(f,"Body size minimum:  %9.0lf bytes\n", stats->minbody);
    fprintf(f,"Body size maximum:  %9.0lf bytes\n", stats->maxbody);
}
