/*	$NetBSD: smu_7_0_0_sh_mask.h,v 1.2 2018/08/27 04:58:22 riastradh Exp $	*/

/*
 * SMU_7_0_0 Register documentation
 *
 * Copyright (C) 2014  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef SMU_7_0_0_SH_MASK_H
#define SMU_7_0_0_SH_MASK_H

#define GCK_SMC_IND_INDEX__SMC_IND_ADDR_MASK 0xffffffff
#define GCK_SMC_IND_INDEX__SMC_IND_ADDR__SHIFT 0x0
#define GCK_SMC_IND_DATA__SMC_IND_DATA_MASK 0xffffffff
#define GCK_SMC_IND_DATA__SMC_IND_DATA__SHIFT 0x0
#define CG_DCLK_CNTL__DCLK_DIVIDER_MASK 0x7f
#define CG_DCLK_CNTL__DCLK_DIVIDER__SHIFT 0x0
#define CG_DCLK_CNTL__DCLK_DIR_CNTL_EN_MASK 0x100
#define CG_DCLK_CNTL__DCLK_DIR_CNTL_EN__SHIFT 0x8
#define CG_DCLK_CNTL__DCLK_DIR_CNTL_TOG_MASK 0x200
#define CG_DCLK_CNTL__DCLK_DIR_CNTL_TOG__SHIFT 0x9
#define CG_DCLK_CNTL__DCLK_DIR_CNTL_DIVIDER_MASK 0x1fc00
#define CG_DCLK_CNTL__DCLK_DIR_CNTL_DIVIDER__SHIFT 0xa
#define CG_DCLK_STATUS__DCLK_STATUS_MASK 0x1
#define CG_DCLK_STATUS__DCLK_STATUS__SHIFT 0x0
#define CG_DCLK_STATUS__DCLK_DIR_CNTL_DONETOG_MASK 0x2
#define CG_DCLK_STATUS__DCLK_DIR_CNTL_DONETOG__SHIFT 0x1
#define CG_VCLK_CNTL__VCLK_DIVIDER_MASK 0x7f
#define CG_VCLK_CNTL__VCLK_DIVIDER__SHIFT 0x0
#define CG_VCLK_CNTL__VCLK_DIR_CNTL_EN_MASK 0x100
#define CG_VCLK_CNTL__VCLK_DIR_CNTL_EN__SHIFT 0x8
#define CG_VCLK_CNTL__VCLK_DIR_CNTL_TOG_MASK 0x200
#define CG_VCLK_CNTL__VCLK_DIR_CNTL_TOG__SHIFT 0x9
#define CG_VCLK_CNTL__VCLK_DIR_CNTL_DIVIDER_MASK 0x1fc00
#define CG_VCLK_CNTL__VCLK_DIR_CNTL_DIVIDER__SHIFT 0xa
#define CG_VCLK_STATUS__VCLK_STATUS_MASK 0x1
#define CG_VCLK_STATUS__VCLK_STATUS__SHIFT 0x0
#define CG_VCLK_STATUS__VCLK_DIR_CNTL_DONETOG_MASK 0x2
#define CG_VCLK_STATUS__VCLK_DIR_CNTL_DONETOG__SHIFT 0x1
#define CG_ECLK_CNTL__ECLK_DIVIDER_MASK 0x7f
#define CG_ECLK_CNTL__ECLK_DIVIDER__SHIFT 0x0
#define CG_ECLK_CNTL__ECLK_DIR_CNTL_EN_MASK 0x100
#define CG_ECLK_CNTL__ECLK_DIR_CNTL_EN__SHIFT 0x8
#define CG_ECLK_CNTL__ECLK_DIR_CNTL_TOG_MASK 0x200
#define CG_ECLK_CNTL__ECLK_DIR_CNTL_TOG__SHIFT 0x9
#define CG_ECLK_CNTL__ECLK_DIR_CNTL_DIVIDER_MASK 0x1fc00
#define CG_ECLK_CNTL__ECLK_DIR_CNTL_DIVIDER__SHIFT 0xa
#define CG_ECLK_STATUS__ECLK_STATUS_MASK 0x1
#define CG_ECLK_STATUS__ECLK_STATUS__SHIFT 0x0
#define CG_ECLK_STATUS__ECLK_DIR_CNTL_DONETOG_MASK 0x2
#define CG_ECLK_STATUS__ECLK_DIR_CNTL_DONETOG__SHIFT 0x1
#define CG_ACLK_CNTL__ACLK_DIVIDER_MASK 0x7f
#define CG_ACLK_CNTL__ACLK_DIVIDER__SHIFT 0x0
#define CG_ACLK_CNTL__ACLK_DIR_CNTL_EN_MASK 0x100
#define CG_ACLK_CNTL__ACLK_DIR_CNTL_EN__SHIFT 0x8
#define CG_ACLK_CNTL__ACLK_DIR_CNTL_TOG_MASK 0x200
#define CG_ACLK_CNTL__ACLK_DIR_CNTL_TOG__SHIFT 0x9
#define CG_ACLK_CNTL__ACLK_DIR_CNTL_DIVIDER_MASK 0x1fc00
#define CG_ACLK_CNTL__ACLK_DIR_CNTL_DIVIDER__SHIFT 0xa
#define GCK_DFS_BYPASS_CNTL__BYPASSECLK_MASK 0x1
#define GCK_DFS_BYPASS_CNTL__BYPASSECLK__SHIFT 0x0
#define GCK_DFS_BYPASS_CNTL__BYPASSLCLK_MASK 0x2
#define GCK_DFS_BYPASS_CNTL__BYPASSLCLK__SHIFT 0x1
#define GCK_DFS_BYPASS_CNTL__BYPASSEVCLK_MASK 0x4
#define GCK_DFS_BYPASS_CNTL__BYPASSEVCLK__SHIFT 0x2
#define GCK_DFS_BYPASS_CNTL__BYPASSDCLK_MASK 0x8
#define GCK_DFS_BYPASS_CNTL__BYPASSDCLK__SHIFT 0x3
#define GCK_DFS_BYPASS_CNTL__BYPASSVCLK_MASK 0x10
#define GCK_DFS_BYPASS_CNTL__BYPASSVCLK__SHIFT 0x4
#define GCK_DFS_BYPASS_CNTL__BYPASSDISPCLK_MASK 0x20
#define GCK_DFS_BYPASS_CNTL__BYPASSDISPCLK__SHIFT 0x5
#define GCK_DFS_BYPASS_CNTL__BYPASSDPREFCLK_MASK 0x40
#define GCK_DFS_BYPASS_CNTL__BYPASSDPREFCLK__SHIFT 0x6
#define GCK_DFS_BYPASS_CNTL__BYPASSACLK_MASK 0x80
#define GCK_DFS_BYPASS_CNTL__BYPASSACLK__SHIFT 0x7
#define GCK_DFS_BYPASS_CNTL__BYPASSADIVCLK_MASK 0x100
#define GCK_DFS_BYPASS_CNTL__BYPASSADIVCLK__SHIFT 0x8
#define GCK_DFS_BYPASS_CNTL__BYPASSPSPCLK_MASK 0x200
#define GCK_DFS_BYPASS_CNTL__BYPASSPSPCLK__SHIFT 0x9
#define GCK_DFS_BYPASS_CNTL__BYPASSSAMCLK_MASK 0x400
#define GCK_DFS_BYPASS_CNTL__BYPASSSAMCLK__SHIFT 0xa
#define GCK_DFS_BYPASS_CNTL__BYPASSSCLK_MASK 0x800
#define GCK_DFS_BYPASS_CNTL__BYPASSSCLK__SHIFT 0xb
#define GCK_DFS_BYPASS_CNTL__USE_SPLL_BYPASS_EN_MASK 0x1000
#define GCK_DFS_BYPASS_CNTL__USE_SPLL_BYPASS_EN__SHIFT 0xc
#define CG_SPLL_FUNC_CNTL__SPLL_RESET_MASK 0x1
#define CG_SPLL_FUNC_CNTL__SPLL_RESET__SHIFT 0x0
#define CG_SPLL_FUNC_CNTL__SPLL_PWRON_MASK 0x2
#define CG_SPLL_FUNC_CNTL__SPLL_PWRON__SHIFT 0x1
#define CG_SPLL_FUNC_CNTL__SPLL_DIVEN_MASK 0x4
#define CG_SPLL_FUNC_CNTL__SPLL_DIVEN__SHIFT 0x2
#define CG_SPLL_FUNC_CNTL__SPLL_BYPASS_EN_MASK 0x8
#define CG_SPLL_FUNC_CNTL__SPLL_BYPASS_EN__SHIFT 0x3
#define CG_SPLL_FUNC_CNTL__SPLL_BYPASS_THRU_DFS_MASK 0x10
#define CG_SPLL_FUNC_CNTL__SPLL_BYPASS_THRU_DFS__SHIFT 0x4
#define CG_SPLL_FUNC_CNTL__SPLL_REF_DIV_MASK 0x7e0
#define CG_SPLL_FUNC_CNTL__SPLL_REF_DIV__SHIFT 0x5
#define CG_SPLL_FUNC_CNTL__SPLL_PDIV_A_UPDATE_MASK 0x800
#define CG_SPLL_FUNC_CNTL__SPLL_PDIV_A_UPDATE__SHIFT 0xb
#define CG_SPLL_FUNC_CNTL__SPLL_PDIV_A_EN_MASK 0x1000
#define CG_SPLL_FUNC_CNTL__SPLL_PDIV_A_EN__SHIFT 0xc
#define CG_SPLL_FUNC_CNTL__SPLL_BG_PWRON_MASK 0x2000
#define CG_SPLL_FUNC_CNTL__SPLL_BG_PWRON__SHIFT 0xd
#define CG_SPLL_FUNC_CNTL__SPLL_BGADJ_MASK 0x3c000
#define CG_SPLL_FUNC_CNTL__SPLL_BGADJ__SHIFT 0xe
#define CG_SPLL_FUNC_CNTL__SPLL_PDIV_A_MASK 0x1fc0000
#define CG_SPLL_FUNC_CNTL__SPLL_PDIV_A__SHIFT 0x12
#define CG_SPLL_FUNC_CNTL__SPLL_REG_BIAS_MASK 0xe000000
#define CG_SPLL_FUNC_CNTL__SPLL_REG_BIAS__SHIFT 0x19
#define CG_SPLL_FUNC_CNTL__SPLL_OTEST_LOCK_EN_MASK 0x10000000
#define CG_SPLL_FUNC_CNTL__SPLL_OTEST_LOCK_EN__SHIFT 0x1c
#define CG_SPLL_FUNC_CNTL_2__SCLK_MUX_SEL_MASK 0x1ff
#define CG_SPLL_FUNC_CNTL_2__SCLK_MUX_SEL__SHIFT 0x0
#define CG_SPLL_FUNC_CNTL_2__SPLL_CTLREQ_MASK 0x800
#define CG_SPLL_FUNC_CNTL_2__SPLL_CTLREQ__SHIFT 0xb
#define CG_SPLL_FUNC_CNTL_2__SPLL_BYPASS_CHG_MASK 0x400000
#define CG_SPLL_FUNC_CNTL_2__SPLL_BYPASS_CHG__SHIFT 0x16
#define CG_SPLL_FUNC_CNTL_2__SPLL_CTLREQ_CHG_MASK 0x800000
#define CG_SPLL_FUNC_CNTL_2__SPLL_CTLREQ_CHG__SHIFT 0x17
#define CG_SPLL_FUNC_CNTL_2__SPLL_RESET_CHG_MASK 0x1000000
#define CG_SPLL_FUNC_CNTL_2__SPLL_RESET_CHG__SHIFT 0x18
#define CG_SPLL_FUNC_CNTL_2__SPLL_BABY_STEP_CHG_MASK 0x2000000
#define CG_SPLL_FUNC_CNTL_2__SPLL_BABY_STEP_CHG__SHIFT 0x19
#define CG_SPLL_FUNC_CNTL_2__SCLK_MUX_UPDATE_MASK 0x4000000
#define CG_SPLL_FUNC_CNTL_2__SCLK_MUX_UPDATE__SHIFT 0x1a
#define CG_SPLL_FUNC_CNTL_2__SPLL_UNLOCK_CLEAR_MASK 0x8000000
#define CG_SPLL_FUNC_CNTL_2__SPLL_UNLOCK_CLEAR__SHIFT 0x1b
#define CG_SPLL_FUNC_CNTL_2__SPLL_CLKF_UPDATE_MASK 0x10000000
#define CG_SPLL_FUNC_CNTL_2__SPLL_CLKF_UPDATE__SHIFT 0x1c
#define CG_SPLL_FUNC_CNTL_2__SPLL_TEST_UNLOCK_CLR_MASK 0x40000000
#define CG_SPLL_FUNC_CNTL_2__SPLL_TEST_UNLOCK_CLR__SHIFT 0x1e
#define CG_SPLL_FUNC_CNTL_3__SPLL_FB_DIV_MASK 0x3ffffff
#define CG_SPLL_FUNC_CNTL_3__SPLL_FB_DIV__SHIFT 0x0
#define CG_SPLL_FUNC_CNTL_3__SPLL_DITHEN_MASK 0x10000000
#define CG_SPLL_FUNC_CNTL_3__SPLL_DITHEN__SHIFT 0x1c
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_TEST_SEL_MASK 0xf
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_TEST_SEL__SHIFT 0x0
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_EXT_SEL_MASK 0x60
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_EXT_SEL__SHIFT 0x5
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_EN_MASK 0x180
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_EN__SHIFT 0x7
#define CG_SPLL_FUNC_CNTL_4__SPLL_SSAMP_EN_MASK 0x200
#define CG_SPLL_FUNC_CNTL_4__SPLL_SSAMP_EN__SHIFT 0x9
#define CG_SPLL_FUNC_CNTL_4__SPLL_SPARE_MASK 0x7fc00
#define CG_SPLL_FUNC_CNTL_4__SPLL_SPARE__SHIFT 0xa
#define CG_SPLL_FUNC_CNTL_4__TEST_FRAC_BYPASS_MASK 0x200000
#define CG_SPLL_FUNC_CNTL_4__TEST_FRAC_BYPASS__SHIFT 0x15
#define CG_SPLL_FUNC_CNTL_4__SPLL_ILOCK_MASK 0x800000
#define CG_SPLL_FUNC_CNTL_4__SPLL_ILOCK__SHIFT 0x17
#define CG_SPLL_FUNC_CNTL_4__SPLL_FBCLK_SEL_MASK 0x1000000
#define CG_SPLL_FUNC_CNTL_4__SPLL_FBCLK_SEL__SHIFT 0x18
#define CG_SPLL_FUNC_CNTL_4__SPLL_VCTRLADC_EN_MASK 0x2000000
#define CG_SPLL_FUNC_CNTL_4__SPLL_VCTRLADC_EN__SHIFT 0x19
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_EXT_MASK 0xc000000
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_EXT__SHIFT 0x1a
#define CG_SPLL_FUNC_CNTL_4__SPLL_SPARE_EXT_MASK 0x70000000
#define CG_SPLL_FUNC_CNTL_4__SPLL_SPARE_EXT__SHIFT 0x1c
#define CG_SPLL_FUNC_CNTL_4__SPLL_VTOI_BIAS_CNTL_MASK 0x80000000
#define CG_SPLL_FUNC_CNTL_4__SPLL_VTOI_BIAS_CNTL__SHIFT 0x1f
#define CG_SPLL_FUNC_CNTL_5__FBDIV_SSC_BYPASS_MASK 0x1
#define CG_SPLL_FUNC_CNTL_5__FBDIV_SSC_BYPASS__SHIFT 0x0
#define CG_SPLL_FUNC_CNTL_5__RISEFBVCO_EN_MASK 0x2
#define CG_SPLL_FUNC_CNTL_5__RISEFBVCO_EN__SHIFT 0x1
#define CG_SPLL_FUNC_CNTL_5__PFD_RESET_CNTRL_MASK 0xc
#define CG_SPLL_FUNC_CNTL_5__PFD_RESET_CNTRL__SHIFT 0x2
#define CG_SPLL_FUNC_CNTL_5__RESET_TIMER_MASK 0x30
#define CG_SPLL_FUNC_CNTL_5__RESET_TIMER__SHIFT 0x4
#define CG_SPLL_FUNC_CNTL_5__FAST_LOCK_CNTRL_MASK 0xc0
#define CG_SPLL_FUNC_CNTL_5__FAST_LOCK_CNTRL__SHIFT 0x6
#define CG_SPLL_FUNC_CNTL_5__FAST_LOCK_EN_MASK 0x100
#define CG_SPLL_FUNC_CNTL_5__FAST_LOCK_EN__SHIFT 0x8
#define CG_SPLL_FUNC_CNTL_5__RESET_ANTI_MUX_MASK 0x200
#define CG_SPLL_FUNC_CNTL_5__RESET_ANTI_MUX__SHIFT 0x9
#define CG_SPLL_FUNC_CNTL_5__REFCLK_BYPASS_EN_MASK 0x400
#define CG_SPLL_FUNC_CNTL_5__REFCLK_BYPASS_EN__SHIFT 0xa
#define CG_SPLL_FUNC_CNTL_5__PLLBYPASS_MASK 0x800
#define CG_SPLL_FUNC_CNTL_5__PLLBYPASS__SHIFT 0xb
#define CG_SPLL_FUNC_CNTL_6__SCLKMUX0_CLKOFF_CNT_MASK 0xff
#define CG_SPLL_FUNC_CNTL_6__SCLKMUX0_CLKOFF_CNT__SHIFT 0x0
#define CG_SPLL_FUNC_CNTL_6__SCLKMUX1_CLKOFF_CNT_MASK 0xff00
#define CG_SPLL_FUNC_CNTL_6__SCLKMUX1_CLKOFF_CNT__SHIFT 0x8
#define CG_SPLL_FUNC_CNTL_6__SPLL_VCTL_EN_MASK 0x10000
#define CG_SPLL_FUNC_CNTL_6__SPLL_VCTL_EN__SHIFT 0x10
#define CG_SPLL_FUNC_CNTL_6__SPLL_VCTL_CNTRL_IN_MASK 0x1e0000
#define CG_SPLL_FUNC_CNTL_6__SPLL_VCTL_CNTRL_IN__SHIFT 0x11
#define CG_SPLL_FUNC_CNTL_6__SPLL_VCTL_CNTRL_OUT_MASK 0x1e00000
#define CG_SPLL_FUNC_CNTL_6__SPLL_VCTL_CNTRL_OUT__SHIFT 0x15
#define CG_SPLL_FUNC_CNTL_6__SPLL_LF_CNTR_MASK 0xfe000000
#define CG_SPLL_FUNC_CNTL_6__SPLL_LF_CNTR__SHIFT 0x19
#define CG_SPLL_FUNC_CNTL_7__SPLL_BW_CNTRL_MASK 0xfff
#define CG_SPLL_FUNC_CNTL_7__SPLL_BW_CNTRL__SHIFT 0x0
#define SPLL_CNTL_MODE__SPLL_SW_DIR_CONTROL_MASK 0x1
#define SPLL_CNTL_MODE__SPLL_SW_DIR_CONTROL__SHIFT 0x0
#define SPLL_CNTL_MODE__SPLL_LEGACY_PDIV_MASK 0x2
#define SPLL_CNTL_MODE__SPLL_LEGACY_PDIV__SHIFT 0x1
#define SPLL_CNTL_MODE__SPLL_TEST_MASK 0x4
#define SPLL_CNTL_MODE__SPLL_TEST__SHIFT 0x2
#define SPLL_CNTL_MODE__SPLL_FASTEN_MASK 0x8
#define SPLL_CNTL_MODE__SPLL_FASTEN__SHIFT 0x3
#define SPLL_CNTL_MODE__SPLL_ENSAT_MASK 0x10
#define SPLL_CNTL_MODE__SPLL_ENSAT__SHIFT 0x4
#define SPLL_CNTL_MODE__SPLL_TEST_CLK_EXT_DIV_MASK 0xc00
#define SPLL_CNTL_MODE__SPLL_TEST_CLK_EXT_DIV__SHIFT 0xa
#define SPLL_CNTL_MODE__SPLL_CTLREQ_DLY_CNT_MASK 0xff000
#define SPLL_CNTL_MODE__SPLL_CTLREQ_DLY_CNT__SHIFT 0xc
#define SPLL_CNTL_MODE__SPLL_RESET_EN_MASK 0x10000000
#define SPLL_CNTL_MODE__SPLL_RESET_EN__SHIFT 0x1c
#define SPLL_CNTL_MODE__SPLL_VCO_MODE_MASK 0x60000000
#define SPLL_CNTL_MODE__SPLL_VCO_MODE__SHIFT 0x1d
#define CG_SPLL_SPREAD_SPECTRUM__SSEN_MASK 0x1
#define CG_SPLL_SPREAD_SPECTRUM__SSEN__SHIFT 0x0
#define CG_SPLL_SPREAD_SPECTRUM__CLKS_MASK 0xfff0
#define CG_SPLL_SPREAD_SPECTRUM__CLKS__SHIFT 0x4
#define CG_SPLL_SPREAD_SPECTRUM_2__CLKV_MASK 0x3ffffff
#define CG_SPLL_SPREAD_SPECTRUM_2__CLKV__SHIFT 0x0
#define MPLL_BYPASSCLK_SEL__MPLL_CLKOUT_SEL_MASK 0xff00
#define MPLL_BYPASSCLK_SEL__MPLL_CLKOUT_SEL__SHIFT 0x8
#define CG_CLKPIN_CNTL__XTALIN_DIVIDE_MASK 0x2
#define CG_CLKPIN_CNTL__XTALIN_DIVIDE__SHIFT 0x1
#define CG_CLKPIN_CNTL__BCLK_AS_XCLK_MASK 0x4
#define CG_CLKPIN_CNTL__BCLK_AS_XCLK__SHIFT 0x2
#define CG_CLKPIN_CNTL_2__ENABLE_XCLK_MASK 0x1
#define CG_CLKPIN_CNTL_2__ENABLE_XCLK__SHIFT 0x0
#define CG_CLKPIN_CNTL_2__FORCE_BIF_REFCLK_EN_MASK 0x8
#define CG_CLKPIN_CNTL_2__FORCE_BIF_REFCLK_EN__SHIFT 0x3
#define CG_CLKPIN_CNTL_2__MUX_TCLK_TO_XCLK_MASK 0x100
#define CG_CLKPIN_CNTL_2__MUX_TCLK_TO_XCLK__SHIFT 0x8
#define CG_CLKPIN_CNTL_2__XO_IN_OSCIN_EN_MASK 0x4000
#define CG_CLKPIN_CNTL_2__XO_IN_OSCIN_EN__SHIFT 0xe
#define CG_CLKPIN_CNTL_2__XO_IN_ICORE_CLK_OE_MASK 0x8000
#define CG_CLKPIN_CNTL_2__XO_IN_ICORE_CLK_OE__SHIFT 0xf
#define CG_CLKPIN_CNTL_2__XO_IN_CML_RXEN_MASK 0x10000
#define CG_CLKPIN_CNTL_2__XO_IN_CML_RXEN__SHIFT 0x10
#define CG_CLKPIN_CNTL_2__XO_IN_BIDIR_CML_OE_MASK 0x20000
#define CG_CLKPIN_CNTL_2__XO_IN_BIDIR_CML_OE__SHIFT 0x11
#define CG_CLKPIN_CNTL_2__XO_IN2_OSCIN_EN_MASK 0x40000
#define CG_CLKPIN_CNTL_2__XO_IN2_OSCIN_EN__SHIFT 0x12
#define CG_CLKPIN_CNTL_2__XO_IN2_ICORE_CLK_OE_MASK 0x80000
#define CG_CLKPIN_CNTL_2__XO_IN2_ICORE_CLK_OE__SHIFT 0x13
#define CG_CLKPIN_CNTL_2__XO_IN2_CML_RXEN_MASK 0x100000
#define CG_CLKPIN_CNTL_2__XO_IN2_CML_RXEN__SHIFT 0x14
#define CG_CLKPIN_CNTL_2__XO_IN2_BIDIR_CML_OE_MASK 0x200000
#define CG_CLKPIN_CNTL_2__XO_IN2_BIDIR_CML_OE__SHIFT 0x15
#define CG_CLKPIN_CNTL_2__CML_CTRL_MASK 0xc00000
#define CG_CLKPIN_CNTL_2__CML_CTRL__SHIFT 0x16
#define CG_CLKPIN_CNTL_2__CLK_SPARE_MASK 0xff000000
#define CG_CLKPIN_CNTL_2__CLK_SPARE__SHIFT 0x18
#define THM_CLK_CNTL__CMON_CLK_SEL_MASK 0xff
#define THM_CLK_CNTL__CMON_CLK_SEL__SHIFT 0x0
#define THM_CLK_CNTL__TMON_CLK_SEL_MASK 0xff00
#define THM_CLK_CNTL__TMON_CLK_SEL__SHIFT 0x8
#define THM_CLK_CNTL__CTF_CLK_SHUTOFF_EN_MASK 0x10000
#define THM_CLK_CNTL__CTF_CLK_SHUTOFF_EN__SHIFT 0x10
#define MISC_CLK_CTRL__DEEP_SLEEP_CLK_SEL_MASK 0xff
#define MISC_CLK_CTRL__DEEP_SLEEP_CLK_SEL__SHIFT 0x0
#define MISC_CLK_CTRL__ZCLK_SEL_MASK 0xff00
#define MISC_CLK_CTRL__ZCLK_SEL__SHIFT 0x8
#define MISC_CLK_CTRL__DFT_SMS_PG_CLK_SEL_MASK 0xff0000
#define MISC_CLK_CTRL__DFT_SMS_PG_CLK_SEL__SHIFT 0x10
#define GCK_PLL_TEST_CNTL__TST_SRC_SEL_MASK 0x1f
#define GCK_PLL_TEST_CNTL__TST_SRC_SEL__SHIFT 0x0
#define GCK_PLL_TEST_CNTL__TST_REF_SEL_MASK 0x3e0
#define GCK_PLL_TEST_CNTL__TST_REF_SEL__SHIFT 0x5
#define GCK_PLL_TEST_CNTL__REF_TEST_COUNT_MASK 0x1fc00
#define GCK_PLL_TEST_CNTL__REF_TEST_COUNT__SHIFT 0xa
#define GCK_PLL_TEST_CNTL__TST_RESET_MASK 0x20000
#define GCK_PLL_TEST_CNTL__TST_RESET__SHIFT 0x11
#define GCK_PLL_TEST_CNTL__TST_CLK_SEL_MODE_MASK 0x40000
#define GCK_PLL_TEST_CNTL__TST_CLK_SEL_MODE__SHIFT 0x12
#define GCK_PLL_TEST_CNTL_2__TEST_COUNT_MASK 0xfffe0000
#define GCK_PLL_TEST_CNTL_2__TEST_COUNT__SHIFT 0x11
#define GCK_ADFS_CLK_BYPASS_CNTL1__ECLK_BYPASS_CNTL_MASK 0x7
#define GCK_ADFS_CLK_BYPASS_CNTL1__ECLK_BYPASS_CNTL__SHIFT 0x0
#define GCK_ADFS_CLK_BYPASS_CNTL1__SCLK_BYPASS_CNTL_MASK 0x38
#define GCK_ADFS_CLK_BYPASS_CNTL1__SCLK_BYPASS_CNTL__SHIFT 0x3
#define GCK_ADFS_CLK_BYPASS_CNTL1__LCLK_BYPASS_CNTL_MASK 0x1c0
#define GCK_ADFS_CLK_BYPASS_CNTL1__LCLK_BYPASS_CNTL__SHIFT 0x6
#define GCK_ADFS_CLK_BYPASS_CNTL1__DCLK_BYPASS_CNTL_MASK 0xe00
#define GCK_ADFS_CLK_BYPASS_CNTL1__DCLK_BYPASS_CNTL__SHIFT 0x9
#define GCK_ADFS_CLK_BYPASS_CNTL1__VCLK_BYPASS_CNTL_MASK 0x7000
#define GCK_ADFS_CLK_BYPASS_CNTL1__VCLK_BYPASS_CNTL__SHIFT 0xc
#define GCK_ADFS_CLK_BYPASS_CNTL1__DISPCLK_BYPASS_CNTL_MASK 0x38000
#define GCK_ADFS_CLK_BYPASS_CNTL1__DISPCLK_BYPASS_CNTL__SHIFT 0xf
#define GCK_ADFS_CLK_BYPASS_CNTL1__DRREFCLK_BYPASS_CNTL_MASK 0x1c0000
#define GCK_ADFS_CLK_BYPASS_CNTL1__DRREFCLK_BYPASS_CNTL__SHIFT 0x12
#define GCK_ADFS_CLK_BYPASS_CNTL1__ACLK_BYPASS_CNTL_MASK 0xe00000
#define GCK_ADFS_CLK_BYPASS_CNTL1__ACLK_BYPASS_CNTL__SHIFT 0x15
#define GCK_ADFS_CLK_BYPASS_CNTL1__SAMCLK_BYPASS_CNTL_MASK 0x7000000
#define GCK_ADFS_CLK_BYPASS_CNTL1__SAMCLK_BYPASS_CNTL__SHIFT 0x18
#define GCK_ADFS_CLK_BYPASS_CNTL1__ACLK_DIV_BYPASS_CNTL_MASK 0x38000000
#define GCK_ADFS_CLK_BYPASS_CNTL1__ACLK_DIV_BYPASS_CNTL__SHIFT 0x1b
#define SMC_IND_INDEX__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_0__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_0__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_0__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_0__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_1__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_1__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_1__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_1__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_2__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_2__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_2__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_2__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_3__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_3__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_3__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_3__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_4__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_4__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_4__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_4__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_5__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_5__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_5__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_5__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_6__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_6__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_6__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_6__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_7__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_7__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_7__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_7__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_0_MASK 0x1
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_0__SHIFT 0x0
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_1_MASK 0x2
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_1__SHIFT 0x1
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_2_MASK 0x4
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_2__SHIFT 0x2
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_3_MASK 0x8
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_3__SHIFT 0x3
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_4_MASK 0x10
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_4__SHIFT 0x4
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_5_MASK 0x20
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_5__SHIFT 0x5
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_6_MASK 0x40
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_6__SHIFT 0x6
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_7_MASK 0x80
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_7__SHIFT 0x7
#define SMC_MESSAGE_0__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_0__SMC_MSG__SHIFT 0x0
#define SMC_RESP_0__SMC_RESP_MASK 0xffff
#define SMC_RESP_0__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_1__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_1__SMC_MSG__SHIFT 0x0
#define SMC_RESP_1__SMC_RESP_MASK 0xffff
#define SMC_RESP_1__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_2__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_2__SMC_MSG__SHIFT 0x0
#define SMC_RESP_2__SMC_RESP_MASK 0xffff
#define SMC_RESP_2__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_3__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_3__SMC_MSG__SHIFT 0x0
#define SMC_RESP_3__SMC_RESP_MASK 0xffff
#define SMC_RESP_3__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_4__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_4__SMC_MSG__SHIFT 0x0
#define SMC_RESP_4__SMC_RESP_MASK 0xffff
#define SMC_RESP_4__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_5__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_5__SMC_MSG__SHIFT 0x0
#define SMC_RESP_5__SMC_RESP_MASK 0xffff
#define SMC_RESP_5__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_6__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_6__SMC_MSG__SHIFT 0x0
#define SMC_RESP_6__SMC_RESP_MASK 0xffff
#define SMC_RESP_6__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_7__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_7__SMC_MSG__SHIFT 0x0
#define SMC_RESP_7__SMC_RESP_MASK 0xffff
#define SMC_RESP_7__SMC_RESP__SHIFT 0x0
#define SMC_MSG_ARG_0__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_0__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_1__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_1__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_2__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_2__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_3__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_3__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_4__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_4__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_5__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_5__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_6__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_6__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_7__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_7__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MESSAGE_8__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_8__SMC_MSG__SHIFT 0x0
#define SMC_RESP_8__SMC_RESP_MASK 0xffff
#define SMC_RESP_8__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_9__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_9__SMC_MSG__SHIFT 0x0
#define SMC_RESP_9__SMC_RESP_MASK 0xffff
#define SMC_RESP_9__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_10__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_10__SMC_MSG__SHIFT 0x0
#define SMC_RESP_10__SMC_RESP_MASK 0xffff
#define SMC_RESP_10__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_11__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_11__SMC_MSG__SHIFT 0x0
#define SMC_RESP_11__SMC_RESP_MASK 0xffff
#define SMC_RESP_11__SMC_RESP__SHIFT 0x0
#define SMC_MSG_ARG_8__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_8__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_9__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_9__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_10__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_10__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_11__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_11__SMC_MSG_ARG__SHIFT 0x0
#define SMC_SYSCON_RESET_CNTL__rst_reg_MASK 0x1
#define SMC_SYSCON_RESET_CNTL__rst_reg__SHIFT 0x0
#define SMC_SYSCON_RESET_CNTL__srbm_soft_rst_override_MASK 0x2
#define SMC_SYSCON_RESET_CNTL__srbm_soft_rst_override__SHIFT 0x1
#define SMC_SYSCON_RESET_CNTL__RegReset_MASK 0x40000000
#define SMC_SYSCON_RESET_CNTL__RegReset__SHIFT 0x1e
#define SMC_SYSCON_CLOCK_CNTL_0__ck_disable_MASK 0x1
#define SMC_SYSCON_CLOCK_CNTL_0__ck_disable__SHIFT 0x0
#define SMC_SYSCON_CLOCK_CNTL_0__auto_cg_en_MASK 0x2
#define SMC_SYSCON_CLOCK_CNTL_0__auto_cg_en__SHIFT 0x1
#define SMC_SYSCON_CLOCK_CNTL_0__auto_cg_timeout_MASK 0xffff00
#define SMC_SYSCON_CLOCK_CNTL_0__auto_cg_timeout__SHIFT 0x8
#define SMC_SYSCON_CLOCK_CNTL_0__cken_MASK 0x1000000
#define SMC_SYSCON_CLOCK_CNTL_0__cken__SHIFT 0x18
#define SMC_SYSCON_CLOCK_CNTL_1__auto_ck_disable_MASK 0x1
#define SMC_SYSCON_CLOCK_CNTL_1__auto_ck_disable__SHIFT 0x0
#define SMC_SYSCON_CLOCK_CNTL_2__wake_on_irq_MASK 0xffffffff
#define SMC_SYSCON_CLOCK_CNTL_2__wake_on_irq__SHIFT 0x0
#define SMC_SYSCON_MSG_ARG_0__smc_msg_arg_MASK 0xffffffff
#define SMC_SYSCON_MSG_ARG_0__smc_msg_arg__SHIFT 0x0
#define SMC_PC_C__smc_pc_c_MASK 0xffffffff
#define SMC_PC_C__smc_pc_c__SHIFT 0x0
#define SMC_SCRATCH9__SCRATCH_VALUE_MASK 0xffffffff
#define SMC_SCRATCH9__SCRATCH_VALUE__SHIFT 0x0
#define CG_FPS_CNT__FPS_CNT_MASK 0xff
#define CG_FPS_CNT__FPS_CNT__SHIFT 0x0
#define SMU_SMC_IND_INDEX__SMC_IND_ADDR_MASK 0xffffffff
#define SMU_SMC_IND_INDEX__SMC_IND_ADDR__SHIFT 0x0
#define SMU_SMC_IND_DATA__SMC_IND_DATA_MASK 0xffffffff
#define SMU_SMC_IND_DATA__SMC_IND_DATA__SHIFT 0x0
#define RCU_UC_EVENTS__RCU_TST_jpc_rep_req_MASK 0x1
#define RCU_UC_EVENTS__RCU_TST_jpc_rep_req__SHIFT 0x0
#define RCU_UC_EVENTS__TST_RCU_jpc_rep_done_MASK 0x2
#define RCU_UC_EVENTS__TST_RCU_jpc_rep_done__SHIFT 0x1
#define RCU_UC_EVENTS__drv_rst_mode_MASK 0x4
#define RCU_UC_EVENTS__drv_rst_mode__SHIFT 0x2
#define RCU_UC_EVENTS__TP_Tester_MASK 0x40
#define RCU_UC_EVENTS__TP_Tester__SHIFT 0x6
#define RCU_UC_EVENTS__boot_seq_done_MASK 0x80
#define RCU_UC_EVENTS__boot_seq_done__SHIFT 0x7
#define RCU_UC_EVENTS__sclk_deep_sleep_exit_MASK 0x100
#define RCU_UC_EVENTS__sclk_deep_sleep_exit__SHIFT 0x8
#define RCU_UC_EVENTS__BREAK_PT1_ACTIVE_MASK 0x200
#define RCU_UC_EVENTS__BREAK_PT1_ACTIVE__SHIFT 0x9
#define RCU_UC_EVENTS__BREAK_PT2_ACTIVE_MASK 0x400
#define RCU_UC_EVENTS__BREAK_PT2_ACTIVE__SHIFT 0xa
#define RCU_UC_EVENTS__FCH_HALT_MASK 0x800
#define RCU_UC_EVENTS__FCH_HALT__SHIFT 0xb
#define RCU_UC_EVENTS__RCU_GIO_fch_lockdown_MASK 0x2000
#define RCU_UC_EVENTS__RCU_GIO_fch_lockdown__SHIFT 0xd
#define RCU_UC_EVENTS__INTERRUPTS_ENABLED_MASK 0x10000
#define RCU_UC_EVENTS__INTERRUPTS_ENABLED__SHIFT 0x10
#define RCU_UC_EVENTS__RCU_DtmCnt0_Done_MASK 0x20000
#define RCU_UC_EVENTS__RCU_DtmCnt0_Done__SHIFT 0x11
#define RCU_UC_EVENTS__RCU_DtmCnt1_Done_MASK 0x40000
#define RCU_UC_EVENTS__RCU_DtmCnt1_Done__SHIFT 0x12
#define RCU_UC_EVENTS__RCU_DtmCnt2_Done_MASK 0x80000
#define RCU_UC_EVENTS__RCU_DtmCnt2_Done__SHIFT 0x13
#define RCU_UC_EVENTS__irq31_sel_MASK 0x3000000
#define RCU_UC_EVENTS__irq31_sel__SHIFT 0x18
#define RCU_MISC_CTRL__REG_DRV_RST_MODE_MASK 0x2
#define RCU_MISC_CTRL__REG_DRV_RST_MODE__SHIFT 0x1
#define RCU_MISC_CTRL__REG_RCU_MEMREP_DIS_MASK 0x8
#define RCU_MISC_CTRL__REG_RCU_MEMREP_DIS__SHIFT 0x3
#define RCU_MISC_CTRL__REG_CC_FUSE_DISABLE_MASK 0x10
#define RCU_MISC_CTRL__REG_CC_FUSE_DISABLE__SHIFT 0x4
#define RCU_MISC_CTRL__REG_SAMU_FUSE_DISABLE_MASK 0x20
#define RCU_MISC_CTRL__REG_SAMU_FUSE_DISABLE__SHIFT 0x5
#define RCU_MISC_CTRL__REG_CC_SRBM_RD_DISABLE_MASK 0x100
#define RCU_MISC_CTRL__REG_CC_SRBM_RD_DISABLE__SHIFT 0x8
#define RCU_MISC_CTRL__BREAK_PT1_DONE_MASK 0x10000
#define RCU_MISC_CTRL__BREAK_PT1_DONE__SHIFT 0x10
#define RCU_MISC_CTRL__BREAK_PT2_DONE_MASK 0x20000
#define RCU_MISC_CTRL__BREAK_PT2_DONE__SHIFT 0x11
#define RCU_MISC_CTRL__SAMU_START_MASK 0x400000
#define RCU_MISC_CTRL__SAMU_START__SHIFT 0x16
#define RCU_MISC_CTRL__RST_PULSE_WIDTH_MASK 0xff800000
#define RCU_MISC_CTRL__RST_PULSE_WIDTH__SHIFT 0x17
#define CC_RCU_FUSES__GPU_DIS_MASK 0x2
#define CC_RCU_FUSES__GPU_DIS__SHIFT 0x1
#define CC_RCU_FUSES__DEBUG_DISABLE_MASK 0x4
#define CC_RCU_FUSES__DEBUG_DISABLE__SHIFT 0x2
#define CC_RCU_FUSES__EFUSE_RD_DISABLE_MASK 0x10
#define CC_RCU_FUSES__EFUSE_RD_DISABLE__SHIFT 0x4
#define CC_RCU_FUSES__CG_RST_GLB_REQ_DIS_MASK 0x20
#define CC_RCU_FUSES__CG_RST_GLB_REQ_DIS__SHIFT 0x5
#define CC_RCU_FUSES__DRV_RST_MODE_MASK 0x40
#define CC_RCU_FUSES__DRV_RST_MODE__SHIFT 0x6
#define CC_RCU_FUSES__ROM_DIS_MASK 0x80
#define CC_RCU_FUSES__ROM_DIS__SHIFT 0x7
#define CC_RCU_FUSES__JPC_REP_DISABLE_MASK 0x100
#define CC_RCU_FUSES__JPC_REP_DISABLE__SHIFT 0x8
#define CC_RCU_FUSES__RCU_BREAK_POINT1_MASK 0x200
#define CC_RCU_FUSES__RCU_BREAK_POINT1__SHIFT 0x9
#define CC_RCU_FUSES__RCU_BREAK_POINT2_MASK 0x400
#define CC_RCU_FUSES__RCU_BREAK_POINT2__SHIFT 0xa
#define CC_RCU_FUSES__PHY_FUSE_VALID_MASK 0x4000
#define CC_RCU_FUSES__PHY_FUSE_VALID__SHIFT 0xe
#define CC_RCU_FUSES__SMU_IOC_MST_DISABLE_MASK 0x8000
#define CC_RCU_FUSES__SMU_IOC_MST_DISABLE__SHIFT 0xf
#define CC_RCU_FUSES__FCH_LOCKOUT_ENABLE_MASK 0x10000
#define CC_RCU_FUSES__FCH_LOCKOUT_ENABLE__SHIFT 0x10
#define CC_RCU_FUSES__FCH_XFIRE_FILTER_ENABLE_MASK 0x20000
#define CC_RCU_FUSES__FCH_XFIRE_FILTER_ENABLE__SHIFT 0x11
#define CC_RCU_FUSES__XFIRE_DISABLE_MASK 0x40000
#define CC_RCU_FUSES__XFIRE_DISABLE__SHIFT 0x12
#define CC_RCU_FUSES__SAMU_FUSE_DISABLE_MASK 0x80000
#define CC_RCU_FUSES__SAMU_FUSE_DISABLE__SHIFT 0x13
#define CC_RCU_FUSES__BIF_RST_POLLING_DISABLE_MASK 0x100000
#define CC_RCU_FUSES__BIF_RST_POLLING_DISABLE__SHIFT 0x14
#define CC_RCU_FUSES__MEM_HARDREP_EN_MASK 0x400000
#define CC_RCU_FUSES__MEM_HARDREP_EN__SHIFT 0x16
#define CC_RCU_FUSES__PCIE_INIT_DISABLE_MASK 0x800000
#define CC_RCU_FUSES__PCIE_INIT_DISABLE__SHIFT 0x17
#define CC_RCU_FUSES__DSMU_DISABLE_MASK 0x1000000
#define CC_RCU_FUSES__DSMU_DISABLE__SHIFT 0x18
#define CC_RCU_FUSES__RCU_SPARE_MASK 0x7e000000
#define CC_RCU_FUSES__RCU_SPARE__SHIFT 0x19
#define CC_RCU_FUSES__PSP_ENABLE_MASK 0x80000000
#define CC_RCU_FUSES__PSP_ENABLE__SHIFT 0x1f
#define CC_SMU_MISC_FUSES__IOMMU_V2_DISABLE_MASK 0x2
#define CC_SMU_MISC_FUSES__IOMMU_V2_DISABLE__SHIFT 0x1
#define CC_SMU_MISC_FUSES__MinSClkDid_MASK 0x1fc
#define CC_SMU_MISC_FUSES__MinSClkDid__SHIFT 0x2
#define CC_SMU_MISC_FUSES__MISC_SPARE_MASK 0x600
#define CC_SMU_MISC_FUSES__MISC_SPARE__SHIFT 0x9
#define CC_SMU_MISC_FUSES__PostResetGnbClkDid_MASK 0x3f800
#define CC_SMU_MISC_FUSES__PostResetGnbClkDid__SHIFT 0xb
#define CC_SMU_MISC_FUSES__L2IMU_tn2_dtc_half_MASK 0x40000
#define CC_SMU_MISC_FUSES__L2IMU_tn2_dtc_half__SHIFT 0x12
#define CC_SMU_MISC_FUSES__L2IMU_tn2_ptc_half_MASK 0x80000
#define CC_SMU_MISC_FUSES__L2IMU_tn2_ptc_half__SHIFT 0x13
#define CC_SMU_MISC_FUSES__L2IMU_tn2_itc_half_MASK 0x100000
#define CC_SMU_MISC_FUSES__L2IMU_tn2_itc_half__SHIFT 0x14
#define CC_SMU_MISC_FUSES__L2IMU_tn2_pdc_half_MASK 0x200000
#define CC_SMU_MISC_FUSES__L2IMU_tn2_pdc_half__SHIFT 0x15
#define CC_SMU_MISC_FUSES__L2IMU_tn2_ptc_dis_MASK 0x400000
#define CC_SMU_MISC_FUSES__L2IMU_tn2_ptc_dis__SHIFT 0x16
#define CC_SMU_MISC_FUSES__L2IMU_tn2_itc_dis_MASK 0x800000
#define CC_SMU_MISC_FUSES__L2IMU_tn2_itc_dis__SHIFT 0x17
#define CC_SMU_MISC_FUSES__VCE_DISABLE_MASK 0x8000000
#define CC_SMU_MISC_FUSES__VCE_DISABLE__SHIFT 0x1b
#define CC_SMU_MISC_FUSES__IOC_IOMMU_DISABLE_MASK 0x10000000
#define CC_SMU_MISC_FUSES__IOC_IOMMU_DISABLE__SHIFT 0x1c
#define CC_SMU_MISC_FUSES__GNB_SPARE_MASK 0x60000000
#define CC_SMU_MISC_FUSES__GNB_SPARE__SHIFT 0x1d
#define CC_SCLK_VID_FUSES__SClkVid0_MASK 0xff
#define CC_SCLK_VID_FUSES__SClkVid0__SHIFT 0x0
#define CC_SCLK_VID_FUSES__SClkVid1_MASK 0xff00
#define CC_SCLK_VID_FUSES__SClkVid1__SHIFT 0x8
#define CC_SCLK_VID_FUSES__SClkVid2_MASK 0xff0000
#define CC_SCLK_VID_FUSES__SClkVid2__SHIFT 0x10
#define CC_SCLK_VID_FUSES__SClkVid3_MASK 0xff000000
#define CC_SCLK_VID_FUSES__SClkVid3__SHIFT 0x18
#define CC_GIO_IOCCFG_FUSES__NB_REV_ID_MASK 0x7fe
#define CC_GIO_IOCCFG_FUSES__NB_REV_ID__SHIFT 0x1
#define CC_GIO_IOC_FUSES__IOC_FUSES_MASK 0x3fffe
#define CC_GIO_IOC_FUSES__IOC_FUSES__SHIFT 0x1
#define CC_SMU_TST_EFUSE1_MISC__RF_RM_6_2_MASK 0x3e
#define CC_SMU_TST_EFUSE1_MISC__RF_RM_6_2__SHIFT 0x1
#define CC_SMU_TST_EFUSE1_MISC__RME_MASK 0x40
#define CC_SMU_TST_EFUSE1_MISC__RME__SHIFT 0x6
#define CC_SMU_TST_EFUSE1_MISC__MBIST_DISABLE_MASK 0x80
#define CC_SMU_TST_EFUSE1_MISC__MBIST_DISABLE__SHIFT 0x7
#define CC_SMU_TST_EFUSE1_MISC__HARD_REPAIR_DISABLE_MASK 0x100
#define CC_SMU_TST_EFUSE1_MISC__HARD_REPAIR_DISABLE__SHIFT 0x8
#define CC_SMU_TST_EFUSE1_MISC__SOFT_REPAIR_DISABLE_MASK 0x200
#define CC_SMU_TST_EFUSE1_MISC__SOFT_REPAIR_DISABLE__SHIFT 0x9
#define CC_SMU_TST_EFUSE1_MISC__GPU_DIS_MASK 0x400
#define CC_SMU_TST_EFUSE1_MISC__GPU_DIS__SHIFT 0xa
#define CC_SMU_TST_EFUSE1_MISC__SMS_PWRDWN_DISABLE_MASK 0x800
#define CC_SMU_TST_EFUSE1_MISC__SMS_PWRDWN_DISABLE__SHIFT 0xb
#define CC_SMU_TST_EFUSE1_MISC__CRBBMP1500_DISA_MASK 0x1000
#define CC_SMU_TST_EFUSE1_MISC__CRBBMP1500_DISA__SHIFT 0xc
#define CC_SMU_TST_EFUSE1_MISC__CRBBMP1500_DISB_MASK 0x2000
#define CC_SMU_TST_EFUSE1_MISC__CRBBMP1500_DISB__SHIFT 0xd
#define CC_SMU_TST_EFUSE1_MISC__RM_RF8_MASK 0x4000
#define CC_SMU_TST_EFUSE1_MISC__RM_RF8__SHIFT 0xe
#define CC_SMU_TST_EFUSE1_MISC__DFT_SPARE1_MASK 0x400000
#define CC_SMU_TST_EFUSE1_MISC__DFT_SPARE1__SHIFT 0x16
#define CC_SMU_TST_EFUSE1_MISC__DFT_SPARE2_MASK 0x800000
#define CC_SMU_TST_EFUSE1_MISC__DFT_SPARE2__SHIFT 0x17
#define CC_SMU_TST_EFUSE1_MISC__DFT_SPARE3_MASK 0x1000000
#define CC_SMU_TST_EFUSE1_MISC__DFT_SPARE3__SHIFT 0x18
#define CC_SMU_TST_EFUSE1_MISC__VCE_DISABLE_MASK 0x2000000
#define CC_SMU_TST_EFUSE1_MISC__VCE_DISABLE__SHIFT 0x19
#define CC_SMU_TST_EFUSE1_MISC__DCE_SCAN_DISABLE_MASK 0x4000000
#define CC_SMU_TST_EFUSE1_MISC__DCE_SCAN_DISABLE__SHIFT 0x1a
#define CC_TST_ID_STRAPS__DEVICE_ID_MASK 0xffff0
#define CC_TST_ID_STRAPS__DEVICE_ID__SHIFT 0x4
#define CC_TST_ID_STRAPS__MAJOR_REV_ID_MASK 0xf00000
#define CC_TST_ID_STRAPS__MAJOR_REV_ID__SHIFT 0x14
#define CC_TST_ID_STRAPS__MINOR_REV_ID_MASK 0xf000000
#define CC_TST_ID_STRAPS__MINOR_REV_ID__SHIFT 0x18
#define CC_FCTRL_FUSES__EXT_EFUSE_MACRO_PRESENT_MASK 0x2
#define CC_FCTRL_FUSES__EXT_EFUSE_MACRO_PRESENT__SHIFT 0x1
#define SMU_MAIN_PLL_OP_FREQ__PLL_OP_FREQ_MASK 0xffffffff
#define SMU_MAIN_PLL_OP_FREQ__PLL_OP_FREQ__SHIFT 0x0
#define SMU_STATUS__SMU_DONE_MASK 0x1
#define SMU_STATUS__SMU_DONE__SHIFT 0x0
#define SMU_STATUS__SMU_PASS_MASK 0x2
#define SMU_STATUS__SMU_PASS__SHIFT 0x1
#define SMU_FIRMWARE__SMU_IN_PROG_MASK 0x1
#define SMU_FIRMWARE__SMU_IN_PROG__SHIFT 0x0
#define SMU_FIRMWARE__SMU_RD_DONE_MASK 0x6
#define SMU_FIRMWARE__SMU_RD_DONE__SHIFT 0x1
#define SMU_FIRMWARE__SMU_SRAM_RD_BLOCK_EN_MASK 0x8
#define SMU_FIRMWARE__SMU_SRAM_RD_BLOCK_EN__SHIFT 0x3
#define SMU_FIRMWARE__SMU_SRAM_WR_BLOCK_EN_MASK 0x10
#define SMU_FIRMWARE__SMU_SRAM_WR_BLOCK_EN__SHIFT 0x4
#define SMU_FIRMWARE__SMU_counter_MASK 0xf00
#define SMU_FIRMWARE__SMU_counter__SHIFT 0x8
#define SMU_FIRMWARE__SMU_MODE_MASK 0x10000
#define SMU_FIRMWARE__SMU_MODE__SHIFT 0x10
#define SMU_FIRMWARE__SMU_SEL_MASK 0x20000
#define SMU_FIRMWARE__SMU_SEL__SHIFT 0x11
#define SMU_INPUT_DATA__START_ADDR_MASK 0x7fffffff
#define SMU_INPUT_DATA__START_ADDR__SHIFT 0x0
#define SMU_INPUT_DATA__AUTO_START_MASK 0x80000000
#define SMU_INPUT_DATA__AUTO_START__SHIFT 0x1f
#define SMU_EFUSE_0__EFUSE_DATA_MASK 0xffffffff
#define SMU_EFUSE_0__EFUSE_DATA__SHIFT 0x0
#define DPM_TABLE_1__SystemFlags_MASK 0xffffffff
#define DPM_TABLE_1__SystemFlags__SHIFT 0x0
#define DPM_TABLE_2__GraphicsPIDController_Ki_MASK 0xffffffff
#define DPM_TABLE_2__GraphicsPIDController_Ki__SHIFT 0x0
#define DPM_TABLE_3__GraphicsPIDController_LFWindupUpperLim_MASK 0xffffffff
#define DPM_TABLE_3__GraphicsPIDController_LFWindupUpperLim__SHIFT 0x0
#define DPM_TABLE_4__GraphicsPIDController_LFWindupLowerLim_MASK 0xffffffff
#define DPM_TABLE_4__GraphicsPIDController_LFWindupLowerLim__SHIFT 0x0
#define DPM_TABLE_5__GraphicsPIDController_StatePrecision_MASK 0xffffffff
#define DPM_TABLE_5__GraphicsPIDController_StatePrecision__SHIFT 0x0
#define DPM_TABLE_6__GraphicsPIDController_LfPrecision_MASK 0xffffffff
#define DPM_TABLE_6__GraphicsPIDController_LfPrecision__SHIFT 0x0
#define DPM_TABLE_7__GraphicsPIDController_LfOffset_MASK 0xffffffff
#define DPM_TABLE_7__GraphicsPIDController_LfOffset__SHIFT 0x0
#define DPM_TABLE_8__GraphicsPIDController_MaxState_MASK 0xffffffff
#define DPM_TABLE_8__GraphicsPIDController_MaxState__SHIFT 0x0
#define DPM_TABLE_9__GraphicsPIDController_MaxLfFraction_MASK 0xffffffff
#define DPM_TABLE_9__GraphicsPIDController_MaxLfFraction__SHIFT 0x0
#define DPM_TABLE_10__GraphicsPIDController_StateShift_MASK 0xffffffff
#define DPM_TABLE_10__GraphicsPIDController_StateShift__SHIFT 0x0
#define DPM_TABLE_11__GioPIDController_Ki_MASK 0xffffffff
#define DPM_TABLE_11__GioPIDController_Ki__SHIFT 0x0
#define DPM_TABLE_12__GioPIDController_LFWindupUpperLim_MASK 0xffffffff
#define DPM_TABLE_12__GioPIDController_LFWindupUpperLim__SHIFT 0x0
#define DPM_TABLE_13__GioPIDController_LFWindupLowerLim_MASK 0xffffffff
#define DPM_TABLE_13__GioPIDController_LFWindupLowerLim__SHIFT 0x0
#define DPM_TABLE_14__GioPIDController_StatePrecision_MASK 0xffffffff
#define DPM_TABLE_14__GioPIDController_StatePrecision__SHIFT 0x0
#define DPM_TABLE_15__GioPIDController_LfPrecision_MASK 0xffffffff
#define DPM_TABLE_15__GioPIDController_LfPrecision__SHIFT 0x0
#define DPM_TABLE_16__GioPIDController_LfOffset_MASK 0xffffffff
#define DPM_TABLE_16__GioPIDController_LfOffset__SHIFT 0x0
#define DPM_TABLE_17__GioPIDController_MaxState_MASK 0xffffffff
#define DPM_TABLE_17__GioPIDController_MaxState__SHIFT 0x0
#define DPM_TABLE_18__GioPIDController_MaxLfFraction_MASK 0xffffffff
#define DPM_TABLE_18__GioPIDController_MaxLfFraction__SHIFT 0x0
#define DPM_TABLE_19__GioPIDController_StateShift_MASK 0xffffffff
#define DPM_TABLE_19__GioPIDController_StateShift__SHIFT 0x0
#define DPM_TABLE_20__VceLevelCount_MASK 0xff
#define DPM_TABLE_20__VceLevelCount__SHIFT 0x0
#define DPM_TABLE_20__UvdLevelCount_MASK 0xff00
#define DPM_TABLE_20__UvdLevelCount__SHIFT 0x8
#define DPM_TABLE_20__GIOLevelCount_MASK 0xff0000
#define DPM_TABLE_20__GIOLevelCount__SHIFT 0x10
#define DPM_TABLE_20__GraphicsDpmLevelCount_MASK 0xff000000
#define DPM_TABLE_20__GraphicsDpmLevelCount__SHIFT 0x18
#define DPM_TABLE_21__FpsHighThreshold_MASK 0xffff
#define DPM_TABLE_21__FpsHighThreshold__SHIFT 0x0
#define DPM_TABLE_21__SamuLevelCount_MASK 0xff0000
#define DPM_TABLE_21__SamuLevelCount__SHIFT 0x10
#define DPM_TABLE_21__AcpLevelCount_MASK 0xff000000
#define DPM_TABLE_21__AcpLevelCount__SHIFT 0x18
#define DPM_TABLE_22__GraphicsLevel_0_MinVddNb_MASK 0xffffffff
#define DPM_TABLE_22__GraphicsLevel_0_MinVddNb__SHIFT 0x0
#define DPM_TABLE_23__GraphicsLevel_0_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_23__GraphicsLevel_0_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_24__GraphicsLevel_0_ActivityLevel_MASK 0xffff
#define DPM_TABLE_24__GraphicsLevel_0_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_24__GraphicsLevel_0_VidOffset_MASK 0xff0000
#define DPM_TABLE_24__GraphicsLevel_0_VidOffset__SHIFT 0x10
#define DPM_TABLE_24__GraphicsLevel_0_Vid_MASK 0xff000000
#define DPM_TABLE_24__GraphicsLevel_0_Vid__SHIFT 0x18
#define DPM_TABLE_25__GraphicsLevel_0_SclkDid_MASK 0xff
#define DPM_TABLE_25__GraphicsLevel_0_SclkDid__SHIFT 0x0
#define DPM_TABLE_25__GraphicsLevel_0_ForceNbPs1_MASK 0xff00
#define DPM_TABLE_25__GraphicsLevel_0_ForceNbPs1__SHIFT 0x8
#define DPM_TABLE_25__GraphicsLevel_0_GnbSlow_MASK 0xff0000
#define DPM_TABLE_25__GraphicsLevel_0_GnbSlow__SHIFT 0x10
#define DPM_TABLE_25__GraphicsLevel_0_PowerThrottle_MASK 0xff000000
#define DPM_TABLE_25__GraphicsLevel_0_PowerThrottle__SHIFT 0x18
#define DPM_TABLE_26__GraphicsLevel_0_UpHyst_MASK 0xff
#define DPM_TABLE_26__GraphicsLevel_0_UpHyst__SHIFT 0x0
#define DPM_TABLE_26__GraphicsLevel_0_EnabledForThrottle_MASK 0xff00
#define DPM_TABLE_26__GraphicsLevel_0_EnabledForThrottle__SHIFT 0x8
#define DPM_TABLE_26__GraphicsLevel_0_EnabledForActivity_MASK 0xff0000
#define DPM_TABLE_26__GraphicsLevel_0_EnabledForActivity__SHIFT 0x10
#define DPM_TABLE_26__GraphicsLevel_0_DisplayWatermark_MASK 0xff000000
#define DPM_TABLE_26__GraphicsLevel_0_DisplayWatermark__SHIFT 0x18
#define DPM_TABLE_27__GraphicsLevel_0_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_27__GraphicsLevel_0_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_27__GraphicsLevel_0_DeepSleepDivId_MASK 0xff00
#define DPM_TABLE_27__GraphicsLevel_0_DeepSleepDivId__SHIFT 0x8
#define DPM_TABLE_27__GraphicsLevel_0_VoltageDownHyst_MASK 0xff0000
#define DPM_TABLE_27__GraphicsLevel_0_VoltageDownHyst__SHIFT 0x10
#define DPM_TABLE_27__GraphicsLevel_0_DownHyst_MASK 0xff000000
#define DPM_TABLE_27__GraphicsLevel_0_DownHyst__SHIFT 0x18
#define DPM_TABLE_28__GraphicsLevel_0_reserved_MASK 0xffffffff
#define DPM_TABLE_28__GraphicsLevel_0_reserved__SHIFT 0x0
#define DPM_TABLE_29__GraphicsLevel_1_MinVddNb_MASK 0xffffffff
#define DPM_TABLE_29__GraphicsLevel_1_MinVddNb__SHIFT 0x0
#define DPM_TABLE_30__GraphicsLevel_1_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_30__GraphicsLevel_1_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_31__GraphicsLevel_1_ActivityLevel_MASK 0xffff
#define DPM_TABLE_31__GraphicsLevel_1_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_31__GraphicsLevel_1_VidOffset_MASK 0xff0000
#define DPM_TABLE_31__GraphicsLevel_1_VidOffset__SHIFT 0x10
#define DPM_TABLE_31__GraphicsLevel_1_Vid_MASK 0xff000000
#define DPM_TABLE_31__GraphicsLevel_1_Vid__SHIFT 0x18
#define DPM_TABLE_32__GraphicsLevel_1_SclkDid_MASK 0xff
#define DPM_TABLE_32__GraphicsLevel_1_SclkDid__SHIFT 0x0
#define DPM_TABLE_32__GraphicsLevel_1_ForceNbPs1_MASK 0xff00
#define DPM_TABLE_32__GraphicsLevel_1_ForceNbPs1__SHIFT 0x8
#define DPM_TABLE_32__GraphicsLevel_1_GnbSlow_MASK 0xff0000
#define DPM_TABLE_32__GraphicsLevel_1_GnbSlow__SHIFT 0x10
#define DPM_TABLE_32__GraphicsLevel_1_PowerThrottle_MASK 0xff000000
#define DPM_TABLE_32__GraphicsLevel_1_PowerThrottle__SHIFT 0x18
#define DPM_TABLE_33__GraphicsLevel_1_UpHyst_MASK 0xff
#define DPM_TABLE_33__GraphicsLevel_1_UpHyst__SHIFT 0x0
#define DPM_TABLE_33__GraphicsLevel_1_EnabledForThrottle_MASK 0xff00
#define DPM_TABLE_33__GraphicsLevel_1_EnabledForThrottle__SHIFT 0x8
#define DPM_TABLE_33__GraphicsLevel_1_EnabledForActivity_MASK 0xff0000
#define DPM_TABLE_33__GraphicsLevel_1_EnabledForActivity__SHIFT 0x10
#define DPM_TABLE_33__GraphicsLevel_1_DisplayWatermark_MASK 0xff000000
#define DPM_TABLE_33__GraphicsLevel_1_DisplayWatermark__SHIFT 0x18
#define DPM_TABLE_34__GraphicsLevel_1_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_34__GraphicsLevel_1_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_34__GraphicsLevel_1_DeepSleepDivId_MASK 0xff00
#define DPM_TABLE_34__GraphicsLevel_1_DeepSleepDivId__SHIFT 0x8
#define DPM_TABLE_34__GraphicsLevel_1_VoltageDownHyst_MASK 0xff0000
#define DPM_TABLE_34__GraphicsLevel_1_VoltageDownHyst__SHIFT 0x10
#define DPM_TABLE_34__GraphicsLevel_1_DownHyst_MASK 0xff000000
#define DPM_TABLE_34__GraphicsLevel_1_DownHyst__SHIFT 0x18
#define DPM_TABLE_35__GraphicsLevel_1_reserved_MASK 0xffffffff
#define DPM_TABLE_35__GraphicsLevel_1_reserved__SHIFT 0x0
#define DPM_TABLE_36__GraphicsLevel_2_MinVddNb_MASK 0xffffffff
#define DPM_TABLE_36__GraphicsLevel_2_MinVddNb__SHIFT 0x0
#define DPM_TABLE_37__GraphicsLevel_2_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_37__GraphicsLevel_2_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_38__GraphicsLevel_2_ActivityLevel_MASK 0xffff
#define DPM_TABLE_38__GraphicsLevel_2_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_38__GraphicsLevel_2_VidOffset_MASK 0xff0000
#define DPM_TABLE_38__GraphicsLevel_2_VidOffset__SHIFT 0x10
#define DPM_TABLE_38__GraphicsLevel_2_Vid_MASK 0xff000000
#define DPM_TABLE_38__GraphicsLevel_2_Vid__SHIFT 0x18
#define DPM_TABLE_39__GraphicsLevel_2_SclkDid_MASK 0xff
#define DPM_TABLE_39__GraphicsLevel_2_SclkDid__SHIFT 0x0
#define DPM_TABLE_39__GraphicsLevel_2_ForceNbPs1_MASK 0xff00
#define DPM_TABLE_39__GraphicsLevel_2_ForceNbPs1__SHIFT 0x8
#define DPM_TABLE_39__GraphicsLevel_2_GnbSlow_MASK 0xff0000
#define DPM_TABLE_39__GraphicsLevel_2_GnbSlow__SHIFT 0x10
#define DPM_TABLE_39__GraphicsLevel_2_PowerThrottle_MASK 0xff000000
#define DPM_TABLE_39__GraphicsLevel_2_PowerThrottle__SHIFT 0x18
#define DPM_TABLE_40__GraphicsLevel_2_UpHyst_MASK 0xff
#define DPM_TABLE_40__GraphicsLevel_2_UpHyst__SHIFT 0x0
#define DPM_TABLE_40__GraphicsLevel_2_EnabledForThrottle_MASK 0xff00
#define DPM_TABLE_40__GraphicsLevel_2_EnabledForThrottle__SHIFT 0x8
#define DPM_TABLE_40__GraphicsLevel_2_EnabledForActivity_MASK 0xff0000
#define DPM_TABLE_40__GraphicsLevel_2_EnabledForActivity__SHIFT 0x10
#define DPM_TABLE_40__GraphicsLevel_2_DisplayWatermark_MASK 0xff000000
#define DPM_TABLE_40__GraphicsLevel_2_DisplayWatermark__SHIFT 0x18
#define DPM_TABLE_41__GraphicsLevel_2_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_41__GraphicsLevel_2_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_41__GraphicsLevel_2_DeepSleepDivId_MASK 0xff00
#define DPM_TABLE_41__GraphicsLevel_2_DeepSleepDivId__SHIFT 0x8
#define DPM_TABLE_41__GraphicsLevel_2_VoltageDownHyst_MASK 0xff0000
#define DPM_TABLE_41__GraphicsLevel_2_VoltageDownHyst__SHIFT 0x10
#define DPM_TABLE_41__GraphicsLevel_2_DownHyst_MASK 0xff000000
#define DPM_TABLE_41__GraphicsLevel_2_DownHyst__SHIFT 0x18
#define DPM_TABLE_42__GraphicsLevel_2_reserved_MASK 0xffffffff
#define DPM_TABLE_42__GraphicsLevel_2_reserved__SHIFT 0x0
#define DPM_TABLE_43__GraphicsLevel_3_MinVddNb_MASK 0xffffffff
#define DPM_TABLE_43__GraphicsLevel_3_MinVddNb__SHIFT 0x0
#define DPM_TABLE_44__GraphicsLevel_3_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_44__GraphicsLevel_3_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_45__GraphicsLevel_3_ActivityLevel_MASK 0xffff
#define DPM_TABLE_45__GraphicsLevel_3_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_45__GraphicsLevel_3_VidOffset_MASK 0xff0000
#define DPM_TABLE_45__GraphicsLevel_3_VidOffset__SHIFT 0x10
#define DPM_TABLE_45__GraphicsLevel_3_Vid_MASK 0xff000000
#define DPM_TABLE_45__GraphicsLevel_3_Vid__SHIFT 0x18
#define DPM_TABLE_46__GraphicsLevel_3_SclkDid_MASK 0xff
#define DPM_TABLE_46__GraphicsLevel_3_SclkDid__SHIFT 0x0
#define DPM_TABLE_46__GraphicsLevel_3_ForceNbPs1_MASK 0xff00
#define DPM_TABLE_46__GraphicsLevel_3_ForceNbPs1__SHIFT 0x8
#define DPM_TABLE_46__GraphicsLevel_3_GnbSlow_MASK 0xff0000
#define DPM_TABLE_46__GraphicsLevel_3_GnbSlow__SHIFT 0x10
#define DPM_TABLE_46__GraphicsLevel_3_PowerThrottle_MASK 0xff000000
#define DPM_TABLE_46__GraphicsLevel_3_PowerThrottle__SHIFT 0x18
#define DPM_TABLE_47__GraphicsLevel_3_UpHyst_MASK 0xff
#define DPM_TABLE_47__GraphicsLevel_3_UpHyst__SHIFT 0x0
#define DPM_TABLE_47__GraphicsLevel_3_EnabledForThrottle_MASK 0xff00
#define DPM_TABLE_47__GraphicsLevel_3_EnabledForThrottle__SHIFT 0x8
#define DPM_TABLE_47__GraphicsLevel_3_EnabledForActivity_MASK 0xff0000
#define DPM_TABLE_47__GraphicsLevel_3_EnabledForActivity__SHIFT 0x10
#define DPM_TABLE_47__GraphicsLevel_3_DisplayWatermark_MASK 0xff000000
#define DPM_TABLE_47__GraphicsLevel_3_DisplayWatermark__SHIFT 0x18
#define DPM_TABLE_48__GraphicsLevel_3_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_48__GraphicsLevel_3_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_48__GraphicsLevel_3_DeepSleepDivId_MASK 0xff00
#define DPM_TABLE_48__GraphicsLevel_3_DeepSleepDivId__SHIFT 0x8
#define DPM_TABLE_48__GraphicsLevel_3_VoltageDownHyst_MASK 0xff0000
#define DPM_TABLE_48__GraphicsLevel_3_VoltageDownHyst__SHIFT 0x10
#define DPM_TABLE_48__GraphicsLevel_3_DownHyst_MASK 0xff000000
#define DPM_TABLE_48__GraphicsLevel_3_DownHyst__SHIFT 0x18
#define DPM_TABLE_49__GraphicsLevel_3_reserved_MASK 0xffffffff
#define DPM_TABLE_49__GraphicsLevel_3_reserved__SHIFT 0x0
#define DPM_TABLE_50__GraphicsLevel_4_MinVddNb_MASK 0xffffffff
#define DPM_TABLE_50__GraphicsLevel_4_MinVddNb__SHIFT 0x0
#define DPM_TABLE_51__GraphicsLevel_4_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_51__GraphicsLevel_4_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_52__GraphicsLevel_4_ActivityLevel_MASK 0xffff
#define DPM_TABLE_52__GraphicsLevel_4_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_52__GraphicsLevel_4_VidOffset_MASK 0xff0000
#define DPM_TABLE_52__GraphicsLevel_4_VidOffset__SHIFT 0x10
#define DPM_TABLE_52__GraphicsLevel_4_Vid_MASK 0xff000000
#define DPM_TABLE_52__GraphicsLevel_4_Vid__SHIFT 0x18
#define DPM_TABLE_53__GraphicsLevel_4_SclkDid_MASK 0xff
#define DPM_TABLE_53__GraphicsLevel_4_SclkDid__SHIFT 0x0
#define DPM_TABLE_53__GraphicsLevel_4_ForceNbPs1_MASK 0xff00
#define DPM_TABLE_53__GraphicsLevel_4_ForceNbPs1__SHIFT 0x8
#define DPM_TABLE_53__GraphicsLevel_4_GnbSlow_MASK 0xff0000
#define DPM_TABLE_53__GraphicsLevel_4_GnbSlow__SHIFT 0x10
#define DPM_TABLE_53__GraphicsLevel_4_PowerThrottle_MASK 0xff000000
#define DPM_TABLE_53__GraphicsLevel_4_PowerThrottle__SHIFT 0x18
#define DPM_TABLE_54__GraphicsLevel_4_UpHyst_MASK 0xff
#define DPM_TABLE_54__GraphicsLevel_4_UpHyst__SHIFT 0x0
#define DPM_TABLE_54__GraphicsLevel_4_EnabledForThrottle_MASK 0xff00
#define DPM_TABLE_54__GraphicsLevel_4_EnabledForThrottle__SHIFT 0x8
#define DPM_TABLE_54__GraphicsLevel_4_EnabledForActivity_MASK 0xff0000
#define DPM_TABLE_54__GraphicsLevel_4_EnabledForActivity__SHIFT 0x10
#define DPM_TABLE_54__GraphicsLevel_4_DisplayWatermark_MASK 0xff000000
#define DPM_TABLE_54__GraphicsLevel_4_DisplayWatermark__SHIFT 0x18
#define DPM_TABLE_55__GraphicsLevel_4_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_55__GraphicsLevel_4_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_55__GraphicsLevel_4_DeepSleepDivId_MASK 0xff00
#define DPM_TABLE_55__GraphicsLevel_4_DeepSleepDivId__SHIFT 0x8
#define DPM_TABLE_55__GraphicsLevel_4_VoltageDownHyst_MASK 0xff0000
#define DPM_TABLE_55__GraphicsLevel_4_VoltageDownHyst__SHIFT 0x10
#define DPM_TABLE_55__GraphicsLevel_4_DownHyst_MASK 0xff000000
#define DPM_TABLE_55__GraphicsLevel_4_DownHyst__SHIFT 0x18
#define DPM_TABLE_56__GraphicsLevel_4_reserved_MASK 0xffffffff
#define DPM_TABLE_56__GraphicsLevel_4_reserved__SHIFT 0x0
#define DPM_TABLE_57__GraphicsLevel_5_MinVddNb_MASK 0xffffffff
#define DPM_TABLE_57__GraphicsLevel_5_MinVddNb__SHIFT 0x0
#define DPM_TABLE_58__GraphicsLevel_5_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_58__GraphicsLevel_5_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_59__GraphicsLevel_5_ActivityLevel_MASK 0xffff
#define DPM_TABLE_59__GraphicsLevel_5_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_59__GraphicsLevel_5_VidOffset_MASK 0xff0000
#define DPM_TABLE_59__GraphicsLevel_5_VidOffset__SHIFT 0x10
#define DPM_TABLE_59__GraphicsLevel_5_Vid_MASK 0xff000000
#define DPM_TABLE_59__GraphicsLevel_5_Vid__SHIFT 0x18
#define DPM_TABLE_60__GraphicsLevel_5_SclkDid_MASK 0xff
#define DPM_TABLE_60__GraphicsLevel_5_SclkDid__SHIFT 0x0
#define DPM_TABLE_60__GraphicsLevel_5_ForceNbPs1_MASK 0xff00
#define DPM_TABLE_60__GraphicsLevel_5_ForceNbPs1__SHIFT 0x8
#define DPM_TABLE_60__GraphicsLevel_5_GnbSlow_MASK 0xff0000
#define DPM_TABLE_60__GraphicsLevel_5_GnbSlow__SHIFT 0x10
#define DPM_TABLE_60__GraphicsLevel_5_PowerThrottle_MASK 0xff000000
#define DPM_TABLE_60__GraphicsLevel_5_PowerThrottle__SHIFT 0x18
#define DPM_TABLE_61__GraphicsLevel_5_UpHyst_MASK 0xff
#define DPM_TABLE_61__GraphicsLevel_5_UpHyst__SHIFT 0x0
#define DPM_TABLE_61__GraphicsLevel_5_EnabledForThrottle_MASK 0xff00
#define DPM_TABLE_61__GraphicsLevel_5_EnabledForThrottle__SHIFT 0x8
#define DPM_TABLE_61__GraphicsLevel_5_EnabledForActivity_MASK 0xff0000
#define DPM_TABLE_61__GraphicsLevel_5_EnabledForActivity__SHIFT 0x10
#define DPM_TABLE_61__GraphicsLevel_5_DisplayWatermark_MASK 0xff000000
#define DPM_TABLE_61__GraphicsLevel_5_DisplayWatermark__SHIFT 0x18
#define DPM_TABLE_62__GraphicsLevel_5_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_62__GraphicsLevel_5_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_62__GraphicsLevel_5_DeepSleepDivId_MASK 0xff00
#define DPM_TABLE_62__GraphicsLevel_5_DeepSleepDivId__SHIFT 0x8
#define DPM_TABLE_62__GraphicsLevel_5_VoltageDownHyst_MASK 0xff0000
#define DPM_TABLE_62__GraphicsLevel_5_VoltageDownHyst__SHIFT 0x10
#define DPM_TABLE_62__GraphicsLevel_5_DownHyst_MASK 0xff000000
#define DPM_TABLE_62__GraphicsLevel_5_DownHyst__SHIFT 0x18
#define DPM_TABLE_63__GraphicsLevel_5_reserved_MASK 0xffffffff
#define DPM_TABLE_63__GraphicsLevel_5_reserved__SHIFT 0x0
#define DPM_TABLE_64__GraphicsLevel_6_MinVddNb_MASK 0xffffffff
#define DPM_TABLE_64__GraphicsLevel_6_MinVddNb__SHIFT 0x0
#define DPM_TABLE_65__GraphicsLevel_6_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_65__GraphicsLevel_6_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_66__GraphicsLevel_6_ActivityLevel_MASK 0xffff
#define DPM_TABLE_66__GraphicsLevel_6_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_66__GraphicsLevel_6_VidOffset_MASK 0xff0000
#define DPM_TABLE_66__GraphicsLevel_6_VidOffset__SHIFT 0x10
#define DPM_TABLE_66__GraphicsLevel_6_Vid_MASK 0xff000000
#define DPM_TABLE_66__GraphicsLevel_6_Vid__SHIFT 0x18
#define DPM_TABLE_67__GraphicsLevel_6_SclkDid_MASK 0xff
#define DPM_TABLE_67__GraphicsLevel_6_SclkDid__SHIFT 0x0
#define DPM_TABLE_67__GraphicsLevel_6_ForceNbPs1_MASK 0xff00
#define DPM_TABLE_67__GraphicsLevel_6_ForceNbPs1__SHIFT 0x8
#define DPM_TABLE_67__GraphicsLevel_6_GnbSlow_MASK 0xff0000
#define DPM_TABLE_67__GraphicsLevel_6_GnbSlow__SHIFT 0x10
#define DPM_TABLE_67__GraphicsLevel_6_PowerThrottle_MASK 0xff000000
#define DPM_TABLE_67__GraphicsLevel_6_PowerThrottle__SHIFT 0x18
#define DPM_TABLE_68__GraphicsLevel_6_UpHyst_MASK 0xff
#define DPM_TABLE_68__GraphicsLevel_6_UpHyst__SHIFT 0x0
#define DPM_TABLE_68__GraphicsLevel_6_EnabledForThrottle_MASK 0xff00
#define DPM_TABLE_68__GraphicsLevel_6_EnabledForThrottle__SHIFT 0x8
#define DPM_TABLE_68__GraphicsLevel_6_EnabledForActivity_MASK 0xff0000
#define DPM_TABLE_68__GraphicsLevel_6_EnabledForActivity__SHIFT 0x10
#define DPM_TABLE_68__GraphicsLevel_6_DisplayWatermark_MASK 0xff000000
#define DPM_TABLE_68__GraphicsLevel_6_DisplayWatermark__SHIFT 0x18
#define DPM_TABLE_69__GraphicsLevel_6_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_69__GraphicsLevel_6_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_69__GraphicsLevel_6_DeepSleepDivId_MASK 0xff00
#define DPM_TABLE_69__GraphicsLevel_6_DeepSleepDivId__SHIFT 0x8
#define DPM_TABLE_69__GraphicsLevel_6_VoltageDownHyst_MASK 0xff0000
#define DPM_TABLE_69__GraphicsLevel_6_VoltageDownHyst__SHIFT 0x10
#define DPM_TABLE_69__GraphicsLevel_6_DownHyst_MASK 0xff000000
#define DPM_TABLE_69__GraphicsLevel_6_DownHyst__SHIFT 0x18
#define DPM_TABLE_70__GraphicsLevel_6_reserved_MASK 0xffffffff
#define DPM_TABLE_70__GraphicsLevel_6_reserved__SHIFT 0x0
#define DPM_TABLE_71__GraphicsLevel_7_MinVddNb_MASK 0xffffffff
#define DPM_TABLE_71__GraphicsLevel_7_MinVddNb__SHIFT 0x0
#define DPM_TABLE_72__GraphicsLevel_7_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_72__GraphicsLevel_7_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_73__GraphicsLevel_7_ActivityLevel_MASK 0xffff
#define DPM_TABLE_73__GraphicsLevel_7_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_73__GraphicsLevel_7_VidOffset_MASK 0xff0000
#define DPM_TABLE_73__GraphicsLevel_7_VidOffset__SHIFT 0x10
#define DPM_TABLE_73__GraphicsLevel_7_Vid_MASK 0xff000000
#define DPM_TABLE_73__GraphicsLevel_7_Vid__SHIFT 0x18
#define DPM_TABLE_74__GraphicsLevel_7_SclkDid_MASK 0xff
#define DPM_TABLE_74__GraphicsLevel_7_SclkDid__SHIFT 0x0
#define DPM_TABLE_74__GraphicsLevel_7_ForceNbPs1_MASK 0xff00
#define DPM_TABLE_74__GraphicsLevel_7_ForceNbPs1__SHIFT 0x8
#define DPM_TABLE_74__GraphicsLevel_7_GnbSlow_MASK 0xff0000
#define DPM_TABLE_74__GraphicsLevel_7_GnbSlow__SHIFT 0x10
#define DPM_TABLE_74__GraphicsLevel_7_PowerThrottle_MASK 0xff000000
#define DPM_TABLE_74__GraphicsLevel_7_PowerThrottle__SHIFT 0x18
#define DPM_TABLE_75__GraphicsLevel_7_UpHyst_MASK 0xff
#define DPM_TABLE_75__GraphicsLevel_7_UpHyst__SHIFT 0x0
#define DPM_TABLE_75__GraphicsLevel_7_EnabledForThrottle_MASK 0xff00
#define DPM_TABLE_75__GraphicsLevel_7_EnabledForThrottle__SHIFT 0x8
#define DPM_TABLE_75__GraphicsLevel_7_EnabledForActivity_MASK 0xff0000
#define DPM_TABLE_75__GraphicsLevel_7_EnabledForActivity__SHIFT 0x10
#define DPM_TABLE_75__GraphicsLevel_7_DisplayWatermark_MASK 0xff000000
#define DPM_TABLE_75__GraphicsLevel_7_DisplayWatermark__SHIFT 0x18
#define DPM_TABLE_76__GraphicsLevel_7_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_76__GraphicsLevel_7_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_76__GraphicsLevel_7_DeepSleepDivId_MASK 0xff00
#define DPM_TABLE_76__GraphicsLevel_7_DeepSleepDivId__SHIFT 0x8
#define DPM_TABLE_76__GraphicsLevel_7_VoltageDownHyst_MASK 0xff0000
#define DPM_TABLE_76__GraphicsLevel_7_VoltageDownHyst__SHIFT 0x10
#define DPM_TABLE_76__GraphicsLevel_7_DownHyst_MASK 0xff000000
#define DPM_TABLE_76__GraphicsLevel_7_DownHyst__SHIFT 0x18
#define DPM_TABLE_77__GraphicsLevel_7_reserved_MASK 0xffffffff
#define DPM_TABLE_77__GraphicsLevel_7_reserved__SHIFT 0x0
#define DPM_TABLE_78__ACPILevel_Flags_MASK 0xffffffff
#define DPM_TABLE_78__ACPILevel_Flags__SHIFT 0x0
#define DPM_TABLE_79__ACPILevel_MinVddNb_MASK 0xffffffff
#define DPM_TABLE_79__ACPILevel_MinVddNb__SHIFT 0x0
#define DPM_TABLE_80__ACPILevel_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_80__ACPILevel_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_81__ACPILevel_DisplayWatermark_MASK 0xff
#define DPM_TABLE_81__ACPILevel_DisplayWatermark__SHIFT 0x0
#define DPM_TABLE_81__ACPILevel_ForceNbPs1_MASK 0xff00
#define DPM_TABLE_81__ACPILevel_ForceNbPs1__SHIFT 0x8
#define DPM_TABLE_81__ACPILevel_GnbSlow_MASK 0xff0000
#define DPM_TABLE_81__ACPILevel_GnbSlow__SHIFT 0x10
#define DPM_TABLE_81__ACPILevel_SclkDid_MASK 0xff000000
#define DPM_TABLE_81__ACPILevel_SclkDid__SHIFT 0x18
#define DPM_TABLE_82__ACPILevel_padding_2_MASK 0xff
#define DPM_TABLE_82__ACPILevel_padding_2__SHIFT 0x0
#define DPM_TABLE_82__ACPILevel_padding_1_MASK 0xff00
#define DPM_TABLE_82__ACPILevel_padding_1__SHIFT 0x8
#define DPM_TABLE_82__ACPILevel_padding_0_MASK 0xff0000
#define DPM_TABLE_82__ACPILevel_padding_0__SHIFT 0x10
#define DPM_TABLE_82__ACPILevel_DeepSleepDivId_MASK 0xff000000
#define DPM_TABLE_82__ACPILevel_DeepSleepDivId__SHIFT 0x18
#define DPM_TABLE_83__UvdLevel_0_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_83__UvdLevel_0_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_84__UvdLevel_0_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_84__UvdLevel_0_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_85__UvdLevel_0_DclkDivider_MASK 0xff
#define DPM_TABLE_85__UvdLevel_0_DclkDivider__SHIFT 0x0
#define DPM_TABLE_85__UvdLevel_0_VclkDivider_MASK 0xff00
#define DPM_TABLE_85__UvdLevel_0_VclkDivider__SHIFT 0x8
#define DPM_TABLE_85__UvdLevel_0_MinVddNb_MASK 0xffff0000
#define DPM_TABLE_85__UvdLevel_0_MinVddNb__SHIFT 0x10
#define DPM_TABLE_86__UvdLevel_0_padding_1_MASK 0xff
#define DPM_TABLE_86__UvdLevel_0_padding_1__SHIFT 0x0
#define DPM_TABLE_86__UvdLevel_0_padding_0_MASK 0xff00
#define DPM_TABLE_86__UvdLevel_0_padding_0__SHIFT 0x8
#define DPM_TABLE_86__UvdLevel_0_DClkBypassCntl_MASK 0xff0000
#define DPM_TABLE_86__UvdLevel_0_DClkBypassCntl__SHIFT 0x10
#define DPM_TABLE_86__UvdLevel_0_VClkBypassCntl_MASK 0xff000000
#define DPM_TABLE_86__UvdLevel_0_VClkBypassCntl__SHIFT 0x18
#define DPM_TABLE_87__UvdLevel_1_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_87__UvdLevel_1_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_88__UvdLevel_1_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_88__UvdLevel_1_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_89__UvdLevel_1_DclkDivider_MASK 0xff
#define DPM_TABLE_89__UvdLevel_1_DclkDivider__SHIFT 0x0
#define DPM_TABLE_89__UvdLevel_1_VclkDivider_MASK 0xff00
#define DPM_TABLE_89__UvdLevel_1_VclkDivider__SHIFT 0x8
#define DPM_TABLE_89__UvdLevel_1_MinVddNb_MASK 0xffff0000
#define DPM_TABLE_89__UvdLevel_1_MinVddNb__SHIFT 0x10
#define DPM_TABLE_90__UvdLevel_1_padding_1_MASK 0xff
#define DPM_TABLE_90__UvdLevel_1_padding_1__SHIFT 0x0
#define DPM_TABLE_90__UvdLevel_1_padding_0_MASK 0xff00
#define DPM_TABLE_90__UvdLevel_1_padding_0__SHIFT 0x8
#define DPM_TABLE_90__UvdLevel_1_DClkBypassCntl_MASK 0xff0000
#define DPM_TABLE_90__UvdLevel_1_DClkBypassCntl__SHIFT 0x10
#define DPM_TABLE_90__UvdLevel_1_VClkBypassCntl_MASK 0xff000000
#define DPM_TABLE_90__UvdLevel_1_VClkBypassCntl__SHIFT 0x18
#define DPM_TABLE_91__UvdLevel_2_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_91__UvdLevel_2_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_92__UvdLevel_2_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_92__UvdLevel_2_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_93__UvdLevel_2_DclkDivider_MASK 0xff
#define DPM_TABLE_93__UvdLevel_2_DclkDivider__SHIFT 0x0
#define DPM_TABLE_93__UvdLevel_2_VclkDivider_MASK 0xff00
#define DPM_TABLE_93__UvdLevel_2_VclkDivider__SHIFT 0x8
#define DPM_TABLE_93__UvdLevel_2_MinVddNb_MASK 0xffff0000
#define DPM_TABLE_93__UvdLevel_2_MinVddNb__SHIFT 0x10
#define DPM_TABLE_94__UvdLevel_2_padding_1_MASK 0xff
#define DPM_TABLE_94__UvdLevel_2_padding_1__SHIFT 0x0
#define DPM_TABLE_94__UvdLevel_2_padding_0_MASK 0xff00
#define DPM_TABLE_94__UvdLevel_2_padding_0__SHIFT 0x8
#define DPM_TABLE_94__UvdLevel_2_DClkBypassCntl_MASK 0xff0000
#define DPM_TABLE_94__UvdLevel_2_DClkBypassCntl__SHIFT 0x10
#define DPM_TABLE_94__UvdLevel_2_VClkBypassCntl_MASK 0xff000000
#define DPM_TABLE_94__UvdLevel_2_VClkBypassCntl__SHIFT 0x18
#define DPM_TABLE_95__UvdLevel_3_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_95__UvdLevel_3_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_96__UvdLevel_3_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_96__UvdLevel_3_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_97__UvdLevel_3_DclkDivider_MASK 0xff
#define DPM_TABLE_97__UvdLevel_3_DclkDivider__SHIFT 0x0
#define DPM_TABLE_97__UvdLevel_3_VclkDivider_MASK 0xff00
#define DPM_TABLE_97__UvdLevel_3_VclkDivider__SHIFT 0x8
#define DPM_TABLE_97__UvdLevel_3_MinVddNb_MASK 0xffff0000
#define DPM_TABLE_97__UvdLevel_3_MinVddNb__SHIFT 0x10
#define DPM_TABLE_98__UvdLevel_3_padding_1_MASK 0xff
#define DPM_TABLE_98__UvdLevel_3_padding_1__SHIFT 0x0
#define DPM_TABLE_98__UvdLevel_3_padding_0_MASK 0xff00
#define DPM_TABLE_98__UvdLevel_3_padding_0__SHIFT 0x8
#define DPM_TABLE_98__UvdLevel_3_DClkBypassCntl_MASK 0xff0000
#define DPM_TABLE_98__UvdLevel_3_DClkBypassCntl__SHIFT 0x10
#define DPM_TABLE_98__UvdLevel_3_VClkBypassCntl_MASK 0xff000000
#define DPM_TABLE_98__UvdLevel_3_VClkBypassCntl__SHIFT 0x18
#define DPM_TABLE_99__UvdLevel_4_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_99__UvdLevel_4_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_100__UvdLevel_4_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_100__UvdLevel_4_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_101__UvdLevel_4_DclkDivider_MASK 0xff
#define DPM_TABLE_101__UvdLevel_4_DclkDivider__SHIFT 0x0
#define DPM_TABLE_101__UvdLevel_4_VclkDivider_MASK 0xff00
#define DPM_TABLE_101__UvdLevel_4_VclkDivider__SHIFT 0x8
#define DPM_TABLE_101__UvdLevel_4_MinVddNb_MASK 0xffff0000
#define DPM_TABLE_101__UvdLevel_4_MinVddNb__SHIFT 0x10
#define DPM_TABLE_102__UvdLevel_4_padding_1_MASK 0xff
#define DPM_TABLE_102__UvdLevel_4_padding_1__SHIFT 0x0
#define DPM_TABLE_102__UvdLevel_4_padding_0_MASK 0xff00
#define DPM_TABLE_102__UvdLevel_4_padding_0__SHIFT 0x8
#define DPM_TABLE_102__UvdLevel_4_DClkBypassCntl_MASK 0xff0000
#define DPM_TABLE_102__UvdLevel_4_DClkBypassCntl__SHIFT 0x10
#define DPM_TABLE_102__UvdLevel_4_VClkBypassCntl_MASK 0xff000000
#define DPM_TABLE_102__UvdLevel_4_VClkBypassCntl__SHIFT 0x18
#define DPM_TABLE_103__UvdLevel_5_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_103__UvdLevel_5_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_104__UvdLevel_5_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_104__UvdLevel_5_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_105__UvdLevel_5_DclkDivider_MASK 0xff
#define DPM_TABLE_105__UvdLevel_5_DclkDivider__SHIFT 0x0
#define DPM_TABLE_105__UvdLevel_5_VclkDivider_MASK 0xff00
#define DPM_TABLE_105__UvdLevel_5_VclkDivider__SHIFT 0x8
#define DPM_TABLE_105__UvdLevel_5_MinVddNb_MASK 0xffff0000
#define DPM_TABLE_105__UvdLevel_5_MinVddNb__SHIFT 0x10
#define DPM_TABLE_106__UvdLevel_5_padding_1_MASK 0xff
#define DPM_TABLE_106__UvdLevel_5_padding_1__SHIFT 0x0
#define DPM_TABLE_106__UvdLevel_5_padding_0_MASK 0xff00
#define DPM_TABLE_106__UvdLevel_5_padding_0__SHIFT 0x8
#define DPM_TABLE_106__UvdLevel_5_DClkBypassCntl_MASK 0xff0000
#define DPM_TABLE_106__UvdLevel_5_DClkBypassCntl__SHIFT 0x10
#define DPM_TABLE_106__UvdLevel_5_VClkBypassCntl_MASK 0xff000000
#define DPM_TABLE_106__UvdLevel_5_VClkBypassCntl__SHIFT 0x18
#define DPM_TABLE_107__UvdLevel_6_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_107__UvdLevel_6_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_108__UvdLevel_6_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_108__UvdLevel_6_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_109__UvdLevel_6_DclkDivider_MASK 0xff
#define DPM_TABLE_109__UvdLevel_6_DclkDivider__SHIFT 0x0
#define DPM_TABLE_109__UvdLevel_6_VclkDivider_MASK 0xff00
#define DPM_TABLE_109__UvdLevel_6_VclkDivider__SHIFT 0x8
#define DPM_TABLE_109__UvdLevel_6_MinVddNb_MASK 0xffff0000
#define DPM_TABLE_109__UvdLevel_6_MinVddNb__SHIFT 0x10
#define DPM_TABLE_110__UvdLevel_6_padding_1_MASK 0xff
#define DPM_TABLE_110__UvdLevel_6_padding_1__SHIFT 0x0
#define DPM_TABLE_110__UvdLevel_6_padding_0_MASK 0xff00
#define DPM_TABLE_110__UvdLevel_6_padding_0__SHIFT 0x8
#define DPM_TABLE_110__UvdLevel_6_DClkBypassCntl_MASK 0xff0000
#define DPM_TABLE_110__UvdLevel_6_DClkBypassCntl__SHIFT 0x10
#define DPM_TABLE_110__UvdLevel_6_VClkBypassCntl_MASK 0xff000000
#define DPM_TABLE_110__UvdLevel_6_VClkBypassCntl__SHIFT 0x18
#define DPM_TABLE_111__UvdLevel_7_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_111__UvdLevel_7_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_112__UvdLevel_7_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_112__UvdLevel_7_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_113__UvdLevel_7_DclkDivider_MASK 0xff
#define DPM_TABLE_113__UvdLevel_7_DclkDivider__SHIFT 0x0
#define DPM_TABLE_113__UvdLevel_7_VclkDivider_MASK 0xff00
#define DPM_TABLE_113__UvdLevel_7_VclkDivider__SHIFT 0x8
#define DPM_TABLE_113__UvdLevel_7_MinVddNb_MASK 0xffff0000
#define DPM_TABLE_113__UvdLevel_7_MinVddNb__SHIFT 0x10
#define DPM_TABLE_114__UvdLevel_7_padding_1_MASK 0xff
#define DPM_TABLE_114__UvdLevel_7_padding_1__SHIFT 0x0
#define DPM_TABLE_114__UvdLevel_7_padding_0_MASK 0xff00
#define DPM_TABLE_114__UvdLevel_7_padding_0__SHIFT 0x8
#define DPM_TABLE_114__UvdLevel_7_DClkBypassCntl_MASK 0xff0000
#define DPM_TABLE_114__UvdLevel_7_DClkBypassCntl__SHIFT 0x10
#define DPM_TABLE_114__UvdLevel_7_VClkBypassCntl_MASK 0xff000000
#define DPM_TABLE_114__UvdLevel_7_VClkBypassCntl__SHIFT 0x18
#define DPM_TABLE_115__VceLevel_0_Frequency_MASK 0xffffffff
#define DPM_TABLE_115__VceLevel_0_Frequency__SHIFT 0x0
#define DPM_TABLE_116__VceLevel_0_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_116__VceLevel_0_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_116__VceLevel_0_Divider_MASK 0xff00
#define DPM_TABLE_116__VceLevel_0_Divider__SHIFT 0x8
#define DPM_TABLE_116__VceLevel_0_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_116__VceLevel_0_MinVoltage__SHIFT 0x10
#define DPM_TABLE_117__VceLevel_0_Reserved_MASK 0xffffffff
#define DPM_TABLE_117__VceLevel_0_Reserved__SHIFT 0x0
#define DPM_TABLE_118__VceLevel_1_Frequency_MASK 0xffffffff
#define DPM_TABLE_118__VceLevel_1_Frequency__SHIFT 0x0
#define DPM_TABLE_119__VceLevel_1_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_119__VceLevel_1_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_119__VceLevel_1_Divider_MASK 0xff00
#define DPM_TABLE_119__VceLevel_1_Divider__SHIFT 0x8
#define DPM_TABLE_119__VceLevel_1_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_119__VceLevel_1_MinVoltage__SHIFT 0x10
#define DPM_TABLE_120__VceLevel_1_Reserved_MASK 0xffffffff
#define DPM_TABLE_120__VceLevel_1_Reserved__SHIFT 0x0
#define DPM_TABLE_121__VceLevel_2_Frequency_MASK 0xffffffff
#define DPM_TABLE_121__VceLevel_2_Frequency__SHIFT 0x0
#define DPM_TABLE_122__VceLevel_2_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_122__VceLevel_2_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_122__VceLevel_2_Divider_MASK 0xff00
#define DPM_TABLE_122__VceLevel_2_Divider__SHIFT 0x8
#define DPM_TABLE_122__VceLevel_2_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_122__VceLevel_2_MinVoltage__SHIFT 0x10
#define DPM_TABLE_123__VceLevel_2_Reserved_MASK 0xffffffff
#define DPM_TABLE_123__VceLevel_2_Reserved__SHIFT 0x0
#define DPM_TABLE_124__VceLevel_3_Frequency_MASK 0xffffffff
#define DPM_TABLE_124__VceLevel_3_Frequency__SHIFT 0x0
#define DPM_TABLE_125__VceLevel_3_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_125__VceLevel_3_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_125__VceLevel_3_Divider_MASK 0xff00
#define DPM_TABLE_125__VceLevel_3_Divider__SHIFT 0x8
#define DPM_TABLE_125__VceLevel_3_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_125__VceLevel_3_MinVoltage__SHIFT 0x10
#define DPM_TABLE_126__VceLevel_3_Reserved_MASK 0xffffffff
#define DPM_TABLE_126__VceLevel_3_Reserved__SHIFT 0x0
#define DPM_TABLE_127__VceLevel_4_Frequency_MASK 0xffffffff
#define DPM_TABLE_127__VceLevel_4_Frequency__SHIFT 0x0
#define DPM_TABLE_128__VceLevel_4_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_128__VceLevel_4_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_128__VceLevel_4_Divider_MASK 0xff00
#define DPM_TABLE_128__VceLevel_4_Divider__SHIFT 0x8
#define DPM_TABLE_128__VceLevel_4_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_128__VceLevel_4_MinVoltage__SHIFT 0x10
#define DPM_TABLE_129__VceLevel_4_Reserved_MASK 0xffffffff
#define DPM_TABLE_129__VceLevel_4_Reserved__SHIFT 0x0
#define DPM_TABLE_130__VceLevel_5_Frequency_MASK 0xffffffff
#define DPM_TABLE_130__VceLevel_5_Frequency__SHIFT 0x0
#define DPM_TABLE_131__VceLevel_5_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_131__VceLevel_5_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_131__VceLevel_5_Divider_MASK 0xff00
#define DPM_TABLE_131__VceLevel_5_Divider__SHIFT 0x8
#define DPM_TABLE_131__VceLevel_5_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_131__VceLevel_5_MinVoltage__SHIFT 0x10
#define DPM_TABLE_132__VceLevel_5_Reserved_MASK 0xffffffff
#define DPM_TABLE_132__VceLevel_5_Reserved__SHIFT 0x0
#define DPM_TABLE_133__VceLevel_6_Frequency_MASK 0xffffffff
#define DPM_TABLE_133__VceLevel_6_Frequency__SHIFT 0x0
#define DPM_TABLE_134__VceLevel_6_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_134__VceLevel_6_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_134__VceLevel_6_Divider_MASK 0xff00
#define DPM_TABLE_134__VceLevel_6_Divider__SHIFT 0x8
#define DPM_TABLE_134__VceLevel_6_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_134__VceLevel_6_MinVoltage__SHIFT 0x10
#define DPM_TABLE_135__VceLevel_6_Reserved_MASK 0xffffffff
#define DPM_TABLE_135__VceLevel_6_Reserved__SHIFT 0x0
#define DPM_TABLE_136__VceLevel_7_Frequency_MASK 0xffffffff
#define DPM_TABLE_136__VceLevel_7_Frequency__SHIFT 0x0
#define DPM_TABLE_137__VceLevel_7_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_137__VceLevel_7_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_137__VceLevel_7_Divider_MASK 0xff00
#define DPM_TABLE_137__VceLevel_7_Divider__SHIFT 0x8
#define DPM_TABLE_137__VceLevel_7_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_137__VceLevel_7_MinVoltage__SHIFT 0x10
#define DPM_TABLE_138__VceLevel_7_Reserved_MASK 0xffffffff
#define DPM_TABLE_138__VceLevel_7_Reserved__SHIFT 0x0
#define DPM_TABLE_139__AcpLevel_0_Frequency_MASK 0xffffffff
#define DPM_TABLE_139__AcpLevel_0_Frequency__SHIFT 0x0
#define DPM_TABLE_140__AcpLevel_0_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_140__AcpLevel_0_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_140__AcpLevel_0_Divider_MASK 0xff00
#define DPM_TABLE_140__AcpLevel_0_Divider__SHIFT 0x8
#define DPM_TABLE_140__AcpLevel_0_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_140__AcpLevel_0_MinVoltage__SHIFT 0x10
#define DPM_TABLE_141__AcpLevel_0_Reserved_MASK 0xffffffff
#define DPM_TABLE_141__AcpLevel_0_Reserved__SHIFT 0x0
#define DPM_TABLE_142__AcpLevel_1_Frequency_MASK 0xffffffff
#define DPM_TABLE_142__AcpLevel_1_Frequency__SHIFT 0x0
#define DPM_TABLE_143__AcpLevel_1_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_143__AcpLevel_1_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_143__AcpLevel_1_Divider_MASK 0xff00
#define DPM_TABLE_143__AcpLevel_1_Divider__SHIFT 0x8
#define DPM_TABLE_143__AcpLevel_1_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_143__AcpLevel_1_MinVoltage__SHIFT 0x10
#define DPM_TABLE_144__AcpLevel_1_Reserved_MASK 0xffffffff
#define DPM_TABLE_144__AcpLevel_1_Reserved__SHIFT 0x0
#define DPM_TABLE_145__AcpLevel_2_Frequency_MASK 0xffffffff
#define DPM_TABLE_145__AcpLevel_2_Frequency__SHIFT 0x0
#define DPM_TABLE_146__AcpLevel_2_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_146__AcpLevel_2_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_146__AcpLevel_2_Divider_MASK 0xff00
#define DPM_TABLE_146__AcpLevel_2_Divider__SHIFT 0x8
#define DPM_TABLE_146__AcpLevel_2_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_146__AcpLevel_2_MinVoltage__SHIFT 0x10
#define DPM_TABLE_147__AcpLevel_2_Reserved_MASK 0xffffffff
#define DPM_TABLE_147__AcpLevel_2_Reserved__SHIFT 0x0
#define DPM_TABLE_148__AcpLevel_3_Frequency_MASK 0xffffffff
#define DPM_TABLE_148__AcpLevel_3_Frequency__SHIFT 0x0
#define DPM_TABLE_149__AcpLevel_3_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_149__AcpLevel_3_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_149__AcpLevel_3_Divider_MASK 0xff00
#define DPM_TABLE_149__AcpLevel_3_Divider__SHIFT 0x8
#define DPM_TABLE_149__AcpLevel_3_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_149__AcpLevel_3_MinVoltage__SHIFT 0x10
#define DPM_TABLE_150__AcpLevel_3_Reserved_MASK 0xffffffff
#define DPM_TABLE_150__AcpLevel_3_Reserved__SHIFT 0x0
#define DPM_TABLE_151__AcpLevel_4_Frequency_MASK 0xffffffff
#define DPM_TABLE_151__AcpLevel_4_Frequency__SHIFT 0x0
#define DPM_TABLE_152__AcpLevel_4_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_152__AcpLevel_4_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_152__AcpLevel_4_Divider_MASK 0xff00
#define DPM_TABLE_152__AcpLevel_4_Divider__SHIFT 0x8
#define DPM_TABLE_152__AcpLevel_4_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_152__AcpLevel_4_MinVoltage__SHIFT 0x10
#define DPM_TABLE_153__AcpLevel_4_Reserved_MASK 0xffffffff
#define DPM_TABLE_153__AcpLevel_4_Reserved__SHIFT 0x0
#define DPM_TABLE_154__AcpLevel_5_Frequency_MASK 0xffffffff
#define DPM_TABLE_154__AcpLevel_5_Frequency__SHIFT 0x0
#define DPM_TABLE_155__AcpLevel_5_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_155__AcpLevel_5_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_155__AcpLevel_5_Divider_MASK 0xff00
#define DPM_TABLE_155__AcpLevel_5_Divider__SHIFT 0x8
#define DPM_TABLE_155__AcpLevel_5_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_155__AcpLevel_5_MinVoltage__SHIFT 0x10
#define DPM_TABLE_156__AcpLevel_5_Reserved_MASK 0xffffffff
#define DPM_TABLE_156__AcpLevel_5_Reserved__SHIFT 0x0
#define DPM_TABLE_157__AcpLevel_6_Frequency_MASK 0xffffffff
#define DPM_TABLE_157__AcpLevel_6_Frequency__SHIFT 0x0
#define DPM_TABLE_158__AcpLevel_6_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_158__AcpLevel_6_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_158__AcpLevel_6_Divider_MASK 0xff00
#define DPM_TABLE_158__AcpLevel_6_Divider__SHIFT 0x8
#define DPM_TABLE_158__AcpLevel_6_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_158__AcpLevel_6_MinVoltage__SHIFT 0x10
#define DPM_TABLE_159__AcpLevel_6_Reserved_MASK 0xffffffff
#define DPM_TABLE_159__AcpLevel_6_Reserved__SHIFT 0x0
#define DPM_TABLE_160__AcpLevel_7_Frequency_MASK 0xffffffff
#define DPM_TABLE_160__AcpLevel_7_Frequency__SHIFT 0x0
#define DPM_TABLE_161__AcpLevel_7_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_161__AcpLevel_7_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_161__AcpLevel_7_Divider_MASK 0xff00
#define DPM_TABLE_161__AcpLevel_7_Divider__SHIFT 0x8
#define DPM_TABLE_161__AcpLevel_7_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_161__AcpLevel_7_MinVoltage__SHIFT 0x10
#define DPM_TABLE_162__AcpLevel_7_Reserved_MASK 0xffffffff
#define DPM_TABLE_162__AcpLevel_7_Reserved__SHIFT 0x0
#define DPM_TABLE_163__SamuLevel_0_Frequency_MASK 0xffffffff
#define DPM_TABLE_163__SamuLevel_0_Frequency__SHIFT 0x0
#define DPM_TABLE_164__SamuLevel_0_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_164__SamuLevel_0_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_164__SamuLevel_0_Divider_MASK 0xff00
#define DPM_TABLE_164__SamuLevel_0_Divider__SHIFT 0x8
#define DPM_TABLE_164__SamuLevel_0_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_164__SamuLevel_0_MinVoltage__SHIFT 0x10
#define DPM_TABLE_165__SamuLevel_0_Reserved_MASK 0xffffffff
#define DPM_TABLE_165__SamuLevel_0_Reserved__SHIFT 0x0
#define DPM_TABLE_166__SamuLevel_1_Frequency_MASK 0xffffffff
#define DPM_TABLE_166__SamuLevel_1_Frequency__SHIFT 0x0
#define DPM_TABLE_167__SamuLevel_1_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_167__SamuLevel_1_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_167__SamuLevel_1_Divider_MASK 0xff00
#define DPM_TABLE_167__SamuLevel_1_Divider__SHIFT 0x8
#define DPM_TABLE_167__SamuLevel_1_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_167__SamuLevel_1_MinVoltage__SHIFT 0x10
#define DPM_TABLE_168__SamuLevel_1_Reserved_MASK 0xffffffff
#define DPM_TABLE_168__SamuLevel_1_Reserved__SHIFT 0x0
#define DPM_TABLE_169__SamuLevel_2_Frequency_MASK 0xffffffff
#define DPM_TABLE_169__SamuLevel_2_Frequency__SHIFT 0x0
#define DPM_TABLE_170__SamuLevel_2_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_170__SamuLevel_2_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_170__SamuLevel_2_Divider_MASK 0xff00
#define DPM_TABLE_170__SamuLevel_2_Divider__SHIFT 0x8
#define DPM_TABLE_170__SamuLevel_2_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_170__SamuLevel_2_MinVoltage__SHIFT 0x10
#define DPM_TABLE_171__SamuLevel_2_Reserved_MASK 0xffffffff
#define DPM_TABLE_171__SamuLevel_2_Reserved__SHIFT 0x0
#define DPM_TABLE_172__SamuLevel_3_Frequency_MASK 0xffffffff
#define DPM_TABLE_172__SamuLevel_3_Frequency__SHIFT 0x0
#define DPM_TABLE_173__SamuLevel_3_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_173__SamuLevel_3_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_173__SamuLevel_3_Divider_MASK 0xff00
#define DPM_TABLE_173__SamuLevel_3_Divider__SHIFT 0x8
#define DPM_TABLE_173__SamuLevel_3_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_173__SamuLevel_3_MinVoltage__SHIFT 0x10
#define DPM_TABLE_174__SamuLevel_3_Reserved_MASK 0xffffffff
#define DPM_TABLE_174__SamuLevel_3_Reserved__SHIFT 0x0
#define DPM_TABLE_175__SamuLevel_4_Frequency_MASK 0xffffffff
#define DPM_TABLE_175__SamuLevel_4_Frequency__SHIFT 0x0
#define DPM_TABLE_176__SamuLevel_4_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_176__SamuLevel_4_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_176__SamuLevel_4_Divider_MASK 0xff00
#define DPM_TABLE_176__SamuLevel_4_Divider__SHIFT 0x8
#define DPM_TABLE_176__SamuLevel_4_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_176__SamuLevel_4_MinVoltage__SHIFT 0x10
#define DPM_TABLE_177__SamuLevel_4_Reserved_MASK 0xffffffff
#define DPM_TABLE_177__SamuLevel_4_Reserved__SHIFT 0x0
#define DPM_TABLE_178__SamuLevel_5_Frequency_MASK 0xffffffff
#define DPM_TABLE_178__SamuLevel_5_Frequency__SHIFT 0x0
#define DPM_TABLE_179__SamuLevel_5_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_179__SamuLevel_5_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_179__SamuLevel_5_Divider_MASK 0xff00
#define DPM_TABLE_179__SamuLevel_5_Divider__SHIFT 0x8
#define DPM_TABLE_179__SamuLevel_5_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_179__SamuLevel_5_MinVoltage__SHIFT 0x10
#define DPM_TABLE_180__SamuLevel_5_Reserved_MASK 0xffffffff
#define DPM_TABLE_180__SamuLevel_5_Reserved__SHIFT 0x0
#define DPM_TABLE_181__SamuLevel_6_Frequency_MASK 0xffffffff
#define DPM_TABLE_181__SamuLevel_6_Frequency__SHIFT 0x0
#define DPM_TABLE_182__SamuLevel_6_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_182__SamuLevel_6_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_182__SamuLevel_6_Divider_MASK 0xff00
#define DPM_TABLE_182__SamuLevel_6_Divider__SHIFT 0x8
#define DPM_TABLE_182__SamuLevel_6_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_182__SamuLevel_6_MinVoltage__SHIFT 0x10
#define DPM_TABLE_183__SamuLevel_6_Reserved_MASK 0xffffffff
#define DPM_TABLE_183__SamuLevel_6_Reserved__SHIFT 0x0
#define DPM_TABLE_184__SamuLevel_7_Frequency_MASK 0xffffffff
#define DPM_TABLE_184__SamuLevel_7_Frequency__SHIFT 0x0
#define DPM_TABLE_185__SamuLevel_7_ClkBypassCntl_MASK 0xff
#define DPM_TABLE_185__SamuLevel_7_ClkBypassCntl__SHIFT 0x0
#define DPM_TABLE_185__SamuLevel_7_Divider_MASK 0xff00
#define DPM_TABLE_185__SamuLevel_7_Divider__SHIFT 0x8
#define DPM_TABLE_185__SamuLevel_7_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_185__SamuLevel_7_MinVoltage__SHIFT 0x10
#define DPM_TABLE_186__SamuLevel_7_Reserved_MASK 0xffffffff
#define DPM_TABLE_186__SamuLevel_7_Reserved__SHIFT 0x0
#define DPM_TABLE_187__SamuBootLevel_MASK 0xff
#define DPM_TABLE_187__SamuBootLevel__SHIFT 0x0
#define DPM_TABLE_187__AcpBootLevel_MASK 0xff00
#define DPM_TABLE_187__AcpBootLevel__SHIFT 0x8
#define DPM_TABLE_187__VceBootLevel_MASK 0xff0000
#define DPM_TABLE_187__VceBootLevel__SHIFT 0x10
#define DPM_TABLE_187__UvdBootLevel_MASK 0xff000000
#define DPM_TABLE_187__UvdBootLevel__SHIFT 0x18
#define DPM_TABLE_188__SAMUInterval_MASK 0xff
#define DPM_TABLE_188__SAMUInterval__SHIFT 0x0
#define DPM_TABLE_188__ACPInterval_MASK 0xff00
#define DPM_TABLE_188__ACPInterval__SHIFT 0x8
#define DPM_TABLE_188__VCEInterval_MASK 0xff0000
#define DPM_TABLE_188__VCEInterval__SHIFT 0x10
#define DPM_TABLE_188__UVDInterval_MASK 0xff000000
#define DPM_TABLE_188__UVDInterval__SHIFT 0x18
#define DPM_TABLE_189__GraphicsVoltageChangeEnable_MASK 0xff
#define DPM_TABLE_189__GraphicsVoltageChangeEnable__SHIFT 0x0
#define DPM_TABLE_189__GraphicsThermThrottleEnable_MASK 0xff00
#define DPM_TABLE_189__GraphicsThermThrottleEnable__SHIFT 0x8
#define DPM_TABLE_189__GraphicsInterval_MASK 0xff0000
#define DPM_TABLE_189__GraphicsInterval__SHIFT 0x10
#define DPM_TABLE_189__GraphicsBootLevel_MASK 0xff000000
#define DPM_TABLE_189__GraphicsBootLevel__SHIFT 0x18
#define DPM_TABLE_190__FpsLowThreshold_MASK 0xffff
#define DPM_TABLE_190__FpsLowThreshold__SHIFT 0x0
#define DPM_TABLE_190__GraphicsClkSlowDivider_MASK 0xff0000
#define DPM_TABLE_190__GraphicsClkSlowDivider__SHIFT 0x10
#define DPM_TABLE_190__GraphicsClkSlowEnable_MASK 0xff000000
#define DPM_TABLE_190__GraphicsClkSlowEnable__SHIFT 0x18
#define DPM_TABLE_191__DisplayCac_MASK 0xffffffff
#define DPM_TABLE_191__DisplayCac__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_1__RefClockFrequency_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_1__RefClockFrequency__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_2__PmTimerPeriod_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_2__PmTimerPeriod__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_3__FeatureEnables_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_3__FeatureEnables__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_4__HandshakeDisables_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_4__HandshakeDisables__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_5__DisplayPhy4Config_MASK 0xff
#define SOFT_REGISTERS_TABLE_5__DisplayPhy4Config__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_5__DisplayPhy3Config_MASK 0xff00
#define SOFT_REGISTERS_TABLE_5__DisplayPhy3Config__SHIFT 0x8
#define SOFT_REGISTERS_TABLE_5__DisplayPhy2Config_MASK 0xff0000
#define SOFT_REGISTERS_TABLE_5__DisplayPhy2Config__SHIFT 0x10
#define SOFT_REGISTERS_TABLE_5__DisplayPhy1Config_MASK 0xff000000
#define SOFT_REGISTERS_TABLE_5__DisplayPhy1Config__SHIFT 0x18
#define SOFT_REGISTERS_TABLE_6__DisplayPhy8Config_MASK 0xff
#define SOFT_REGISTERS_TABLE_6__DisplayPhy8Config__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_6__DisplayPhy7Config_MASK 0xff00
#define SOFT_REGISTERS_TABLE_6__DisplayPhy7Config__SHIFT 0x8
#define SOFT_REGISTERS_TABLE_6__DisplayPhy6Config_MASK 0xff0000
#define SOFT_REGISTERS_TABLE_6__DisplayPhy6Config__SHIFT 0x10
#define SOFT_REGISTERS_TABLE_6__DisplayPhy5Config_MASK 0xff000000
#define SOFT_REGISTERS_TABLE_6__DisplayPhy5Config__SHIFT 0x18
#define SOFT_REGISTERS_TABLE_7__AverageGraphicsActivity_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_7__AverageGraphicsActivity__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_8__AverageMemoryActivity_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_8__AverageMemoryActivity__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_9__AverageGioActivity_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_9__AverageGioActivity__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_10__PCIeDpmEnabledLevels_MASK 0xff
#define SOFT_REGISTERS_TABLE_10__PCIeDpmEnabledLevels__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_10__LClkDpmEnabledLevels_MASK 0xff00
#define SOFT_REGISTERS_TABLE_10__LClkDpmEnabledLevels__SHIFT 0x8
#define SOFT_REGISTERS_TABLE_10__MClkDpmEnabledLevels_MASK 0xff0000
#define SOFT_REGISTERS_TABLE_10__MClkDpmEnabledLevels__SHIFT 0x10
#define SOFT_REGISTERS_TABLE_10__SClkDpmEnabledLevels_MASK 0xff000000
#define SOFT_REGISTERS_TABLE_10__SClkDpmEnabledLevels__SHIFT 0x18
#define SOFT_REGISTERS_TABLE_11__VCEDpmEnabledLevels_MASK 0xff
#define SOFT_REGISTERS_TABLE_11__VCEDpmEnabledLevels__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_11__ACPDpmEnabledLevels_MASK 0xff00
#define SOFT_REGISTERS_TABLE_11__ACPDpmEnabledLevels__SHIFT 0x8
#define SOFT_REGISTERS_TABLE_11__SAMUDpmEnabledLevels_MASK 0xff0000
#define SOFT_REGISTERS_TABLE_11__SAMUDpmEnabledLevels__SHIFT 0x10
#define SOFT_REGISTERS_TABLE_11__UVDDpmEnabledLevels_MASK 0xff000000
#define SOFT_REGISTERS_TABLE_11__UVDDpmEnabledLevels__SHIFT 0x18
#define SOFT_REGISTERS_TABLE_12__Reserved_0_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_12__Reserved_0__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_13__Reserved_1_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_13__Reserved_1__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_14__Reserved_2_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_14__Reserved_2__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_15__Reserved_3_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_15__Reserved_3__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_16__Reserved_4_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_16__Reserved_4__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_17__Reserved_5_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_17__Reserved_5__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_18__Reserved_6_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_18__Reserved_6__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_19__Reserved_7_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_19__Reserved_7__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_20__Reserved_8_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_20__Reserved_8__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_21__Reserved_9_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_21__Reserved_9__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_0_CNTL_0__LOW_VOLTAGE_REQ_THRESHOLD_MASK 0xff
#define SMU_LCLK_DPM_STATE_0_CNTL_0__LOW_VOLTAGE_REQ_THRESHOLD__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_0_CNTL_0__VID_MASK 0xff00
#define SMU_LCLK_DPM_STATE_0_CNTL_0__VID__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_0_CNTL_0__CLK_DIVIDER_MASK 0xff0000
#define SMU_LCLK_DPM_STATE_0_CNTL_0__CLK_DIVIDER__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_0_CNTL_0__STATE_VALID_MASK 0xff000000
#define SMU_LCLK_DPM_STATE_0_CNTL_0__STATE_VALID__SHIFT 0x18
#define SMU_LCLK_DPM_STATE_1_CNTL_0__LOW_VOLTAGE_REQ_THRESHOLD_MASK 0xff
#define SMU_LCLK_DPM_STATE_1_CNTL_0__LOW_VOLTAGE_REQ_THRESHOLD__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_1_CNTL_0__VID_MASK 0xff00
#define SMU_LCLK_DPM_STATE_1_CNTL_0__VID__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_1_CNTL_0__CLK_DIVIDER_MASK 0xff0000
#define SMU_LCLK_DPM_STATE_1_CNTL_0__CLK_DIVIDER__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_1_CNTL_0__STATE_VALID_MASK 0xff000000
#define SMU_LCLK_DPM_STATE_1_CNTL_0__STATE_VALID__SHIFT 0x18
#define SMU_LCLK_DPM_STATE_2_CNTL_0__LOW_VOLTAGE_REQ_THRESHOLD_MASK 0xff
#define SMU_LCLK_DPM_STATE_2_CNTL_0__LOW_VOLTAGE_REQ_THRESHOLD__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_2_CNTL_0__VID_MASK 0xff00
#define SMU_LCLK_DPM_STATE_2_CNTL_0__VID__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_2_CNTL_0__CLK_DIVIDER_MASK 0xff0000
#define SMU_LCLK_DPM_STATE_2_CNTL_0__CLK_DIVIDER__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_2_CNTL_0__STATE_VALID_MASK 0xff000000
#define SMU_LCLK_DPM_STATE_2_CNTL_0__STATE_VALID__SHIFT 0x18
#define SMU_LCLK_DPM_STATE_3_CNTL_0__LOW_VOLTAGE_REQ_THRESHOLD_MASK 0xff
#define SMU_LCLK_DPM_STATE_3_CNTL_0__LOW_VOLTAGE_REQ_THRESHOLD__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_3_CNTL_0__VID_MASK 0xff00
#define SMU_LCLK_DPM_STATE_3_CNTL_0__VID__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_3_CNTL_0__CLK_DIVIDER_MASK 0xff0000
#define SMU_LCLK_DPM_STATE_3_CNTL_0__CLK_DIVIDER__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_3_CNTL_0__STATE_VALID_MASK 0xff000000
#define SMU_LCLK_DPM_STATE_3_CNTL_0__STATE_VALID__SHIFT 0x18
#define SMU_LCLK_DPM_STATE_4_CNTL_0__LOW_VOLTAGE_REQ_THRESHOLD_MASK 0xff
#define SMU_LCLK_DPM_STATE_4_CNTL_0__LOW_VOLTAGE_REQ_THRESHOLD__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_4_CNTL_0__VID_MASK 0xff00
#define SMU_LCLK_DPM_STATE_4_CNTL_0__VID__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_4_CNTL_0__CLK_DIVIDER_MASK 0xff0000
#define SMU_LCLK_DPM_STATE_4_CNTL_0__CLK_DIVIDER__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_4_CNTL_0__STATE_VALID_MASK 0xff000000
#define SMU_LCLK_DPM_STATE_4_CNTL_0__STATE_VALID__SHIFT 0x18
#define SMU_LCLK_DPM_STATE_5_CNTL_0__LOW_VOLTAGE_REQ_THRESHOLD_MASK 0xff
#define SMU_LCLK_DPM_STATE_5_CNTL_0__LOW_VOLTAGE_REQ_THRESHOLD__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_5_CNTL_0__VID_MASK 0xff00
#define SMU_LCLK_DPM_STATE_5_CNTL_0__VID__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_5_CNTL_0__CLK_DIVIDER_MASK 0xff0000
#define SMU_LCLK_DPM_STATE_5_CNTL_0__CLK_DIVIDER__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_5_CNTL_0__STATE_VALID_MASK 0xff000000
#define SMU_LCLK_DPM_STATE_5_CNTL_0__STATE_VALID__SHIFT 0x18
#define SMU_LCLK_DPM_STATE_6_CNTL_0__LOW_VOLTAGE_REQ_THRESHOLD_MASK 0xff
#define SMU_LCLK_DPM_STATE_6_CNTL_0__LOW_VOLTAGE_REQ_THRESHOLD__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_6_CNTL_0__VID_MASK 0xff00
#define SMU_LCLK_DPM_STATE_6_CNTL_0__VID__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_6_CNTL_0__CLK_DIVIDER_MASK 0xff0000
#define SMU_LCLK_DPM_STATE_6_CNTL_0__CLK_DIVIDER__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_6_CNTL_0__STATE_VALID_MASK 0xff000000
#define SMU_LCLK_DPM_STATE_6_CNTL_0__STATE_VALID__SHIFT 0x18
#define SMU_LCLK_DPM_STATE_7_CNTL_0__LOW_VOLTAGE_REQ_THRESHOLD_MASK 0xff
#define SMU_LCLK_DPM_STATE_7_CNTL_0__LOW_VOLTAGE_REQ_THRESHOLD__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_7_CNTL_0__VID_MASK 0xff00
#define SMU_LCLK_DPM_STATE_7_CNTL_0__VID__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_7_CNTL_0__CLK_DIVIDER_MASK 0xff0000
#define SMU_LCLK_DPM_STATE_7_CNTL_0__CLK_DIVIDER__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_7_CNTL_0__STATE_VALID_MASK 0xff000000
#define SMU_LCLK_DPM_STATE_7_CNTL_0__STATE_VALID__SHIFT 0x18
#define SMU_LCLK_DPM_STATE_0_CNTL_1__MIN_VDDNB_MASK 0xffffffff
#define SMU_LCLK_DPM_STATE_0_CNTL_1__MIN_VDDNB__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_1_CNTL_1__MIN_VDDNB_MASK 0xffffffff
#define SMU_LCLK_DPM_STATE_1_CNTL_1__MIN_VDDNB__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_2_CNTL_1__MIN_VDDNB_MASK 0xffffffff
#define SMU_LCLK_DPM_STATE_2_CNTL_1__MIN_VDDNB__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_3_CNTL_1__MIN_VDDNB_MASK 0xffffffff
#define SMU_LCLK_DPM_STATE_3_CNTL_1__MIN_VDDNB__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_4_CNTL_1__MIN_VDDNB_MASK 0xffffffff
#define SMU_LCLK_DPM_STATE_4_CNTL_1__MIN_VDDNB__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_5_CNTL_1__MIN_VDDNB_MASK 0xffffffff
#define SMU_LCLK_DPM_STATE_5_CNTL_1__MIN_VDDNB__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_6_CNTL_1__MIN_VDDNB_MASK 0xffffffff
#define SMU_LCLK_DPM_STATE_6_CNTL_1__MIN_VDDNB__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_7_CNTL_1__MIN_VDDNB_MASK 0xffffffff
#define SMU_LCLK_DPM_STATE_7_CNTL_1__MIN_VDDNB__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_0_CNTL_2__HYSTERESIS_DOWN_MASK 0xff
#define SMU_LCLK_DPM_STATE_0_CNTL_2__HYSTERESIS_DOWN__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_0_CNTL_2__HYSTERESIS_UP_MASK 0xff00
#define SMU_LCLK_DPM_STATE_0_CNTL_2__HYSTERESIS_UP__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_0_CNTL_2__RESIDENCY_COUNTER_MASK 0xffff0000
#define SMU_LCLK_DPM_STATE_0_CNTL_2__RESIDENCY_COUNTER__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_1_CNTL_2__HYSTERESIS_DOWN_MASK 0xff
#define SMU_LCLK_DPM_STATE_1_CNTL_2__HYSTERESIS_DOWN__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_1_CNTL_2__HYSTERESIS_UP_MASK 0xff00
#define SMU_LCLK_DPM_STATE_1_CNTL_2__HYSTERESIS_UP__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_1_CNTL_2__RESIDENCY_COUNTER_MASK 0xffff0000
#define SMU_LCLK_DPM_STATE_1_CNTL_2__RESIDENCY_COUNTER__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_2_CNTL_2__HYSTERESIS_DOWN_MASK 0xff
#define SMU_LCLK_DPM_STATE_2_CNTL_2__HYSTERESIS_DOWN__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_2_CNTL_2__HYSTERESIS_UP_MASK 0xff00
#define SMU_LCLK_DPM_STATE_2_CNTL_2__HYSTERESIS_UP__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_2_CNTL_2__RESIDENCY_COUNTER_MASK 0xffff0000
#define SMU_LCLK_DPM_STATE_2_CNTL_2__RESIDENCY_COUNTER__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_3_CNTL_2__HYSTERESIS_DOWN_MASK 0xff
#define SMU_LCLK_DPM_STATE_3_CNTL_2__HYSTERESIS_DOWN__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_3_CNTL_2__HYSTERESIS_UP_MASK 0xff00
#define SMU_LCLK_DPM_STATE_3_CNTL_2__HYSTERESIS_UP__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_3_CNTL_2__RESIDENCY_COUNTER_MASK 0xffff0000
#define SMU_LCLK_DPM_STATE_3_CNTL_2__RESIDENCY_COUNTER__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_4_CNTL_2__HYSTERESIS_DOWN_MASK 0xff
#define SMU_LCLK_DPM_STATE_4_CNTL_2__HYSTERESIS_DOWN__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_4_CNTL_2__HYSTERESIS_UP_MASK 0xff00
#define SMU_LCLK_DPM_STATE_4_CNTL_2__HYSTERESIS_UP__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_4_CNTL_2__RESIDENCY_COUNTER_MASK 0xffff0000
#define SMU_LCLK_DPM_STATE_4_CNTL_2__RESIDENCY_COUNTER__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_5_CNTL_2__HYSTERESIS_DOWN_MASK 0xff
#define SMU_LCLK_DPM_STATE_5_CNTL_2__HYSTERESIS_DOWN__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_5_CNTL_2__HYSTERESIS_UP_MASK 0xff00
#define SMU_LCLK_DPM_STATE_5_CNTL_2__HYSTERESIS_UP__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_5_CNTL_2__RESIDENCY_COUNTER_MASK 0xffff0000
#define SMU_LCLK_DPM_STATE_5_CNTL_2__RESIDENCY_COUNTER__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_6_CNTL_2__HYSTERESIS_DOWN_MASK 0xff
#define SMU_LCLK_DPM_STATE_6_CNTL_2__HYSTERESIS_DOWN__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_6_CNTL_2__HYSTERESIS_UP_MASK 0xff00
#define SMU_LCLK_DPM_STATE_6_CNTL_2__HYSTERESIS_UP__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_6_CNTL_2__RESIDENCY_COUNTER_MASK 0xffff0000
#define SMU_LCLK_DPM_STATE_6_CNTL_2__RESIDENCY_COUNTER__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_7_CNTL_2__HYSTERESIS_DOWN_MASK 0xff
#define SMU_LCLK_DPM_STATE_7_CNTL_2__HYSTERESIS_DOWN__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_7_CNTL_2__HYSTERESIS_UP_MASK 0xff00
#define SMU_LCLK_DPM_STATE_7_CNTL_2__HYSTERESIS_UP__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_7_CNTL_2__RESIDENCY_COUNTER_MASK 0xffff0000
#define SMU_LCLK_DPM_STATE_7_CNTL_2__RESIDENCY_COUNTER__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_0_CNTL_3__LCLK_FREQUENCY_MASK 0xffffffff
#define SMU_LCLK_DPM_STATE_0_CNTL_3__LCLK_FREQUENCY__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_1_CNTL_3__LCLK_FREQUENCY_MASK 0xffffffff
#define SMU_LCLK_DPM_STATE_1_CNTL_3__LCLK_FREQUENCY__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_2_CNTL_3__LCLK_FREQUENCY_MASK 0xffffffff
#define SMU_LCLK_DPM_STATE_2_CNTL_3__LCLK_FREQUENCY__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_3_CNTL_3__LCLK_FREQUENCY_MASK 0xffffffff
#define SMU_LCLK_DPM_STATE_3_CNTL_3__LCLK_FREQUENCY__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_4_CNTL_3__LCLK_FREQUENCY_MASK 0xffffffff
#define SMU_LCLK_DPM_STATE_4_CNTL_3__LCLK_FREQUENCY__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_5_CNTL_3__LCLK_FREQUENCY_MASK 0xffffffff
#define SMU_LCLK_DPM_STATE_5_CNTL_3__LCLK_FREQUENCY__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_6_CNTL_3__LCLK_FREQUENCY_MASK 0xffffffff
#define SMU_LCLK_DPM_STATE_6_CNTL_3__LCLK_FREQUENCY__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_7_CNTL_3__LCLK_FREQUENCY_MASK 0xffffffff
#define SMU_LCLK_DPM_STATE_7_CNTL_3__LCLK_FREQUENCY__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_0_ACTIVITY_THRESHOLD__RESERVED_MASK 0xff
#define SMU_LCLK_DPM_STATE_0_ACTIVITY_THRESHOLD__RESERVED__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_0_ACTIVITY_THRESHOLD__LCLKBYPASSCNTL_MASK 0xff00
#define SMU_LCLK_DPM_STATE_0_ACTIVITY_THRESHOLD__LCLKBYPASSCNTL__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_0_ACTIVITY_THRESHOLD__ENABLED_FOR_THROTTLE_MASK 0xff0000
#define SMU_LCLK_DPM_STATE_0_ACTIVITY_THRESHOLD__ENABLED_FOR_THROTTLE__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_0_ACTIVITY_THRESHOLD__ACTIVITY_THRESHOLD_MASK 0xff000000
#define SMU_LCLK_DPM_STATE_0_ACTIVITY_THRESHOLD__ACTIVITY_THRESHOLD__SHIFT 0x18
#define SMU_LCLK_DPM_STATE_1_ACTIVITY_THRESHOLD__RESERVED_MASK 0xff
#define SMU_LCLK_DPM_STATE_1_ACTIVITY_THRESHOLD__RESERVED__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_1_ACTIVITY_THRESHOLD__LCLKBYPASSCNTL_MASK 0xff00
#define SMU_LCLK_DPM_STATE_1_ACTIVITY_THRESHOLD__LCLKBYPASSCNTL__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_1_ACTIVITY_THRESHOLD__ENABLED_FOR_THROTTLE_MASK 0xff0000
#define SMU_LCLK_DPM_STATE_1_ACTIVITY_THRESHOLD__ENABLED_FOR_THROTTLE__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_1_ACTIVITY_THRESHOLD__ACTIVITY_THRESHOLD_MASK 0xff000000
#define SMU_LCLK_DPM_STATE_1_ACTIVITY_THRESHOLD__ACTIVITY_THRESHOLD__SHIFT 0x18
#define SMU_LCLK_DPM_STATE_2_ACTIVITY_THRESHOLD__RESERVED_MASK 0xff
#define SMU_LCLK_DPM_STATE_2_ACTIVITY_THRESHOLD__RESERVED__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_2_ACTIVITY_THRESHOLD__LCLKBYPASSCNTL_MASK 0xff00
#define SMU_LCLK_DPM_STATE_2_ACTIVITY_THRESHOLD__LCLKBYPASSCNTL__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_2_ACTIVITY_THRESHOLD__ENABLED_FOR_THROTTLE_MASK 0xff0000
#define SMU_LCLK_DPM_STATE_2_ACTIVITY_THRESHOLD__ENABLED_FOR_THROTTLE__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_2_ACTIVITY_THRESHOLD__ACTIVITY_THRESHOLD_MASK 0xff000000
#define SMU_LCLK_DPM_STATE_2_ACTIVITY_THRESHOLD__ACTIVITY_THRESHOLD__SHIFT 0x18
#define SMU_LCLK_DPM_STATE_3_ACTIVITY_THRESHOLD__RESERVED_MASK 0xff
#define SMU_LCLK_DPM_STATE_3_ACTIVITY_THRESHOLD__RESERVED__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_3_ACTIVITY_THRESHOLD__LCLKBYPASSCNTL_MASK 0xff00
#define SMU_LCLK_DPM_STATE_3_ACTIVITY_THRESHOLD__LCLKBYPASSCNTL__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_3_ACTIVITY_THRESHOLD__ENABLED_FOR_THROTTLE_MASK 0xff0000
#define SMU_LCLK_DPM_STATE_3_ACTIVITY_THRESHOLD__ENABLED_FOR_THROTTLE__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_3_ACTIVITY_THRESHOLD__ACTIVITY_THRESHOLD_MASK 0xff000000
#define SMU_LCLK_DPM_STATE_3_ACTIVITY_THRESHOLD__ACTIVITY_THRESHOLD__SHIFT 0x18
#define SMU_LCLK_DPM_STATE_4_ACTIVITY_THRESHOLD__RESERVED_MASK 0xff
#define SMU_LCLK_DPM_STATE_4_ACTIVITY_THRESHOLD__RESERVED__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_4_ACTIVITY_THRESHOLD__LCLKBYPASSCNTL_MASK 0xff00
#define SMU_LCLK_DPM_STATE_4_ACTIVITY_THRESHOLD__LCLKBYPASSCNTL__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_4_ACTIVITY_THRESHOLD__ENABLED_FOR_THROTTLE_MASK 0xff0000
#define SMU_LCLK_DPM_STATE_4_ACTIVITY_THRESHOLD__ENABLED_FOR_THROTTLE__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_4_ACTIVITY_THRESHOLD__ACTIVITY_THRESHOLD_MASK 0xff000000
#define SMU_LCLK_DPM_STATE_4_ACTIVITY_THRESHOLD__ACTIVITY_THRESHOLD__SHIFT 0x18
#define SMU_LCLK_DPM_STATE_5_ACTIVITY_THRESHOLD__RESERVED_MASK 0xff
#define SMU_LCLK_DPM_STATE_5_ACTIVITY_THRESHOLD__RESERVED__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_5_ACTIVITY_THRESHOLD__LCLKBYPASSCNTL_MASK 0xff00
#define SMU_LCLK_DPM_STATE_5_ACTIVITY_THRESHOLD__LCLKBYPASSCNTL__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_5_ACTIVITY_THRESHOLD__ENABLED_FOR_THROTTLE_MASK 0xff0000
#define SMU_LCLK_DPM_STATE_5_ACTIVITY_THRESHOLD__ENABLED_FOR_THROTTLE__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_5_ACTIVITY_THRESHOLD__ACTIVITY_THRESHOLD_MASK 0xff000000
#define SMU_LCLK_DPM_STATE_5_ACTIVITY_THRESHOLD__ACTIVITY_THRESHOLD__SHIFT 0x18
#define SMU_LCLK_DPM_STATE_6_ACTIVITY_THRESHOLD__RESERVED_MASK 0xff
#define SMU_LCLK_DPM_STATE_6_ACTIVITY_THRESHOLD__RESERVED__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_6_ACTIVITY_THRESHOLD__LCLKBYPASSCNTL_MASK 0xff00
#define SMU_LCLK_DPM_STATE_6_ACTIVITY_THRESHOLD__LCLKBYPASSCNTL__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_6_ACTIVITY_THRESHOLD__ENABLED_FOR_THROTTLE_MASK 0xff0000
#define SMU_LCLK_DPM_STATE_6_ACTIVITY_THRESHOLD__ENABLED_FOR_THROTTLE__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_6_ACTIVITY_THRESHOLD__ACTIVITY_THRESHOLD_MASK 0xff000000
#define SMU_LCLK_DPM_STATE_6_ACTIVITY_THRESHOLD__ACTIVITY_THRESHOLD__SHIFT 0x18
#define SMU_LCLK_DPM_STATE_7_ACTIVITY_THRESHOLD__RESERVED_MASK 0xff
#define SMU_LCLK_DPM_STATE_7_ACTIVITY_THRESHOLD__RESERVED__SHIFT 0x0
#define SMU_LCLK_DPM_STATE_7_ACTIVITY_THRESHOLD__LCLKBYPASSCNTL_MASK 0xff00
#define SMU_LCLK_DPM_STATE_7_ACTIVITY_THRESHOLD__LCLKBYPASSCNTL__SHIFT 0x8
#define SMU_LCLK_DPM_STATE_7_ACTIVITY_THRESHOLD__ENABLED_FOR_THROTTLE_MASK 0xff0000
#define SMU_LCLK_DPM_STATE_7_ACTIVITY_THRESHOLD__ENABLED_FOR_THROTTLE__SHIFT 0x10
#define SMU_LCLK_DPM_STATE_7_ACTIVITY_THRESHOLD__ACTIVITY_THRESHOLD_MASK 0xff000000
#define SMU_LCLK_DPM_STATE_7_ACTIVITY_THRESHOLD__ACTIVITY_THRESHOLD__SHIFT 0x18
#define GIO_PID_CONTROLLER_CNTL_0__K_I_MASK 0xffffffff
#define GIO_PID_CONTROLLER_CNTL_0__K_I__SHIFT 0x0
#define GIO_PID_CONTROLLER_CNTL_1__LF_WINDUP_UPPER_LIM_MASK 0xffffffff
#define GIO_PID_CONTROLLER_CNTL_1__LF_WINDUP_UPPER_LIM__SHIFT 0x0
#define GIO_PID_CONTROLLER_CNTL_2__LF_WINDUP_LOWER_LIM_MASK 0xffffffff
#define GIO_PID_CONTROLLER_CNTL_2__LF_WINDUP_LOWER_LIM__SHIFT 0x0
#define GIO_PID_CONTROLLER_CNTL_3__STATE_PRECISION_MASK 0xffffffff
#define GIO_PID_CONTROLLER_CNTL_3__STATE_PRECISION__SHIFT 0x0
#define GIO_PID_CONTROLLER_CNTL_4__LF_PRECISION_MASK 0xffffffff
#define GIO_PID_CONTROLLER_CNTL_4__LF_PRECISION__SHIFT 0x0
#define GIO_PID_CONTROLLER_CNTL_5__LF_OFFSET_MASK 0xffffffff
#define GIO_PID_CONTROLLER_CNTL_5__LF_OFFSET__SHIFT 0x0
#define GIO_PID_CONTROLLER_CNTL_6__MAX_STATE_MASK 0xffffffff
#define GIO_PID_CONTROLLER_CNTL_6__MAX_STATE__SHIFT 0x0
#define GIO_PID_CONTROLLER_CNTL_7__MAX_LF_FRACTION_MASK 0xffffffff
#define GIO_PID_CONTROLLER_CNTL_7__MAX_LF_FRACTION__SHIFT 0x0
#define GIO_PID_CONTROLLER_CNTL_8__STATE_SHIFT_MASK 0xffffffff
#define GIO_PID_CONTROLLER_CNTL_8__STATE_SHIFT__SHIFT 0x0
#define SMU_LCLK_DPM_LEVEL_COUNT__LCLK_DPM_LEVEL_COUNT_MASK 0xffffffff
#define SMU_LCLK_DPM_LEVEL_COUNT__LCLK_DPM_LEVEL_COUNT__SHIFT 0x0
#define SMU_LCLK_DPM_CNTL__RESERVED_MASK 0xff
#define SMU_LCLK_DPM_CNTL__RESERVED__SHIFT 0x0
#define SMU_LCLK_DPM_CNTL__LCLK_DPM_BOOT_STATE_MASK 0xff00
#define SMU_LCLK_DPM_CNTL__LCLK_DPM_BOOT_STATE__SHIFT 0x8
#define SMU_LCLK_DPM_CNTL__VOLTAGE_CHG_EN_MASK 0xff0000
#define SMU_LCLK_DPM_CNTL__VOLTAGE_CHG_EN__SHIFT 0x10
#define SMU_LCLK_DPM_CNTL__LCLK_DPM_EN_MASK 0xff000000
#define SMU_LCLK_DPM_CNTL__LCLK_DPM_EN__SHIFT 0x18
#define SMU_LCLK_DPM_CURRENT_AND_TARGET_STATE__CURRENT_STATE_MASK 0xff
#define SMU_LCLK_DPM_CURRENT_AND_TARGET_STATE__CURRENT_STATE__SHIFT 0x0
#define SMU_LCLK_DPM_CURRENT_AND_TARGET_STATE__TARGET_STATE_MASK 0xff00
#define SMU_LCLK_DPM_CURRENT_AND_TARGET_STATE__TARGET_STATE__SHIFT 0x8
#define SMU_LCLK_DPM_THERMAL_THROTTLING_CNTL__LCLK_THERMAL_THROTTLING_EN_MASK 0xff
#define SMU_LCLK_DPM_THERMAL_THROTTLING_CNTL__LCLK_THERMAL_THROTTLING_EN__SHIFT 0x0
#define SMU_LCLK_DPM_THERMAL_THROTTLING_CNTL__TEMPERATURE_SEL_MASK 0xff00
#define SMU_LCLK_DPM_THERMAL_THROTTLING_CNTL__TEMPERATURE_SEL__SHIFT 0x8
#define SMU_LCLK_DPM_THERMAL_THROTTLING_CNTL__LCLK_TT_MODE_MASK 0xff0000
#define SMU_LCLK_DPM_THERMAL_THROTTLING_CNTL__LCLK_TT_MODE__SHIFT 0x10
#define SMU_LCLK_DPM_THERMAL_THROTTLING_CNTL__TT_HTC_ACTIVE_MASK 0xff000000
#define SMU_LCLK_DPM_THERMAL_THROTTLING_CNTL__TT_HTC_ACTIVE__SHIFT 0x18
#define SMU_LCLK_DPM_THERMAL_THROTTLING_THRESHOLDS__LOW_THRESHOLD_MASK 0xffff
#define SMU_LCLK_DPM_THERMAL_THROTTLING_THRESHOLDS__LOW_THRESHOLD__SHIFT 0x0
#define SMU_LCLK_DPM_THERMAL_THROTTLING_THRESHOLDS__HIGH_THRESHOLD_MASK 0xffff0000
#define SMU_LCLK_DPM_THERMAL_THROTTLING_THRESHOLDS__HIGH_THRESHOLD__SHIFT 0x10
#define PM_FUSES_1__BapmPstateVid_3_MASK 0xff
#define PM_FUSES_1__BapmPstateVid_3__SHIFT 0x0
#define PM_FUSES_1__BapmPstateVid_2_MASK 0xff00
#define PM_FUSES_1__BapmPstateVid_2__SHIFT 0x8
#define PM_FUSES_1__BapmPstateVid_1_MASK 0xff0000
#define PM_FUSES_1__BapmPstateVid_1__SHIFT 0x10
#define PM_FUSES_1__BapmPstateVid_0_MASK 0xff000000
#define PM_FUSES_1__BapmPstateVid_0__SHIFT 0x18
#define PM_FUSES_2__BapmPstateVid_7_MASK 0xff
#define PM_FUSES_2__BapmPstateVid_7__SHIFT 0x0
#define PM_FUSES_2__BapmPstateVid_6_MASK 0xff00
#define PM_FUSES_2__BapmPstateVid_6__SHIFT 0x8
#define PM_FUSES_2__BapmPstateVid_5_MASK 0xff0000
#define PM_FUSES_2__BapmPstateVid_5__SHIFT 0x10
#define PM_FUSES_2__BapmPstateVid_4_MASK 0xff000000
#define PM_FUSES_2__BapmPstateVid_4__SHIFT 0x18
#define PM_FUSES_3__BapmVddNbVidHiSidd_3_MASK 0xff
#define PM_FUSES_3__BapmVddNbVidHiSidd_3__SHIFT 0x0
#define PM_FUSES_3__BapmVddNbVidHiSidd_2_MASK 0xff00
#define PM_FUSES_3__BapmVddNbVidHiSidd_2__SHIFT 0x8
#define PM_FUSES_3__BapmVddNbVidHiSidd_1_MASK 0xff0000
#define PM_FUSES_3__BapmVddNbVidHiSidd_1__SHIFT 0x10
#define PM_FUSES_3__BapmVddNbVidHiSidd_0_MASK 0xff000000
#define PM_FUSES_3__BapmVddNbVidHiSidd_0__SHIFT 0x18
#define PM_FUSES_4__BapmVddNbVidLoSidd_2_MASK 0xff
#define PM_FUSES_4__BapmVddNbVidLoSidd_2__SHIFT 0x0
#define PM_FUSES_4__BapmVddNbVidLoSidd_1_MASK 0xff00
#define PM_FUSES_4__BapmVddNbVidLoSidd_1__SHIFT 0x8
#define PM_FUSES_4__BapmVddNbVidLoSidd_0_MASK 0xff0000
#define PM_FUSES_4__BapmVddNbVidLoSidd_0__SHIFT 0x10
#define PM_FUSES_4__BapmVddNbVidHiSidd_4_MASK 0xff000000
#define PM_FUSES_4__BapmVddNbVidHiSidd_4__SHIFT 0x18
#define PM_FUSES_5__CpuIdModel_MASK 0xff
#define PM_FUSES_5__CpuIdModel__SHIFT 0x0
#define PM_FUSES_5__SviLoadLineEn_MASK 0xff00
#define PM_FUSES_5__SviLoadLineEn__SHIFT 0x8
#define PM_FUSES_5__BapmVddNbVidLoSidd_4_MASK 0xff0000
#define PM_FUSES_5__BapmVddNbVidLoSidd_4__SHIFT 0x10
#define PM_FUSES_5__BapmVddNbVidLoSidd_3_MASK 0xff000000
#define PM_FUSES_5__BapmVddNbVidLoSidd_3__SHIFT 0x18
#define PM_FUSES_6__SviLoadLineTrimVddNb_MASK 0xff
#define PM_FUSES_6__SviLoadLineTrimVddNb__SHIFT 0x0
#define PM_FUSES_6__SviLoadLineTrimVdd_MASK 0xff00
#define PM_FUSES_6__SviLoadLineTrimVdd__SHIFT 0x8
#define PM_FUSES_6__SviLoadLineVddNb_MASK 0xff0000
#define PM_FUSES_6__SviLoadLineVddNb__SHIFT 0x10
#define PM_FUSES_6__SviLoadLineVdd_MASK 0xff000000
#define PM_FUSES_6__SviLoadLineVdd__SHIFT 0x18
#define PM_FUSES_7__BAPMTI_TjOffset_0_MASK 0xffff
#define PM_FUSES_7__BAPMTI_TjOffset_0__SHIFT 0x0
#define PM_FUSES_7__SviLoadLineOffsetVddNb_MASK 0xff0000
#define PM_FUSES_7__SviLoadLineOffsetVddNb__SHIFT 0x10
#define PM_FUSES_7__SviLoadLineOffsetVdd_MASK 0xff000000
#define PM_FUSES_7__SviLoadLineOffsetVdd__SHIFT 0x18
#define PM_FUSES_8__BAPMTI_TjOffset_2_MASK 0xffff
#define PM_FUSES_8__BAPMTI_TjOffset_2__SHIFT 0x0
#define PM_FUSES_8__BAPMTI_TjOffset_1_MASK 0xffff0000
#define PM_FUSES_8__BAPMTI_TjOffset_1__SHIFT 0x10
#define PM_FUSES_9__BAPMTI_TjHyst_1_MASK 0xffff
#define PM_FUSES_9__BAPMTI_TjHyst_1__SHIFT 0x0
#define PM_FUSES_9__BAPMTI_TjHyst_0_MASK 0xffff0000
#define PM_FUSES_9__BAPMTI_TjHyst_0__SHIFT 0x10
#define PM_FUSES_10__BAPMTI_TjMax_1_MASK 0xff
#define PM_FUSES_10__BAPMTI_TjMax_1__SHIFT 0x0
#define PM_FUSES_10__BAPMTI_TjMax_0_MASK 0xff00
#define PM_FUSES_10__BAPMTI_TjMax_0__SHIFT 0x8
#define PM_FUSES_10__BAPMTI_GpuTjHyst_MASK 0xffff0000
#define PM_FUSES_10__BAPMTI_GpuTjHyst__SHIFT 0x10
#define PM_FUSES_11__LhtcTmpLmt_MASK 0xff
#define PM_FUSES_11__LhtcTmpLmt__SHIFT 0x0
#define PM_FUSES_11__LhtcPstateLimit_MASK 0xff00
#define PM_FUSES_11__LhtcPstateLimit__SHIFT 0x8
#define PM_FUSES_11__LhtcHystLmt_MASK 0xff0000
#define PM_FUSES_11__LhtcHystLmt__SHIFT 0x10
#define PM_FUSES_11__BAPMTI_GpuTjMax_MASK 0xff000000
#define PM_FUSES_11__BAPMTI_GpuTjMax__SHIFT 0x18
#define PM_FUSES_12__MaxPwrCpu_1_MASK 0xff
#define PM_FUSES_12__MaxPwrCpu_1__SHIFT 0x0
#define PM_FUSES_12__MaxPwrCpu_0_MASK 0xff00
#define PM_FUSES_12__MaxPwrCpu_0__SHIFT 0x8
#define PM_FUSES_12__NomPwrCpu_1_MASK 0xff0000
#define PM_FUSES_12__NomPwrCpu_1__SHIFT 0x10
#define PM_FUSES_12__NomPwrCpu_0_MASK 0xff000000
#define PM_FUSES_12__NomPwrCpu_0__SHIFT 0x18
#define PM_FUSES_13__NomPwrGpu_MASK 0xffff
#define PM_FUSES_13__NomPwrGpu__SHIFT 0x0
#define PM_FUSES_13__MidPwrCpu_1_MASK 0xff0000
#define PM_FUSES_13__MidPwrCpu_1__SHIFT 0x10
#define PM_FUSES_13__MidPwrCpu_0_MASK 0xff000000
#define PM_FUSES_13__MidPwrCpu_0__SHIFT 0x18
#define PM_FUSES_14__MinPwrGpu_MASK 0xffff
#define PM_FUSES_14__MinPwrGpu__SHIFT 0x0
#define PM_FUSES_14__MaxPwrGpu_MASK 0xffff0000
#define PM_FUSES_14__MaxPwrGpu__SHIFT 0x10
#define PM_FUSES_15__PCIe3PhyOffset_MASK 0xff
#define PM_FUSES_15__PCIe3PhyOffset__SHIFT 0x0
#define PM_FUSES_15__PCIe2PhyOffset_MASK 0xff00
#define PM_FUSES_15__PCIe2PhyOffset__SHIFT 0x8
#define PM_FUSES_15__PCIe1PhyOffset_MASK 0xff0000
#define PM_FUSES_15__PCIe1PhyOffset__SHIFT 0x10
#define PM_FUSES_15__MidPwrTempHyst_MASK 0xff000000
#define PM_FUSES_15__MidPwrTempHyst__SHIFT 0x18
#define PM_FUSES_16__TDC_VDD_PkgLimit_MASK 0xffff
#define PM_FUSES_16__TDC_VDD_PkgLimit__SHIFT 0x0
#define PM_FUSES_16__DCE2PhyOffset_MASK 0xff0000
#define PM_FUSES_16__DCE2PhyOffset__SHIFT 0x10
#define PM_FUSES_16__DCE1PhyOffset_MASK 0xff000000
#define PM_FUSES_16__DCE1PhyOffset__SHIFT 0x18
#define PM_FUSES_17__TDC_VDDNB_ThrottleReleaseLimitPerc_MASK 0xff
#define PM_FUSES_17__TDC_VDDNB_ThrottleReleaseLimitPerc__SHIFT 0x0
#define PM_FUSES_17__TDC_VDD_ThrottleReleaseLimitPerc_MASK 0xff00
#define PM_FUSES_17__TDC_VDD_ThrottleReleaseLimitPerc__SHIFT 0x8
#define PM_FUSES_17__TDC_VDDNB_PkgLimit_MASK 0xffff0000
#define PM_FUSES_17__TDC_VDDNB_PkgLimit__SHIFT 0x10
#define PM_FUSES_18__TdcWaterfallCtl_MASK 0xff
#define PM_FUSES_18__TdcWaterfallCtl__SHIFT 0x0
#define PM_FUSES_18__TdpAgeRate_MASK 0xff00
#define PM_FUSES_18__TdpAgeRate__SHIFT 0x8
#define PM_FUSES_18__TdpAgeValue_MASK 0xff0000
#define PM_FUSES_18__TdpAgeValue__SHIFT 0x10
#define PM_FUSES_18__TDC_MAWt_MASK 0xff000000
#define PM_FUSES_18__TDC_MAWt__SHIFT 0x18
#define PM_FUSES_19__BapmLhtcCap_MASK 0xff
#define PM_FUSES_19__BapmLhtcCap__SHIFT 0x0
#define PM_FUSES_19__BapmFuseOverride_MASK 0xff00
#define PM_FUSES_19__BapmFuseOverride__SHIFT 0x8
#define PM_FUSES_19__SmuCoolingIndex_MASK 0xff0000
#define PM_FUSES_19__SmuCoolingIndex__SHIFT 0x10
#define PM_FUSES_19__SmuSocIndex_MASK 0xff000000
#define PM_FUSES_19__SmuSocIndex__SHIFT 0x18
#define PM_FUSES_20__SamClkDid_3_MASK 0xff
#define PM_FUSES_20__SamClkDid_3__SHIFT 0x0
#define PM_FUSES_20__SamClkDid_2_MASK 0xff00
#define PM_FUSES_20__SamClkDid_2__SHIFT 0x8
#define PM_FUSES_20__SamClkDid_1_MASK 0xff0000
#define PM_FUSES_20__SamClkDid_1__SHIFT 0x10
#define PM_FUSES_20__SamClkDid_0_MASK 0xff000000
#define PM_FUSES_20__SamClkDid_0__SHIFT 0x18
#define PM_FUSES_21__AmbientTempBase_MASK 0xff
#define PM_FUSES_21__AmbientTempBase__SHIFT 0x0
#define PM_FUSES_21__LPMLTemperatureMax_MASK 0xff00
#define PM_FUSES_21__LPMLTemperatureMax__SHIFT 0x8
#define PM_FUSES_21__LPMLTemperatureMin_MASK 0xff0000
#define PM_FUSES_21__LPMLTemperatureMin__SHIFT 0x10
#define PM_FUSES_21__SamClkDid_4_MASK 0xff000000
#define PM_FUSES_21__SamClkDid_4__SHIFT 0x18
#define PM_FUSES_22__LPMLTemperatureScaler_3_MASK 0xff
#define PM_FUSES_22__LPMLTemperatureScaler_3__SHIFT 0x0
#define PM_FUSES_22__LPMLTemperatureScaler_2_MASK 0xff00
#define PM_FUSES_22__LPMLTemperatureScaler_2__SHIFT 0x8
#define PM_FUSES_22__LPMLTemperatureScaler_1_MASK 0xff0000
#define PM_FUSES_22__LPMLTemperatureScaler_1__SHIFT 0x10
#define PM_FUSES_22__LPMLTemperatureScaler_0_MASK 0xff000000
#define PM_FUSES_22__LPMLTemperatureScaler_0__SHIFT 0x18
#define PM_FUSES_23__LPMLTemperatureScaler_7_MASK 0xff
#define PM_FUSES_23__LPMLTemperatureScaler_7__SHIFT 0x0
#define PM_FUSES_23__LPMLTemperatureScaler_6_MASK 0xff00
#define PM_FUSES_23__LPMLTemperatureScaler_6__SHIFT 0x8
#define PM_FUSES_23__LPMLTemperatureScaler_5_MASK 0xff0000
#define PM_FUSES_23__LPMLTemperatureScaler_5__SHIFT 0x10
#define PM_FUSES_23__LPMLTemperatureScaler_4_MASK 0xff000000
#define PM_FUSES_23__LPMLTemperatureScaler_4__SHIFT 0x18
#define PM_FUSES_24__LPMLTemperatureScaler_11_MASK 0xff
#define PM_FUSES_24__LPMLTemperatureScaler_11__SHIFT 0x0
#define PM_FUSES_24__LPMLTemperatureScaler_10_MASK 0xff00
#define PM_FUSES_24__LPMLTemperatureScaler_10__SHIFT 0x8
#define PM_FUSES_24__LPMLTemperatureScaler_9_MASK 0xff0000
#define PM_FUSES_24__LPMLTemperatureScaler_9__SHIFT 0x10
#define PM_FUSES_24__LPMLTemperatureScaler_8_MASK 0xff000000
#define PM_FUSES_24__LPMLTemperatureScaler_8__SHIFT 0x18
#define PM_FUSES_25__LPMLTemperatureScaler_15_MASK 0xff
#define PM_FUSES_25__LPMLTemperatureScaler_15__SHIFT 0x0
#define PM_FUSES_25__LPMLTemperatureScaler_14_MASK 0xff00
#define PM_FUSES_25__LPMLTemperatureScaler_14__SHIFT 0x8
#define PM_FUSES_25__LPMLTemperatureScaler_13_MASK 0xff0000
#define PM_FUSES_25__LPMLTemperatureScaler_13__SHIFT 0x10
#define PM_FUSES_25__LPMLTemperatureScaler_12_MASK 0xff000000
#define PM_FUSES_25__LPMLTemperatureScaler_12__SHIFT 0x18
#define PM_FUSES_26__GnbLPML_3_MASK 0xff
#define PM_FUSES_26__GnbLPML_3__SHIFT 0x0
#define PM_FUSES_26__GnbLPML_2_MASK 0xff00
#define PM_FUSES_26__GnbLPML_2__SHIFT 0x8
#define PM_FUSES_26__GnbLPML_1_MASK 0xff0000
#define PM_FUSES_26__GnbLPML_1__SHIFT 0x10
#define PM_FUSES_26__GnbLPML_0_MASK 0xff000000
#define PM_FUSES_26__GnbLPML_0__SHIFT 0x18
#define PM_FUSES_27__GnbLPML_7_MASK 0xff
#define PM_FUSES_27__GnbLPML_7__SHIFT 0x0
#define PM_FUSES_27__GnbLPML_6_MASK 0xff00
#define PM_FUSES_27__GnbLPML_6__SHIFT 0x8
#define PM_FUSES_27__GnbLPML_5_MASK 0xff0000
#define PM_FUSES_27__GnbLPML_5__SHIFT 0x10
#define PM_FUSES_27__GnbLPML_4_MASK 0xff000000
#define PM_FUSES_27__GnbLPML_4__SHIFT 0x18
#define PM_FUSES_28__GnbLPML_11_MASK 0xff
#define PM_FUSES_28__GnbLPML_11__SHIFT 0x0
#define PM_FUSES_28__GnbLPML_10_MASK 0xff00
#define PM_FUSES_28__GnbLPML_10__SHIFT 0x8
#define PM_FUSES_28__GnbLPML_9_MASK 0xff0000
#define PM_FUSES_28__GnbLPML_9__SHIFT 0x10
#define PM_FUSES_28__GnbLPML_8_MASK 0xff000000
#define PM_FUSES_28__GnbLPML_8__SHIFT 0x18
#define PM_FUSES_29__GnbLPML_15_MASK 0xff
#define PM_FUSES_29__GnbLPML_15__SHIFT 0x0
#define PM_FUSES_29__GnbLPML_14_MASK 0xff00
#define PM_FUSES_29__GnbLPML_14__SHIFT 0x8
#define PM_FUSES_29__GnbLPML_13_MASK 0xff0000
#define PM_FUSES_29__GnbLPML_13__SHIFT 0x10
#define PM_FUSES_29__GnbLPML_12_MASK 0xff000000
#define PM_FUSES_29__GnbLPML_12__SHIFT 0x18
#define PM_FUSES_30__NbVid_3_MASK 0xff
#define PM_FUSES_30__NbVid_3__SHIFT 0x0
#define PM_FUSES_30__NbVid_2_MASK 0xff00
#define PM_FUSES_30__NbVid_2__SHIFT 0x8
#define PM_FUSES_30__NbVid_1_MASK 0xff0000
#define PM_FUSES_30__NbVid_1__SHIFT 0x10
#define PM_FUSES_30__NbVid_0_MASK 0xff000000
#define PM_FUSES_30__NbVid_0__SHIFT 0x18
#define PM_FUSES_31__CpuVid_3_MASK 0xff
#define PM_FUSES_31__CpuVid_3__SHIFT 0x0
#define PM_FUSES_31__CpuVid_2_MASK 0xff00
#define PM_FUSES_31__CpuVid_2__SHIFT 0x8
#define PM_FUSES_31__CpuVid_1_MASK 0xff0000
#define PM_FUSES_31__CpuVid_1__SHIFT 0x10
#define PM_FUSES_31__CpuVid_0_MASK 0xff000000
#define PM_FUSES_31__CpuVid_0__SHIFT 0x18
#define PM_FUSES_32__CpuVid_7_MASK 0xff
#define PM_FUSES_32__CpuVid_7__SHIFT 0x0
#define PM_FUSES_32__CpuVid_6_MASK 0xff00
#define PM_FUSES_32__CpuVid_6__SHIFT 0x8
#define PM_FUSES_32__CpuVid_5_MASK 0xff0000
#define PM_FUSES_32__CpuVid_5__SHIFT 0x10
#define PM_FUSES_32__CpuVid_4_MASK 0xff000000
#define PM_FUSES_32__CpuVid_4__SHIFT 0x18
#define PM_FUSES_33__Tdp2Watt_MASK 0xffff
#define PM_FUSES_33__Tdp2Watt__SHIFT 0x0
#define PM_FUSES_33__GnbLPMLMinVid_MASK 0xff0000
#define PM_FUSES_33__GnbLPMLMinVid__SHIFT 0x10
#define PM_FUSES_33__GnbLPMLMaxVid_MASK 0xff000000
#define PM_FUSES_33__GnbLPMLMaxVid__SHIFT 0x18
#define PM_FUSES_34__Lpml_3_MASK 0xff
#define PM_FUSES_34__Lpml_3__SHIFT 0x0
#define PM_FUSES_34__Lpml_2_MASK 0xff00
#define PM_FUSES_34__Lpml_2__SHIFT 0x8
#define PM_FUSES_34__Lpml_1_MASK 0xff0000
#define PM_FUSES_34__Lpml_1__SHIFT 0x10
#define PM_FUSES_34__Lpml_0_MASK 0xff000000
#define PM_FUSES_34__Lpml_0__SHIFT 0x18
#define PM_FUSES_35__Lpml_7_MASK 0xff
#define PM_FUSES_35__Lpml_7__SHIFT 0x0
#define PM_FUSES_35__Lpml_6_MASK 0xff00
#define PM_FUSES_35__Lpml_6__SHIFT 0x8
#define PM_FUSES_35__Lpml_5_MASK 0xff0000
#define PM_FUSES_35__Lpml_5__SHIFT 0x10
#define PM_FUSES_35__Lpml_4_MASK 0xff000000
#define PM_FUSES_35__Lpml_4__SHIFT 0x18
#define PM_FUSES_36__Lpmv_3_MASK 0xff
#define PM_FUSES_36__Lpmv_3__SHIFT 0x0
#define PM_FUSES_36__Lpmv_2_MASK 0xff00
#define PM_FUSES_36__Lpmv_2__SHIFT 0x8
#define PM_FUSES_36__Lpmv_1_MASK 0xff0000
#define PM_FUSES_36__Lpmv_1__SHIFT 0x10
#define PM_FUSES_36__Lpmv_0_MASK 0xff000000
#define PM_FUSES_36__Lpmv_0__SHIFT 0x18
#define PM_FUSES_37__Lpmv_7_MASK 0xff
#define PM_FUSES_37__Lpmv_7__SHIFT 0x0
#define PM_FUSES_37__Lpmv_6_MASK 0xff00
#define PM_FUSES_37__Lpmv_6__SHIFT 0x8
#define PM_FUSES_37__Lpmv_5_MASK 0xff0000
#define PM_FUSES_37__Lpmv_5__SHIFT 0x10
#define PM_FUSES_37__Lpmv_4_MASK 0xff000000
#define PM_FUSES_37__Lpmv_4__SHIFT 0x18
#define PM_FUSES_38__EClkDid_3_MASK 0xff
#define PM_FUSES_38__EClkDid_3__SHIFT 0x0
#define PM_FUSES_38__EClkDid_2_MASK 0xff00
#define PM_FUSES_38__EClkDid_2__SHIFT 0x8
#define PM_FUSES_38__EClkDid_1_MASK 0xff0000
#define PM_FUSES_38__EClkDid_1__SHIFT 0x10
#define PM_FUSES_38__EClkDid_0_MASK 0xff000000
#define PM_FUSES_38__EClkDid_0__SHIFT 0x18
#define PM_FUSES_39__CoreDis_MASK 0xff
#define PM_FUSES_39__CoreDis__SHIFT 0x0
#define PM_FUSES_39__C6CstatePower_MASK 0xff00
#define PM_FUSES_39__C6CstatePower__SHIFT 0x8
#define PM_FUSES_39__BoostLock_MASK 0xff0000
#define PM_FUSES_39__BoostLock__SHIFT 0x10
#define PM_FUSES_39__EClkDid_4_MASK 0xff000000
#define PM_FUSES_39__EClkDid_4__SHIFT 0x18
#define PM_FUSES_40__BapmVddNbBaseLeakageLoSidd_MASK 0xffff
#define PM_FUSES_40__BapmVddNbBaseLeakageLoSidd__SHIFT 0x0
#define PM_FUSES_40__BapmVddNbBaseLeakageHiSidd_MASK 0xffff0000
#define PM_FUSES_40__BapmVddNbBaseLeakageHiSidd__SHIFT 0x10
#define PM_FUSES_41__VddNbVid_3_MASK 0xff
#define PM_FUSES_41__VddNbVid_3__SHIFT 0x0
#define PM_FUSES_41__VddNbVid_2_MASK 0xff00
#define PM_FUSES_41__VddNbVid_2__SHIFT 0x8
#define PM_FUSES_41__VddNbVid_1_MASK 0xff0000
#define PM_FUSES_41__VddNbVid_1__SHIFT 0x10
#define PM_FUSES_41__VddNbVid_0_MASK 0xff000000
#define PM_FUSES_41__VddNbVid_0__SHIFT 0x18
#define PM_FUSES_42__VddNbVidOffset_2_MASK 0xff
#define PM_FUSES_42__VddNbVidOffset_2__SHIFT 0x0
#define PM_FUSES_42__VddNbVidOffset_1_MASK 0xff00
#define PM_FUSES_42__VddNbVidOffset_1__SHIFT 0x8
#define PM_FUSES_42__VddNbVidOffset_0_MASK 0xff0000
#define PM_FUSES_42__VddNbVidOffset_0__SHIFT 0x10
#define PM_FUSES_42__VddNbVid_4_MASK 0xff000000
#define PM_FUSES_42__VddNbVid_4__SHIFT 0x18
#define PM_FUSES_43__BapmDisable_MASK 0xff
#define PM_FUSES_43__BapmDisable__SHIFT 0x0
#define PM_FUSES_43__CoreTdpLimit0_MASK 0xff00
#define PM_FUSES_43__CoreTdpLimit0__SHIFT 0x8
#define PM_FUSES_43__VddNbVidOffset_4_MASK 0xff0000
#define PM_FUSES_43__VddNbVidOffset_4__SHIFT 0x10
#define PM_FUSES_43__VddNbVidOffset_3_MASK 0xff000000
#define PM_FUSES_43__VddNbVidOffset_3__SHIFT 0x18
#define PM_FUSES_44__LpmlL2_3_MASK 0xff
#define PM_FUSES_44__LpmlL2_3__SHIFT 0x0
#define PM_FUSES_44__LpmlL2_2_MASK 0xff00
#define PM_FUSES_44__LpmlL2_2__SHIFT 0x8
#define PM_FUSES_44__LpmlL2_1_MASK 0xff0000
#define PM_FUSES_44__LpmlL2_1__SHIFT 0x10
#define PM_FUSES_44__LpmlL2_0_MASK 0xff000000
#define PM_FUSES_44__LpmlL2_0__SHIFT 0x18
#define PM_FUSES_45__LpmlL2_7_MASK 0xff
#define PM_FUSES_45__LpmlL2_7__SHIFT 0x0
#define PM_FUSES_45__LpmlL2_6_MASK 0xff00
#define PM_FUSES_45__LpmlL2_6__SHIFT 0x8
#define PM_FUSES_45__LpmlL2_5_MASK 0xff0000
#define PM_FUSES_45__LpmlL2_5__SHIFT 0x10
#define PM_FUSES_45__LpmlL2_4_MASK 0xff000000
#define PM_FUSES_45__LpmlL2_4__SHIFT 0x18
#define PM_FUSES_46__CoolPdmTc_MASK 0xff
#define PM_FUSES_46__CoolPdmTc__SHIFT 0x0
#define PM_FUSES_46__BaseCpcTdpLimit2_MASK 0xff00
#define PM_FUSES_46__BaseCpcTdpLimit2__SHIFT 0x8
#define PM_FUSES_46__BaseCpcTdpLimit1_MASK 0xff0000
#define PM_FUSES_46__BaseCpcTdpLimit1__SHIFT 0x10
#define PM_FUSES_46__BaseCpcTdpLimit_MASK 0xff000000
#define PM_FUSES_46__BaseCpcTdpLimit__SHIFT 0x18
#define PM_FUSES_47__CoolPdmThr2_MASK 0xff
#define PM_FUSES_47__CoolPdmThr2__SHIFT 0x0
#define PM_FUSES_47__CoolPdmThr1_MASK 0xff00
#define PM_FUSES_47__CoolPdmThr1__SHIFT 0x8
#define PM_FUSES_47__GpuPdmTc_MASK 0xff0000
#define PM_FUSES_47__GpuPdmTc__SHIFT 0x10
#define PM_FUSES_47__HeatPdmTc_MASK 0xff000000
#define PM_FUSES_47__HeatPdmTc__SHIFT 0x18
#define PM_FUSES_48__PkgPwr_MAWt_MASK 0xff
#define PM_FUSES_48__PkgPwr_MAWt__SHIFT 0x0
#define PM_FUSES_48__GpuActThr_MASK 0xff00
#define PM_FUSES_48__GpuActThr__SHIFT 0x8
#define PM_FUSES_48__HeatPdmThr2_MASK 0xff0000
#define PM_FUSES_48__HeatPdmThr2__SHIFT 0x10
#define PM_FUSES_48__HeatPdmThr1_MASK 0xff000000
#define PM_FUSES_48__HeatPdmThr1__SHIFT 0x18
#define PM_FUSES_49__SocketTdp_MASK 0xffff
#define PM_FUSES_49__SocketTdp__SHIFT 0x0
#define PM_FUSES_49__GpuPdmMult_MASK 0xffff0000
#define PM_FUSES_49__GpuPdmMult__SHIFT 0x10
#define PM_FUSES_50__Reserved2_MASK 0xffff
#define PM_FUSES_50__Reserved2__SHIFT 0x0
#define PM_FUSES_50__Reserved1_MASK 0xff0000
#define PM_FUSES_50__Reserved1__SHIFT 0x10
#define PM_FUSES_50__NumBoostStates_MASK 0xff000000
#define PM_FUSES_50__NumBoostStates__SHIFT 0x18
#define PM_FUSES_51__FUSE_DATA_MASK 0xffffffff
#define PM_FUSES_51__FUSE_DATA__SHIFT 0x0
#define PM_FUSES_52__FUSE_DATA_MASK 0xffffffff
#define PM_FUSES_52__FUSE_DATA__SHIFT 0x0
#define PM_FUSES_53__FUSE_DATA_MASK 0xffffffff
#define PM_FUSES_53__FUSE_DATA__SHIFT 0x0
#define PM_FUSES_54__FUSE_DATA_MASK 0xffffffff
#define PM_FUSES_54__FUSE_DATA__SHIFT 0x0
#define PM_FUSES_55__FUSE_DATA_MASK 0xffffffff
#define PM_FUSES_55__FUSE_DATA__SHIFT 0x0
#define PM_FUSES_56__FUSE_DATA_MASK 0xffffffff
#define PM_FUSES_56__FUSE_DATA__SHIFT 0x0
#define PM_FUSES_57__FUSE_DATA_MASK 0xffffffff
#define PM_FUSES_57__FUSE_DATA__SHIFT 0x0
#define PM_FUSES_58__FUSE_DATA_MASK 0xffffffff
#define PM_FUSES_58__FUSE_DATA__SHIFT 0x0
#define PM_FUSES_59__FUSE_DATA_MASK 0xffffffff
#define PM_FUSES_59__FUSE_DATA__SHIFT 0x0
#define PM_FUSES_60__FUSE_DATA_MASK 0xffffffff
#define PM_FUSES_60__FUSE_DATA__SHIFT 0x0
#define PM_FUSES_61__FUSE_DATA_MASK 0xffffffff
#define PM_FUSES_61__FUSE_DATA__SHIFT 0x0
#define PM_FUSES_62__FUSE_DATA_MASK 0xffffffff
#define PM_FUSES_62__FUSE_DATA__SHIFT 0x0
#define PM_FUSES_63__FUSE_DATA_MASK 0xffffffff
#define PM_FUSES_63__FUSE_DATA__SHIFT 0x0
#define PM_FUSES_64__FUSE_DATA_MASK 0xffffffff
#define PM_FUSES_64__FUSE_DATA__SHIFT 0x0
#define PM_FUSES_65__FUSE_DATA_MASK 0xffffffff
#define PM_FUSES_65__FUSE_DATA__SHIFT 0x0
#define FIRMWARE_FLAGS__INTERRUPTS_ENABLED_MASK 0x1
#define FIRMWARE_FLAGS__INTERRUPTS_ENABLED__SHIFT 0x0
#define FIRMWARE_FLAGS__RESERVED_MASK 0xfffffe
#define FIRMWARE_FLAGS__RESERVED__SHIFT 0x1
#define FIRMWARE_FLAGS__TEST_COUNT_MASK 0xff000000
#define FIRMWARE_FLAGS__TEST_COUNT__SHIFT 0x18
#define TEMPERATURE_READ_ADDR__CSR_ADDR_MASK 0x3f
#define TEMPERATURE_READ_ADDR__CSR_ADDR__SHIFT 0x0
#define TEMPERATURE_READ_ADDR__TCEN_ID_MASK 0x3c0
#define TEMPERATURE_READ_ADDR__TCEN_ID__SHIFT 0x6
#define TEMPERATURE_READ_ADDR__RESERVED_MASK 0xfffffc00
#define TEMPERATURE_READ_ADDR__RESERVED__SHIFT 0xa
#define CURRENT_GNB_TEMP__TEMP_MASK 0x7ff
#define CURRENT_GNB_TEMP__TEMP__SHIFT 0x0
#define CURRENT_GLOBAL_TEMP__TEMP_MASK 0x7ff
#define CURRENT_GLOBAL_TEMP__TEMP__SHIFT 0x0
#define FEATURE_STATUS__SCLK_DPM_ON_MASK 0x1
#define FEATURE_STATUS__SCLK_DPM_ON__SHIFT 0x0
#define FEATURE_STATUS__MCLK_DPM_ON_MASK 0x2
#define FEATURE_STATUS__MCLK_DPM_ON__SHIFT 0x1
#define FEATURE_STATUS__LCLK_DPM_ON_MASK 0x4
#define FEATURE_STATUS__LCLK_DPM_ON__SHIFT 0x2
#define FEATURE_STATUS__UVD_DPM_ON_MASK 0x8
#define FEATURE_STATUS__UVD_DPM_ON__SHIFT 0x3
#define FEATURE_STATUS__VCE_DPM_ON_MASK 0x10
#define FEATURE_STATUS__VCE_DPM_ON__SHIFT 0x4
#define FEATURE_STATUS__ACP_DPM_ON_MASK 0x20
#define FEATURE_STATUS__ACP_DPM_ON__SHIFT 0x5
#define FEATURE_STATUS__SAMU_DPM_ON_MASK 0x40
#define FEATURE_STATUS__SAMU_DPM_ON__SHIFT 0x6
#define FEATURE_STATUS__PCIE_DPM_ON_MASK 0x80
#define FEATURE_STATUS__PCIE_DPM_ON__SHIFT 0x7
#define FEATURE_STATUS__BAPM_ON_MASK 0x100
#define FEATURE_STATUS__BAPM_ON__SHIFT 0x8
#define FEATURE_STATUS__LPMX_ON_MASK 0x200
#define FEATURE_STATUS__LPMX_ON__SHIFT 0x9
#define FEATURE_STATUS__NBDPM_ON_MASK 0x400
#define FEATURE_STATUS__NBDPM_ON__SHIFT 0xa
#define FEATURE_STATUS__LHTC_ON_MASK 0x800
#define FEATURE_STATUS__LHTC_ON__SHIFT 0xb
#define FEATURE_STATUS__VPC_ON_MASK 0x1000
#define FEATURE_STATUS__VPC_ON__SHIFT 0xc
#define FEATURE_STATUS__VOLTAGE_CONTROLLER_ON_MASK 0x2000
#define FEATURE_STATUS__VOLTAGE_CONTROLLER_ON__SHIFT 0xd
#define FEATURE_STATUS__TDC_LIMIT_ON_MASK 0x4000
#define FEATURE_STATUS__TDC_LIMIT_ON__SHIFT 0xe
#define FEATURE_STATUS__GPU_CAC_ON_MASK 0x8000
#define FEATURE_STATUS__GPU_CAC_ON__SHIFT 0xf
#define FEATURE_STATUS__AVS_ON_MASK 0x10000
#define FEATURE_STATUS__AVS_ON__SHIFT 0x10
#define FEATURE_STATUS__SPMI_ON_MASK 0x20000
#define FEATURE_STATUS__SPMI_ON__SHIFT 0x11
#define FEATURE_STATUS__SCLK_DPM_FORCED_MASK 0x40000
#define FEATURE_STATUS__SCLK_DPM_FORCED__SHIFT 0x12
#define FEATURE_STATUS__MCLK_DPM_FORCED_MASK 0x80000
#define FEATURE_STATUS__MCLK_DPM_FORCED__SHIFT 0x13
#define FEATURE_STATUS__LCLK_DPM_FORCED_MASK 0x100000
#define FEATURE_STATUS__LCLK_DPM_FORCED__SHIFT 0x14
#define FEATURE_STATUS__PCIE_DPM_FORCED_MASK 0x200000
#define FEATURE_STATUS__PCIE_DPM_FORCED__SHIFT 0x15
#define FEATURE_STATUS__CLK_MON_ON_MASK 0x400000
#define FEATURE_STATUS__CLK_MON_ON__SHIFT 0x16
#define FEATURE_STATUS__RESERVED_MASK 0xff800000
#define FEATURE_STATUS__RESERVED__SHIFT 0x17
#define PCIE_PLL_RECONF__RECONF_WAIT_MASK 0xff
#define PCIE_PLL_RECONF__RECONF_WAIT__SHIFT 0x0
#define PCIE_PLL_RECONF__RECONF_WRAPPER_MASK 0xff00
#define PCIE_PLL_RECONF__RECONF_WRAPPER__SHIFT 0x8
#define PCIE_PLL_RECONF__SB_RELOCATE_EN_MASK 0xff0000
#define PCIE_PLL_RECONF__SB_RELOCATE_EN__SHIFT 0x10
#define PCIE_PLL_RECONF__SB_NEW_PORT_MASK 0xff000000
#define PCIE_PLL_RECONF__SB_NEW_PORT__SHIFT 0x18
#define PM_INTERVAL_CNTL_0__LCLK_DPM_MASK 0xff
#define PM_INTERVAL_CNTL_0__LCLK_DPM__SHIFT 0x0
#define PM_INTERVAL_CNTL_0__THERMAL_CNTL_MASK 0xff00
#define PM_INTERVAL_CNTL_0__THERMAL_CNTL__SHIFT 0x8
#define PM_INTERVAL_CNTL_0__VOLTAGE_CNTL_MASK 0xff0000
#define PM_INTERVAL_CNTL_0__VOLTAGE_CNTL__SHIFT 0x10
#define PM_INTERVAL_CNTL_0__LOADLINE_MASK 0xff000000
#define PM_INTERVAL_CNTL_0__LOADLINE__SHIFT 0x18
#define PM_INTERVAL_CNTL_1__NB_DPM_MASK 0xff
#define PM_INTERVAL_CNTL_1__NB_DPM__SHIFT 0x0
#define PM_INTERVAL_CNTL_1__AVS_PERIOD_MASK 0xff00
#define PM_INTERVAL_CNTL_1__AVS_PERIOD__SHIFT 0x8
#define PM_INTERVAL_CNTL_1__PKGPWR_PERIOD_MASK 0xff0000
#define PM_INTERVAL_CNTL_1__PKGPWR_PERIOD__SHIFT 0x10
#define PM_INTERVAL_CNTL_1__TDP_CNTL_MASK 0xff000000
#define PM_INTERVAL_CNTL_1__TDP_CNTL__SHIFT 0x18
#define PM_INTERVAL_CNTL_2__BAPM_PERIOD_MASK 0xff
#define PM_INTERVAL_CNTL_2__BAPM_PERIOD__SHIFT 0x0
#define PM_INTERVAL_CNTL_2__HTC_PERIOD_MASK 0xff00
#define PM_INTERVAL_CNTL_2__HTC_PERIOD__SHIFT 0x8
#define PM_INTERVAL_CNTL_2__TDC_PERIOD_MASK 0xff0000
#define PM_INTERVAL_CNTL_2__TDC_PERIOD__SHIFT 0x10
#define PM_INTERVAL_CNTL_2__LPMX_PERIOD_MASK 0xff000000
#define PM_INTERVAL_CNTL_2__LPMX_PERIOD__SHIFT 0x18
#define VPC_INTERVAL_CNTL__VPC_PERIOD_MASK 0xffffffff
#define VPC_INTERVAL_CNTL__VPC_PERIOD__SHIFT 0x0
#define DISP_PHY_TDP_LIMIT__DisplayPhyTdpLimit_MASK 0xffffffff
#define DISP_PHY_TDP_LIMIT__DisplayPhyTdpLimit__SHIFT 0x0
#define FCH_PWR_CREDIT__FchPwrCredit_MASK 0xffffffff
#define FCH_PWR_CREDIT__FchPwrCredit__SHIFT 0x0
#define PKGPWR_MV_AVG__Avg_Pkg_Pwr_MASK 0xffffffff
#define PKGPWR_MV_AVG__Avg_Pkg_Pwr__SHIFT 0x0
#define PACKAGE_POWER__Pkg_power_MASK 0xffffffff
#define PACKAGE_POWER__Pkg_power__SHIFT 0x0
#define PKG_PWR_CNTL__CpcGpuPerfPri_MASK 0x1
#define PKG_PWR_CNTL__CpcGpuPerfPri__SHIFT 0x0
#define PKG_PWR_CNTL__PkgPwrLimit_MASK 0x1fffe
#define PKG_PWR_CNTL__PkgPwrLimit__SHIFT 0x1
#define PKG_PWR_CNTL__FchPwrCreditScale_MASK 0x7e0000
#define PKG_PWR_CNTL__FchPwrCreditScale__SHIFT 0x11
#define PKG_PWR_CNTL__PkgHystCoeff_MASK 0x1f800000
#define PKG_PWR_CNTL__PkgHystCoeff__SHIFT 0x17
#define PKG_PWR_CNTL__RESERVED_MASK 0xe0000000
#define PKG_PWR_CNTL__RESERVED__SHIFT 0x1d
#define PKG_PWR_STATUS__GnbMinLimitSetFlag_MASK 0x1
#define PKG_PWR_STATUS__GnbMinLimitSetFlag__SHIFT 0x0
#define PKG_PWR_STATUS__PstateLimitSetFlag_MASK 0x2
#define PKG_PWR_STATUS__PstateLimitSetFlag__SHIFT 0x1
#define PKG_PWR_STATUS__PkgPwrLimit_base_MASK 0x3fffc
#define PKG_PWR_STATUS__PkgPwrLimit_base__SHIFT 0x2
#define PKG_PWR_STATUS__RESERVED_MASK 0xfc0000
#define PKG_PWR_STATUS__RESERVED__SHIFT 0x12
#define PKG_PWR_STATUS__PkgPwr_MAWt_MASK 0xff000000
#define PKG_PWR_STATUS__PkgPwr_MAWt__SHIFT 0x18
#define DISP_PHY_CONFIG__Corner_MASK 0xff
#define DISP_PHY_CONFIG__Corner__SHIFT 0x0
#define DISP_PHY_CONFIG__DispPHYConfig_MASK 0xff00
#define DISP_PHY_CONFIG__DispPHYConfig__SHIFT 0x8
#define GPU_TDP_LIMIT__Gpu_Tdp_Limit_MASK 0xffff
#define GPU_TDP_LIMIT__Gpu_Tdp_Limit__SHIFT 0x0
#define GPU_TDP_LIMIT__Reserved_MASK 0xffff0000
#define GPU_TDP_LIMIT__Reserved__SHIFT 0x10
#define EXT_API_IN_DATA_0_0__byte0_MASK 0xff
#define EXT_API_IN_DATA_0_0__byte0__SHIFT 0x0
#define EXT_API_IN_DATA_0_0__byte1_MASK 0xff00
#define EXT_API_IN_DATA_0_0__byte1__SHIFT 0x8
#define EXT_API_IN_DATA_0_0__byte2_MASK 0xff0000
#define EXT_API_IN_DATA_0_0__byte2__SHIFT 0x10
#define EXT_API_IN_DATA_0_0__byte3_MASK 0xff000000
#define EXT_API_IN_DATA_0_0__byte3__SHIFT 0x18
#define EXT_API_IN_DATA_0_1__byte0_MASK 0xff
#define EXT_API_IN_DATA_0_1__byte0__SHIFT 0x0
#define EXT_API_IN_DATA_0_1__byte1_MASK 0xff00
#define EXT_API_IN_DATA_0_1__byte1__SHIFT 0x8
#define EXT_API_IN_DATA_0_1__byte2_MASK 0xff0000
#define EXT_API_IN_DATA_0_1__byte2__SHIFT 0x10
#define EXT_API_IN_DATA_0_1__byte3_MASK 0xff000000
#define EXT_API_IN_DATA_0_1__byte3__SHIFT 0x18
#define EXT_API_IN_DATA_0_2__byte0_MASK 0xff
#define EXT_API_IN_DATA_0_2__byte0__SHIFT 0x0
#define EXT_API_IN_DATA_0_2__byte1_MASK 0xff00
#define EXT_API_IN_DATA_0_2__byte1__SHIFT 0x8
#define EXT_API_IN_DATA_0_2__byte2_MASK 0xff0000
#define EXT_API_IN_DATA_0_2__byte2__SHIFT 0x10
#define EXT_API_IN_DATA_0_2__byte3_MASK 0xff000000
#define EXT_API_IN_DATA_0_2__byte3__SHIFT 0x18
#define EXT_API_IN_DATA_0_3__byte0_MASK 0xff
#define EXT_API_IN_DATA_0_3__byte0__SHIFT 0x0
#define EXT_API_IN_DATA_0_3__byte1_MASK 0xff00
#define EXT_API_IN_DATA_0_3__byte1__SHIFT 0x8
#define EXT_API_IN_DATA_0_3__byte2_MASK 0xff0000
#define EXT_API_IN_DATA_0_3__byte2__SHIFT 0x10
#define EXT_API_IN_DATA_0_3__byte3_MASK 0xff000000
#define EXT_API_IN_DATA_0_3__byte3__SHIFT 0x18
#define EXT_API_OUT_DATA_0_0__byte0_MASK 0xff
#define EXT_API_OUT_DATA_0_0__byte0__SHIFT 0x0
#define EXT_API_OUT_DATA_0_0__byte1_MASK 0xff00
#define EXT_API_OUT_DATA_0_0__byte1__SHIFT 0x8
#define EXT_API_OUT_DATA_0_0__byte2_MASK 0xff0000
#define EXT_API_OUT_DATA_0_0__byte2__SHIFT 0x10
#define EXT_API_OUT_DATA_0_0__byte3_MASK 0xff000000
#define EXT_API_OUT_DATA_0_0__byte3__SHIFT 0x18
#define EXT_API_OUT_DATA_0_1__byte0_MASK 0xff
#define EXT_API_OUT_DATA_0_1__byte0__SHIFT 0x0
#define EXT_API_OUT_DATA_0_1__byte1_MASK 0xff00
#define EXT_API_OUT_DATA_0_1__byte1__SHIFT 0x8
#define EXT_API_OUT_DATA_0_1__byte2_MASK 0xff0000
#define EXT_API_OUT_DATA_0_1__byte2__SHIFT 0x10
#define EXT_API_OUT_DATA_0_1__byte3_MASK 0xff000000
#define EXT_API_OUT_DATA_0_1__byte3__SHIFT 0x18
#define EXT_API_OUT_DATA_0_2__byte0_MASK 0xff
#define EXT_API_OUT_DATA_0_2__byte0__SHIFT 0x0
#define EXT_API_OUT_DATA_0_2__byte1_MASK 0xff00
#define EXT_API_OUT_DATA_0_2__byte1__SHIFT 0x8
#define EXT_API_OUT_DATA_0_2__byte2_MASK 0xff0000
#define EXT_API_OUT_DATA_0_2__byte2__SHIFT 0x10
#define EXT_API_OUT_DATA_0_2__byte3_MASK 0xff000000
#define EXT_API_OUT_DATA_0_2__byte3__SHIFT 0x18
#define EXT_API_OUT_DATA_0_3__byte0_MASK 0xff
#define EXT_API_OUT_DATA_0_3__byte0__SHIFT 0x0
#define EXT_API_OUT_DATA_0_3__byte1_MASK 0xff00
#define EXT_API_OUT_DATA_0_3__byte1__SHIFT 0x8
#define EXT_API_OUT_DATA_0_3__byte2_MASK 0xff0000
#define EXT_API_OUT_DATA_0_3__byte2__SHIFT 0x10
#define EXT_API_OUT_DATA_0_3__byte3_MASK 0xff000000
#define EXT_API_OUT_DATA_0_3__byte3__SHIFT 0x18
#define BAPM_PARAMETERS__MaxPwrCpu_1_MASK 0xff
#define BAPM_PARAMETERS__MaxPwrCpu_1__SHIFT 0x0
#define BAPM_PARAMETERS__NomPwrCpu_1_MASK 0xff00
#define BAPM_PARAMETERS__NomPwrCpu_1__SHIFT 0x8
#define BAPM_PARAMETERS__MaxPwrCpu_0_MASK 0xff0000
#define BAPM_PARAMETERS__MaxPwrCpu_0__SHIFT 0x10
#define BAPM_PARAMETERS__NomPwrCpu_0_MASK 0xff000000
#define BAPM_PARAMETERS__NomPwrCpu_0__SHIFT 0x18
#define BAPM_PARAMETERS_2__MaxPwrGpu_MASK 0xffff
#define BAPM_PARAMETERS_2__MaxPwrGpu__SHIFT 0x0
#define BAPM_PARAMETERS_2__NomPwrGpu_MASK 0xffff0000
#define BAPM_PARAMETERS_2__NomPwrGpu__SHIFT 0x10
#define BAPM_PARAMETERS_3__TjOffset_MASK 0xff
#define BAPM_PARAMETERS_3__TjOffset__SHIFT 0x0
#define BAPM_PARAMETERS_3__EnergyCntNorm_MASK 0x3ff00
#define BAPM_PARAMETERS_3__EnergyCntNorm__SHIFT 0x8
#define BAPM_PARAMETERS_3__Reserved_MASK 0xfffc0000
#define BAPM_PARAMETERS_3__Reserved__SHIFT 0x12
#define BAPM_PARAMETERS_4__MinPwrGpu_MASK 0xffff
#define BAPM_PARAMETERS_4__MinPwrGpu__SHIFT 0x0
#define BAPM_PARAMETERS_4__MidPwrCpu_1_MASK 0xff0000
#define BAPM_PARAMETERS_4__MidPwrCpu_1__SHIFT 0x10
#define BAPM_PARAMETERS_4__MidPwrCpu_0_MASK 0xff000000
#define BAPM_PARAMETERS_4__MidPwrCpu_0__SHIFT 0x18
#define SMU_SVI_TELEMETRY__Iddspike_OCP_MASK 0xffff
#define SMU_SVI_TELEMETRY__Iddspike_OCP__SHIFT 0x0
#define SMU_SVI_TELEMETRY__IddNbspike_OCP_MASK 0xffff0000
#define SMU_SVI_TELEMETRY__IddNbspike_OCP__SHIFT 0x10
#define BAPM_STATUS__THROTTLE_MASK 0xff
#define BAPM_STATUS__THROTTLE__SHIFT 0x0
#define BAPM_STATUS__THROTTLE_LAST_MASK 0xff00
#define BAPM_STATUS__THROTTLE_LAST__SHIFT 0x8
#define BAPM_STATUS__COUNT_CORE1_MASK 0xff0000
#define BAPM_STATUS__COUNT_CORE1__SHIFT 0x10
#define BAPM_STATUS__COUNT_CORE0_MASK 0xff000000
#define BAPM_STATUS__COUNT_CORE0__SHIFT 0x18
#define SMU_HTC_STATUS__HTC_ACTIVE_MASK 0x1
#define SMU_HTC_STATUS__HTC_ACTIVE__SHIFT 0x0
#define SMU_HTC_STATUS__Reserved_MASK 0xfffffffe
#define SMU_HTC_STATUS__Reserved__SHIFT 0x1
#define SMU_VPC_STATUS__AllCpuIdleLast_MASK 0x1
#define SMU_VPC_STATUS__AllCpuIdleLast__SHIFT 0x0
#define SMU_VPC_STATUS__Reserved_MASK 0xfffffffe
#define SMU_VPC_STATUS__Reserved__SHIFT 0x1
#define ENTITY_TEMPERATURES_1__CORE0_MASK 0xffffffff
#define ENTITY_TEMPERATURES_1__CORE0__SHIFT 0x0
#define ENTITY_TEMPERATURES_2__CORE1_MASK 0xffffffff
#define ENTITY_TEMPERATURES_2__CORE1__SHIFT 0x0
#define ENTITY_TEMPERATURES_3__GPU_MASK 0xffffffff
#define ENTITY_TEMPERATURES_3__GPU__SHIFT 0x0
#define CU_POWER__CU0_POWER_MASK 0xffff
#define CU_POWER__CU0_POWER__SHIFT 0x0
#define CU_POWER__CU1_POWER_MASK 0xffff0000
#define CU_POWER__CU1_POWER__SHIFT 0x10
#define GPU_POWER__IGPU_POWER_MASK 0xffff
#define GPU_POWER__IGPU_POWER__SHIFT 0x0
#define GPU_POWER__DGPU_POWER_MASK 0xffff0000
#define GPU_POWER__DGPU_POWER__SHIFT 0x10
#define NTE_POWER__NTE0_POWER_MASK 0xffff
#define NTE_POWER__NTE0_POWER__SHIFT 0x0
#define NTE_POWER__NTE1_POWER_MASK 0xffff0000
#define NTE_POWER__NTE1_POWER__SHIFT 0x10
#define TDC_STATUS__VDD_Boost_MASK 0xff
#define TDC_STATUS__VDD_Boost__SHIFT 0x0
#define TDC_STATUS__VDD_Throttle_MASK 0xff00
#define TDC_STATUS__VDD_Throttle__SHIFT 0x8
#define TDC_STATUS__VDDNB_Boost_MASK 0xff0000
#define TDC_STATUS__VDDNB_Boost__SHIFT 0x10
#define TDC_STATUS__VDDNB_Throttle_MASK 0xff000000
#define TDC_STATUS__VDDNB_Throttle__SHIFT 0x18
#define TDC_MV_AVERAGE__IDD_MASK 0xffff
#define TDC_MV_AVERAGE__IDD__SHIFT 0x0
#define TDC_MV_AVERAGE__IDDNB_MASK 0xffff0000
#define TDC_MV_AVERAGE__IDDNB__SHIFT 0x10
#define PM_CONFIG__Enable_VPC_Accumulators_MASK 0x1
#define PM_CONFIG__Enable_VPC_Accumulators__SHIFT 0x0
#define PM_CONFIG__Enable_BAPM_MASK 0x2
#define PM_CONFIG__Enable_BAPM__SHIFT 0x1
#define PM_CONFIG__Enable_TDC_Limit_MASK 0x4
#define PM_CONFIG__Enable_TDC_Limit__SHIFT 0x2
#define PM_CONFIG__Enable_LPMx_MASK 0x8
#define PM_CONFIG__Enable_LPMx__SHIFT 0x3
#define PM_CONFIG__Enable_HTC_Limit_MASK 0x10
#define PM_CONFIG__Enable_HTC_Limit__SHIFT 0x4
#define PM_CONFIG__Enable_NBDPM_MASK 0x20
#define PM_CONFIG__Enable_NBDPM__SHIFT 0x5
#define PM_CONFIG__Enable_LoadLine_MASK 0x40
#define PM_CONFIG__Enable_LoadLine__SHIFT 0x6
#define PM_CONFIG__Reserved_MASK 0xff80
#define PM_CONFIG__Reserved__SHIFT 0x7
#define PM_CONFIG__Override_VPC_Current_MASK 0x10000
#define PM_CONFIG__Override_VPC_Current__SHIFT 0x10
#define PM_CONFIG__Reserved1_MASK 0x60000
#define PM_CONFIG__Reserved1__SHIFT 0x11
#define PM_CONFIG__Override_Calc_Temp_MASK 0x80000
#define PM_CONFIG__Override_Calc_Temp__SHIFT 0x13
#define PM_CONFIG__Enable_Hybrid_Boost_MASK 0x100000
#define PM_CONFIG__Enable_Hybrid_Boost__SHIFT 0x14
#define PM_CONFIG__Reserved2_MASK 0xe00000
#define PM_CONFIG__Reserved2__SHIFT 0x15
#define PM_CONFIG__PSTATE_AllCpusIdle_MASK 0x7000000
#define PM_CONFIG__PSTATE_AllCpusIdle__SHIFT 0x18
#define PM_CONFIG__NBPSTATE_AllCpusIdle_MASK 0x8000000
#define PM_CONFIG__NBPSTATE_AllCpusIdle__SHIFT 0x1b
#define PM_CONFIG__Reserved3_MASK 0x10000000
#define PM_CONFIG__Reserved3__SHIFT 0x1c
#define PM_CONFIG__SVI_Mode_MASK 0x20000000
#define PM_CONFIG__SVI_Mode__SHIFT 0x1d
#define PM_CONFIG__Enable_PDM_MASK 0x40000000
#define PM_CONFIG__Enable_PDM__SHIFT 0x1e
#define PM_CONFIG__Enable_PKG_PWR_LIMIT_MASK 0x80000000
#define PM_CONFIG__Enable_PKG_PWR_LIMIT__SHIFT 0x1f
#define TE0_TEMPERATURE_READ_ADDR__CSR_ADDR_MASK 0x3f
#define TE0_TEMPERATURE_READ_ADDR__CSR_ADDR__SHIFT 0x0
#define TE0_TEMPERATURE_READ_ADDR__TCEN_ID_MASK 0x3c0
#define TE0_TEMPERATURE_READ_ADDR__TCEN_ID__SHIFT 0x6
#define TE0_TEMPERATURE_READ_ADDR__RESERVED_MASK 0xfffffc00
#define TE0_TEMPERATURE_READ_ADDR__RESERVED__SHIFT 0xa
#define TE1_TEMPERATURE_READ_ADDR__CSR_ADDR_MASK 0x3f
#define TE1_TEMPERATURE_READ_ADDR__CSR_ADDR__SHIFT 0x0
#define TE1_TEMPERATURE_READ_ADDR__TCEN_ID_MASK 0x3c0
#define TE1_TEMPERATURE_READ_ADDR__TCEN_ID__SHIFT 0x6
#define TE1_TEMPERATURE_READ_ADDR__RESERVED_MASK 0xfffffc00
#define TE1_TEMPERATURE_READ_ADDR__RESERVED__SHIFT 0xa
#define TE2_TEMPERATURE_READ_ADDR__CSR_ADDR_MASK 0x3f
#define TE2_TEMPERATURE_READ_ADDR__CSR_ADDR__SHIFT 0x0
#define TE2_TEMPERATURE_READ_ADDR__TCEN_ID_MASK 0x3c0
#define TE2_TEMPERATURE_READ_ADDR__TCEN_ID__SHIFT 0x6
#define TE2_TEMPERATURE_READ_ADDR__RESERVED_MASK 0xfffffc00
#define TE2_TEMPERATURE_READ_ADDR__RESERVED__SHIFT 0xa
#define NB_DPM_CONFIG_1__Dpm0PgNbPsLo_MASK 0xff
#define NB_DPM_CONFIG_1__Dpm0PgNbPsLo__SHIFT 0x0
#define NB_DPM_CONFIG_1__Dpm0PgNbPsHi_MASK 0xff00
#define NB_DPM_CONFIG_1__Dpm0PgNbPsHi__SHIFT 0x8
#define NB_DPM_CONFIG_1__DpmXNbPsLo_MASK 0xff0000
#define NB_DPM_CONFIG_1__DpmXNbPsLo__SHIFT 0x10
#define NB_DPM_CONFIG_1__DpmXNbPsHi_MASK 0xff000000
#define NB_DPM_CONFIG_1__DpmXNbPsHi__SHIFT 0x18
#define NB_DPM_CONFIG_2__Hysteresis_MASK 0xff
#define NB_DPM_CONFIG_2__Hysteresis__SHIFT 0x0
#define NB_DPM_CONFIG_2__SkipPG_MASK 0xff00
#define NB_DPM_CONFIG_2__SkipPG__SHIFT 0x8
#define NB_DPM_CONFIG_2__SkipDPM0_MASK 0xff0000
#define NB_DPM_CONFIG_2__SkipDPM0__SHIFT 0x10
#define NB_DPM_CONFIG_2__EnablePSI1_MASK 0xff000000
#define NB_DPM_CONFIG_2__EnablePSI1__SHIFT 0x18
#define NB_DPM_CONFIG_3__RESERVED_MASK 0xffffff
#define NB_DPM_CONFIG_3__RESERVED__SHIFT 0x0
#define NB_DPM_CONFIG_3__EnableDpmPstatePoll_MASK 0xff000000
#define NB_DPM_CONFIG_3__EnableDpmPstatePoll__SHIFT 0x18
#define SMU_IDD_OVERRIDE__IDD_MASK 0xffff
#define SMU_IDD_OVERRIDE__IDD__SHIFT 0x0
#define SMU_IDD_OVERRIDE__IDDNB_MASK 0xffff0000
#define SMU_IDD_OVERRIDE__IDDNB__SHIFT 0x10
#define AVS_CONFIG__AvsEnabledForPstates_MASK 0xff
#define AVS_CONFIG__AvsEnabledForPstates__SHIFT 0x0
#define AVS_CONFIG__AvsOverrideEnabled_MASK 0x100
#define AVS_CONFIG__AvsOverrideEnabled__SHIFT 0x8
#define AVS_CONFIG__AvsPsmTempCompensation_MASK 0x200
#define AVS_CONFIG__AvsPsmTempCompensation__SHIFT 0x9
#define AVS_CONFIG__RESERVED1_MASK 0xfc00
#define AVS_CONFIG__RESERVED1__SHIFT 0xa
#define AVS_CONFIG__AvsOverrideOffset_MASK 0xff0000
#define AVS_CONFIG__AvsOverrideOffset__SHIFT 0x10
#define AVS_CONFIG__RESERVED_MASK 0xff000000
#define AVS_CONFIG__RESERVED__SHIFT 0x18
#define TDC_VRM_LIMIT__IDD_MASK 0xffff
#define TDC_VRM_LIMIT__IDD__SHIFT 0x0
#define TDC_VRM_LIMIT__IDDNB_MASK 0xffff0000
#define TDC_VRM_LIMIT__IDDNB__SHIFT 0x10
#define CU0_PSM_CONFIG__Psm4_MASK 0xff
#define CU0_PSM_CONFIG__Psm4__SHIFT 0x0
#define CU0_PSM_CONFIG__Psm3_MASK 0xff00
#define CU0_PSM_CONFIG__Psm3__SHIFT 0x8
#define CU0_PSM_CONFIG__Psm2_MASK 0xff0000
#define CU0_PSM_CONFIG__Psm2__SHIFT 0x10
#define CU0_PSM_CONFIG__Psm1_MASK 0xff000000
#define CU0_PSM_CONFIG__Psm1__SHIFT 0x18
#define CU1_PSM_CONFIG__Psm4_MASK 0xff
#define CU1_PSM_CONFIG__Psm4__SHIFT 0x0
#define CU1_PSM_CONFIG__Psm3_MASK 0xff00
#define CU1_PSM_CONFIG__Psm3__SHIFT 0x8
#define CU1_PSM_CONFIG__Psm2_MASK 0xff0000
#define CU1_PSM_CONFIG__Psm2__SHIFT 0x10
#define CU1_PSM_CONFIG__Psm1_MASK 0xff000000
#define CU1_PSM_CONFIG__Psm1__SHIFT 0x18
#define SPMI_CONFIG__SpmiTestCode_MASK 0xff
#define SPMI_CONFIG__SpmiTestCode__SHIFT 0x0
#define SPMI_CONFIG__SpmiTestData_MASK 0xff00
#define SPMI_CONFIG__SpmiTestData__SHIFT 0x8
#define SPMI_CONFIG__RESERVED_MASK 0xffff0000
#define SPMI_CONFIG__RESERVED__SHIFT 0x10
#define SPMI_SMC_CHAIN_ADDR__Addr_MASK 0xffffffff
#define SPMI_SMC_CHAIN_ADDR__Addr__SHIFT 0x0
#define SPMI_STATUS__OpDone_MASK 0xff
#define SPMI_STATUS__OpDone__SHIFT 0x0
#define SPMI_STATUS__OpFailed_MASK 0xff00
#define SPMI_STATUS__OpFailed__SHIFT 0x8
#define AVSNB_CONFIG__AvsEnabledForPstates_MASK 0xf
#define AVSNB_CONFIG__AvsEnabledForPstates__SHIFT 0x0
#define AVSNB_CONFIG__RESERVED0_MASK 0xf0
#define AVSNB_CONFIG__RESERVED0__SHIFT 0x4
#define AVSNB_CONFIG__AvsOverrideEnabled_MASK 0x100
#define AVSNB_CONFIG__AvsOverrideEnabled__SHIFT 0x8
#define AVSNB_CONFIG__AvsPsmTempCompensation_MASK 0x200
#define AVSNB_CONFIG__AvsPsmTempCompensation__SHIFT 0x9
#define AVSNB_CONFIG__RESERVED1_MASK 0xfc00
#define AVSNB_CONFIG__RESERVED1__SHIFT 0xa
#define AVSNB_CONFIG__AvsOverrideOffset_MASK 0xff0000
#define AVSNB_CONFIG__AvsOverrideOffset__SHIFT 0x10
#define AVSNB_CONFIG__RESERVED_MASK 0xff000000
#define AVSNB_CONFIG__RESERVED__SHIFT 0x18
#define HTC_CONFIG__CSR_ADDR_MASK 0x3f
#define HTC_CONFIG__CSR_ADDR__SHIFT 0x0
#define HTC_CONFIG__TCEN_ID_MASK 0x3c0
#define HTC_CONFIG__TCEN_ID__SHIFT 0x6
#define HTC_CONFIG__HTC_ACTIVE_PSTATE_LIMIT_MASK 0xff0000
#define HTC_CONFIG__HTC_ACTIVE_PSTATE_LIMIT__SHIFT 0x10
#define HTC_CONFIG__Reserved_MASK 0xff000000
#define HTC_CONFIG__Reserved__SHIFT 0x18
#define AVS_CU0_TEMPERATURE_SENSOR__CsrAddr_MASK 0x3f
#define AVS_CU0_TEMPERATURE_SENSOR__CsrAddr__SHIFT 0x0
#define AVS_CU0_TEMPERATURE_SENSOR__TcenID_MASK 0x3c0
#define AVS_CU0_TEMPERATURE_SENSOR__TcenID__SHIFT 0x6
#define AVS_CU0_TEMPERATURE_SENSOR__RESERVED_MASK 0xfffffc00
#define AVS_CU0_TEMPERATURE_SENSOR__RESERVED__SHIFT 0xa
#define AVS_CU1_TEMPERATURE_SENSOR__CsrAddr_MASK 0x3f
#define AVS_CU1_TEMPERATURE_SENSOR__CsrAddr__SHIFT 0x0
#define AVS_CU1_TEMPERATURE_SENSOR__TcenID_MASK 0x3c0
#define AVS_CU1_TEMPERATURE_SENSOR__TcenID__SHIFT 0x6
#define AVS_CU1_TEMPERATURE_SENSOR__RESERVED_MASK 0xfffffc00
#define AVS_CU1_TEMPERATURE_SENSOR__RESERVED__SHIFT 0xa
#define AVS_GNB_TEMPERATURE_SENSOR__CsrAddr_MASK 0x3f
#define AVS_GNB_TEMPERATURE_SENSOR__CsrAddr__SHIFT 0x0
#define AVS_GNB_TEMPERATURE_SENSOR__TcenID_MASK 0x3c0
#define AVS_GNB_TEMPERATURE_SENSOR__TcenID__SHIFT 0x6
#define AVS_GNB_TEMPERATURE_SENSOR__RESERVED_MASK 0xfffffc00
#define AVS_GNB_TEMPERATURE_SENSOR__RESERVED__SHIFT 0xa
#define AVS_UNB_TEMPERATURE_SENSOR__CsrAddr_MASK 0x3f
#define AVS_UNB_TEMPERATURE_SENSOR__CsrAddr__SHIFT 0x0
#define AVS_UNB_TEMPERATURE_SENSOR__TcenID_MASK 0x3c0
#define AVS_UNB_TEMPERATURE_SENSOR__TcenID__SHIFT 0x6
#define AVS_UNB_TEMPERATURE_SENSOR__RESERVED_MASK 0xfffffc00
#define AVS_UNB_TEMPERATURE_SENSOR__RESERVED__SHIFT 0xa
#define SMU_MONITOR_PORT80_MMIO_ADDR__MMIO_ADDRESS_MASK 0xffffffff
#define SMU_MONITOR_PORT80_MMIO_ADDR__MMIO_ADDRESS__SHIFT 0x0
#define SMU_MONITOR_PORT80_MEMBASE_HI__MEMORY_BASE_HI_MASK 0xffffffff
#define SMU_MONITOR_PORT80_MEMBASE_HI__MEMORY_BASE_HI__SHIFT 0x0
#define SMU_MONITOR_PORT80_MEMBASE_LO__MEMORY_BASE_LO_MASK 0xffffffff
#define SMU_MONITOR_PORT80_MEMBASE_LO__MEMORY_BASE_LO__SHIFT 0x0
#define SMU_MONITOR_PORT80_MEMSETUP__MEMORY_POSITION_MASK 0xffff
#define SMU_MONITOR_PORT80_MEMSETUP__MEMORY_POSITION__SHIFT 0x0
#define SMU_MONITOR_PORT80_MEMSETUP__MEMORY_BUFFER_SIZE_MASK 0xffff0000
#define SMU_MONITOR_PORT80_MEMSETUP__MEMORY_BUFFER_SIZE__SHIFT 0x10
#define SMU_MONITOR_PORT80_CTRL__ENABLE_DRAM_SHADOW_MASK 0x1
#define SMU_MONITOR_PORT80_CTRL__ENABLE_DRAM_SHADOW__SHIFT 0x0
#define SMU_MONITOR_PORT80_CTRL__ENABLE_CSR_SHADOW_MASK 0x2
#define SMU_MONITOR_PORT80_CTRL__ENABLE_CSR_SHADOW__SHIFT 0x1
#define SMU_MONITOR_PORT80_CTRL__RESERVED_MASK 0xfffc
#define SMU_MONITOR_PORT80_CTRL__RESERVED__SHIFT 0x2
#define SMU_MONITOR_PORT80_CTRL__POLLING_INTERVAL_MASK 0xffff0000
#define SMU_MONITOR_PORT80_CTRL__POLLING_INTERVAL__SHIFT 0x10
#define SMU_TCEN_ALIVE__CORE_TCEN_ID_MASK 0xff
#define SMU_TCEN_ALIVE__CORE_TCEN_ID__SHIFT 0x0
#define SMU_TCEN_ALIVE__GNB_TCEN_ID_MASK 0xff00
#define SMU_TCEN_ALIVE__GNB_TCEN_ID__SHIFT 0x8
#define SMU_TCEN_ALIVE__RESERVED_MASK 0xffff0000
#define SMU_TCEN_ALIVE__RESERVED__SHIFT 0x10
#define PDM_STATUS__PDM_ENABLED_MASK 0x1
#define PDM_STATUS__PDM_ENABLED__SHIFT 0x0
#define PDM_STATUS__NewCpcTdpLimit_MASK 0x1fffe
#define PDM_STATUS__NewCpcTdpLimit__SHIFT 0x1
#define PDM_STATUS__NoofConnectedCores_MASK 0x1e0000
#define PDM_STATUS__NoofConnectedCores__SHIFT 0x11
#define PDM_STATUS__Reserved_MASK 0xffe00000
#define PDM_STATUS__Reserved__SHIFT 0x15
#define PDM_CNTL_1__BaseCoreTdpLimit0_MASK 0xff
#define PDM_CNTL_1__BaseCoreTdpLimit0__SHIFT 0x0
#define PDM_CNTL_1__BaseCoreTdpLimit1_MASK 0xff00
#define PDM_CNTL_1__BaseCoreTdpLimit1__SHIFT 0x8
#define PDM_CNTL_1__BaseCoreTdpLimit2_MASK 0xff0000
#define PDM_CNTL_1__BaseCoreTdpLimit2__SHIFT 0x10
#define PDM_CNTL_1__GpuPdmMult_MASK 0xff000000
#define PDM_CNTL_1__GpuPdmMult__SHIFT 0x18
#define PDM_CNTL_2__HeatPdmTc_MASK 0xff
#define PDM_CNTL_2__HeatPdmTc__SHIFT 0x0
#define PDM_CNTL_2__CoolPdmTc_MASK 0xff00
#define PDM_CNTL_2__CoolPdmTc__SHIFT 0x8
#define PDM_CNTL_2__GpuPdmTc_MASK 0xff0000
#define PDM_CNTL_2__GpuPdmTc__SHIFT 0x10
#define PDM_CNTL_2__GpuActThr_MASK 0xff000000
#define PDM_CNTL_2__GpuActThr__SHIFT 0x18
#define PDM_CNTL_3__HeatPdmThr1_MASK 0xff
#define PDM_CNTL_3__HeatPdmThr1__SHIFT 0x0
#define PDM_CNTL_3__HeatPdmThr2_MASK 0xff00
#define PDM_CNTL_3__HeatPdmThr2__SHIFT 0x8
#define PDM_CNTL_3__CoolPdmThr1_MASK 0xff0000
#define PDM_CNTL_3__CoolPdmThr1__SHIFT 0x10
#define PDM_CNTL_3__CoolPdmThr2_MASK 0xff000000
#define PDM_CNTL_3__CoolPdmThr2__SHIFT 0x18
#define SMU_PM_STATUS_0__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_0__DATA__SHIFT 0x0
#define SMU_PM_STATUS_1__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_1__DATA__SHIFT 0x0
#define SMU_PM_STATUS_2__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_2__DATA__SHIFT 0x0
#define SMU_PM_STATUS_3__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_3__DATA__SHIFT 0x0
#define SMU_PM_STATUS_4__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_4__DATA__SHIFT 0x0
#define SMU_PM_STATUS_5__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_5__DATA__SHIFT 0x0
#define SMU_PM_STATUS_6__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_6__DATA__SHIFT 0x0
#define SMU_PM_STATUS_7__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_7__DATA__SHIFT 0x0
#define SMU_PM_STATUS_8__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_8__DATA__SHIFT 0x0
#define SMU_PM_STATUS_9__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_9__DATA__SHIFT 0x0
#define SMU_PM_STATUS_10__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_10__DATA__SHIFT 0x0
#define SMU_PM_STATUS_11__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_11__DATA__SHIFT 0x0
#define SMU_PM_STATUS_12__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_12__DATA__SHIFT 0x0
#define SMU_PM_STATUS_13__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_13__DATA__SHIFT 0x0
#define SMU_PM_STATUS_14__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_14__DATA__SHIFT 0x0
#define SMU_PM_STATUS_15__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_15__DATA__SHIFT 0x0
#define SMU_PM_STATUS_16__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_16__DATA__SHIFT 0x0
#define SMU_PM_STATUS_17__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_17__DATA__SHIFT 0x0
#define SMU_PM_STATUS_18__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_18__DATA__SHIFT 0x0
#define SMU_PM_STATUS_19__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_19__DATA__SHIFT 0x0
#define SMU_PM_STATUS_20__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_20__DATA__SHIFT 0x0
#define SMU_PM_STATUS_21__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_21__DATA__SHIFT 0x0
#define SMU_PM_STATUS_22__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_22__DATA__SHIFT 0x0
#define SMU_PM_STATUS_23__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_23__DATA__SHIFT 0x0
#define SMU_PM_STATUS_24__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_24__DATA__SHIFT 0x0
#define SMU_PM_STATUS_25__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_25__DATA__SHIFT 0x0
#define SMU_PM_STATUS_26__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_26__DATA__SHIFT 0x0
#define SMU_PM_STATUS_27__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_27__DATA__SHIFT 0x0
#define SMU_PM_STATUS_28__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_28__DATA__SHIFT 0x0
#define SMU_PM_STATUS_29__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_29__DATA__SHIFT 0x0
#define SMU_PM_STATUS_30__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_30__DATA__SHIFT 0x0
#define SMU_PM_STATUS_31__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_31__DATA__SHIFT 0x0
#define SMU_PM_STATUS_32__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_32__DATA__SHIFT 0x0
#define SMU_PM_STATUS_33__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_33__DATA__SHIFT 0x0
#define SMU_PM_STATUS_34__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_34__DATA__SHIFT 0x0
#define SMU_PM_STATUS_35__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_35__DATA__SHIFT 0x0
#define SMU_PM_STATUS_36__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_36__DATA__SHIFT 0x0
#define SMU_PM_STATUS_37__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_37__DATA__SHIFT 0x0
#define SMU_PM_STATUS_38__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_38__DATA__SHIFT 0x0
#define SMU_PM_STATUS_39__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_39__DATA__SHIFT 0x0
#define SMU_PM_STATUS_40__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_40__DATA__SHIFT 0x0
#define SMU_PM_STATUS_41__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_41__DATA__SHIFT 0x0
#define SMU_PM_STATUS_42__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_42__DATA__SHIFT 0x0
#define SMU_PM_STATUS_43__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_43__DATA__SHIFT 0x0
#define SMU_PM_STATUS_44__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_44__DATA__SHIFT 0x0
#define SMU_PM_STATUS_45__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_45__DATA__SHIFT 0x0
#define SMU_PM_STATUS_46__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_46__DATA__SHIFT 0x0
#define SMU_PM_STATUS_47__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_47__DATA__SHIFT 0x0
#define SMU_PM_STATUS_48__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_48__DATA__SHIFT 0x0
#define SMU_PM_STATUS_49__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_49__DATA__SHIFT 0x0
#define SMU_PM_STATUS_50__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_50__DATA__SHIFT 0x0
#define SMU_PM_STATUS_51__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_51__DATA__SHIFT 0x0
#define SMU_PM_STATUS_52__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_52__DATA__SHIFT 0x0
#define SMU_PM_STATUS_53__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_53__DATA__SHIFT 0x0
#define SMU_PM_STATUS_54__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_54__DATA__SHIFT 0x0
#define SMU_PM_STATUS_55__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_55__DATA__SHIFT 0x0
#define SMU_PM_STATUS_56__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_56__DATA__SHIFT 0x0
#define SMU_PM_STATUS_57__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_57__DATA__SHIFT 0x0
#define SMU_PM_STATUS_58__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_58__DATA__SHIFT 0x0
#define SMU_PM_STATUS_59__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_59__DATA__SHIFT 0x0
#define SMU_PM_STATUS_60__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_60__DATA__SHIFT 0x0
#define SMU_PM_STATUS_61__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_61__DATA__SHIFT 0x0
#define SMU_PM_STATUS_62__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_62__DATA__SHIFT 0x0
#define SMU_PM_STATUS_63__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_63__DATA__SHIFT 0x0
#define SMU_PM_STATUS_64__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_64__DATA__SHIFT 0x0
#define SMU_PM_STATUS_65__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_65__DATA__SHIFT 0x0
#define SMU_PM_STATUS_66__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_66__DATA__SHIFT 0x0
#define SMU_PM_STATUS_67__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_67__DATA__SHIFT 0x0
#define SMU_PM_STATUS_68__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_68__DATA__SHIFT 0x0
#define SMU_PM_STATUS_69__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_69__DATA__SHIFT 0x0
#define SMU_PM_STATUS_70__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_70__DATA__SHIFT 0x0
#define SMU_PM_STATUS_71__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_71__DATA__SHIFT 0x0
#define SMU_PM_STATUS_72__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_72__DATA__SHIFT 0x0
#define SMU_PM_STATUS_73__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_73__DATA__SHIFT 0x0
#define SMU_PM_STATUS_74__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_74__DATA__SHIFT 0x0
#define SMU_PM_STATUS_75__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_75__DATA__SHIFT 0x0
#define SMU_PM_STATUS_76__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_76__DATA__SHIFT 0x0
#define SMU_PM_STATUS_77__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_77__DATA__SHIFT 0x0
#define SMU_PM_STATUS_78__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_78__DATA__SHIFT 0x0
#define SMU_PM_STATUS_79__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_79__DATA__SHIFT 0x0
#define SMU_PM_STATUS_80__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_80__DATA__SHIFT 0x0
#define SMU_PM_STATUS_81__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_81__DATA__SHIFT 0x0
#define SMU_PM_STATUS_82__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_82__DATA__SHIFT 0x0
#define SMU_PM_STATUS_83__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_83__DATA__SHIFT 0x0
#define SMU_PM_STATUS_84__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_84__DATA__SHIFT 0x0
#define SMU_PM_STATUS_85__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_85__DATA__SHIFT 0x0
#define SMU_PM_STATUS_86__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_86__DATA__SHIFT 0x0
#define SMU_PM_STATUS_87__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_87__DATA__SHIFT 0x0
#define SMU_PM_STATUS_88__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_88__DATA__SHIFT 0x0
#define SMU_PM_STATUS_89__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_89__DATA__SHIFT 0x0
#define SMU_PM_STATUS_90__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_90__DATA__SHIFT 0x0
#define SMU_PM_STATUS_91__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_91__DATA__SHIFT 0x0
#define SMU_PM_STATUS_92__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_92__DATA__SHIFT 0x0
#define SMU_PM_STATUS_93__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_93__DATA__SHIFT 0x0
#define SMU_PM_STATUS_94__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_94__DATA__SHIFT 0x0
#define SMU_PM_STATUS_95__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_95__DATA__SHIFT 0x0
#define SMU_PM_STATUS_96__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_96__DATA__SHIFT 0x0
#define SMU_PM_STATUS_97__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_97__DATA__SHIFT 0x0
#define SMU_PM_STATUS_98__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_98__DATA__SHIFT 0x0
#define SMU_PM_STATUS_99__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_99__DATA__SHIFT 0x0
#define SMU_PM_STATUS_100__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_100__DATA__SHIFT 0x0
#define SMU_PM_STATUS_101__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_101__DATA__SHIFT 0x0
#define SMU_PM_STATUS_102__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_102__DATA__SHIFT 0x0
#define SMU_PM_STATUS_103__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_103__DATA__SHIFT 0x0
#define SMU_PM_STATUS_104__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_104__DATA__SHIFT 0x0
#define SMU_PM_STATUS_105__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_105__DATA__SHIFT 0x0
#define SMU_PM_STATUS_106__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_106__DATA__SHIFT 0x0
#define SMU_PM_STATUS_107__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_107__DATA__SHIFT 0x0
#define SMU_PM_STATUS_108__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_108__DATA__SHIFT 0x0
#define SMU_PM_STATUS_109__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_109__DATA__SHIFT 0x0
#define SMU_PM_STATUS_110__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_110__DATA__SHIFT 0x0
#define SMU_PM_STATUS_111__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_111__DATA__SHIFT 0x0
#define SMU_PM_STATUS_112__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_112__DATA__SHIFT 0x0
#define SMU_PM_STATUS_113__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_113__DATA__SHIFT 0x0
#define SMU_PM_STATUS_114__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_114__DATA__SHIFT 0x0
#define SMU_PM_STATUS_115__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_115__DATA__SHIFT 0x0
#define SMU_PM_STATUS_116__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_116__DATA__SHIFT 0x0
#define SMU_PM_STATUS_117__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_117__DATA__SHIFT 0x0
#define SMU_PM_STATUS_118__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_118__DATA__SHIFT 0x0
#define SMU_PM_STATUS_119__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_119__DATA__SHIFT 0x0
#define SMU_PM_STATUS_120__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_120__DATA__SHIFT 0x0
#define SMU_PM_STATUS_121__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_121__DATA__SHIFT 0x0
#define SMU_PM_STATUS_122__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_122__DATA__SHIFT 0x0
#define SMU_PM_STATUS_123__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_123__DATA__SHIFT 0x0
#define SMU_PM_STATUS_124__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_124__DATA__SHIFT 0x0
#define SMU_PM_STATUS_125__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_125__DATA__SHIFT 0x0
#define SMU_PM_STATUS_126__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_126__DATA__SHIFT 0x0
#define SMU_PM_STATUS_127__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_127__DATA__SHIFT 0x0
#define CG_THERMAL_INT_ENA__THERM_INTH_SET_MASK 0x1
#define CG_THERMAL_INT_ENA__THERM_INTH_SET__SHIFT 0x0
#define CG_THERMAL_INT_ENA__THERM_INTL_SET_MASK 0x2
#define CG_THERMAL_INT_ENA__THERM_INTL_SET__SHIFT 0x1
#define CG_THERMAL_INT_ENA__THERM_TRIGGER_SET_MASK 0x4
#define CG_THERMAL_INT_ENA__THERM_TRIGGER_SET__SHIFT 0x2
#define CG_THERMAL_INT_ENA__THERM_INTH_CLR_MASK 0x8
#define CG_THERMAL_INT_ENA__THERM_INTH_CLR__SHIFT 0x3
#define CG_THERMAL_INT_ENA__THERM_INTL_CLR_MASK 0x10
#define CG_THERMAL_INT_ENA__THERM_INTL_CLR__SHIFT 0x4
#define CG_THERMAL_INT_ENA__THERM_TRIGGER_CLR_MASK 0x20
#define CG_THERMAL_INT_ENA__THERM_TRIGGER_CLR__SHIFT 0x5
#define CG_THERMAL_INT_CTRL__DIG_THERM_INTH_MASK 0xff
#define CG_THERMAL_INT_CTRL__DIG_THERM_INTH__SHIFT 0x0
#define CG_THERMAL_INT_CTRL__DIG_THERM_INTL_MASK 0xff00
#define CG_THERMAL_INT_CTRL__DIG_THERM_INTL__SHIFT 0x8
#define CG_THERMAL_INT_CTRL__GNB_TEMP_THRESHOLD_MASK 0xff0000
#define CG_THERMAL_INT_CTRL__GNB_TEMP_THRESHOLD__SHIFT 0x10
#define CG_THERMAL_INT_CTRL__THERM_INTH_MASK_MASK 0x1000000
#define CG_THERMAL_INT_CTRL__THERM_INTH_MASK__SHIFT 0x18
#define CG_THERMAL_INT_CTRL__THERM_INTL_MASK_MASK 0x2000000
#define CG_THERMAL_INT_CTRL__THERM_INTL_MASK__SHIFT 0x19
#define CG_THERMAL_INT_CTRL__THERM_TRIGGER_MASK_MASK 0x4000000
#define CG_THERMAL_INT_CTRL__THERM_TRIGGER_MASK__SHIFT 0x1a
#define CG_THERMAL_INT_CTRL__THERM_TRIGGER_CNB_MASK_MASK 0x8000000
#define CG_THERMAL_INT_CTRL__THERM_TRIGGER_CNB_MASK__SHIFT 0x1b
#define CG_THERMAL_INT_CTRL__THERM_GNB_HW_ENA_MASK 0x10000000
#define CG_THERMAL_INT_CTRL__THERM_GNB_HW_ENA__SHIFT 0x1c
#define CG_THERMAL_INT_STATUS__THERM_INTH_DETECT_MASK 0x1
#define CG_THERMAL_INT_STATUS__THERM_INTH_DETECT__SHIFT 0x0
#define CG_THERMAL_INT_STATUS__THERM_INTL_DETECT_MASK 0x2
#define CG_THERMAL_INT_STATUS__THERM_INTL_DETECT__SHIFT 0x1
#define CG_THERMAL_INT_STATUS__THERM_TRIGGER_DETECT_MASK 0x4
#define CG_THERMAL_INT_STATUS__THERM_TRIGGER_DETECT__SHIFT 0x2
#define CG_THERMAL_INT_STATUS__THERM_TRIGGER_CNB_DETECT_MASK 0x8
#define CG_THERMAL_INT_STATUS__THERM_TRIGGER_CNB_DETECT__SHIFT 0x3
#define GENERAL_PWRMGT__GLOBAL_PWRMGT_EN_MASK 0x1
#define GENERAL_PWRMGT__GLOBAL_PWRMGT_EN__SHIFT 0x0
#define GENERAL_PWRMGT__STATIC_PM_EN_MASK 0x2
#define GENERAL_PWRMGT__STATIC_PM_EN__SHIFT 0x1
#define GENERAL_PWRMGT__THERMAL_PROTECTION_DIS_MASK 0x4
#define GENERAL_PWRMGT__THERMAL_PROTECTION_DIS__SHIFT 0x2
#define GENERAL_PWRMGT__THERMAL_PROTECTION_TYPE_MASK 0x8
#define GENERAL_PWRMGT__THERMAL_PROTECTION_TYPE__SHIFT 0x3
#define GENERAL_PWRMGT__SW_SMIO_INDEX_MASK 0x40
#define GENERAL_PWRMGT__SW_SMIO_INDEX__SHIFT 0x6
#define GENERAL_PWRMGT__LOW_VOLT_D2_ACPI_MASK 0x100
#define GENERAL_PWRMGT__LOW_VOLT_D2_ACPI__SHIFT 0x8
#define GENERAL_PWRMGT__LOW_VOLT_D3_ACPI_MASK 0x200
#define GENERAL_PWRMGT__LOW_VOLT_D3_ACPI__SHIFT 0x9
#define GENERAL_PWRMGT__VOLT_PWRMGT_EN_MASK 0x400
#define GENERAL_PWRMGT__VOLT_PWRMGT_EN__SHIFT 0xa
#define GENERAL_PWRMGT__SPARE11_MASK 0x800
#define GENERAL_PWRMGT__SPARE11__SHIFT 0xb
#define GENERAL_PWRMGT__GPU_COUNTER_ACPI_MASK 0x4000
#define GENERAL_PWRMGT__GPU_COUNTER_ACPI__SHIFT 0xe
#define GENERAL_PWRMGT__GPU_COUNTER_CLK_MASK 0x8000
#define GENERAL_PWRMGT__GPU_COUNTER_CLK__SHIFT 0xf
#define GENERAL_PWRMGT__GPU_COUNTER_OFF_MASK 0x10000
#define GENERAL_PWRMGT__GPU_COUNTER_OFF__SHIFT 0x10
#define GENERAL_PWRMGT__GPU_COUNTER_INTF_OFF_MASK 0x20000
#define GENERAL_PWRMGT__GPU_COUNTER_INTF_OFF__SHIFT 0x11
#define GENERAL_PWRMGT__SPARE18_MASK 0x40000
#define GENERAL_PWRMGT__SPARE18__SHIFT 0x12
#define GENERAL_PWRMGT__ACPI_D3_VID_MASK 0x180000
#define GENERAL_PWRMGT__ACPI_D3_VID__SHIFT 0x13
#define GENERAL_PWRMGT__DYN_SPREAD_SPECTRUM_EN_MASK 0x800000
#define GENERAL_PWRMGT__DYN_SPREAD_SPECTRUM_EN__SHIFT 0x17
#define GENERAL_PWRMGT__SPARE27_MASK 0x8000000
#define GENERAL_PWRMGT__SPARE27__SHIFT 0x1b
#define GENERAL_PWRMGT__SPARE_MASK 0xf0000000
#define GENERAL_PWRMGT__SPARE__SHIFT 0x1c
#define CNB_PWRMGT_CNTL__GNB_SLOW_MODE_MASK 0x3
#define CNB_PWRMGT_CNTL__GNB_SLOW_MODE__SHIFT 0x0
#define CNB_PWRMGT_CNTL__GNB_SLOW_MASK 0x4
#define CNB_PWRMGT_CNTL__GNB_SLOW__SHIFT 0x2
#define CNB_PWRMGT_CNTL__FORCE_NB_PS1_MASK 0x8
#define CNB_PWRMGT_CNTL__FORCE_NB_PS1__SHIFT 0x3
#define CNB_PWRMGT_CNTL__DPM_ENABLED_MASK 0x10
#define CNB_PWRMGT_CNTL__DPM_ENABLED__SHIFT 0x4
#define CNB_PWRMGT_CNTL__SPARE_MASK 0xffffffe0
#define CNB_PWRMGT_CNTL__SPARE__SHIFT 0x5
#define SCLK_PWRMGT_CNTL__SCLK_PWRMGT_OFF_MASK 0x1
#define SCLK_PWRMGT_CNTL__SCLK_PWRMGT_OFF__SHIFT 0x0
#define SCLK_PWRMGT_CNTL__SCLK_LOW_D1_MASK 0x2
#define SCLK_PWRMGT_CNTL__SCLK_LOW_D1__SHIFT 0x1
#define SCLK_PWRMGT_CNTL__DYN_PWR_DOWN_EN_MASK 0x4
#define SCLK_PWRMGT_CNTL__DYN_PWR_DOWN_EN__SHIFT 0x2
#define SCLK_PWRMGT_CNTL__RESET_BUSY_CNT_MASK 0x10
#define SCLK_PWRMGT_CNTL__RESET_BUSY_CNT__SHIFT 0x4
#define SCLK_PWRMGT_CNTL__RESET_SCLK_CNT_MASK 0x20
#define SCLK_PWRMGT_CNTL__RESET_SCLK_CNT__SHIFT 0x5
#define SCLK_PWRMGT_CNTL__RESERVED_0_MASK 0x40
#define SCLK_PWRMGT_CNTL__RESERVED_0__SHIFT 0x6
#define SCLK_PWRMGT_CNTL__DYN_GFX_CLK_OFF_EN_MASK 0x80
#define SCLK_PWRMGT_CNTL__DYN_GFX_CLK_OFF_EN__SHIFT 0x7
#define SCLK_PWRMGT_CNTL__GFX_CLK_FORCE_ON_MASK 0x100
#define SCLK_PWRMGT_CNTL__GFX_CLK_FORCE_ON__SHIFT 0x8
#define SCLK_PWRMGT_CNTL__GFX_CLK_REQUEST_OFF_MASK 0x200
#define SCLK_PWRMGT_CNTL__GFX_CLK_REQUEST_OFF__SHIFT 0x9
#define SCLK_PWRMGT_CNTL__GFX_CLK_FORCE_OFF_MASK 0x400
#define SCLK_PWRMGT_CNTL__GFX_CLK_FORCE_OFF__SHIFT 0xa
#define SCLK_PWRMGT_CNTL__GFX_CLK_OFF_ACPI_D1_MASK 0x800
#define SCLK_PWRMGT_CNTL__GFX_CLK_OFF_ACPI_D1__SHIFT 0xb
#define SCLK_PWRMGT_CNTL__GFX_CLK_OFF_ACPI_D2_MASK 0x1000
#define SCLK_PWRMGT_CNTL__GFX_CLK_OFF_ACPI_D2__SHIFT 0xc
#define SCLK_PWRMGT_CNTL__GFX_CLK_OFF_ACPI_D3_MASK 0x2000
#define SCLK_PWRMGT_CNTL__GFX_CLK_OFF_ACPI_D3__SHIFT 0xd
#define SCLK_PWRMGT_CNTL__DYN_LIGHT_SLEEP_EN_MASK 0x4000
#define SCLK_PWRMGT_CNTL__DYN_LIGHT_SLEEP_EN__SHIFT 0xe
#define SCLK_PWRMGT_CNTL__AUTO_SCLK_PULSE_SKIP_MASK 0x8000
#define SCLK_PWRMGT_CNTL__AUTO_SCLK_PULSE_SKIP__SHIFT 0xf
#define SCLK_PWRMGT_CNTL__LIGHT_SLEEP_COUNTER_MASK 0x1f0000
#define SCLK_PWRMGT_CNTL__LIGHT_SLEEP_COUNTER__SHIFT 0x10
#define SCLK_PWRMGT_CNTL__DYNAMIC_PM_EN_MASK 0x200000
#define SCLK_PWRMGT_CNTL__DYNAMIC_PM_EN__SHIFT 0x15
#define SCLK_PWRMGT_CNTL__DPM_DYN_PWR_DOWN_CNTL_MASK 0x400000
#define SCLK_PWRMGT_CNTL__DPM_DYN_PWR_DOWN_CNTL__SHIFT 0x16
#define SCLK_PWRMGT_CNTL__DPM_DYN_PWR_DOWN_EN_MASK 0x800000
#define SCLK_PWRMGT_CNTL__DPM_DYN_PWR_DOWN_EN__SHIFT 0x17
#define SCLK_PWRMGT_CNTL__RESERVED_3_MASK 0x1000000
#define SCLK_PWRMGT_CNTL__RESERVED_3__SHIFT 0x18
#define SCLK_PWRMGT_CNTL__VOLTAGE_UPDATE_EN_MASK 0x2000000
#define SCLK_PWRMGT_CNTL__VOLTAGE_UPDATE_EN__SHIFT 0x19
#define SCLK_PWRMGT_CNTL__FORCE_PM0_INTERRUPT_MASK 0x10000000
#define SCLK_PWRMGT_CNTL__FORCE_PM0_INTERRUPT__SHIFT 0x1c
#define SCLK_PWRMGT_CNTL__FORCE_PM1_INTERRUPT_MASK 0x20000000
#define SCLK_PWRMGT_CNTL__FORCE_PM1_INTERRUPT__SHIFT 0x1d
#define SCLK_PWRMGT_CNTL__GFX_VOLTAGE_CHANGE_EN_MASK 0x40000000
#define SCLK_PWRMGT_CNTL__GFX_VOLTAGE_CHANGE_EN__SHIFT 0x1e
#define SCLK_PWRMGT_CNTL__GFX_VOLTAGE_CHANGE_MODE_MASK 0x80000000
#define SCLK_PWRMGT_CNTL__GFX_VOLTAGE_CHANGE_MODE__SHIFT 0x1f
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARGET_STATE_MASK 0xf
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARGET_STATE__SHIFT 0x0
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURRENT_STATE_MASK 0xf0
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURRENT_STATE__SHIFT 0x4
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_MCLK_INDEX_MASK 0xf00
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_MCLK_INDEX__SHIFT 0x8
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_MCLK_INDEX_MASK 0xf000
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_MCLK_INDEX__SHIFT 0xc
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_SCLK_INDEX_MASK 0x1f0000
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_SCLK_INDEX__SHIFT 0x10
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_SCLK_INDEX_MASK 0x3e00000
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_SCLK_INDEX__SHIFT 0x15
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_LCLK_INDEX_MASK 0x1c000000
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_LCLK_INDEX__SHIFT 0x1a
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_LCLK_INDEX_MASK 0xe0000000
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_LCLK_INDEX__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_0__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_0__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_0__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_0__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_0__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_0__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_0__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_0__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_0__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_0__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_0__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_0__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_0__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_0__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_0__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_0__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_0__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_0__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_0__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_0__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_0__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_0__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_0__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_0__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_0__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_0__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_0__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_0__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_0__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_0__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_0__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_0__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_0__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_0__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_0__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_0__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_0__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_0__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_0__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_0__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_0__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_0__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_0__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_0__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_0__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_0__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_0__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_0__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_0__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_0__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_0__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_0__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_0__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_0__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_0__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_0__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_1__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_1__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_1__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_1__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_1__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_1__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_1__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_1__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_1__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_1__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_1__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_1__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_1__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_1__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_1__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_1__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_1__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_1__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_1__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_1__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_1__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_1__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_1__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_1__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_1__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_1__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_1__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_1__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_1__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_1__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_1__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_1__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_1__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_1__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_1__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_1__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_1__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_1__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_1__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_1__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_1__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_1__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_1__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_1__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_1__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_1__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_1__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_1__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_1__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_1__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_1__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_1__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_1__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_1__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_1__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_1__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_2__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_2__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_2__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_2__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_2__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_2__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_2__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_2__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_2__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_2__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_2__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_2__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_2__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_2__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_2__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_2__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_2__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_2__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_2__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_2__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_2__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_2__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_2__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_2__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_2__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_2__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_2__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_2__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_2__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_2__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_2__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_2__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_2__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_2__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_2__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_2__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_2__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_2__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_2__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_2__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_2__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_2__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_2__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_2__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_2__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_2__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_2__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_2__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_2__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_2__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_2__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_2__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_2__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_2__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_2__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_2__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_3__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_3__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_3__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_3__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_3__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_3__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_3__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_3__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_3__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_3__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_3__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_3__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_3__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_3__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_3__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_3__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_3__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_3__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_3__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_3__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_3__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_3__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_3__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_3__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_3__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_3__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_3__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_3__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_3__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_3__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_3__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_3__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_3__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_3__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_3__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_3__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_3__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_3__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_3__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_3__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_3__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_3__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_3__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_3__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_3__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_3__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_3__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_3__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_3__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_3__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_3__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_3__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_3__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_3__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_3__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_3__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_4__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_4__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_4__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_4__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_4__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_4__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_4__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_4__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_4__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_4__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_4__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_4__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_4__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_4__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_4__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_4__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_4__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_4__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_4__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_4__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_4__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_4__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_4__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_4__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_4__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_4__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_4__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_4__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_4__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_4__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_4__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_4__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_4__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_4__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_4__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_4__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_4__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_4__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_4__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_4__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_4__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_4__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_4__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_4__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_4__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_4__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_4__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_4__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_4__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_4__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_4__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_4__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_4__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_4__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_4__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_4__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_5__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_5__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_5__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_5__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_5__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_5__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_5__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_5__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_5__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_5__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_5__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_5__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_5__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_5__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_5__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_5__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_5__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_5__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_5__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_5__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_5__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_5__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_5__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_5__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_5__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_5__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_5__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_5__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_5__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_5__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_5__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_5__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_5__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_5__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_5__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_5__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_5__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_5__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_5__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_5__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_5__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_5__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_5__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_5__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_5__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_5__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_5__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_5__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_5__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_5__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_5__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_5__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_5__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_5__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_5__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_5__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_6__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_6__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_6__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_6__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_6__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_6__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_6__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_6__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_6__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_6__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_6__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_6__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_6__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_6__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_6__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_6__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_6__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_6__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_6__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_6__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_6__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_6__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_6__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_6__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_6__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_6__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_6__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_6__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_6__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_6__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_6__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_6__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_6__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_6__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_6__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_6__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_6__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_6__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_6__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_6__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_6__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_6__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_6__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_6__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_6__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_6__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_6__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_6__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_6__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_6__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_6__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_6__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_6__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_6__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_6__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_6__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_7__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_7__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_7__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_7__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_7__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_7__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_7__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_7__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_7__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_7__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_7__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_7__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_7__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_7__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_7__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_7__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_7__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_7__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_7__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_7__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_7__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_7__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_7__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_7__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_7__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_7__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_7__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_7__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_7__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_7__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_7__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_7__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_7__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_7__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_7__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_7__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_7__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_7__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_7__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_7__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_7__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_7__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_7__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_7__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_7__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_7__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_7__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_7__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_7__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_7__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_7__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_7__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_7__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_7__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_7__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_7__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define PLL_TEST_CNTL__TST_SRC_SEL_MASK 0xf
#define PLL_TEST_CNTL__TST_SRC_SEL__SHIFT 0x0
#define PLL_TEST_CNTL__TST_REF_SEL_MASK 0xf0
#define PLL_TEST_CNTL__TST_REF_SEL__SHIFT 0x4
#define PLL_TEST_CNTL__REF_TEST_COUNT_MASK 0x7f00
#define PLL_TEST_CNTL__REF_TEST_COUNT__SHIFT 0x8
#define PLL_TEST_CNTL__TST_RESET_MASK 0x8000
#define PLL_TEST_CNTL__TST_RESET__SHIFT 0xf
#define PLL_TEST_CNTL__TEST_COUNT_MASK 0xfffe0000
#define PLL_TEST_CNTL__TEST_COUNT__SHIFT 0x11
#define CG_STATIC_SCREEN_PARAMETER__STATIC_SCREEN_THRESHOLD_MASK 0xffff
#define CG_STATIC_SCREEN_PARAMETER__STATIC_SCREEN_THRESHOLD__SHIFT 0x0
#define CG_STATIC_SCREEN_PARAMETER__STATIC_SCREEN_THRESHOLD_UNIT_MASK 0xf0000
#define CG_STATIC_SCREEN_PARAMETER__STATIC_SCREEN_THRESHOLD_UNIT__SHIFT 0x10
#define CG_DISPLAY_GAP_CNTL__DISP_GAP_MASK 0x3
#define CG_DISPLAY_GAP_CNTL__DISP_GAP__SHIFT 0x0
#define CG_DISPLAY_GAP_CNTL__VBI_TIMER_COUNT_MASK 0x3fff0
#define CG_DISPLAY_GAP_CNTL__VBI_TIMER_COUNT__SHIFT 0x4
#define CG_DISPLAY_GAP_CNTL__VBI_TIMER_UNIT_MASK 0x700000
#define CG_DISPLAY_GAP_CNTL__VBI_TIMER_UNIT__SHIFT 0x14
#define CG_DISPLAY_GAP_CNTL__DISP_GAP_MCHG_MASK 0x3000000
#define CG_DISPLAY_GAP_CNTL__DISP_GAP_MCHG__SHIFT 0x18
#define CG_DISPLAY_GAP_CNTL__VBI_TIMER_DISABLE_MASK 0x10000000
#define CG_DISPLAY_GAP_CNTL__VBI_TIMER_DISABLE__SHIFT 0x1c
#define CG_DISPLAY_GAP_CNTL2__VBI_PREDICTION_MASK 0xffffffff
#define CG_DISPLAY_GAP_CNTL2__VBI_PREDICTION__SHIFT 0x0
#define CG_ACPI_CNTL__SCLK_ACPI_DIV_MASK 0x7f
#define CG_ACPI_CNTL__SCLK_ACPI_DIV__SHIFT 0x0
#define CG_ACPI_CNTL__SCLK_CHANGE_SKIP_MASK 0x80
#define CG_ACPI_CNTL__SCLK_CHANGE_SKIP__SHIFT 0x7
#define SCLK_DEEP_SLEEP_CNTL__DIV_ID_MASK 0x7
#define SCLK_DEEP_SLEEP_CNTL__DIV_ID__SHIFT 0x0
#define SCLK_DEEP_SLEEP_CNTL__RAMP_DIS_MASK 0x8
#define SCLK_DEEP_SLEEP_CNTL__RAMP_DIS__SHIFT 0x3
#define SCLK_DEEP_SLEEP_CNTL__HYSTERESIS_MASK 0xfff0
#define SCLK_DEEP_SLEEP_CNTL__HYSTERESIS__SHIFT 0x4
#define SCLK_DEEP_SLEEP_CNTL__SCLK_RUNNING_MASK_MASK 0x10000
#define SCLK_DEEP_SLEEP_CNTL__SCLK_RUNNING_MASK__SHIFT 0x10
#define SCLK_DEEP_SLEEP_CNTL__SELF_REFRESH_MASK_MASK 0x20000
#define SCLK_DEEP_SLEEP_CNTL__SELF_REFRESH_MASK__SHIFT 0x11
#define SCLK_DEEP_SLEEP_CNTL__ALLOW_NBPSTATE_MASK_MASK 0x40000
#define SCLK_DEEP_SLEEP_CNTL__ALLOW_NBPSTATE_MASK__SHIFT 0x12
#define SCLK_DEEP_SLEEP_CNTL__BIF_BUSY_MASK_MASK 0x80000
#define SCLK_DEEP_SLEEP_CNTL__BIF_BUSY_MASK__SHIFT 0x13
#define SCLK_DEEP_SLEEP_CNTL__UVD_BUSY_MASK_MASK 0x100000
#define SCLK_DEEP_SLEEP_CNTL__UVD_BUSY_MASK__SHIFT 0x14
#define SCLK_DEEP_SLEEP_CNTL__MC0SRBM_BUSY_MASK_MASK 0x200000
#define SCLK_DEEP_SLEEP_CNTL__MC0SRBM_BUSY_MASK__SHIFT 0x15
#define SCLK_DEEP_SLEEP_CNTL__MC1SRBM_BUSY_MASK_MASK 0x400000
#define SCLK_DEEP_SLEEP_CNTL__MC1SRBM_BUSY_MASK__SHIFT 0x16
#define SCLK_DEEP_SLEEP_CNTL__MC_ALLOW_MASK_MASK 0x800000
#define SCLK_DEEP_SLEEP_CNTL__MC_ALLOW_MASK__SHIFT 0x17
#define SCLK_DEEP_SLEEP_CNTL__SMU_BUSY_MASK_MASK 0x1000000
#define SCLK_DEEP_SLEEP_CNTL__SMU_BUSY_MASK__SHIFT 0x18
#define SCLK_DEEP_SLEEP_CNTL__SELF_REFRESH_NLC_MASK_MASK 0x2000000
#define SCLK_DEEP_SLEEP_CNTL__SELF_REFRESH_NLC_MASK__SHIFT 0x19
#define SCLK_DEEP_SLEEP_CNTL__FAST_EXIT_REQ_NBPSTATE_MASK 0x4000000
#define SCLK_DEEP_SLEEP_CNTL__FAST_EXIT_REQ_NBPSTATE__SHIFT 0x1a
#define SCLK_DEEP_SLEEP_CNTL__DEEP_SLEEP_ENTRY_MODE_MASK 0x8000000
#define SCLK_DEEP_SLEEP_CNTL__DEEP_SLEEP_ENTRY_MODE__SHIFT 0x1b
#define SCLK_DEEP_SLEEP_CNTL__MBUS2_ACTIVE_MASK_MASK 0x10000000
#define SCLK_DEEP_SLEEP_CNTL__MBUS2_ACTIVE_MASK__SHIFT 0x1c
#define SCLK_DEEP_SLEEP_CNTL__VCE_BUSY_MASK_MASK 0x20000000
#define SCLK_DEEP_SLEEP_CNTL__VCE_BUSY_MASK__SHIFT 0x1d
#define SCLK_DEEP_SLEEP_CNTL__AZ_BUSY_MASK_MASK 0x40000000
#define SCLK_DEEP_SLEEP_CNTL__AZ_BUSY_MASK__SHIFT 0x1e
#define SCLK_DEEP_SLEEP_CNTL__ENABLE_DS_MASK 0x80000000
#define SCLK_DEEP_SLEEP_CNTL__ENABLE_DS__SHIFT 0x1f
#define SCLK_DEEP_SLEEP_CNTL2__RLC_BUSY_MASK_MASK 0x1
#define SCLK_DEEP_SLEEP_CNTL2__RLC_BUSY_MASK__SHIFT 0x0
#define SCLK_DEEP_SLEEP_CNTL2__HDP_BUSY_MASK_MASK 0x2
#define SCLK_DEEP_SLEEP_CNTL2__HDP_BUSY_MASK__SHIFT 0x1
#define SCLK_DEEP_SLEEP_CNTL2__ROM_BUSY_MASK_MASK 0x4
#define SCLK_DEEP_SLEEP_CNTL2__ROM_BUSY_MASK__SHIFT 0x2
#define SCLK_DEEP_SLEEP_CNTL2__IH_SEM_BUSY_MASK_MASK 0x8
#define SCLK_DEEP_SLEEP_CNTL2__IH_SEM_BUSY_MASK__SHIFT 0x3
#define SCLK_DEEP_SLEEP_CNTL2__PDMA_BUSY_MASK_MASK 0x10
#define SCLK_DEEP_SLEEP_CNTL2__PDMA_BUSY_MASK__SHIFT 0x4
#define SCLK_DEEP_SLEEP_CNTL2__IDCT_BUSY_MASK_MASK 0x40
#define SCLK_DEEP_SLEEP_CNTL2__IDCT_BUSY_MASK__SHIFT 0x6
#define SCLK_DEEP_SLEEP_CNTL2__SDMA_BUSY_MASK_MASK 0x80
#define SCLK_DEEP_SLEEP_CNTL2__SDMA_BUSY_MASK__SHIFT 0x7
#define SCLK_DEEP_SLEEP_CNTL2__DC_AZ_BUSY_MASK_MASK 0x100
#define SCLK_DEEP_SLEEP_CNTL2__DC_AZ_BUSY_MASK__SHIFT 0x8
#define SCLK_DEEP_SLEEP_CNTL2__ACP_SMU_ALLOW_DSLEEP_STUTTER_MASK_MASK 0x200
#define SCLK_DEEP_SLEEP_CNTL2__ACP_SMU_ALLOW_DSLEEP_STUTTER_MASK__SHIFT 0x9
#define SCLK_DEEP_SLEEP_CNTL2__UVD_CG_MC_STAT_BUSY_MASK_MASK 0x400
#define SCLK_DEEP_SLEEP_CNTL2__UVD_CG_MC_STAT_BUSY_MASK__SHIFT 0xa
#define SCLK_DEEP_SLEEP_CNTL2__VCE_CG_MC_STAT_BUSY_MASK_MASK 0x800
#define SCLK_DEEP_SLEEP_CNTL2__VCE_CG_MC_STAT_BUSY_MASK__SHIFT 0xb
#define SCLK_DEEP_SLEEP_CNTL2__SAM_CG_MC_STAT_BUSY_MASK_MASK 0x1000
#define SCLK_DEEP_SLEEP_CNTL2__SAM_CG_MC_STAT_BUSY_MASK__SHIFT 0xc
#define SCLK_DEEP_SLEEP_CNTL2__SAM_CG_STATUS_BUSY_MASK_MASK 0x2000
#define SCLK_DEEP_SLEEP_CNTL2__SAM_CG_STATUS_BUSY_MASK__SHIFT 0xd
#define SCLK_DEEP_SLEEP_CNTL2__RLC_SMU_GFXCLK_OFF_MASK_MASK 0x4000
#define SCLK_DEEP_SLEEP_CNTL2__RLC_SMU_GFXCLK_OFF_MASK__SHIFT 0xe
#define SCLK_DEEP_SLEEP_CNTL2__SHALLOW_DIV_ID_MASK 0xe00000
#define SCLK_DEEP_SLEEP_CNTL2__SHALLOW_DIV_ID__SHIFT 0x15
#define SCLK_DEEP_SLEEP_CNTL2__INOUT_CUSHION_MASK 0xff000000
#define SCLK_DEEP_SLEEP_CNTL2__INOUT_CUSHION__SHIFT 0x18
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_0_SMU_BUSY_MASK_MASK 0x1
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_0_SMU_BUSY_MASK__SHIFT 0x0
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_1_SMU_BUSY_MASK_MASK 0x2
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_1_SMU_BUSY_MASK__SHIFT 0x1
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_2_SMU_BUSY_MASK_MASK 0x4
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_2_SMU_BUSY_MASK__SHIFT 0x2
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_3_SMU_BUSY_MASK_MASK 0x8
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_3_SMU_BUSY_MASK__SHIFT 0x3
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_4_SMU_BUSY_MASK_MASK 0x10
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_4_SMU_BUSY_MASK__SHIFT 0x4
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_5_SMU_BUSY_MASK_MASK 0x20
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_5_SMU_BUSY_MASK__SHIFT 0x5
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_6_SMU_BUSY_MASK_MASK 0x40
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_6_SMU_BUSY_MASK__SHIFT 0x6
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_7_SMU_BUSY_MASK_MASK 0x80
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_7_SMU_BUSY_MASK__SHIFT 0x7
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_8_SMU_BUSY_MASK_MASK 0x100
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_8_SMU_BUSY_MASK__SHIFT 0x8
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_9_SMU_BUSY_MASK_MASK 0x200
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_9_SMU_BUSY_MASK__SHIFT 0x9
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_10_SMU_BUSY_MASK_MASK 0x400
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_10_SMU_BUSY_MASK__SHIFT 0xa
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_11_SMU_BUSY_MASK_MASK 0x800
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_11_SMU_BUSY_MASK__SHIFT 0xb
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_12_SMU_BUSY_MASK_MASK 0x1000
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_12_SMU_BUSY_MASK__SHIFT 0xc
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_13_SMU_BUSY_MASK_MASK 0x2000
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_13_SMU_BUSY_MASK__SHIFT 0xd
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_14_SMU_BUSY_MASK_MASK 0x4000
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_14_SMU_BUSY_MASK__SHIFT 0xe
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_15_SMU_BUSY_MASK_MASK 0x8000
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_15_SMU_BUSY_MASK__SHIFT 0xf
#define SCLK_DEEP_SLEEP_MISC_CNTL__DPM_DS_DIV_ID_MASK 0x7
#define SCLK_DEEP_SLEEP_MISC_CNTL__DPM_DS_DIV_ID__SHIFT 0x0
#define SCLK_DEEP_SLEEP_MISC_CNTL__DPM_SS_DIV_ID_MASK 0x38
#define SCLK_DEEP_SLEEP_MISC_CNTL__DPM_SS_DIV_ID__SHIFT 0x3
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_ENABLE_MASK 0x10000
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_ENABLE__SHIFT 0x10
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_DS_DIV_ID_MASK 0xe0000
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_DS_DIV_ID__SHIFT 0x11
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_SS_DIV_ID_MASK 0x700000
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_SS_DIV_ID__SHIFT 0x14
#define LCLK_DEEP_SLEEP_CNTL__DIV_ID_MASK 0x7
#define LCLK_DEEP_SLEEP_CNTL__DIV_ID__SHIFT 0x0
#define LCLK_DEEP_SLEEP_CNTL__RAMP_DIS_MASK 0x8
#define LCLK_DEEP_SLEEP_CNTL__RAMP_DIS__SHIFT 0x3
#define LCLK_DEEP_SLEEP_CNTL__HYSTERESIS_MASK 0xfff0
#define LCLK_DEEP_SLEEP_CNTL__HYSTERESIS__SHIFT 0x4
#define LCLK_DEEP_SLEEP_CNTL__RESERVED_MASK 0x7fff0000
#define LCLK_DEEP_SLEEP_CNTL__RESERVED__SHIFT 0x10
#define LCLK_DEEP_SLEEP_CNTL__ENABLE_DS_MASK 0x80000000
#define LCLK_DEEP_SLEEP_CNTL__ENABLE_DS__SHIFT 0x1f
#define LCLK_DEEP_SLEEP_CNTL2__RFE_BUSY_MASK_MASK 0x1
#define LCLK_DEEP_SLEEP_CNTL2__RFE_BUSY_MASK__SHIFT 0x0
#define LCLK_DEEP_SLEEP_CNTL2__BIF_CG_LCLK_BUSY_MASK_MASK 0x2
#define LCLK_DEEP_SLEEP_CNTL2__BIF_CG_LCLK_BUSY_MASK__SHIFT 0x1
#define LCLK_DEEP_SLEEP_CNTL2__L1IMU_SMU_IDLE_MASK_MASK 0x4
#define LCLK_DEEP_SLEEP_CNTL2__L1IMU_SMU_IDLE_MASK__SHIFT 0x2
#define LCLK_DEEP_SLEEP_CNTL2__RESERVED_BIT3_MASK 0x8
#define LCLK_DEEP_SLEEP_CNTL2__RESERVED_BIT3__SHIFT 0x3
#define LCLK_DEEP_SLEEP_CNTL2__SCLK_RUNNING_MASK_MASK 0x10
#define LCLK_DEEP_SLEEP_CNTL2__SCLK_RUNNING_MASK__SHIFT 0x4
#define LCLK_DEEP_SLEEP_CNTL2__SMU_BUSY_MASK_MASK 0x20
#define LCLK_DEEP_SLEEP_CNTL2__SMU_BUSY_MASK__SHIFT 0x5
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE1_MASK_MASK 0x40
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE1_MASK__SHIFT 0x6
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE2_MASK_MASK 0x80
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE2_MASK__SHIFT 0x7
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE3_MASK_MASK 0x100
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE3_MASK__SHIFT 0x8
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE4_MASK_MASK 0x200
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE4_MASK__SHIFT 0x9
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUGPP_IDLE_MASK_MASK 0x400
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUGPP_IDLE_MASK__SHIFT 0xa
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUGPPSB_IDLE_MASK_MASK 0x800
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUGPPSB_IDLE_MASK__SHIFT 0xb
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUBIF_IDLE_MASK_MASK 0x1000
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUBIF_IDLE_MASK__SHIFT 0xc
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUINTGEN_IDLE_MASK_MASK 0x2000
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUINTGEN_IDLE_MASK__SHIFT 0xd
#define LCLK_DEEP_SLEEP_CNTL2__L2IMU_IDLE_MASK_MASK 0x4000
#define LCLK_DEEP_SLEEP_CNTL2__L2IMU_IDLE_MASK__SHIFT 0xe
#define LCLK_DEEP_SLEEP_CNTL2__ORB_IDLE_MASK_MASK 0x8000
#define LCLK_DEEP_SLEEP_CNTL2__ORB_IDLE_MASK__SHIFT 0xf
#define LCLK_DEEP_SLEEP_CNTL2__ON_INB_WAKE_MASK_MASK 0x10000
#define LCLK_DEEP_SLEEP_CNTL2__ON_INB_WAKE_MASK__SHIFT 0x10
#define LCLK_DEEP_SLEEP_CNTL2__ON_INB_WAKE_ACK_MASK_MASK 0x20000
#define LCLK_DEEP_SLEEP_CNTL2__ON_INB_WAKE_ACK_MASK__SHIFT 0x11
#define LCLK_DEEP_SLEEP_CNTL2__ON_OUTB_WAKE_MASK_MASK 0x40000
#define LCLK_DEEP_SLEEP_CNTL2__ON_OUTB_WAKE_MASK__SHIFT 0x12
#define LCLK_DEEP_SLEEP_CNTL2__ON_OUTB_WAKE_ACK_MASK_MASK 0x80000
#define LCLK_DEEP_SLEEP_CNTL2__ON_OUTB_WAKE_ACK_MASK__SHIFT 0x13
#define LCLK_DEEP_SLEEP_CNTL2__DMAACTIVE_MASK_MASK 0x100000
#define LCLK_DEEP_SLEEP_CNTL2__DMAACTIVE_MASK__SHIFT 0x14
#define LCLK_DEEP_SLEEP_CNTL2__RLC_SMU_GFXCLK_OFF_MASK_MASK 0x200000
#define LCLK_DEEP_SLEEP_CNTL2__RLC_SMU_GFXCLK_OFF_MASK__SHIFT 0x15
#define LCLK_DEEP_SLEEP_CNTL2__RESERVED_MASK 0xffc00000
#define LCLK_DEEP_SLEEP_CNTL2__RESERVED__SHIFT 0x16
#define SMU_VOLTAGE_STATUS__SMU_VOLTAGE_STATUS_MASK 0x1
#define SMU_VOLTAGE_STATUS__SMU_VOLTAGE_STATUS__SHIFT 0x0
#define SMU_VOLTAGE_STATUS__SMU_VOLTAGE_CURRENT_LEVEL_MASK 0x1fe
#define SMU_VOLTAGE_STATUS__SMU_VOLTAGE_CURRENT_LEVEL__SHIFT 0x1
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_VDDCI_INDEX_MASK 0xf
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_VDDCI_INDEX__SHIFT 0x0
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_VDDCI_INDEX_MASK 0xf0
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_VDDCI_INDEX__SHIFT 0x4
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_MVDD_INDEX_MASK 0xf00
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_MVDD_INDEX__SHIFT 0x8
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_MVDD_INDEX_MASK 0xf000
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_MVDD_INDEX__SHIFT 0xc
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_VDDC_INDEX_MASK 0xf0000
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_VDDC_INDEX__SHIFT 0x10
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_VDDC_INDEX_MASK 0xf00000
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_VDDC_INDEX__SHIFT 0x14
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_PCIE_INDEX_MASK 0xf000000
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_PCIE_INDEX__SHIFT 0x18
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_PCIE_INDEX_MASK 0xf0000000
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_PCIE_INDEX__SHIFT 0x1c
#define CG_ULV_PARAMETER__ULV_THRESHOLD_MASK 0xffff
#define CG_ULV_PARAMETER__ULV_THRESHOLD__SHIFT 0x0
#define CG_ULV_PARAMETER__ULV_THRESHOLD_UNIT_MASK 0xf0000
#define CG_ULV_PARAMETER__ULV_THRESHOLD_UNIT__SHIFT 0x10
#define SCLK_MIN_DIV__FRACV_MASK 0xfff
#define SCLK_MIN_DIV__FRACV__SHIFT 0x0
#define SCLK_MIN_DIV__INTV_MASK 0x7f000
#define SCLK_MIN_DIV__INTV__SHIFT 0xc
#define LCAC_SX0_CNTL__SX0_ENABLE_MASK 0x1
#define LCAC_SX0_CNTL__SX0_ENABLE__SHIFT 0x0
#define LCAC_SX0_CNTL__SX0_THRESHOLD_MASK 0x1fffe
#define LCAC_SX0_CNTL__SX0_THRESHOLD__SHIFT 0x1
#define LCAC_SX0_CNTL__SX0_BLOCK_ID_MASK 0x3e0000
#define LCAC_SX0_CNTL__SX0_BLOCK_ID__SHIFT 0x11
#define LCAC_SX0_CNTL__SX0_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_SX0_CNTL__SX0_SIGNAL_ID__SHIFT 0x16
#define LCAC_SX0_OVR_SEL__SX0_OVR_SEL_MASK 0xffffffff
#define LCAC_SX0_OVR_SEL__SX0_OVR_SEL__SHIFT 0x0
#define LCAC_SX0_OVR_VAL__SX0_OVR_VAL_MASK 0xffffffff
#define LCAC_SX0_OVR_VAL__SX0_OVR_VAL__SHIFT 0x0
#define LCAC_MC0_CNTL__MC0_ENABLE_MASK 0x1
#define LCAC_MC0_CNTL__MC0_ENABLE__SHIFT 0x0
#define LCAC_MC0_CNTL__MC0_THRESHOLD_MASK 0x1fffe
#define LCAC_MC0_CNTL__MC0_THRESHOLD__SHIFT 0x1
#define LCAC_MC0_CNTL__MC0_BLOCK_ID_MASK 0x3e0000
#define LCAC_MC0_CNTL__MC0_BLOCK_ID__SHIFT 0x11
#define LCAC_MC0_CNTL__MC0_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_MC0_CNTL__MC0_SIGNAL_ID__SHIFT 0x16
#define LCAC_MC0_OVR_SEL__MC0_OVR_SEL_MASK 0xffffffff
#define LCAC_MC0_OVR_SEL__MC0_OVR_SEL__SHIFT 0x0
#define LCAC_MC0_OVR_VAL__MC0_OVR_VAL_MASK 0xffffffff
#define LCAC_MC0_OVR_VAL__MC0_OVR_VAL__SHIFT 0x0
#define LCAC_MC1_CNTL__MC1_ENABLE_MASK 0x1
#define LCAC_MC1_CNTL__MC1_ENABLE__SHIFT 0x0
#define LCAC_MC1_CNTL__MC1_THRESHOLD_MASK 0x1fffe
#define LCAC_MC1_CNTL__MC1_THRESHOLD__SHIFT 0x1
#define LCAC_MC1_CNTL__MC1_BLOCK_ID_MASK 0x3e0000
#define LCAC_MC1_CNTL__MC1_BLOCK_ID__SHIFT 0x11
#define LCAC_MC1_CNTL__MC1_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_MC1_CNTL__MC1_SIGNAL_ID__SHIFT 0x16
#define LCAC_MC1_OVR_SEL__MC1_OVR_SEL_MASK 0xffffffff
#define LCAC_MC1_OVR_SEL__MC1_OVR_SEL__SHIFT 0x0
#define LCAC_MC1_OVR_VAL__MC1_OVR_VAL_MASK 0xffffffff
#define LCAC_MC1_OVR_VAL__MC1_OVR_VAL__SHIFT 0x0
#define LCAC_MC2_CNTL__MC2_ENABLE_MASK 0x1
#define LCAC_MC2_CNTL__MC2_ENABLE__SHIFT 0x0
#define LCAC_MC2_CNTL__MC2_THRESHOLD_MASK 0x1fffe
#define LCAC_MC2_CNTL__MC2_THRESHOLD__SHIFT 0x1
#define LCAC_MC2_CNTL__MC2_BLOCK_ID_MASK 0x3e0000
#define LCAC_MC2_CNTL__MC2_BLOCK_ID__SHIFT 0x11
#define LCAC_MC2_CNTL__MC2_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_MC2_CNTL__MC2_SIGNAL_ID__SHIFT 0x16
#define LCAC_MC2_OVR_SEL__MC2_OVR_SEL_MASK 0xffffffff
#define LCAC_MC2_OVR_SEL__MC2_OVR_SEL__SHIFT 0x0
#define LCAC_MC2_OVR_VAL__MC2_OVR_VAL_MASK 0xffffffff
#define LCAC_MC2_OVR_VAL__MC2_OVR_VAL__SHIFT 0x0
#define LCAC_MC3_CNTL__MC3_ENABLE_MASK 0x1
#define LCAC_MC3_CNTL__MC3_ENABLE__SHIFT 0x0
#define LCAC_MC3_CNTL__MC3_THRESHOLD_MASK 0x1fffe
#define LCAC_MC3_CNTL__MC3_THRESHOLD__SHIFT 0x1
#define LCAC_MC3_CNTL__MC3_BLOCK_ID_MASK 0x3e0000
#define LCAC_MC3_CNTL__MC3_BLOCK_ID__SHIFT 0x11
#define LCAC_MC3_CNTL__MC3_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_MC3_CNTL__MC3_SIGNAL_ID__SHIFT 0x16
#define LCAC_MC3_OVR_SEL__MC3_OVR_SEL_MASK 0xffffffff
#define LCAC_MC3_OVR_SEL__MC3_OVR_SEL__SHIFT 0x0
#define LCAC_MC3_OVR_VAL__MC3_OVR_VAL_MASK 0xffffffff
#define LCAC_MC3_OVR_VAL__MC3_OVR_VAL__SHIFT 0x0
#define LCAC_CPL_CNTL__CPL_ENABLE_MASK 0x1
#define LCAC_CPL_CNTL__CPL_ENABLE__SHIFT 0x0
#define LCAC_CPL_CNTL__CPL_THRESHOLD_MASK 0x1fffe
#define LCAC_CPL_CNTL__CPL_THRESHOLD__SHIFT 0x1
#define LCAC_CPL_CNTL__CPL_BLOCK_ID_MASK 0x3e0000
#define LCAC_CPL_CNTL__CPL_BLOCK_ID__SHIFT 0x11
#define LCAC_CPL_CNTL__CPL_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_CPL_CNTL__CPL_SIGNAL_ID__SHIFT 0x16
#define LCAC_CPL_OVR_SEL__CPL_OVR_SEL_MASK 0xffffffff
#define LCAC_CPL_OVR_SEL__CPL_OVR_SEL__SHIFT 0x0
#define LCAC_CPL_OVR_VAL__CPL_OVR_VAL_MASK 0xffffffff
#define LCAC_CPL_OVR_VAL__CPL_OVR_VAL__SHIFT 0x0

#endif /* SMU_7_0_0_SH_MASK_H */
