/* $NetBSD: linux_sysent.c,v 1.69 2018/08/10 21:47:14 pgoyette Exp $ */

/*
 * System call switch table.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.60 2017/02/03 16:18:19 christos Exp
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: linux_sysent.c,v 1.69 2018/08/10 21:47:14 pgoyette Exp $");

#if defined(_KERNEL_OPT)
#include "opt_sysv.h"
#include "opt_compat_43.h"
#include "opt_compat_netbsd.h"
#endif
#include <sys/param.h>
#include <sys/poll.h>
#include <sys/systm.h>
#include <sys/signal.h>
#include <sys/mount.h>
#include <sys/syscallargs.h>
#include <sys/time.h>
#include <compat/sys/time.h>
#include <compat/linux/common/linux_types.h>
#include <compat/linux/common/linux_mmap.h>
#include <compat/linux/common/linux_ipc.h>
#include <compat/linux/common/linux_msg.h>
#include <compat/linux/common/linux_sem.h>
#include <compat/linux/common/linux_shm.h>
#include <compat/linux/common/linux_signal.h>
#include <compat/linux/common/linux_siginfo.h>
#include <compat/linux/common/linux_machdep.h>
#include <compat/linux/linux_syscallargs.h>

#define	s(type)	sizeof(type)
#define	n(type)	(sizeof(type)/sizeof (register_t))
#define	ns(type)	.sy_narg = n(type), .sy_argsize = s(type)

struct sysent linux_sysent[] = {
	{
		ns(struct sys_read_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_read
	},		/* 0 = read */
	{
		ns(struct sys_write_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_write
	},		/* 1 = write */
	{
		ns(struct linux_sys_open_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_open
	},		/* 2 = open */
	{
		ns(struct sys_close_args),
		.sy_call = (sy_call_t *)sys_close
	},		/* 3 = close */
	{
		ns(struct linux_sys_stat64_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_stat64
	},		/* 4 = stat64 */
	{
		ns(struct linux_sys_fstat64_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fstat64
	},		/* 5 = fstat64 */
	{
		ns(struct linux_sys_lstat64_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_lstat64
	},		/* 6 = lstat64 */
	{
		ns(struct sys_poll_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_poll
	},		/* 7 = poll */
	{
		ns(struct compat_43_sys_lseek_args),
		.sy_call = (sy_call_t *)compat_43_sys_lseek
	},		/* 8 = lseek */
	{
		ns(struct linux_sys_mmap_args),
		.sy_call = (sy_call_t *)linux_sys_mmap
	},		/* 9 = mmap */
	{
		ns(struct linux_sys_mprotect_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_mprotect
	},		/* 10 = mprotect */
	{
		ns(struct sys_munmap_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_munmap
	},		/* 11 = munmap */
	{
		ns(struct linux_sys_brk_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_brk
	},		/* 12 = brk */
	{
		ns(struct linux_sys_rt_sigaction_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_sigaction
	},		/* 13 = rt_sigaction */
	{
		ns(struct linux_sys_rt_sigprocmask_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_sigprocmask
	},		/* 14 = rt_sigprocmask */
	{
		.sy_call = (sy_call_t *)linux_sys_rt_sigreturn
	},		/* 15 = rt_sigreturn */
	{
		ns(struct linux_sys_ioctl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_ioctl
	},		/* 16 = ioctl */
	{
		ns(struct linux_sys_pread_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG3_64 | SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_pread
	},		/* 17 = pread */
	{
		ns(struct linux_sys_pwrite_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG3_64 | SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_pwrite
	},		/* 18 = pwrite */
	{
		ns(struct sys_readv_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_readv
	},		/* 19 = readv */
	{
		ns(struct sys_writev_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_writev
	},		/* 20 = writev */
	{
		ns(struct sys_access_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_access
	},		/* 21 = access */
	{
		ns(struct linux_sys_pipe_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_pipe
	},		/* 22 = pipe */
	{
		ns(struct linux_sys_select_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_select
	},		/* 23 = select */
	{
		.sy_call = (sy_call_t *)linux_sys_sched_yield
	},		/* 24 = sched_yield */
	{
		ns(struct linux_sys_mremap_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_mremap
	},		/* 25 = mremap */
	{
		ns(struct sys___msync13_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___msync13
	},		/* 26 = __msync13 */
	{
		ns(struct sys_mincore_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_mincore
	},		/* 27 = mincore */
	{
		ns(struct sys_madvise_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_madvise
	},		/* 28 = madvise */
#ifdef SYSVSHM
	{
		ns(struct linux_sys_shmget_args),
		.sy_call = (sy_call_t *)linux_sys_shmget
	},		/* 29 = shmget */
	{
		ns(struct sys_shmat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_shmat
	},		/* 30 = shmat */
	{
		ns(struct linux_sys_shmctl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_shmctl
	},		/* 31 = shmctl */
#else
	{
		.sy_call = linux_sys_nosys,
	},		/* 29 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 30 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 31 = filler */
#endif
	{
		ns(struct sys_dup_args),
		.sy_call = (sy_call_t *)sys_dup
	},		/* 32 = dup */
	{
		ns(struct sys_dup2_args),
		.sy_call = (sy_call_t *)sys_dup2
	},		/* 33 = dup2 */
	{
		.sy_call = (sy_call_t *)linux_sys_pause
	},		/* 34 = pause */
	{
		ns(struct linux_sys_nanosleep_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_nanosleep
	},		/* 35 = nanosleep */
	{
		ns(struct compat_50_sys_getitimer_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_getitimer
	},		/* 36 = getitimer */
	{
		ns(struct linux_sys_alarm_args),
		.sy_call = (sy_call_t *)linux_sys_alarm
	},		/* 37 = alarm */
	{
		ns(struct compat_50_sys_setitimer_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_setitimer
	},		/* 38 = setitimer */
	{
		.sy_call = (sy_call_t *)sys_getpid
	},		/* 39 = getpid */
	{
		.sy_call = linux_sys_nosys,
	},		/* 40 = filler */
	{
		ns(struct linux_sys_socket_args),
		.sy_call = (sy_call_t *)linux_sys_socket
	},		/* 41 = socket */
	{
		ns(struct linux_sys_connect_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_connect
	},		/* 42 = connect */
	{
		ns(struct linux_sys_accept_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_accept
	},		/* 43 = oaccept */
	{
		ns(struct linux_sys_sendto_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sendto
	},		/* 44 = sendto */
	{
		ns(struct linux_sys_recvfrom_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_recvfrom
	},		/* 45 = recvfrom */
	{
		ns(struct linux_sys_sendmsg_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sendmsg
	},		/* 46 = sendmsg */
	{
		ns(struct linux_sys_recvmsg_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_recvmsg
	},		/* 47 = recvmsg */
	{
		ns(struct sys_shutdown_args),
		.sy_call = (sy_call_t *)sys_shutdown
	},		/* 48 = shutdown */
	{
		ns(struct linux_sys_bind_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_bind
	},		/* 49 = bind */
	{
		ns(struct sys_listen_args),
		.sy_call = (sy_call_t *)sys_listen
	},		/* 50 = listen */
	{
		ns(struct linux_sys_getsockname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getsockname
	},		/* 51 = getsockname */
	{
		ns(struct linux_sys_getpeername_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getpeername
	},		/* 52 = getpeername */
	{
		ns(struct linux_sys_socketpair_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_socketpair
	},		/* 53 = socketpair */
	{
		ns(struct linux_sys_setsockopt_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_setsockopt
	},		/* 54 = setsockopt */
	{
		ns(struct linux_sys_getsockopt_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getsockopt
	},		/* 55 = getsockopt */
	{
		ns(struct linux_sys_clone_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_clone
	},		/* 56 = clone */
	{
		.sy_call = (sy_call_t *)sys_fork
	},		/* 57 = fork */
	{
		.sy_call = (sy_call_t *)sys___vfork14
	},		/* 58 = __vfork14 */
	{
		ns(struct sys_execve_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_execve
	},		/* 59 = execve */
	{
		ns(struct linux_sys_exit_args),
		.sy_call = (sy_call_t *)linux_sys_exit
	},		/* 60 = exit */
	{
		ns(struct linux_sys_wait4_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_wait4
	},		/* 61 = wait4 */
	{
		ns(struct linux_sys_kill_args),
		.sy_call = (sy_call_t *)linux_sys_kill
	},		/* 62 = kill */
	{
		ns(struct linux_sys_uname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_uname
	},		/* 63 = uname */
#ifdef SYSVSEM
	{
		ns(struct sys_semget_args),
		.sy_call = (sy_call_t *)sys_semget
	},		/* 64 = semget */
	{
		ns(struct sys_semop_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_semop
	},		/* 65 = semop */
	{
		ns(struct linux_sys_semctl_args),
		.sy_call = (sy_call_t *)linux_sys_semctl
	},		/* 66 = semctl */
#else
	{
		.sy_call = linux_sys_nosys,
	},		/* 64 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 65 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 66 = filler */
#endif
#ifdef SYSVSHM
	{
		ns(struct sys_shmdt_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_shmdt
	},		/* 67 = shmdt */
#else
	{
		.sy_call = linux_sys_nosys,
	},		/* 67 = filler */
#endif
#ifdef SYSVMSG
	{
		ns(struct sys_msgget_args),
		.sy_call = (sy_call_t *)sys_msgget
	},		/* 68 = msgget */
	{
		ns(struct sys_msgsnd_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_msgsnd
	},		/* 69 = msgsnd */
	{
		ns(struct sys_msgrcv_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_msgrcv
	},		/* 70 = msgrcv */
	{
		ns(struct linux_sys_msgctl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_msgctl
	},		/* 71 = msgctl */
#else
	{
		.sy_call = linux_sys_nosys,
	},		/* 68 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 69 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 70 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 71 = filler */
#endif
	{
		ns(struct linux_sys_fcntl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fcntl
	},		/* 72 = fcntl */
	{
		ns(struct sys_flock_args),
		.sy_call = (sy_call_t *)sys_flock
	},		/* 73 = flock */
	{
		ns(struct sys_fsync_args),
		.sy_call = (sy_call_t *)sys_fsync
	},		/* 74 = fsync */
	{
		ns(struct linux_sys_fdatasync_args),
		.sy_call = (sy_call_t *)linux_sys_fdatasync
	},		/* 75 = fdatasync */
	{
		ns(struct linux_sys_truncate64_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG1_64 | SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_truncate64
	},		/* 76 = truncate64 */
	{
		ns(struct linux_sys_ftruncate64_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG1_64,
		.sy_call = (sy_call_t *)linux_sys_ftruncate64
	},		/* 77 = ftruncate64 */
	{
		ns(struct linux_sys_getdents_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getdents
	},		/* 78 = getdents */
	{
		ns(struct sys___getcwd_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___getcwd
	},		/* 79 = __getcwd */
	{
		ns(struct sys_chdir_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_chdir
	},		/* 80 = chdir */
	{
		ns(struct sys_fchdir_args),
		.sy_call = (sy_call_t *)sys_fchdir
	},		/* 81 = fchdir */
	{
		ns(struct sys___posix_rename_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___posix_rename
	},		/* 82 = __posix_rename */
	{
		ns(struct sys_mkdir_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_mkdir
	},		/* 83 = mkdir */
	{
		ns(struct sys_rmdir_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_rmdir
	},		/* 84 = rmdir */
	{
		ns(struct linux_sys_creat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_creat
	},		/* 85 = creat */
	{
		ns(struct sys_link_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_link
	},		/* 86 = link */
	{
		ns(struct linux_sys_unlink_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_unlink
	},		/* 87 = unlink */
	{
		ns(struct sys_symlink_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_symlink
	},		/* 88 = symlink */
	{
		ns(struct sys_readlink_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_readlink
	},		/* 89 = readlink */
	{
		ns(struct sys_chmod_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_chmod
	},		/* 90 = chmod */
	{
		ns(struct sys_fchmod_args),
		.sy_call = (sy_call_t *)sys_fchmod
	},		/* 91 = fchmod */
	{
		ns(struct sys___posix_chown_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___posix_chown
	},		/* 92 = __posix_chown */
	{
		ns(struct sys___posix_fchown_args),
		.sy_call = (sy_call_t *)sys___posix_fchown
	},		/* 93 = __posix_fchown */
	{
		ns(struct sys___posix_lchown_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___posix_lchown
	},		/* 94 = __posix_lchown */
	{
		ns(struct sys_umask_args),
		.sy_call = (sy_call_t *)sys_umask
	},		/* 95 = umask */
	{
		ns(struct linux_sys_gettimeofday_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_gettimeofday
	},		/* 96 = gettimeofday */
	{
		ns(struct linux_sys_getrlimit_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getrlimit
	},		/* 97 = getrlimit */
	{
		ns(struct compat_50_sys_getrusage_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_getrusage
	},		/* 98 = getrusage */
	{
		ns(struct linux_sys_sysinfo_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sysinfo
	},		/* 99 = sysinfo */
	{
		ns(struct linux_sys_times_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_times
	},		/* 100 = times */
	{
		ns(struct linux_sys_ptrace_args),
		.sy_call = (sy_call_t *)linux_sys_ptrace
	},		/* 101 = ptrace */
	{
		.sy_call = (sy_call_t *)sys_getuid
	},		/* 102 = getuid */
	{
		.sy_call = linux_sys_nosys,
	},		/* 103 = filler */
	{
		.sy_call = (sy_call_t *)sys_getgid
	},		/* 104 = getgid */
	{
		ns(struct sys_setuid_args),
		.sy_call = (sy_call_t *)sys_setuid
	},		/* 105 = setuid */
	{
		ns(struct sys_setgid_args),
		.sy_call = (sy_call_t *)sys_setgid
	},		/* 106 = setgid */
	{
		.sy_call = (sy_call_t *)sys_geteuid
	},		/* 107 = geteuid */
	{
		.sy_call = (sy_call_t *)sys_getegid
	},		/* 108 = getegid */
	{
		ns(struct sys_setpgid_args),
		.sy_call = (sy_call_t *)sys_setpgid
	},		/* 109 = setpgid */
	{
		.sy_call = (sy_call_t *)sys_getppid
	},		/* 110 = getppid */
	{
		.sy_call = (sy_call_t *)sys_getpgrp
	},		/* 111 = getpgrp */
	{
		.sy_call = (sy_call_t *)sys_setsid
	},		/* 112 = setsid */
	{
		ns(struct sys_setreuid_args),
		.sy_call = (sy_call_t *)sys_setreuid
	},		/* 113 = setreuid */
	{
		ns(struct sys_setregid_args),
		.sy_call = (sy_call_t *)sys_setregid
	},		/* 114 = setregid */
	{
		ns(struct sys_getgroups_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_getgroups
	},		/* 115 = getgroups */
	{
		ns(struct sys_setgroups_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_setgroups
	},		/* 116 = setgroups */
	{
		ns(struct linux_sys_setresuid_args),
		.sy_call = (sy_call_t *)linux_sys_setresuid
	},		/* 117 = setresuid */
	{
		ns(struct linux_sys_getresuid_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getresuid
	},		/* 118 = getresuid */
	{
		ns(struct linux_sys_setresgid_args),
		.sy_call = (sy_call_t *)linux_sys_setresgid
	},		/* 119 = setresgid */
	{
		ns(struct linux_sys_getresgid_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getresgid
	},		/* 120 = getresgid */
	{
		ns(struct sys_getpgid_args),
		.sy_call = (sy_call_t *)sys_getpgid
	},		/* 121 = getpgid */
	{
		ns(struct linux_sys_setfsuid_args),
		.sy_call = (sy_call_t *)linux_sys_setfsuid
	},		/* 122 = setfsuid */
	{
		ns(struct linux_sys_setfsgid_args),
		.sy_call = (sy_call_t *)linux_sys_setfsgid
	},		/* 123 = setfsgid */
	{
		ns(struct sys_getsid_args),
		.sy_call = (sy_call_t *)sys_getsid
	},		/* 124 = getsid */
	{
		.sy_call = linux_sys_nosys,
	},		/* 125 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 126 = filler */
	{
		ns(struct linux_sys_rt_sigpending_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_sigpending
	},		/* 127 = rt_sigpending */
	{
		ns(struct linux_sys_rt_sigtimedwait_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_sigtimedwait
	},		/* 128 = rt_sigtimedwait */
	{
		ns(struct linux_sys_rt_queueinfo_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_queueinfo
	},		/* 129 = rt_queueinfo */
	{
		ns(struct linux_sys_rt_sigsuspend_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_sigsuspend
	},		/* 130 = rt_sigsuspend */
	{
		ns(struct linux_sys_sigaltstack_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sigaltstack
	},		/* 131 = sigaltstack */
	{
		ns(struct linux_sys_utime_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_utime
	},		/* 132 = utime */
	{
		ns(struct linux_sys_mknod_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_mknod
	},		/* 133 = mknod */
#ifdef EXEC_AOUT
	{
		ns(struct linux_sys_uselib_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_uselib
	},		/* 134 = uselib */
#else
	{
		.sy_call = linux_sys_nosys,
	},		/* 134 = filler */
#endif
	{
		ns(struct linux_sys_personality_args),
		.sy_call = (sy_call_t *)linux_sys_personality
	},		/* 135 = personality */
	{
		.sy_call = linux_sys_nosys,
	},		/* 136 = filler */
	{
		ns(struct linux_sys_statfs_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_statfs
	},		/* 137 = statfs */
	{
		ns(struct linux_sys_fstatfs_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fstatfs
	},		/* 138 = fstatfs */
	{
		.sy_call = linux_sys_nosys,
	},		/* 139 = filler */
	{
		ns(struct linux_sys_getpriority_args),
		.sy_call = (sy_call_t *)linux_sys_getpriority
	},		/* 140 = getpriority */
	{
		ns(struct sys_setpriority_args),
		.sy_call = (sy_call_t *)sys_setpriority
	},		/* 141 = setpriority */
	{
		ns(struct linux_sys_sched_setparam_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sched_setparam
	},		/* 142 = sched_setparam */
	{
		ns(struct linux_sys_sched_getparam_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sched_getparam
	},		/* 143 = sched_getparam */
	{
		ns(struct linux_sys_sched_setscheduler_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sched_setscheduler
	},		/* 144 = sched_setscheduler */
	{
		ns(struct linux_sys_sched_getscheduler_args),
		.sy_call = (sy_call_t *)linux_sys_sched_getscheduler
	},		/* 145 = sched_getscheduler */
	{
		ns(struct linux_sys_sched_get_priority_max_args),
		.sy_call = (sy_call_t *)linux_sys_sched_get_priority_max
	},		/* 146 = sched_get_priority_max */
	{
		ns(struct linux_sys_sched_get_priority_min_args),
		.sy_call = (sy_call_t *)linux_sys_sched_get_priority_min
	},		/* 147 = sched_get_priority_min */
	{
		.sy_call = linux_sys_nosys,
	},		/* 148 = filler */
	{
		ns(struct sys_mlock_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_mlock
	},		/* 149 = mlock */
	{
		ns(struct sys_munlock_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_munlock
	},		/* 150 = munlock */
	{
		ns(struct sys_mlockall_args),
		.sy_call = (sy_call_t *)sys_mlockall
	},		/* 151 = mlockall */
	{
		.sy_call = (sy_call_t *)sys_munlockall
	},		/* 152 = munlockall */
	{
		.sy_call = linux_sys_nosys,
	},		/* 153 = filler */
	{
		ns(struct linux_sys_modify_ldt_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_modify_ldt
	},		/* 154 = modify_ldt */
	{
		.sy_call = linux_sys_nosys,
	},		/* 155 = filler */
	{
		ns(struct linux_sys___sysctl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys___sysctl
	},		/* 156 = __sysctl */
	{
		.sy_call = linux_sys_nosys,
	},		/* 157 = filler */
	{
		ns(struct linux_sys_arch_prctl_args),
		.sy_call = (sy_call_t *)linux_sys_arch_prctl
	},		/* 158 = arch_prctl */
	{
		.sy_call = linux_sys_nosys,
	},		/* 159 = filler */
	{
		ns(struct linux_sys_setrlimit_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_setrlimit
	},		/* 160 = setrlimit */
	{
		ns(struct sys_chroot_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_chroot
	},		/* 161 = chroot */
	{
		.sy_call = (sy_call_t *)sys_sync
	},		/* 162 = sync */
	{
		ns(struct sys_acct_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_acct
	},		/* 163 = acct */
	{
		ns(struct linux_sys_settimeofday_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_settimeofday
	},		/* 164 = settimeofday */
	{
		.sy_call = linux_sys_nosys,
	},		/* 165 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 166 = filler */
	{
		ns(struct linux_sys_swapon_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_swapon
	},		/* 167 = swapon */
	{
		ns(struct linux_sys_swapoff_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_swapoff
	},		/* 168 = swapoff */
	{
		ns(struct linux_sys_reboot_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_reboot
	},		/* 169 = reboot */
	{
		ns(struct compat_43_sys_sethostname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_sethostname
	},		/* 170 = sethostname */
	{
		ns(struct linux_sys_setdomainname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_setdomainname
	},		/* 171 = setdomainname */
	{
		ns(struct linux_sys_iopl_args),
		.sy_call = (sy_call_t *)linux_sys_iopl
	},		/* 172 = iopl */
	{
		ns(struct linux_sys_ioperm_args),
		.sy_call = (sy_call_t *)linux_sys_ioperm
	},		/* 173 = ioperm */
	{
		.sy_call = linux_sys_nosys,
	},		/* 174 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 175 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 176 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 177 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 178 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 179 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 180 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 181 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 182 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 183 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 184 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 185 = filler */
	{
		.sy_call = (sy_call_t *)linux_sys_gettid
	},		/* 186 = gettid */
	{
		.sy_call = linux_sys_nosys,
	},		/* 187 = filler */
	{
		ns(struct linux_sys_setxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_setxattr
	},		/* 188 = setxattr */
	{
		ns(struct linux_sys_lsetxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_lsetxattr
	},		/* 189 = lsetxattr */
	{
		ns(struct linux_sys_fsetxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fsetxattr
	},		/* 190 = fsetxattr */
	{
		ns(struct linux_sys_getxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getxattr
	},		/* 191 = getxattr */
	{
		ns(struct linux_sys_lgetxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_lgetxattr
	},		/* 192 = lgetxattr */
	{
		ns(struct linux_sys_fgetxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fgetxattr
	},		/* 193 = fgetxattr */
	{
		ns(struct linux_sys_listxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_listxattr
	},		/* 194 = listxattr */
	{
		ns(struct linux_sys_llistxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_llistxattr
	},		/* 195 = llistxattr */
	{
		ns(struct linux_sys_flistxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_flistxattr
	},		/* 196 = flistxattr */
	{
		ns(struct linux_sys_removexattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_removexattr
	},		/* 197 = removexattr */
	{
		ns(struct linux_sys_lremovexattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_lremovexattr
	},		/* 198 = lremovexattr */
	{
		ns(struct linux_sys_fremovexattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fremovexattr
	},		/* 199 = fremovexattr */
	{
		ns(struct linux_sys_tkill_args),
		.sy_call = (sy_call_t *)linux_sys_tkill
	},		/* 200 = tkill */
	{
		ns(struct linux_sys_time_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_time
	},		/* 201 = time */
	{
		ns(struct linux_sys_futex_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_futex
	},		/* 202 = futex */
	{
		ns(struct linux_sys_sched_setaffinity_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sched_setaffinity
	},		/* 203 = sched_setaffinity */
	{
		ns(struct linux_sys_sched_getaffinity_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sched_getaffinity
	},		/* 204 = sched_getaffinity */
	{
		.sy_call = linux_sys_nosys,
	},		/* 205 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 206 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 207 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 208 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 209 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 210 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 211 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 212 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 213 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 214 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 215 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 216 = filler */
	{
		ns(struct linux_sys_getdents64_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getdents64
	},		/* 217 = getdents64 */
	{
		ns(struct linux_sys_set_tid_address_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_set_tid_address
	},		/* 218 = set_tid_address */
	{
		.sy_call = linux_sys_nosys,
	},		/* 219 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 220 = filler */
	{
		ns(struct linux_sys_fadvise64_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG1_64,
		.sy_call = (sy_call_t *)linux_sys_fadvise64
	},		/* 221 = fadvise64 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 222 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 223 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 224 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 225 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 226 = filler */
	{
		ns(struct linux_sys_clock_settime_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_clock_settime
	},		/* 227 = clock_settime */
	{
		ns(struct linux_sys_clock_gettime_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_clock_gettime
	},		/* 228 = clock_gettime */
	{
		ns(struct linux_sys_clock_getres_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_clock_getres
	},		/* 229 = clock_getres */
	{
		ns(struct linux_sys_clock_nanosleep_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_clock_nanosleep
	},		/* 230 = clock_nanosleep */
	{
		ns(struct linux_sys_exit_group_args),
		.sy_call = (sy_call_t *)linux_sys_exit_group
	},		/* 231 = exit_group */
	{
		.sy_call = linux_sys_nosys,
	},		/* 232 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 233 = filler */
	{
		ns(struct linux_sys_tgkill_args),
		.sy_call = (sy_call_t *)linux_sys_tgkill
	},		/* 234 = tgkill */
	{
		ns(struct compat_50_sys_utimes_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_utimes
	},		/* 235 = utimes */
	{
		.sy_call = linux_sys_nosys,
	},		/* 236 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 237 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 238 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 239 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 240 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 241 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 242 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 243 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 244 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 245 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 246 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 247 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 248 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 249 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 250 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 251 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 252 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 253 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 254 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 255 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 256 = filler */
	{
		ns(struct linux_sys_openat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_openat
	},		/* 257 = openat */
	{
		ns(struct sys_mkdirat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_mkdirat
	},		/* 258 = mkdirat */
	{
		ns(struct linux_sys_mknodat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_mknodat
	},		/* 259 = mknodat */
	{
		ns(struct linux_sys_fchownat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fchownat
	},		/* 260 = fchownat */
	{
		.sy_call = linux_sys_nosys,
	},		/* 261 = filler */
	{
		ns(struct linux_sys_fstatat64_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fstatat64
	},		/* 262 = fstatat64 */
	{
		ns(struct linux_sys_unlinkat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_unlinkat
	},		/* 263 = unlinkat */
	{
		ns(struct sys_renameat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_renameat
	},		/* 264 = renameat */
	{
		ns(struct linux_sys_linkat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_linkat
	},		/* 265 = linkat */
	{
		ns(struct sys_symlinkat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_symlinkat
	},		/* 266 = symlinkat */
	{
		ns(struct sys_readlinkat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_readlinkat
	},		/* 267 = readlinkat */
	{
		ns(struct linux_sys_fchmodat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fchmodat
	},		/* 268 = fchmodat */
	{
		ns(struct linux_sys_faccessat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_faccessat
	},		/* 269 = faccessat */
	{
		ns(struct linux_sys_pselect6_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_pselect6
	},		/* 270 = pselect6 */
	{
		ns(struct linux_sys_ppoll_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_ppoll
	},		/* 271 = ppoll */
	{
		.sy_call = linux_sys_nosys,
	},		/* 272 = filler */
	{
		ns(struct linux_sys_set_robust_list_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_set_robust_list
	},		/* 273 = set_robust_list */
	{
		ns(struct linux_sys_get_robust_list_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_get_robust_list
	},		/* 274 = get_robust_list */
	{
		.sy_call = linux_sys_nosys,
	},		/* 275 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 276 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 277 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 278 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 279 = filler */
	{
		ns(struct linux_sys_utimensat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_utimensat
	},		/* 280 = utimensat */
	{
		.sy_call = linux_sys_nosys,
	},		/* 281 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 282 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 283 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 284 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 285 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 286 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 287 = filler */
	{
		ns(struct linux_sys_accept4_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_accept4
	},		/* 288 = accept4 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 289 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 290 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 291 = filler */
	{
		ns(struct linux_sys_dup3_args),
		.sy_call = (sy_call_t *)linux_sys_dup3
	},		/* 292 = dup3 */
	{
		ns(struct linux_sys_pipe2_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_pipe2
	},		/* 293 = pipe2 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 294 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 295 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 296 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 297 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 298 = filler */
	{
		ns(struct linux_sys_recvmmsg_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_recvmmsg
	},		/* 299 = recvmmsg */
	{
		.sy_call = linux_sys_nosys,
	},		/* 300 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 301 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 302 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 303 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 304 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 305 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 306 = filler */
	{
		ns(struct linux_sys_sendmmsg_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sendmmsg
	},		/* 307 = sendmmsg */
	{
		.sy_call = linux_sys_nosys,
	},		/* 308 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 309 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 310 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 311 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 312 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 313 = filler */
	{
		.sy_call = (sy_call_t *)linux_sys_nosys
	},		/* 314 = nosys */
	{
		.sy_call = linux_sys_nosys,
	},		/* 315 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 316 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 317 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 318 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 319 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 320 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 321 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 322 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 323 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 324 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 325 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 326 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 327 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 328 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 329 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 330 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 331 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 332 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 333 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 334 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 335 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 336 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 337 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 338 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 339 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 340 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 341 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 342 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 343 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 344 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 345 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 346 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 347 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 348 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 349 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 350 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 351 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 352 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 353 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 354 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 355 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 356 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 357 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 358 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 359 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 360 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 361 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 362 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 363 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 364 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 365 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 366 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 367 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 368 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 369 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 370 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 371 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 372 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 373 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 374 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 375 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 376 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 377 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 378 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 379 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 380 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 381 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 382 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 383 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 384 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 385 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 386 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 387 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 388 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 389 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 390 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 391 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 392 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 393 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 394 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 395 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 396 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 397 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 398 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 399 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 400 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 401 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 402 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 403 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 404 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 405 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 406 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 407 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 408 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 409 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 410 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 411 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 412 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 413 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 414 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 415 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 416 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 417 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 418 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 419 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 420 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 421 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 422 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 423 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 424 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 425 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 426 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 427 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 428 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 429 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 430 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 431 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 432 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 433 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 434 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 435 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 436 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 437 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 438 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 439 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 440 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 441 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 442 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 443 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 444 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 445 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 446 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 447 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 448 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 449 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 450 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 451 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 452 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 453 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 454 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 455 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 456 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 457 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 458 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 459 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 460 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 461 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 462 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 463 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 464 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 465 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 466 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 467 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 468 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 469 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 470 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 471 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 472 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 473 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 474 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 475 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 476 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 477 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 478 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 479 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 480 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 481 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 482 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 483 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 484 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 485 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 486 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 487 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 488 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 489 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 490 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 491 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 492 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 493 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 494 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 495 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 496 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 497 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 498 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 499 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 500 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 501 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 502 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 503 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 504 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 505 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 506 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 507 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 508 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 509 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 510 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 511 = filler */
};

const uint32_t linux_sysent_nomodbits[] = {
	0x00000000,	/* syscalls   0- 31 */
	0x00000000,	/* syscalls  32- 63 */
	0x00000000,	/* syscalls  64- 95 */
	0x00000000,	/* syscalls  96-127 */
	0x00000000,	/* syscalls 128-159 */
	0x00000000,	/* syscalls 160-191 */
	0x00000000,	/* syscalls 192-223 */
	0x00000000,	/* syscalls 224-255 */
	0x00000000,	/* syscalls 256-287 */
	0x00000000,	/* syscalls 288-319 */
	0x00000000,	/* syscalls 320-351 */
	0x00000000,	/* syscalls 352-383 */
	0x00000000,	/* syscalls 384-415 */
	0x00000000,	/* syscalls 416-447 */
	0x00000000,	/* syscalls 448-479 */
	0x00000000,	/* syscalls 480-511 */
};
