/* $NetBSD: cycv_reg.h,v 1.2 2018/10/18 09:01:52 skrll Exp $ */
#ifndef _ARM_ALTERA_CYCV_REG_H
#define _ARM_ALTERA_CYCV_REG_H

#define CYCV_SDRAM_VBASE	0xf0000000
#define CYCV_SDRAM_BASE		0x0
#define CYCV_SDRAM_SIZE		L1_S_SIZE

#define CYCV_PERIPHERAL_BASE	0xFC000000
#define CYCV_PERIPHERAL_SIZE	(64 * 1024 * 1024)

#define CYCV_PERIPHERAL_VBASE	CYCV_PERIPHERAL_BASE

/* Clock manager */

#define CYCV_CLKMGR_BASE			0xFFD04000
#define CYCV_CLKMGR_SIZE			0x1000

#define CYCV_CLKMGR_CTRL			0x00
#define CYCV_CLKMGR_CTRL_SAFEMODE			__BIT(0)
#define CYCV_CLKMGR_CTRL_ENSFMDWR			__BIT(2)

#define CYCV_CLKMGR_BYPASS			0x04
#define CYCV_CLKMGR_BYPASS_MAINPLL			__BIT(0)
#define CYCV_CLKMGR_BYPASS_SDRPLL			__BIT(1)
#define CYCV_CLKMGR_BYPASS_SDRPLLSRC			__BIT(2)
#define CYCV_CLKMGR_BYPASS_PERPLL			__BIT(3)
#define CYCV_CLKMGR_BYPASS_PERPLLSRC			__BIT(4)

#define CYCV_CLKMGR_INTER			0x08
#define CYCV_CLKMGR_INT_MAINPLLACHIEVED			__BIT(0)
#define CYCV_CLKMGR_INT_PERPLLACHIEVED			__BIT(1)
#define CYCV_CLKMGR_INT_SDRPLLACHIEVED			__BIT(2)
#define CYCV_CLKMGR_INT_MAINPLLLOST			__BIT(3)
#define CYCV_CLKMGR_INT_PERPLLLOST			__BIT(4)
#define CYCV_CLKMGR_INT_SDRPLLLOST			__BIT(5)
#define CYCV_CLKMGR_INTER_MAINPLLLOCKED			__BIT(6)
#define CYCV_CLKMGR_INTER_PERPLLLOCKED			__BIT(7)
#define CYCV_CLKMGR_INTER_SDRPLLLOCKED			__BIT(8)

#define CYCV_CLKMGR_INTREN			0x0C
/* See CYCV_CLKMGR_INT_* above */

#define CYCV_CLKMGR_DBCTRL			0x10
#define CYCV_CLKMGR_STAT			0x14

#define CYCV_CLKMGR_MAIN_PLL_VCO		0x40
#define CYCV_CLKMGR_PLL_VCO_NUMER			__BITS(3, 15)
#define CYCV_CLKMGR_PLL_VCO_DENOM			__BITS(16, 21)
#define CYCV_CLKMGR_MAIN_PLL_MISC		0x44
#define CYCV_CLKMGR_MAIN_PLL_MPUCLK		0x48
#define CYCV_CLKMGR_MAIN_PLL_MPUCLK_CNT			__BITS(0, 8)
#define CYCV_CLKMGR_MAIN_PLL_MAINCLK		0x4C
#define CYCV_CLKMGR_MAIN_PLL_MAINCLK_CNT		__BITS(0, 8)
#define CYCV_CLKMGR_MAIN_PLL_DBGATCLK		0x50
#define CYCV_CLKMGR_MAIN_PLL_MAINQSPICLK	0x54
#define CYCV_CLKMGR_MAIN_PLL_MAINNANDSDMMCCLK	0x58
#define CYCV_CLKMGR_MAIN_PLL_CFGS2FUSER0CLK	0x5C
#define CYCV_CLKMGR_MAIN_PLL_EN			0x60
#define CYCV_CLKMGR_MAIN_PLL_MAINDIV		0x64
#define CYCV_CLKMGR_MAIN_PLL_MAINDIV_L4SP		__BITS(7, 9)
#define CYCV_CLKMGR_MAIN_PLL_DBGDIV		0x68
#define CYCV_CLKMGR_MAIN_PLL_TRACEDIV		0x6C
#define CYCV_CLKMGR_MAIN_PLL_L4SRC		0x70
#define CYCV_CLKMGR_MAIN_PLL_L4SRC_L4SP			__BIT(1)
#define CYCV_CLKMGR_MAIN_PLL_L4SRC_L4MP			__BIT(0)
#define CYCV_CLKMGR_MAIN_PLL_STAT		0x74

#define CYCV_CLKMGR_PERI_PLL_VCO		0x80
#define CYCV_CLKMGR_PERI_PLL_MISC		0x84
#define CYCV_CLKMGR_PERI_PLL_EMAC0CLK		0x88
#define CYCV_CLKMGR_PERI_PLL_EMAC1CLK		0x8C
#define CYCV_CLKMGR_PERI_PLL_PERQSPICLK		0x90
#define CYCV_CLKMGR_PERI_PLL_PERNANDSDMMCCLK	0x94
#define CYCV_CLKMGR_PERI_PLL_PERBASECLK		0x98
#define CYCV_CLKMGR_PERI_PLL_PERBASECLK_CNT		__BITS(0, 8)
#define CYCV_CLKMGR_PERI_PLL_H2FUSER1CLK	0x9C
#define CYCV_CLKMGR_PERI_PLL_EN			0xA0
#define CYCV_CLKMGR_PERI_PLL_DIV		0xA4
#define CYCV_CLKMGR_PERI_PLL_GPIODIV		0xA8
#define CYCV_CLKMGR_PERI_PLL_SRC		0xAC
#define CYCV_CLKMGR_PERI_PLL_STAT		0xB0

#define CYCV_CLKMGR_SDRAM_PLL_VCO		0xC0
#define CYCV_CLKMGR_SDRAM_PLL_CTRL		0xC4
#define CYCV_CLKMGR_SDRAM_PLL_DDRDQSCLK		0xC8
#define CYCV_CLKMGR_SDRAM_PLL_DDR2XDQSCLK	0xCC
#define CYCV_CLKMGR_SDRAM_PLL_DDRDQCLK		0xD0
#define CYCV_CLKMGR_SDRAM_PLL_S2FUSER2CLK	0xD4
#define CYCV_CLKMGR_SDRAM_PLL_EN		0xD8
#define CYCV_CLKMGR_SDRAM_PLL_STAT		0xDC

/* Reset manager */

#define CYCV_RSTMGR_BASE			0xFFD05000
#define CYCV_RSTMGR_SIZE			0x24

#define CYCV_RSTMGR_STAT			0x00
#define CYCV_RSTMGR_CTRL			0x04
#define CYCV_RSTMGR_CTRL_SWCOLDRSTREQ			__BIT(0)
#define CYCV_RSTMGR_COUNTS			0x08
#define CYCV_RSTMGR_MPUMODRST			0x10
#define CYCV_RSTMGR_MPUMODRST_CPU1			__BIT(1)
#define CYCV_RSTMGR_PERMODRST			0x14
#define CYCV_RSTMGR_PER2MODRST			0x18
#define CYCV_RSTMGR_BRGMODRST			0x1C
#define CYCV_RSTMGR_MISCMODRST			0x20

/* Snoop Control Unit */

#define CYCV_SCU_BASE				0xFFFEC000
#define CYCV_SCU_SIZE				0x100

/* Level 2 Cache */

#define CYCV_L2CACHE_BASE			0xFFFEF000
#define CYCV_L2CACHE_SIZE			0x1000

#endif /* _ARM_ALTERA_CYCV_REG_H */
