.\" Copyright (c) 1993, 1994  X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
.\" OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall not
.\" be used in advertising or otherwise to promote the sale, use or other
.\" dealing in this Software without prior written authorization from the
.\" X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw Xt-Initialize
.na
.TH XtInitialize __libmansuffix__ __xorgversion__ "XT COMPATIBILITY FUNCTIONS"
.SH NAME
XtInitialize \- initialize
.SH SYNTAX
#include <X11/Intrinsic.h>
.HP
Widget XtInitialize(const char *\fIshell_name\fP,
const char *\fIapplication_class\fP,
XrmOptionDescRec* \fIoptions\fP, Cardinal \fInum_options\fP,
int* \fIargc\fP, char** \fIargv\fP);
.SH ARGUMENTS
.IP \fIshell_name\fP 1i
Specifies the name of the created shell widget.
.IP \fIapplication_class\fP 1i
Specifies the class name of this application, which usually is the generic name for all instances of this application.
.IP \fIoptions\fP 1i
Specifies how to parse the command line for any application-specific resources.
The options argument is passed as a parameter to
.BR XrmParseCommand .
For further information,
see \fI\*(xL\fP.
.IP \fInum_options\fP 1i
Specifies the number of entries in the options list.
.IP \fIargc\fP 1i
Specifies a pointer to the number of command line parameters.
.IP \fIargv\fP 1i
Specifies the command line parameters.
.SH DESCRIPTION
.B XtInitialize
calls
.B XtToolkitInitialize
followed by
.B XtOpenDisplay
with \fIdisplay_string\fP NULL and \fIapplication_name\fP NULL, and
finally calls
.B XtAppCreateShell
with \fIapplication_name\fP NULL, \fIwidget_class\fP
.BR applicationShellWidgetClass ,
and the specified \fIargs\fP and \fInum_args\fP and returns the
created shell.
The semantics of calling
.B XtInitialize
more than once are undefined.
This routine has been replaced by
.BR XtAppInitialize .
.SH "SEE ALSO"
.BR XtAppInitialize (__libmansuffix__)
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
