/*	$NetBSD: nouveau_nvkm_engine_vp_g84.c,v 1.3 2021/12/18 23:45:37 riastradh Exp $	*/

/*
 * Copyright 2012 Red Hat Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Authors: Ben Skeggs, Ilia Mirkin
 */
#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: nouveau_nvkm_engine_vp_g84.c,v 1.3 2021/12/18 23:45:37 riastradh Exp $");

#include <engine/vp.h>

#include <nvif/class.h>

static const struct nvkm_xtensa_func
g84_vp = {
	.fifo_val = 0x111,
	.unkd28 = 0x9c544,
	.sclass = {
		{ -1, -1, NV74_VP2 },
		{}
	}
};

int
g84_vp_new(struct nvkm_device *device, int index, struct nvkm_engine **pengine)
{
	return nvkm_xtensa_new_(&g84_vp, device, index,
				true, 0x00f000, pengine);
}
