/* $NetBSD: imx7d_ccm.h,v 1.1 2020/12/23 14:42:38 skrll Exp $ */

/*-
 * Copyright (c) 2020 Jared McNeill <jmcneill@invisible.ca>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _IMX7D_CCM_H
#define _IMX7D_CCM_H

/*
 * Clocks
 */

#define	OSC_24M_CLK 0
#define	PLL_ARM_MAIN 1
#define	PLL_ARM_MAIN_CLK 2
#define	PLL_ARM_MAIN_SRC 3
#define	PLL_ARM_MAIN_BYPASS 4
#define	PLL_SYS_MAIN 5
#define	PLL_SYS_MAIN_CLK 6
#define	PLL_SYS_MAIN_SRC 7
#define	PLL_SYS_MAIN_BYPASS 8
#define	PLL_SYS_MAIN_480M 9
#define	PLL_SYS_MAIN_240M 10
#define	PLL_SYS_MAIN_120M 11
#define	PLL_SYS_MAIN_480M_CLK 12
#define	PLL_SYS_MAIN_240M_CLK 13
#define	PLL_SYS_MAIN_120M_CLK 14
#define	PLL_SYS_PFD0_392M_CLK 15
#define	PLL_SYS_PFD0_196M 16
#define	PLL_SYS_PFD0_196M_CLK 17
#define	PLL_SYS_PFD1_332M_CLK 18
#define	PLL_SYS_PFD1_166M 19
#define	PLL_SYS_PFD1_166M_CLK 20
#define	PLL_SYS_PFD2_270M_CLK 21
#define	PLL_SYS_PFD2_135M 22
#define	PLL_SYS_PFD2_135M_CLK 23
#define	PLL_SYS_PFD3_CLK 24
#define	PLL_SYS_PFD4_CLK 25
#define	PLL_SYS_PFD5_CLK 26
#define	PLL_SYS_PFD6_CLK 27
#define	PLL_SYS_PFD7_CLK 28
#define	PLL_ENET_MAIN 29
#define	PLL_ENET_MAIN_CLK 30
#define	PLL_ENET_MAIN_SRC 31
#define	PLL_ENET_MAIN_BYPASS 32
#define	PLL_ENET_MAIN_500M 33
#define	PLL_ENET_MAIN_250M 34
#define	PLL_ENET_MAIN_125M 35
#define	PLL_ENET_MAIN_100M 36
#define	PLL_ENET_MAIN_50M 37
#define	PLL_ENET_MAIN_40M 38
#define	PLL_ENET_MAIN_25M 39
#define	PLL_ENET_MAIN_500M_CLK 40
#define	PLL_ENET_MAIN_250M_CLK 41
#define	PLL_ENET_MAIN_125M_CLK 42
#define	PLL_ENET_MAIN_100M_CLK 43
#define	PLL_ENET_MAIN_50M_CLK 44
#define	PLL_ENET_MAIN_40M_CLK 45
#define	PLL_ENET_MAIN_25M_CLK 46
#define	PLL_DRAM_MAIN 47
#define	PLL_DRAM_MAIN_CLK 48
#define	PLL_DRAM_MAIN_SRC 49
#define	PLL_DRAM_MAIN_BYPASS 50
#define	PLL_DRAM_MAIN_533M 51
#define	PLL_DRAM_MAIN_533M_CLK 52
#define	PLL_AUDIO_MAIN 53
#define	PLL_AUDIO_MAIN_CLK 54
#define	PLL_AUDIO_MAIN_SRC 55
#define	PLL_AUDIO_MAIN_BYPASS 56
#define	PLL_VIDEO_MAIN_CLK 57
#define	PLL_VIDEO_MAIN 58
#define	PLL_VIDEO_MAIN_SRC 59
#define	PLL_VIDEO_MAIN_BYPASS 60
#define	USB_MAIN_480M_CLK 61
#define	ARM_A7_ROOT_CLK 62
#define	ARM_A7_ROOT_SRC 63
#define	ARM_A7_ROOT_CG 64
#define	ARM_A7_ROOT_DIV 65
#define	ARM_M4_ROOT_CLK 66
#define	ARM_M4_ROOT_SRC 67
#define	ARM_M4_ROOT_CG 68
#define	ARM_M4_ROOT_DIV 69
#define	ARM_M0_ROOT_CLK 70
#define	ARM_M0_ROOT_SRC 71
#define	ARM_M0_ROOT_CG 72
#define	ARM_M0_ROOT_DIV 73
#define	MAIN_AXI_ROOT_CLK 74
#define	MAIN_AXI_ROOT_SRC 75
#define	MAIN_AXI_ROOT_CG 76
#define	MAIN_AXI_ROOT_DIV 77
#define	DISP_AXI_ROOT_CLK 78
#define	DISP_AXI_ROOT_SRC 79
#define	DISP_AXI_ROOT_CG 80
#define	DISP_AXI_ROOT_DIV 81
#define	ENET_AXI_ROOT_CLK 82
#define	ENET_AXI_ROOT_SRC 83
#define	ENET_AXI_ROOT_CG 84
#define	ENET_AXI_ROOT_DIV 85
#define	NAND_USDHC_BUS_ROOT_CLK 86
#define	NAND_USDHC_BUS_ROOT_SRC 87
#define	NAND_USDHC_BUS_ROOT_CG 88
#define	NAND_USDHC_BUS_ROOT_DIV 89
#define	AHB_CHANNEL_ROOT_CLK 90
#define	AHB_CHANNEL_ROOT_SRC 91
#define	AHB_CHANNEL_ROOT_CG 92
#define	AHB_CHANNEL_ROOT_DIV 93
#define	DRAM_PHYM_ROOT_CLK 94
#define	DRAM_PHYM_ROOT_SRC 95
#define	DRAM_PHYM_ROOT_CG 96
#define	DRAM_PHYM_ROOT_DIV 97
#define	DRAM_ROOT_CLK 98
#define	DRAM_ROOT_SRC 99
#define	DRAM_ROOT_CG 100
#define	DRAM_ROOT_DIV 101
#define	DRAM_PHYM_ALT_ROOT_CLK 102
#define	DRAM_PHYM_ALT_ROOT_SRC 103
#define	DRAM_PHYM_ALT_ROOT_CG 104
#define	DRAM_PHYM_ALT_ROOT_DIV 105
#define	DRAM_ALT_ROOT_CLK 106
#define	DRAM_ALT_ROOT_SRC 107
#define	DRAM_ALT_ROOT_CG 108
#define	DRAM_ALT_ROOT_DIV 109
#define	USB_HSIC_ROOT_CLK 110
#define	USB_HSIC_ROOT_SRC 111
#define	USB_HSIC_ROOT_CG 112
#define	USB_HSIC_ROOT_DIV 113
#define	PCIE_CTRL_ROOT_CLK 114
#define	PCIE_CTRL_ROOT_SRC 115
#define	PCIE_CTRL_ROOT_CG 116
#define	PCIE_CTRL_ROOT_DIV 117
#define	PCIE_PHY_ROOT_CLK 118
#define	PCIE_PHY_ROOT_SRC 119
#define	PCIE_PHY_ROOT_CG 120
#define	PCIE_PHY_ROOT_DIV 121
#define	EPDC_PIXEL_ROOT_CLK 122
#define	EPDC_PIXEL_ROOT_SRC 123
#define	EPDC_PIXEL_ROOT_CG 124
#define	EPDC_PIXEL_ROOT_DIV 125
#define	LCDIF_PIXEL_ROOT_CLK 126
#define	LCDIF_PIXEL_ROOT_SRC 127
#define	LCDIF_PIXEL_ROOT_CG 128
#define	LCDIF_PIXEL_ROOT_DIV 129
#define	MIPI_DSI_ROOT_CLK 130
#define	MIPI_DSI_ROOT_SRC 131
#define	MIPI_DSI_ROOT_CG 132
#define	MIPI_DSI_ROOT_DIV 133
#define	MIPI_CSI_ROOT_CLK 134
#define	MIPI_CSI_ROOT_SRC 135
#define	MIPI_CSI_ROOT_CG 136
#define	MIPI_CSI_ROOT_DIV 137
#define	MIPI_DPHY_ROOT_CLK 138
#define	MIPI_DPHY_ROOT_SRC 139
#define	MIPI_DPHY_ROOT_CG 140
#define	MIPI_DPHY_ROOT_DIV 141
#define	SAI1_ROOT_CLK 142
#define	SAI1_ROOT_SRC 143
#define	SAI1_ROOT_CG 144
#define	SAI1_ROOT_DIV 145
#define	SAI2_ROOT_CLK 146
#define	SAI2_ROOT_SRC 147
#define	SAI2_ROOT_CG 148
#define	SAI2_ROOT_DIV 149
#define	SAI3_ROOT_CLK 150
#define	SAI3_ROOT_SRC 151
#define	SAI3_ROOT_CG 152
#define	SAI3_ROOT_DIV 153
#define	SPDIF_ROOT_CLK 154
#define	SPDIF_ROOT_SRC 155
#define	SPDIF_ROOT_CG 156
#define	SPDIF_ROOT_DIV 157
#define	ENET1_IPG_ROOT_CLK 158
#define	ENET1_REF_ROOT_SRC 159
#define	ENET1_REF_ROOT_CG 160
#define	ENET1_REF_ROOT_DIV 161
#define	ENET1_TIME_ROOT_CLK 162
#define	ENET1_TIME_ROOT_SRC 163
#define	ENET1_TIME_ROOT_CG 164
#define	ENET1_TIME_ROOT_DIV 165
#define	ENET2_IPG_ROOT_CLK 166
#define	ENET2_REF_ROOT_SRC 167
#define	ENET2_REF_ROOT_CG 168
#define	ENET2_REF_ROOT_DIV 169
#define	ENET2_TIME_ROOT_CLK 170
#define	ENET2_TIME_ROOT_SRC 171
#define	ENET2_TIME_ROOT_CG 172
#define	ENET2_TIME_ROOT_DIV 173
#define	ENET_PHY_REF_ROOT_CLK 174
#define	ENET_PHY_REF_ROOT_SRC 175
#define	ENET_PHY_REF_ROOT_CG 176
#define	ENET_PHY_REF_ROOT_DIV 177
#define	EIM_ROOT_CLK 178
#define	EIM_ROOT_SRC 179
#define	EIM_ROOT_CG 180
#define	EIM_ROOT_DIV 181
#define	NAND_ROOT_CLK 182
#define	NAND_ROOT_SRC 183
#define	NAND_ROOT_CG 184
#define	NAND_ROOT_DIV 185
#define	QSPI_ROOT_CLK 186
#define	QSPI_ROOT_SRC 187
#define	QSPI_ROOT_CG 188
#define	QSPI_ROOT_DIV 189
#define	USDHC1_ROOT_CLK 190
#define	USDHC1_ROOT_SRC 191
#define	USDHC1_ROOT_CG 192
#define	USDHC1_ROOT_DIV 193
#define	USDHC2_ROOT_CLK 194
#define	USDHC2_ROOT_SRC 195
#define	USDHC2_ROOT_CG 196
#define	USDHC2_ROOT_DIV 197
#define	USDHC3_ROOT_CLK 198
#define	USDHC3_ROOT_SRC 199
#define	USDHC3_ROOT_CG 200
#define	USDHC3_ROOT_DIV 201
#define	CAN1_ROOT_CLK 202
#define	CAN1_ROOT_SRC 203
#define	CAN1_ROOT_CG 204
#define	CAN1_ROOT_DIV 205
#define	CAN2_ROOT_CLK 206
#define	CAN2_ROOT_SRC 207
#define	CAN2_ROOT_CG 208
#define	CAN2_ROOT_DIV 209
#define	I2C1_ROOT_CLK 210
#define	I2C1_ROOT_SRC 211
#define	I2C1_ROOT_CG 212
#define	I2C1_ROOT_DIV 213
#define	I2C2_ROOT_CLK 214
#define	I2C2_ROOT_SRC 215
#define	I2C2_ROOT_CG 216
#define	I2C2_ROOT_DIV 217
#define	I2C3_ROOT_CLK 218
#define	I2C3_ROOT_SRC 219
#define	I2C3_ROOT_CG 220
#define	I2C3_ROOT_DIV 221
#define	I2C4_ROOT_CLK 222
#define	I2C4_ROOT_SRC 223
#define	I2C4_ROOT_CG 224
#define	I2C4_ROOT_DIV 225
#define	UART1_ROOT_CLK 226
#define	UART1_ROOT_SRC 227
#define	UART1_ROOT_CG 228
#define	UART1_ROOT_DIV 229
#define	UART2_ROOT_CLK 230
#define	UART2_ROOT_SRC 231
#define	UART2_ROOT_CG 232
#define	UART2_ROOT_DIV 233
#define	UART3_ROOT_CLK 234
#define	UART3_ROOT_SRC 235
#define	UART3_ROOT_CG 236
#define	UART3_ROOT_DIV 237
#define	UART4_ROOT_CLK 238
#define	UART4_ROOT_SRC 239
#define	UART4_ROOT_CG 240
#define	UART4_ROOT_DIV 241
#define	UART5_ROOT_CLK 242
#define	UART5_ROOT_SRC 243
#define	UART5_ROOT_CG 244
#define	UART5_ROOT_DIV 245
#define	UART6_ROOT_CLK 246
#define	UART6_ROOT_SRC 247
#define	UART6_ROOT_CG 248
#define	UART6_ROOT_DIV 249
#define	UART7_ROOT_CLK 250
#define	UART7_ROOT_SRC 251
#define	UART7_ROOT_CG 252
#define	UART7_ROOT_DIV 253
#define	ECSPI1_ROOT_CLK 254
#define	ECSPI1_ROOT_SRC 255
#define	ECSPI1_ROOT_CG 256
#define	ECSPI1_ROOT_DIV 257
#define	ECSPI2_ROOT_CLK 258
#define	ECSPI2_ROOT_SRC 259
#define	ECSPI2_ROOT_CG 260
#define	ECSPI2_ROOT_DIV 261
#define	ECSPI3_ROOT_CLK 262
#define	ECSPI3_ROOT_SRC 263
#define	ECSPI3_ROOT_CG 264
#define	ECSPI3_ROOT_DIV 265
#define	ECSPI4_ROOT_CLK 266
#define	ECSPI4_ROOT_SRC 267
#define	ECSPI4_ROOT_CG 268
#define	ECSPI4_ROOT_DIV 269
#define	PWM1_ROOT_CLK 270
#define	PWM1_ROOT_SRC 271
#define	PWM1_ROOT_CG 272
#define	PWM1_ROOT_DIV 273
#define	PWM2_ROOT_CLK 274
#define	PWM2_ROOT_SRC 275
#define	PWM2_ROOT_CG 276
#define	PWM2_ROOT_DIV 277
#define	PWM3_ROOT_CLK 278
#define	PWM3_ROOT_SRC 279
#define	PWM3_ROOT_CG 280
#define	PWM3_ROOT_DIV 281
#define	PWM4_ROOT_CLK 282
#define	PWM4_ROOT_SRC 283
#define	PWM4_ROOT_CG 284
#define	PWM4_ROOT_DIV 285
#define	FLEXTIMER1_ROOT_CLK 286
#define	FLEXTIMER1_ROOT_SRC 287
#define	FLEXTIMER1_ROOT_CG 288
#define	FLEXTIMER1_ROOT_DIV 289
#define	FLEXTIMER2_ROOT_CLK 290
#define	FLEXTIMER2_ROOT_SRC 291
#define	FLEXTIMER2_ROOT_CG 292
#define	FLEXTIMER2_ROOT_DIV 293
#define	SIM1_ROOT_CLK 294
#define	SIM1_ROOT_SRC 295
#define	SIM1_ROOT_CG 296
#define	SIM1_ROOT_DIV 297
#define	SIM2_ROOT_CLK 298
#define	SIM2_ROOT_SRC 299
#define	SIM2_ROOT_CG 300
#define	SIM2_ROOT_DIV 301
#define	GPT1_ROOT_CLK 302
#define	GPT1_ROOT_SRC 303
#define	GPT1_ROOT_CG 304
#define	GPT1_ROOT_DIV 305
#define	GPT2_ROOT_CLK 306
#define	GPT2_ROOT_SRC 307
#define	GPT2_ROOT_CG 308
#define	GPT2_ROOT_DIV 309
#define	GPT3_ROOT_CLK 310
#define	GPT3_ROOT_SRC 311
#define	GPT3_ROOT_CG 312
#define	GPT3_ROOT_DIV 313
#define	GPT4_ROOT_CLK 314
#define	GPT4_ROOT_SRC 315
#define	GPT4_ROOT_CG 316
#define	GPT4_ROOT_DIV 317
#define	TRACE_ROOT_CLK 318
#define	TRACE_ROOT_SRC 319
#define	TRACE_ROOT_CG 320
#define	TRACE_ROOT_DIV 321
#define	WDOG1_ROOT_CLK 322
#define	WDOG_ROOT_SRC 323
#define	WDOG_ROOT_CG 324
#define	WDOG_ROOT_DIV 325
#define	CSI_MCLK_ROOT_CLK 326
#define	CSI_MCLK_ROOT_SRC 327
#define	CSI_MCLK_ROOT_CG 328
#define	CSI_MCLK_ROOT_DIV 329
#define	AUDIO_MCLK_ROOT_CLK 330
#define	AUDIO_MCLK_ROOT_SRC 331
#define	AUDIO_MCLK_ROOT_CG 332
#define	AUDIO_MCLK_ROOT_DIV 333
#define	WRCLK_ROOT_CLK 334
#define	WRCLK_ROOT_SRC 335
#define	WRCLK_ROOT_CG 336
#define	WRCLK_ROOT_DIV 337
#define	CLKO1_ROOT_SRC 338
#define	CLKO1_ROOT_CG 339
#define	CLKO1_ROOT_DIV 340
#define	CLKO2_ROOT_SRC 341
#define	CLKO2_ROOT_CG 342
#define	CLKO2_ROOT_DIV 343
#define	MAIN_AXI_ROOT_PRE_DIV 344
#define	DISP_AXI_ROOT_PRE_DIV 345
#define	ENET_AXI_ROOT_PRE_DIV 346
#define	NAND_USDHC_BUS_ROOT_PRE_DIV 347
#define	AHB_CHANNEL_ROOT_PRE_DIV 348
#define	USB_HSIC_ROOT_PRE_DIV 349
#define	PCIE_CTRL_ROOT_PRE_DIV 350
#define	PCIE_PHY_ROOT_PRE_DIV 351
#define	EPDC_PIXEL_ROOT_PRE_DIV 352
#define	LCDIF_PIXEL_ROOT_PRE_DIV 353
#define	MIPI_DSI_ROOT_PRE_DIV 354
#define	MIPI_CSI_ROOT_PRE_DIV 355
#define	MIPI_DPHY_ROOT_PRE_DIV 356
#define	SAI1_ROOT_PRE_DIV 357
#define	SAI2_ROOT_PRE_DIV 358
#define	SAI3_ROOT_PRE_DIV 359
#define	SPDIF_ROOT_PRE_DIV 360
#define	ENET1_REF_ROOT_PRE_DIV 361
#define	ENET1_TIME_ROOT_PRE_DIV 362
#define	ENET2_REF_ROOT_PRE_DIV 363
#define	ENET2_TIME_ROOT_PRE_DIV 364
#define	ENET_PHY_REF_ROOT_PRE_DIV 365
#define	EIM_ROOT_PRE_DIV 366
#define	NAND_ROOT_PRE_DIV 367
#define	QSPI_ROOT_PRE_DIV 368
#define	USDHC1_ROOT_PRE_DIV 369
#define	USDHC2_ROOT_PRE_DIV 370
#define	USDHC3_ROOT_PRE_DIV 371
#define	CAN1_ROOT_PRE_DIV 372
#define	CAN2_ROOT_PRE_DIV 373
#define	I2C1_ROOT_PRE_DIV 374
#define	I2C2_ROOT_PRE_DIV 375
#define	I2C3_ROOT_PRE_DIV 376
#define	I2C4_ROOT_PRE_DIV 377
#define	UART1_ROOT_PRE_DIV 378
#define	UART2_ROOT_PRE_DIV 379
#define	UART3_ROOT_PRE_DIV 380
#define	UART4_ROOT_PRE_DIV 381
#define	UART5_ROOT_PRE_DIV 382
#define	UART6_ROOT_PRE_DIV 383
#define	UART7_ROOT_PRE_DIV 384
#define	ECSPI1_ROOT_PRE_DIV 385
#define	ECSPI2_ROOT_PRE_DIV 386
#define	ECSPI3_ROOT_PRE_DIV 387
#define	ECSPI4_ROOT_PRE_DIV 388
#define	PWM1_ROOT_PRE_DIV 389
#define	PWM2_ROOT_PRE_DIV 390
#define	PWM3_ROOT_PRE_DIV 391
#define	PWM4_ROOT_PRE_DIV 392
#define	FLEXTIMER1_ROOT_PRE_DIV 393
#define	FLEXTIMER2_ROOT_PRE_DIV 394
#define	SIM1_ROOT_PRE_DIV 395
#define	SIM2_ROOT_PRE_DIV 396
#define	GPT1_ROOT_PRE_DIV 397
#define	GPT2_ROOT_PRE_DIV 398
#define	GPT3_ROOT_PRE_DIV 399
#define	GPT4_ROOT_PRE_DIV 400
#define	TRACE_ROOT_PRE_DIV 401
#define	WDOG_ROOT_PRE_DIV 402
#define	CSI_MCLK_ROOT_PRE_DIV 403
#define	AUDIO_MCLK_ROOT_PRE_DIV 404
#define	WRCLK_ROOT_PRE_DIV 405
#define	CLKO1_ROOT_PRE_DIV 406
#define	CLKO2_ROOT_PRE_DIV 407
#define	DRAM_PHYM_ALT_ROOT_PRE_DIV 408
#define	DRAM_ALT_ROOT_PRE_DIV 409
#define	LVDS1_IN_CLK 410
#define	LVDS1_OUT_SEL 411
#define	LVDS1_OUT_CLK 412
#define	CLK_DUMMY 413
#define	GPT_3M_CLK 414
#define	OCRAM_CLK 415
#define	OCRAM_S_CLK 416
#define	WDOG2_ROOT_CLK 417
#define	WDOG3_ROOT_CLK 418
#define	WDOG4_ROOT_CLK 419
#define	SDMA_CORE_CLK 420
#define	USB1_MAIN_480M_CLK 421
#define	USB_CTRL_CLK 422
#define	USB_PHY1_CLK 423
#define	USB_PHY2_CLK 424
#define	IPG_ROOT_CLK 425
#define	SAI1_IPG_CLK 426
#define	SAI2_IPG_CLK 427
#define	SAI3_IPG_CLK 428
#define	PLL_AUDIO_TEST_DIV 429
#define	PLL_AUDIO_POST_DIV 430
#define	PLL_VIDEO_TEST_DIV 431
#define	PLL_VIDEO_POST_DIV 432
#define	MU_ROOT_CLK 433
#define	SEMA4_HS_ROOT_CLK 434
#define	PLL_DRAM_TEST_DIV 435
#define	ADC_ROOT_CLK 436
#define	CLK_ARM 437
#define	CKIL 438
#define	OCOTP_CLK 439
#define	NAND_RAWNAND_CLK 440
#define	NAND_USDHC_BUS_RAWNAND_CLK 441
#define	SNVS_CLK 442
#define	CAAM_CLK 443
#define	KPP_ROOT_CLK 444

#endif /* !_IMX7D_CCM_H */
