/*	$NetBSD: bcm2838_pcie.h,v 1.1 2021/03/08 13:49:01 mlelstv Exp $ */

/*-
 * Copyright (c) 2020 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Michael van Elst
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *	notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *	notice, this list of conditions and the following disclaimer in the
 *	documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.	IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _BCM2838_PCIE_H
#define _BCM2838_PCIE_H

/* Broadcom Settop Box PCIE Register Offsets.	*/
#define PCIE_RC_CFG_VENDOR_VENDOR_SPECIFIC_REG1				0x0188
#define  PCIE_RC_CFG_VENDOR_VENDOR_SPECIFIC_REG1_ENDIAN_MODE_BAR1	__BITS(0,1)
#define  PCIE_RC_CFG_VENDOR_VENDOR_SPECIFIC_REG1_ENDIAN_MODE_BAR2	__BITS(2,3)
#define  PCIE_RC_CFG_VENDOR_VENDOR_SPECIFIC_REG1_ENDIAN_MODE_BAR3	__BITS(4,5)

#define PCIE_RC_CFG_PRIV1_ID_VAL3				0x043c
#define  PCIE_RC_CFG_PRIV1_ID_VAL3_CLASS_CODE			__BITS(0,23)

#define PCIE_RC_CFG_PRIV1_LINK_CAPABILITY			0x04dc
#define  PCIE_RC_CFG_PRIV1_LINK_CAPABILITY_ASPM_SUPPORT		__BITS(10,11)

#define PCIE_RC_DL_MDIO_ADDR					0x1100
#define PCIE_RC_DL_MDIO_WR_DATA					0x1104
#define PCIE_RC_DL_MDIO_RD_DATA					0x1108
#define  PCIE_RC_DL_MDIO_DATA					__BITS(0,30)
#define  PCIE_RC_DL_MDIO_PORT					__BITS(16,19)
#define  PCIE_RC_DL_MDIO_REGAD					__BITS(0,15)
#define  PCIE_RC_DL_MDIO_CMD					__BITS(20,31)
#define  PCIE_RC_DL_MDIO_READ					__BIT(0)
#define  PCIE_RC_DL_MDIO_DATA_DONE				__BIT(31)


#define PCIE_MISC_MISC_CTRL					0x4008
#define  PCIE_MISC_MISC_CTRL_SCB_ACCESS_EN			__BIT(12)
#define  PCIE_MISC_MISC_CTRL_CFG_READ_UR_MODE			__BIT(13)
#define  PCIE_MISC_MISC_CTRL_MAX_BURST_SIZE			__BITS(20,21)
#define  PCIE_MISC_MISC_CTRL_SCB0_SIZE				__BITS(27,31)
#define  PCIE_MISC_MISC_CTRL_SCB1_SIZE				__BITS(22,26)
#define  PCIE_MISC_MISC_CTRL_SCB2_SIZE				__BITS(0,4)

#define PCIE_RC_CFG_PCIE_LINK_CAPABILITY			0x00b8
#define  PCIE_RC_CFG_PCIE_LINK_CAPABILITY_MAX_LINK_SPEED	__BITS(0,3)
#define PCIE_RC_CFG_PCIE_LINK_STATUS_CONTROL			0x00bc
#define  PCIE_RC_CFG_PCIE_LINK_STATUS_CONTROL_NEG_LINK_WIDTH	__BITS(24,29)
#define  PCIE_RC_CFG_PCIE_LINK_STATUS_CONTROL_NEG_LINK_SPEED	__BITS(16,19)
#define PCIE_RC_CFG_PCIE_ROOT_CAP_CONTROL			0x00c8
#define  PCIE_RC_CFG_PCIE_ROOT_CAP_CONTROL_RC_CRS_EN		__BITS(4,7)
#define PCIE_RC_CFG_PCIE_LINK_STATUS_CONTROL_2	 		0x00dc
#define	 PCIE_RC_CFG_PCIE_LINK_STATUS_CONTROL_2_TARGET_LINK_SPEED	__BITS(0,3)

#define PCIE_MISC_CPU_2_PCIE_MEM_WIN0_LO(w)			(0x400c + (w) * 0x4)
#define PCIE_MISC_CPU_2_PCIE_MEM_WIN0_HI(w)			(0x4010 + (w) * 0x4)

#define PCIE_MISC_RC_BAR1_CONFIG_LO				0x402c
#define  PCIE_MISC_RC_BARx_CONFIG_LO_MATCH_ADDRESS		__BITS(12,31)
#define  PCIE_MISC_RC_BARx_CONFIG_LO_SIZE			__BITS(0,5)
#define PCIE_MISC_RC_BAR1_CONFIG_HI				0x4030
#define PCIE_MISC_RC_BAR2_CONFIG_LO				0x4034
#define PCIE_MISC_RC_BAR2_CONFIG_HI				0x4038
#define PCIE_MISC_RC_BAR3_CONFIG_LO				0x403c
#define PCIE_MISC_RC_BAR3_CONFIG_HI				0x4040

#define PCIE_MISC_PCIE_CTRL					0x4064
#define  PCIE_MISC_PCIE_CTRL_PCIE_PERSTB			__BIT(2)
#define  PCIE_MISC_PCIE_CTRL_PCIE_L23_REQUEST			__BIT(0)

#define PCIE_MISC_PCIE_STATUS					0x4068
#define  PCIE_MISC_PCIE_STATUS_PCIE_PORT			__BIT(7)
#define  PCIE_MISC_PCIE_STATUS_PCIE_LINK_IN_L23			__BIT(6)
#define  PCIE_MISC_PCIE_STATUS_PCIE_DL_ACTIVE			__BIT(5)
#define  PCIE_MISC_PCIE_STATUS_PCIE_PHYLINKUP			__BIT(4)

#define PCIE_MISC_REVISION					0x406c
#define  PCIE_MISC_REVISION_MAJMIN	 			__BITS(0,15)

#define PCIE_MISC_CPU_2_PCIE_MEM_WIN0_BASE_LIMIT(w)		(0x4070 + (w) * 0x4)
#define  PCIE_MISC_CPU_2_PCIE_MEM_WIN0_BASE_LIMIT_LIMIT		__BITS(20,31)
#define  PCIE_MISC_CPU_2_PCIE_MEM_WIN0_BASE_LIMIT_BASE 		__BITS(4,15)

#define PCIE_MISC_CPU_2_PCIE_MEM_WIN0_BASE_HI(w)		(0x4080 + (w) * 0x4)
#define  PCIE_MISC_CPU_2_PCIE_MEM_WIN0_BASE_HI_BASE		__BITS(0,7)

#define PCIE_MISC_CPU_2_PCIE_MEM_WIN0_LIMIT_HI(w) 		(0x4084 + (w) * 0x8)
#define  PCIE_MISC_CPU_2_PCIE_MEM_WIN0_LIMIT_HI_LIMIT 		__BITS(0,7)

#define PCIE_MISC_HARD_PCIE_HARD_DEBUG		 		0x4204
#define  PCIE_MISC_HARD_PCIE_HARD_DEBUG_CLKREQ			__BIT(1)
#define  PCIE_MISC_HARD_PCIE_HARD_DEBUG_SERDES_IDDQ		__BIT(27)

#define PCIE_INTR2_STATUS					0x4300
#define PCIE_INTR2_SET						0x4304
#define PCIE_INTR2_CLR						0x4308
#define PCIE_INTR2_MASK_STATUS					0x430c
#define PCIE_INTR2_MASK_SET					0x4310
#define PCIE_INTR2_MASK_CLR					0x4314

#define PCIE_MSI_INTR2_STATUS					0x4500
#define PCIE_MSI_INTR2_SET					0x4504
#define PCIE_MSI_INTR2_CLR					0x4508
#define PCIE_MSI_INTR2_MASK_STATUS				0x450c
#define PCIE_MSI_INTR2_MASK_SET					0x4510
#define PCIE_MSI_INTR2_MASK_CLR					0x4514

#define PCIE_EXT_CFG_DATA					0x8000

#define PCIE_EXT_CFG_INDEX					0x9000
#define  PCIE_EXT_CFG_INDEX_BUSNUM				__BITS(20,27)
#define  PCIE_EXT_CFG_INDEX_SLOT				__BITS(15,19)
#define  PCIE_EXT_CFG_INDEX_FUNC				__BITS(12,14)

#define PCIE_RGR1_SW_INIT_1					0x9210
#define  PCIE_RGR1_SW_INIT_1_PERST			 	__BIT(0)
#define  PCIE_RGR1_SW_INIT_1_INIT			 	__BIT(1)

#endif /* !_BCM2838_PCIE_H */
