#!/usr/bin/env bash
set -eux

BUILDROOT="$(git rev-parse --show-toplevel)"
SCAN=(scan-build${CC#clang} --use-cc="${CC}")

pushd "$BUILDROOT" &>/dev/null
  ./autogen.sh
  # We want to omit source files generated by third-party tools (e.g.
  # gengetopt) from the static analysis. Therefore, configure to build
  # in a separate directory which we can then pass to scan-build's
  # --exclude flag (which only accepts directories containing source
  # files, not source files directly).
  mkdir build && pushd build &>/dev/null
    ${SCAN[@]} ../configure --disable-silent-rules --disable-man
  popd &>/dev/null
  ${SCAN[@]} --keep-cc --status-bugs --exclude build \
    make -C build -j $(nproc) check
popd &>/dev/null
