/* $NetBSD: gcscpcibreg.h,v 1.1 2011/08/27 12:47:49 bouyer Exp $ */
/* $OpenBSD: glxpcib.c,v 1.6 2007/11/17 17:02:47 mbalmer Exp $	*/

/*
 * Copyright (c) 2007 Marc Balmer <mbalmer@openbsd.org>
 * Copyright (c) 2007 Michael Shalayeff
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF MIND, USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
 * OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * Register definitions for the AMD CS5535/CS5536 Companion Device.
 */

#ifndef _IC_GCSCPCIBREG_H_
#define _IC_GCSCPCIBREG_H_

#define	AMD553X_REV		0x51400017
#define	AMD553X_REV_MASK	0xff
#define	AMD553X_TMC		0x51400050

/* Multi-Functional General Purpose Timer */
#define	MSR_LBAR_MFGPT		0x5140000d
#define AMD553X_MFGPT_MAX	6	/* 6 timers for wdog */
#define AMD553X_MFGPT_REGOFFSET	0x8
#define	AMD553X_MFGPTX_CMP1(x)	(0x00000000 + (AMD553X_MFGPT_REGOFFSET * (x)))
#define	AMD553X_MFGPTX_CMP2(x)	(0x00000002 + (AMD553X_MFGPT_REGOFFSET * (x)))
#define	AMD553X_MFGPTX_CNT(x)	(0x00000004 + (AMD553X_MFGPT_REGOFFSET * (x)))
#define	AMD553X_MFGPTX_SETUP(x)	(0x00000006 + (AMD553X_MFGPT_REGOFFSET * (x)))
#define	AMD553X_MFGPT_DIV_MASK	0x000f	/* div = 1 << mask */
#define	  AMD553X_MFGPT_DIV_1	0x0000
#define	  AMD553X_MFGPT_DIV_2	0x0001
#define	  AMD553X_MFGPT_DIV_4	0x0002
#define	  AMD553X_MFGPT_DIV_8	0x0003
#define	  AMD553X_MFGPT_DIV_16	0x0004
#define	  AMD553X_MFGPT_DIV_32	0x0005
#define	  AMD553X_MFGPT_DIV_64	0x0006
#define	  AMD553X_MFGPT_DIV_128	0x0007
#define	  AMD553X_MFGPT_DIV_256	0x0008
#define	  AMD553X_MFGPT_DIV_512	0x0009
#define	  AMD553X_MFGPT_DIV_1K	0x000a
#define	  AMD553X_MFGPT_DIV_2K	0x000b
#define	  AMD553X_MFGPT_DIV_4K	0x000c
#define	  AMD553X_MFGPT_DIV_8K	0x000d
#define	  AMD553X_MFGPT_DIV_16K	0x000e
#define	  AMD553X_MFGPT_DIV_32K	0x000f
#define	AMD553X_MFGPT_CLKSEL	0x0010
#define	AMD553X_MFGPT_REV_EN	0x0020
#define	AMD553X_MFGPT_CMP1DIS	0x0000
#define	AMD553X_MFGPT_CMP1EQ	0x0040
#define	AMD553X_MFGPT_CMP1GE	0x0080
#define	AMD553X_MFGPT_CMP1EV	0x00c0
#define	AMD553X_MFGPT_CMP2DIS	0x0000
#define	AMD553X_MFGPT_CMP2EQ	0x0100
#define	AMD553X_MFGPT_CMP2GE	0x0200
#define	AMD553X_MFGPT_CMP2EV	0x0300
#define	AMD553X_MFGPT_STOP_EN	0x0800
#define	AMD553X_MFGPT_SET	0x1000
#define	AMD553X_MFGPT_CMP1	0x2000
#define	AMD553X_MFGPT_CMP2	0x4000
#define	AMD553X_MFGPT_CNT_EN	0x8000
#define	AMD553X_MFGPT_IRQ	0x51400028
#define	AMD553X_MFGPT0_C1_IRQM	0x00000001
#define	AMD553X_MFGPT1_C1_IRQM	0x00000002
#define	AMD553X_MFGPT2_C1_IRQM	0x00000004
#define	AMD553X_MFGPT3_C1_IRQM	0x00000008
#define	AMD553X_MFGPT4_C1_IRQM	0x00000010
#define	AMD553X_MFGPT5_C1_IRQM	0x00000020
#define	AMD553X_MFGPT6_C1_IRQM	0x00000040
#define	AMD553X_MFGPT7_C1_IRQM	0x00000080
#define	AMD553X_MFGPT0_C2_IRQM	0x00000100
#define	AMD553X_MFGPT1_C2_IRQM	0x00000200
#define	AMD553X_MFGPT2_C2_IRQM	0x00000400
#define	AMD553X_MFGPT3_C2_IRQM	0x00000800
#define	AMD553X_MFGPT4_C2_IRQM	0x00001000
#define	AMD553X_MFGPT5_C2_IRQM	0x00002000
#define	AMD553X_MFGPT6_C2_IRQM	0x00004000
#define	AMD553X_MFGPT7_C2_IRQM	0x00008000
#define	AMD553X_MFGPT_NR	0x51400029 /* NMI and Reset mask */
#define	AMD553X_MFGPT0_C1_NMIM	0x00000001
#define	AMD553X_MFGPT1_C1_NMIM	0x00000002
#define	AMD553X_MFGPT2_C1_NMIM	0x00000004
#define	AMD553X_MFGPT3_C1_NMIM	0x00000008
#define	AMD553X_MFGPT4_C1_NMIM	0x00000010
#define	AMD553X_MFGPT5_C1_NMIM	0x00000020
#define	AMD553X_MFGPT6_C1_NMIM	0x00000040
#define	AMD553X_MFGPT7_C1_NMIM	0x00000080
#define	AMD553X_MFGPT0_C2_NMIM	0x00000100
#define	AMD553X_MFGPT1_C2_NMIM	0x00000200
#define	AMD553X_MFGPT2_C2_NMIM	0x00000400
#define	AMD553X_MFGPT3_C2_NMIM	0x00000800
#define	AMD553X_MFGPT4_C2_NMIM	0x00001000
#define	AMD553X_MFGPT5_C2_NMIM	0x00002000
#define	AMD553X_MFGPT6_C2_NMIM	0x00004000
#define	AMD553X_MFGPT7_C2_NMIM	0x00008000
#define	AMD553X_NMI_LEG		0x00010000
#define	AMD553X_MFGPT0_C2_RSTEN	0x01000000
#define	AMD553X_MFGPT1_C2_RSTEN	0x02000000
#define	AMD553X_MFGPT2_C2_RSTEN	0x04000000
#define	AMD553X_MFGPT3_C2_RSTEN	0x08000000
#define	AMD553X_MFGPT4_C2_RSTEN	0x10000000
#define	AMD553X_MFGPT5_C2_RSTEN	0x20000000
#define	AMD553X_MFGPT_SETUP	0x5140002b

/* SMB / IIC */
#define	MSR_LBAR_SMB		0x5140000b

/* GPIO */
#define	MSR_LBAR_GPIO		0x5140000c
#define	AMD553X_GPIO_NPINS	32
#define	AMD553X_GPIOH_OFFSET	0x80	/* high bank register offset */
#define	AMD553X_GPIO_OUT_VAL	0x00	/* output value */
#define	AMD553X_GPIO_OUT_EN	0x04	/* output enable */
#define	AMD553X_GPIO_OD_EN	0x08	/* open-drain enable */
#define AMD553X_GPIO_OUT_INVRT_EN 0x0c	/* invert output enable*/
#define	AMD553X_GPIO_PU_EN	0x18	/* pull-up enable */
#define	AMD553X_GPIO_PD_EN	0x1c	/* pull-down enable */
#define	AMD553X_GPIO_IN_EN	0x20	/* input enable */
#define AMD553X_GPIO_IN_INVRT_EN 0x24	/* invert input */
#define	AMD553X_GPIO_IN_FLTR_EN	0x28	/* filter enable */
#define	AMD553X_GPIO_IN_EVNTCNT_EN	0x2c	/* event counter enable */
#define	AMD553X_GPIO_READ_BACK	0x30	/* read back value */
#define	AMD553X_GPIO_EVNT_EN	0x38	/* event enable */
#define	AMD553X_GPIO_LOCK_EN	0x3c	/* lock enable */
#define	AMD553X_GPIO_IN_PE_EN	0x40	/* input positive edge enable */
#define	AMD553X_GPIO_IN_NE_EN	0x44	/* input negative edge enable */
#define	AMD553X_GPIO_IN_NE_STS	0x48	/* input negative edge status */
#define	AMD553X_GPIO_IN_PE_STS	0x4c	/* input positive edge status */

#endif /* _IC_GCSCPCIBREG_H_ */
