/*	$NetBSD: am2315reg.h,v 1.2 2017/12/29 02:20:47 christos Exp $	*/

/*
 * Copyright (c) 2017 Brad Spencer <brad@anduin.eldar.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _DEV_I2C_AM2315REG_H_
#define _DEV_I2C_AM2315REG_H_

#define AM2315_TYPICAL_ADDR	0x5c

#define AM2315_READ_REGISTERS   0x03
#define AM2315_WRITE_REGISTERS  0x10

#define AM2315_REGISTER_HIGH_RH 0x00
#define AM2315_REGISTER_LOW_RH 0x01
#define AM2315_REGISTER_HIGH_TEMP 0x02
#define AM2315_REGISTER_LOW_TEMP 0x03
#define AM2315_REGISTER_RETENTION_04 0x04
#define AM2315_REGISTER_RETENTION_05 0x05
#define AM2315_REGISTER_RETENTION_06 0x06
#define AM2315_REGISTER_RETENTION_07 0x07
#define AM2315_REGISTER_HIGH_MODEL 0x08
#define AM2315_REGISTER_LOW_MODEL 0x09
#define AM2315_REGISTER_VERSION 0x0a
#define AM2315_REGISTER_ID_PT_24_31 0x0b
#define AM2315_REGISTER_ID_PT_16_23 0x0c
#define AM2315_REGISTER_ID_PT_8_15 0x0d
#define AM2315_REGISTER_ID_PT_0_7 0x0e
#define AM2315_REGISTER_STATUS 0x0f
#define AM2315_REGISTER_HIGH_USER1 0x10
#define AM2315_REGISTER_LOW_USER1 0x11
#define AM2315_REGISTER_HIGH_USER2 0x12
#define AM2315_REGISTER_LOW_USER2 0x13
#define AM2315_REGISTER_RETENTION_14 0x14
#define AM2315_REGISTER_RETENTION_15 0x15
#define AM2315_REGISTER_RETENTION_16 0x16
#define AM2315_REGISTER_RETENTION_17 0x17
#define AM2315_REGISTER_RETENTION_18 0x18
#define AM2315_REGISTER_RETENTION_19 0x19
#define AM2315_REGISTER_RETENTION_1a 0x1a
#define AM2315_REGISTER_RETENTION_1b 0x1b
#define AM2315_REGISTER_RETENTION_1c 0x1c
#define AM2315_REGISTER_RETENTION_1d 0x1d
#define AM2315_REGISTER_RETENTION_1e 0x1e
#define AM2315_REGISTER_RETENTION_1f 0x1f

#define AM2315_TEMP_NEGATIVE 0x80

#endif
