/* $NetBSD: linux_sysent.c,v 1.88 2021/12/02 04:39:45 ryo Exp $ */

/*
 * System call switch table.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.74 2021/11/24 18:52:13 ryo Exp
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: linux_sysent.c,v 1.88 2021/12/02 04:39:45 ryo Exp $");

#include <sys/param.h>
#include <sys/poll.h>
#include <sys/systm.h>
#include <sys/signal.h>
#include <sys/mount.h>
#include <sys/syscallargs.h>
#include <sys/time.h>
#include <compat/sys/time.h>
#include <compat/linux/common/linux_types.h>
#include <compat/linux/common/linux_mmap.h>
#include <compat/linux/common/linux_signal.h>
#include <compat/linux/common/linux_siginfo.h>
#include <compat/linux/common/linux_machdep.h>
#include <compat/linux/linux_syscallargs.h>

#define	s(type)	sizeof(type)
#define	n(type)	(sizeof(type)/sizeof (register_t))
#define	ns(type)	.sy_narg = n(type), .sy_argsize = s(type)

struct sysent linux_sysent[] = {
	{
		.sy_call = (sy_call_t *)linux_sys_nosys
	},		/* 0 = nosys */
	{
		ns(struct linux_sys_exit_args),
		.sy_call = (sy_call_t *)linux_sys_exit
	},		/* 1 = exit */
	{
		.sy_call = (sy_call_t *)sys_fork
	},		/* 2 = fork */
	{
		ns(struct sys_read_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_read
	},		/* 3 = read */
	{
		ns(struct sys_write_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_write
	},		/* 4 = write */
	{
		ns(struct linux_sys_open_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_open
	},		/* 5 = open */
	{
		ns(struct sys_close_args),
		.sy_call = (sy_call_t *)sys_close
	},		/* 6 = close */
	{
		ns(struct linux_sys_waitpid_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_waitpid
	},		/* 7 = waitpid */
	{
		ns(struct linux_sys_creat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_creat
	},		/* 8 = creat */
	{
		ns(struct sys_link_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_link
	},		/* 9 = link */
	{
		ns(struct linux_sys_unlink_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_unlink
	},		/* 10 = unlink */
	{
		ns(struct sys_execve_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_execve
	},		/* 11 = execve */
	{
		ns(struct sys_chdir_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_chdir
	},		/* 12 = chdir */
	{
		ns(struct linux_sys_time_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_time
	},		/* 13 = time */
	{
		ns(struct linux_sys_mknod_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_mknod
	},		/* 14 = mknod */
	{
		ns(struct sys_chmod_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_chmod
	},		/* 15 = chmod */
	{
		ns(struct linux_sys_lchown16_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_lchown16
	},		/* 16 = lchown16 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 17 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 18 = filler */
	{
		ns(struct compat_43_sys_lseek_args),
		.sy_call = (sy_call_t *)compat_43_sys_lseek
	},		/* 19 = lseek */
	{
		.sy_call = (sy_call_t *)sys_getpid
	},		/* 20 = getpid */
	{
		.sy_call = linux_sys_nosys,
	},		/* 21 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 22 = filler */
	{
		ns(struct sys_setuid_args),
		.sy_call = (sy_call_t *)sys_setuid
	},		/* 23 = setuid */
	{
		.sy_call = (sy_call_t *)sys_getuid
	},		/* 24 = getuid */
	{
		ns(struct linux_sys_stime_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_stime
	},		/* 25 = stime */
	{
		ns(struct linux_sys_ptrace_args),
		.sy_call = (sy_call_t *)linux_sys_ptrace
	},		/* 26 = ptrace */
	{
		ns(struct linux_sys_alarm_args),
		.sy_call = (sy_call_t *)linux_sys_alarm
	},		/* 27 = alarm */
	{
		.sy_call = linux_sys_nosys,
	},		/* 28 = filler */
	{
		.sy_call = (sy_call_t *)linux_sys_pause
	},		/* 29 = pause */
	{
		ns(struct linux_sys_utime_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_utime
	},		/* 30 = utime */
	{
		.sy_call = linux_sys_nosys,
	},		/* 31 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 32 = filler */
	{
		ns(struct sys_access_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_access
	},		/* 33 = access */
	{
		ns(struct linux_sys_nice_args),
		.sy_call = (sy_call_t *)linux_sys_nice
	},		/* 34 = nice */
	{
		.sy_call = linux_sys_nosys,
	},		/* 35 = filler */
	{
		.sy_call = (sy_call_t *)sys_sync
	},		/* 36 = sync */
	{
		ns(struct linux_sys_kill_args),
		.sy_call = (sy_call_t *)linux_sys_kill
	},		/* 37 = kill */
	{
		ns(struct sys___posix_rename_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___posix_rename
	},		/* 38 = __posix_rename */
	{
		ns(struct sys_mkdir_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_mkdir
	},		/* 39 = mkdir */
	{
		ns(struct sys_rmdir_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_rmdir
	},		/* 40 = rmdir */
	{
		ns(struct sys_dup_args),
		.sy_call = (sy_call_t *)sys_dup
	},		/* 41 = dup */
	{
		ns(struct linux_sys_pipe_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_pipe
	},		/* 42 = pipe */
	{
		ns(struct linux_sys_times_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_times
	},		/* 43 = times */
	{
		.sy_call = linux_sys_nosys,
	},		/* 44 = filler */
	{
		ns(struct linux_sys_brk_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_brk
	},		/* 45 = brk */
	{
		ns(struct sys_setgid_args),
		.sy_call = (sy_call_t *)sys_setgid
	},		/* 46 = setgid */
	{
		.sy_call = (sy_call_t *)sys_getgid
	},		/* 47 = getgid */
	{
		ns(struct linux_sys_signal_args),
		.sy_call = (sy_call_t *)linux_sys_signal
	},		/* 48 = signal */
	{
		.sy_call = (sy_call_t *)sys_geteuid
	},		/* 49 = geteuid */
	{
		.sy_call = (sy_call_t *)sys_getegid
	},		/* 50 = getegid */
	{
		ns(struct sys_acct_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_acct
	},		/* 51 = acct */
	{
		.sy_call = linux_sys_nosys,
	},		/* 52 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 53 = filler */
	{
		ns(struct linux_sys_ioctl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_ioctl
	},		/* 54 = ioctl */
	{
		ns(struct linux_sys_fcntl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fcntl
	},		/* 55 = fcntl */
	{
		.sy_call = linux_sys_nosys,
	},		/* 56 = filler */
	{
		ns(struct sys_setpgid_args),
		.sy_call = (sy_call_t *)sys_setpgid
	},		/* 57 = setpgid */
	{
		.sy_call = linux_sys_nosys,
	},		/* 58 = filler */
	{
		ns(struct linux_sys_oldolduname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_oldolduname
	},		/* 59 = oldolduname */
	{
		ns(struct sys_umask_args),
		.sy_call = (sy_call_t *)sys_umask
	},		/* 60 = umask */
	{
		ns(struct sys_chroot_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_chroot
	},		/* 61 = chroot */
	{
		.sy_call = linux_sys_nosys,
	},		/* 62 = filler */
	{
		ns(struct sys_dup2_args),
		.sy_call = (sy_call_t *)sys_dup2
	},		/* 63 = dup2 */
	{
		.sy_call = (sy_call_t *)sys_getppid
	},		/* 64 = getppid */
	{
		.sy_call = (sy_call_t *)sys_getpgrp
	},		/* 65 = getpgrp */
	{
		.sy_call = (sy_call_t *)sys_setsid
	},		/* 66 = setsid */
	{
		ns(struct linux_sys_sigaction_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sigaction
	},		/* 67 = sigaction */
	{
		.sy_call = (sy_call_t *)linux_sys_siggetmask
	},		/* 68 = siggetmask */
	{
		ns(struct linux_sys_sigsetmask_args),
		.sy_call = (sy_call_t *)linux_sys_sigsetmask
	},		/* 69 = sigsetmask */
	{
		ns(struct linux_sys_setreuid16_args),
		.sy_call = (sy_call_t *)linux_sys_setreuid16
	},		/* 70 = setreuid16 */
	{
		ns(struct linux_sys_setregid16_args),
		.sy_call = (sy_call_t *)linux_sys_setregid16
	},		/* 71 = setregid16 */
	{
		ns(struct linux_sys_sigsuspend_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sigsuspend
	},		/* 72 = sigsuspend */
	{
		ns(struct linux_sys_sigpending_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sigpending
	},		/* 73 = sigpending */
	{
		ns(struct compat_43_sys_sethostname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_sethostname
	},		/* 74 = sethostname */
	{
		ns(struct linux_sys_setrlimit_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_setrlimit
	},		/* 75 = setrlimit */
	{
		ns(struct linux_sys_getrlimit_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getrlimit
	},		/* 76 = getrlimit */
	{
		ns(struct compat_50_sys_getrusage_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_getrusage
	},		/* 77 = getrusage */
	{
		ns(struct linux_sys_gettimeofday_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_gettimeofday
	},		/* 78 = gettimeofday */
	{
		ns(struct linux_sys_settimeofday_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_settimeofday
	},		/* 79 = settimeofday */
	{
		ns(struct linux_sys_getgroups16_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getgroups16
	},		/* 80 = getgroups16 */
	{
		ns(struct linux_sys_setgroups16_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_setgroups16
	},		/* 81 = setgroups16 */
	{
		ns(struct linux_sys_oldselect_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_oldselect
	},		/* 82 = oldselect */
	{
		ns(struct sys_symlink_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_symlink
	},		/* 83 = symlink */
	{
		ns(struct compat_43_sys_lstat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_lstat
	},		/* 84 = oolstat */
	{
		ns(struct sys_readlink_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_readlink
	},		/* 85 = readlink */
#ifdef EXEC_AOUT
	{
		ns(struct linux_sys_uselib_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_uselib
	},		/* 86 = uselib */
#else
	{
		.sy_call = linux_sys_nosys,
	},		/* 86 = filler */
#endif
	{
		ns(struct linux_sys_swapon_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_swapon
	},		/* 87 = swapon */
	{
		ns(struct linux_sys_reboot_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_reboot
	},		/* 88 = reboot */
	{
		ns(struct linux_sys_readdir_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_readdir
	},		/* 89 = readdir */
	{
		ns(struct linux_sys_old_mmap_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_old_mmap
	},		/* 90 = old_mmap */
	{
		ns(struct sys_munmap_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_munmap
	},		/* 91 = munmap */
	{
		ns(struct compat_43_sys_truncate_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_truncate
	},		/* 92 = truncate */
	{
		ns(struct compat_43_sys_ftruncate_args),
		.sy_call = (sy_call_t *)compat_43_sys_ftruncate
	},		/* 93 = ftruncate */
	{
		ns(struct sys_fchmod_args),
		.sy_call = (sy_call_t *)sys_fchmod
	},		/* 94 = fchmod */
	{
		ns(struct linux_sys_fchown16_args),
		.sy_call = (sy_call_t *)linux_sys_fchown16
	},		/* 95 = fchown16 */
	{
		ns(struct linux_sys_getpriority_args),
		.sy_call = (sy_call_t *)linux_sys_getpriority
	},		/* 96 = getpriority */
	{
		ns(struct sys_setpriority_args),
		.sy_call = (sy_call_t *)sys_setpriority
	},		/* 97 = setpriority */
	{
		ns(struct sys_profil_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_profil
	},		/* 98 = profil */
	{
		ns(struct linux_sys_statfs_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_statfs
	},		/* 99 = statfs */
	{
		ns(struct linux_sys_fstatfs_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fstatfs
	},		/* 100 = fstatfs */
	{
		.sy_call = linux_sys_nosys,
	},		/* 101 = filler */
	{
		ns(struct linux_sys_socketcall_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_socketcall
	},		/* 102 = socketcall */
	{
		.sy_call = linux_sys_nosys,
	},		/* 103 = filler */
	{
		ns(struct compat_50_sys_setitimer_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_setitimer
	},		/* 104 = setitimer */
	{
		ns(struct compat_50_sys_getitimer_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_getitimer
	},		/* 105 = getitimer */
	{
		ns(struct linux_sys_stat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_stat
	},		/* 106 = stat */
	{
		ns(struct linux_sys_lstat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_lstat
	},		/* 107 = lstat */
	{
		ns(struct linux_sys_fstat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fstat
	},		/* 108 = fstat */
	{
		ns(struct linux_sys_olduname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_olduname
	},		/* 109 = olduname */
	{
		.sy_call = linux_sys_nosys,
	},		/* 110 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 111 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 112 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 113 = filler */
	{
		ns(struct linux_sys_wait4_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_wait4
	},		/* 114 = wait4 */
	{
		ns(struct linux_sys_swapoff_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_swapoff
	},		/* 115 = swapoff */
	{
		ns(struct linux_sys_sysinfo_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sysinfo
	},		/* 116 = sysinfo */
	{
		ns(struct linux_sys_ipc_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_ipc
	},		/* 117 = ipc */
	{
		ns(struct sys_fsync_args),
		.sy_call = (sy_call_t *)sys_fsync
	},		/* 118 = fsync */
	{
		ns(struct linux_sys_sigreturn_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sigreturn
	},		/* 119 = sigreturn */
	{
		ns(struct linux_sys_clone_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_clone
	},		/* 120 = clone */
	{
		ns(struct linux_sys_setdomainname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_setdomainname
	},		/* 121 = setdomainname */
	{
		ns(struct linux_sys_uname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_uname
	},		/* 122 = uname */
	{
		.sy_call = linux_sys_nosys,
	},		/* 123 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 124 = filler */
	{
		ns(struct linux_sys_mprotect_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_mprotect
	},		/* 125 = mprotect */
	{
		ns(struct linux_sys_sigprocmask_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sigprocmask
	},		/* 126 = sigprocmask */
	{
		.sy_call = linux_sys_nosys,
	},		/* 127 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 128 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 129 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 130 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 131 = filler */
	{
		ns(struct sys_getpgid_args),
		.sy_call = (sy_call_t *)sys_getpgid
	},		/* 132 = getpgid */
	{
		ns(struct sys_fchdir_args),
		.sy_call = (sy_call_t *)sys_fchdir
	},		/* 133 = fchdir */
	{
		.sy_call = linux_sys_nosys,
	},		/* 134 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 135 = filler */
	{
		ns(struct linux_sys_personality_args),
		.sy_call = (sy_call_t *)linux_sys_personality
	},		/* 136 = personality */
	{
		.sy_call = linux_sys_nosys,
	},		/* 137 = filler */
	{
		ns(struct linux_sys_setfsuid_args),
		.sy_call = (sy_call_t *)linux_sys_setfsuid
	},		/* 138 = setfsuid */
	{
		ns(struct linux_sys_setfsgid_args),
		.sy_call = (sy_call_t *)linux_sys_setfsgid
	},		/* 139 = setfsgid */
	{
		ns(struct linux_sys_llseek_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_llseek
	},		/* 140 = llseek */
	{
		ns(struct linux_sys_getdents_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getdents
	},		/* 141 = getdents */
	{
		ns(struct linux_sys_select_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_select
	},		/* 142 = select */
	{
		ns(struct sys_flock_args),
		.sy_call = (sy_call_t *)sys_flock
	},		/* 143 = flock */
	{
		ns(struct sys___msync13_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___msync13
	},		/* 144 = __msync13 */
	{
		ns(struct sys_readv_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_readv
	},		/* 145 = readv */
	{
		ns(struct sys_writev_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_writev
	},		/* 146 = writev */
	{
		ns(struct sys_getsid_args),
		.sy_call = (sy_call_t *)sys_getsid
	},		/* 147 = getsid */
	{
		ns(struct linux_sys_fdatasync_args),
		.sy_call = (sy_call_t *)linux_sys_fdatasync
	},		/* 148 = fdatasync */
	{
		ns(struct linux_sys___sysctl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys___sysctl
	},		/* 149 = __sysctl */
	{
		ns(struct sys_mlock_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_mlock
	},		/* 150 = mlock */
	{
		ns(struct sys_munlock_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_munlock
	},		/* 151 = munlock */
	{
		ns(struct sys_mlockall_args),
		.sy_call = (sy_call_t *)sys_mlockall
	},		/* 152 = mlockall */
	{
		.sy_call = (sy_call_t *)sys_munlockall
	},		/* 153 = munlockall */
	{
		ns(struct linux_sys_sched_setparam_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sched_setparam
	},		/* 154 = sched_setparam */
	{
		ns(struct linux_sys_sched_getparam_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sched_getparam
	},		/* 155 = sched_getparam */
	{
		ns(struct linux_sys_sched_setscheduler_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sched_setscheduler
	},		/* 156 = sched_setscheduler */
	{
		ns(struct linux_sys_sched_getscheduler_args),
		.sy_call = (sy_call_t *)linux_sys_sched_getscheduler
	},		/* 157 = sched_getscheduler */
	{
		.sy_call = (sy_call_t *)linux_sys_sched_yield
	},		/* 158 = sched_yield */
	{
		ns(struct linux_sys_sched_get_priority_max_args),
		.sy_call = (sy_call_t *)linux_sys_sched_get_priority_max
	},		/* 159 = sched_get_priority_max */
	{
		ns(struct linux_sys_sched_get_priority_min_args),
		.sy_call = (sy_call_t *)linux_sys_sched_get_priority_min
	},		/* 160 = sched_get_priority_min */
	{
		.sy_call = linux_sys_nosys,
	},		/* 161 = filler */
	{
		ns(struct linux_sys_nanosleep_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_nanosleep
	},		/* 162 = nanosleep */
	{
		ns(struct linux_sys_mremap_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_mremap
	},		/* 163 = mremap */
	{
		ns(struct linux_sys_setresuid16_args),
		.sy_call = (sy_call_t *)linux_sys_setresuid16
	},		/* 164 = setresuid16 */
	{
		ns(struct linux_sys_getresuid16_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getresuid16
	},		/* 165 = getresuid16 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 166 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 167 = filler */
	{
		ns(struct sys_poll_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_poll
	},		/* 168 = poll */
	{
		.sy_call = linux_sys_nosys,
	},		/* 169 = filler */
	{
		ns(struct linux_sys_setresgid16_args),
		.sy_call = (sy_call_t *)linux_sys_setresgid16
	},		/* 170 = setresgid16 */
	{
		ns(struct linux_sys_getresgid16_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getresgid16
	},		/* 171 = getresgid16 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 172 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 173 = filler */
	{
		ns(struct linux_sys_rt_sigaction_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_sigaction
	},		/* 174 = rt_sigaction */
	{
		ns(struct linux_sys_rt_sigprocmask_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_sigprocmask
	},		/* 175 = rt_sigprocmask */
	{
		ns(struct linux_sys_rt_sigpending_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_sigpending
	},		/* 176 = rt_sigpending */
	{
		ns(struct linux_sys_rt_sigtimedwait_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_sigtimedwait
	},		/* 177 = rt_sigtimedwait */
	{
		ns(struct linux_sys_rt_queueinfo_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_queueinfo
	},		/* 178 = rt_queueinfo */
	{
		ns(struct linux_sys_rt_sigsuspend_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_rt_sigsuspend
	},		/* 179 = rt_sigsuspend */
	{
		ns(struct linux_sys_pread_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG3_64 | SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_pread
	},		/* 180 = pread */
	{
		ns(struct linux_sys_pwrite_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG3_64 | SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_pwrite
	},		/* 181 = pwrite */
	{
		ns(struct linux_sys_chown16_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_chown16
	},		/* 182 = chown16 */
	{
		ns(struct sys___getcwd_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___getcwd
	},		/* 183 = __getcwd */
	{
		.sy_call = linux_sys_nosys,
	},		/* 184 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 185 = filler */
	{
		ns(struct linux_sys_sigaltstack_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sigaltstack
	},		/* 186 = sigaltstack */
	{
		.sy_call = linux_sys_nosys,
	},		/* 187 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 188 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 189 = filler */
	{
		.sy_call = (sy_call_t *)sys___vfork14
	},		/* 190 = vfork */
	{
		ns(struct linux_sys_ugetrlimit_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_ugetrlimit
	},		/* 191 = ugetrlimit */
#define linux_sys_mmap2_args linux_sys_mmap_args
	{
		ns(struct linux_sys_mmap2_args),
		.sy_call = (sy_call_t *)linux_sys_mmap2
	},		/* 192 = mmap2 */
	{
		ns(struct linux_sys_truncate64_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG1_64 | SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_truncate64
	},		/* 193 = truncate64 */
	{
		ns(struct linux_sys_ftruncate64_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG1_64,
		.sy_call = (sy_call_t *)linux_sys_ftruncate64
	},		/* 194 = ftruncate64 */
	{
		ns(struct linux_sys_stat64_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_stat64
	},		/* 195 = stat64 */
	{
		ns(struct linux_sys_lstat64_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_lstat64
	},		/* 196 = lstat64 */
	{
		ns(struct linux_sys_fstat64_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fstat64
	},		/* 197 = fstat64 */
	{
		ns(struct sys___posix_lchown_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___posix_lchown
	},		/* 198 = __posix_lchown */
	{
		.sy_call = (sy_call_t *)sys_getuid
	},		/* 199 = getuid32 */
	{
		.sy_call = (sy_call_t *)sys_getgid
	},		/* 200 = getgid32 */
	{
		.sy_call = (sy_call_t *)sys_geteuid
	},		/* 201 = geteuid32 */
	{
		.sy_call = (sy_call_t *)sys_getegid
	},		/* 202 = getegid32 */
	{
		ns(struct sys_setreuid_args),
		.sy_call = (sy_call_t *)sys_setreuid
	},		/* 203 = setreuid32 */
	{
		ns(struct sys_setregid_args),
		.sy_call = (sy_call_t *)sys_setregid
	},		/* 204 = setregid32 */
	{
		ns(struct sys_getgroups_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_getgroups
	},		/* 205 = getgroups32 */
	{
		ns(struct sys_setgroups_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_setgroups
	},		/* 206 = setgroups32 */
	{
		ns(struct sys___posix_fchown_args),
		.sy_call = (sy_call_t *)sys___posix_fchown
	},		/* 207 = fchown32 */
	{
		ns(struct linux_sys_setresuid_args),
		.sy_call = (sy_call_t *)linux_sys_setresuid
	},		/* 208 = setresuid32 */
	{
		ns(struct linux_sys_getresuid_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getresuid
	},		/* 209 = getresuid32 */
	{
		ns(struct linux_sys_setresgid_args),
		.sy_call = (sy_call_t *)linux_sys_setresgid
	},		/* 210 = setresgid32 */
	{
		ns(struct linux_sys_getresgid_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getresgid
	},		/* 211 = getresgid32 */
	{
		ns(struct sys___posix_chown_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___posix_chown
	},		/* 212 = chown32 */
	{
		ns(struct sys_setuid_args),
		.sy_call = (sy_call_t *)sys_setuid
	},		/* 213 = setuid32 */
	{
		ns(struct sys_setgid_args),
		.sy_call = (sy_call_t *)sys_setgid
	},		/* 214 = setgid32 */
	{
		ns(struct linux_sys_setfsuid_args),
		.sy_call = (sy_call_t *)linux_sys_setfsuid
	},		/* 215 = setfsuid32 */
	{
		ns(struct linux_sys_setfsgid_args),
		.sy_call = (sy_call_t *)linux_sys_setfsgid
	},		/* 216 = setfsgid32 */
	{
		ns(struct linux_sys_getdents64_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getdents64
	},		/* 217 = getdents64 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 218 = filler */
	{
		ns(struct sys_mincore_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_mincore
	},		/* 219 = mincore */
	{
		ns(struct sys_madvise_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_madvise
	},		/* 220 = madvise */
	{
		ns(struct linux_sys_fcntl64_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fcntl64
	},		/* 221 = fcntl64 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 222 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 223 = filler */
	{
		.sy_call = (sy_call_t *)linux_sys_gettid
	},		/* 224 = gettid */
	{
		.sy_call = linux_sys_nosys,
	},		/* 225 = filler */
	{
		ns(struct linux_sys_setxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_setxattr
	},		/* 226 = setxattr */
	{
		ns(struct linux_sys_lsetxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_lsetxattr
	},		/* 227 = lsetxattr */
	{
		ns(struct linux_sys_fsetxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fsetxattr
	},		/* 228 = fsetxattr */
	{
		ns(struct linux_sys_getxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_getxattr
	},		/* 229 = getxattr */
	{
		ns(struct linux_sys_lgetxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_lgetxattr
	},		/* 230 = lgetxattr */
	{
		ns(struct linux_sys_fgetxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fgetxattr
	},		/* 231 = fgetxattr */
	{
		ns(struct linux_sys_listxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_listxattr
	},		/* 232 = listxattr */
	{
		ns(struct linux_sys_llistxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_llistxattr
	},		/* 233 = llistxattr */
	{
		ns(struct linux_sys_flistxattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_flistxattr
	},		/* 234 = flistxattr */
	{
		ns(struct linux_sys_removexattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_removexattr
	},		/* 235 = removexattr */
	{
		ns(struct linux_sys_lremovexattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_lremovexattr
	},		/* 236 = lremovexattr */
	{
		ns(struct linux_sys_fremovexattr_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fremovexattr
	},		/* 237 = fremovexattr */
	{
		ns(struct linux_sys_tkill_args),
		.sy_call = (sy_call_t *)linux_sys_tkill
	},		/* 238 = tkill */
	{
		.sy_call = linux_sys_nosys,
	},		/* 239 = filler */
	{
		ns(struct linux_sys_futex_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_futex
	},		/* 240 = futex */
	{
		ns(struct linux_sys_sched_setaffinity_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sched_setaffinity
	},		/* 241 = sched_setaffinity */
	{
		ns(struct linux_sys_sched_getaffinity_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sched_getaffinity
	},		/* 242 = sched_getaffinity */
	{
		.sy_call = linux_sys_nosys,
	},		/* 243 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 244 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 245 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 246 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 247 = filler */
	{
		ns(struct linux_sys_exit_group_args),
		.sy_call = (sy_call_t *)linux_sys_exit_group
	},		/* 248 = exit_group */
	{
		.sy_call = linux_sys_nosys,
	},		/* 249 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 250 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 251 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 252 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 253 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 254 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 255 = filler */
	{
		ns(struct linux_sys_set_tid_address_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_set_tid_address
	},		/* 256 = set_tid_address */
	{
		ns(struct linux_sys_timer_create_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_timer_create
	},		/* 257 = timer_create */
	{
		ns(struct linux_sys_timer_settime_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_timer_settime
	},		/* 258 = timer_settime */
	{
		ns(struct linux_sys_timer_gettime_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_timer_gettime
	},		/* 259 = timer_gettime */
	{
		ns(struct sys_timer_getoverrun_args),
		.sy_call = (sy_call_t *)sys_timer_getoverrun
	},		/* 260 = timer_getoverrun */
	{
		ns(struct sys_timer_delete_args),
		.sy_call = (sy_call_t *)sys_timer_delete
	},		/* 261 = timer_delete */
	{
		ns(struct linux_sys_clock_settime_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_clock_settime
	},		/* 262 = clock_settime */
	{
		ns(struct linux_sys_clock_gettime_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_clock_gettime
	},		/* 263 = clock_gettime */
	{
		ns(struct linux_sys_clock_getres_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_clock_getres
	},		/* 264 = clock_getres */
	{
		ns(struct linux_sys_clock_nanosleep_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_clock_nanosleep
	},		/* 265 = clock_nanosleep */
	{
		ns(struct linux_sys_statfs64_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_statfs64
	},		/* 266 = statfs64 */
	{
		ns(struct linux_sys_fstatfs64_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fstatfs64
	},		/* 267 = fstatfs64 */
	{
		ns(struct linux_sys_tgkill_args),
		.sy_call = (sy_call_t *)linux_sys_tgkill
	},		/* 268 = tgkill */
	{
		ns(struct compat_50_sys_utimes_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_utimes
	},		/* 269 = utimes */
	{
		ns(struct linux_sys_fadvise64_64_args),
		.sy_flags = SYCALL_NARGS64_VAL(2) | SYCALL_ARG2_64 | SYCALL_ARG1_64,
		.sy_call = (sy_call_t *)linux_sys_fadvise64_64
	},		/* 270 = fadvise64_64 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 271 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 272 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 273 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 274 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 275 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 276 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 277 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 278 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 279 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 280 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 281 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 282 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 283 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 284 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 285 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 286 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 287 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 288 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 289 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 290 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 291 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 292 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 293 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 294 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 295 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 296 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 297 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 298 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 299 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 300 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 301 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 302 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 303 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 304 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 305 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 306 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 307 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 308 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 309 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 310 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 311 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 312 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 313 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 314 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 315 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 316 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 317 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 318 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 319 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 320 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 321 = filler */
	{
		ns(struct linux_sys_openat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_openat
	},		/* 322 = openat */
	{
		ns(struct sys_mkdirat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_mkdirat
	},		/* 323 = mkdirat */
	{
		ns(struct linux_sys_mknodat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_mknodat
	},		/* 324 = mknodat */
	{
		ns(struct linux_sys_fchownat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fchownat
	},		/* 325 = fchownat */
	{
		.sy_call = linux_sys_nosys,
	},		/* 326 = filler */
	{
		ns(struct linux_sys_fstatat64_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fstatat64
	},		/* 327 = fstatat64 */
	{
		ns(struct linux_sys_unlinkat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_unlinkat
	},		/* 328 = unlinkat */
	{
		ns(struct sys_renameat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_renameat
	},		/* 329 = renameat */
	{
		ns(struct linux_sys_linkat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_linkat
	},		/* 330 = linkat */
	{
		ns(struct sys_symlinkat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_symlinkat
	},		/* 331 = symlinkat */
	{
		ns(struct sys_readlinkat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_readlinkat
	},		/* 332 = readlinkat */
	{
		ns(struct linux_sys_fchmodat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_fchmodat
	},		/* 333 = fchmodat */
	{
		ns(struct linux_sys_faccessat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_faccessat
	},		/* 334 = faccessat */
	{
		ns(struct linux_sys_pselect6_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_pselect6
	},		/* 335 = pselect6 */
	{
		ns(struct linux_sys_ppoll_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_ppoll
	},		/* 336 = ppoll */
	{
		.sy_call = linux_sys_nosys,
	},		/* 337 = filler */
	{
		ns(struct sys___futex_set_robust_list_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___futex_set_robust_list
	},		/* 338 = __futex_set_robust_list */
	{
		ns(struct sys___futex_get_robust_list_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___futex_get_robust_list
	},		/* 339 = __futex_get_robust_list */
	{
		.sy_call = linux_sys_nosys,
	},		/* 340 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 341 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 342 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 343 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 344 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 345 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 346 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 347 = filler */
	{
		ns(struct linux_sys_utimensat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_utimensat
	},		/* 348 = utimensat */
	{
		.sy_call = linux_sys_nosys,
	},		/* 349 = filler */
	{
		ns(struct linux_sys_timerfd_create_args),
		.sy_call = (sy_call_t *)linux_sys_timerfd_create
	},		/* 350 = timerfd_create */
	{
		ns(struct linux_sys_eventfd_args),
		.sy_call = (sy_call_t *)linux_sys_eventfd
	},		/* 351 = eventfd */
	{
		ns(struct linux_sys_fallocate_args),
		.sy_flags = SYCALL_NARGS64_VAL(2) | SYCALL_ARG3_64 | SYCALL_ARG2_64,
		.sy_call = (sy_call_t *)linux_sys_fallocate
	},		/* 352 = fallocate */
	{
		ns(struct linux_sys_timerfd_settime_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_timerfd_settime
	},		/* 353 = timerfd_settime */
	{
		ns(struct linux_sys_timerfd_gettime_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_timerfd_gettime
	},		/* 354 = timerfd_gettime */
	{
		.sy_call = linux_sys_nosys,
	},		/* 355 = filler */
	{
		ns(struct linux_sys_eventfd2_args),
		.sy_call = (sy_call_t *)linux_sys_eventfd2
	},		/* 356 = eventfd2 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 357 = filler */
	{
		ns(struct linux_sys_dup3_args),
		.sy_call = (sy_call_t *)linux_sys_dup3
	},		/* 358 = dup3 */
	{
		ns(struct linux_sys_pipe2_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_pipe2
	},		/* 359 = pipe2 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 360 = filler */
	{
		ns(struct linux_sys_preadv_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_preadv
	},		/* 361 = preadv */
	{
		ns(struct linux_sys_pwritev_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_pwritev
	},		/* 362 = pwritev */
	{
		.sy_call = linux_sys_nosys,
	},		/* 363 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 364 = filler */
	{
		ns(struct linux_sys_recvmmsg_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_recvmmsg
	},		/* 365 = recvmmsg */
	{
		ns(struct linux_sys_accept4_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_accept4
	},		/* 366 = accept4 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 367 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 368 = filler */
	{
		ns(struct linux_sys_prlimit64_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_prlimit64
	},		/* 369 = prlimit64 */
	{
		.sy_call = linux_sys_nosys,
	},		/* 370 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 371 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 372 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 373 = filler */
	{
		ns(struct linux_sys_sendmmsg_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_sendmmsg
	},		/* 374 = sendmmsg */
	{
		.sy_call = linux_sys_nosys,
	},		/* 375 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 376 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 377 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 378 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 379 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 380 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 381 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 382 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 383 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 384 = filler */
	{
		.sy_call = (sy_call_t *)linux_sys_breakpoint
	},		/* 385 = breakpoint */
	{
		ns(struct linux_sys_cacheflush_args),
		.sy_call = (sy_call_t *)linux_sys_cacheflush
	},		/* 386 = cacheflush */
	{
		.sy_call = linux_sys_nosys,
	},		/* 387 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 388 = filler */
	{
		ns(struct linux_sys_set_tls_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)linux_sys_set_tls
	},		/* 389 = set_tls */
	{
		.sy_call = linux_sys_nosys,
	},		/* 390 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 391 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 392 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 393 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 394 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 395 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 396 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 397 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 398 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 399 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 400 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 401 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 402 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 403 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 404 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 405 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 406 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 407 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 408 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 409 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 410 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 411 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 412 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 413 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 414 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 415 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 416 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 417 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 418 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 419 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 420 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 421 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 422 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 423 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 424 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 425 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 426 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 427 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 428 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 429 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 430 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 431 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 432 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 433 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 434 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 435 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 436 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 437 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 438 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 439 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 440 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 441 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 442 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 443 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 444 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 445 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 446 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 447 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 448 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 449 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 450 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 451 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 452 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 453 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 454 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 455 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 456 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 457 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 458 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 459 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 460 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 461 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 462 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 463 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 464 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 465 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 466 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 467 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 468 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 469 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 470 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 471 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 472 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 473 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 474 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 475 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 476 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 477 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 478 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 479 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 480 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 481 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 482 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 483 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 484 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 485 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 486 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 487 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 488 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 489 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 490 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 491 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 492 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 493 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 494 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 495 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 496 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 497 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 498 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 499 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 500 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 501 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 502 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 503 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 504 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 505 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 506 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 507 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 508 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 509 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 510 = filler */
	{
		.sy_call = linux_sys_nosys,
	},		/* 511 = filler */
};

const uint32_t linux_sysent_nomodbits[] = {
	0x00000000,	/* syscalls   0- 31 */
	0x00000000,	/* syscalls  32- 63 */
	0x00000000,	/* syscalls  64- 95 */
	0x00000000,	/* syscalls  96-127 */
	0x00000000,	/* syscalls 128-159 */
	0x00000000,	/* syscalls 160-191 */
	0x00000000,	/* syscalls 192-223 */
	0x00000000,	/* syscalls 224-255 */
	0x00000000,	/* syscalls 256-287 */
	0x00000000,	/* syscalls 288-319 */
	0x00000000,	/* syscalls 320-351 */
	0x00000000,	/* syscalls 352-383 */
	0x00000000,	/* syscalls 384-415 */
	0x00000000,	/* syscalls 416-447 */
	0x00000000,	/* syscalls 448-479 */
	0x00000000,	/* syscalls 480-511 */
};
