#!/bin/sh

# Fatal trap 12: page fault while in kernel mode
# cpuid = 0; apic id = 00
# fault virtual address	= 0x18
# fault code		= supervisor read data, page not present
# instruction pointer	= 0x20:0xffffffff80ffe995
# stack pointer	        = 0x28:0xfffffe0015e1d6f0
# frame pointer	        = 0x28:0xfffffe0015e1d720
# code segment		= base 0x0, limit 0xfffff, type 0x1b
# 			= DPL 0, pres 1, long 1, def32 0, gran 1
# processor eflags	= interrupt enabled, resume, IOPL = 0
# current process		= 744 (syz-executor7538254)
# trap number		= 12
# panic: page fault
# cpuid = 0
# time = 1575776142
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x47/frame 0xfffffe0015e1d2f0
# vpanic() at vpanic+0x1c7/frame 0xfffffe0015e1d360
# panic() at panic+0x43/frame 0xfffffe0015e1d3c0
# trap_fatal() at trap_fatal+0x4cc/frame 0xfffffe0015e1d440
# trap_pfault() at trap_pfault+0xdc/frame 0xfffffe0015e1d4e0
# trap() at trap+0x441/frame 0xfffffe0015e1d620
# calltrap() at calltrap+0x8/frame 0xfffffe0015e1d620
# --- trap 0xc, rip = 0xffffffff80ffe995, rsp = 0xfffffe0015e1d6f0, rbp = 0xfffffe0015e1d720 ---
# __mtx_assert() at __mtx_assert+0x85/frame 0xfffffe0015e1d720
# uipc_send() at uipc_send+0xeec/frame 0xfffffe0015e1d810
# sosend_generic() at sosend_generic+0x707/frame 0xfffffe0015e1d8d0
# sosend() at sosend+0xc6/frame 0xfffffe0015e1d940
# kern_sendit() at kern_sendit+0x32d/frame 0xfffffe0015e1d9f0
# sendit() at sendit+0x226/frame 0xfffffe0015e1da50
# sys_sendmsg() at sys_sendmsg+0x8b/frame 0xfffffe0015e1dab0
# amd64_syscall() at amd64_syscall+0x46d/frame 0xfffffe0015e1dbf0
# fast_syscall_common() at fast_syscall_common+0x101/frame 0xfffffe0015e1dbf0
# --- syscall (0, FreeBSD ELF64, nosys), rip = 0x41c3ea, rsp = 0x7fffffffeb98, rbp = 0x7fffffffebf0 ---

# Reproduced on r359818
# Fixed by r359893

[ `uname -p` = "i386" ] && exit 0

. ../default.cfg
cat > /tmp/syzkaller9.c <<EOF
// http://syzkaller.backtrace.io:8080/report?id=03a08d05681c3e7f38ab6ab3f0d025105c3dcea3
// autogenerated by syzkaller (https://github.com/google/syzkaller)

#define _GNU_SOURCE

#include <pwd.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <unistd.h>

uint64_t r[2] = {0xffffffffffffffff, 0xffffffffffffffff};

int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 3ul, 0x1012ul, -1, 0ul);
  intptr_t res = 0;
  res = syscall(SYS_socket, 1ul, 5ul, 0ul);
  if (res != -1)
    r[0] = res;
  memcpy((void*)0x20000000, "\x1d\x01\x2e\x2f\x66\x69\x6c\x65\x30\x00", 10);
  syscall(SYS_bind, r[0], 0x20000000ul, 0xaul);
  syscall(SYS_listen, r[0], 0);
  res = syscall(SYS_socket, 1ul, 5ul, 0ul);
  if (res != -1)
    r[1] = res;
  *(uint64_t*)0x20002640 = 0x20000000;
  *(uint8_t*)0x20000000 = 0xa;
  *(uint8_t*)0x20000001 = 1;
  memcpy((void*)0x20000002, "./file0\000", 8);
  *(uint32_t*)0x20002648 = 0xa;
  *(uint64_t*)0x20002650 = 0;
  *(uint64_t*)0x20002658 = 0;
  *(uint64_t*)0x20002660 = 0x20002580;
  memcpy((void*)0x20002580,
         "\x10\x00\x00\x00\xff\xff\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00",
         16);
  *(uint64_t*)0x20002668 = 0x10;
  *(uint32_t*)0x20002670 = 0;
  syscall(SYS_sendmsg, r[1], 0x20002640ul, 0ul);
  return 0;
}
EOF
mycc -o /tmp/syzkaller9 -Wall -Wextra -O2 /tmp/syzkaller9.c -lpthread ||
    exit 1

(cd /tmp; ./syzkaller9) &
sleep 60
pkill -9 syzkaller9
wait

rm -f /tmp/syzkaller9 /tmp/syzkaller9.c /tmp/syzkaller9.core /tmp/file0
exit 0
