#!/bin/sh

# panic: sleepq_add: td 0xfffffe00dffd8800 to sleep on wchan 0xffffffff81d9bee8 with sleeping prohibited
# cpuid = 7
# time = 1599685416
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe00e656d5e0
# vpanic() at vpanic+0x182/frame 0xfffffe00e656d630
# panic() at panic+0x43/frame 0xfffffe00e656d690
# sleepq_add() at sleepq_add+0x359/frame 0xfffffe00e656d6e0
# _sx_xlock_hard() at _sx_xlock_hard+0x405/frame 0xfffffe00e656d780
# _sx_xlock() at _sx_xlock+0xba/frame 0xfffffe00e656d7c0
# inp_setmoptions() at inp_setmoptions+0xd5c/frame 0xfffffe00e656d970
# ip_ctloutput() at ip_ctloutput+0x103/frame 0xfffffe00e656d9c0
# rip_ctloutput() at rip_ctloutput+0x158/frame 0xfffffe00e656d9f0
# sosetopt() at sosetopt+0xed/frame 0xfffffe00e656da50
# kern_setsockopt() at kern_setsockopt+0xa8/frame 0xfffffe00e656dab0
# sys_setsockopt() at sys_setsockopt+0x24/frame 0xfffffe00e656dad0
# amd64_syscall() at amd64_syscall+0x159/frame 0xfffffe00e656dbf0
# fast_syscall_common() at fast_syscall_common+0xf8/frame 0xfffffe00e656dbf0
# --- syscall (0, FreeBSD ELF64, nosys), rip = 0x80042819a, rsp = 0x7fffffffe958, rbp = 0x7fffffffe970 ---
# KDB: enter: panic
# [ thread pid 27447 tid 100183 ]
# Stopped at      kdb_enter+0x37: movq    $0,0x10b7246(%rip)
# db> x/s version
# version: FreeBSD 13.0-CURRENT #0 r365508: Wed Sep  9 21:36:20 CEST 2020
# pho@mercat1.netperf.freebsd.org:/usr/src/sys/amd64/compile/PHO
# db> 

# Fixed by r366795.

[ `uname -p` != "amd64" ] && exit 0

. ../default.cfg
cat > /tmp/syzkaller24.c <<EOF
// https://syzkaller.appspot.com/bug?id=0f4996e03d94b16bb9e945ede3c9de343748e6ed
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+34f419947239a738ed34@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <sys/types.h>

#include <pwd.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter __unused = 0;
  for (;; iter++) {
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      sleep_ms(1);
      if (current_time_ms() - start < 5 * 1000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
  }
}

uint64_t r[1] = {0xffffffffffffffff};

void execute_one(void)
{
  intptr_t res = 0;
  res = syscall(SYS_socket, 2ul, 3ul, 1);
  if (res != -1)
    r[0] = res;
  *(uint32_t*)0x20000180 = htobe32(0xe0000002);
  *(uint32_t*)0x20000184 = htobe32(0x7f000001);
  *(uint32_t*)0x20000188 = htobe32(0x7f000001);
  syscall(SYS_setsockopt, r[0], 0, 0x46, 0x20000180ul, 0x4414ae3732a778ful);
}
int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  loop();
  return 0;
}
EOF
mycc -o /tmp/syzkaller24 -Wall -Wextra -O0 /tmp/syzkaller24.c ||
    exit 1

(cd /tmp; timeout 3m ./syzkaller24)

rm -rf /tmp/syzkaller24 /tmp/syzkaller24.c /tmp/syzkaller.*
exit 0
