/*-
 * SPDX-License-Identifier: BSD-2-Clause
 *
 * Copyright (c) 2012 Adrian Chadd <adrian@FreeBSD.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef	__AR93XX_REG_H__
#define	__AR93XX_REG_H__

#define	REV_ID_MAJOR_AR9330		0x0110
#define	REV_ID_MAJOR_AR9331		0x1110

#define	AR933X_REV_ID_REVISION_MASK	0x3

#define	AR933X_GPIO_COUNT		30

#define	AR933X_UART_BASE	(AR71XX_APB_BASE + 0x00020000)
#define	AR933X_UART_SIZE	0x14

#define	AR933X_GMAC_BASE	(AR71XX_APB_BASE + 0x00070000)
#define	AR933X_GMAC_SIZE	0x04

#define	AR933X_GMAC_REG_ETH_CFG		(AR933X_GMAC_BASE + 0x00)

#define	AR933X_ETH_CFG_RGMII_GE0	(1 << 0)
#define	AR933X_ETH_CFG_MII_GE0		(1 << 1)
#define	AR933X_ETH_CFG_GMII_GE0		(1 << 2)
#define	AR933X_ETH_CFG_MII_GE0_MASTER	(1 << 3)
#define	AR933X_ETH_CFG_MII_GE0_SLAVE	(1 << 4)
#define	AR933X_ETH_CFG_MII_GE0_ERR_EN	(1 << 5)
#define	AR933X_ETH_CFG_SW_PHY_SWAP	(1 << 7)
#define	AR933X_ETH_CFG_SW_PHY_ADDR_SWAP	(1 << 8)
#define	AR933X_ETH_CFG_RMII_GE0		(1 << 9)
#define	AR933X_ETH_CFG_RMII_GE0_SPD_10		0
#define	AR933X_ETH_CFG_RMII_GE0_SPD_100		(1 << 10)

#define	AR933X_WMAC_BASE	(AR71XX_APB_BASE + 0x00100000)
#define	AR933X_WMAC_SIZE	0x20000
#define	AR933X_EHCI_BASE	0x1b000000
#define	AR933X_EHCI_SIZE	0x1000

#define	AR933X_DDR_REG_FLUSH_GE0	(AR71XX_APB_BASE + 0x7c)
#define	AR933X_DDR_REG_FLUSH_GE1	(AR71XX_APB_BASE + 0x80)
#define	AR933X_DDR_REG_FLUSH_USB	(AR71XX_APB_BASE + 0x84)
#define	AR933X_DDR_REG_FLUSH_WMAC	(AR71XX_APB_BASE + 0x88)

#define	AR933X_PLL_CPU_CONFIG_REG	(AR71XX_PLL_CPU_BASE + 0x00)
#define	AR933X_PLL_CLOCK_CTRL_REG	(AR71XX_PLL_CPU_BASE + 0x08)

#define	AR933X_PLL_CPU_CONFIG_NINT_SHIFT	10
#define	AR933X_PLL_CPU_CONFIG_NINT_MASK		0x3f
#define	AR933X_PLL_CPU_CONFIG_REFDIV_SHIFT	16
#define	AR933X_PLL_CPU_CONFIG_REFDIV_MASK	0x1f
#define	AR933X_PLL_CPU_CONFIG_OUTDIV_SHIFT	23
#define	AR933X_PLL_CPU_CONFIG_OUTDIV_MASK	0x7

#define	AR933X_PLL_CLOCK_CTRL_BYPASS		(1 << 2)
#define	AR933X_PLL_CLOCK_CTRL_CPU_DIV_SHIFT	5
#define	AR933X_PLL_CLOCK_CTRL_CPU_DIV_MASK	0x3
#define	AR933X_PLL_CLOCK_CTRL_DDR_DIV_SHIFT	10
#define	AR933X_PLL_CLOCK_CTRL_DDR_DIV_MASK	0x3
#define	AR933X_PLL_CLOCK_CTRL_AHB_DIV_SHIFT	15
#define	AR933X_PLL_CLOCK_CTRL_AHB_DIV_MASK	0x7

#define	AR933X_RESET_REG_RESET_MODULE		(AR71XX_RST_BLOCK_BASE + 0x1c)
#define	AR933X_RESET_REG_BOOTSTRAP		(AR71XX_RST_BLOCK_BASE + 0xac)
#define	AR933X_RESET_WMAC			(1 << 11)
#define	AR933X_RESET_USB_HOST			(1 << 5)
#define	AR933X_RESET_USB_PHY			(1 << 4)
#define	AR933X_RESET_USBSUS_OVERRIDE		(1 << 3)

#define	AR933X_BOOTSTRAP_REF_CLK_40		(1 << 0)

#define	AR933X_PLL_VAL_1000			0x00110000
#define	AR933X_PLL_VAL_100			0x00001099
#define	AR933X_PLL_VAL_10			0x00991099

#endif	/* __AR93XX_REG_H__ */
