#!/usr/bin/env python3
#
# SPDX-License-Identifier: BSD-2-Clause-FreeBSD
#
# Copyright (c) 2019 Synacktiv
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.

import random
import logging
logging.getLogger("scapy").setLevel(logging.CRITICAL)
import scapy.all as sp
import sys

UDP_PROTO  = 17
AH_PROTO   = 51
FRAG_PROTO = 44

def main():
    intf = sys.argv[1]
    ipv6_src = sys.argv[2]
    ipv6_dst = sys.argv[3]

    ipv6_main = sp.IPv6(dst=ipv6_dst, src=ipv6_src)

    padding = 8
    fid = random.randint(0,100000)
    frag_0 = sp.IPv6ExtHdrFragment(id=fid, nh=UDP_PROTO, m=1, offset=0)
    foff_1 = (int)(padding/8)
    frag_1 = sp.IPv6ExtHdrFragment(id=fid, nh=UDP_PROTO, m=0, offset=foff_1)
    
    pkt1_opts = sp.AH(nh=AH_PROTO, payloadlen=200) \
            / sp.Raw('XXXX' * 199) \
            / sp.AH(nh=FRAG_PROTO, payloadlen=1) \
            / frag_1

    pkt0 = sp.Ether() / ipv6_main / frag_0 / sp.Raw('A' * padding)
    pkt1 = sp.Ether() / ipv6_main / pkt1_opts / sp.Raw('B' * padding)

    sp.sendp(pkt0, iface=intf, verbose=False)
    sp.sendp(pkt1, iface=intf, verbose=False)

if __name__ == '__main__':
	main()
