/*-
 * SPDX-License-Identifier: BSD-2-Clause-FreeBSD
 *
 * Copyright (c) 2009-2010 Weongyo Jeong <weongyo@freebsd.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    similar to the "NO WARRANTY" disclaimer below ("Disclaimer") and any
 *    redistribution must be conditioned upon including a substantially
 *    similar Disclaimer requirement for further binary redistribution.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF NONINFRINGEMENT, MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGES.
 *
 * $FreeBSD: stable/12/sys/dev/bwn/if_bwnreg.h 328912 2018-02-05 23:38:15Z landonf $
 */

#ifndef _IF_BWNREG_H
#define	_IF_BWNREG_H

/* D11-specific I/O control flags */
#define	BWN_IOCTL_PHYCLOCK_ENABLE	0x0004
#define	BWN_IOCTL_PHYRESET		0x0008
#define	BWN_IOCTL_MACPHYCLKEN		0x0010	/* MAC PHY Clock Control Enable (rev >= 5) */
#define	BWN_IOCTL_PLLREFSEL		0x0020	/* PLL Frequency Reference Select (rev >= 5) */
/* PHY_BANDWIDTH: N-PHY only */
#define	BWN_IOCTL_PHY_BANDWIDTH		0x00C0
#define	BWN_IOCTL_PHY_BANDWIDTH_10MHZ	0x0000
#define	BWN_IOCTL_PHY_BANDWIDTH_20MHZ	0x0040
#define	BWN_IOCTL_PHY_BANDWIDTH_40MHZ	0x0080
#define	BWN_IOCTL_SUPPORT_G		0x2000

/* D11-specific I/O status flags */
#define	BWN_IOST_HAVE_2GHZ		0x0001
#define	BWN_IOST_HAVE_5GHZ		0x0002
#define	BWN_IOST_DUALPHY		0x0008

#define	BWN_PHYTYPE_A			0x00
#define	BWN_PHYTYPE_B			0x01
#define	BWN_PHYTYPE_G			0x02
#define	BWN_PHYTYPE_N			0x04
#define	BWN_PHYTYPE_LP			0x05
#define	BWN_PHYTYPE_SSLPN		0x06
#define	BWN_PHYTYPE_HT			0x07
#define	BWN_PHYTYPE_LCN			0x08
#define	BWN_PHYTYPE_LCNXN		0x09
#define	BWN_PHYTYPE_LCN40		0x0a
#define	BWN_PHYTYPE_AC			0x0b

#define	BWN_DMA0_REASON			0x20
#define	BWN_DMA0_INTR_MASK		0x24
#define	BWN_DMA1_REASON			0x28
#define	BWN_DMA1_INTR_MASK		0x2c
#define	BWN_DMA2_REASON			0x30
#define	BWN_DMA2_INTR_MASK		0x34
#define	BWN_DMA3_REASON			0x38
#define	BWN_DMA3_INTR_MASK		0x3c
#define	BWN_DMA4_REASON			0x40
#define	BWN_DMA4_INTR_MASK		0x44
#define	BWN_DMA5_INTR_MASK		0x4c

#define	BWN_MACCTL			0x120
#define	BWN_MACCTL_ON			0x00000001
#define	BWN_MACCTL_MCODE_RUN		0x00000002
#define	BWN_MACCTL_MCODE_JMP0		0x00000004
#define	BWN_MACCTL_SHM_ON		0x00000100
#define	BWN_MACCTL_IHR_ON		0x00000400
#define	BWN_MACCTL_GPOUT_MASK		0x0000c000
#define	BWN_MACCTL_BIGENDIAN		0x00010000
#define	BWN_MACCTL_STA			0x00020000
#define	BWN_MACCTL_HOSTAP		0x00040000
#define	BWN_MACCTL_RADIO_LOCK		0x00080000
#define	BWN_MACCTL_BEACON_PROMISC	0x00100000
#define	BWN_MACCTL_PASS_BADPLCP		0x00200000
#define	BWN_MACCTL_PHY_LOCK		0x00200000	/* PHY-N? */
#define	BWN_MACCTL_PASS_CTL		0x00400000
#define	BWN_MACCTL_PASS_BADFCS		0x00800000
#define	BWN_MACCTL_PROMISC		0x01000000
#define	BWN_MACCTL_HWPS			0x02000000
#define	BWN_MACCTL_AWAKE		0x04000000
#define	BWN_MACCTL_CLOSEDNET		0x08000000
#define	BWN_MACCTL_TBTT_HOLD		0x10000000
#define	BWN_MACCTL_DISC_TXSTAT		0x20000000
#define	BWN_MACCTL_DISC_PMQ		0x40000000
#define	BWN_MACCTL_GMODE		0x80000000

#define	BWN_MACCMD			0x124	/* MAC command */
#define	BWN_MACCMD_BEACON0_VALID	0x00000001
#define	BWN_MACCMD_BEACON1_VALID	0x00000002
#define	BWN_MACCMD_DFQ_VALID		0x00000004
#define	BWN_MACCMD_BGNOISE		0x00000010
#define	BWN_INTR_REASON			0x128
#define	BWN_INTR_MASK			0x12c
#define	BWN_RAM_CONTROL			0x130
#define	BWN_RAM_DATA			0x134
#define	BWN_PS_STATUS			0x140
#define	BWN_MAC_HW_CAP			0x15c	/* core rev >= 13 */
#define	BWN_RF_HWENABLED_HI		0x158
#define	BWN_RF_HWENABLED_HI_MASK	(1 << 16)
#define	BWN_SHM_CONTROL			0x160
#define	BWN_SHM_DATA			0x164
#define	BWN_SHM_DATA_UNALIGNED		0x166
#define	BWN_XMITSTAT_0			0x170
#define	BWN_XMITSTAT_1			0x174
#define	BWN_REV3PLUS_TSF_LOW		0x180	/* core rev >= 3 only */
#define	BWN_REV3PLUS_TSF_HIGH		0x184	/* core rev >= 3 only */
#define	BWN_TSF_CFP_START		0x18c

/* 32-bit DMA */
#define	BWN_DMA32_BASE0			0x200
#define	BWN_DMA32_BASE1			0x220
#define	BWN_DMA32_BASE2			0x240
#define	BWN_DMA32_BASE3			0x260
#define	BWN_DMA32_BASE4			0x280
#define	BWN_DMA32_BASE5			0x2a0
/* 64-bit DMA */
#define	BWN_DMA64_BASE0			0x200
#define	BWN_DMA64_BASE1			0x240
#define	BWN_DMA64_BASE2			0x280
#define	BWN_DMA64_BASE3			0x2c0
#define	BWN_DMA64_BASE4			0x300
#define	BWN_DMA64_BASE5			0x340

/* PIO on core rev < 11 */
#define	BWN_PIO_BASE0			0x300
#define	BWN_PIO_BASE1			0x310
#define	BWN_PIO_BASE2			0x320
#define	BWN_PIO_BASE3			0x330
#define	BWN_PIO_BASE4			0x340
#define	BWN_PIO_BASE5			0x350
#define	BWN_PIO_BASE6			0x360
#define	BWN_PIO_BASE7			0x370
/* PIO on core rev >= 11 */
#define	BWN_PIO11_BASE0			0x200
#define	BWN_PIO11_BASE1			0x240
#define	BWN_PIO11_BASE2			0x280
#define	BWN_PIO11_BASE3			0x2c0
#define	BWN_PIO11_BASE4			0x300
#define	BWN_PIO11_BASE5			0x340

#define	BWN_GPIOCTL			0x06c
#define	BWN_PHYVER			0x3e0
#define	BWN_PHYVER_ANALOG		0xf000
#define	BWN_PHYVER_TYPE			0x0f00
#define	BWN_PHYVER_VERSION		0x00ff
#define	BWN_PHY_RADIO			0x3e2
#define	BWN_PHY0			0x3e6
#define	BWN_CHANNEL			0x3f0
#define	BWN_CHANNEL_EXT			0x3f4
#define	BWN_RFCTL			0x3f6
#define	BWN_RFCTL_ID			0x01
#define	BWN_RFDATAHI			0x3f8
#define	BWN_RFDATALO			0x3fa
#define	BWN_PHYCTL			0x3fc
#define	BWN_PHYDATA			0x3fe
#define	BWN_MACFILTER_CONTROL		0x420
#define	BWN_MACFILTER_DATA		0x422
#define	BWN_RCMTA_COUNT			0x43c

#define	BWN_PSM_PHY_HDR			0x492
/* BWN_PSM_PHY_HDR bits */
#define	BWN_PSM_HDR_MAC_PHY_RESET	0x00000001
#define	BWN_PSM_HDR_MAC_PHY_CLOCK_EN	0x00000002
#define	BWN_PSM_HDR_MAC_PHY_FORCE_CLK	0x00000004

#define	BWN_RF_HWENABLED_LO		0x49a
#define	BWN_RF_HWENABLED_LO_MASK	(1 << 4)
#define	BWN_GPIO_CONTROL		0x49c
#define	BWN_GPIO_MASK			0x49e
#define	BWN_TSF_CFP_START_LOW		0x604
#define	BWN_TSF_CFP_START_HIGH		0x606
#define	BWN_TSF_CFP_PRETBTT		0x612
#define	BWN_TSF_CLK_FRAC_LOW		0x62e
#define	BWN_TSF_CLK_FRAC_HIGH		0x630
#define	BWN_RNG				0x65a
#define	BWN_IFSCTL			0x688 /* Interframe space control */
#define	BWN_IFSCTL_USE_EDCF		0x0004
#define	BWN_POWERUP_DELAY		0x6a8
#define	BWN_BTCOEX_CTL			0x6b4
#define	BWN_BTCOEX_TXCTL		0x6b8

#define	BWN_UCODE			0x0
#define	BWN_HW				0x3
#define	BWN_RCMTA			0x4

#define	BWN_TSSI_MAX			0x7f
#define	BWN_SHARED			0x1
#define	BWN_SHARED_UCODE_REV		0x0000
#define	BWN_SHARED_UCODE_PATCH		0x0002
#define	BWN_SHARED_UCODE_DATE		0x0004
#define	BWN_SHARED_UCODE_TIME		0x0006
#define	BWN_SHARED_COREREV		0x0016
#define	BWN_SHARED_ACKCTS_PHYCTL	0x0022
#define	BWN_SHARED_RX_PADOFFSET		0x0034
#define	BWN_SHARED_UCODESTAT		0x0040
#define	BWN_SHARED_UCODESTAT_SUSPEND	3
#define	BWN_SHARED_UCODESTAT_SLEEP	4
#define	BWN_SHARED_FWCAPS		0x0042
#define	BWN_SHARED_SHORT_RETRY_FALLBACK	0x0044
#define	BWN_SHARED_LONG_RETRY_FALLBACK	0x0046
#define	BWN_SHARED_BEACON_PHYCTL	0x0054
#define	BWN_SHARED_KEY_TABLEP		0x0056
#define	BWN_SHARED_TSSI_CCK		0x0058
#define	BWN_SHARED_HFLO			0x005e	/* low hostflag */
#define	BWN_SHARED_HFMI			0x0060	/* middle hostflag */
#define	BWN_SHARED_HFHI			0x0062	/* high hostflag */
#define	BWN_SHARED_RADIO_ATT		0x0064
#define	BWN_SHARED_TSSI_OFDM_G		0x0070
#define	BWN_SHARED_PROBE_RESP_MAXTIME	0x0074
#define	BWN_SHARED_SPU_WAKEUP		0x0094
#define	BWN_SHARED_PRETBTT		0x0096
#define	BWN_SHARED_CHAN			0x00a0
#define	BWN_SHARED_MACHW_L		0x00c0
#define	BWN_SHARED_MACHW_H		0x00c2
#define	BWN_SHARED_AUTOINC		0x0100
#define	BWN_SHARED_PROBE_RESP_PHYCTL	0x0188
#define	BWN_SHARED_EDCFQ		0x0240
#define	BWN_SHARED_KEYIDX_BLOCK		0x05d4
#define	BWN_SHARED_PSM			0x05f4

/* SHM_SHARED tx iq workarounds */
#define	BWN_SHM_SH_NPHY_TXIQW0		0x0700
#define	BWN_SHM_SH_NPHY_TXIQW1		0x0702
#define	BWN_SHM_SH_NPHY_TXIQW2		0x0704
#define	BWN_SHM_SH_NPHY_TXIQW3		0x0706
/* SHM_SHARED tx pwr ctrl */
#define	BWN_SHM_SH_NPHY_TXPWR_INDX0	0x0708
#define	BWN_SHM_SH_NPHY_TXPWR_INDX1	0x070E

/* SHM_SCRATCH offsets */
#define	BWN_SCRATCH			0x2
#define	BWN_SCRATCH_CONT_MIN		0x0003
#define	BWN_SCRATCH_CONT_MAX		0x0004
#define	BWN_SCRATCH_SHORT_RETRY		0x0006
#define	BWN_SCRATCH_LONG_RETRY		0x0007

/* Generic-Interrupt reasons. */
#define	BWN_INTR_MAC_SUSPENDED		0x00000001
#define	BWN_INTR_BEACON			0x00000002
#define	BWN_INTR_TBTT_INDI		0x00000004
#define	BWN_INTR_ATIM_END		0x00000020
#define	BWN_INTR_PMQ			0x00000040
#define	BWN_INTR_MAC_TXERR		0x00000200
#define	BWN_INTR_PHY_TXERR		0x00000800
#define	BWN_INTR_DMA			0x00008000
#define	BWN_INTR_TXFIFO_FLUSH_OK	0x00010000
#define	BWN_INTR_NOISESAMPLE_OK		0x00040000
#define	BWN_INTR_UCODE_DEBUG		0x08000000
#define	BWN_INTR_RFKILL			0x10000000
#define	BWN_INTR_TX_OK			0x20000000
#define	BWN_INTR_ALL			0xffffffff
#define	BWN_INTR_MASKTEMPLATE	\
	(BWN_INTR_TBTT_INDI | BWN_INTR_ATIM_END | BWN_INTR_PMQ |	\
	 BWN_INTR_MAC_TXERR | BWN_INTR_PHY_TXERR | BWN_INTR_DMA |	\
	 BWN_INTR_TXFIFO_FLUSH_OK | BWN_INTR_NOISESAMPLE_OK |	\
	 BWN_INTR_UCODE_DEBUG | BWN_INTR_RFKILL | BWN_INTR_TX_OK)

#define	BWN_HF_UCODE_ANTDIV_HELPER	0x000000000001ull
#define	BWN_HF_GPHY_SYM_WORKAROUND	0x000000000002ull
#define	BWN_HF_4DB_CCK_POWERBOOST	0x000000000008ull
#define	BWN_HF_BT_COEXIST		0x000000000010ull
#define	BWN_HF_GPHY_DC_CANCELFILTER	0x000000000020ull
#define	BWN_HF_PAGAINBOOST_OFDM_ON	0x000000000040ull
#define	BWN_HF_JAPAN_CHAN14_OFF		0x000000000080ull
#define	BWN_HF_EDCF			0x000000000100ull
#define	BWN_HF_TSSI_RESET_PSM_WORKAROUN	0x000000000200ull
#define	BWN_HF_SLOWCLOCK_REQ_OFF	0x000000000400ull
#define	BWN_HF_ACI_WORKAROUND		0x000000000800ull
#define	BWN_HF_2060_RADIO_WORKAROUND	0x000000001000ull
#define	BWN_HF_FORCE_VCO_RECALC		0x000000040000ull
#define	BWN_HF_PCI_SLOWCLOCK_WORKAROUND	0x000000080000ull
#define	BWN_HF_4318_TSSI		0x000000200000ull
#define	BWN_HF_HW_POWERCTL		0x000000800000ull
#define	BWN_HF_BT_COEXISTALT		0x000001000000ull
#define	BWN_HF_SKIP_CFP_UPDATE		0x000004000000ull
#define	BWN_HF_N40W			0x000008000000ULL /* N PHY 40 MHz workaround (rev >= 13 only) */
#define	BWN_HF_ANTSEL			0x000020000000ULL /* Antenna selection (for testing antenna div.) */
#define	BWN_HF_BT3COEXT			0x000020000000ULL /* Bluetooth 3-wire coexistence (rev >= 13 only) */
#define	BWN_HF_BTCANT			0x000040000000ULL /* Bluetooth coexistence (antenna mode) (rev >= 13 only) */
#define	BWN_HF_ANTSELEN			0x000100000000ULL /* Antenna selection enabled (rev >= 13 only) */
#define	BWN_HF_ANTSELMODE		0x000200000000ULL /* Antenna selection mode (rev >= 13 only) */
#define	BWN_HF_MLADVW			0x001000000000ULL /* N PHY ML ADV workaround (rev >= 13 only) */
#define	BWN_HF_PR45960W			0x080000000000ULL

#define	BWN_TX_PHY_ENC_CCK		0x0000
#define	BWN_TX_PHY_ENC_OFDM		0x0001
#define	BWN_TX_PHY_SHORTPRMBL		0x0010
#define	BWN_TX_PHY_ANT			0x03c0
#define	BWN_TX_PHY_ANT0			0x0000
#define	BWN_TX_PHY_ANT1			0x0040
#define	BWN_TX_PHY_ANT01AUTO		0x00c0
#define	BWN_TX_PHY_ANT2			0x0100
#define	BWN_TX_PHY_ANT3			0x0200
#define	BWN_TX_PHY_TXPWR		0xfc00
#define	BWN_TX_MAC_ACK			0x00000001	/* immediate ACK */
#define	BWN_TX_MAC_LONGFRAME		0x00000002
#define	BWN_TX_MAC_SEND_RTSCTS		0x00000004
#define	BWN_TX_MAC_START_MSDU		0x00000008
#define	BWN_TX_MAC_HWSEQ		0x00000010
#define	BWN_TX_MAC_5GHZ			0x00000080
#define	BWN_TX_MAC_SEND_CTSTOSELF	0x00000800
#define	BWN_TX_EFT_FB_CCK		0x00
#define	BWN_TX_EFT_FB_OFDM		0x01
#define	BWN_TX_EFT_RTS_CCK		0x00
#define	BWN_TX_EFT_RTS_OFDM		0x04
#define	BWN_TX_EFT_RTS_FBCCK		0x00
#define	BWN_TX_EFT_RTS_FBOFDM		0x10

#define	BWN_PIO_TXCTL			0x00
#define	BWN_PIO_TXCTL_WRITELO		0x0001
#define	BWN_PIO_TXCTL_WRITEHI		0x0002
#define	BWN_PIO_TXCTL_EOF		0x0004
#define	BWN_PIO_TXCTL_FRAMEREADY	0x0008
#define	BWN_PIO_TXDATA			0x02
#define	BWN_PIO_TXQBUFSIZE		0x04
#define	BWN_PIO_RXCTL			0x00
#define	BWN_PIO_RXCTL_FRAMEREADY	0x0001
#define	BWN_PIO_RXCTL_DATAREADY		0x0002
#define	BWN_PIO_RXDATA			0x02
#define	BWN_PIO8_TXCTL			0x00
#define	BWN_PIO8_TXCTL_0_7		0x00000001
#define	BWN_PIO8_TXCTL_8_15		0x00000002
#define	BWN_PIO8_TXCTL_16_23		0x00000004
#define	BWN_PIO8_TXCTL_24_31		0x00000008
#define	BWN_PIO8_TXCTL_EOF		0x00000010
#define	BWN_PIO8_TXCTL_FRAMEREADY	0x00000080
#define	BWN_PIO8_TXDATA			0x04
#define	BWN_PIO8_RXCTL			0x00
#define	BWN_PIO8_RXCTL_FRAMEREADY	0x00000001
#define	BWN_PIO8_RXCTL_DATAREADY	0x00000002
#define	BWN_PIO8_RXDATA			0x04

#define	BWN_DMA32_TXCTL			0x00
#define	BWN_DMA32_TXENABLE		0x00000001
#define	BWN_DMA32_TXSUSPEND		0x00000002
#define	BWN_DMA32_TXPARITY_DISABLE	0x00000800
#define	BWN_DMA32_TXADDREXT_MASK	0x00030000
#define	BWN_DMA32_TXADDREXT_SHIFT	16
#define	BWN_DMA32_TXRING		0x04
#define	BWN_DMA32_TXINDEX		0x08
#define	BWN_DMA32_TXSTATUS		0x0c
#define	BWN_DMA32_TXSTATE		0x0000f000
#define	BWN_DMA32_TXSTAT_DISABLED	0x00000000
#define	BWN_DMA32_TXSTAT_IDLEWAIT	0x00002000
#define	BWN_DMA32_TXSTAT_STOPPED	0x00003000
#define	BWN_DMA32_RXCTL			0x10
#define	BWN_DMA32_RXENABLE		0x00000001
#define	BWN_DMA32_RXFROFF_SHIFT		1
#define	BWN_DMA32_RXDIRECTFIFO		0x00000100
#define	BWN_DMA32_RXPARITY_DISABLE	0x00000800
#define	BWN_DMA32_RXADDREXT_MASK	0x00030000
#define	BWN_DMA32_RXADDREXT_SHIFT	16
#define	BWN_DMA32_RXRING		0x14
#define	BWN_DMA32_RXINDEX		0x18
#define	BWN_DMA32_RXSTATUS		0x1c
#define	BWN_DMA32_RXDPTR		0x00000fff
#define	BWN_DMA32_RXSTATE		0x0000f000
#define	BWN_DMA32_RXSTAT_DISABLED	0x00000000
#define	BWN_DMA32_ADDREXT_MASK		0xC0000000
#define	BWN_DMA32_ADDREXT_SHIFT		30
#define	BWN_DMA64_TXCTL			0x00
#define	BWN_DMA64_TXENABLE		0x00000001
#define	BWN_DMA64_TXSUSPEND		0x00000002
#define	BWN_DMA64_TXPARITY_DISABLE	0x00000800
#define	BWN_DMA64_TXADDREXT_MASK	0x00030000
#define	BWN_DMA64_TXADDREXT_SHIFT	16
#define	BWN_DMA64_TXINDEX		0x04
#define	BWN_DMA64_TXRINGLO		0x08
#define	BWN_DMA64_TXRINGHI		0x0c
#define	BWN_DMA64_TXSTATUS		0x10
#define	BWN_DMA64_TXSTAT		0xf0000000
#define	BWN_DMA64_TXSTAT_DISABLED	0x00000000
#define	BWN_DMA64_TXSTAT_IDLEWAIT	0x20000000
#define	BWN_DMA64_TXSTAT_STOPPED	0x30000000
#define	BWN_DMA64_RXCTL			0x20
#define	BWN_DMA64_RXENABLE		0x00000001
#define	BWN_DMA64_RXFROFF_SHIFT		1
#define	BWN_DMA64_RXDIRECTFIFO		0x00000100
#define	BWN_DMA64_RXPARITY_DISABLE	0x00000800
#define	BWN_DMA64_RXADDREXT_MASK	0x00030000
#define	BWN_DMA64_RXADDREXT_SHIFT	16
#define	BWN_DMA64_RXINDEX		0x24
#define	BWN_DMA64_RXRINGLO		0x28
#define	BWN_DMA64_RXRINGHI		0x2c
#define	BWN_DMA64_RXSTATUS		0x30
#define	BWN_DMA64_RXSTATDPTR		0x00001fff
#define	BWN_DMA64_RXSTAT		0xf0000000
#define	BWN_DMA64_RXSTAT_DISABLED	0x00000000
#define	BWN_DMA64_ADDREXT_MASK		0xC000000000000000ULL
#define	BWN_DMA64_ADDREXT_SHIFT		62
#define	BWN_DMA_RINGMEMSIZE		PAGE_SIZE
#define	BWN_DMA0_RX_FRAMEOFFSET_FW351	30
#define	BWN_DMA0_RX_FRAMEOFFSET_FW598	38

#define	BWN_TXRING_SLOTS		64
#define	BWN_RXRING_SLOTS		64
#define	BWN_DMA0_RX_BUFFERSIZE_FW351	(IEEE80211_MAX_LEN + BWN_DMA0_RX_FRAMEOFFSET_FW351)
#define	BWN_DMA0_RX_BUFFERSIZE_FW598	(IEEE80211_MAX_LEN + BWN_DMA0_RX_FRAMEOFFSET_FW598)

#define	BWN_PHYROUTE_BASE		0x0000
#define	BWN_PHYROUTE_MASK		0x0c00
#define	BWN_PHYROUTE_OFDM_GPHY		0x0400
#define	BWN_PHYROUTE_EXT_GPHY		0x0800
#define	BWN_PHYROUTE_N_BMODE		0x0C00
#define	BWN_PHY_CCK(reg)		((reg) | BWN_PHYROUTE_BASE)
#define	BWN_PHY_N(reg)			((reg) | BWN_PHYROUTE_BASE) /* PHY-N */
#define	BWN_PHY_N_BMODE(reg)		((reg) | BWN_PHYROUTE_N_BMODE)
#define	BWN_PHY_OFDM(reg)		((reg) | BWN_PHYROUTE_OFDM_GPHY)
#define	BWN_PHY_EXTG(reg)		((reg) | BWN_PHYROUTE_EXT_GPHY)

#define	BWN_PHY_VERSION_OFDM		BWN_PHY_OFDM(0x00)
#define	BWN_PHY_BBANDCFG		BWN_PHY_OFDM(0x01)
#define	BWN_PHY_BBANDCFG_RXANT		0x180
#define	BWN_PHY_BBANDCFG_RXANT_SHIFT	7
#define	BWN_PHY_PWRDOWN			BWN_PHY_OFDM(0x03)
#define	BWN_PHY_CRSTHRES1_R1		BWN_PHY_OFDM(0x06)
#define	BWN_PHY_CRSGAIN_CTL		BWN_PHY_OFDM(0x10)
#define	BWN_PHY_MINPWR_LEVEL		BWN_PHY_OFDM(0x16)
#define	BWN_PHY_OFDMSYNCTHRESH0		BWN_PHY_OFDM(0x17)
#define	BWN_PHY_IDLEAFTERPKTRXTO	BWN_PHY_OFDM(0x1a)
#define	BWN_PHY_LNAHPFCTL		BWN_PHY_OFDM(0x1c)
#define	BWN_PHY_DCOFFSETTRANSIENT	BWN_PHY_OFDM(0x1c) /* for LP */
#define	BWN_PHY_PREAMBLECONFIRMTO	BWN_PHY_OFDM(0x1e)
#define	BWN_PHY_CLIPTHRESH		BWN_PHY_OFDM(0x1f)
#define	BWN_PHY_LPFGAINCTL		BWN_PHY_OFDM(0x20)
#define	BWN_PHY_CLIPCTRTHRESH		BWN_PHY_OFDM(0x20) /* for LP */
#define	BWN_PHY_HIGAINDB		BWN_PHY_OFDM(0x23)
#define	BWN_PHY_LOWGAINDB		BWN_PHY_OFDM(0x24)
#define	BWN_PHY_VERYLOWGAINDB		BWN_PHY_OFDM(0x25)
#define	BWN_PHY_GAINMISMATCH		BWN_PHY_OFDM(0x26)
#define	BWN_PHY_ADIVRELATED		BWN_PHY_OFDM(0x27)
#define	BWN_PHY_GAINDIRECTMISMATCH	BWN_PHY_OFDM(0x27) /* for LP */
#define	BWN_PHY_CRS0			BWN_PHY_OFDM(0x29)
#define	BWN_PHY_CRS0_EN			0x4000
#define	BWN_PHY_PWR_THRESH1		BWN_PHY_OFDM(0x29) /* for LP */
#define	BWN_PHY_ANTDWELL		BWN_PHY_OFDM(0x2b)
#define	BWN_PHY_ANTDWELL_AUTODIV1	0x0100
#define	BWN_PHY_DSSS_CONFIRM_CNT	BWN_PHY_OFDM(0x2f) /* DSSS Confirm Cnt */
#define	BWN_PHY_PEAK_COUNT		BWN_PHY_OFDM(0x30)
#define	BWN_PHY_GAIN_MISMATCH_LIMIT	BWN_PHY_OFDM(0x31)
#define	BWN_PHY_CRS_ED_THRESH		BWN_PHY_OFDM(0x32)
#define	BWN_PHY_INPUT_PWRDB		BWN_PHY_OFDM(0x34)
#define	BWN_PHY_AFE_ADC_CTL_0		BWN_PHY_OFDM(0x36)
#define	BWN_PHY_AFE_ADC_CTL_1		BWN_PHY_OFDM(0x37)
#define	BWN_PHY_AFE_DAC_CTL		BWN_PHY_OFDM(0x39)
#define	BWN_PHY_AFE_CTL			BWN_PHY_OFDM(0x3a)
#define	BWN_PHY_AFE_CTL_OVR		BWN_PHY_OFDM(0x3b)
#define	BWN_PHY_AFE_CTL_OVRVAL		BWN_PHY_OFDM(0x3c)
#define	BWN_PHY_AFE_RSSI_CTL_0		BWN_PHY_OFDM(0x3d)
#define	BWN_PHY_AFE_RSSI_CTL_1		BWN_PHY_OFDM(0x3e)
#define	BWN_PHY_LP_PHY_CTL		BWN_PHY_OFDM(0x48)
#define	BWN_PHY_ENCORE			BWN_PHY_OFDM(0x49)
#define	BWN_PHY_ENCORE_EN		0x0200
#define	BWN_PHY_RESET_CTL		BWN_PHY_OFDM(0x4a)
#define	BWN_PHY_RF_OVERRIDE_0		BWN_PHY_OFDM(0x4c)
#define	BWN_PHY_RF_OVERRIDE_VAL_0	BWN_PHY_OFDM(0x4d)
#define	BWN_PHY_TR_LOOKUP_1		BWN_PHY_OFDM(0x4e)
#define	BWN_PHY_TR_LOOKUP_2		BWN_PHY_OFDM(0x4F)
#define	BWN_PHY_LMS			BWN_PHY_OFDM(0x55)
#define	BWN_PHY_TABLE_ADDR		BWN_PHY_OFDM(0x55) /* for LP */
#define	BWN_PHY_TABLEDATALO		BWN_PHY_OFDM(0x56)
#define	BWN_PHY_TABLEDATAHI		BWN_PHY_OFDM(0x57)
#define	BWN_PHY_OFDM61			BWN_PHY_OFDM(0x61)
#define	BWN_PHY_OFDM61_10		0x0010
#define	BWN_PHY_ADC_COMPENSATION_CTL	BWN_PHY_OFDM(0x70)
#define	BWN_PHY_OTABLECTL		BWN_PHY_OFDM(0x72)
#define	BWN_PHY_OTABLENR_SHIFT		10
#define	BWN_PHY_OTABLEI			BWN_PHY_OFDM(0x73)
#define	BWN_PHY_OTABLEQ			BWN_PHY_OFDM(0x74)
#define	BWN_PHY_HPWR_TSSICTL		BWN_PHY_OFDM(0x78)
#define	BWN_PHY_IQ_ENABLE_WAIT_TIME_ADDR	BWN_PHY_OFDM(0x81)
#define	BWN_PHY_IQ_NUM_SMPLS_ADDR	BWN_PHY_OFDM(0x82)
#define	BWN_PHY_IQ_ACC_HI_ADDR		BWN_PHY_OFDM(0x83)
#define	BWN_PHY_IQ_ACC_LO_ADDR		BWN_PHY_OFDM(0x84)
#define	BWN_PHY_IQ_I_PWR_ACC_HI_ADDR	BWN_PHY_OFDM(0x85)
#define	BWN_PHY_IQ_I_PWR_ACC_LO_ADDR	BWN_PHY_OFDM(0x86)
#define	BWN_PHY_IQ_Q_PWR_ACC_HI_ADDR	BWN_PHY_OFDM(0x87)
#define	BWN_PHY_IQ_Q_PWR_ACC_LO_ADDR	BWN_PHY_OFDM(0x88)
#define	BWN_PHY_ANTWRSETT		BWN_PHY_OFDM(0x8c)
#define	BWN_PHY_ANTWRSETT_ARXDIV	0x2000
#define	BWN_PHY_OFDM9B			BWN_PHY_OFDM(0x9b)
#define	BWN_PHY_A_PHY_CTL_ADDR		BWN_PHY_OFDM(0x9c)
#define	BWN_PHY_RX_COMP_COEFF_S		BWN_PHY_OFDM(0x9e)
#define	BWN_PHY_N1P1GAIN		BWN_PHY_OFDM(0xa0)
#define	BWN_PHY_SMPL_PLAY_COUNT		BWN_PHY_OFDM(0xa0) /* for LP */
#define	BWN_PHY_P1P2GAIN		BWN_PHY_OFDM(0xa1)
#define	BWN_PHY_SMPL_PLAY_BUFFER_CTL	BWN_PHY_OFDM(0xA1) /* for LP */
#define	BWN_PHY_N1N2GAIN		BWN_PHY_OFDM(0xa2)
#define	BWN_PHY_4WIRECTL		BWN_PHY_OFDM(0xa2)  /* for LP */
#define	BWN_PHY_TX_PWR_CTL_CMD		BWN_PHY_OFDM(0xa4)
#define	BWN_PHY_TX_PWR_CTL_CMD_MODE	0xe000
#define	BWN_PHY_TX_PWR_CTL_CMD_MODE_OFF	0x0000
#define	BWN_PHY_TX_PWR_CTL_CMD_MODE_SW	0x8000
#define	BWN_PHY_TX_PWR_CTL_CMD_MODE_HW	0xe000
#define	BWN_PHY_CCKSHIFTBITS_WA		BWN_PHY_OFDM(0xa5)
#define	BWN_PHY_TX_PWR_CTL_NNUM		BWN_PHY_OFDM(0xa5)	/* for LP */
#define	BWN_PHY_CCKSHIFTBITS		BWN_PHY_OFDM(0xa7)
#define	BWN_PHY_DIVSRCHIDX		BWN_PHY_OFDM(0xa8)
#define	BWN_PHY_DIVP1P2GAIN		BWN_PHY_OFDM(0xab)
#define	BWN_PHY_LP_RF_SIGNAL_LUT	BWN_PHY_OFDM(0xac)
#define	BWN_PHY_DIVSRCHGAINBACK		BWN_PHY_OFDM(0xad)
#define	BWN_PHY_RX_RADIO_CTL		BWN_PHY_OFDM(0xae)
#define	BWN_PHY_RF_OVERRIDE_2		BWN_PHY_OFDM(0xb0)
#define	BWN_PHY_RF_OVERRIDE_2_VAL	BWN_PHY_OFDM(0xb1)
#define	BWN_PHY_PS_CTL_OVERRIDE_VAL0	BWN_PHY_OFDM(0xB2)
#define	BWN_PHY_PS_CTL_OVERRIDE_VAL1	BWN_PHY_OFDM(0xB3)
#define	BWN_PHY_PS_CTL_OVERRIDE_VAL2	BWN_PHY_OFDM(0xB4)
#define	BWN_PHY_TX_GAIN_CTL_OVERRIDE_VAL	BWN_PHY_OFDM(0xB5)
#define	BWN_PHY_RX_GAIN_CTL_OVERRIDE_VAL	BWN_PHY_OFDM(0xB6)
#define	BWN_PHY_AFE_DDFS		BWN_PHY_OFDM(0xb7)
#define	BWN_PHY_AFE_DDFS_POINTER_INIT	BWN_PHY_OFDM(0xB8)
#define	BWN_PHY_AFE_DDFS_INCR_INIT	BWN_PHY_OFDM(0xB9)
#define	BWN_PHY_TR_LOOKUP_3		BWN_PHY_OFDM(0xbb)
#define	BWN_PHY_TR_LOOKUP_4		BWN_PHY_OFDM(0xbc)
#define	BWN_PHY_GPIO_OUTEN		BWN_PHY_OFDM(0xbe)
#define	BWN_PHY_GPIO_SELECT		BWN_PHY_OFDM(0xbf)
#define	BWN_PHY_CRSTHRES1		BWN_PHY_OFDM(0xc0)
#define	BWN_PHY_CRSTHRES2		BWN_PHY_OFDM(0xc1)
#define	BWN_PHY_4C3			BWN_PHY_OFDM(0xC3)
#define	BWN_PHY_4C4			BWN_PHY_OFDM(0xC4)
#define	BWN_PHY_4C5			BWN_PHY_OFDM(0xC5)
#define	BWN_PHY_TR_LOOKUP_5		BWN_PHY_OFDM(0xC7)
#define	BWN_PHY_TR_LOOKUP_6		BWN_PHY_OFDM(0xC8)
#define	BWN_PHY_TR_LOOKUP_7		BWN_PHY_OFDM(0xC9)
#define	BWN_PHY_TR_LOOKUP_8		BWN_PHY_OFDM(0xCA)
#define	BWN_PHY_RF_PWR_OVERRIDE		BWN_PHY_OFDM(0xd3)

#define	BWN_OFDMTAB(number, offset)	\
	(((number) << BWN_PHY_OTABLENR_SHIFT) | (offset))
#define	BWN_OFDMTAB_AGC1		BWN_OFDMTAB(0x00, 0)
#define	BWN_OFDMTAB_GAIN0		BWN_OFDMTAB(0x00, 0)
#define	BWN_OFDMTAB_GAINX		BWN_OFDMTAB(0x01, 0)
#define	BWN_OFDMTAB_GAIN1		BWN_OFDMTAB(0x01, 4)
#define	BWN_OFDMTAB_AGC3		BWN_OFDMTAB(0x02, 0)
#define	BWN_OFDMTAB_GAIN2		BWN_OFDMTAB(0x02, 3)
#define	BWN_OFDMTAB_LNAHPFGAIN1		BWN_OFDMTAB(0x03, 0)
#define	BWN_OFDMTAB_WRSSI		BWN_OFDMTAB(0x04, 0)
#define	BWN_OFDMTAB_NOISESCALE		BWN_OFDMTAB(0x05, 0)
#define	BWN_OFDMTAB_AGC2		BWN_OFDMTAB(0x06, 0)
#define	BWN_OFDMTAB_ROTOR		BWN_OFDMTAB(0x08, 0)
#define	BWN_OFDMTAB_ADVRETARD		BWN_OFDMTAB(0x09, 0)
#define	BWN_OFDMTAB_DAC			BWN_OFDMTAB(0x0c, 0)
#define	BWN_OFDMTAB_DC			BWN_OFDMTAB(0x0e, 7)
#define	BWN_OFDMTAB_PWRDYN2		BWN_OFDMTAB(0x0e, 12)
#define	BWN_OFDMTAB_UNKNOWN_0F		BWN_OFDMTAB(0x0f, 0)
#define	BWN_OFDMTAB_UNKNOWN_APHY	BWN_OFDMTAB(0x0f, 7)
#define	BWN_OFDMTAB_LPFGAIN		BWN_OFDMTAB(0x0f, 12)
#define	BWN_OFDMTAB_RSSI		BWN_OFDMTAB(0x10, 0)
#define	BWN_OFDMTAB_UNKNOWN_11		BWN_OFDMTAB(0x11, 4)
#define	BWN_OFDMTAB_AGC1_R1		BWN_OFDMTAB(0x13, 0)
#define	BWN_OFDMTAB_GAINX_R1		BWN_OFDMTAB(0x14, 0)
#define	BWN_OFDMTAB_MINSIGSQ		BWN_OFDMTAB(0x14, 0)
#define	BWN_OFDMTAB_AGC3_R1		BWN_OFDMTAB(0x15, 0)
#define	BWN_OFDMTAB_WRSSI_R1		BWN_OFDMTAB(0x15, 4)
#define	BWN_OFDMTAB_DACRFPABB		BWN_OFDMTAB(0x16, 0)

#define	BWN_PHY_CCKBBANDCFG		BWN_PHY_CCK(0x01)
#define	BWN_PHY_PGACTL			BWN_PHY_CCK(0x15)
#define	BWN_PHY_PGACTL_LPF		0x1000
#define	BWN_PHY_PGACTL_LOWBANDW		0x0040
#define	BWN_PHY_PGACTL_UNKNOWN		0xefa0
#define	BWN_PHY_TSSI			BWN_PHY_CCK(0x29)
#define	BWN_PHY_LO_LEAKAGE		BWN_PHY_CCK(0x2d)
#define	BWN_PHY_SYNCPEAKCNT		BWN_PHY_CCK(0x30)
#define	BWN_PHY_SYNCCTL			BWN_PHY_CCK(0x35)
#define	BWN_PHY_DACCTL			BWN_PHY_CCK(0x60)

#define	BWN_PHY_CLASSCTL		BWN_PHY_EXTG(0x02)
#define	BWN_PHY_GTABCTL			BWN_PHY_EXTG(0x03)
#define	BWN_PHY_GTABNR_SHIFT		10
#define	BWN_PHY_GTABDATA		BWN_PHY_EXTG(0x04)
#define	BWN_PHY_LO_MASK			BWN_PHY_EXTG(0x0f)
#define	BWN_PHY_LO_CTL			BWN_PHY_EXTG(0x10)
#define	BWN_PHY_RFOVER			BWN_PHY_EXTG(0x11)
#define	BWN_PHY_RFOVERVAL		BWN_PHY_EXTG(0x12)
#define	BWN_PHY_RFOVERVAL_EXTLNA	0x8000
#define	BWN_PHY_RFOVERVAL_LNA		0x7000
#define	BWN_PHY_RFOVERVAL_LNA_SHIFT	12
#define	BWN_PHY_RFOVERVAL_PGA		0x0f00
#define	BWN_PHY_RFOVERVAL_PGA_SHIFT	8
#define	BWN_PHY_RFOVERVAL_UNK		0x0010
#define	BWN_PHY_RFOVERVAL_TRSWRX	0x00e0
#define	BWN_PHY_RFOVERVAL_BW		0x0003
#define	BWN_PHY_RFOVERVAL_BW_LPF	0x0001
#define	BWN_PHY_RFOVERVAL_BW_LBW	0x0002
#define	BWN_PHY_ANALOGOVER		BWN_PHY_EXTG(0x14)
#define	BWN_PHY_ANALOGOVERVAL		BWN_PHY_EXTG(0x15)

#define	BWN_GTAB(number, offset)	\
	(((number) << BWN_PHY_GTABNR_SHIFT) | (offset))
#define	BWN_GTAB_ORIGTR			BWN_GTAB(0x2e, 0x298)

#define	BWN_PHY_G_LOCTL			0x0810
#define	BWN_PHY_RADIO_BITFIELD		0x0401
#define	BWN_PHY_G_CRS			0x0429
#define	BWN_PHY_NRSSI_CTRL		0x0803
#define	BWN_PHY_NRSSI_DATA		0x0804
#define	BWN_FWCAPS_HWCRYPTO		0x0001
#define	BWN_FWCAPS_WME			0x0002
#define	BWN_MACFILTER_SELF		0x0000
#define	BWN_MACFILTER_BSSID		0x0003
#define	BWN_SEC_KEYSIZE			16
#define	BWN_SEC_ALGO_NONE		0
#define	BWN_LED_BEHAVIOUR		0x7f
#define	BWN_LED_ACTIVELOW		0x80

#define	BWN_DEBUGINTR_REASON_REG	63
#define	BWN_DEBUGINTR_PANIC		0
#define	BWN_DEBUGINTR_DUMP_SHM		1
#define	BWN_DEBUGINTR_DUMP_REGS		2
#define	BWN_DEBUGINTR_MARKER		3
#define	BWN_DEBUGINTR_ACK		0xffff

#define	BWN_FWPANIC_REASON_REG		3
#define	BWN_FWPANIC_DIE			0
#define	BWN_FWPANIC_RESTART		1
#define	BWN_WATCHDOG_REG		1

#define	BWN_CCK_RATE_1MB		0x02
#define	BWN_CCK_RATE_2MB		0x04
#define	BWN_CCK_RATE_5MB		0x0b
#define	BWN_CCK_RATE_11MB		0x16
#define	BWN_OFDM_RATE_6MB		0x0c
#define	BWN_OFDM_RATE_9MB		0x12
#define	BWN_OFDM_RATE_12MB		0x18
#define	BWN_OFDM_RATE_18MB		0x24
#define	BWN_OFDM_RATE_24MB		0x30
#define	BWN_OFDM_RATE_36MB		0x48
#define	BWN_OFDM_RATE_48MB		0x60
#define	BWN_OFDM_RATE_54MB		0x6c

#define	BWN_RX_CHAN_PHYTYPE		0x0007
#define	BWN_RX_PHYST0_GAINCTL		0x4000
#define	BWN_RX_PHYST0_PLCPHCF		0x0200
#define	BWN_RX_PHYST0_PLCPFV		0x0100
#define	BWN_RX_PHYST0_SHORTPRMBL	0x0080
#define	BWN_RX_PHYST0_OFDM		0x0001
#define	BWN_RX_PHYST3_TRSTATE		0x0400
#define	BWN_RX_MAC_KEYIDX		0x000007e0
#define	BWN_RX_MAC_KEYIDX_SHIFT		5
#define	BWN_RX_MAC_DECERR		0x00000010
#define	BWN_RX_MAC_DEC			0x00000008
#define	BWN_RX_MAC_PADDING		0x00000004
#define	BWN_RX_MAC_FCSERR		0x00000001

#define	BWN_PS_ON			(1 << 0)
#define	BWN_PS_OFF			(1 << 1)
#define	BWN_PS_AWAKE			(1 << 2)
#define	BWN_PS_ASLEEP			(1 << 3)

#define	BWN_TAB_NOISESCALE_SIZE		27

/*
 * SPROM rev 1 locale codes. Later SPROM revisions use a two-character
 * country code.
 */
enum {
	BWN_SPROM1_CC_WORLDWIDE	= 0,
	BWN_SPROM1_CC_THAILAND	= 1,
	BWN_SPROM1_CC_ISRAEL	= 2,
	BWN_SPROM1_CC_JORDAN	= 3,
	BWN_SPROM1_CC_CHINA	= 4,
	BWN_SPROM1_CC_JP	= 5,
	BWN_SPROM1_CC_USA	= 6,
	BWN_SPROM1_CC_EUROPE	= 7,
	BWN_SPROM1_CC_US_LOW	= 8,
	BWN_SPROM1_CC_JP_HIGH	= 9,
};

/*
 * SPROM GPIO
 */
#define	BWN_LED_ACT_LOW			0x80
#define	BWN_LED_ACT_MASK		0x7f
#define	BWN_LED_ACT_OFF			0
#define	BWN_LED_ACT_ON			1
#define	BWN_LED_ACT_BLINK		2
#define	BWN_LED_ACT_RF_ENABLED		3
#define	BWN_LED_ACT_5GHZ		4
#define	BWN_LED_ACT_2GHZ		5
#define	BWN_LED_ACT_11G			6
#define	BWN_LED_ACT_BLINK_SLOW		7
#define	BWN_LED_ACT_BLINK_POLL		8
#define	BWN_LED_ACT_UNKN		9
#define	BWN_LED_ACT_ASSOC		10
#define	BWN_LED_ACT_NULL		11

#define	BWN_VENDOR_LED_ACT_HP_COMPAQ	\
	BWN_LED_ACT_RF_ENABLED,		\
	BWN_LED_ACT_2GHZ,		\
	BWN_LED_ACT_5GHZ,		\
	BWN_LED_ACT_OFF

#define	BWN_VENDOR_LED_ACT_ASUSTEK	\
	BWN_LED_ACT_ASSOC,		\
	BWN_LED_ACT_2GHZ,	\
	BWN_LED_ACT_5GHZ,		\
	BWN_LED_ACT_OFF

#define	BWN_VENDOR_LED_ACT_DEFAULT	\
	BWN_LED_ACT_BLINK,		\
	BWN_LED_ACT_2GHZ,	\
	BWN_LED_ACT_5GHZ,	\
	BWN_LED_ACT_OFF

#define	BWN_TAB_ROTOR							\
{									\
	0xfeb93ffd, 0xfec63ffd, 0xfed23ffd, 0xfedf3ffd, 0xfeec3ffe,	\
	0xfef83ffe, 0xff053ffe, 0xff113ffe, 0xff1e3ffe, 0xff2a3fff,	\
	0xff373fff, 0xff443fff, 0xff503fff, 0xff5d3fff, 0xff693fff,	\
	0xff763fff, 0xff824000, 0xff8f4000, 0xff9b4000, 0xffa84000,	\
	0xffb54000, 0xffc14000, 0xffce4000, 0xffda4000, 0xffe74000,	\
	0xfff34000, 0x00004000, 0x000d4000, 0x00194000, 0x00264000,	\
	0x00324000, 0x003f4000, 0x004b4000, 0x00584000, 0x00654000,	\
	0x00714000, 0x007e4000, 0x008a3fff, 0x00973fff, 0x00a33fff,	\
	0x00b03fff, 0x00bc3fff, 0x00c93fff, 0x00d63fff, 0x00e23ffe,	\
	0x00ef3ffe, 0x00fb3ffe, 0x01083ffe, 0x01143ffe, 0x01213ffd,	\
	0x012e3ffd, 0x013a3ffd, 0x01473ffd				\
}

#define	BWN_TAB_RETARD							\
{									\
	0xdb93cb87, 0xd666cf64, 0xd1fdd358, 0xcda6d826, 0xca38dd9f,	\
	0xc729e2b4, 0xc469e88e, 0xc26aee2b, 0xc0def46c, 0xc073fa62,	\
	0xc01d00d5, 0xc0760743, 0xc1560d1e, 0xc2e51369, 0xc4ed18ff,	\
	0xc7ac1ed7, 0xcb2823b2, 0xcefa28d9, 0xd2f62d3f, 0xd7bb3197,	\
	0xdce53568, 0xe1fe3875, 0xe7d13b35, 0xed663d35, 0xf39b3ec4,	\
	0xf98e3fa7, 0x00004000, 0x06723fa7, 0x0c653ec4, 0x129a3d35,	\
	0x182f3b35, 0x1e023875, 0x231b3568, 0x28453197, 0x2d0a2d3f,	\
	0x310628d9, 0x34d823b2, 0x38541ed7, 0x3b1318ff, 0x3d1b1369,	\
	0x3eaa0d1e, 0x3f8a0743, 0x3fe300d5, 0x3f8dfa62, 0x3f22f46c,	\
	0x3d96ee2b, 0x3b97e88e, 0x38d7e2b4, 0x35c8dd9f, 0x325ad826,	\
	0x2e03d358, 0x299acf64, 0x246dcb87,				\
}

#define	BWN_TAB_FINEFREQ_G						\
{									\
	0x0089, 0x02e9, 0x0409, 0x04e9, 0x05a9, 0x0669, 0x0709, 0x0789,	\
	0x0829, 0x08a9, 0x0929, 0x0989, 0x0a09, 0x0a69, 0x0ac9, 0x0b29,	\
	0x0ba9, 0x0be9, 0x0c49, 0x0ca9, 0x0d09, 0x0d69, 0x0da9, 0x0e09,	\
	0x0e69, 0x0ea9, 0x0f09, 0x0f49, 0x0fa9, 0x0fe9, 0x1029, 0x1089,	\
	0x10c9, 0x1109, 0x1169, 0x11a9, 0x11e9, 0x1229, 0x1289, 0x12c9,	\
	0x1309, 0x1349, 0x1389, 0x13c9, 0x1409, 0x1449, 0x14a9, 0x14e9,	\
	0x1529, 0x1569, 0x15a9, 0x15e9, 0x1629, 0x1669, 0x16a9, 0x16e8,	\
	0x1728, 0x1768, 0x17a8, 0x17e8, 0x1828, 0x1868, 0x18a8, 0x18e8,	\
	0x1928, 0x1968, 0x19a8, 0x19e8, 0x1a28, 0x1a68, 0x1aa8, 0x1ae8,	\
	0x1b28, 0x1b68, 0x1ba8, 0x1be8, 0x1c28, 0x1c68, 0x1ca8, 0x1ce8,	\
	0x1d28, 0x1d68, 0x1dc8, 0x1e08, 0x1e48, 0x1e88, 0x1ec8, 0x1f08,	\
	0x1f48, 0x1f88, 0x1fe8, 0x2028, 0x2068, 0x20a8, 0x2108, 0x2148,	\
	0x2188, 0x21c8, 0x2228, 0x2268, 0x22c8, 0x2308, 0x2348, 0x23a8,	\
	0x23e8, 0x2448, 0x24a8, 0x24e8, 0x2548, 0x25a8, 0x2608, 0x2668,	\
	0x26c8, 0x2728, 0x2787, 0x27e7, 0x2847, 0x28c7, 0x2947, 0x29a7,	\
	0x2a27, 0x2ac7, 0x2b47, 0x2be7, 0x2ca7, 0x2d67, 0x2e47, 0x2f67,	\
	0x3247, 0x3526, 0x3646, 0x3726, 0x3806, 0x38a6, 0x3946, 0x39e6,	\
	0x3a66, 0x3ae6, 0x3b66, 0x3bc6, 0x3c45, 0x3ca5, 0x3d05, 0x3d85,	\
	0x3de5, 0x3e45, 0x3ea5, 0x3ee5, 0x3f45, 0x3fa5, 0x4005, 0x4045,	\
	0x40a5, 0x40e5, 0x4145, 0x4185, 0x41e5, 0x4225, 0x4265, 0x42c5,	\
	0x4305, 0x4345, 0x43a5, 0x43e5, 0x4424, 0x4464, 0x44c4, 0x4504,	\
	0x4544, 0x4584, 0x45c4, 0x4604, 0x4644, 0x46a4, 0x46e4, 0x4724,	\
	0x4764, 0x47a4, 0x47e4, 0x4824, 0x4864, 0x48a4, 0x48e4, 0x4924,	\
	0x4964, 0x49a4, 0x49e4, 0x4a24, 0x4a64, 0x4aa4, 0x4ae4, 0x4b23,	\
	0x4b63, 0x4ba3, 0x4be3, 0x4c23, 0x4c63, 0x4ca3, 0x4ce3, 0x4d23,	\
	0x4d63, 0x4da3, 0x4de3, 0x4e23, 0x4e63, 0x4ea3, 0x4ee3, 0x4f23,	\
	0x4f63, 0x4fc3, 0x5003, 0x5043, 0x5083, 0x50c3, 0x5103, 0x5143,	\
	0x5183, 0x51e2, 0x5222, 0x5262, 0x52a2, 0x52e2, 0x5342, 0x5382,	\
	0x53c2, 0x5402, 0x5462, 0x54a2, 0x5502, 0x5542, 0x55a2, 0x55e2,	\
	0x5642, 0x5682, 0x56e2, 0x5722, 0x5782, 0x57e1, 0x5841, 0x58a1,	\
	0x5901, 0x5961, 0x59c1, 0x5a21, 0x5aa1, 0x5b01, 0x5b81, 0x5be1,	\
	0x5c61, 0x5d01, 0x5d80, 0x5e20, 0x5ee0, 0x5fa0, 0x6080, 0x61c0,	\
}

#define	BWN_TAB_NOISE_G1						\
{									\
	0x013c, 0x01f5, 0x031a, 0x0631, 0x0001, 0x0001, 0x0001, 0x0001,	\
}

#define	BWN_TAB_NOISE_G2						\
{									\
	0x5484, 0x3c40, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,	\
}

#define	BWN_TAB_NOISESCALE_G1						\
{									\
	0x6c77, 0x5162, 0x3b40, 0x3335, 0x2f2d, 0x2a2a, 0x2527, 0x1f21,	\
	0x1a1d, 0x1719, 0x1616, 0x1414, 0x1414, 0x1400, 0x1414, 0x1614,	\
	0x1716, 0x1a19, 0x1f1d, 0x2521, 0x2a27, 0x2f2a, 0x332d, 0x3b35,	\
	0x5140, 0x6c62, 0x0077,						\
}

#define	BWN_TAB_NOISESCALE_G2						\
{									\
	0xd8dd, 0xcbd4, 0xbcc0, 0xb6b7, 0xb2b0, 0xadad, 0xa7a9, 0x9fa1,	\
	0x969b, 0x9195, 0x8f8f, 0x8a8a, 0x8a8a, 0x8a00, 0x8a8a, 0x8f8a,	\
	0x918f, 0x9695, 0x9f9b, 0xa7a1, 0xada9, 0xb2ad, 0xb6b0, 0xbcb7,	\
	0xcbc0, 0xd8d4, 0x00dd,						\
}

#define	BWN_TAB_NOISESCALE_G3						\
{									\
	0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4,	\
	0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa400, 0xa4a4, 0xa4a4,	\
	0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4, 0xa4a4,	\
	0xa4a4, 0xa4a4, 0x00a4,						\
}

#define	BWN_TAB_SIGMASQR2						\
{									\
	0x00de, 0x00dc, 0x00da, 0x00d8, 0x00d6, 0x00d4, 0x00d2, 0x00cf,	\
	0x00cd, 0x00ca, 0x00c7, 0x00c4, 0x00c1, 0x00be, 0x00be, 0x00be,	\
	0x00be, 0x00be, 0x00be, 0x00be, 0x00be, 0x00be, 0x00be, 0x00be,	\
	0x00be, 0x00be, 0x0000, 0x00be, 0x00be, 0x00be, 0x00be, 0x00be,	\
	0x00be, 0x00be, 0x00be, 0x00be, 0x00be, 0x00be, 0x00be, 0x00be,	\
	0x00c1, 0x00c4, 0x00c7, 0x00ca, 0x00cd, 0x00cf, 0x00d2, 0x00d4,	\
	0x00d6, 0x00d8, 0x00da, 0x00dc, 0x00de,				\
}

#define	BWN_PHY_G_TSSI2DBM_TABLE					\
{									\
	77, 77, 77, 76, 76, 76, 75, 75, 74, 74, 73, 73, 73, 72, 72, 71,	\
	71, 70, 70, 69, 68, 68, 67, 67, 66, 65, 65, 64, 63, 63, 62, 61,	\
	60, 59, 58, 57, 56, 55, 54, 53, 52, 50, 49, 47, 45, 43, 40, 37,	\
	33, 28, 22, 14, 5, -7, -20, -20, -20, -20, -20, -20, -20, -20,	\
	-20, -20							\
}

#define	BWN_PHY_G_RF_CHANNELS						\
{									\
	12, 17, 22, 27, 32, 37, 42, 47, 52, 57, 62, 67, 72, 84,		\
}

#define	BWN_BITREV_TABLE						\
{									\
	0x00, 0x80, 0x40, 0xc0, 0x20, 0xa0, 0x60, 0xe0, 0x10, 0x90,	\
	0x50, 0xd0, 0x30, 0xb0, 0x70, 0xf0, 0x08, 0x88, 0x48, 0xc8,	\
	0x28, 0xa8, 0x68, 0xe8, 0x18, 0x98, 0x58, 0xd8, 0x38, 0xb8,	\
	0x78, 0xf8, 0x04, 0x84, 0x44, 0xc4, 0x24, 0xa4, 0x64, 0xe4,	\
	0x14, 0x94, 0x54, 0xd4, 0x34, 0xb4, 0x74, 0xf4, 0x0c, 0x8c,	\
	0x4c, 0xcc, 0x2c, 0xac, 0x6c, 0xec, 0x1c, 0x9c, 0x5c, 0xdc,	\
	0x3c, 0xbc, 0x7c, 0xfc, 0x02, 0x82, 0x42, 0xc2, 0x22, 0xa2,	\
	0x62, 0xe2, 0x12, 0x92, 0x52, 0xd2, 0x32, 0xb2, 0x72, 0xf2,	\
	0x0a, 0x8a, 0x4a, 0xca, 0x2a, 0xaa, 0x6a, 0xea, 0x1a, 0x9a,	\
	0x5a, 0xda, 0x3a, 0xba, 0x7a, 0xfa, 0x06, 0x86, 0x46, 0xc6,	\
	0x26, 0xa6, 0x66, 0xe6, 0x16, 0x96, 0x56, 0xd6, 0x36, 0xb6,	\
	0x76, 0xf6, 0x0e, 0x8e, 0x4e, 0xce, 0x2e, 0xae, 0x6e, 0xee,	\
	0x1e, 0x9e, 0x5e, 0xde, 0x3e, 0xbe, 0x7e, 0xfe, 0x01, 0x81,	\
	0x41, 0xc1, 0x21, 0xa1, 0x61, 0xe1, 0x11, 0x91, 0x51, 0xd1,	\
	0x31, 0xb1, 0x71, 0xf1, 0x09, 0x89, 0x49, 0xc9, 0x29, 0xa9,	\
	0x69, 0xe9, 0x19, 0x99, 0x59, 0xd9, 0x39, 0xb9, 0x79, 0xf9,	\
	0x05, 0x85, 0x45, 0xc5, 0x25, 0xa5, 0x65, 0xe5, 0x15, 0x95,	\
	0x55, 0xd5, 0x35, 0xb5, 0x75, 0xf5, 0x0d, 0x8d, 0x4d, 0xcd,	\
	0x2d, 0xad, 0x6d, 0xed, 0x1d, 0x9d, 0x5d, 0xdd, 0x3d, 0xbd,	\
	0x7d, 0xfd, 0x03, 0x83, 0x43, 0xc3, 0x23, 0xa3, 0x63, 0xe3,	\
	0x13, 0x93, 0x53, 0xd3, 0x33, 0xb3, 0x73, 0xf3, 0x0b, 0x8b,	\
	0x4b, 0xcb, 0x2b, 0xab, 0x6b, 0xeb, 0x1b, 0x9b, 0x5b, 0xdb,	\
	0x3b, 0xbb, 0x7b, 0xfb, 0x07, 0x87, 0x47, 0xc7, 0x27, 0xa7,	\
	0x67, 0xe7, 0x17, 0x97, 0x57, 0xd7, 0x37, 0xb7, 0x77, 0xf7,	\
	0x0f, 0x8f, 0x4f, 0xcf, 0x2f, 0xaf, 0x6f, 0xef, 0x1f, 0x9f,	\
	0x5f, 0xdf, 0x3f, 0xbf, 0x7f, 0xff				\
}

/*
 * LP PHY
 */

#define	BWN_TAB_TYPEMASK		0xf0000000
#define	BWN_TAB_GETTYPE(v)		((v) & BWN_TAB_TYPEMASK)
#define	BWN_TAB_GETOFFSET(v)		((v) & ~BWN_TAB_TYPEMASK)
#define	BWN_TAB_8BIT			0x10000000
#define	BWN_TAB_16BIT			0x20000000
#define	BWN_TAB_32BIT			0x30000000
#define	BWN_TAB_1(table, offset)			\
	(((table) << 10) | (offset) | BWN_TAB_8BIT)
#define	BWN_TAB_2(table, offset)			\
	(((table) << 10) | (offset) | BWN_TAB_16BIT)
#define	BWN_TAB_4(table, offset)			\
	(((table) << 10) | (offset) | BWN_TAB_32BIT)

#define	BWN_LP_RADIO(radio_reg)		(radio_reg)
#define	BWN_LP_NORTH(radio_reg)		BWN_LP_RADIO(radio_reg)
#define	BWN_LP_SOUTH(radio_reg)		BWN_LP_RADIO((radio_reg) | 0x4000)

#define	BWN_B2062_N_COM1		BWN_LP_NORTH(0x000)
#define	BWN_B2062_N_COM2		BWN_LP_NORTH(0x002)
#define	BWN_B2062_N_COM4		BWN_LP_NORTH(0x004)
#define	BWN_B2062_N_PDNCTL0		BWN_LP_NORTH(0x010)
#define	BWN_B2062_N_PDNCTL1		BWN_LP_NORTH(0x011)
#define	BWN_B2062_N_PDNCTL3		BWN_LP_NORTH(0x013)
#define	BWN_B2062_N_PDNCTL4		BWN_LP_NORTH(0x014)
#define	BWN_B2062_N_LGENC		BWN_LP_NORTH(0x017)
#define	BWN_B2062_N_LGENATUNE0		BWN_LP_NORTH(0x01E)
#define	BWN_B2062_N_LGENATUNE2		BWN_LP_NORTH(0x020)
#define	BWN_B2062_N_LGENATUNE3		BWN_LP_NORTH(0x021)
#define	BWN_B2062_N_LGENACTL3		BWN_LP_NORTH(0x022)
#define	BWN_B2062_N_LGENACTL5		BWN_LP_NORTH(0x024)
#define	BWN_B2062_N_LGENACTL6		BWN_LP_NORTH(0x025)
#define	BWN_B2062_N_LGENACTL7		BWN_LP_NORTH(0x026)
#define	BWN_B2062_N_RXA_CTL1		BWN_LP_NORTH(0x028)
#define	BWN_B2062_N_RXBB_CTL0		BWN_LP_NORTH(0x02F)
#define	BWN_B2062_N_RXBB_GAIN1		BWN_LP_NORTH(0x033)
#define	BWN_B2062_N_RXBB_GAIN2		BWN_LP_NORTH(0x034)
#define	BWN_B2062_N_RXBB_CALIB2		BWN_LP_NORTH(0x03A)
#define	BWN_B2062_N_TXCTL3		BWN_LP_NORTH(0x048)
#define	BWN_B2062_N_TXCTL4		BWN_LP_NORTH(0x049)
#define	BWN_B2062_N_TXCTL5		BWN_LP_NORTH(0x04A)
#define	BWN_B2062_N_TXCTL6		BWN_LP_NORTH(0x04B)
#define	BWN_B2062_N_TXCTL_A		BWN_LP_NORTH(0x04F)
#define	BWN_B2062_N_TX_TUNE		BWN_LP_NORTH(0x052)
#define	BWN_B2062_N_TX_PAD		BWN_LP_NORTH(0x053)
#define	BWN_B2062_N_TX_PGA		BWN_LP_NORTH(0x054)
#define	BWN_B2062_N_TSSI_CTL0		BWN_LP_NORTH(0x057)
#define	BWN_B2062_N_CALIB_TS		BWN_LP_NORTH(0x05D)
#define	BWN_B2062_S_COM4		BWN_LP_SOUTH(0x004)
#define	BWN_B2062_S_PDS_CTL0		BWN_LP_SOUTH(0x010)
#define	BWN_B2062_S_BG_CTL1		BWN_LP_SOUTH(0x015)
#define	BWN_B2062_S_LGENG_CTL0		BWN_LP_SOUTH(0x017)
#define	BWN_B2062_S_LGENG_CTL1		BWN_LP_SOUTH(0x018)
#define	BWN_B2062_S_LGENG_CTL8		BWN_LP_SOUTH(0x01F)
#define	BWN_B2062_S_LGENG_CTL10		BWN_LP_SOUTH(0x021)
#define	BWN_B2062_S_RFPLLCTL0		BWN_LP_SOUTH(0x034)
#define	BWN_B2062_S_RFPLLCTL1		BWN_LP_SOUTH(0x035)
#define	BWN_B2062_S_RFPLLCTL2		BWN_LP_SOUTH(0x036)
#define	BWN_B2062_S_RFPLLCTL3		BWN_LP_SOUTH(0x037)
#define	BWN_B2062_S_RFPLLCTL5		BWN_LP_SOUTH(0x039)
#define	BWN_B2062_S_RFPLLCTL6		BWN_LP_SOUTH(0x03A)
#define	BWN_B2062_S_RFPLLCTL7		BWN_LP_SOUTH(0x03B)
#define	BWN_B2062_S_RFPLLCTL8		BWN_LP_SOUTH(0x03C)
#define	BWN_B2062_S_RFPLLCTL9		BWN_LP_SOUTH(0x03D)
#define	BWN_B2062_S_RFPLLCTL10		BWN_LP_SOUTH(0x03E)
#define	BWN_B2062_S_RFPLLCTL11		BWN_LP_SOUTH(0x03F)
#define	BWN_B2062_S_RFPLLCTL12		BWN_LP_SOUTH(0x040)
#define	BWN_B2062_S_RFPLLCTL13		BWN_LP_SOUTH(0x041)
#define	BWN_B2062_S_RFPLLCTL14		BWN_LP_SOUTH(0x042)
#define	BWN_B2062_S_RFPLLCTL18		BWN_LP_SOUTH(0x046)
#define	BWN_B2062_S_RFPLLCTL19		BWN_LP_SOUTH(0x047)
#define	BWN_B2062_S_RFPLLCTL21		BWN_LP_SOUTH(0x049)
#define	BWN_B2062_S_RFPLLCTL22		BWN_LP_SOUTH(0x04A)
#define	BWN_B2062_S_RFPLLCTL23		BWN_LP_SOUTH(0x04B)
#define	BWN_B2062_S_RFPLLCTL24		BWN_LP_SOUTH(0x04C)
#define	BWN_B2062_S_RFPLLCTL25		BWN_LP_SOUTH(0x04D)
#define	BWN_B2062_S_RFPLLCTL26		BWN_LP_SOUTH(0x04E)
#define	BWN_B2062_S_RFPLLCTL27		BWN_LP_SOUTH(0x04F)
#define	BWN_B2062_S_RFPLLCTL28		BWN_LP_SOUTH(0x050)
#define	BWN_B2062_S_RFPLLCTL29		BWN_LP_SOUTH(0x051)
#define	BWN_B2062_S_RFPLLCTL30		BWN_LP_SOUTH(0x052)
#define	BWN_B2062_S_RFPLLCTL31		BWN_LP_SOUTH(0x053)
#define	BWN_B2062_S_RFPLLCTL33		BWN_LP_SOUTH(0x055)
#define	BWN_B2062_S_RFPLLCTL34		BWN_LP_SOUTH(0x056)
#define	BWN_B2062_S_RXG_CNT8		BWN_LP_SOUTH(0x05F)
#define	BWN_B2062_S_RXG_CNT16		BWN_LP_SOUTH(0x067)
#define	BWN_B2063_COM1			BWN_LP_RADIO(0x000)
#define	BWN_B2063_COM8			BWN_LP_RADIO(0x008)
#define	BWN_B2063_COM10			BWN_LP_RADIO(0x00A)
#define	BWN_B2063_COM15			BWN_LP_RADIO(0x00F)
#define	BWN_B2063_COM16			BWN_LP_RADIO(0x010)
#define	BWN_B2063_COM17			BWN_LP_RADIO(0x011)
#define	BWN_B2063_COM18			BWN_LP_RADIO(0x012)
#define	BWN_B2063_COM19			BWN_LP_RADIO(0x013)
#define	BWN_B2063_COM20			BWN_LP_RADIO(0x014)
#define	BWN_B2063_COM21			BWN_LP_RADIO(0x015)
#define	BWN_B2063_COM22			BWN_LP_RADIO(0x016)
#define	BWN_B2063_COM23			BWN_LP_RADIO(0x017)
#define	BWN_B2063_COM24			BWN_LP_RADIO(0x018)
#define	BWN_B2063_PLL_SP1		BWN_LP_RADIO(0x01A)
#define	BWN_B2063_PLL_SP2		BWN_LP_RADIO(0x01B)
#define	BWN_B2063_LOGEN_SP1		BWN_LP_RADIO(0x01C)
#define	BWN_B2063_LOGEN_SP2		BWN_LP_RADIO(0x01D)
#define	BWN_B2063_LOGEN_SP4		BWN_LP_RADIO(0x01F)
#define	BWN_B2063_LOGEN_SP5		BWN_LP_RADIO(0x020)
#define	BWN_B2063_G_RX_SP1		BWN_LP_RADIO(0x021)
#define	BWN_B2063_G_RX_SP2		BWN_LP_RADIO(0x022)
#define	BWN_B2063_G_RX_SP3		BWN_LP_RADIO(0x023)
#define	BWN_B2063_G_RX_SP7		BWN_LP_RADIO(0x027)
#define	BWN_B2063_G_RX_SP10		BWN_LP_RADIO(0x02A)
#define	BWN_B2063_A_RX_SP1		BWN_LP_RADIO(0x02C)
#define	BWN_B2063_A_RX_SP2		BWN_LP_RADIO(0x02D)
#define	BWN_B2063_A_RX_SP7		BWN_LP_RADIO(0x032)
#define	BWN_B2063_RX_BB_SP3		BWN_LP_RADIO(0x035)
#define	BWN_B2063_RX_BB_SP4		BWN_LP_RADIO(0x036)
#define	BWN_B2063_RX_BB_SP8		BWN_LP_RADIO(0x03A)
#define	BWN_B2063_TX_RF_SP3		BWN_LP_RADIO(0x03D)
#define	BWN_B2063_TX_RF_SP4		BWN_LP_RADIO(0x03E)
#define	BWN_B2063_TX_RF_SP6		BWN_LP_RADIO(0x040)
#define	BWN_B2063_TX_RF_SP9		BWN_LP_RADIO(0x043)
#define	BWN_B2063_PA_SP1		BWN_LP_RADIO(0x04C)
#define	BWN_B2063_PA_SP2		BWN_LP_RADIO(0x04D)
#define	BWN_B2063_PA_SP3		BWN_LP_RADIO(0x04E)
#define	BWN_B2063_PA_SP4		BWN_LP_RADIO(0x04F)
#define	BWN_B2063_PA_SP7		BWN_LP_RADIO(0x052)
#define	BWN_B2063_TX_BB_SP1		BWN_LP_RADIO(0x053)
#define	BWN_B2063_TX_BB_SP3		BWN_LP_RADIO(0x055)
#define	BWN_B2063_REG_SP1		BWN_LP_RADIO(0x056)
#define	BWN_B2063_BANDGAP_CTL1		BWN_LP_RADIO(0x057)
#define	BWN_B2063_RC_CALIB_CTL1		BWN_LP_RADIO(0x05A)
#define	BWN_B2063_RC_CALIB_CTL2		BWN_LP_RADIO(0x05B)
#define	BWN_B2063_RC_CALIB_CTL3		BWN_LP_RADIO(0x05C)
#define	BWN_B2063_RC_CALIB_CTL4		BWN_LP_RADIO(0x05D)
#define	BWN_B2063_RC_CALIB_CTL5		BWN_LP_RADIO(0x05E)
#define	BWN_B2063_RC_CALIB_CTL6		BWN_LP_RADIO(0x05F)
#define	BWN_B2063_JTAG_CALNRST		BWN_LP_RADIO(0x064)
#define	BWN_B2063_JTAG_CP2		BWN_LP_RADIO(0x068)
#define	BWN_B2063_JTAG_CP3		BWN_LP_RADIO(0x069)
#define	BWN_B2063_JTAG_LF1		BWN_LP_RADIO(0x06C)
#define	BWN_B2063_JTAG_LF2		BWN_LP_RADIO(0x06D)
#define	BWN_B2063_JTAG_LF3		BWN_LP_RADIO(0x06E)
#define	BWN_B2063_JTAG_LF4		BWN_LP_RADIO(0x06F)
#define	BWN_B2063_JTAG_SG1		BWN_LP_RADIO(0x070)
#define	BWN_B2063_JTAG_SG2		BWN_LP_RADIO(0x071)
#define	BWN_B2063_JTAG_SG3		BWN_LP_RADIO(0x072)
#define	BWN_B2063_JTAG_SG4		BWN_LP_RADIO(0x073)
#define	BWN_B2063_JTAG_VCO1		BWN_LP_RADIO(0x075)
#define	BWN_B2063_JTAG_VCO2		BWN_LP_RADIO(0x076)
#define	BWN_B2063_JTAG_VCO_CALIB3	BWN_LP_RADIO(0x079)
#define	BWN_B2063_JTAG_VCO_CALIB5	BWN_LP_RADIO(0x07B)
#define	BWN_B2063_JTAG_VCO_CALIB6	BWN_LP_RADIO(0x07C)
#define	BWN_B2063_JTAG_VCO_CALIB7	BWN_LP_RADIO(0x07D)
#define	BWN_B2063_JTAG_VCO_CALIB8	BWN_LP_RADIO(0x07E)
#define	BWN_B2063_JTAG_XTAL_12		BWN_LP_RADIO(0x081)
#define	BWN_B2063_LOGEN_RCCR1		BWN_LP_RADIO(0x0A1)
#define	BWN_B2063_LOGEN_VCOBUF1		BWN_LP_RADIO(0x0A2)
#define	BWN_B2063_LOGEN_MIXER2		BWN_LP_RADIO(0x0A4)
#define	BWN_B2063_LOGEN_BUF2		BWN_LP_RADIO(0x0A6)
#define	BWN_B2063_G_RX_MIX3		BWN_LP_RADIO(0x0C4)
#define	BWN_B2063_G_RX_MIX4		BWN_LP_RADIO(0x0C5)
#define	BWN_B2063_A_RX_1ST2		BWN_LP_RADIO(0x0CF)
#define	BWN_B2063_A_RX_1ST3		BWN_LP_RADIO(0x0D0)
#define	BWN_B2063_A_RX_2ND1		BWN_LP_RADIO(0x0D3)
#define	BWN_B2063_A_RX_2ND4		BWN_LP_RADIO(0x0D6)
#define	BWN_B2063_A_RX_2ND7		BWN_LP_RADIO(0x0D9)
#define	BWN_B2063_A_RX_PS6		BWN_LP_RADIO(0x0DF)
#define	BWN_B2063_A_RX_MIX4		BWN_LP_RADIO(0x0E3)
#define	BWN_B2063_A_RX_MIX5		BWN_LP_RADIO(0x0E4)
#define	BWN_B2063_A_RX_MIX6		BWN_LP_RADIO(0x0E5)
#define	BWN_B2063_RX_TIA_CTL1		BWN_LP_RADIO(0x0EC)
#define	BWN_B2063_RX_TIA_CTL3		BWN_LP_RADIO(0x0EE)
#define	BWN_B2063_RX_BB_CTL2		BWN_LP_RADIO(0x0F3)
#define	BWN_B2063_TX_RF_CTL2		BWN_LP_RADIO(0x100)
#define	BWN_B2063_TX_RF_CTL5		BWN_LP_RADIO(0x103)
#define	BWN_B2063_PA_CTL1		BWN_LP_RADIO(0x10B)
#define	BWN_B2063_PA_CTL11		BWN_LP_RADIO(0x115)
#define	BWN_B2063_VREG_CTL1		BWN_LP_RADIO(0x11D)

/* N-PHY, etc TX configuration */

#define	BWN_TXH_PHY1_BW			0x0007 /* Bandwidth */
#define	 BWN_TXH_PHY1_BW_10		0x0000 /* 10 MHz */
#define	 BWN_TXH_PHY1_BW_10U		0x0001 /* 10 MHz upper */
#define	 BWN_TXH_PHY1_BW_20		0x0002 /* 20 MHz */
#define	 BWN_TXH_PHY1_BW_20U		0x0003 /* 20 MHz upper */
#define	 BWN_TXH_PHY1_BW_40		0x0004 /* 40 MHz */
#define	 BWN_TXH_PHY1_BW_40DUP		0x0005 /* 40 MHz duplicate */
#define	BWN_TXH_PHY1_MODE		0x0038 /* Mode */
#define	 BWN_TXH_PHY1_MODE_SISO		0x0000 /* SISO */
#define	 BWN_TXH_PHY1_MODE_CDD		0x0008 /* CDD */
#define	 BWN_TXH_PHY1_MODE_STBC		0x0010 /* STBC */
#define	 BWN_TXH_PHY1_MODE_SDM		0x0018 /* SDM */
#define	BWN_TXH_PHY1_CRATE		0x0700 /* Coding rate */
#define	 BWN_TXH_PHY1_CRATE_1_2		0x0000 /* 1/2 */
#define	 BWN_TXH_PHY1_CRATE_2_3		0x0100 /* 2/3 */
#define	 BWN_TXH_PHY1_CRATE_3_4		0x0200 /* 3/4 */
#define	 BWN_TXH_PHY1_CRATE_4_5		0x0300 /* 4/5 */
#define	 BWN_TXH_PHY1_CRATE_5_6		0x0400 /* 5/6 */
#define	 BWN_TXH_PHY1_CRATE_7_8		0x0600 /* 7/8 */
#define	BWN_TXH_PHY1_MODUL		0x3800 /* Modulation scheme */
#define	 BWN_TXH_PHY1_MODUL_BPSK	0x0000 /* BPSK */
#define	 BWN_TXH_PHY1_MODUL_QPSK	0x0800 /* QPSK */
#define	 BWN_TXH_PHY1_MODUL_QAM16	0x1000 /* QAM16 */
#define	 BWN_TXH_PHY1_MODUL_QAM64	0x1800 /* QAM64 */
#define	 BWN_TXH_PHY1_MODUL_QAM256	0x2000 /* QAM256 */

#endif	/* !_IF_BWNREG_H */
