/*-
 * Copyright (c) 2015,2016 Annapurna Labs Ltd. and affiliates
 * All rights reserved.
 *
 * Developed by Semihalf.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/12/sys/arm/annapurna/alpine/alpine_serdes.h 307669 2016-10-20 11:26:51Z wma $
 */

#ifndef __ALPINE_SERDES_H__
#define __ALPINE_SERDES_H__

/* SerDes ETH mode */
enum alpine_serdes_eth_mode {
	ALPINE_SERDES_ETH_MODE_SGMII,
	ALPINE_SERDES_ETH_MODE_KR,
};

/*
 * Get SerDes group regs base, to be used in relevant Alpine drivers.
 * Valid group is 0..3.
 * Returns virtual base address of the group regs base.
 */
void *alpine_serdes_resource_get(uint32_t group);

/*
 * Set SerDes ETH mode for an entire group, unless already set
 * Valid group is 0..3.
 * Returns 0 upon success.
 */
int alpine_serdes_eth_mode_set(uint32_t group,
    enum alpine_serdes_eth_mode mode);

/* Lock the all serdes group for using common registers */
void alpine_serdes_eth_group_lock(uint32_t group);

/* Unlock the all serdes group for using common registers */
void alpine_serdes_eth_group_unlock(uint32_t group);

#endif /* __ALPINE_SERDES_H__ */
