/*-
 * SPDX-License-Identifier: BSD-3-Clause
 *
 * Copyright (c) 2017-2019 Mellanox Technologies.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Mellanox nor the names of contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/11/sys/dev/mlxfw/mlxfw_mfa2_file.h 347285 2019-05-08 10:49:05Z hselasky $
 */

#ifndef _MLXFW_MFA2_FILE_H
#define _MLXFW_MFA2_FILE_H

#include "mlxfw.h"
#include <linux/kernel.h>

struct mlxfw_mfa2_file {
	const struct firmware *fw;
	const struct mlxfw_mfa2_tlv *first_dev;
	u16 dev_count;
	const struct mlxfw_mfa2_tlv *first_component;
	u16 component_count;
	const void *cb; /* components block */
	u32 cb_archive_size; /* size of compressed components block */
};

static inline bool mlxfw_mfa2_valid_ptr(const struct mlxfw_mfa2_file *mfa2_file,
					const u8 *ptr)
{
	const u8 *valid_to = (const u8 *) mfa2_file->fw->data + mfa2_file->fw->datasize;
	const u8 *valid_from = mfa2_file->fw->data;

	return ptr > valid_from && ptr < valid_to;
}

#endif
