// Copyright (c) 2016 Nuxi (https://nuxi.nl/) and contributors.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
// This file is automatically generated. Do not edit.
//
// Source: https://github.com/NuxiNL/cloudabi

#define ENTRY(name)      \
  .text;                 \
  .p2align 2;            \
  .global name;          \
  .type name, %function; \
name:

#define END(name) .size name, . - name

ENTRY(cloudabi_sys_clock_res_get)
  str r1, [sp, #-4]
  mov ip, #0
  swi 0
  ldrcc r2, [sp, #-4]
  strcc r0, [r2, 0]
  strcc r1, [r2, 4]
  movcc r0, $0
  bx lr
END(cloudabi_sys_clock_res_get)

ENTRY(cloudabi_sys_clock_time_get)
  mov ip, #1
  swi 0
  ldrcc r2, [sp, #0]
  strcc r0, [r2, 0]
  strcc r1, [r2, 4]
  movcc r0, $0
  bx lr
END(cloudabi_sys_clock_time_get)

ENTRY(cloudabi_sys_condvar_signal)
  mov ip, #2
  swi 0
  bx lr
END(cloudabi_sys_condvar_signal)

ENTRY(cloudabi_sys_fd_close)
  mov ip, #3
  swi 0
  bx lr
END(cloudabi_sys_fd_close)

ENTRY(cloudabi_sys_fd_create1)
  str r1, [sp, #-4]
  mov ip, #4
  swi 0
  ldrcc r2, [sp, #-4]
  strcc r0, [r2]
  movcc r0, $0
  bx lr
END(cloudabi_sys_fd_create1)

ENTRY(cloudabi_sys_fd_create2)
  str r1, [sp, #-4]
  str r2, [sp, #-8]
  mov ip, #5
  swi 0
  ldrcc r2, [sp, #-4]
  ldrcc r3, [sp, #-8]
  strcc r0, [r2]
  strcc r1, [r3]
  movcc r0, $0
  bx lr
END(cloudabi_sys_fd_create2)

ENTRY(cloudabi_sys_fd_datasync)
  mov ip, #6
  swi 0
  bx lr
END(cloudabi_sys_fd_datasync)

ENTRY(cloudabi_sys_fd_dup)
  str r1, [sp, #-4]
  mov ip, #7
  swi 0
  ldrcc r2, [sp, #-4]
  strcc r0, [r2]
  movcc r0, $0
  bx lr
END(cloudabi_sys_fd_dup)

ENTRY(cloudabi_sys_fd_pread)
  mov ip, #8
  swi 0
  ldrcc r2, [sp, #8]
  strcc r0, [r2]
  movcc r0, $0
  bx lr
END(cloudabi_sys_fd_pread)

ENTRY(cloudabi_sys_fd_pwrite)
  mov ip, #9
  swi 0
  ldrcc r2, [sp, #8]
  strcc r0, [r2]
  movcc r0, $0
  bx lr
END(cloudabi_sys_fd_pwrite)

ENTRY(cloudabi_sys_fd_read)
  str r3, [sp, #-4]
  mov ip, #10
  swi 0
  ldrcc r2, [sp, #-4]
  strcc r0, [r2]
  movcc r0, $0
  bx lr
END(cloudabi_sys_fd_read)

ENTRY(cloudabi_sys_fd_replace)
  mov ip, #11
  swi 0
  bx lr
END(cloudabi_sys_fd_replace)

ENTRY(cloudabi_sys_fd_seek)
  mov ip, #12
  swi 0
  ldrcc r2, [sp, #4]
  strcc r0, [r2, 0]
  strcc r1, [r2, 4]
  movcc r0, $0
  bx lr
END(cloudabi_sys_fd_seek)

ENTRY(cloudabi_sys_fd_stat_get)
  mov ip, #13
  swi 0
  bx lr
END(cloudabi_sys_fd_stat_get)

ENTRY(cloudabi_sys_fd_stat_put)
  mov ip, #14
  swi 0
  bx lr
END(cloudabi_sys_fd_stat_put)

ENTRY(cloudabi_sys_fd_sync)
  mov ip, #15
  swi 0
  bx lr
END(cloudabi_sys_fd_sync)

ENTRY(cloudabi_sys_fd_write)
  str r3, [sp, #-4]
  mov ip, #16
  swi 0
  ldrcc r2, [sp, #-4]
  strcc r0, [r2]
  movcc r0, $0
  bx lr
END(cloudabi_sys_fd_write)

ENTRY(cloudabi_sys_file_advise)
  mov ip, #17
  swi 0
  bx lr
END(cloudabi_sys_file_advise)

ENTRY(cloudabi_sys_file_allocate)
  mov ip, #18
  swi 0
  bx lr
END(cloudabi_sys_file_allocate)

ENTRY(cloudabi_sys_file_create)
  mov ip, #19
  swi 0
  bx lr
END(cloudabi_sys_file_create)

ENTRY(cloudabi_sys_file_link)
  mov ip, #20
  swi 0
  bx lr
END(cloudabi_sys_file_link)

ENTRY(cloudabi_sys_file_open)
  mov ip, #21
  swi 0
  ldrcc r2, [sp, #8]
  strcc r0, [r2]
  movcc r0, $0
  bx lr
END(cloudabi_sys_file_open)

ENTRY(cloudabi_sys_file_readdir)
  mov ip, #22
  swi 0
  ldrcc r2, [sp, #8]
  strcc r0, [r2]
  movcc r0, $0
  bx lr
END(cloudabi_sys_file_readdir)

ENTRY(cloudabi_sys_file_readlink)
  mov ip, #23
  swi 0
  ldrcc r2, [sp, #4]
  strcc r0, [r2]
  movcc r0, $0
  bx lr
END(cloudabi_sys_file_readlink)

ENTRY(cloudabi_sys_file_rename)
  mov ip, #24
  swi 0
  bx lr
END(cloudabi_sys_file_rename)

ENTRY(cloudabi_sys_file_stat_fget)
  mov ip, #25
  swi 0
  bx lr
END(cloudabi_sys_file_stat_fget)

ENTRY(cloudabi_sys_file_stat_fput)
  mov ip, #26
  swi 0
  bx lr
END(cloudabi_sys_file_stat_fput)

ENTRY(cloudabi_sys_file_stat_get)
  mov ip, #27
  swi 0
  bx lr
END(cloudabi_sys_file_stat_get)

ENTRY(cloudabi_sys_file_stat_put)
  mov ip, #28
  swi 0
  bx lr
END(cloudabi_sys_file_stat_put)

ENTRY(cloudabi_sys_file_symlink)
  mov ip, #29
  swi 0
  bx lr
END(cloudabi_sys_file_symlink)

ENTRY(cloudabi_sys_file_unlink)
  mov ip, #30
  swi 0
  bx lr
END(cloudabi_sys_file_unlink)

ENTRY(cloudabi_sys_lock_unlock)
  mov ip, #31
  swi 0
  bx lr
END(cloudabi_sys_lock_unlock)

ENTRY(cloudabi_sys_mem_advise)
  mov ip, #32
  swi 0
  bx lr
END(cloudabi_sys_mem_advise)

ENTRY(cloudabi_sys_mem_map)
  mov ip, #33
  swi 0
  ldrcc r2, [sp, #16]
  strcc r0, [r2]
  movcc r0, $0
  bx lr
END(cloudabi_sys_mem_map)

ENTRY(cloudabi_sys_mem_protect)
  mov ip, #34
  swi 0
  bx lr
END(cloudabi_sys_mem_protect)

ENTRY(cloudabi_sys_mem_sync)
  mov ip, #35
  swi 0
  bx lr
END(cloudabi_sys_mem_sync)

ENTRY(cloudabi_sys_mem_unmap)
  mov ip, #36
  swi 0
  bx lr
END(cloudabi_sys_mem_unmap)

ENTRY(cloudabi_sys_poll)
  str r3, [sp, #-4]
  mov ip, #37
  swi 0
  ldrcc r2, [sp, #-4]
  strcc r0, [r2]
  movcc r0, $0
  bx lr
END(cloudabi_sys_poll)

ENTRY(cloudabi_sys_proc_exec)
  mov ip, #38
  swi 0
  bx lr
END(cloudabi_sys_proc_exec)

ENTRY(cloudabi_sys_proc_exit)
  mov ip, #39
  swi 0
END(cloudabi_sys_proc_exit)

ENTRY(cloudabi_sys_proc_fork)
  str r0, [sp, #-4]
  str r1, [sp, #-8]
  mov ip, #40
  swi 0
  ldrcc r2, [sp, #-4]
  ldrcc r3, [sp, #-8]
  strcc r0, [r2]
  strcc r1, [r3]
  movcc r0, $0
  bx lr
END(cloudabi_sys_proc_fork)

ENTRY(cloudabi_sys_proc_raise)
  mov ip, #41
  swi 0
  bx lr
END(cloudabi_sys_proc_raise)

ENTRY(cloudabi_sys_random_get)
  mov ip, #42
  swi 0
  bx lr
END(cloudabi_sys_random_get)

ENTRY(cloudabi_sys_sock_recv)
  mov ip, #43
  swi 0
  bx lr
END(cloudabi_sys_sock_recv)

ENTRY(cloudabi_sys_sock_send)
  mov ip, #44
  swi 0
  bx lr
END(cloudabi_sys_sock_send)

ENTRY(cloudabi_sys_sock_shutdown)
  mov ip, #45
  swi 0
  bx lr
END(cloudabi_sys_sock_shutdown)

ENTRY(cloudabi_sys_thread_create)
  str r1, [sp, #-4]
  mov ip, #46
  swi 0
  ldrcc r2, [sp, #-4]
  strcc r0, [r2]
  movcc r0, $0
  bx lr
END(cloudabi_sys_thread_create)

ENTRY(cloudabi_sys_thread_exit)
  mov ip, #47
  swi 0
END(cloudabi_sys_thread_exit)

ENTRY(cloudabi_sys_thread_yield)
  mov ip, #48
  swi 0
  bx lr
END(cloudabi_sys_thread_yield)
