#
# $FreeBSD: stable/10/ObsoleteFiles.inc 326918 2017-12-17 06:00:49Z cy $
#
# This file lists old files (OLD_FILES), libraries (OLD_LIBS) and
# directories (OLD_DIRS) which should get removed at an update. Recently
# removed entries first (with the date as a comment). Dynamic libraries are
# special cased (OLD_LIBS). Static libraries or the generic links to
# the dynamic libraries (lib*.so) should (if you don't know why to make an
# exception, make this a "must") be viewed as normal files (OLD_FILES).
#
# In case of a complete directory hierarchy the sorting is in depth first
# order.
#
# The file is partitioned: OLD_FILES first, then OLD_LIBS and OLD_DIRS last.
#
# Before you commit changes to this file please check if any entries in
# tools/build/mk/OptionalObsoleteFiles.inc can be removed. The following
# command tells which files are listed more than once regardless of some
# architecture specific conditionals, so you can not blindly trust the
# output:
# ( grep '+=' /usr/src/ObsoleteFiles.inc | sort -u ; \
# grep '+=' /usr/src/tools/build/mk/OptionalObsoleteFiles.inc | sort -u) | \
# sort | uniq -d
#
# To find regular duplicates not dependant on optional components, you can
# also use something that will not give you false positives, e.g.:
# for t in `make -V TARGETS universe`; do
#   __MAKE_CONF=/dev/null make -f Makefile.inc1 TARGET=$t \
#   -V OLD_FILES -V OLD_LIBS -V OLD_DIRS check-old | \
#   xargs -n1 | sort | uniq -d;
# done
#
# For optional components, you can use the following to see if some entries
# in OptionalObsoleteFiles.inc have been obsoleted by ObsoleteFiles.inc
# for o in tools/build/options/WITH*; do
#   __MAKE_CONF=/dev/null make -f Makefile.inc1 -D${o##*/} \
#   -V OLD_FILES -V OLD_LIBS -V OLD_DIRS check-old | \
#   xargs -n1 | sort | uniq -d;
# done

# 20171204: Move fdformat man page from volume 1 to volume 8.
OLD_FILES+=usr/share/man/man1/fdformat.1.gz
# 20170620: remove stale manpage
OLD_FILES+=usr/share/man/man2/cap_rights_get.2.gz
# 20170610: chown-f_test replaced by chown_test
OLD_FILES+=usr/tests/usr.sbin/chown/chown-f_test
# 20170322: rename <x> to <x>_test to match the FreeBSD test suite name scheme
OLD_FILES+=usr/tests/usr.bin/col/col
OLD_FILES+=usr/tests/usr.sbin/pw/pw_config
OLD_FILES+=usr/tests/usr.sbin/pw/pw_etcdir
OLD_FILES+=usr/tests/usr.sbin/pw/pw_groupadd
OLD_FILES+=usr/tests/usr.sbin/pw/pw_groupdel
OLD_FILES+=usr/tests/usr.sbin/pw/pw_groupmod
OLD_FILES+=usr/tests/usr.sbin/pw/pw_lock
OLD_FILES+=usr/tests/usr.sbin/pw/pw_useradd
OLD_FILES+=usr/tests/usr.sbin/pw/pw_userdel
OLD_FILES+=usr/tests/usr.sbin/pw/pw_usermod
OLD_FILES+=usr/tests/usr.sbin/pw/pw_usernext
# 20170214: Four files from ggate tests consolidated into one
OLD_FILES+=usr/tests/sys/geom/class/gate/1_test
OLD_FILES+=usr/tests/sys/geom/class/gate/2_test
OLD_FILES+=usr/tests/sys/geom/class/gate/3_test
OLD_FILES+=usr/tests/sys/geom/class/gate/conf.sh
# 20170211: libarchive ACL pax test renamed to test_acl_pax_posix1e.tar.uu
OLD_FILES+=usr/tests/lib/libarchive/test_acl_pax.tar.uu
# 20161229: Three files from gnop tests consolidated into one
OLD_FILES+=usr/tests/sys/geom/class/nop/1_test
OLD_FILES+=usr/tests/sys/geom/class/nop/2_test
OLD_FILES+=usr/tests/sys/geom/class/nop/conf.sh
# 20161121: Hyper-V manuals only apply to amd64 and i386.
.if ${TARGET_ARCH} != "amd64" && ${TARGET_ARCH} != "i386"
OLD_FILES+=usr/share/man/man4/hv_kvp.4.gz
OLD_FILES+=usr/share/man/man4/hv_netvsc.4.gz
OLD_FILES+=usr/share/man/man4/hv_storvsc.4.gz
OLD_FILES+=usr/share/man/man4/hv_utils.4.gz
OLD_FILES+=usr/share/man/man4/hv_vmbus.4.gz
OLD_FILES+=usr/share/man/man4/hv_vss.4.gz
.endif
# 20161118: Remove hv_ata_pci_disengage(4)
OLD_FILES+=usr/share/man/man4/hv_ata_pci_disengage.4.gz
# 20160906: libkqueue tests moved to /usr/tests/sys/kqueue/libkqueue
OLD_FILES+=usr/tests/sys/kqueue/kqtest
OLD_FILES+=usr/tests/sys/kqueue/kqueue_test
# 20160723: stale MLINK removed
OLD_FILES+=usr/share/man/man9/rman_await_resource.9.gz
# 20160216: Remove obsolete unbound-control-setup
OLD_FILES+=usr/sbin/unbound-control-setup
# 20151222: liblzma header
OLD_FILES+=usr/include/lzma/lzma.h
# 20151115: added missing _test suffix on multiple tests in lib/libc
OLD_FILES+=usr/tests/lib/libc/c063/faccessat
OLD_FILES+=usr/tests/lib/libc/c063/fchmodat
OLD_FILES+=usr/tests/lib/libc/c063/fchownat
OLD_FILES+=usr/tests/lib/libc/c063/fexecve
OLD_FILES+=usr/tests/lib/libc/c063/fstatat
OLD_FILES+=usr/tests/lib/libc/c063/linkat
OLD_FILES+=usr/tests/lib/libc/c063/mkdirat
OLD_FILES+=usr/tests/lib/libc/c063/mkfifoat
OLD_FILES+=usr/tests/lib/libc/c063/mknodat
OLD_FILES+=usr/tests/lib/libc/c063/openat
OLD_FILES+=usr/tests/lib/libc/c063/readlinkat
OLD_FILES+=usr/tests/lib/libc/c063/renameat
OLD_FILES+=usr/tests/lib/libc/c063/symlinkat
OLD_FILES+=usr/tests/lib/libc/c063/unlinkat
OLD_FILES+=usr/tests/lib/libc/string/memchr
OLD_FILES+=usr/tests/lib/libc/string/memcpy
OLD_FILES+=usr/tests/lib/libc/string/memmem
OLD_FILES+=usr/tests/lib/libc/string/memset
OLD_FILES+=usr/tests/lib/libc/string/strcat
OLD_FILES+=usr/tests/lib/libc/string/strchr
OLD_FILES+=usr/tests/lib/libc/string/strcmp
OLD_FILES+=usr/tests/lib/libc/string/strcpy
OLD_FILES+=usr/tests/lib/libc/string/strcspn
OLD_FILES+=usr/tests/lib/libc/string/strerror
OLD_FILES+=usr/tests/lib/libc/string/strlen
OLD_FILES+=usr/tests/lib/libc/string/strpbrk
OLD_FILES+=usr/tests/lib/libc/string/strrchr
OLD_FILES+=usr/tests/lib/libc/string/strspn
OLD_FILES+=usr/tests/lib/libc/string/swab
# 20151025: remove links to removed/unimplemented mbuf(9) macros
OLD_FILES+=usr/share/man/man9/MEXT_ADD_REF.9.gz
OLD_FILES+=usr/share/man/man9/MEXTFREE.9.gz
OLD_FILES+=usr/share/man/man9/MEXT_IS_REF.9.gz
OLD_FILES+=usr/share/man/man9/MEXT_REM_REF.9.gz
OLD_FILES+=usr/share/man/man9/MFREE.9.gz
# 20151023: unused sgsmsg utility is removed
OLD_FILES+=usr/bin/sgsmsg
# 20150506
OLD_FILES+=usr/share/man/man9/NDHASGIANT.9.gz
# 20141223: remove in6_gif.h and in_gif.h
OLD_FILES+=usr/include/netinet/in_gif.h
OLD_FILES+=usr/include/netinet6/in6_gif.h
# 20141205: convert sbin/mdconfig/tests to ATF format tests
OLD_FILES+=usr/tests/sbin/mdconfig/legacy_test
OLD_FILES+=usr/tests/sbin/mdconfig/mdconfig.test
OLD_FILES+=usr/tests/sbin/mdconfig/run.pl
# 20141107: overhaul if_gre(4)
OLD_FILES+=usr/include/netinet/ip_gre.h
# 20141028: debug files accidentally installed as directory name
OLD_FILES+=usr/lib/debug/usr/lib/i18n
OLD_FILES+=usr/lib/debug/usr/lib/private
OLD_FILES+=usr/lib/debug/usr/lib32/i18n
OLD_FILES+=usr/lib/debug/usr/lib32/private
# 20141015: OpenSSL 1.0.1j import
OLD_FILES+=usr/share/openssl/man/man3/CMS_sign_add1_signer.3.gz
# 20141010: rc.d/kerberos removed
OLD_FILES+=etc/rc.d/kerberos
# 20140922: sleepq_calc_signal_retval.9 and sleepq_catch_signals.9 removed
OLD_FILES+=usr/share/man/man9/sleepq_calc_signal_retval.9.gz
OLD_FILES+=usr/share/man/man9/sleepq_catch_signals.9.gz
# 20140917: hv_kvpd rc.d script removed in favor of devd configuration
OLD_FILES+=etc/rc.d/hv_kvpd
# 20140814: libopie version bump
OLD_LIBS+=usr/lib/libopie.so.8
OLD_LIBS+=usr/lib32/libopie.so.8
# 20140811: otp-sha renamed to otp-sha1
OLD_FILES+=usr/bin/otp-sha
OLD_FILES+=usr/share/man/man1/otp-sha.1.gz
# 20140812: example files removed
OLD_FILES+=usr/share/examples/libusb20/aux.c
OLD_FILES+=usr/share/examples/libusb20/aux.h
# 20140803: Remove an obsolete man page
OLD_FILES+=usr/share/man/man9/pmap_change_wiring.9.gz
# 20140728: Remove an obsolete man page
OLD_FILES+=usr/share/man/man9/VOP_GETVOBJECT.9.gz
OLD_FILES+=usr/share/man/man9/VOP_CREATEVOBJECT.9.gz
OLD_FILES+=usr/share/man/man9/VOP_DESTROYVOBJECT.9.gz
# 20140625: csup example files removal
OLD_FILES+=usr/share/examples/cvsup/README
OLD_FILES+=usr/share/examples/cvsup/cvs-supfile
OLD_FILES+=usr/share/examples/cvsup/stable-supfile
OLD_FILES+=usr/share/examples/cvsup/standard-supfile
OLD_DIRS+=usr/share/examples/cvsup
# 20140614: send-pr removal
OLD_FILES+=usr/bin/sendbug
OLD_FILES+=usr/share/info/send-pr.info.gz
OLD_FILES+=usr/share/man/man1/send-pr.1.gz
OLD_FILES+=usr/share/man/man1/sendbug.1.gz
OLD_FILES+=etc/gnats/freefall
OLD_DIRS+=etc/gnats
# 20140512: new clang import which bumps version from 3.4 to 3.4.1.
OLD_FILES+=usr/include/clang/3.4/__wmmintrin_aes.h
OLD_FILES+=usr/include/clang/3.4/__wmmintrin_pclmul.h
OLD_FILES+=usr/include/clang/3.4/altivec.h
OLD_FILES+=usr/include/clang/3.4/ammintrin.h
OLD_FILES+=usr/include/clang/3.4/avx2intrin.h
OLD_FILES+=usr/include/clang/3.4/avxintrin.h
OLD_FILES+=usr/include/clang/3.4/bmi2intrin.h
OLD_FILES+=usr/include/clang/3.4/bmiintrin.h
OLD_FILES+=usr/include/clang/3.4/cpuid.h
OLD_FILES+=usr/include/clang/3.4/emmintrin.h
OLD_FILES+=usr/include/clang/3.4/f16cintrin.h
OLD_FILES+=usr/include/clang/3.4/fma4intrin.h
OLD_FILES+=usr/include/clang/3.4/fmaintrin.h
OLD_FILES+=usr/include/clang/3.4/immintrin.h
OLD_FILES+=usr/include/clang/3.4/lzcntintrin.h
OLD_FILES+=usr/include/clang/3.4/mm3dnow.h
OLD_FILES+=usr/include/clang/3.4/mm_malloc.h
OLD_FILES+=usr/include/clang/3.4/mmintrin.h
OLD_FILES+=usr/include/clang/3.4/module.map
OLD_FILES+=usr/include/clang/3.4/nmmintrin.h
OLD_FILES+=usr/include/clang/3.4/pmmintrin.h
OLD_FILES+=usr/include/clang/3.4/popcntintrin.h
OLD_FILES+=usr/include/clang/3.4/prfchwintrin.h
OLD_FILES+=usr/include/clang/3.4/rdseedintrin.h
OLD_FILES+=usr/include/clang/3.4/rtmintrin.h
OLD_FILES+=usr/include/clang/3.4/shaintrin.h
OLD_FILES+=usr/include/clang/3.4/smmintrin.h
OLD_FILES+=usr/include/clang/3.4/tbmintrin.h
OLD_FILES+=usr/include/clang/3.4/tmmintrin.h
OLD_FILES+=usr/include/clang/3.4/wmmintrin.h
OLD_FILES+=usr/include/clang/3.4/x86intrin.h
OLD_FILES+=usr/include/clang/3.4/xmmintrin.h
OLD_FILES+=usr/include/clang/3.4/xopintrin.h
OLD_FILES+=usr/include/clang/3.4/arm_neon.h
OLD_FILES+=usr/include/clang/3.4/module.map
OLD_DIRS+=usr/include/clang/3.4
# 20140321: new clang import which bumps version from 3.3 to 3.4.
OLD_FILES+=usr/bin/llvm-prof
OLD_FILES+=usr/bin/llvm-ranlib
OLD_FILES+=usr/include/clang/3.3/__wmmintrin_aes.h
OLD_FILES+=usr/include/clang/3.3/__wmmintrin_pclmul.h
OLD_FILES+=usr/include/clang/3.3/altivec.h
OLD_FILES+=usr/include/clang/3.3/ammintrin.h
OLD_FILES+=usr/include/clang/3.3/avx2intrin.h
OLD_FILES+=usr/include/clang/3.3/avxintrin.h
OLD_FILES+=usr/include/clang/3.3/bmi2intrin.h
OLD_FILES+=usr/include/clang/3.3/bmiintrin.h
OLD_FILES+=usr/include/clang/3.3/cpuid.h
OLD_FILES+=usr/include/clang/3.3/emmintrin.h
OLD_FILES+=usr/include/clang/3.3/f16cintrin.h
OLD_FILES+=usr/include/clang/3.3/fma4intrin.h
OLD_FILES+=usr/include/clang/3.3/fmaintrin.h
OLD_FILES+=usr/include/clang/3.3/immintrin.h
OLD_FILES+=usr/include/clang/3.3/lzcntintrin.h
OLD_FILES+=usr/include/clang/3.3/mm3dnow.h
OLD_FILES+=usr/include/clang/3.3/mm_malloc.h
OLD_FILES+=usr/include/clang/3.3/mmintrin.h
OLD_FILES+=usr/include/clang/3.3/module.map
OLD_FILES+=usr/include/clang/3.3/nmmintrin.h
OLD_FILES+=usr/include/clang/3.3/pmmintrin.h
OLD_FILES+=usr/include/clang/3.3/popcntintrin.h
OLD_FILES+=usr/include/clang/3.3/prfchwintrin.h
OLD_FILES+=usr/include/clang/3.3/rdseedintrin.h
OLD_FILES+=usr/include/clang/3.3/rtmintrin.h
OLD_FILES+=usr/include/clang/3.3/smmintrin.h
OLD_FILES+=usr/include/clang/3.3/tmmintrin.h
OLD_FILES+=usr/include/clang/3.3/wmmintrin.h
OLD_FILES+=usr/include/clang/3.3/x86intrin.h
OLD_FILES+=usr/include/clang/3.3/xmmintrin.h
OLD_FILES+=usr/include/clang/3.3/xopintrin.h
OLD_FILES+=usr/share/man/man1/llvm-prof.1.gz
OLD_FILES+=usr/share/man/man1/llvm-ranlib.1.gz
OLD_DIRS+=usr/include/clang/3.3
# 20140314: bsdconfig usermgmt rewrite
OLD_FILES+=usr/libexec/bsdconfig/070.usermgmt/userinput
# 20140307: bsdconfig groupmgmt rewrite
OLD_FILES+=usr/libexec/bsdconfig/070.usermgmt/groupinput
# 20131109: extattr(2) mlinks fixed
OLD_FILES+=usr/share/man/man2/extattr_delete_list.2.gz
OLD_FILES+=usr/share/man/man2/extattr_get_list.2.gz
# 20131103: WITH_LIBICONV_COMPAT removal
OLD_FILES+=usr/include/_libiconv_compat.h
OLD_FILES+=usr/lib/libiconv.a
OLD_FILES+=usr/lib/libiconv.so
OLD_FILES+=usr/lib/libiconv.so.3
OLD_FILES+=usr/lib/libiconv_p.a
OLD_FILES+=usr/lib32/libiconv.a
OLD_FILES+=usr/lib32/libiconv.so
OLD_FILES+=usr/lib32/libiconv.so.3
OLD_FILES+=usr/lib32/libiconv_p.a
# 20131030: /etc/keys moved to /usr/share/keys
OLD_DIRS+=etc/keys
OLD_DIRS+=etc/keys/pkg
OLD_DIRS+=etc/keys/pkg/revoked
OLD_DIRS+=etc/keys/pkg/trusted
OLD_FILES+=etc/keys/pkg/trusted/pkg.freebsd.org.2013102301
# 20131023: remove never used iscsi directory
OLD_DIRS+=usr/share/examples/iscsi
# 20131014: libbsdyml becomes private
OLD_FILES+=usr/lib/libbsdyml.a
OLD_FILES+=usr/lib/libbsdyml.so
OLD_LIBS+=usr/lib/libbsdyml.so.0
OLD_FILES+=usr/lib/libbsdyml_p.a
OLD_FILES+=usr/lib32/libbsdyml.a
OLD_FILES+=usr/lib32/libbsdyml.so
OLD_LIBS+=usr/lib32/libbsdyml.so.0
OLD_FILES+=usr/lib32/libbsdyml_p.a
OLD_FILES+=usr/share/man/man3/libbsdyml.3.gz
OLD_FILES+=usr/include/bsdyml.h
# 20131013: Removal of the ATF tools
OLD_FILES+=etc/atf/FreeBSD.conf
OLD_FILES+=etc/atf/atf-run.hooks
OLD_FILES+=etc/atf/common.conf
OLD_FILES+=usr/bin/atf-config
OLD_FILES+=usr/bin/atf-report
OLD_FILES+=usr/bin/atf-run
OLD_FILES+=usr/bin/atf-version
OLD_FILES+=usr/share/atf/atf-run.hooks
OLD_FILES+=usr/share/examples/atf/atf-run.hooks
OLD_FILES+=usr/share/examples/atf/tests-results.css
OLD_FILES+=usr/share/man/man1/atf-config.1.gz
OLD_FILES+=usr/share/man/man1/atf-report.1.gz
OLD_FILES+=usr/share/man/man1/atf-run.1.gz
OLD_FILES+=usr/share/man/man1/atf-version.1.gz
OLD_FILES+=usr/share/man/man5/atf-formats.5.gz
OLD_FILES+=usr/share/xml/atf/tests-results.dtd
OLD_FILES+=usr/share/xsl/atf/tests-results.xsl
# 20131009: freebsd-version moved from /libexec to /bin
OLD_FILES+=libexec/freebsd-version
# 20131001: ar and ranlib from binutils not used
OLD_FILES+=usr/bin/gnu-ar
OLD_FILES+=usr/bin/gnu-ranlib
OLD_FILES+=usr/share/man/man1/gnu-ar.1.gz
OLD_FILES+=usr/share/man/man1/gnu-ranlib.1.gz
# 20130930: BIND removed from base
OLD_FILES+=etc/mtree/BIND.chroot.dist
OLD_FILES+=etc/namedb
OLD_FILES+=etc/periodic/daily/470.status-named
OLD_FILES+=usr/bin/dig
OLD_FILES+=usr/bin/nslookup
OLD_FILES+=usr/bin/nsupdate
OLD_DIRS+=usr/include/lwres
OLD_FILES+=usr/include/lwres/context.h
OLD_FILES+=usr/include/lwres/int.h
OLD_FILES+=usr/include/lwres/ipv6.h
OLD_FILES+=usr/include/lwres/lang.h
OLD_FILES+=usr/include/lwres/list.h
OLD_FILES+=usr/include/lwres/lwbuffer.h
OLD_FILES+=usr/include/lwres/lwpacket.h
OLD_FILES+=usr/include/lwres/lwres.h
OLD_FILES+=usr/include/lwres/net.h
OLD_FILES+=usr/include/lwres/netdb.h
OLD_FILES+=usr/include/lwres/platform.h
OLD_FILES+=usr/include/lwres/result.h
OLD_FILES+=usr/include/lwres/string.h
OLD_FILES+=usr/include/lwres/version.h
OLD_FILES+=usr/lib/liblwres.a
OLD_FILES+=usr/lib/liblwres.so
OLD_LIBS+=usr/lib/liblwres.so.90
OLD_FILES+=usr/lib/liblwres_p.a
OLD_FILES+=usr/sbin/arpaname
OLD_FILES+=usr/sbin/ddns-confgen
OLD_FILES+=usr/sbin/dnssec-dsfromkey
OLD_FILES+=usr/sbin/dnssec-keyfromlabel
OLD_FILES+=usr/sbin/dnssec-keygen
OLD_FILES+=usr/sbin/dnssec-revoke
OLD_FILES+=usr/sbin/dnssec-settime
OLD_FILES+=usr/sbin/dnssec-signzone
OLD_FILES+=usr/sbin/dnssec-verify
OLD_FILES+=usr/sbin/genrandom
OLD_FILES+=usr/sbin/isc-hmac-fixup
OLD_FILES+=usr/sbin/lwresd
OLD_FILES+=usr/sbin/named
OLD_FILES+=usr/sbin/named-checkconf
OLD_FILES+=usr/sbin/named-checkzone
OLD_FILES+=usr/sbin/named-compilezone
OLD_FILES+=usr/sbin/named-journalprint
OLD_FILES+=usr/sbin/named.reconfig
OLD_FILES+=usr/sbin/named.reload
OLD_FILES+=usr/sbin/nsec3hash
OLD_FILES+=usr/sbin/rndc
OLD_FILES+=usr/sbin/rndc-confgen
OLD_DIRS+=usr/share/doc/bind9
OLD_FILES+=usr/share/doc/bind9/CHANGES
OLD_FILES+=usr/share/doc/bind9/COPYRIGHT
OLD_FILES+=usr/share/doc/bind9/FAQ
OLD_FILES+=usr/share/doc/bind9/HISTORY
OLD_FILES+=usr/share/doc/bind9/README
OLD_DIRS+=usr/share/doc/bind9/arm
OLD_FILES+=usr/share/doc/bind9/arm/Bv9ARM.ch01.html
OLD_FILES+=usr/share/doc/bind9/arm/Bv9ARM.ch02.html
OLD_FILES+=usr/share/doc/bind9/arm/Bv9ARM.ch03.html
OLD_FILES+=usr/share/doc/bind9/arm/Bv9ARM.ch04.html
OLD_FILES+=usr/share/doc/bind9/arm/Bv9ARM.ch05.html
OLD_FILES+=usr/share/doc/bind9/arm/Bv9ARM.ch06.html
OLD_FILES+=usr/share/doc/bind9/arm/Bv9ARM.ch07.html
OLD_FILES+=usr/share/doc/bind9/arm/Bv9ARM.ch08.html
OLD_FILES+=usr/share/doc/bind9/arm/Bv9ARM.ch09.html
OLD_FILES+=usr/share/doc/bind9/arm/Bv9ARM.ch10.html
OLD_FILES+=usr/share/doc/bind9/arm/Bv9ARM.html
OLD_FILES+=usr/share/doc/bind9/arm/Bv9ARM.pdf
OLD_FILES+=usr/share/doc/bind9/arm/man.arpaname.html
OLD_FILES+=usr/share/doc/bind9/arm/man.ddns-confgen.html
OLD_FILES+=usr/share/doc/bind9/arm/man.dig.html
OLD_FILES+=usr/share/doc/bind9/arm/man.dnssec-dsfromkey.html
OLD_FILES+=usr/share/doc/bind9/arm/man.dnssec-keyfromlabel.html
OLD_FILES+=usr/share/doc/bind9/arm/man.dnssec-keygen.html
OLD_FILES+=usr/share/doc/bind9/arm/man.dnssec-revoke.html
OLD_FILES+=usr/share/doc/bind9/arm/man.dnssec-settime.html
OLD_FILES+=usr/share/doc/bind9/arm/man.dnssec-signzone.html
OLD_FILES+=usr/share/doc/bind9/arm/man.dnssec-verify.html
OLD_FILES+=usr/share/doc/bind9/arm/man.genrandom.html
OLD_FILES+=usr/share/doc/bind9/arm/man.host.html
OLD_FILES+=usr/share/doc/bind9/arm/man.isc-hmac-fixup.html
OLD_FILES+=usr/share/doc/bind9/arm/man.named-checkconf.html
OLD_FILES+=usr/share/doc/bind9/arm/man.named-checkzone.html
OLD_FILES+=usr/share/doc/bind9/arm/man.named-journalprint.html
OLD_FILES+=usr/share/doc/bind9/arm/man.named.html
OLD_FILES+=usr/share/doc/bind9/arm/man.nsec3hash.html
OLD_FILES+=usr/share/doc/bind9/arm/man.nsupdate.html
OLD_FILES+=usr/share/doc/bind9/arm/man.rndc-confgen.html
OLD_FILES+=usr/share/doc/bind9/arm/man.rndc.conf.html
OLD_FILES+=usr/share/doc/bind9/arm/man.rndc.html
OLD_DIRS+=usr/share/doc/bind9/misc
OLD_FILES+=usr/share/doc/bind9/misc/dnssec
OLD_FILES+=usr/share/doc/bind9/misc/format-options.pl
OLD_FILES+=usr/share/doc/bind9/misc/ipv6
OLD_FILES+=usr/share/doc/bind9/misc/migration
OLD_FILES+=usr/share/doc/bind9/misc/migration-4to9
OLD_FILES+=usr/share/doc/bind9/misc/options
OLD_FILES+=usr/share/doc/bind9/misc/rfc-compliance
OLD_FILES+=usr/share/doc/bind9/misc/roadmap
OLD_FILES+=usr/share/doc/bind9/misc/sdb
OLD_FILES+=usr/share/doc/bind9/misc/sort-options.pl
OLD_FILES+=usr/share/man/man1/arpaname.1.gz
OLD_FILES+=usr/share/man/man1/dig.1.gz
OLD_FILES+=usr/share/man/man1/nslookup.1.gz
OLD_FILES+=usr/share/man/man1/nsupdate.1.gz
OLD_FILES+=usr/share/man/man3/lwres.3.gz
OLD_FILES+=usr/share/man/man3/lwres_addr_parse.3.gz
OLD_FILES+=usr/share/man/man3/lwres_buffer.3.gz
OLD_FILES+=usr/share/man/man3/lwres_buffer_add.3.gz
OLD_FILES+=usr/share/man/man3/lwres_buffer_back.3.gz
OLD_FILES+=usr/share/man/man3/lwres_buffer_clear.3.gz
OLD_FILES+=usr/share/man/man3/lwres_buffer_first.3.gz
OLD_FILES+=usr/share/man/man3/lwres_buffer_forward.3.gz
OLD_FILES+=usr/share/man/man3/lwres_buffer_getmem.3.gz
OLD_FILES+=usr/share/man/man3/lwres_buffer_getuint16.3.gz
OLD_FILES+=usr/share/man/man3/lwres_buffer_getuint32.3.gz
OLD_FILES+=usr/share/man/man3/lwres_buffer_getuint8.3.gz
OLD_FILES+=usr/share/man/man3/lwres_buffer_init.3.gz
OLD_FILES+=usr/share/man/man3/lwres_buffer_invalidate.3.gz
OLD_FILES+=usr/share/man/man3/lwres_buffer_putmem.3.gz
OLD_FILES+=usr/share/man/man3/lwres_buffer_putuint16.3.gz
OLD_FILES+=usr/share/man/man3/lwres_buffer_putuint32.3.gz
OLD_FILES+=usr/share/man/man3/lwres_buffer_putuint8.3.gz
OLD_FILES+=usr/share/man/man3/lwres_buffer_subtract.3.gz
OLD_FILES+=usr/share/man/man3/lwres_conf_clear.3.gz
OLD_FILES+=usr/share/man/man3/lwres_conf_get.3.gz
OLD_FILES+=usr/share/man/man3/lwres_conf_init.3.gz
OLD_FILES+=usr/share/man/man3/lwres_conf_parse.3.gz
OLD_FILES+=usr/share/man/man3/lwres_conf_print.3.gz
OLD_FILES+=usr/share/man/man3/lwres_config.3.gz
OLD_FILES+=usr/share/man/man3/lwres_context.3.gz
OLD_FILES+=usr/share/man/man3/lwres_context_allocmem.3.gz
OLD_FILES+=usr/share/man/man3/lwres_context_create.3.gz
OLD_FILES+=usr/share/man/man3/lwres_context_destroy.3.gz
OLD_FILES+=usr/share/man/man3/lwres_context_freemem.3.gz
OLD_FILES+=usr/share/man/man3/lwres_context_initserial.3.gz
OLD_FILES+=usr/share/man/man3/lwres_context_nextserial.3.gz
OLD_FILES+=usr/share/man/man3/lwres_context_sendrecv.3.gz
OLD_FILES+=usr/share/man/man3/lwres_endhostent.3.gz
OLD_FILES+=usr/share/man/man3/lwres_endhostent_r.3.gz
OLD_FILES+=usr/share/man/man3/lwres_freeaddrinfo.3.gz
OLD_FILES+=usr/share/man/man3/lwres_freehostent.3.gz
OLD_FILES+=usr/share/man/man3/lwres_gabn.3.gz
OLD_FILES+=usr/share/man/man3/lwres_gabnrequest_free.3.gz
OLD_FILES+=usr/share/man/man3/lwres_gabnrequest_parse.3.gz
OLD_FILES+=usr/share/man/man3/lwres_gabnrequest_render.3.gz
OLD_FILES+=usr/share/man/man3/lwres_gabnresponse_free.3.gz
OLD_FILES+=usr/share/man/man3/lwres_gabnresponse_parse.3.gz
OLD_FILES+=usr/share/man/man3/lwres_gabnresponse_render.3.gz
OLD_FILES+=usr/share/man/man3/lwres_gai_strerror.3.gz
OLD_FILES+=usr/share/man/man3/lwres_getaddrinfo.3.gz
OLD_FILES+=usr/share/man/man3/lwres_getaddrsbyname.3.gz
OLD_FILES+=usr/share/man/man3/lwres_gethostbyaddr.3.gz
OLD_FILES+=usr/share/man/man3/lwres_gethostbyaddr_r.3.gz
OLD_FILES+=usr/share/man/man3/lwres_gethostbyname.3.gz
OLD_FILES+=usr/share/man/man3/lwres_gethostbyname2.3.gz
OLD_FILES+=usr/share/man/man3/lwres_gethostbyname_r.3.gz
OLD_FILES+=usr/share/man/man3/lwres_gethostent.3.gz
OLD_FILES+=usr/share/man/man3/lwres_gethostent_r.3.gz
OLD_FILES+=usr/share/man/man3/lwres_getipnode.3.gz
OLD_FILES+=usr/share/man/man3/lwres_getipnodebyaddr.3.gz
OLD_FILES+=usr/share/man/man3/lwres_getipnodebyname.3.gz
OLD_FILES+=usr/share/man/man3/lwres_getnamebyaddr.3.gz
OLD_FILES+=usr/share/man/man3/lwres_getnameinfo.3.gz
OLD_FILES+=usr/share/man/man3/lwres_getrrsetbyname.3.gz
OLD_FILES+=usr/share/man/man3/lwres_gnba.3.gz
OLD_FILES+=usr/share/man/man3/lwres_gnbarequest_free.3.gz
OLD_FILES+=usr/share/man/man3/lwres_gnbarequest_parse.3.gz
OLD_FILES+=usr/share/man/man3/lwres_gnbarequest_render.3.gz
OLD_FILES+=usr/share/man/man3/lwres_gnbaresponse_free.3.gz
OLD_FILES+=usr/share/man/man3/lwres_gnbaresponse_parse.3.gz
OLD_FILES+=usr/share/man/man3/lwres_gnbaresponse_render.3.gz
OLD_FILES+=usr/share/man/man3/lwres_herror.3.gz
OLD_FILES+=usr/share/man/man3/lwres_hstrerror.3.gz
OLD_FILES+=usr/share/man/man3/lwres_inetntop.3.gz
OLD_FILES+=usr/share/man/man3/lwres_lwpacket_parseheader.3.gz
OLD_FILES+=usr/share/man/man3/lwres_lwpacket_renderheader.3.gz
OLD_FILES+=usr/share/man/man3/lwres_net_ntop.3.gz
OLD_FILES+=usr/share/man/man3/lwres_noop.3.gz
OLD_FILES+=usr/share/man/man3/lwres_nooprequest_free.3.gz
OLD_FILES+=usr/share/man/man3/lwres_nooprequest_parse.3.gz
OLD_FILES+=usr/share/man/man3/lwres_nooprequest_render.3.gz
OLD_FILES+=usr/share/man/man3/lwres_noopresponse_free.3.gz
OLD_FILES+=usr/share/man/man3/lwres_noopresponse_parse.3.gz
OLD_FILES+=usr/share/man/man3/lwres_noopresponse_render.3.gz
OLD_FILES+=usr/share/man/man3/lwres_packet.3.gz
OLD_FILES+=usr/share/man/man3/lwres_resutil.3.gz
OLD_FILES+=usr/share/man/man3/lwres_sethostent.3.gz
OLD_FILES+=usr/share/man/man3/lwres_sethostent_r.3.gz
OLD_FILES+=usr/share/man/man3/lwres_string_parse.3.gz
OLD_FILES+=usr/share/man/man5/named.conf.5.gz
OLD_FILES+=usr/share/man/man5/rndc.conf.5.gz
OLD_FILES+=usr/share/man/man8/ddns-confgen.8.gz
OLD_FILES+=usr/share/man/man8/dnssec-dsfromkey.8.gz
OLD_FILES+=usr/share/man/man8/dnssec-keyfromlabel.8.gz
OLD_FILES+=usr/share/man/man8/dnssec-keygen.8.gz
OLD_FILES+=usr/share/man/man8/dnssec-revoke.8.gz
OLD_FILES+=usr/share/man/man8/dnssec-settime.8.gz
OLD_FILES+=usr/share/man/man8/dnssec-signzone.8.gz
OLD_FILES+=usr/share/man/man8/genrandom.8.gz
OLD_FILES+=usr/share/man/man8/isc-hmac-fixup.8.gz
OLD_FILES+=usr/share/man/man8/lwresd.8.gz
OLD_FILES+=usr/share/man/man8/named-checkconf.8.gz
OLD_FILES+=usr/share/man/man8/named-checkzone.8.gz
OLD_FILES+=usr/share/man/man8/named-compilezone.8.gz
OLD_FILES+=usr/share/man/man8/named-journalprint.8.gz
OLD_FILES+=usr/share/man/man8/named.8.gz
OLD_FILES+=usr/share/man/man8/named.reconfig.8.gz
OLD_FILES+=usr/share/man/man8/named.reload.8.gz
OLD_FILES+=usr/share/man/man8/nsec3hash.8.gz
OLD_FILES+=usr/share/man/man8/rndc-confgen.8.gz
OLD_FILES+=usr/share/man/man8/rndc.8.gz
OLD_DIRS+=var/named/dev
OLD_DIRS+=var/named/etc
OLD_DIRS+=var/named/etc/namedb
OLD_FILES+=var/named/etc/namedb/PROTO.localhost-v6.rev
OLD_FILES+=var/named/etc/namedb/PROTO.localhost.rev
OLD_DIRS+=var/named/etc/namedb/dynamic
OLD_FILES+=var/named/etc/namedb/make-localhost
OLD_DIRS+=var/named/etc/namedb/master
OLD_FILES+=var/named/etc/namedb/master/empty.db
OLD_FILES+=var/named/etc/namedb/master/localhost-forward.db
OLD_FILES+=var/named/etc/namedb/master/localhost-reverse.db
#OLD_FILES+=var/named/etc/namedb/named.conf	# intentionally left out
OLD_FILES+=var/named/etc/namedb/named.root
OLD_DIRS+=var/named/etc/namedb/working
OLD_DIRS+=var/named/etc/namedb/slave
OLD_DIRS+=var/named/var
OLD_DIRS+=var/named/var/dump
OLD_DIRS+=var/named/var/log
OLD_DIRS+=var/named/var/run
OLD_DIRS+=var/named/var/run/named
OLD_DIRS+=var/named/var/stats
OLD_DIRS+=var/run/named
# 20130908: libssh becomes private
OLD_FILES+=usr/lib/libssh.a
OLD_FILES+=usr/lib/libssh.so
OLD_LIBS+=usr/lib/libssh.so.5
OLD_FILES+=usr/lib/libssh_p.a
OLD_FILES+=usr/lib32/libssh.a
OLD_FILES+=usr/lib32/libssh.so
OLD_LIBS+=usr/lib32/libssh.so.5
OLD_FILES+=usr/lib32/libssh_p.a
# 20130903: gnupatch is no more
OLD_FILES+=usr/bin/gnupatch
OLD_FILES+=usr/share/man/man1/gnupatch.1.gz
# 20130829: bsdpatch is patch unconditionally
OLD_FILES+=usr/bin/bsdpatch
OLD_FILES+=usr/share/man/man1/bsdpatch.1.gz
# 20130822: bind 9.9.3-P2 import
OLD_LIBS+=usr/lib/liblwres.so.80
# 20130814: vm_page_busy(9)
OLD_FILES+=usr/share/man/man9/vm_page_flash.9.gz
OLD_FILES+=usr/share/man/man9/vm_page_io.9.gz
OLD_FILES+=usr/share/man/man9/vm_page_io_finish.9.gz
OLD_FILES+=usr/share/man/man9/vm_page_io_start.9.gz
OLD_FILES+=usr/share/man/man9/vm_page_wakeup.9.gz
# 20130710: libkvm version bump 
OLD_LIBS+=lib/libkvm.so.5
OLD_LIBS+=usr/lib32/libkvm.so.5
# 20130623: dialog update from 1.1 to 1.2
OLD_LIBS+=usr/lib/libdialog.so.7
OLD_LIBS+=usr/lib32/libdialog.so.7
# 20130616: vfs_mount.9 removed
OLD_FILES+=usr/share/man/man9/vfs_mount.9.gz
# 20130614: remove CVS from base
OLD_FILES+=usr/bin/cvs
OLD_FILES+=usr/bin/cvsbug
OLD_FILES+=usr/share/doc/psd/28.cvs/paper.ascii.gz
OLD_FILES+=usr/share/doc/psd/28.cvs/paper.ps.gz
OLD_DIRS+=usr/share/doc/psd/28.cvs
OLD_FILES+=usr/share/examples/cvs/contrib/README
OLD_FILES+=usr/share/examples/cvs/contrib/clmerge
OLD_FILES+=usr/share/examples/cvs/contrib/cln_hist
OLD_FILES+=usr/share/examples/cvs/contrib/commit_prep
OLD_FILES+=usr/share/examples/cvs/contrib/cvs2vendor
OLD_FILES+=usr/share/examples/cvs/contrib/cvs_acls
OLD_FILES+=usr/share/examples/cvs/contrib/cvscheck
OLD_FILES+=usr/share/examples/cvs/contrib/cvscheck.man
OLD_FILES+=usr/share/examples/cvs/contrib/cvshelp.man
OLD_FILES+=usr/share/examples/cvs/contrib/descend.man
OLD_FILES+=usr/share/examples/cvs/contrib/easy-import
OLD_FILES+=usr/share/examples/cvs/contrib/intro.doc
OLD_FILES+=usr/share/examples/cvs/contrib/log
OLD_FILES+=usr/share/examples/cvs/contrib/log_accum
OLD_FILES+=usr/share/examples/cvs/contrib/mfpipe
OLD_FILES+=usr/share/examples/cvs/contrib/rcs-to-cvs
OLD_FILES+=usr/share/examples/cvs/contrib/rcs2log
OLD_FILES+=usr/share/examples/cvs/contrib/rcslock
OLD_FILES+=usr/share/examples/cvs/contrib/sccs2rcs
OLD_DIRS+=usr/share/examples/cvs/contrib
OLD_DIRS+=usr/share/examples/cvs
OLD_FILES+=usr/share/info/cvs.info.gz
OLD_FILES+=usr/share/info/cvsclient.info.gz
OLD_FILES+=usr/share/man/man1/cvs.1.gz
OLD_FILES+=usr/share/man/man5/cvs.5.gz
OLD_FILES+=usr/share/man/man8/cvsbug.8.gz
# 20130607: WITH_DEBUG_FILES added
OLD_FILES+=lib/libufs.so.6.symbols
OLD_FILES+=usr/lib32/libufs.so.6.symbols
# 20130417: nfs fha moved from nfsserver to nfs
OLD_FILES+=usr/include/nfsserver/nfs_fha.h
# 20130411: new clang import which bumps version from 3.2 to 3.3.
OLD_FILES+=usr/include/clang/3.2/__wmmintrin_aes.h
OLD_FILES+=usr/include/clang/3.2/__wmmintrin_pclmul.h
OLD_FILES+=usr/include/clang/3.2/altivec.h
OLD_FILES+=usr/include/clang/3.2/ammintrin.h
OLD_FILES+=usr/include/clang/3.2/avx2intrin.h
OLD_FILES+=usr/include/clang/3.2/avxintrin.h
OLD_FILES+=usr/include/clang/3.2/bmi2intrin.h
OLD_FILES+=usr/include/clang/3.2/bmiintrin.h
OLD_FILES+=usr/include/clang/3.2/cpuid.h
OLD_FILES+=usr/include/clang/3.2/emmintrin.h
OLD_FILES+=usr/include/clang/3.2/f16cintrin.h
OLD_FILES+=usr/include/clang/3.2/fma4intrin.h
OLD_FILES+=usr/include/clang/3.2/fmaintrin.h
OLD_FILES+=usr/include/clang/3.2/immintrin.h
OLD_FILES+=usr/include/clang/3.2/lzcntintrin.h
OLD_FILES+=usr/include/clang/3.2/mm3dnow.h
OLD_FILES+=usr/include/clang/3.2/mm_malloc.h
OLD_FILES+=usr/include/clang/3.2/mmintrin.h
OLD_FILES+=usr/include/clang/3.2/module.map
OLD_FILES+=usr/include/clang/3.2/nmmintrin.h
OLD_FILES+=usr/include/clang/3.2/pmmintrin.h
OLD_FILES+=usr/include/clang/3.2/popcntintrin.h
OLD_FILES+=usr/include/clang/3.2/rtmintrin.h
OLD_FILES+=usr/include/clang/3.2/smmintrin.h
OLD_FILES+=usr/include/clang/3.2/tmmintrin.h
OLD_FILES+=usr/include/clang/3.2/wmmintrin.h
OLD_FILES+=usr/include/clang/3.2/x86intrin.h
OLD_FILES+=usr/include/clang/3.2/xmmintrin.h
OLD_FILES+=usr/include/clang/3.2/xopintrin.h
OLD_DIRS+=usr/include/clang/3.2
# 20130404: legacy ATA stack removed
OLD_FILES+=etc/periodic/daily/405.status-ata-raid
OLD_FILES+=rescue/atacontrol
OLD_FILES+=sbin/atacontrol
OLD_FILES+=usr/share/man/man8/atacontrol.8.gz
OLD_FILES+=usr/share/man/man4/atapicam.4.gz
OLD_FILES+=usr/share/man/man4/ataraid.4.gz
OLD_FILES+=usr/sbin/burncd
OLD_FILES+=usr/share/man/man8/burncd.8.gz
# 20130316: vinum.4 removed
OLD_FILES+=usr/share/man/man4/vinum.4.gz
# 20130312: fortunes-o removed
OLD_FILES+=usr/share/games/fortune/fortunes-o
OLD_FILES+=usr/share/games/fortune/fortunes-o.dat
# 20130311: Ports are no more available via cvsup
OLD_FILES+=usr/share/examples/cvsup/ports-supfile
OLD_FILES+=usr/share/examples/cvsup/refuse
OLD_FILES+=usr/share/examples/cvsup/refuse.README
# 20130309: NWFS and NCP supports removed
OLD_FILES+=usr/bin/ncplist
OLD_FILES+=usr/bin/ncplogin
OLD_FILES+=usr/bin/ncplogout
OLD_FILES+=usr/include/fs/nwfs/nwfs.h
OLD_FILES+=usr/include/fs/nwfs/nwfs_mount.h
OLD_FILES+=usr/include/fs/nwfs/nwfs_node.h
OLD_FILES+=usr/include/fs/nwfs/nwfs_subr.h
OLD_DIRS+=usr/include/fs/nwfs
OLD_FILES+=usr/include/netncp/ncp.h
OLD_FILES+=usr/include/netncp/ncp_cfg.h
OLD_FILES+=usr/include/netncp/ncp_conn.h
OLD_FILES+=usr/include/netncp/ncp_file.h
OLD_FILES+=usr/include/netncp/ncp_lib.h
OLD_FILES+=usr/include/netncp/ncp_ncp.h
OLD_FILES+=usr/include/netncp/ncp_nls.h
OLD_FILES+=usr/include/netncp/ncp_rcfile.h
OLD_FILES+=usr/include/netncp/ncp_rq.h
OLD_FILES+=usr/include/netncp/ncp_sock.h
OLD_FILES+=usr/include/netncp/ncp_subr.h
OLD_FILES+=usr/include/netncp/ncp_user.h
OLD_FILES+=usr/include/netncp/ncpio.h
OLD_FILES+=usr/include/netncp/nwerror.h
OLD_DIRS+=usr/include/netncp
OLD_FILES+=usr/lib/libncp.a
OLD_FILES+=usr/lib/libncp.so
OLD_LIBS+=usr/lib/libncp.so.4
OLD_FILES+=usr/lib/libncp_p.a
OLD_FILES+=usr/lib32/libncp.a
OLD_FILES+=usr/lib32/libncp.so
OLD_LIBS+=usr/lib32/libncp.so.4
OLD_FILES+=usr/lib32/libncp_p.a
OLD_FILES+=usr/sbin/mount_nwfs
OLD_FILES+=usr/share/examples/nwclient/dot.nwfsrc
OLD_FILES+=usr/share/examples/nwclient/nwfs.sh.sample
OLD_DIRS+=usr/share/examples/nwclient
OLD_FILES+=usr/share/man/man1/ncplist.1.gz
OLD_FILES+=usr/share/man/man1/ncplogin.1.gz
OLD_FILES+=usr/share/man/man1/ncplogout.1.gz
OLD_FILES+=usr/share/man/man8/mount_nwfs.8.gz
# 20130302: NTFS support removed
OLD_FILES+=rescue/mount_ntfs
OLD_FILES+=sbin/mount_ntfs
OLD_FILES+=usr/include/fs/ntfs/ntfs.h
OLD_FILES+=usr/include/fs/ntfs/ntfs_compr.h
OLD_FILES+=usr/include/fs/ntfs/ntfs_ihash.h
OLD_FILES+=usr/include/fs/ntfs/ntfs_inode.h
OLD_FILES+=usr/include/fs/ntfs/ntfs_subr.h
OLD_FILES+=usr/include/fs/ntfs/ntfs_vfsops.h
OLD_FILES+=usr/include/fs/ntfs/ntfsmount.h
OLD_DIRS+=usr/include/fs/ntfs
OLD_FILES+=usr/share/man/man8/mount_ntfs.8.gz
# 20130302: PORTALFS support removed
OLD_FILES+=usr/include/fs/portalfs/portal.h
OLD_DIRS+=usr/include/fs/portalfs
OLD_FILES+=usr/sbin/mount_portalfs
OLD_FILES+=usr/share/examples/portal/README
OLD_FILES+=usr/share/examples/portal/portal.conf
OLD_DIRS+=usr/share/examples/portal
OLD_FILES+=usr/share/man/man8/mount_portalfs.8.gz
# 20130302: CODAFS support removed
OLD_FILES+=usr/share/man/man4/coda.4.gz
# 20130302: XFS support removed
OLD_FILES+=usr/share/man/man5/xfs.5.gz
# 20130302: Capsicum overhaul
OLD_FILES+=usr/share/man/man2/cap_getrights.2.gz
OLD_FILES+=usr/share/man/man2/cap_new.2.gz
# 20130213: OpenSSL 1.0.1e import
OLD_FILES+=usr/share/openssl/man/man3/EVP_PKEY_verifyrecover.3.gz
OLD_FILES+=usr/share/openssl/man/man3/EVP_PKEY_verifyrecover_init.3.gz
# 20130116: removed long unused directories for .1aout section manpages
OLD_FILES+=usr/share/man/en.ISO8859-1/man1aout
OLD_FILES+=usr/share/man/en.UTF-8/man1aout
OLD_DIRS+=usr/share/man/man1aout
OLD_DIRS+=usr/share/man/cat1aout
OLD_DIRS+=usr/share/man/en.ISO8859-1/cat1aout
OLD_DIRS+=usr/share/man/en.UTF-8/cat1aout
# 20130110: bsd.compat.mk removed
OLD_FILES+=usr/share/mk/bsd.compat.mk
# 20130103: gnats-supfile removed
OLD_FILES+=usr/share/examples/cvsup/gnats-supfile
# 20121230: libdisk removed
OLD_FILES+=usr/share/man/man3/libdisk.3.gz usr/include/libdisk.h
OLD_FILES+=usr/lib/libdisk.a usr/lib32/libdisk.a
# 20121230: remove wrongly created directories for auditdistd
OLD_DIRS+=var/dist
OLD_DIRS+=var/remote
# 20121114: zpool-features manual page moved from section 5 to 7
OLD_FILES+=usr/share/man/man5/zpool-features.5.gz
# 20121022: remove harp, hfa and idt man page
OLD_FILES+=usr/share/man/man4/harp.4.gz
OLD_FILES+=usr/share/man/man4/hfa.4.gz
OLD_FILES+=usr/share/man/man4/idt.4.gz
OLD_FILES+=usr/share/man/man4/if_idt.4.gz
# 20121022: VFS_LOCK_GIANT elimination
OLD_FILES+=usr/share/man/man9/VFS_LOCK_GIANT.9.gz
OLD_FILES+=usr/share/man/man9/VFS_UNLOCK_GIANT.9.gz
# 20121004: remove incomplete unwind.h
OLD_FILES+=usr/include/clang/3.2/unwind.h
# 20120910: NetBSD compat shims removed
OLD_FILES+=usr/include/cam/scsi/scsi_low_pisa.h
OLD_FILES+=usr/include/sys/device_port.h
# 20120909: doc and www supfiles removed
OLD_FILES+=usr/share/examples/cvsup/doc-supfile
OLD_FILES+=usr/share/examples/cvsup/www-supfile
# 20120908: pf cleanup
OLD_FILES+=usr/include/net/if_pflow.h
# 20120816: new clang import which bumps version from 3.1 to 3.2
OLD_FILES+=usr/bin/llvm-ld
OLD_FILES+=usr/bin/llvm-stub
OLD_FILES+=usr/include/clang/3.1/altivec.h
OLD_FILES+=usr/include/clang/3.1/avx2intrin.h
OLD_FILES+=usr/include/clang/3.1/avxintrin.h
OLD_FILES+=usr/include/clang/3.1/bmi2intrin.h
OLD_FILES+=usr/include/clang/3.1/bmiintrin.h
OLD_FILES+=usr/include/clang/3.1/cpuid.h
OLD_FILES+=usr/include/clang/3.1/emmintrin.h
OLD_FILES+=usr/include/clang/3.1/fma4intrin.h
OLD_FILES+=usr/include/clang/3.1/immintrin.h
OLD_FILES+=usr/include/clang/3.1/lzcntintrin.h
OLD_FILES+=usr/include/clang/3.1/mm3dnow.h
OLD_FILES+=usr/include/clang/3.1/mm_malloc.h
OLD_FILES+=usr/include/clang/3.1/mmintrin.h
OLD_FILES+=usr/include/clang/3.1/module.map
OLD_FILES+=usr/include/clang/3.1/nmmintrin.h
OLD_FILES+=usr/include/clang/3.1/pmmintrin.h
OLD_FILES+=usr/include/clang/3.1/popcntintrin.h
OLD_FILES+=usr/include/clang/3.1/smmintrin.h
OLD_FILES+=usr/include/clang/3.1/tmmintrin.h
OLD_FILES+=usr/include/clang/3.1/unwind.h
OLD_FILES+=usr/include/clang/3.1/wmmintrin.h
OLD_FILES+=usr/include/clang/3.1/x86intrin.h
OLD_FILES+=usr/include/clang/3.1/xmmintrin.h
OLD_DIRS+=usr/include/clang/3.1
OLD_FILES+=usr/share/man/man1/llvm-ld.1.gz
# 20120712: OpenSSL 1.0.1c import
OLD_LIBS+=lib/libcrypto.so.6
OLD_LIBS+=usr/lib/libssl.so.6
OLD_LIBS+=usr/lib32/libcrypto.so.6
OLD_LIBS+=usr/lib32/libssl.so.6
OLD_FILES+=usr/include/openssl/aes_locl.h
OLD_FILES+=usr/include/openssl/bio_lcl.h
OLD_FILES+=usr/include/openssl/e_os.h
OLD_FILES+=usr/include/openssl/fips.h
OLD_FILES+=usr/include/openssl/fips_rand.h
OLD_FILES+=usr/include/openssl/md2.h
OLD_FILES+=usr/include/openssl/pq_compat.h
OLD_FILES+=usr/include/openssl/store.h
OLD_FILES+=usr/include/openssl/tmdiff.h
OLD_FILES+=usr/include/openssl/ui_locl.h
OLD_FILES+=usr/share/openssl/man/man3/CRYPTO_set_id_callback.3.gz
# 20120621: remove old man page
OLD_FILES+=usr/share/man/man8/vnconfig.8.gz
# 20120619: TOE support updated
OLD_FILES+=usr/include/netinet/toedev.h
# 20120613: auth.conf removed
OLD_FILES+=etc/auth.conf
OLD_FILES+=usr/share/examples/etc/auth.conf
OLD_FILES+=usr/share/man/man3/auth.3.gz
OLD_FILES+=usr/share/man/man3/auth_getval.3.gz
OLD_FILES+=usr/share/man/man5/auth.conf.5.gz
# 20120530: kde pam lives now in ports
OLD_FILES+=etc/pam.d/kde
# 20120521: byacc import
OLD_FILES+=usr/bin/yyfix
OLD_FILES+=usr/share/man/man1/yyfix.1.gz
# 20120505: new clang import installed a redundant internal header
OLD_FILES+=usr/include/clang/3.1/stdalign.h
# 20120428: MD2 removed from libmd
OLD_LIBS+=lib/libmd.so.5
OLD_FILES+=usr/include/md2.h
OLD_LIBS+=usr/lib32/libmd.so.5
OLD_FILES+=usr/share/man/man3/MD2Data.3.gz
OLD_FILES+=usr/share/man/man3/MD2End.3.gz
OLD_FILES+=usr/share/man/man3/MD2File.3.gz
OLD_FILES+=usr/share/man/man3/MD2FileChunk.3.gz
OLD_FILES+=usr/share/man/man3/MD2Final.3.gz
OLD_FILES+=usr/share/man/man3/MD2Init.3.gz
OLD_FILES+=usr/share/man/man3/MD2Update.3.gz
OLD_FILES+=usr/share/man/man3/md2.3.gz
# 20120425: libusb version bump (r234684)
OLD_LIBS+=usr/lib/libusb.so.2
OLD_LIBS+=usr/lib32/libusb.so.2
OLD_FILES+=usr/share/man/man3/libsub_get_active_config_descriptor.3.gz
# 20120415: new clang import which bumps version from 3.0 to 3.1
OLD_FILES+=usr/include/clang/3.0/altivec.h
OLD_FILES+=usr/include/clang/3.0/avxintrin.h
OLD_FILES+=usr/include/clang/3.0/emmintrin.h
OLD_FILES+=usr/include/clang/3.0/immintrin.h
OLD_FILES+=usr/include/clang/3.0/mm3dnow.h
OLD_FILES+=usr/include/clang/3.0/mm_malloc.h
OLD_FILES+=usr/include/clang/3.0/mmintrin.h
OLD_FILES+=usr/include/clang/3.0/nmmintrin.h
OLD_FILES+=usr/include/clang/3.0/pmmintrin.h
OLD_FILES+=usr/include/clang/3.0/smmintrin.h
OLD_FILES+=usr/include/clang/3.0/tmmintrin.h
OLD_FILES+=usr/include/clang/3.0/wmmintrin.h
OLD_FILES+=usr/include/clang/3.0/x86intrin.h
OLD_FILES+=usr/include/clang/3.0/xmmintrin.h
OLD_DIRS+=usr/include/clang/3.0
# 20120412: BIND 9.8.1 release notes removed
OLD_FILES+=usr/share/doc/bind9/RELEASE-NOTES-BIND-9.8.1.pdf
OLD_FILES+=usr/share/doc/bind9/RELEASE-NOTES-BIND-9.8.1.txt
OLD_FILES+=usr/share/doc/bind9/RELEASE-NOTES-BIND-9.8.1.html
OLD_FILES+=usr/share/doc/bind9/release-notes.css
# 20120330: legacy(4) moved to x86
OLD_FILES+=usr/include/machine/legacyvar.h
# 20120324: MPI headers updated
OLD_FILES+=usr/include/dev/mpt/mpilib/mpi_inb.h
# 20120322: hwpmc_mips24k.h removed
OLD_FILES+=usr/include/dev/hwpmc/hwpmc_mips24k.h
# 20120322: Update heimdal to 1.5.1.
OLD_FILES+=usr/include/krb5-v4compat.h \
	usr/include/krb_err.h \
	usr/include/hdb-private.h \
        usr/share/man/man3/krb5_addresses.3.gz \
        usr/share/man/man3/krb5_cc_cursor.3.gz \
        usr/share/man/man3/krb5_cc_ops.3.gz \
        usr/share/man/man3/krb5_config.3.gz \
        usr/share/man/man3/krb5_config_get_int_default.3.gz \
        usr/share/man/man3/krb5_context.3.gz \
        usr/share/man/man3/krb5_data.3.gz \
        usr/share/man/man3/krb5_err.3.gz \
        usr/share/man/man3/krb5_errx.3.gz \
        usr/share/man/man3/krb5_keyblock.3.gz \
        usr/share/man/man3/krb5_keytab_entry.3.gz \
        usr/share/man/man3/krb5_kt_cursor.3.gz \
        usr/share/man/man3/krb5_kt_ops.3.gz \
        usr/share/man/man3/krb5_set_warn_dest.3.gz \
        usr/share/man/man3/krb5_verr.3.gz \
        usr/share/man/man3/krb5_verrx.3.gz \
        usr/share/man/man3/krb5_vwarnx.3.gz \
        usr/share/man/man3/krb5_warn.3.gz \
        usr/share/man/man3/krb5_warnx.3.gz
OLD_LIBS+=usr/lib/libasn1.so.10 \
	usr/lib/libhdb.so.10 \
	usr/lib/libheimntlm.so.10 \
	usr/lib/libhx509.so.10 \
	usr/lib/libkadm5clnt.so.10 \
	usr/lib/libkadm5srv.so.10 \
	usr/lib/libkafs5.so.10 \
	usr/lib/libkrb5.so.10 \
	usr/lib/libroken.so.10 \
	usr/lib32/libasn1.so.10 \
	usr/lib32/libhdb.so.10 \
	usr/lib32/libheimntlm.so.10 \
	usr/lib32/libhx509.so.10 \
	usr/lib32/libkadm5clnt.so.10 \
	usr/lib32/libkadm5srv.so.10 \
	usr/lib32/libkafs5.so.10 \
	usr/lib32/libkrb5.so.10 \
	usr/lib32/libroken.so.10
# 20120309: Remove fifofs header files.
OLD_FILES+=usr/include/fs/fifofs/fifo.h
OLD_DIRS+=usr/include/fs/fifofs
# 20120304: xlocale cleanup
OLD_FILES+=usr/include/_xlocale_ctype.h
# 20120225: libarchive 3.0.3
OLD_FILES+=usr/share/man/man3/archive_read_data_into_buffer.3.gz \
	usr/share/man/man3/archive_read_support_compression_all.3.gz \
	usr/share/man/man3/archive_read_support_compression_bzip2.3.gz \
	usr/share/man/man3/archive_read_support_compression_compress.3.gz \
	usr/share/man/man3/archive_read_support_compression_gzip.3.gz \
	usr/share/man/man3/archive_read_support_compression_lzma.3.gz \
	usr/share/man/man3/archive_read_support_compression_none.3.gz \
	usr/share/man/man3/archive_read_support_compression_program.3.gz \
	usr/share/man/man3/archive_read_support_compression_program_signature.3.gz \
	usr/share/man/man3/archive_read_support_compression_xz.3.gz \
	usr/share/man/man3/archive_write_set_callbacks.3.gz \
	usr/share/man/man3/archive_write_set_compression_bzip2.3.gz \
	usr/share/man/man3/archive_write_set_compression_compress.3.gz \
	usr/share/man/man3/archive_write_set_compression_gzip.3.gz \
	usr/share/man/man3/archive_write_set_compression_none.3.gz \
	usr/share/man/man3/archive_write_set_compression_program.3.gz
OLD_LIBS+=usr/lib/libarchive.so.5
OLD_LIBS+=usr/lib32/libarchive.so.5
# 20120113: removal of wtmpcvt(1)
OLD_FILES+=usr/bin/wtmpcvt
OLD_FILES+=usr/share/man/man1/wtmpcvt.1.gz
# 20111214: eventtimers(7) moved to eventtimers(4)
OLD_FILES+=usr/share/man/man7/eventtimers.7.gz
# 20111125: amd(4) removed
OLD_FILES+=usr/share/man/man4/amd.4.gz
# 20111125: libodialog removed
OLD_FILES+=usr/lib/libodialog.a
OLD_FILES+=usr/lib/libodialog.so
OLD_LIBS+=usr/lib/libodialog.so.7
OLD_FILES+=usr/lib/libodialog_p.a
OLD_FILES+=usr/lib32/libodialog.a
OLD_FILES+=usr/lib32/libodialog.so
OLD_LIBS+=usr/lib32/libodialog.so.7
OLD_FILES+=usr/lib32/libodialog_p.a
# 20110930: sysinstall removed
OLD_FILES+=usr/sbin/sysinstall
OLD_FILES+=usr/share/man/man8/sysinstall.8.gz
OLD_FILES+=usr/lib/libftpio.a
OLD_FILES+=usr/lib/libftpio.so
OLD_LIBS+=usr/lib/libftpio.so.8
OLD_FILES+=usr/lib/libftpio_p.a
OLD_FILES+=usr/lib32/libftpio.a
OLD_FILES+=usr/lib32/libftpio.so
OLD_LIBS+=usr/lib32/libftpio.so.8
OLD_FILES+=usr/lib32/libftpio_p.a
OLD_FILES+=usr/include/ftpio.h
OLD_FILES+=usr/share/man/man3/ftpio.3.gz
# 20110915: rename congestion control manpages
OLD_FILES+=usr/share/man/man9/cc.9.gz
# 20110831: atomic page flags operations
OLD_FILES+=usr/share/man/man9/vm_page_flag.9.gz
OLD_FILES+=usr/share/man/man9/vm_page_flag_clear.9.gz
OLD_FILES+=usr/share/man/man9/vm_page_flag_set.9.gz
# 20110828: library version bump for 9.0
OLD_LIBS+=lib/libcam.so.5
OLD_LIBS+=lib/libpcap.so.7
OLD_LIBS+=lib/libufs.so.5
OLD_LIBS+=usr/lib/libbsnmp.so.5
OLD_LIBS+=usr/lib/libdwarf.so.2
OLD_LIBS+=usr/lib/libopie.so.6
OLD_LIBS+=usr/lib/librtld_db.so.1
OLD_LIBS+=usr/lib/libtacplus.so.4
OLD_LIBS+=usr/lib32/libcam.so.5
OLD_LIBS+=usr/lib32/libpcap.so.7
OLD_LIBS+=usr/lib32/libufs.so.5
OLD_LIBS+=usr/lib32/libbsnmp.so.5
OLD_LIBS+=usr/lib32/libdwarf.so.2
OLD_LIBS+=usr/lib32/libopie.so.6
OLD_LIBS+=usr/lib32/librtld_db.so.1
OLD_LIBS+=usr/lib32/libtacplus.so.4
# 20110817: no more acd.4, ad.4, afd.4 and ast.4
OLD_FILES+=usr/share/man/man4/acd.4.gz
OLD_FILES+=usr/share/man/man4/ad.4.gz
OLD_FILES+=usr/share/man/man4/afd.4.gz
OLD_FILES+=usr/share/man/man4/ast.4.gz
# 20110718: no longer useful in the age of rc.d
OLD_FILES+=usr/sbin/named.reconfig
OLD_FILES+=usr/sbin/named.reload
OLD_FILES+=usr/share/man/man8/named.reconfig.8.gz
OLD_FILES+=usr/share/man/man8/named.reload.8.gz
# 20110716: bind 9.8.0 import
OLD_LIBS+=usr/lib/liblwres.so.50
OLD_FILES+=usr/share/doc/bind9/KNOWN-DEFECTS
OLD_FILES+=usr/share/doc/bind9/NSEC3-NOTES
OLD_FILES+=usr/share/doc/bind9/README.idnkit
OLD_FILES+=usr/share/doc/bind9/README.pkcs11
# 20110709: vm_map_clean.9 -> vm_map_sync.9
OLD_FILES+=usr/share/man/man9/vm_map_clean.9.gz
# 20110709: Catch up with removal of these functions.
OLD_FILES+=usr/share/man/man9/vm_page_copy.9.gz
OLD_FILES+=usr/share/man/man9/vm_page_protect.9.gz
OLD_FILES+=usr/share/man/man9/vm_page_zero_fill.9.gz
# 20110707: script no longer needed by /etc/rc.d/nfsd
OLD_FILES+=etc/rc.d/nfsserver
# 20110705: files moved so both NFS clients can share them
OLD_FILES+=usr/include/nfsclient/krpc.h
OLD_FILES+=usr/include/nfsclient/nfsdiskless.h
# 20110705: the switch of default NFS client to the new one
OLD_FILES+=sbin/mount_newnfs
OLD_FILES+=usr/share/man/man8/mount_newnfs.8.gz
OLD_FILES+=usr/include/nfsclient/nfs_kdtrace.h
# 20110628: calendar.msk removed
OLD_FILES+=usr/share/calendar/ru_RU.KOI8-R/calendar.msk
# 20110517: libpkg removed
OLD_FILES+=usr/include/pkg.h
OLD_FILES+=usr/lib/libpkg.a
OLD_FILES+=usr/lib/libpkg.so
OLD_LIBS+=usr/lib/libpkg.so.0
OLD_FILES+=usr/lib/libpkg_p.a
OLD_FILES+=usr/lib32/libpkg.a
OLD_FILES+=usr/lib32/libpkg.so
OLD_LIBS+=usr/lib32/libpkg.so.0
OLD_FILES+=usr/lib32/libpkg_p.a
# 20110517: libsbuf version bump
OLD_LIBS+=lib/libsbuf.so.5
OLD_LIBS+=usr/lib32/libsbuf.so.5
# 20110502: new clang import which bumps version from 2.9 to 3.0
OLD_FILES+=usr/include/clang/2.9/emmintrin.h
OLD_FILES+=usr/include/clang/2.9/mm_malloc.h
OLD_FILES+=usr/include/clang/2.9/mmintrin.h
OLD_FILES+=usr/include/clang/2.9/pmmintrin.h
OLD_FILES+=usr/include/clang/2.9/tmmintrin.h
OLD_FILES+=usr/include/clang/2.9/xmmintrin.h
OLD_DIRS+=usr/include/clang/2.9
# 20110417: removal of Objective-C support
OLD_FILES+=usr/include/objc/encoding.h
OLD_FILES+=usr/include/objc/hash.h
OLD_FILES+=usr/include/objc/NXConstStr.h
OLD_FILES+=usr/include/objc/objc-api.h
OLD_FILES+=usr/include/objc/objc-decls.h
OLD_FILES+=usr/include/objc/objc-list.h
OLD_FILES+=usr/include/objc/objc.h
OLD_FILES+=usr/include/objc/Object.h
OLD_FILES+=usr/include/objc/Protocol.h
OLD_FILES+=usr/include/objc/runtime.h
OLD_FILES+=usr/include/objc/sarray.h
OLD_FILES+=usr/include/objc/thr.h
OLD_FILES+=usr/include/objc/typedstream.h
OLD_FILES+=usr/lib/libobjc.a
OLD_FILES+=usr/lib/libobjc.so
OLD_FILES+=usr/lib/libobjc_p.a
OLD_FILES+=usr/libexec/cc1obj
OLD_LIBS+=usr/lib/libobjc.so.4
OLD_DIRS+=usr/include/objc
OLD_FILES+=usr/lib32/libobjc.a
OLD_FILES+=usr/lib32/libobjc.so
OLD_FILES+=usr/lib32/libobjc_p.a
OLD_LIBS+=usr/lib32/libobjc.so.4
# 20110331: firmware.img created at build time
OLD_FILES+=usr/share/examples/kld/firmware/fwimage/firmware.img
# 20110224: sticky.8 -> sticky.7
OLD_FILES+=usr/share/man/man8/sticky.8.gz
# 20110220: new clang import which bumps version from 2.8 to 2.9
OLD_FILES+=usr/include/clang/2.8/emmintrin.h
OLD_FILES+=usr/include/clang/2.8/mm_malloc.h
OLD_FILES+=usr/include/clang/2.8/mmintrin.h
OLD_FILES+=usr/include/clang/2.8/pmmintrin.h
OLD_FILES+=usr/include/clang/2.8/tmmintrin.h
OLD_FILES+=usr/include/clang/2.8/xmmintrin.h
OLD_DIRS+=usr/include/clang/2.8
# 20110119: netinet/sctp_cc_functions.h removed
OLD_FILES+=usr/include/netinet/sctp_cc_functions.h
# 20110119: Remove SYSCTL_*X* sysctl additions.
OLD_FILES+=usr/share/man/man9/SYSCTL_XINT.9.gz \
    usr/share/man/man9/SYSCTL_XLONG.9.gz

# 20110112: Update dialog to new version, rename old libdialog to libodialog,
#     removing associated man pages and header files.
OLD_FILES+=usr/share/man/man3/draw_shadow.3.gz \
    usr/share/man/man3/draw_box.3.gz usr/share/man/man3/line_edit.3.gz \
    usr/share/man/man3/strheight.3.gz usr/share/man/man3/strwidth.3.gz \
    usr/share/man/man3/dialog_create_rc.3.gz \
    usr/share/man/man3/dialog_yesno.3.gz usr/share/man/man3/dialog_noyes.3.gz \
    usr/share/man/man3/dialog_prgbox.3.gz \
    usr/share/man/man3/dialog_textbox.3.gz usr/share/man/man3/dialog_menu.3.gz \
    usr/share/man/man3/dialog_checklist.3.gz \
    usr/share/man/man3/dialog_radiolist.3.gz \
    usr/share/man/man3/dialog_inputbox.3.gz \
    usr/share/man/man3/dialog_clear_norefresh.3.gz \
    usr/share/man/man3/dialog_clear.3.gz usr/share/man/man3/dialog_update.3.gz \
    usr/share/man/man3/dialog_fselect.3.gz \
    usr/share/man/man3/dialog_notify.3.gz \
    usr/share/man/man3/dialog_mesgbox.3.gz \
    usr/share/man/man3/dialog_gauge.3.gz usr/share/man/man3/init_dialog.3.gz \
    usr/share/man/man3/end_dialog.3.gz usr/share/man/man3/use_helpfile.3.gz \
    usr/share/man/man3/use_helpline.3.gz usr/share/man/man3/get_helpline.3.gz \
    usr/share/man/man3/restore_helpline.3.gz \
    usr/share/man/man3/dialog_msgbox.3.gz \
    usr/share/man/man3/dialog_ftree.3.gz usr/share/man/man3/dialog_tree.3.gz \
    usr/share/examples/dialog/README usr/share/examples/dialog/checklist \
    usr/share/examples/dialog/ftreebox usr/share/examples/dialog/infobox \
    usr/share/examples/dialog/inputbox usr/share/examples/dialog/menubox \
    usr/share/examples/dialog/msgbox usr/share/examples/dialog/prgbox \
    usr/share/examples/dialog/radiolist usr/share/examples/dialog/textbox \
    usr/share/examples/dialog/treebox usr/share/examples/dialog/yesno \
    usr/share/examples/libdialog/Makefile usr/share/examples/libdialog/check1.c\
    usr/share/examples/libdialog/check2.c usr/share/examples/libdialog/check3.c\
    usr/share/examples/libdialog/dselect.c \
    usr/share/examples/libdialog/fselect.c \
    usr/share/examples/libdialog/ftree1.c \
    usr/share/examples/libdialog/ftree1.test \
    usr/share/examples/libdialog/ftree2.c \
    usr/share/examples/libdialog/ftree2.test \
    usr/share/examples/libdialog/gauge.c usr/share/examples/libdialog/input1.c \
    usr/share/examples/libdialog/input2.c usr/share/examples/libdialog/menu1.c \
    usr/share/examples/libdialog/menu2.c usr/share/examples/libdialog/menu3.c \
    usr/share/examples/libdialog/msg.c usr/share/examples/libdialog/prgbox.c \
    usr/share/examples/libdialog/radio1.c usr/share/examples/libdialog/radio2.c\
    usr/share/examples/libdialog/radio3.c usr/share/examples/libdialog/text.c \
    usr/share/examples/libdialog/tree.c usr/share/examples/libdialog/yesno.c
OLD_DIRS+=usr/share/examples/libdialog usr/share/examples/dialog
# 20101114: Remove long-obsolete MAKEDEV.8
OLD_FILES+=usr/share/man/man8/MAKEDEV.8.gz
# 20101112: vgonel(9) has gone to private API a while ago
OLD_FILES+=usr/share/man/man9/vgonel.9.gz
# 20101112: removed gasp.info
OLD_FILES+=usr/share/info/gasp.info.gz
# 20101109: machine/mutex.h removed
OLD_FILES+=usr/include/machine/mutex.h
# 20101109: headers moved from machine/ to x86/
.if ${TARGET_ARCH} == "amd64" || ${TARGET_ARCH} == "i386"
OLD_FILES+=usr/include/machine/mptable.h
.endif
# 20101101: headers moved from machine/ to x86/
.if ${TARGET_ARCH} == "amd64" || ${TARGET_ARCH} == "i386"
OLD_FILES+=usr/include/machine/apicreg.h
OLD_FILES+=usr/include/machine/mca.h
.endif
# 20101020: catch up with vm_page_sleep_if_busy rename
OLD_FILES+=usr/share/man/man9/vm_page_sleep_busy.9.gz
# 20101018: taskqueue(9) updates
OLD_FILES+=usr/share/man/man9/taskqueue_find.9.gz
# 20101011: removed subblock.h from liblzma
OLD_FILES+=usr/include/lzma/subblock.h
# 20101002: removed manpath.config
OLD_FILES+=etc/manpath.config
OLD_FILES+=usr/share/examples/etc/manpath.config
# 20100910: renamed sbuf_overflowed to sbuf_error
OLD_FILES+=usr/share/man/man9/sbuf_overflowed.9.gz
# 20100815: retired last traces of chooseproc(9)
OLD_FILES+=usr/share/man/man9/chooseproc.9.gz
# 20100806: removal of unused libcompat routines
OLD_FILES+=usr/share/man/man3/ascftime.3.gz
OLD_FILES+=usr/share/man/man3/cfree.3.gz
OLD_FILES+=usr/share/man/man3/cftime.3.gz
OLD_FILES+=usr/share/man/man3/getpw.3.gz
# 20100801: tzdata2010k import
OLD_FILES+=usr/share/zoneinfo/Pacific/Ponape
OLD_FILES+=usr/share/zoneinfo/Pacific/Truk
# 20100725: acpi_aiboost(4) removal.
OLD_FILES+=usr/share/man/man4/acpi_aiboost.4.gz
# 20100724: nfsclient/nfs_lock.h moved to nfs/nfs_lock.h
OLD_FILES+=usr/include/nfsclient/nfs_lock.h
# 20100720: new clang import which bumps version from 2.0 to 2.8
OLD_FILES+=usr/include/clang/2.0/emmintrin.h
OLD_FILES+=usr/include/clang/2.0/mm_malloc.h
OLD_FILES+=usr/include/clang/2.0/mmintrin.h
OLD_FILES+=usr/include/clang/2.0/pmmintrin.h
OLD_FILES+=usr/include/clang/2.0/tmmintrin.h
OLD_FILES+=usr/include/clang/2.0/xmmintrin.h
OLD_DIRS+=usr/include/clang/2.0
# 20100706: removed pc-sysinstall's detect-vmware.sh
OLD_FILES+=usr/share/pc-sysinstall/backend-query/detect-vmware.sh
# 20100701: [powerpc] removed <machine/intr.h>
.if ${TARGET_ARCH} == "powerpc"
OLD_FILES+=usr/include/machine/intr.h
.endif
# 20100514: library version bump for versioned symbols for liblzma
OLD_LIBS+=usr/lib/liblzma.so.0
OLD_LIBS+=usr/lib32/liblzma.so.0
# 20100511: move GCC-specific headers to /usr/include/gcc
.if ${TARGET_ARCH} == "amd64" || ${TARGET_ARCH} == "i386"
OLD_FILES+=usr/include/emmintrin.h
OLD_FILES+=usr/include/mm_malloc.h
OLD_FILES+=usr/include/pmmintrin.h
OLD_FILES+=usr/include/xmmintrin.h
.endif
.if ${TARGET_ARCH} == "amd64" || ${TARGET_ARCH} == "i386" || ${TARGET_ARCH} == "arm"
OLD_FILES+=usr/include/mmintrin.h
.endif
.if ${TARGET_ARCH} == "ia64"
OLD_FILES+=usr/include/ia64intrin.h
.endif
.if ${TARGET_ARCH} == "powerpc"
OLD_FILES+=usr/include/altivec.h
OLD_FILES+=usr/include/ppc-asm.h
OLD_FILES+=usr/include/spe.h
.endif
# 20100416: [mips] removed <machine/psl.h>
.if ${TARGET_ARCH} == "mips"
OLD_FILES+=usr/include/machine/psl.h
.endif
# 20100415: [mips] removed unused headers
.if ${TARGET_ARCH} == "mips"
OLD_FILES+=usr/include/machine/archtype.h
OLD_FILES+=usr/include/machine/segments.h
OLD_FILES+=usr/include/machine/rm7000.h
OLD_FILES+=usr/include/machine/defs.h
OLD_FILES+=usr/include/machine/queue.h
.endif
# 20100326: [ia64] removed <machine/nexusvar.h>
.if ${TARGET_ARCH} == "ia64"
OLD_FILES+=usr/include/machine/nexusvar.h
.endif
# 20100326: gcpio removal
OLD_FILES+=usr/bin/gcpio
OLD_FILES+=usr/share/info/cpio.info.gz
OLD_FILES+=usr/share/man/man1/gcpio.1.gz
# 20100322: libz update
OLD_LIBS+=lib/libz.so.5
OLD_LIBS+=usr/lib32/libz.so.5
# 20100314: removal of regexp.h
OLD_FILES+=usr/include/regexp.h
OLD_FILES+=usr/share/man/man3/regexp.3.gz
OLD_FILES+=usr/share/man/man3/regsub.3.gz
# 20100303: actual removal of utmp.h
OLD_FILES+=usr/include/utmp.h
# 20100227: [ia64] removed <machine/sapicreg.h> and <machine/sapicvar.h>
.if ${TARGET_ARCH} == "ia64"
OLD_FILES+=usr/include/machine/sapicreg.h
OLD_FILES+=usr/include/machine/sapicvar.h
.endif
# 20100208: man pages moved
.if ${TARGET_ARCH} == "i386"
OLD_FILES+=usr/share/man/man4/i386/alpm.4.gz
OLD_FILES+=usr/share/man/man4/i386/amdpm.4.gz
OLD_FILES+=usr/share/man/man4/i386/mcd.4.gz
OLD_FILES+=usr/share/man/man4/i386/padlock.4.gz
OLD_FILES+=usr/share/man/man4/i386/pcf.4.gz
OLD_FILES+=usr/share/man/man4/i386/scd.4.gz
OLD_FILES+=usr/share/man/man4/i386/viapm.4.gz
.endif
# 20100122: move BSDL bc/dc USD documents to /usr/share/doc/usd
OLD_FILES+=usr/share/doc/papers/bc.ascii.gz
OLD_FILES+=usr/share/doc/papers/dc.ascii.gz
# 20100120: replacing GNU bc/dc with BSDL versions
OLD_FILES+=usr/share/examples/bc/ckbook.b
OLD_FILES+=usr/share/examples/bc/pi.b
OLD_FILES+=usr/share/examples/bc/primes.b
OLD_FILES+=usr/share/examples/bc/twins.b
OLD_FILES+=usr/share/info/dc.info.gz
OLD_DIRS+=usr/share/examples/bc
# 20100114: removal of ttyslot(3)
OLD_FILES+=usr/share/man/man3/ttyslot.3.gz
# 20100113: remove utmp.h, replace it by utmpx.h
OLD_FILES+=usr/share/man/man3/login.3.gz
OLD_FILES+=usr/share/man/man3/logout.3.gz
OLD_FILES+=usr/share/man/man3/logwtmp.3.gz
OLD_FILES+=usr/share/man/man3/ulog_endutxent.3.gz
OLD_FILES+=usr/share/man/man3/ulog_getutxent.3.gz
OLD_FILES+=usr/share/man/man3/ulog_getutxline.3.gz
OLD_FILES+=usr/share/man/man3/ulog_getutxuser.3.gz
OLD_FILES+=usr/share/man/man3/ulog_pututxline.3.gz
OLD_FILES+=usr/share/man/man3/ulog_setutxent.3.gz
OLD_FILES+=usr/share/man/man3/ulog_setutxfile.3.gz
OLD_FILES+=usr/share/man/man5/lastlog.5.gz
OLD_FILES+=usr/share/man/man5/utmp.5.gz
OLD_FILES+=usr/share/man/man5/wtmp.5.gz
OLD_LIBS+=lib/libutil.so.8
OLD_LIBS+=usr/lib32/libutil.so.8
# 20100105: new userland semaphore implementation
OLD_FILES+=usr/include/sys/semaphore.h
# 20100103: ntptrace(8) removed
OLD_FILES+=usr/sbin/ntptrace
OLD_FILES+=usr/share/man/man8/ntptrace.8.gz
# 20091229: remove no longer relevant examples
OLD_FILES+=usr/share/examples/pppd/auth-down.sample
OLD_FILES+=usr/share/examples/pppd/auth-up.sample
OLD_FILES+=usr/share/examples/pppd/chap-secrets.sample
OLD_FILES+=usr/share/examples/pppd/chat.sh.sample
OLD_FILES+=usr/share/examples/pppd/ip-down.sample
OLD_FILES+=usr/share/examples/pppd/ip-up.sample
OLD_FILES+=usr/share/examples/pppd/options.sample
OLD_FILES+=usr/share/examples/pppd/pap-secrets.sample
OLD_FILES+=usr/share/examples/pppd/ppp.deny.sample
OLD_FILES+=usr/share/examples/pppd/ppp.shells.sample
OLD_DIRS+=usr/share/examples/pppd
OLD_FILES+=usr/share/examples/slattach/unit-command.sh
OLD_DIRS+=usr/share/examples/slattach
OLD_FILES+=usr/share/examples/sliplogin/slip.hosts
OLD_FILES+=usr/share/examples/sliplogin/slip.login
OLD_FILES+=usr/share/examples/sliplogin/slip.logout
OLD_FILES+=usr/share/examples/sliplogin/slip.slparms
OLD_DIRS+=usr/share/examples/sliplogin
OLD_FILES+=usr/share/examples/startslip/sldown.sh
OLD_FILES+=usr/share/examples/startslip/slip.sh
OLD_FILES+=usr/share/examples/startslip/slup.sh
OLD_DIRS+=usr/share/examples/startslip
# 20091202: unify rc.firewall and rc.firewall6.
OLD_FILES+=etc/rc.d/ip6fw
OLD_FILES+=etc/rc.firewall6
OLD_FILES+=usr/share/examples/etc/rc.firewall6
# 20091117: removal of rc.early(8) link
OLD_FILES+=usr/share/man/man8/rc.early.8.gz
# 20091117: usr/share/zoneinfo/GMT link removed
OLD_FILES+=usr/share/zoneinfo/GMT
# 20091027: pselect.3 implemented as syscall
OLD_FILES+=usr/share/man/man3/pselect.3.gz
# 20091005: fusword.9 and susword.9 removed
OLD_FILES+=usr/share/man/man9/fusword.9.gz
OLD_FILES+=usr/share/man/man9/susword.9.gz
# 20090909: vesa and dpms promoted to be i386/amd64 common
OLD_FILES+=usr/include/machine/pc/vesa.h
OLD_FILES+=usr/share/man/man4/i386/dpms.4.gz
# 20090904: remove lukemftpd
OLD_FILES+=usr/libexec/lukemftpd
OLD_FILES+=usr/share/man/man5/ftpd.conf.5.gz
OLD_FILES+=usr/share/man/man5/ftpusers.5.gz
OLD_FILES+=usr/share/man/man8/lukemftpd.8.gz
# 20090902: BSD.{x11,x11-4}.dist are dead and BSD.local.dist lives in ports/
OLD_FILES+=etc/mtree/BSD.local.dist
OLD_FILES+=etc/mtree/BSD.x11.dist
OLD_FILES+=etc/mtree/BSD.x11-4.dist
# 20090812: net80211 documentation overhaul
OLD_FILES+=usr/share/man/man9/ieee80211_add_rates.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_add_xrates.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_alloc_node.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_attach.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_begin_scan.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_cfgget.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_cfgset.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_chan2ieee.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_chan2mode.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_create_ibss.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_crypto_attach.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_crypto_detach.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_decap.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_dump_pkt.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_dup_bss.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_encap.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_end_scan.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_find_node.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_fix_rate.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_free_allnodes.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_ieee2mhz.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_ioctl.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_lookup_node.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_media2rate.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_media_change.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_media_init.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_media_status.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_mhz2ieee.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_next_scan.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_node_attach.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_node_detach.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_node_lateattach.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_print_essid.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_proto_attach.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_proto_detach.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_rate2media.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_recv_mgmt.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_send_mgmt.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_setmode.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_timeout_nodes.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_watchdog.9.gz
OLD_FILES+=usr/share/man/man9/ieee80211_wep_crypt.9.gz
# 20090801: vimage.h removed in favour of vnet.h
OLD_FILES+=usr/include/sys/vimage.h
# 20101208: libbsnmp was moved to usr/lib
OLD_LIBS+=lib/libbsnmp.so.5
# 20090719: library version bump for 8.0
OLD_LIBS+=lib/libalias.so.6
OLD_LIBS+=lib/libavl.so.1
OLD_LIBS+=lib/libbegemot.so.3
OLD_LIBS+=lib/libbsdxml.so.3
OLD_LIBS+=lib/libbsnmp.so.4
OLD_LIBS+=lib/libcam.so.4
OLD_LIBS+=lib/libcrypt.so.4
OLD_LIBS+=lib/libcrypto.so.5
OLD_LIBS+=lib/libctf.so.1
OLD_LIBS+=lib/libdevstat.so.6
OLD_LIBS+=lib/libdtrace.so.1
OLD_LIBS+=lib/libedit.so.6
OLD_LIBS+=lib/libgeom.so.4
OLD_LIBS+=lib/libipsec.so.3
OLD_LIBS+=lib/libipx.so.4
OLD_LIBS+=lib/libkiconv.so.3
OLD_LIBS+=lib/libkvm.so.4
OLD_LIBS+=lib/libmd.so.4
OLD_LIBS+=lib/libncurses.so.7
OLD_LIBS+=lib/libncursesw.so.7
OLD_LIBS+=lib/libnvpair.so.1
OLD_LIBS+=lib/libpcap.so.6
OLD_LIBS+=lib/libreadline.so.7
OLD_LIBS+=lib/libsbuf.so.4
OLD_LIBS+=lib/libufs.so.4
OLD_LIBS+=lib/libumem.so.1
OLD_LIBS+=lib/libutil.so.7
OLD_LIBS+=lib/libuutil.so.1
OLD_LIBS+=lib/libz.so.4
OLD_LIBS+=lib/libzfs.so.1
OLD_LIBS+=lib/libzpool.so.1
OLD_LIBS+=usr/lib/libarchive.so.4
OLD_LIBS+=usr/lib/libauditd.so.4
OLD_LIBS+=usr/lib/libbluetooth.so.3
OLD_LIBS+=usr/lib/libbsm.so.2
OLD_LIBS+=usr/lib/libbz2.so.3
OLD_LIBS+=usr/lib/libcalendar.so.4
OLD_LIBS+=usr/lib/libcom_err.so.4
OLD_LIBS+=usr/lib/libdevinfo.so.4
OLD_LIBS+=usr/lib/libdialog.so.6
OLD_LIBS+=usr/lib/libdwarf.so.1
OLD_LIBS+=usr/lib/libfetch.so.5
OLD_LIBS+=usr/lib/libform.so.4
OLD_LIBS+=usr/lib/libformw.so.4
OLD_LIBS+=usr/lib/libftpio.so.7
OLD_LIBS+=usr/lib/libgnuregex.so.4
OLD_LIBS+=usr/lib/libgpib.so.2
OLD_LIBS+=usr/lib/libhistory.so.7
OLD_LIBS+=usr/lib/libmagic.so.3
OLD_LIBS+=usr/lib/libmemstat.so.2
OLD_LIBS+=usr/lib/libmenu.so.4
OLD_LIBS+=usr/lib/libmenuw.so.4
OLD_LIBS+=usr/lib/libmilter.so.4
OLD_LIBS+=usr/lib/libncp.so.3
OLD_LIBS+=usr/lib/libnetgraph.so.3
OLD_LIBS+=usr/lib/libngatm.so.3
OLD_LIBS+=usr/lib/libobjc.so.3
OLD_LIBS+=usr/lib/libopie.so.5
OLD_LIBS+=usr/lib/libpam.so.4
OLD_LIBS+=usr/lib/libpanel.so.4
OLD_LIBS+=usr/lib/libpanelw.so.4
OLD_LIBS+=usr/lib/libpmc.so.4
OLD_LIBS+=usr/lib/libproc.so.1
OLD_LIBS+=usr/lib/libradius.so.3
OLD_LIBS+=usr/lib/librpcsvc.so.4
OLD_LIBS+=usr/lib/libsdp.so.3
OLD_LIBS+=usr/lib/libsmb.so.3
OLD_LIBS+=usr/lib/libssh.so.4
OLD_LIBS+=usr/lib/libssl.so.5
OLD_LIBS+=usr/lib/libtacplus.so.3
OLD_LIBS+=usr/lib/libugidfw.so.3
OLD_LIBS+=usr/lib/libusb.so.1
OLD_LIBS+=usr/lib/libusbhid.so.3
OLD_LIBS+=usr/lib/libvgl.so.5
OLD_LIBS+=usr/lib/libwrap.so.5
OLD_LIBS+=usr/lib/libypclnt.so.3
OLD_LIBS+=usr/lib/pam_chroot.so.4
OLD_LIBS+=usr/lib/pam_deny.so.4
OLD_LIBS+=usr/lib/pam_echo.so.4
OLD_LIBS+=usr/lib/pam_exec.so.4
OLD_LIBS+=usr/lib/pam_ftpusers.so.4
OLD_LIBS+=usr/lib/pam_group.so.4
OLD_LIBS+=usr/lib/pam_guest.so.4
OLD_LIBS+=usr/lib/pam_krb5.so.4
OLD_LIBS+=usr/lib/pam_ksu.so.4
OLD_LIBS+=usr/lib/pam_lastlog.so.4
OLD_LIBS+=usr/lib/pam_login_access.so.4
OLD_LIBS+=usr/lib/pam_nologin.so.4
OLD_LIBS+=usr/lib/pam_opie.so.4
OLD_LIBS+=usr/lib/pam_opieaccess.so.4
OLD_LIBS+=usr/lib/pam_passwdqc.so.4
OLD_LIBS+=usr/lib/pam_permit.so.4
OLD_LIBS+=usr/lib/pam_radius.so.4
OLD_LIBS+=usr/lib/pam_rhosts.so.4
OLD_LIBS+=usr/lib/pam_rootok.so.4
OLD_LIBS+=usr/lib/pam_securetty.so.4
OLD_LIBS+=usr/lib/pam_self.so.4
OLD_LIBS+=usr/lib/pam_ssh.so.4
OLD_LIBS+=usr/lib/pam_tacplus.so.4
OLD_LIBS+=usr/lib/pam_unix.so.4
OLD_LIBS+=usr/lib/snmp_atm.so.5
OLD_LIBS+=usr/lib/snmp_bridge.so.5
OLD_LIBS+=usr/lib/snmp_hostres.so.5
OLD_LIBS+=usr/lib/snmp_mibII.so.5
OLD_LIBS+=usr/lib/snmp_netgraph.so.5
OLD_LIBS+=usr/lib/snmp_pf.so.5
OLD_LIBS+=usr/lib32/libalias.so.6
OLD_LIBS+=usr/lib32/libarchive.so.4
OLD_LIBS+=usr/lib32/libauditd.so.4
OLD_LIBS+=usr/lib32/libavl.so.1
OLD_LIBS+=usr/lib32/libbegemot.so.3
OLD_LIBS+=usr/lib32/libbluetooth.so.3
OLD_LIBS+=usr/lib32/libbsdxml.so.3
OLD_LIBS+=usr/lib32/libbsm.so.2
OLD_LIBS+=usr/lib32/libbsnmp.so.4
OLD_LIBS+=usr/lib32/libbz2.so.3
OLD_LIBS+=usr/lib32/libcalendar.so.4
OLD_LIBS+=usr/lib32/libcam.so.4
OLD_LIBS+=usr/lib32/libcom_err.so.4
OLD_LIBS+=usr/lib32/libcrypt.so.4
OLD_LIBS+=usr/lib32/libcrypto.so.5
OLD_LIBS+=usr/lib32/libctf.so.1
OLD_LIBS+=usr/lib32/libdevinfo.so.4
OLD_LIBS+=usr/lib32/libdevstat.so.6
OLD_LIBS+=usr/lib32/libdialog.so.6
OLD_LIBS+=usr/lib32/libdtrace.so.1
OLD_LIBS+=usr/lib32/libdwarf.so.1
OLD_LIBS+=usr/lib32/libedit.so.6
OLD_LIBS+=usr/lib32/libfetch.so.5
OLD_LIBS+=usr/lib32/libform.so.4
OLD_LIBS+=usr/lib32/libformw.so.4
OLD_LIBS+=usr/lib32/libftpio.so.7
OLD_LIBS+=usr/lib32/libgeom.so.4
OLD_LIBS+=usr/lib32/libgnuregex.so.4
OLD_LIBS+=usr/lib32/libgpib.so.2
OLD_LIBS+=usr/lib32/libhistory.so.7
OLD_LIBS+=usr/lib32/libipsec.so.3
OLD_LIBS+=usr/lib32/libipx.so.4
OLD_LIBS+=usr/lib32/libkiconv.so.3
OLD_LIBS+=usr/lib32/libkvm.so.4
OLD_LIBS+=usr/lib32/libmagic.so.3
OLD_LIBS+=usr/lib32/libmd.so.4
OLD_LIBS+=usr/lib32/libmemstat.so.2
OLD_LIBS+=usr/lib32/libmenu.so.4
OLD_LIBS+=usr/lib32/libmenuw.so.4
OLD_LIBS+=usr/lib32/libmilter.so.4
OLD_LIBS+=usr/lib32/libncp.so.3
OLD_LIBS+=usr/lib32/libncurses.so.7
OLD_LIBS+=usr/lib32/libncursesw.so.7
OLD_LIBS+=usr/lib32/libnetgraph.so.3
OLD_LIBS+=usr/lib32/libngatm.so.3
OLD_LIBS+=usr/lib32/libnvpair.so.1
OLD_LIBS+=usr/lib32/libobjc.so.3
OLD_LIBS+=usr/lib32/libopie.so.5
OLD_LIBS+=usr/lib32/libpam.so.4
OLD_LIBS+=usr/lib32/libpanel.so.4
OLD_LIBS+=usr/lib32/libpanelw.so.4
OLD_LIBS+=usr/lib32/libpcap.so.6
OLD_LIBS+=usr/lib32/libpmc.so.4
OLD_LIBS+=usr/lib32/libproc.so.1
OLD_LIBS+=usr/lib32/libradius.so.3
OLD_LIBS+=usr/lib32/libreadline.so.7
OLD_LIBS+=usr/lib32/librpcsvc.so.4
OLD_LIBS+=usr/lib32/libsbuf.so.4
OLD_LIBS+=usr/lib32/libsdp.so.3
OLD_LIBS+=usr/lib32/libsmb.so.3
OLD_LIBS+=usr/lib32/libssh.so.4
OLD_LIBS+=usr/lib32/libssl.so.5
OLD_LIBS+=usr/lib32/libtacplus.so.3
OLD_LIBS+=usr/lib32/libufs.so.4
OLD_LIBS+=usr/lib32/libugidfw.so.3
OLD_LIBS+=usr/lib32/libumem.so.1
OLD_LIBS+=usr/lib32/libusb.so.1
OLD_LIBS+=usr/lib32/libusbhid.so.3
OLD_LIBS+=usr/lib32/libutil.so.7
OLD_LIBS+=usr/lib32/libuutil.so.1
OLD_LIBS+=usr/lib32/libvgl.so.5
OLD_LIBS+=usr/lib32/libwrap.so.5
OLD_LIBS+=usr/lib32/libypclnt.so.3
OLD_LIBS+=usr/lib32/libz.so.4
OLD_LIBS+=usr/lib32/libzfs.so.1
OLD_LIBS+=usr/lib32/libzpool.so.1
OLD_LIBS+=usr/lib32/pam_chroot.so.4
OLD_LIBS+=usr/lib32/pam_deny.so.4
OLD_LIBS+=usr/lib32/pam_echo.so.4
OLD_LIBS+=usr/lib32/pam_exec.so.4
OLD_LIBS+=usr/lib32/pam_ftpusers.so.4
OLD_LIBS+=usr/lib32/pam_group.so.4
OLD_LIBS+=usr/lib32/pam_guest.so.4
OLD_LIBS+=usr/lib32/pam_krb5.so.4
OLD_LIBS+=usr/lib32/pam_ksu.so.4
OLD_LIBS+=usr/lib32/pam_lastlog.so.4
OLD_LIBS+=usr/lib32/pam_login_access.so.4
OLD_LIBS+=usr/lib32/pam_nologin.so.4
OLD_LIBS+=usr/lib32/pam_opie.so.4
OLD_LIBS+=usr/lib32/pam_opieaccess.so.4
OLD_LIBS+=usr/lib32/pam_passwdqc.so.4
OLD_LIBS+=usr/lib32/pam_permit.so.4
OLD_LIBS+=usr/lib32/pam_radius.so.4
OLD_LIBS+=usr/lib32/pam_rhosts.so.4
OLD_LIBS+=usr/lib32/pam_rootok.so.4
OLD_LIBS+=usr/lib32/pam_securetty.so.4
OLD_LIBS+=usr/lib32/pam_self.so.4
OLD_LIBS+=usr/lib32/pam_ssh.so.4
OLD_LIBS+=usr/lib32/pam_tacplus.so.4
OLD_LIBS+=usr/lib32/pam_unix.so.4
# 20090718: the gdm pam.d file is no longer required.
OLD_FILES+=etc/pam.d/gdm
# 20090714: net_add_domain(9) renamed to domain_add(9)
OLD_FILES+=usr/share/man/man9/net_add_domain.9.gz
# 20090713: vimage container structs removed.
OLD_FILES+=usr/include/netinet/vinet.h
OLD_FILES+=usr/include/netinet6/vinet6.h
OLD_FILES+=usr/include/netipsec/vipsec.h
# 20090712: ieee80211.4 -> net80211.4
OLD_FILES+=usr/share/man/man4/ieee80211.4.gz
# 20090711: typo fixed, kproc_resume,.9 -> kproc_resume.9
OLD_FILES+=usr/share/man/man9/kproc_resume,.9.gz
# 20090709: msgctl.3 msgget.3 msgrcv.3 msgsnd.3 manual pages moved
OLD_FILES+=usr/share/man/man3/msgctl.3.gz
OLD_FILES+=usr/share/man/man3/msgget.3.gz
OLD_FILES+=usr/share/man/man3/msgrcv.3.gz
OLD_FILES+=usr/share/man/man3/msgsnd.3.gz
# 20090630: old kernel RPC implementation removal
OLD_FILES+=usr/include/nfs/rpcv2.h
# 20090624: update usbdi(9)
OLD_FILES+=usr/share/man/man9/usbd_abort_default_pipe.9.gz
OLD_FILES+=usr/share/man/man9/usbd_abort_pipe.9.gz
OLD_FILES+=usr/share/man/man9/usbd_alloc_buffer.9.gz
OLD_FILES+=usr/share/man/man9/usbd_alloc_xfer.9.gz
OLD_FILES+=usr/share/man/man9/usbd_clear_endpoint_stall.9.gz
OLD_FILES+=usr/share/man/man9/usbd_clear_endpoint_stall_async.9.gz
OLD_FILES+=usr/share/man/man9/usbd_clear_endpoint_toggle.9.gz
OLD_FILES+=usr/share/man/man9/usbd_close_pipe.9.gz
OLD_FILES+=usr/share/man/man9/usbd_device2interface_handle.9.gz
OLD_FILES+=usr/share/man/man9/usbd_do_request_async.9.gz
OLD_FILES+=usr/share/man/man9/usbd_do_request_flags_pipe.9.gz
OLD_FILES+=usr/share/man/man9/usbd_endpoint_count.9.gz
OLD_FILES+=usr/share/man/man9/usbd_find_edesc.9.gz
OLD_FILES+=usr/share/man/man9/usbd_find_idesc.9.gz
OLD_FILES+=usr/share/man/man9/usbd_free_buffer.9.gz
OLD_FILES+=usr/share/man/man9/usbd_free_xfer.9.gz
OLD_FILES+=usr/share/man/man9/usbd_get_buffer.9.gz
OLD_FILES+=usr/share/man/man9/usbd_get_config.9.gz
OLD_FILES+=usr/share/man/man9/usbd_get_config_desc.9.gz
OLD_FILES+=usr/share/man/man9/usbd_get_config_desc_full.9.gz
OLD_FILES+=usr/share/man/man9/usbd_get_config_descriptor.9.gz
OLD_FILES+=usr/share/man/man9/usbd_get_device_descriptor.9.gz
OLD_FILES+=usr/share/man/man9/usbd_get_endpoint_descriptor.9.gz
OLD_FILES+=usr/share/man/man9/usbd_get_interface_altindex.9.gz
OLD_FILES+=usr/share/man/man9/usbd_get_interface_descriptor.9.gz
OLD_FILES+=usr/share/man/man9/usbd_get_no_alts.9.gz
OLD_FILES+=usr/share/man/man9/usbd_get_quirks.9.gz
OLD_FILES+=usr/share/man/man9/usbd_get_speed.9.gz
OLD_FILES+=usr/share/man/man9/usbd_get_string.9.gz
OLD_FILES+=usr/share/man/man9/usbd_get_string_desc.9.gz
OLD_FILES+=usr/share/man/man9/usbd_get_xfer_status.9.gz
OLD_FILES+=usr/share/man/man9/usbd_interface2device_handle.9.gz
OLD_FILES+=usr/share/man/man9/usbd_interface2endpoint_descriptor.9.gz
OLD_FILES+=usr/share/man/man9/usbd_interface_count.9.gz
OLD_FILES+=usr/share/man/man9/usbd_open_pipe.9.gz
OLD_FILES+=usr/share/man/man9/usbd_open_pipe_intr.9.gz
OLD_FILES+=usr/share/man/man9/usbd_pipe2device_handle.9.gz
OLD_FILES+=usr/share/man/man9/usbd_set_config_index.9.gz
OLD_FILES+=usr/share/man/man9/usbd_set_config_no.9.gz
OLD_FILES+=usr/share/man/man9/usbd_set_interface.9.gz
OLD_FILES+=usr/share/man/man9/usbd_setup_default_xfer.9.gz
OLD_FILES+=usr/share/man/man9/usbd_setup_isoc_xfer.9.gz
OLD_FILES+=usr/share/man/man9/usbd_setup_xfer.9.gz
OLD_FILES+=usr/share/man/man9/usbd_sync_transfer.9.gz
OLD_FILES+=usr/share/man/man9/usbd_transfer.9.gz
OLD_FILES+=usr/share/man/man9/usb_find_desc.9.gz
# 20090623: number of headers needed for a usb driver reduced
OLD_FILES+=usr/include/dev/usb/usb_defs.h
OLD_FILES+=usr/include/dev/usb/usb_error.h
OLD_FILES+=usr/include/dev/usb/usb_handle_request.h
OLD_FILES+=usr/include/dev/usb/usb_hid.h
OLD_FILES+=usr/include/dev/usb/usb_lookup.h
OLD_FILES+=usr/include/dev/usb/usb_mfunc.h
OLD_FILES+=usr/include/dev/usb/usb_parse.h
OLD_FILES+=usr/include/dev/usb/usb_revision.h
# 20090609: devclass_add_driver is no longer public
OLD_FILES+=usr/share/man/man9/devclass_add_driver.9.gz
OLD_FILES+=usr/share/man/man9/devclass_delete_driver.9.gz
OLD_FILES+=usr/share/man/man9/devclass_find_driver.9.gz
# 20090605: removal of clists
OLD_FILES+=usr/include/sys/clist.h
# 20090602: removal of window(1)
OLD_FILES+=usr/bin/window
OLD_FILES+=usr/share/man/man1/window.1.gz
# 20090531: bind 9.6.1rc1 import
OLD_LIBS+=usr/lib/liblwres.so.30
# 20090530: removal of early.sh
OLD_FILES+=etc/rc.d/early.sh
# 20090527: renaming of S{LIST,TAILQ}_REMOVE_NEXT() to _REMOVE_AFTER()
OLD_FILES+=usr/share/man/man3/SLIST_REMOVE_NEXT.3.gz
OLD_FILES+=usr/share/man/man3/STAILQ_REMOVE_NEXT.3.gz
# 20090527: removal of legacy USB stack
OLD_FILES+=usr/include/legacy/dev/usb/dsbr100io.h
OLD_FILES+=usr/include/legacy/dev/usb/ehcireg.h
OLD_FILES+=usr/include/legacy/dev/usb/ehcivar.h
OLD_FILES+=usr/include/legacy/dev/usb/hid.h
OLD_FILES+=usr/include/legacy/dev/usb/if_urtwreg.h
OLD_FILES+=usr/include/legacy/dev/usb/if_urtwvar.h
OLD_FILES+=usr/include/legacy/dev/usb/ohcireg.h
OLD_FILES+=usr/include/legacy/dev/usb/ohcivar.h
OLD_FILES+=usr/include/legacy/dev/usb/rio500_usb.h
OLD_FILES+=usr/include/legacy/dev/usb/rt2573_ucode.h
OLD_FILES+=usr/include/legacy/dev/usb/sl811hsreg.h
OLD_FILES+=usr/include/legacy/dev/usb/sl811hsvar.h
OLD_FILES+=usr/include/legacy/dev/usb/ubser.h
OLD_FILES+=usr/include/legacy/dev/usb/ucomvar.h
OLD_FILES+=usr/include/legacy/dev/usb/udbp.h
OLD_FILES+=usr/include/legacy/dev/usb/uftdireg.h
OLD_FILES+=usr/include/legacy/dev/usb/ugraphire_rdesc.h
OLD_FILES+=usr/include/legacy/dev/usb/uhcireg.h
OLD_FILES+=usr/include/legacy/dev/usb/uhcivar.h
OLD_FILES+=usr/include/legacy/dev/usb/usb.h
OLD_FILES+=usr/include/legacy/dev/usb/usb_mem.h
OLD_FILES+=usr/include/legacy/dev/usb/usb_port.h
OLD_FILES+=usr/include/legacy/dev/usb/usb_quirks.h
OLD_FILES+=usr/include/legacy/dev/usb/usbcdc.h
OLD_FILES+=usr/include/legacy/dev/usb/usbdi.h
OLD_FILES+=usr/include/legacy/dev/usb/usbdi_util.h
OLD_FILES+=usr/include/legacy/dev/usb/usbdivar.h
OLD_FILES+=usr/include/legacy/dev/usb/usbhid.h
OLD_FILES+=usr/include/legacy/dev/usb/uxb360gp_rdesc.h
OLD_DIRS+=usr/include/legacy/dev/usb
OLD_DIRS+=usr/include/legacy/dev
OLD_DIRS+=usr/include/legacy
# 20090526: removal of makekey(8)
OLD_FILES+=usr/libexec/makekey
OLD_FILES+=usr/share/man/man8/makekey.8.gz
# 20090522: removal of University of Michigan NFSv4 client
OLD_FILES+=etc/rc.d/idmapd
OLD_FILES+=sbin/idmapd
OLD_FILES+=sbin/mount_nfs4
OLD_FILES+=usr/share/man/man8/idmapd.8.gz
OLD_FILES+=usr/share/man/man8/mount_nfs4.8.gz
# 20090513: removal of legacy versions of USB network interface drivers
OLD_FILES+=usr/include/legacy/dev/usb/if_upgtvar.h
OLD_FILES+=usr/include/legacy/dev/usb/usb_ethersubr.h
# 20090417: removal of legacy versions of USB network interface drivers
OLD_FILES+=usr/include/legacy/dev/usb/if_auereg.h
OLD_FILES+=usr/include/legacy/dev/usb/if_axereg.h
OLD_FILES+=usr/include/legacy/dev/usb/if_cdcereg.h
OLD_FILES+=usr/include/legacy/dev/usb/if_cuereg.h
OLD_FILES+=usr/include/legacy/dev/usb/if_kuereg.h
OLD_FILES+=usr/include/legacy/dev/usb/if_ruereg.h
OLD_FILES+=usr/include/legacy/dev/usb/if_rumreg.h
OLD_FILES+=usr/include/legacy/dev/usb/if_rumvar.h
OLD_FILES+=usr/include/legacy/dev/usb/if_udavreg.h
OLD_FILES+=usr/include/legacy/dev/usb/if_uralreg.h
OLD_FILES+=usr/include/legacy/dev/usb/if_uralvar.h
OLD_FILES+=usr/include/legacy/dev/usb/if_zydfw.h
OLD_FILES+=usr/include/legacy/dev/usb/if_zydreg.h
OLD_FILES+=usr/include/legacy/dev/usb/kue_fw.h
# 20090416: removal of ar(4), ray(4), sr(4), raycontrol(8)
OLD_FILES+=usr/sbin/raycontrol
OLD_FILES+=usr/share/man/man4/i386/ar.4.gz
OLD_FILES+=usr/share/man/man4/i386/ray.4.gz
OLD_FILES+=usr/share/man/man4/i386/sr.4.gz
OLD_FILES+=usr/share/man/man8/raycontrol.8.gz
# 20090410: VOP_LEASE.9 removed
OLD_FILES+=usr/share/man/man9/VOP_LEASE.9.gz
# 20090406: usb_sw_transfer.h removed
OLD_FILES+=usr/include/dev/usb/usb_sw_transfer.h
# 20090405: removal of if_ppp(4) and if_sl(4)
OLD_FILES+=sbin/slattach rescue/slattach
OLD_FILES+=sbin/startslip rescue/startslip
OLD_FILES+=usr/include/net/if_ppp.h
OLD_FILES+=usr/include/net/if_pppvar.h
OLD_FILES+=usr/include/net/if_slvar.h
OLD_FILES+=usr/include/net/ppp_comp.h
OLD_FILES+=usr/include/net/slip.h
OLD_FILES+=usr/sbin/sliplogin
OLD_FILES+=usr/sbin/slstat
OLD_FILES+=usr/sbin/pppd
OLD_FILES+=usr/sbin/pppstats
OLD_FILES+=usr/share/man/man1/startslip.1.gz
OLD_FILES+=usr/share/man/man4/if_ppp.4.gz
OLD_FILES+=usr/share/man/man4/if_sl.4.gz
OLD_FILES+=usr/share/man/man4/ppp.4.gz
OLD_FILES+=usr/share/man/man4/sl.4.gz
OLD_FILES+=usr/share/man/man8/pppd.8.gz
OLD_FILES+=usr/share/man/man8/pppstats.8.gz
OLD_FILES+=usr/share/man/man8/slattach.8.gz
OLD_FILES+=usr/share/man/man8/slip.8.gz
OLD_FILES+=usr/share/man/man8/sliplogin.8.gz
OLD_FILES+=usr/share/man/man8/slstat.8.gz
# 20090321: libpcap upgraded to 1.0.0
OLD_LIBS+=lib/libpcap.so.5
OLD_LIBS+=usr/lib32/libpcap.so.5
# 20090319: uscanner(4) has been removed
OLD_FILES+=usr/share/man/man4/uscanner.4.gz
# 20090313: k8temp(4) renamed to amdtemp(4)
OLD_FILES+=usr/share/man/man4/k8temp.4.gz
# 20090308: libusb.so.1 renamed
OLD_LIBS+=usr/lib/libusb20.so.1
OLD_FILES+=usr/lib/libusb20.a
OLD_FILES+=usr/lib/libusb20.so
OLD_FILES+=usr/lib/libusb20_p.a
OLD_FILES+=usr/include/libusb20_compat01.h
OLD_FILES+=usr/include/libusb20_compat10.h
OLD_LIBS+=usr/lib32/libusb20.so.1
OLD_FILES+=usr/lib32/libusb20.a
OLD_FILES+=usr/lib32/libusb20.so
OLD_FILES+=usr/lib32/libusb20_p.a
# 20090226: libmp(3) functions renamed
OLD_LIBS+=usr/lib/libmp.so.6
OLD_LIBS+=usr/lib32/libmp.so.6
# 20090223: changeover of USB stacks
OLD_FILES+=usr/include/dev/usb2/include/ufm2_ioctl.h
OLD_FILES+=usr/include/dev/usb2/include/urio2_ioctl.h
OLD_FILES+=usr/include/dev/usb2/include/usb2_cdc.h
OLD_FILES+=usr/include/dev/usb2/include/usb2_defs.h
OLD_FILES+=usr/include/dev/usb2/include/usb2_devid.h
OLD_FILES+=usr/include/dev/usb2/include/usb2_devtable.h
OLD_FILES+=usr/include/dev/usb2/include/usb2_endian.h
OLD_FILES+=usr/include/dev/usb2/include/usb2_error.h
OLD_FILES+=usr/include/dev/usb2/include/usb2_hid.h
OLD_FILES+=usr/include/dev/usb2/include/usb2_ioctl.h
OLD_FILES+=usr/include/dev/usb2/include/usb2_mfunc.h
OLD_FILES+=usr/include/dev/usb2/include/usb2_revision.h
OLD_FILES+=usr/include/dev/usb2/include/usb2_standard.h
OLD_DIRS+=usr/include/dev/usb2/include
OLD_DIRS+=usr/include/dev/usb2
OLD_FILES+=usr/include/dev/usb/dsbr100io.h
OLD_FILES+=usr/include/dev/usb/ehcireg.h
OLD_FILES+=usr/include/dev/usb/ehcivar.h
OLD_FILES+=usr/include/dev/usb/hid.h
OLD_FILES+=usr/include/dev/usb/if_auereg.h
OLD_FILES+=usr/include/dev/usb/if_axereg.h
OLD_FILES+=usr/include/dev/usb/if_cdcereg.h
OLD_FILES+=usr/include/dev/usb/if_cuereg.h
OLD_FILES+=usr/include/dev/usb/if_kuereg.h
OLD_FILES+=usr/include/dev/usb/if_ruereg.h
OLD_FILES+=usr/include/dev/usb/if_rumreg.h
OLD_FILES+=usr/include/dev/usb/if_rumvar.h
OLD_FILES+=usr/include/dev/usb/if_udavreg.h
OLD_FILES+=usr/include/dev/usb/if_upgtvar.h
OLD_FILES+=usr/include/dev/usb/if_uralreg.h
OLD_FILES+=usr/include/dev/usb/if_uralvar.h
OLD_FILES+=usr/include/dev/usb/if_urtwreg.h
OLD_FILES+=usr/include/dev/usb/if_urtwvar.h
OLD_FILES+=usr/include/dev/usb/if_zydfw.h
OLD_FILES+=usr/include/dev/usb/if_zydreg.h
OLD_FILES+=usr/include/dev/usb/kue_fw.h
OLD_FILES+=usr/include/dev/usb/ohcireg.h
OLD_FILES+=usr/include/dev/usb/ohcivar.h
OLD_FILES+=usr/include/dev/usb/rio500_usb.h
OLD_FILES+=usr/include/dev/usb/rt2573_ucode.h
OLD_FILES+=usr/include/dev/usb/sl811hsreg.h
OLD_FILES+=usr/include/dev/usb/sl811hsvar.h
OLD_FILES+=usr/include/dev/usb/ubser.h
OLD_FILES+=usr/include/dev/usb/ucomvar.h
OLD_FILES+=usr/include/dev/usb/udbp.h
OLD_FILES+=usr/include/dev/usb/uftdireg.h
OLD_FILES+=usr/include/dev/usb/ugraphire_rdesc.h
OLD_FILES+=usr/include/dev/usb/uhcireg.h
OLD_FILES+=usr/include/dev/usb/uhcivar.h
OLD_FILES+=usr/include/dev/usb/usb_ethersubr.h
OLD_FILES+=usr/include/dev/usb/usb_mem.h
OLD_FILES+=usr/include/dev/usb/usb_port.h
OLD_FILES+=usr/include/dev/usb/usb_quirks.h
OLD_FILES+=usr/include/dev/usb/usbcdc.h
OLD_FILES+=usr/include/dev/usb/usbdivar.h
OLD_FILES+=usr/include/dev/usb/uxb360gp_rdesc.h
OLD_FILES+=usr/sbin/usbdevs
OLD_FILES+=usr/share/man/man8/usbdevs.8.gz
# 20090203: removal of pccard header files
OLD_FILES+=usr/include/pccard/cardinfo.h
OLD_FILES+=usr/include/pccard/cis.h
OLD_DIRS+=usr/include/pccard
# 20090203: adding_user.8 moved to adding_user.7
OLD_FILES+=usr/share/man/man8/adding_user.8.gz
# 20090122: tzdata2009a import
OLD_FILES+=usr/share/zoneinfo/Asia/Katmandu
# 20090102: file 4.26 import
OLD_FILES+=usr/share/misc/magic.mime
OLD_FILES+=usr/share/misc/magic.mime.mgc
# 20081223: bind 9.4.3 import, nsupdate.8 moved to nsupdate.1
OLD_FILES+=usr/share/man/man8/nsupdate.8.gz
# 20081223: ipprotosw.h removed
OLD_FILES+=usr/include/netinet/ipprotosw.h
# 20081123: vfs_mountedon.9 removed
OLD_FILES+=usr/share/man/man9/vfs_mountedon.9.gz
# 20081023: FREE.9 and MALLOC.9 removed
OLD_FILES+=usr/share/man/man9/FREE.9.gz
OLD_FILES+=usr/share/man/man9/MALLOC.9.gz
# 20080928: removal of inaccurate device_ids(9) manual page
OLD_FILES+=usr/share/man/man9/device_ids.9.gz
OLD_FILES+=usr/share/man/man9/major.9.gz
OLD_FILES+=usr/share/man/man9/minor.9.gz
OLD_FILES+=usr/share/man/man9/umajor.9.gz
OLD_FILES+=usr/share/man/man9/uminor.9.gz
# 20080917: removal of manpage for axed kernel primitive suser(9)
OLD_FILES+=usr/share/man/man9/suser.9.gz
OLD_FILES+=usr/share/man/man9/suser_cred.9.gz
# 20080913: pax removed from rescue
OLD_FILES+=rescue/pax
# 20080823: removal of unneeded pt_chown, to implement grantpt(3)
OLD_FILES+=usr/libexec/pt_chown
# 20080822: ntp 4.2.4p5 import
OLD_FILES+=usr/share/doc/ntp/driver23.html
OLD_FILES+=usr/share/doc/ntp/driver24.html
# 20080821: several man pages moved from man4.i386 to man4
.if ${TARGET_ARCH} == "i386"
OLD_FILES+=usr/share/man/man4/i386/acpi_aiboost.4.gz
OLD_FILES+=usr/share/man/man4/i386/acpi_asus.4.gz
OLD_FILES+=usr/share/man/man4/i386/acpi_fujitsu.4.gz
OLD_FILES+=usr/share/man/man4/i386/acpi_ibm.4.gz
OLD_FILES+=usr/share/man/man4/i386/acpi_panasonic.4.gz
OLD_FILES+=usr/share/man/man4/i386/acpi_sony.4.gz
OLD_FILES+=usr/share/man/man4/i386/acpi_toshiba.4.gz
OLD_FILES+=usr/share/man/man4/i386/ichwd.4.gz
OLD_FILES+=usr/share/man/man4/i386/if_ndis.4.gz
OLD_FILES+=usr/share/man/man4/i386/io.4.gz
OLD_FILES+=usr/share/man/man4/i386/linux.4.gz
OLD_FILES+=usr/share/man/man4/i386/ndis.4.gz
.endif
# 20080820: MPSAFE TTY layer integrated
OLD_FILES+=usr/include/sys/linedisc.h
OLD_FILES+=usr/share/man/man3/posix_openpt.3.gz
# 20080725: sgtty.h removed
OLD_FILES+=usr/include/sgtty.h
# 20080706: bsdlabel(8) removed on powerpc
.if ${TARGET_ARCH} == "powerpc"
OLD_FILES+=sbin/bsdlabel
OLD_FILES+=usr/share/man/man8/bsdlabel.8.gz
.endif
# 20080704: sbsh(4) removed
OLD_FILES+=usr/share/man/man4/if_sbsh.4.gz
OLD_FILES+=usr/share/man/man4/sbsh.4.gz
# 20080704: cnw(4) removed
OLD_FILES+=usr/share/man/man4/if_cnw.4.gz
OLD_FILES+=usr/share/man/man4/cnw.4.gz
# 20080704: oltr(4) removed
.if ${TARGET_ARCH} == "i386"
OLD_FILES+=usr/share/man/man4/i386/if_oltr.4.gz
OLD_FILES+=usr/share/man/man4/i386/oltr.4.gz
.endif
# 20080704: arl(4) removed
.if ${TARGET_ARCH} == "i386"
OLD_FILES+=usr/sbin/arlcontrol
OLD_FILES+=usr/share/man/man4/i386/arl.4.gz
OLD_FILES+=usr/share/man/man8/arlcontrol.8.gz
.endif
# 20080703: sunlabel only for sparc64
.if ${TARGET_ARCH} != "sparc64"
OLD_FILES+=sbin/sunlabel
OLD_FILES+=usr/share/man/man8/sunlabel.8.gz
.endif
# 20080703: bsdlabel & fdisk removed on ia64
.if ${TARGET_ARCH} == "ia64"
OLD_FILES+=sbin/bsdlabel
OLD_FILES+=usr/share/man/man8/bsdlabel.8.gz
OLD_FILES+=usr/share/man/man8/disklabel.8.gz
OLD_FILES+=sbin/fdisk
OLD_FILES+=usr/share/man/man8/fdisk.8.gz
.endif
# 20080701: wpa_supplicant.conf moved to share/examples/etc/
OLD_FILES+=usr/share/examples/wpa_supplicant/wpa_supplicant.conf
OLD_DIRS+=usr/share/examples/wpa_supplicant
# 20080614: pecoff image activator removed
.if ${TARGET_ARCH} == "i386"
OLD_FILES+=usr/include/machine/pecoff_machdep.h
.endif
# 20080614: sgtty removed
OLD_FILES+=usr/include/sys/ttychars.h
OLD_FILES+=usr/include/sys/ttydev.h
OLD_FILES+=usr/share/man/man3/gtty.3.gz
OLD_FILES+=usr/share/man/man3/stty.3.gz
# 20080609: gpt(8) removed
OLD_FILES+=sbin/gpt
OLD_FILES+=usr/share/man/man8/gpt.8.gz
# 20080525: I4B removed
OLD_FILES+=etc/isdn/answer
OLD_FILES+=etc/isdn/isdntel
OLD_FILES+=etc/isdn/record
OLD_FILES+=etc/isdn/tell
OLD_FILES+=etc/isdn/tell-record
OLD_FILES+=etc/isdn/unknown_incoming
OLD_FILES+=etc/isdn/holidays.D
OLD_FILES+=etc/isdn/isdnd.rates.A
OLD_FILES+=etc/isdn/isdnd.rates.D
OLD_FILES+=etc/isdn/isdnd.rates.F
OLD_FILES+=etc/isdn/isdnd.rates.L
OLD_FILES+=etc/isdn/isdnd.rates.UK.BT
OLD_FILES+=etc/isdn/isdnd.rc.sample
OLD_FILES+=etc/isdn/isdntel.alias.sample
OLD_DIRS+=etc/isdn
OLD_FILES+=etc/rc.d/isdnd
OLD_FILES+=usr/include/i4b/i4b_cause.h
OLD_FILES+=usr/include/i4b/i4b_debug.h
OLD_FILES+=usr/include/i4b/i4b_ioctl.h
OLD_FILES+=usr/include/i4b/i4b_rbch_ioctl.h
OLD_FILES+=usr/include/i4b/i4b_tel_ioctl.h
OLD_FILES+=usr/include/i4b/i4b_trace.h
OLD_DIRS+=usr/include/i4b
OLD_FILES+=usr/sbin/dtmfdecode
OLD_FILES+=usr/sbin/g711conv
OLD_FILES+=usr/sbin/isdnd
OLD_FILES+=usr/sbin/isdndebug
OLD_FILES+=usr/sbin/isdndecode
OLD_FILES+=usr/sbin/isdnmonitor
OLD_FILES+=usr/sbin/isdnphone
OLD_FILES+=usr/sbin/isdntel
OLD_FILES+=usr/sbin/isdntelctl
OLD_FILES+=usr/sbin/isdntrace
OLD_FILES+=usr/share/isdn/0.al
OLD_FILES+=usr/share/isdn/1.al
OLD_FILES+=usr/share/isdn/2.al
OLD_FILES+=usr/share/isdn/3.al
OLD_FILES+=usr/share/isdn/4.al
OLD_FILES+=usr/share/isdn/5.al
OLD_FILES+=usr/share/isdn/6.al
OLD_FILES+=usr/share/isdn/7.al
OLD_FILES+=usr/share/isdn/8.al
OLD_FILES+=usr/share/isdn/9.al
OLD_FILES+=usr/share/isdn/beep.al
OLD_FILES+=usr/share/isdn/msg.al
OLD_DIRS+=usr/share/isdn
OLD_FILES+=usr/share/man/man1/dtmfdecode.1.gz
OLD_FILES+=usr/share/man/man1/g711conv.1.gz
OLD_FILES+=usr/share/man/man4/i4b.4.gz
OLD_FILES+=usr/share/man/man4/i4bcapi.4.gz
OLD_FILES+=usr/share/man/man4/i4bctl.4.gz
OLD_FILES+=usr/share/man/man4/i4bing.4.gz
OLD_FILES+=usr/share/man/man4/i4bipr.4.gz
OLD_FILES+=usr/share/man/man4/i4bisppp.4.gz
OLD_FILES+=usr/share/man/man4/i4bq921.4.gz
OLD_FILES+=usr/share/man/man4/i4bq931.4.gz
OLD_FILES+=usr/share/man/man4/i4brbch.4.gz
OLD_FILES+=usr/share/man/man4/i4btel.4.gz
OLD_FILES+=usr/share/man/man4/i4btrc.4.gz
OLD_FILES+=usr/share/man/man4/iavc.4.gz
OLD_FILES+=usr/share/man/man4/isic.4.gz
OLD_FILES+=usr/share/man/man4/ifpi.4.gz
OLD_FILES+=usr/share/man/man4/ifpi2.4.gz
OLD_FILES+=usr/share/man/man4/ifpnp.4.gz
OLD_FILES+=usr/share/man/man4/ihfc.4.gz
OLD_FILES+=usr/share/man/man4/itjc.4.gz
OLD_FILES+=usr/share/man/man4/iwic.4.gz
OLD_FILES+=usr/share/man/man5/isdnd.rc.5.gz
OLD_FILES+=usr/share/man/man5/isdnd.rates.5.gz
OLD_FILES+=usr/share/man/man5/isdnd.acct.5.gz
OLD_FILES+=usr/share/man/man8/isdnd.8.gz
OLD_FILES+=usr/share/man/man8/isdndebug.8.gz
OLD_FILES+=usr/share/man/man8/isdndecode.8.gz
OLD_FILES+=usr/share/man/man8/isdnmonitor.8.gz
OLD_FILES+=usr/share/man/man8/isdnphone.8.gz
OLD_FILES+=usr/share/man/man8/isdntel.8.gz
OLD_FILES+=usr/share/man/man8/isdntelctl.8.gz
OLD_FILES+=usr/share/man/man8/isdntrace.8.gz
OLD_FILES+=usr/share/examples/isdn/contrib/README
OLD_FILES+=usr/share/examples/isdn/contrib/anleitung.ppp
OLD_FILES+=usr/share/examples/isdn/contrib/answer.c
OLD_FILES+=usr/share/examples/isdn/contrib/answer.sh
OLD_FILES+=usr/share/examples/isdn/contrib/convert.sh
OLD_FILES+=usr/share/examples/isdn/contrib/hplay.c
OLD_FILES+=usr/share/examples/isdn/contrib/i4b-ppp-newbie.txt
OLD_FILES+=usr/share/examples/isdn/contrib/isdnctl
OLD_FILES+=usr/share/examples/isdn/contrib/isdnd_acct
OLD_FILES+=usr/share/examples/isdn/contrib/isdnd_acct.pl
OLD_FILES+=usr/share/examples/isdn/contrib/isdntelmux.c
OLD_FILES+=usr/share/examples/isdn/contrib/mrtg-isp0.sh
OLD_FILES+=usr/share/examples/isdn/i4brunppp/Makefile
OLD_FILES+=usr/share/examples/isdn/i4brunppp/README
OLD_FILES+=usr/share/examples/isdn/i4brunppp/i4brunppp-isdnd.rc
OLD_FILES+=usr/share/examples/isdn/i4brunppp/i4brunppp.8
OLD_FILES+=usr/share/examples/isdn/i4brunppp/i4brunppp.c
OLD_FILES+=usr/share/examples/isdn/v21/Makefile
OLD_FILES+=usr/share/examples/isdn/v21/README
OLD_FILES+=usr/share/examples/isdn/v21/v21modem.c
OLD_FILES+=usr/share/examples/isdn/FAQ
OLD_FILES+=usr/share/examples/isdn/KERNEL
OLD_FILES+=usr/share/examples/isdn/Overview
OLD_FILES+=usr/share/examples/isdn/README
OLD_FILES+=usr/share/examples/isdn/ROADMAP
OLD_FILES+=usr/share/examples/isdn/ReleaseNotes
OLD_FILES+=usr/share/examples/isdn/Resources
OLD_FILES+=usr/share/examples/isdn/SupportedCards
OLD_FILES+=usr/share/examples/isdn/ThankYou
OLD_DIRS+=usr/share/examples/isdn/contrib
OLD_DIRS+=usr/share/examples/isdn/i4brunppp
OLD_DIRS+=usr/share/examples/isdn/v21
OLD_DIRS+=usr/share/examples/isdn
OLD_FILES+=usr/share/examples/ppp/isdnd.rc
OLD_FILES+=usr/share/examples/ppp/ppp.conf.isdn
# 20080525: ng_atmpif removed
OLD_FILES+=usr/include/netgraph/atm/ng_atmpif.h
OLD_FILES+=usr/share/man/man4/ng_atmpif.4.gz
# 20080522: pmap_addr_hint removed
OLD_FILES+=usr/share/man/man9/pmap_addr_hint.9.gz
# 20080517: ipsec_osdep.h removed
OLD_FILES+=usr/include/netipsec/ipsec_osdep.h
# 20080507: heimdal 1.1 import
OLD_LIBS+=usr/lib/libasn1.so.9
OLD_LIBS+=usr/lib/libgssapi.so.9
OLD_LIBS+=usr/lib/libgssapi_krb5.so.9
OLD_LIBS+=usr/lib/libhdb.so.9
OLD_LIBS+=usr/lib/libkadm5clnt.so.9
OLD_LIBS+=usr/lib/libkadm5srv.so.9
OLD_LIBS+=usr/lib/libkafs5.so.9
OLD_LIBS+=usr/lib/libkrb5.so.9
OLD_LIBS+=usr/lib/libroken.so.9
OLD_LIBS+=usr/lib32/libgssapi.so.9
# 20080420: Symbol card support dropped
OLD_FILES+=usr/include/dev/wi/spectrum24t_cf.h
# 20080420: awi removal
OLD_FILES+=usr/share/man/man4/awi.4.gz
OLD_FILES+=usr/share/man/man4/if_awi.4.gz
# 20080331: pkg_sign has been removed
OLD_FILES+=usr/sbin/pkg_check
OLD_FILES+=usr/sbin/pkg_sign
OLD_FILES+=usr/share/man/man1/pkg_check.1.gz
OLD_FILES+=usr/share/man/man1/pkg_sign.1.gz
# 20080325: tzdata2008b import
OLD_FILES+=usr/share/zoneinfo/Asia/Calcutta
OLD_FILES+=usr/share/zoneinfo/Asia/Saigon
# 20080314: stack_print(9) mlink fixed
OLD_FILES+=usr/share/man/man9/stack_printf.9.gz
# 20080312: libkse removal
OLD_FILES+=usr/include/sys/kse.h
OLD_FILES+=usr/lib/libkse.so
OLD_LIBS+=usr/lib/libkse.so.3
OLD_FILES+=usr/share/man/man2/kse.2.gz
OLD_FILES+=usr/share/man/man2/kse_create.2.gz
OLD_FILES+=usr/share/man/man2/kse_exit.2.gz
OLD_FILES+=usr/share/man/man2/kse_release.2.gz
OLD_FILES+=usr/share/man/man2/kse_switchin.2.gz
OLD_FILES+=usr/share/man/man2/kse_thr_interrupt.2.gz
OLD_FILES+=usr/share/man/man2/kse_wakeup.2.gz
OLD_FILES+=usr/lib32/libkse.so
OLD_LIBS+=usr/lib32/libkse.so.3
# 20080225: bsdar/bsdranlib rename to ar/ranlib
OLD_FILES+=usr/bin/bsdar
OLD_FILES+=usr/bin/bsdranlib
OLD_FILES+=usr/share/man/man1/bsdar.1.gz
OLD_FILES+=usr/share/man/man1/bsdranlib.1.gz
# 20080220: geom_lvm rename to geom_linux_lvm
OLD_FILES+=usr/share/man/man4/geom_lvm.4.gz
# 20080126: oldcard.4 removal
OLD_FILES+=usr/share/man/man4/card.4.gz
OLD_FILES+=usr/share/man/man4/oldcard.4.gz
# 20080122: Removed from the tree
OLD_FILES+=usr/share/man/man9/BUF_REFCNT.9.gz
# 20080108: Moved to section 2
OLD_FILES+=usr/share/man/man3/shm_open.3.gz
OLD_FILES+=usr/share/man/man3/shm_unlink.3.gz
# 20071207: Merged with fortunes-o.real
OLD_FILES+=usr/share/games/fortune/fortunes2-o
OLD_FILES+=usr/share/games/fortune/fortunes2-o.dat
# 20071201: Removal of XRPU driver
OLD_FILES+=usr/include/sys/xrpuio.h
# 20071129: Disabled static versions of libkse by default
OLD_FILES+=usr/lib/libkse.a
OLD_FILES+=usr/lib/libkse_p.a
OLD_FILES+=usr/lib/libkse_pic.a
OLD_FILES+=usr/lib32/libkse.a
OLD_FILES+=usr/lib32/libkse_p.a
OLD_FILES+=usr/lib32/libkse_pic.a
# 20071129: Removed a Solaris compatibility header
OLD_FILES+=usr/include/sys/_elf_solaris.h
# 20071125: Renamed to pmc_get_msr()
OLD_FILES+=usr/share/man/man3/pmc_x86_get_msr.3.gz
# 20071108: Removed very crunch OLDCARD support file
OLD_FILES+=etc/defaults/pccard.conf
# 20071104: Removed bsdlabel, fdisk and gpt from rescue on ia64.
.if ${TARGET_ARCH} == "ia64"
OLD_FILES+=rescue/bsdlabel
OLD_FILES+=rescue/fdisk
OLD_FILES+=rescue/gpt
.endif
# 20071025: rc.d/nfslocking superceeded by rc.d/lockd and rc.d/statd
OLD_FILES+=etc/rc.d/nfslocking
# 20070930: rename of cached to nscd
OLD_FILES+=etc/cached.conf
OLD_FILES+=etc/rc.d/cached
OLD_FILES+=usr/sbin/cached
OLD_FILES+=usr/share/man/man5/cached.conf.5.gz
OLD_FILES+=usr/share/man/man8/cached.8.gz
# 20070807: removal of PowerPC specific header file.
.if ${TARGET_ARCH} == "powerpc"
OLD_FILES+=usr/include/machine/interruptvar.h
.endif
# 20070801: fast_ipsec.4 gone
OLD_FILES+=usr/share/man/man4/fast_ipsec.4.gz
# 20070715: netatm temporarily disconnected (removed 20080525)
OLD_FILES+=rescue/atm
OLD_FILES+=rescue/fore_dnld
OLD_FILES+=rescue/ilmid
OLD_FILES+=sbin/atm
OLD_FILES+=sbin/fore_dnld
OLD_FILES+=sbin/ilmid
OLD_FILES+=usr/include/libatm.h
OLD_FILES+=usr/include/netatm/atm.h
OLD_FILES+=usr/include/netatm/atm_cm.h
OLD_FILES+=usr/include/netatm/atm_if.h
OLD_FILES+=usr/include/netatm/atm_ioctl.h
OLD_FILES+=usr/include/netatm/atm_pcb.h
OLD_FILES+=usr/include/netatm/atm_sap.h
OLD_FILES+=usr/include/netatm/atm_sigmgr.h
OLD_FILES+=usr/include/netatm/atm_stack.h
OLD_FILES+=usr/include/netatm/atm_sys.h
OLD_FILES+=usr/include/netatm/atm_var.h
OLD_FILES+=usr/include/netatm/atm_vc.h
OLD_FILES+=usr/include/netatm/ipatm/ipatm.h
OLD_FILES+=usr/include/netatm/ipatm/ipatm_serv.h
OLD_FILES+=usr/include/netatm/ipatm/ipatm_var.h
OLD_FILES+=usr/include/netatm/port.h
OLD_FILES+=usr/include/netatm/queue.h
OLD_FILES+=usr/include/netatm/sigpvc/sigpvc_var.h
OLD_FILES+=usr/include/netatm/spans/spans_cls.h
OLD_FILES+=usr/include/netatm/spans/spans_kxdr.h
OLD_FILES+=usr/include/netatm/spans/spans_var.h
OLD_FILES+=usr/include/netatm/uni/sscf_uni.h
OLD_FILES+=usr/include/netatm/uni/sscf_uni_var.h
OLD_FILES+=usr/include/netatm/uni/sscop.h
OLD_FILES+=usr/include/netatm/uni/sscop_misc.h
OLD_FILES+=usr/include/netatm/uni/sscop_pdu.h
OLD_FILES+=usr/include/netatm/uni/sscop_var.h
OLD_FILES+=usr/include/netatm/uni/uni.h
OLD_FILES+=usr/include/netatm/uni/uniip_var.h
OLD_FILES+=usr/include/netatm/uni/unisig.h
OLD_FILES+=usr/include/netatm/uni/unisig_decode.h
OLD_FILES+=usr/include/netatm/uni/unisig_mbuf.h
OLD_FILES+=usr/include/netatm/uni/unisig_msg.h
OLD_FILES+=usr/include/netatm/uni/unisig_print.h
OLD_FILES+=usr/include/netatm/uni/unisig_var.h
OLD_FILES+=usr/lib/libatm.a
OLD_FILES+=usr/lib/libatm_p.a
OLD_FILES+=usr/sbin/atmarpd
OLD_FILES+=usr/sbin/scspd
OLD_FILES+=usr/share/man/en.ISO8859-1/man8/atm.8.gz
OLD_FILES+=usr/share/man/en.ISO8859-1/man8/atmarpd.8.gz
OLD_FILES+=usr/share/man/en.ISO8859-1/man8/fore_dnld.8.gz
OLD_FILES+=usr/share/man/en.ISO8859-1/man8/ilmid.8.gz
OLD_FILES+=usr/share/man/en.ISO8859-1/man8/scspd.8.gz
OLD_FILES+=usr/share/man/man8/atm.8.gz
OLD_FILES+=usr/share/man/man8/atmarpd.8.gz
OLD_FILES+=usr/share/man/man8/fore_dnld.8.gz
OLD_FILES+=usr/share/man/man8/ilmid.8.gz
OLD_FILES+=usr/share/man/man8/scspd.8.gz
OLD_FILES+=usr/share/examples/atm/NOTES
OLD_FILES+=usr/share/examples/atm/README
OLD_FILES+=usr/share/examples/atm/Startup
OLD_FILES+=usr/share/examples/atm/atm-config.sh
OLD_FILES+=usr/share/examples/atm/atm-sockets.txt
OLD_FILES+=usr/share/examples/atm/cpcs-design.txt
OLD_FILES+=usr/share/examples/atm/fore-microcode.txt
OLD_FILES+=usr/share/examples/atm/sscf-design.txt
OLD_FILES+=usr/share/examples/atm/sscop-design.txt
OLD_LIBS+=lib/libatm.so.5
OLD_LIBS+=usr/lib/libatm.so
OLD_DIRS+=usr/include/netatm/sigpvc
OLD_DIRS+=usr/include/netatm/spans
OLD_DIRS+=usr/include/netatm/ipatm
OLD_DIRS+=usr/include/netatm/uni
OLD_DIRS+=usr/include/netatm
OLD_DIRS+=usr/share/examples/atm
OLD_FILES+=usr/lib32/libatm.a
OLD_FILES+=usr/lib32/libatm.so
OLD_LIBS+=usr/lib32/libatm.so.5
OLD_FILES+=usr/lib32/libatm_p.a
# 20070705: I4B headers repo-copied to include/i4b/
.if ${TARGET_ARCH} == "i386"
OLD_FILES+=usr/include/machine/i4b_cause.h
OLD_FILES+=usr/include/machine/i4b_debug.h
OLD_FILES+=usr/include/machine/i4b_ioctl.h
OLD_FILES+=usr/include/machine/i4b_rbch_ioctl.h
OLD_FILES+=usr/include/machine/i4b_tel_ioctl.h
OLD_FILES+=usr/include/machine/i4b_trace.h
.endif
# 20070703: pf 4.1 import
OLD_FILES+=usr/libexec/ftp-proxy
# 20070701: KAME IPSec removal
OLD_FILES+=usr/include/netinet6/ah.h
OLD_FILES+=usr/include/netinet6/ah6.h
OLD_FILES+=usr/include/netinet6/ah_aesxcbcmac.h
OLD_FILES+=usr/include/netinet6/esp.h
OLD_FILES+=usr/include/netinet6/esp6.h
OLD_FILES+=usr/include/netinet6/esp_aesctr.h
OLD_FILES+=usr/include/netinet6/esp_camellia.h
OLD_FILES+=usr/include/netinet6/esp_rijndael.h
OLD_FILES+=usr/include/netinet6/ipsec.h
OLD_FILES+=usr/include/netinet6/ipsec6.h
OLD_FILES+=usr/include/netinet6/ipcomp.h
OLD_FILES+=usr/include/netinet6/ipcomp6.h
OLD_FILES+=usr/include/netkey/key.h
OLD_FILES+=usr/include/netkey/key_debug.h
OLD_FILES+=usr/include/netkey/key_var.h
OLD_FILES+=usr/include/netkey/keydb.h
OLD_FILES+=usr/include/netkey/keysock.h
OLD_DIRS+=usr/include/netkey
# 20070701: remove wicontrol
OLD_FILES+=usr/sbin/wicontrol
OLD_FILES+=usr/share/man/man8/wicontrol.8.gz
# 20070625: umapfs removal
OLD_FILES+=rescue/mount_umapfs
OLD_FILES+=sbin/mount_umapfs
OLD_FILES+=usr/include/fs/umapfs/umap.h
OLD_FILES+=usr/share/man/man8/mount_umapfs.8.gz
OLD_DIRS+=usr/include/fs/umapfs
# 20070618: Removal of the PROTO.localhost* files
OLD_FILES+=etc/namedb/PROTO.localhost-v6.rev
OLD_FILES+=etc/namedb/PROTO.localhost.rev
OLD_FILES+=etc/namedb/make-localhost
# 20070618: shared library version bump
OLD_LIBS+=lib/libalias.so.5
OLD_LIBS+=lib/libbsnmp.so.3
OLD_LIBS+=lib/libncurses.so.6
OLD_LIBS+=lib/libncursesw.so.6
OLD_LIBS+=lib/libreadline.so.6
OLD_LIBS+=usr/lib/libdialog.so.5
OLD_LIBS+=usr/lib/libgnuregex.so.3
OLD_LIBS+=usr/lib/libhistory.so.6
OLD_LIBS+=usr/lib/libpam.so.3
OLD_LIBS+=usr/lib/libssh.so.3
OLD_LIBS+=usr/lib/pam_chroot.so.3
OLD_LIBS+=usr/lib/pam_deny.so.3
OLD_LIBS+=usr/lib/pam_echo.so.3
OLD_LIBS+=usr/lib/pam_exec.so.3
OLD_LIBS+=usr/lib/pam_ftpusers.so.3
OLD_LIBS+=usr/lib/pam_group.so.3
OLD_LIBS+=usr/lib/pam_guest.so.3
OLD_LIBS+=usr/lib/pam_krb5.so.3
OLD_LIBS+=usr/lib/pam_ksu.so.3
OLD_LIBS+=usr/lib/pam_lastlog.so.3
OLD_LIBS+=usr/lib/pam_login_access.so.3
OLD_LIBS+=usr/lib/pam_nologin.so.3
OLD_LIBS+=usr/lib/pam_opie.so.3
OLD_LIBS+=usr/lib/pam_opieaccess.so.3
OLD_LIBS+=usr/lib/pam_passwdqc.so.3
OLD_LIBS+=usr/lib/pam_permit.so.3
OLD_LIBS+=usr/lib/pam_radius.so.3
OLD_LIBS+=usr/lib/pam_rhosts.so.3
OLD_LIBS+=usr/lib/pam_rootok.so.3
OLD_LIBS+=usr/lib/pam_securetty.so.3
OLD_LIBS+=usr/lib/pam_self.so.3
OLD_LIBS+=usr/lib/pam_ssh.so.3
OLD_LIBS+=usr/lib/pam_tacplus.so.3
OLD_LIBS+=usr/lib/pam_unix.so.3
OLD_LIBS+=usr/lib/snmp_atm.so.4
OLD_LIBS+=usr/lib/snmp_bridge.so.4
OLD_LIBS+=usr/lib/snmp_hostres.so.4
OLD_LIBS+=usr/lib/snmp_mibII.so.4
OLD_LIBS+=usr/lib/snmp_netgraph.so.4
OLD_LIBS+=usr/lib/snmp_pf.so.4
OLD_LIBS+=usr/lib32/libalias.so.5
OLD_LIBS+=usr/lib32/libbsnmp.so.3
OLD_LIBS+=usr/lib32/libdialog.so.5
OLD_LIBS+=usr/lib32/libgnuregex.so.3
OLD_LIBS+=usr/lib32/libhistory.so.6
OLD_LIBS+=usr/lib32/libncurses.so.6
OLD_LIBS+=usr/lib32/libncursesw.so.6
OLD_LIBS+=usr/lib32/libpam.so.3
OLD_LIBS+=usr/lib32/libreadline.so.6
OLD_LIBS+=usr/lib32/libssh.so.3
OLD_LIBS+=usr/lib32/pam_chroot.so.3
OLD_LIBS+=usr/lib32/pam_deny.so.3
OLD_LIBS+=usr/lib32/pam_echo.so.3
OLD_LIBS+=usr/lib32/pam_exec.so.3
OLD_LIBS+=usr/lib32/pam_ftpusers.so.3
OLD_LIBS+=usr/lib32/pam_group.so.3
OLD_LIBS+=usr/lib32/pam_guest.so.3
OLD_LIBS+=usr/lib32/pam_krb5.so.3
OLD_LIBS+=usr/lib32/pam_ksu.so.3
OLD_LIBS+=usr/lib32/pam_lastlog.so.3
OLD_LIBS+=usr/lib32/pam_login_access.so.3
OLD_LIBS+=usr/lib32/pam_nologin.so.3
OLD_LIBS+=usr/lib32/pam_opie.so.3
OLD_LIBS+=usr/lib32/pam_opieaccess.so.3
OLD_LIBS+=usr/lib32/pam_passwdqc.so.3
OLD_LIBS+=usr/lib32/pam_permit.so.3
OLD_LIBS+=usr/lib32/pam_radius.so.3
OLD_LIBS+=usr/lib32/pam_rhosts.so.3
OLD_LIBS+=usr/lib32/pam_rootok.so.3
OLD_LIBS+=usr/lib32/pam_securetty.so.3
OLD_LIBS+=usr/lib32/pam_self.so.3
OLD_LIBS+=usr/lib32/pam_ssh.so.3
OLD_LIBS+=usr/lib32/pam_tacplus.so.3
OLD_LIBS+=usr/lib32/pam_unix.so.3
# 20070613: IPX over IP tunnel removal
OLD_FILES+=usr/include/netipx/ipx_ip.h
# 20070605: sched_core removal
OLD_FILES+=usr/share/man/man4/sched_core.4.gz
# 20070603: BIND 9.4.1 import
OLD_LIBS+=usr/lib/liblwres.so.10
# 20070521: shared library version bump
OLD_LIBS+=lib/libatm.so.4
OLD_LIBS+=lib/libbegemot.so.2
OLD_LIBS+=lib/libbsdxml.so.2
OLD_LIBS+=lib/libcam.so.3
OLD_LIBS+=lib/libcrypt.so.3
OLD_LIBS+=lib/libdevstat.so.5
OLD_LIBS+=lib/libedit.so.5
OLD_LIBS+=lib/libgeom.so.3
OLD_LIBS+=lib/libipsec.so.2
OLD_LIBS+=lib/libipx.so.3
OLD_LIBS+=lib/libkiconv.so.2
OLD_LIBS+=lib/libkse.so.2
OLD_LIBS+=lib/libkvm.so.3
OLD_LIBS+=lib/libm.so.4
OLD_LIBS+=lib/libmd.so.3
OLD_LIBS+=lib/libpcap.so.4
OLD_LIBS+=lib/libpthread.so.2
OLD_LIBS+=lib/libsbuf.so.3
OLD_LIBS+=lib/libthr.so.2
OLD_LIBS+=lib/libufs.so.3
OLD_LIBS+=lib/libutil.so.6
OLD_LIBS+=lib/libz.so.3
OLD_LIBS+=usr/lib/libbluetooth.so.2
OLD_LIBS+=usr/lib/libbsm.so.1
OLD_LIBS+=usr/lib/libbz2.so.2
OLD_LIBS+=usr/lib/libcalendar.so.3
OLD_LIBS+=usr/lib/libcom_err.so.3
OLD_LIBS+=usr/lib/libdevinfo.so.3
OLD_LIBS+=usr/lib/libfetch.so.4
OLD_LIBS+=usr/lib/libform.so.3
OLD_LIBS+=usr/lib/libformw.so.3
OLD_LIBS+=usr/lib/libftpio.so.6
OLD_LIBS+=usr/lib/libgpib.so.1
OLD_LIBS+=usr/lib/libkse.so.2
OLD_LIBS+=usr/lib/libmagic.so.2
OLD_LIBS+=usr/lib/libmemstat.so.1
OLD_LIBS+=usr/lib/libmenu.so.3
OLD_LIBS+=usr/lib/libmenuw.so.3
OLD_LIBS+=usr/lib/libmilter.so.3
OLD_LIBS+=usr/lib/libmp.so.5
OLD_LIBS+=usr/lib/libncp.so.2
OLD_LIBS+=usr/lib/libnetgraph.so.2
OLD_LIBS+=usr/lib/libngatm.so.2
OLD_LIBS+=usr/lib/libopie.so.4
OLD_LIBS+=usr/lib/libpanel.so.3
OLD_LIBS+=usr/lib/libpanelw.so.3
OLD_LIBS+=usr/lib/libpmc.so.3
OLD_LIBS+=usr/lib/libradius.so.2
OLD_LIBS+=usr/lib/librpcsvc.so.3
OLD_LIBS+=usr/lib/libsdp.so.2
OLD_LIBS+=usr/lib/libsmb.so.2
OLD_LIBS+=usr/lib/libstdc++.so.5
OLD_LIBS+=usr/lib/libtacplus.so.2
OLD_LIBS+=usr/lib/libthr.so.2
OLD_LIBS+=usr/lib/libthread_db.so.2
OLD_LIBS+=usr/lib/libugidfw.so.2
OLD_LIBS+=usr/lib/libusbhid.so.2
OLD_LIBS+=usr/lib/libvgl.so.4
OLD_LIBS+=usr/lib/libwrap.so.4
OLD_LIBS+=usr/lib/libypclnt.so.2
OLD_LIBS+=usr/lib/snmp_bridge.so.3
OLD_LIBS+=usr/lib/snmp_hostres.so.3
OLD_LIBS+=usr/lib32/libatm.so.4
OLD_LIBS+=usr/lib32/libbegemot.so.2
OLD_LIBS+=usr/lib32/libbluetooth.so.2
OLD_LIBS+=usr/lib32/libbsdxml.so.2
OLD_LIBS+=usr/lib32/libbsm.so.1
OLD_LIBS+=usr/lib32/libbz2.so.2
OLD_LIBS+=usr/lib32/libcalendar.so.3
OLD_LIBS+=usr/lib32/libcam.so.3
OLD_LIBS+=usr/lib32/libcom_err.so.3
OLD_LIBS+=usr/lib32/libcrypt.so.3
OLD_LIBS+=usr/lib32/libdevinfo.so.3
OLD_LIBS+=usr/lib32/libdevstat.so.5
OLD_LIBS+=usr/lib32/libedit.so.5
OLD_LIBS+=usr/lib32/libfetch.so.4
OLD_LIBS+=usr/lib32/libform.so.3
OLD_LIBS+=usr/lib32/libformw.so.3
OLD_LIBS+=usr/lib32/libftpio.so.6
OLD_LIBS+=usr/lib32/libgeom.so.3
OLD_LIBS+=usr/lib32/libgpib.so.1
OLD_LIBS+=usr/lib32/libipsec.so.2
OLD_LIBS+=usr/lib32/libipx.so.3
OLD_LIBS+=usr/lib32/libkiconv.so.2
OLD_LIBS+=usr/lib32/libkse.so.2
OLD_LIBS+=usr/lib32/libkvm.so.3
OLD_LIBS+=usr/lib32/libm.so.4
OLD_LIBS+=usr/lib32/libmagic.so.2
OLD_LIBS+=usr/lib32/libmd.so.3
OLD_LIBS+=usr/lib32/libmemstat.so.1
OLD_LIBS+=usr/lib32/libmenu.so.3
OLD_LIBS+=usr/lib32/libmenuw.so.3
OLD_LIBS+=usr/lib32/libmilter.so.3
OLD_LIBS+=usr/lib32/libmp.so.5
OLD_LIBS+=usr/lib32/libncp.so.2
OLD_LIBS+=usr/lib32/libnetgraph.so.2
OLD_LIBS+=usr/lib32/libngatm.so.2
OLD_LIBS+=usr/lib32/libopie.so.4
OLD_LIBS+=usr/lib32/libpanel.so.3
OLD_LIBS+=usr/lib32/libpanelw.so.3
OLD_LIBS+=usr/lib32/libpcap.so.4
OLD_LIBS+=usr/lib32/libpmc.so.3
OLD_LIBS+=usr/lib32/libpthread.so.2
OLD_LIBS+=usr/lib32/libradius.so.2
OLD_LIBS+=usr/lib32/librpcsvc.so.3
OLD_LIBS+=usr/lib32/libsbuf.so.3
OLD_LIBS+=usr/lib32/libsdp.so.2
OLD_LIBS+=usr/lib32/libsmb.so.2
OLD_LIBS+=usr/lib32/libstdc++.so.5
OLD_LIBS+=usr/lib32/libtacplus.so.2
OLD_LIBS+=usr/lib32/libthr.so.2
OLD_LIBS+=usr/lib32/libthread_db.so.2
OLD_LIBS+=usr/lib32/libufs.so.3
OLD_LIBS+=usr/lib32/libugidfw.so.2
OLD_LIBS+=usr/lib32/libusbhid.so.2
OLD_LIBS+=usr/lib32/libutil.so.6
OLD_LIBS+=usr/lib32/libvgl.so.4
OLD_LIBS+=usr/lib32/libwrap.so.4
OLD_LIBS+=usr/lib32/libypclnt.so.2
OLD_LIBS+=usr/lib32/libz.so.3
# 20070519: GCC 4.2
OLD_FILES+=usr/bin/f77
OLD_FILES+=usr/bin/protoize
OLD_FILES+=usr/include/g2c.h
OLD_FILES+=usr/libexec/f771
OLD_FILES+=usr/share/info/g77.info.gz
OLD_FILES+=usr/share/man/man1/f77.1.gz
OLD_FILES+=usr/include/c++/3.4/algorithm
OLD_FILES+=usr/include/c++/3.4/backward/algo.h
OLD_FILES+=usr/include/c++/3.4/backward/algobase.h
OLD_FILES+=usr/include/c++/3.4/backward/alloc.h
OLD_FILES+=usr/include/c++/3.4/backward/backward_warning.h
OLD_FILES+=usr/include/c++/3.4/backward/bvector.h
OLD_FILES+=usr/include/c++/3.4/backward/complex.h
OLD_FILES+=usr/include/c++/3.4/backward/defalloc.h
OLD_FILES+=usr/include/c++/3.4/backward/deque.h
OLD_FILES+=usr/include/c++/3.4/backward/fstream.h
OLD_FILES+=usr/include/c++/3.4/backward/function.h
OLD_FILES+=usr/include/c++/3.4/backward/hash_map.h
OLD_FILES+=usr/include/c++/3.4/backward/hash_set.h
OLD_FILES+=usr/include/c++/3.4/backward/hashtable.h
OLD_FILES+=usr/include/c++/3.4/backward/heap.h
OLD_FILES+=usr/include/c++/3.4/backward/iomanip.h
OLD_FILES+=usr/include/c++/3.4/backward/iostream.h
OLD_FILES+=usr/include/c++/3.4/backward/istream.h
OLD_FILES+=usr/include/c++/3.4/backward/iterator.h
OLD_FILES+=usr/include/c++/3.4/backward/list.h
OLD_FILES+=usr/include/c++/3.4/backward/map.h
OLD_FILES+=usr/include/c++/3.4/backward/multimap.h
OLD_FILES+=usr/include/c++/3.4/backward/multiset.h
OLD_FILES+=usr/include/c++/3.4/backward/new.h
OLD_FILES+=usr/include/c++/3.4/backward/ostream.h
OLD_FILES+=usr/include/c++/3.4/backward/pair.h
OLD_FILES+=usr/include/c++/3.4/backward/queue.h
OLD_FILES+=usr/include/c++/3.4/backward/rope.h
OLD_FILES+=usr/include/c++/3.4/backward/set.h
OLD_FILES+=usr/include/c++/3.4/backward/slist.h
OLD_FILES+=usr/include/c++/3.4/backward/stack.h
OLD_FILES+=usr/include/c++/3.4/backward/stream.h
OLD_FILES+=usr/include/c++/3.4/backward/streambuf.h
OLD_FILES+=usr/include/c++/3.4/backward/strstream
OLD_FILES+=usr/include/c++/3.4/backward/tempbuf.h
OLD_FILES+=usr/include/c++/3.4/backward/tree.h
OLD_FILES+=usr/include/c++/3.4/backward/vector.h
OLD_FILES+=usr/include/c++/3.4/bits/allocator.h
OLD_FILES+=usr/include/c++/3.4/bits/atomic_word.h
OLD_FILES+=usr/include/c++/3.4/bits/atomicity.h
OLD_FILES+=usr/include/c++/3.4/bits/basic_file.h
OLD_FILES+=usr/include/c++/3.4/bits/basic_ios.h
OLD_FILES+=usr/include/c++/3.4/bits/basic_ios.tcc
OLD_FILES+=usr/include/c++/3.4/bits/basic_string.h
OLD_FILES+=usr/include/c++/3.4/bits/basic_string.tcc
OLD_FILES+=usr/include/c++/3.4/bits/boost_concept_check.h
OLD_FILES+=usr/include/c++/3.4/bits/c++allocator.h
OLD_FILES+=usr/include/c++/3.4/bits/c++config.h
OLD_FILES+=usr/include/c++/3.4/bits/c++io.h
OLD_FILES+=usr/include/c++/3.4/bits/c++locale.h
OLD_FILES+=usr/include/c++/3.4/bits/c++locale_internal.h
OLD_FILES+=usr/include/c++/3.4/bits/char_traits.h
OLD_FILES+=usr/include/c++/3.4/bits/cmath.tcc
OLD_FILES+=usr/include/c++/3.4/bits/codecvt.h
OLD_FILES+=usr/include/c++/3.4/bits/codecvt_specializations.h
OLD_FILES+=usr/include/c++/3.4/bits/concept_check.h
OLD_FILES+=usr/include/c++/3.4/bits/concurrence.h
OLD_FILES+=usr/include/c++/3.4/bits/cpp_type_traits.h
OLD_FILES+=usr/include/c++/3.4/bits/ctype_base.h
OLD_FILES+=usr/include/c++/3.4/bits/ctype_inline.h
OLD_FILES+=usr/include/c++/3.4/bits/ctype_noninline.h
OLD_FILES+=usr/include/c++/3.4/bits/deque.tcc
OLD_FILES+=usr/include/c++/3.4/bits/fstream.tcc
OLD_FILES+=usr/include/c++/3.4/bits/functexcept.h
OLD_FILES+=usr/include/c++/3.4/bits/gslice.h
OLD_FILES+=usr/include/c++/3.4/bits/gslice_array.h
OLD_FILES+=usr/include/c++/3.4/bits/gthr-default.h
OLD_FILES+=usr/include/c++/3.4/bits/gthr-posix.h
OLD_FILES+=usr/include/c++/3.4/bits/gthr-single.h
OLD_FILES+=usr/include/c++/3.4/bits/gthr.h
OLD_FILES+=usr/include/c++/3.4/bits/indirect_array.h
OLD_FILES+=usr/include/c++/3.4/bits/ios_base.h
OLD_FILES+=usr/include/c++/3.4/bits/istream.tcc
OLD_FILES+=usr/include/c++/3.4/bits/list.tcc
OLD_FILES+=usr/include/c++/3.4/bits/locale_classes.h
OLD_FILES+=usr/include/c++/3.4/bits/locale_facets.h
OLD_FILES+=usr/include/c++/3.4/bits/locale_facets.tcc
OLD_FILES+=usr/include/c++/3.4/bits/localefwd.h
OLD_FILES+=usr/include/c++/3.4/bits/mask_array.h
OLD_FILES+=usr/include/c++/3.4/bits/messages_members.h
OLD_FILES+=usr/include/c++/3.4/bits/os_defines.h
OLD_FILES+=usr/include/c++/3.4/bits/ostream.tcc
OLD_FILES+=usr/include/c++/3.4/bits/postypes.h
OLD_FILES+=usr/include/c++/3.4/bits/slice_array.h
OLD_FILES+=usr/include/c++/3.4/bits/sstream.tcc
OLD_FILES+=usr/include/c++/3.4/bits/stl_algo.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_algobase.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_bvector.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_construct.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_deque.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_function.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_heap.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_iterator.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_iterator_base_funcs.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_iterator_base_types.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_list.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_map.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_multimap.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_multiset.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_numeric.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_pair.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_queue.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_raw_storage_iter.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_relops.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_set.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_stack.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_tempbuf.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_threads.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_tree.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_uninitialized.h
OLD_FILES+=usr/include/c++/3.4/bits/stl_vector.h
OLD_FILES+=usr/include/c++/3.4/bits/stream_iterator.h
OLD_FILES+=usr/include/c++/3.4/bits/streambuf.tcc
OLD_FILES+=usr/include/c++/3.4/bits/streambuf_iterator.h
OLD_FILES+=usr/include/c++/3.4/bits/stringfwd.h
OLD_FILES+=usr/include/c++/3.4/bits/time_members.h
OLD_FILES+=usr/include/c++/3.4/bits/type_traits.h
OLD_FILES+=usr/include/c++/3.4/bits/valarray_after.h
OLD_FILES+=usr/include/c++/3.4/bits/valarray_array.h
OLD_FILES+=usr/include/c++/3.4/bits/valarray_array.tcc
OLD_FILES+=usr/include/c++/3.4/bits/valarray_before.h
OLD_FILES+=usr/include/c++/3.4/bits/vector.tcc
OLD_FILES+=usr/include/c++/3.4/bitset
OLD_FILES+=usr/include/c++/3.4/cassert
OLD_FILES+=usr/include/c++/3.4/cctype
OLD_FILES+=usr/include/c++/3.4/cerrno
OLD_FILES+=usr/include/c++/3.4/cfloat
OLD_FILES+=usr/include/c++/3.4/ciso646
OLD_FILES+=usr/include/c++/3.4/climits
OLD_FILES+=usr/include/c++/3.4/clocale
OLD_FILES+=usr/include/c++/3.4/cmath
OLD_FILES+=usr/include/c++/3.4/complex
OLD_FILES+=usr/include/c++/3.4/csetjmp
OLD_FILES+=usr/include/c++/3.4/csignal
OLD_FILES+=usr/include/c++/3.4/cstdarg
OLD_FILES+=usr/include/c++/3.4/cstddef
OLD_FILES+=usr/include/c++/3.4/cstdio
OLD_FILES+=usr/include/c++/3.4/cstdlib
OLD_FILES+=usr/include/c++/3.4/cstring
OLD_FILES+=usr/include/c++/3.4/ctime
OLD_FILES+=usr/include/c++/3.4/cwchar
OLD_FILES+=usr/include/c++/3.4/cwctype
OLD_FILES+=usr/include/c++/3.4/cxxabi.h
OLD_FILES+=usr/include/c++/3.4/debug/bitset
OLD_FILES+=usr/include/c++/3.4/debug/debug.h
OLD_FILES+=usr/include/c++/3.4/debug/deque
OLD_FILES+=usr/include/c++/3.4/debug/formatter.h
OLD_FILES+=usr/include/c++/3.4/debug/hash_map
OLD_FILES+=usr/include/c++/3.4/debug/hash_map.h
OLD_FILES+=usr/include/c++/3.4/debug/hash_multimap.h
OLD_FILES+=usr/include/c++/3.4/debug/hash_multiset.h
OLD_FILES+=usr/include/c++/3.4/debug/hash_set
OLD_FILES+=usr/include/c++/3.4/debug/hash_set.h
OLD_FILES+=usr/include/c++/3.4/debug/list
OLD_FILES+=usr/include/c++/3.4/debug/map
OLD_FILES+=usr/include/c++/3.4/debug/map.h
OLD_FILES+=usr/include/c++/3.4/debug/multimap.h
OLD_FILES+=usr/include/c++/3.4/debug/multiset.h
OLD_FILES+=usr/include/c++/3.4/debug/safe_base.h
OLD_FILES+=usr/include/c++/3.4/debug/safe_iterator.h
OLD_FILES+=usr/include/c++/3.4/debug/safe_iterator.tcc
OLD_FILES+=usr/include/c++/3.4/debug/safe_sequence.h
OLD_FILES+=usr/include/c++/3.4/debug/set
OLD_FILES+=usr/include/c++/3.4/debug/set.h
OLD_FILES+=usr/include/c++/3.4/debug/string
OLD_FILES+=usr/include/c++/3.4/debug/vector
OLD_FILES+=usr/include/c++/3.4/deque
OLD_FILES+=usr/include/c++/3.4/exception
OLD_FILES+=usr/include/c++/3.4/exception_defines.h
OLD_FILES+=usr/include/c++/3.4/ext/algorithm
OLD_FILES+=usr/include/c++/3.4/ext/bitmap_allocator.h
OLD_FILES+=usr/include/c++/3.4/ext/debug_allocator.h
OLD_FILES+=usr/include/c++/3.4/ext/enc_filebuf.h
OLD_FILES+=usr/include/c++/3.4/ext/functional
OLD_FILES+=usr/include/c++/3.4/ext/hash_fun.h
OLD_FILES+=usr/include/c++/3.4/ext/hash_map
OLD_FILES+=usr/include/c++/3.4/ext/hash_set
OLD_FILES+=usr/include/c++/3.4/ext/hashtable.h
OLD_FILES+=usr/include/c++/3.4/ext/iterator
OLD_FILES+=usr/include/c++/3.4/ext/malloc_allocator.h
OLD_FILES+=usr/include/c++/3.4/ext/memory
OLD_FILES+=usr/include/c++/3.4/ext/mt_allocator.h
OLD_FILES+=usr/include/c++/3.4/ext/new_allocator.h
OLD_FILES+=usr/include/c++/3.4/ext/numeric
OLD_FILES+=usr/include/c++/3.4/ext/pod_char_traits.h
OLD_FILES+=usr/include/c++/3.4/ext/pool_allocator.h
OLD_FILES+=usr/include/c++/3.4/ext/rb_tree
OLD_FILES+=usr/include/c++/3.4/ext/rope
OLD_FILES+=usr/include/c++/3.4/ext/ropeimpl.h
OLD_FILES+=usr/include/c++/3.4/ext/slist
OLD_FILES+=usr/include/c++/3.4/ext/stdio_filebuf.h
OLD_FILES+=usr/include/c++/3.4/ext/stdio_sync_filebuf.h
OLD_FILES+=usr/include/c++/3.4/fstream
OLD_FILES+=usr/include/c++/3.4/functional
OLD_FILES+=usr/include/c++/3.4/iomanip
OLD_FILES+=usr/include/c++/3.4/ios
OLD_FILES+=usr/include/c++/3.4/iosfwd
OLD_FILES+=usr/include/c++/3.4/iostream
OLD_FILES+=usr/include/c++/3.4/istream
OLD_FILES+=usr/include/c++/3.4/iterator
OLD_FILES+=usr/include/c++/3.4/limits
OLD_FILES+=usr/include/c++/3.4/list
OLD_FILES+=usr/include/c++/3.4/locale
OLD_FILES+=usr/include/c++/3.4/map
OLD_FILES+=usr/include/c++/3.4/memory
OLD_FILES+=usr/include/c++/3.4/new
OLD_FILES+=usr/include/c++/3.4/numeric
OLD_FILES+=usr/include/c++/3.4/ostream
OLD_FILES+=usr/include/c++/3.4/queue
OLD_FILES+=usr/include/c++/3.4/set
OLD_FILES+=usr/include/c++/3.4/sstream
OLD_FILES+=usr/include/c++/3.4/stack
OLD_FILES+=usr/include/c++/3.4/stdexcept
OLD_FILES+=usr/include/c++/3.4/streambuf
OLD_FILES+=usr/include/c++/3.4/string
OLD_FILES+=usr/include/c++/3.4/typeinfo
OLD_FILES+=usr/include/c++/3.4/utility
OLD_FILES+=usr/include/c++/3.4/valarray
OLD_FILES+=usr/include/c++/3.4/vector
OLD_DIRS+=usr/include/c++/3.4/backward
OLD_DIRS+=usr/include/c++/3.4/bits
OLD_DIRS+=usr/include/c++/3.4/debug
OLD_DIRS+=usr/include/c++/3.4/ext
OLD_DIRS+=usr/include/c++/3.4
# 20070510: zpool/zfs moved to /sbin
OLD_FILES+=usr/sbin/zfs
OLD_FILES+=usr/sbin/zpool
# 20070423: rc.bluetooth (examples) removed
OLD_FILES+=usr/share/examples/netgraph/bluetooth/rc.bluetooth
OLD_DIRS+=usr/share/examples/netgraph/bluetooth
# 20070421: worm.4 removed
OLD_FILES+=usr/share/man/man4/worm.4.gz
# 20070417: trunk(4) renamed to lagg(4)
OLD_FILES+=usr/include/net/if_trunk.h
# 20070409: uuidgen moved to /bin/
OLD_FILES+=usr/bin/uuidgen
# 20070328: bzip2 1.0.4
OLD_FILES+=usr/share/info/bzip2.info.gz
# 20070303: libarchive 2.0
OLD_LIBS+=usr/lib/libarchive.so.3
OLD_LIBS+=usr/lib32/libarchive.so.3
# 20070301: remove addr2ascii and ascii2addr
OLD_FILES+=usr/share/man/man3/addr2ascii.3.gz
OLD_FILES+=usr/share/man/man3/ascii2addr.3.gz
# 20070225: vm_page_unmanage() removed
OLD_FILES+=usr/share/man/man9/vm_page_unmanage.9.gz
# 20070216: VFS_VPTOFH(9) -> VOP_VPTOFH(9)
OLD_FILES+=usr/share/man/man9/VFS_VPTOFH.9.gz
# 20070212: kame.4 removed
OLD_FILES+=usr/share/man/man4/kame.4.gz
# 20070201: remove libmytinfo link
OLD_FILES+=usr/lib/libmytinfo.a
OLD_FILES+=usr/lib/libmytinfo.so
OLD_FILES+=usr/lib/libmytinfo_p.a
OLD_FILES+=usr/lib/libmytinfow.a
OLD_FILES+=usr/lib/libmytinfow.so
OLD_FILES+=usr/lib/libmytinfow_p.a
OLD_FILES+=usr/lib32/libmytinfo.a
OLD_FILES+=usr/lib32/libmytinfo.so
OLD_FILES+=usr/lib32/libmytinfo_p.a
OLD_FILES+=usr/lib32/libmytinfow.a
OLD_FILES+=usr/lib32/libmytinfow.so
OLD_FILES+=usr/lib32/libmytinfow_p.a
# 20070128: remove vnconfig
OLD_FILES+=usr/sbin/vnconfig
# 20070127: remove bpf_compat.h
OLD_FILES+=usr/include/net/bpf_compat.h
# 20070125: objformat bites the dust
OLD_FILES+=usr/bin/objformat
OLD_FILES+=usr/share/man/man1/objformat.1.gz
OLD_FILES+=usr/include/objformat.h
OLD_FILES+=usr/share/man/man3/getobjformat.3.gz
# 20061201: remove symlink to *.so.4 libalias modules
OLD_FILES+=usr/lib/libalias_cuseeme.so
OLD_FILES+=usr/lib/libalias_dummy.so
OLD_FILES+=usr/lib/libalias_ftp.so
OLD_FILES+=usr/lib/libalias_irc.so
OLD_FILES+=usr/lib/libalias_nbt.so
OLD_FILES+=usr/lib/libalias_pptp.so
OLD_FILES+=usr/lib/libalias_skinny.so
OLD_FILES+=usr/lib/libalias_smedia.so
# 20061201: remove old *.so.4 libalias modules
OLD_FILES+=lib/libalias_cuseeme.so.4
OLD_FILES+=lib/libalias_dummy.so.4
OLD_FILES+=lib/libalias_ftp.so.4
OLD_FILES+=lib/libalias_irc.so.4
OLD_FILES+=lib/libalias_nbt.so.4
OLD_FILES+=lib/libalias_pptp.so.4
OLD_FILES+=lib/libalias_skinny.so.4
OLD_FILES+=lib/libalias_smedia.so.4
# 20061126: remove old man page
OLD_FILES+=usr/share/man/man3/archive_read_set_bytes_per_block.3.gz
# 20061125: remove old man page
OLD_FILES+=usr/share/man/man9/devsw.9.gz
# 20061122: remove obsolete mount programs
OLD_FILES+=sbin/mount_devfs
OLD_FILES+=sbin/mount_ext2fs
OLD_FILES+=sbin/mount_fdescfs
OLD_FILES+=sbin/mount_linprocfs
OLD_FILES+=sbin/mount_procfs
OLD_FILES+=sbin/mount_std
OLD_FILES+=rescue/mount_devfs
OLD_FILES+=rescue/mount_ext2fs
OLD_FILES+=rescue/mount_fdescfs
OLD_FILES+=rescue/mount_linprocfs
OLD_FILES+=rescue/mount_procfs
OLD_FILES+=rescue/mount_std
OLD_FILES+=usr/share/man/man8/mount_devfs.8.gz
OLD_FILES+=usr/share/man/man8/mount_ext2fs.8.gz
OLD_FILES+=usr/share/man/man8/mount_fdescfs.8.gz
OLD_FILES+=usr/share/man/man8/mount_linprocfs.8.gz
OLD_FILES+=usr/share/man/man8/mount_procfs.8.gz
OLD_FILES+=usr/share/man/man8/mount_std.8.gz
# 20061116: uhidev.4 removed
OLD_FILES+=usr/share/man/man4/uhidev.4.gz
# 20061106: archive_write_prepare.3 removed
OLD_FILES+=usr/share/man/man3/archive_write_prepare.3.gz
.if ${TARGET_ARCH} == "ia64"
# 20061104: skiload.help removed
OLD_FILES+=boot/skiload.help
.endif
# 20061018: pccardc removed
OLD_FILES+=usr/sbin/pccardc usr/share/man/man8/pccardc.8.gz
# 20060930: demangle.h from contrib/libstdc++/include/ext/
OLD_FILES+=usr/include/c++/3.4/ext/demangle.h
# 20060929: mrouted removed
OLD_FILES+=usr/sbin/map-mbone
OLD_FILES+=usr/sbin/mrinfo
OLD_FILES+=usr/sbin/mrouted
OLD_FILES+=usr/sbin/mtrace
OLD_FILES+=usr/share/man/man8/map-mbone.8.gz
OLD_FILES+=usr/share/man/man8/mrinfo.8.gz
OLD_FILES+=usr/share/man/man8/mrouted.8.gz
OLD_FILES+=usr/share/man/man8/mtrace.8.gz
# 20060924: tcpslice removed
OLD_FILES+=usr/sbin/tcpslice
OLD_FILES+=usr/share/man/man1/tcpslice.1.gz
# 20060829: kvmdb cleanup script removed
OLD_FILES+=etc/periodic/weekly/120.clean-kvmdb
# 20060822: ramdisk{,-own} have been replaced by mdconfig{,2}
OLD_FILES+=etc/rc.d/ramdisk
OLD_FILES+=etc/rc.d/ramdisk-own
# 20060729: OpenSSL 0.9.7e -> 0.9.8b upgrade
OLD_FILES+=usr/include/openssl/eng_int.h
OLD_FILES+=usr/include/openssl/hw_4758_cca_err.h
OLD_FILES+=usr/include/openssl/hw_aep_err.h
OLD_FILES+=usr/include/openssl/hw_atalla_err.h
OLD_FILES+=usr/include/openssl/hw_cswift_err.h
OLD_FILES+=usr/include/openssl/hw_ncipher_err.h
OLD_FILES+=usr/include/openssl/hw_nuron_err.h
OLD_FILES+=usr/include/openssl/hw_sureware_err.h
OLD_FILES+=usr/include/openssl/hw_ubsec_err.h
# 20060713: mount_linsysfs(8) never existed in 7.x
OLD_FILES+=sbin/mount_linsysfs
OLD_FILES+=usr/share/man/man8/mount_linsysfs.8.gz
# 20060704: KAME compat file net_osdep.h removed
OLD_FILES+=usr/include/net/net_osdep.h
# 20060605: man page links removed by OpenBSM 1.0 alpha 6 import
OLD_FILES+=usr/share/man/man3/au_to_socket.3.gz
OLD_FILES+=usr/share/man/man3/au_to_socket_ex_128.3.gz
OLD_FILES+=usr/share/man/man3/au_to_socket_ex_32.3.gz
# 20060517: pcvt removed
OLD_FILES+=usr/share/pcvt/README.FIRST
OLD_FILES+=usr/share/pcvt/Etc/xmodmap-german
OLD_FILES+=usr/share/pcvt/Etc/pcvt.sh
OLD_FILES+=usr/share/pcvt/Etc/pcvt.el
OLD_FILES+=usr/share/pcvt/Etc/Terminfo
OLD_FILES+=usr/share/pcvt/Etc/Termcap
OLD_DIRS+=usr/share/pcvt/Etc
OLD_FILES+=usr/share/pcvt/Doc/NotesAndHints
OLD_FILES+=usr/share/pcvt/Doc/Keyboard.VT
OLD_FILES+=usr/share/pcvt/Doc/Keyboard.HP
OLD_FILES+=usr/share/pcvt/Doc/EscapeSequences
OLD_FILES+=usr/share/pcvt/Doc/Charsets
OLD_FILES+=usr/share/pcvt/Doc/CharGen
OLD_FILES+=usr/share/pcvt/Doc/Bibliography
OLD_FILES+=usr/share/pcvt/Doc/Acknowledgements
OLD_DIRS+=usr/share/pcvt/Doc
OLD_DIRS+=usr/share/pcvt
OLD_FILES+=usr/share/misc/pcvtfonts/vt220l.816
OLD_FILES+=usr/share/misc/pcvtfonts/vt220l.814
OLD_FILES+=usr/share/misc/pcvtfonts/vt220l.810
OLD_FILES+=usr/share/misc/pcvtfonts/vt220l.808
OLD_FILES+=usr/share/misc/pcvtfonts/vt220h.816
OLD_FILES+=usr/share/misc/pcvtfonts/vt220h.814
OLD_FILES+=usr/share/misc/pcvtfonts/vt220h.810
OLD_FILES+=usr/share/misc/pcvtfonts/vt220h.808
OLD_DIRS+=usr/share/misc/pcvtfonts
OLD_FILES+=usr/share/misc/keycap.pcvt
OLD_FILES+=usr/share/man/man8/ispcvt.8.gz
OLD_FILES+=usr/share/man/man5/keycap.5.gz
OLD_FILES+=usr/share/man/man4/pcvt.4.gz
OLD_FILES+=usr/share/man/man3/kgetstr.3.gz
OLD_FILES+=usr/share/man/man3/kgetnum.3.gz
OLD_FILES+=usr/share/man/man3/kgetflag.3.gz
OLD_FILES+=usr/share/man/man3/kgetent.3.gz
OLD_FILES+=usr/share/man/man3/keycap.3.gz
OLD_FILES+=usr/share/man/man1/vt220keys.1.gz
OLD_FILES+=usr/share/man/man1/scon.1.gz
OLD_FILES+=usr/share/man/man1/loadfont.1.gz
OLD_FILES+=usr/share/man/man1/kcon.1.gz
OLD_FILES+=usr/share/man/man1/fontedit.1.gz
OLD_FILES+=usr/share/man/man1/cursor.1.gz
OLD_FILES+=usr/sbin/vt220keys
OLD_FILES+=usr/sbin/scon
OLD_FILES+=usr/sbin/loadfont
OLD_FILES+=usr/sbin/kcon
OLD_FILES+=usr/sbin/ispcvt
OLD_FILES+=usr/sbin/fontedit
OLD_FILES+=usr/sbin/cursor
OLD_FILES+=usr/lib/libkeycap_p.a
OLD_FILES+=usr/lib/libkeycap.a
OLD_FILES+=usr/include/machine/pcvt_ioctl.h
# 20060514: lnc(4) replaced by le(4)
OLD_FILES+=usr/share/man/man4/i386/lnc.4.gz
# 20060512: remove ip6fw
OLD_FILES+=etc/periodic/security/600.ip6fwdenied
OLD_FILES+=etc/periodic/security/650.ip6fwlimit
OLD_FILES+=sbin/ip6fw
OLD_FILES+=usr/include/netinet6/ip6_fw.h
OLD_FILES+=usr/share/man/man8/ip6fw.8.gz
# 20060424: sab(4) removed
OLD_FILES+=usr/share/man/man4/sab.4.gz
# 20060328: remove redundant rc.d script
OLD_FILES+=etc/rc.d/ike
# 20060127: revert libdisk to static-only
OLD_FILES+=usr/lib/libdisk.so
# 20060115: sys/pccard includes cleanup
OLD_FILES+=usr/include/pccard/driver.h
OLD_FILES+=usr/include/pccard/i82365.h
OLD_FILES+=usr/include/pccard/meciareg.h
OLD_FILES+=usr/include/pccard/pccard_nbk.h
OLD_FILES+=usr/include/pccard/pcic_pci.h
OLD_FILES+=usr/include/pccard/pcicvar.h
OLD_FILES+=usr/include/pccard/slot.h
# 20051215: rescue/nextboot.sh renamed to rescue/nextboot
OLD_FILES+=rescue/nextboot.sh
# 20051214: usbd(8) removed
OLD_FILES+=etc/rc.d/usbd
OLD_FILES+=etc/usbd.conf
OLD_FILES+=usr/sbin/usbd
OLD_FILES+=usr/share/man/man8/usbd.8.gz
# 20051029: rc.d/ppp-user renamed to rc.d/ppp for convenience
OLD_FILES+=etc/rc.d/ppp-user
# 20051012: setkey(8) moved to /sbin/
OLD_FILES+=usr/sbin/setkey
# 20050930: pccardd(8) removed
OLD_FILES+=usr/sbin/pccardd
OLD_FILES+=usr/share/man/man5/pccard.conf.5.gz
OLD_FILES+=usr/share/man/man8/pccardd.8.gz
# 20050927: bridge(4) replaced by if_bridge(4)
OLD_FILES+=usr/include/net/bridge.h
# 20050831: not implemented
OLD_FILES+=usr/share/man/man3/getino.3.gz
OLD_FILES+=usr/share/man/man3/putino.3.gz
# 20050825: T/TCP retired several months ago
OLD_FILES+=usr/share/man/man4/ttcp.4.gz
# 20050805 tn3270 retired long ago
OLD_FILES+=usr/share/misc/map3270
# 20050801: too old to be interesting here
OLD_FILES+=usr/share/doc/papers/px.ps.gz
# 20050721: moved to ports
OLD_FILES+=usr/sbin/vttest
OLD_FILES+=usr/share/man/man1/vttest.1.gz
# 20050617: wpa man pages moved to section 8
OLD_FILES+=usr/share/man/man1/hostapd.1.gz
OLD_FILES+=usr/share/man/man1/hostapd_cli.1.gz
OLD_FILES+=usr/share/man/man1/wpa_cli.1.gz
OLD_FILES+=usr/share/man/man1/wpa_supplicant.1.gz
# 20050610: rexecd (insecure by design)
OLD_FILES+=etc/pam.d/rexecd
OLD_FILES+=usr/share/man/man8/rexecd.8.gz
OLD_FILES+=usr/libexec/rexecd
# 20050606: OpenBSD dhclient replaces ISC one
OLD_FILES+=bin/omshell
OLD_FILES+=sbin/omshell
OLD_FILES+=usr/share/man/man1/omshell.1.gz
OLD_FILES+=usr/share/man/man5/dhcp-eval.5.gz
# 200504XX: ipf tools moved from /usr to /
OLD_FILES+=rescue/ipfs
OLD_FILES+=rescue/ipfstat
OLD_FILES+=rescue/ipmon
OLD_FILES+=rescue/ipnat
OLD_FILES+=usr/sbin/ipftest
OLD_FILES+=usr/sbin/ipresend
OLD_FILES+=usr/sbin/ipsend
OLD_FILES+=usr/sbin/iptest
OLD_FILES+=usr/share/man/man1/ipnat.1.gz
OLD_FILES+=usr/share/man/man1/ipsend.1.gz
OLD_FILES+=usr/share/man/man1/iptest.1.gz
OLD_FILES+=usr/share/man/man5/ipsend.5.gz
# 200503XX: bsdtar takes over gtar
OLD_FILES+=usr/bin/gtar
OLD_FILES+=usr/share/man/man1/gtar.1.gz
# 200503XX
OLD_FILES+=usr/share/man/man3/exp10.3.gz
OLD_FILES+=usr/share/man/man3/exp10f.3.gz
OLD_FILES+=usr/share/man/man3/fpsetsticky.3.gz
# 20050324: updated release infrastructure
OLD_FILES+=usr/share/man/man5/drivers.conf.5.gz
# 20050317: removed from BIND 9 distribution
OLD_FILES+=usr/share/doc/bind9/KNOWN_DEFECTS
# 2005XXXX:
OLD_FILES+=sbin/mount_autofs
OLD_FILES+=usr/lib/libautofs.a
OLD_FILES+=usr/lib/libautofs.so
OLD_FILES+=usr/share/man/man8/mount_autofs.8.gz
# 20050203: Merged with fortunes
OLD_FILES+=usr/share/games/fortune/fortunes2
OLD_FILES+=usr/share/games/fortune/fortunes2.dat
# 200501XX:
OLD_FILES+=usr/libexec/getNAME
# 200411XX: gvinum replaces vinum
OLD_FILES+=bin/vinum
OLD_FILES+=rescue/vinum
OLD_FILES+=sbin/vinum
OLD_FILES+=usr/share/man/man8/vinum.8.gz
# 200411XX: libxpg4 removal
OLD_FILES+=usr/lib/libxpg4.a
OLD_FILES+=usr/lib/libxpg4.so
OLD_FILES+=usr/lib/libxpg4_p.a
# 20041109: replaced by em(4)
OLD_FILES+=usr/share/man/man4/gx.4.gz
OLD_FILES+=usr/share/man/man4/if_gx.4.gz
# 20041017: rune interface removed
OLD_FILES+=usr/include/rune.h
OLD_FILES+=usr/share/man/man3/fgetrune.3.gz
OLD_FILES+=usr/share/man/man3/fputrune.3.gz
OLD_FILES+=usr/share/man/man3/fungetrune.3.gz
OLD_FILES+=usr/share/man/man3/mbrrune.3.gz
OLD_FILES+=usr/share/man/man3/mbrune.3.gz
OLD_FILES+=usr/share/man/man3/rune.3.gz
OLD_FILES+=usr/share/man/man3/setinvalidrune.3.gz
OLD_FILES+=usr/share/man/man3/sgetrune.3.gz
OLD_FILES+=usr/share/man/man3/sputrune.3.gz
# 20040925: bind9 import
OLD_FILES+=usr/bin/dnskeygen
OLD_FILES+=usr/bin/dnsquery
OLD_FILES+=usr/lib/libisc.a
OLD_FILES+=usr/lib/libisc.so
OLD_FILES+=usr/lib/libisc_p.a
OLD_FILES+=usr/libexec/named-xfer
OLD_FILES+=usr/sbin/named.restart
OLD_FILES+=usr/sbin/ndc
OLD_FILES+=usr/sbin/nslookup
OLD_FILES+=usr/sbin/nsupdate
OLD_FILES+=usr/share/doc/bind/html/acl.html
OLD_FILES+=usr/share/doc/bind/html/address_list.html
OLD_FILES+=usr/share/doc/bind/html/comments.html
OLD_FILES+=usr/share/doc/bind/html/config.html
OLD_FILES+=usr/share/doc/bind/html/controls.html
OLD_FILES+=usr/share/doc/bind/html/docdef.html
OLD_FILES+=usr/share/doc/bind/html/example.html
OLD_FILES+=usr/share/doc/bind/html/include.html
OLD_FILES+=usr/share/doc/bind/html/index.html
OLD_FILES+=usr/share/doc/bind/html/key.html
OLD_FILES+=usr/share/doc/bind/html/logging.html
OLD_FILES+=usr/share/doc/bind/html/master.html
OLD_FILES+=usr/share/doc/bind/html/options.html
OLD_FILES+=usr/share/doc/bind/html/server.html
OLD_FILES+=usr/share/doc/bind/html/trusted-keys.html
OLD_FILES+=usr/share/doc/bind/html/zone.html
OLD_FILES+=usr/share/doc/bind/misc/DynamicUpdate
OLD_FILES+=usr/share/doc/bind/misc/FAQ.1of2
OLD_FILES+=usr/share/doc/bind/misc/FAQ.2of2
OLD_FILES+=usr/share/doc/bind/misc/rfc2317-notes.txt
OLD_FILES+=usr/share/doc/bind/misc/style.txt
OLD_FILES+=usr/share/man/man1/dnskeygen.1.gz
OLD_FILES+=usr/share/man/man1/dnsquery.1.gz
OLD_FILES+=usr/share/man/man8/named-bootconf.8.gz
OLD_FILES+=usr/share/man/man8/named-xfer.8.gz
OLD_FILES+=usr/share/man/man8/named.restart.8.gz
OLD_FILES+=usr/share/man/man8/ndc.8.gz
OLD_FILES+=usr/share/man/man8/nslookup.8.gz
# 200409XX
OLD_FILES+=usr/share/man/man3/ENSURE.3.gz
OLD_FILES+=usr/share/man/man3/ENSURE_ERR.3.gz
OLD_FILES+=usr/share/man/man3/INSIST.3.gz
OLD_FILES+=usr/share/man/man3/INSIST_ERR.3.gz
OLD_FILES+=usr/share/man/man3/INVARIANT.3.gz
OLD_FILES+=usr/share/man/man3/INVARIANT_ERR.3.gz
OLD_FILES+=usr/share/man/man3/REQUIRE.3.gz
OLD_FILES+=usr/share/man/man3/REQUIRE_ERR.3.gz
OLD_FILES+=usr/share/man/man3/assertion_type_to_text.3.gz
OLD_FILES+=usr/share/man/man3/assertions.3.gz
OLD_FILES+=usr/share/man/man3/bitncmp.3.gz
OLD_FILES+=usr/share/man/man3/evAddTime.3.gz
OLD_FILES+=usr/share/man/man3/evCancelConn.3.gz
OLD_FILES+=usr/share/man/man3/evCancelRW.3.gz
OLD_FILES+=usr/share/man/man3/evClearIdleTimer.3.gz
OLD_FILES+=usr/share/man/man3/evClearTimer.3.gz
OLD_FILES+=usr/share/man/man3/evCmpTime.3.gz
OLD_FILES+=usr/share/man/man3/evConnFunc.3.gz
OLD_FILES+=usr/share/man/man3/evConnect.3.gz
OLD_FILES+=usr/share/man/man3/evConsIovec.3.gz
OLD_FILES+=usr/share/man/man3/evConsTime.3.gz
OLD_FILES+=usr/share/man/man3/evCreate.3.gz
OLD_FILES+=usr/share/man/man3/evDefer.3.gz
OLD_FILES+=usr/share/man/man3/evDeselectFD.3.gz
OLD_FILES+=usr/share/man/man3/evDestroy.3.gz
OLD_FILES+=usr/share/man/man3/evDispatch.3.gz
OLD_FILES+=usr/share/man/man3/evDo.3.gz
OLD_FILES+=usr/share/man/man3/evDrop.3.gz
OLD_FILES+=usr/share/man/man3/evFileFunc.3.gz
OLD_FILES+=usr/share/man/man3/evGetNext.3.gz
OLD_FILES+=usr/share/man/man3/evHold.3.gz
OLD_FILES+=usr/share/man/man3/evInitID.3.gz
OLD_FILES+=usr/share/man/man3/evLastEventTime.3.gz
OLD_FILES+=usr/share/man/man3/evListen.3.gz
OLD_FILES+=usr/share/man/man3/evMainLoop.3.gz
OLD_FILES+=usr/share/man/man3/evNowTime.3.gz
OLD_FILES+=usr/share/man/man3/evPrintf.3.gz
OLD_FILES+=usr/share/man/man3/evRead.3.gz
OLD_FILES+=usr/share/man/man3/evResetTimer.3.gz
OLD_FILES+=usr/share/man/man3/evSelectFD.3.gz
OLD_FILES+=usr/share/man/man3/evSetDebug.3.gz
OLD_FILES+=usr/share/man/man3/evSetIdleTimer.3.gz
OLD_FILES+=usr/share/man/man3/evSetTimer.3.gz
OLD_FILES+=usr/share/man/man3/evStreamFunc.3.gz
OLD_FILES+=usr/share/man/man3/evSubTime.3.gz
OLD_FILES+=usr/share/man/man3/evTestID.3.gz
OLD_FILES+=usr/share/man/man3/evTimeRW.3.gz
OLD_FILES+=usr/share/man/man3/evTimeSpec.3.gz
OLD_FILES+=usr/share/man/man3/evTimeVal.3.gz
OLD_FILES+=usr/share/man/man3/evTimerFunc.3.gz
OLD_FILES+=usr/share/man/man3/evTouchIdleTimer.3.gz
OLD_FILES+=usr/share/man/man3/evTryAccept.3.gz
OLD_FILES+=usr/share/man/man3/evUnhold.3.gz
OLD_FILES+=usr/share/man/man3/evUntimeRW.3.gz
OLD_FILES+=usr/share/man/man3/evUnwait.3.gz
OLD_FILES+=usr/share/man/man3/evWaitFor.3.gz
OLD_FILES+=usr/share/man/man3/evWaitFunc.3.gz
OLD_FILES+=usr/share/man/man3/evWrite.3.gz
OLD_FILES+=usr/share/man/man3/eventlib.3.gz
OLD_FILES+=usr/share/man/man3/heap.3.gz
OLD_FILES+=usr/share/man/man3/heap_decreased.3.gz
OLD_FILES+=usr/share/man/man3/heap_delete.3.gz
OLD_FILES+=usr/share/man/man3/heap_element.3.gz
OLD_FILES+=usr/share/man/man3/heap_for_each.3.gz
OLD_FILES+=usr/share/man/man3/heap_free.3.gz
OLD_FILES+=usr/share/man/man3/heap_increased.3.gz
OLD_FILES+=usr/share/man/man3/heap_insert.3.gz
OLD_FILES+=usr/share/man/man3/heap_new.3.gz
OLD_FILES+=usr/share/man/man3/log_add_channel.3.gz
OLD_FILES+=usr/share/man/man3/log_category_is_active.3.gz
OLD_FILES+=usr/share/man/man3/log_close_stream.3.gz
OLD_FILES+=usr/share/man/man3/log_dec_references.3.gz
OLD_FILES+=usr/share/man/man3/log_free_channel.3.gz
OLD_FILES+=usr/share/man/man3/log_free_context.3.gz
OLD_FILES+=usr/share/man/man3/log_get_filename.3.gz
OLD_FILES+=usr/share/man/man3/log_get_stream.3.gz
OLD_FILES+=usr/share/man/man3/log_inc_references.3.gz
OLD_FILES+=usr/share/man/man3/log_new_context.3.gz
OLD_FILES+=usr/share/man/man3/log_new_file_channel.3.gz
OLD_FILES+=usr/share/man/man3/log_new_null_channel.3.gz
OLD_FILES+=usr/share/man/man3/log_new_syslog_channel.3.gz
OLD_FILES+=usr/share/man/man3/log_open_stream.3.gz
OLD_FILES+=usr/share/man/man3/log_option.3.gz
OLD_FILES+=usr/share/man/man3/log_remove_channel.3.gz
OLD_FILES+=usr/share/man/man3/log_set_file_owner.3.gz
OLD_FILES+=usr/share/man/man3/log_vwrite.3.gz
OLD_FILES+=usr/share/man/man3/log_write.3.gz
OLD_FILES+=usr/share/man/man3/logging.3.gz
OLD_FILES+=usr/share/man/man3/memcluster.3.gz
OLD_FILES+=usr/share/man/man3/memget.3.gz
OLD_FILES+=usr/share/man/man3/memput.3.gz
OLD_FILES+=usr/share/man/man3/memstats.3.gz
OLD_FILES+=usr/share/man/man3/set_assertion_failure_callback.3.
OLD_FILES+=usr/share/man/man3/sigwait.3.gz
OLD_FILES+=usr/share/man/man3/tree_add.3.gz
OLD_FILES+=usr/share/man/man3/tree_delete.3.gz
OLD_FILES+=usr/share/man/man3/tree_init.3.gz
OLD_FILES+=usr/share/man/man3/tree_mung.3.gz
OLD_FILES+=usr/share/man/man3/tree_srch.3.gz
OLD_FILES+=usr/share/man/man3/tree_trav.3.gz
# 2004XXYY: OS internal libs, no ports use them, no need to use OLD_LIBS
OLD_FILES+=lib/geom/geom_concat.so.1
OLD_FILES+=lib/geom/geom_label.so.1
OLD_FILES+=lib/geom/geom_nop.so.1
OLD_FILES+=lib/geom/geom_stripe.so.1
# 20040728: GCC 3.4.2
OLD_DIRS+=usr/include/c++/3.3
OLD_FILES+=usr/include/c++/3.3/FlexLexer.h
OLD_FILES+=usr/include/c++/3.3/algorithm
OLD_FILES+=usr/include/c++/3.3/backward/algo.h
OLD_FILES+=usr/include/c++/3.3/backward/algobase.h
OLD_FILES+=usr/include/c++/3.3/backward/alloc.h
OLD_FILES+=usr/include/c++/3.3/backward/backward_warning.h
OLD_FILES+=usr/include/c++/3.3/backward/bvector.h
OLD_FILES+=usr/include/c++/3.3/backward/complex.h
OLD_FILES+=usr/include/c++/3.3/backward/defalloc.h
OLD_FILES+=usr/include/c++/3.3/backward/deque.h
OLD_FILES+=usr/include/c++/3.3/backward/fstream.h
OLD_FILES+=usr/include/c++/3.3/backward/function.h
OLD_FILES+=usr/include/c++/3.3/backward/hash_map.h
OLD_FILES+=usr/include/c++/3.3/backward/hash_set.h
OLD_FILES+=usr/include/c++/3.3/backward/hashtable.h
OLD_FILES+=usr/include/c++/3.3/backward/heap.h
OLD_FILES+=usr/include/c++/3.3/backward/iomanip.h
OLD_FILES+=usr/include/c++/3.3/backward/iostream.h
OLD_FILES+=usr/include/c++/3.3/backward/istream.h
OLD_FILES+=usr/include/c++/3.3/backward/iterator.h
OLD_FILES+=usr/include/c++/3.3/backward/list.h
OLD_FILES+=usr/include/c++/3.3/backward/map.h
OLD_FILES+=usr/include/c++/3.3/backward/multimap.h
OLD_FILES+=usr/include/c++/3.3/backward/multiset.h
OLD_FILES+=usr/include/c++/3.3/backward/new.h
OLD_FILES+=usr/include/c++/3.3/backward/ostream.h
OLD_FILES+=usr/include/c++/3.3/backward/pair.h
OLD_FILES+=usr/include/c++/3.3/backward/queue.h
OLD_FILES+=usr/include/c++/3.3/backward/rope.h
OLD_FILES+=usr/include/c++/3.3/backward/set.h
OLD_FILES+=usr/include/c++/3.3/backward/slist.h
OLD_FILES+=usr/include/c++/3.3/backward/stack.h
OLD_FILES+=usr/include/c++/3.3/backward/stream.h
OLD_FILES+=usr/include/c++/3.3/backward/streambuf.h
OLD_FILES+=usr/include/c++/3.3/backward/strstream
OLD_FILES+=usr/include/c++/3.3/backward/strstream.h
OLD_FILES+=usr/include/c++/3.3/backward/tempbuf.h
OLD_FILES+=usr/include/c++/3.3/backward/tree.h
OLD_FILES+=usr/include/c++/3.3/backward/vector.h
OLD_DIRS+=usr/include/c++/3.3/backward
OLD_FILES+=usr/include/c++/3.3/bits/atomicity.h
OLD_FILES+=usr/include/c++/3.3/bits/basic_file.h
OLD_FILES+=usr/include/c++/3.3/bits/basic_ios.h
OLD_FILES+=usr/include/c++/3.3/bits/basic_ios.tcc
OLD_FILES+=usr/include/c++/3.3/bits/basic_string.h
OLD_FILES+=usr/include/c++/3.3/bits/basic_string.tcc
OLD_FILES+=usr/include/c++/3.3/bits/boost_concept_check.h
OLD_FILES+=usr/include/c++/3.3/bits/c++config.h
OLD_FILES+=usr/include/c++/3.3/bits/c++io.h
OLD_FILES+=usr/include/c++/3.3/bits/c++locale.h
OLD_FILES+=usr/include/c++/3.3/bits/c++locale_internal.h
OLD_FILES+=usr/include/c++/3.3/bits/char_traits.h
OLD_FILES+=usr/include/c++/3.3/bits/cmath.tcc
OLD_FILES+=usr/include/c++/3.3/bits/codecvt.h
OLD_FILES+=usr/include/c++/3.3/bits/codecvt_specializations.h
OLD_FILES+=usr/include/c++/3.3/bits/concept_check.h
OLD_FILES+=usr/include/c++/3.3/bits/cpp_type_traits.h
OLD_FILES+=usr/include/c++/3.3/bits/ctype_base.h
OLD_FILES+=usr/include/c++/3.3/bits/ctype_inline.h
OLD_FILES+=usr/include/c++/3.3/bits/ctype_noninline.h
OLD_FILES+=usr/include/c++/3.3/bits/deque.tcc
OLD_FILES+=usr/include/c++/3.3/bits/fpos.h
OLD_FILES+=usr/include/c++/3.3/bits/fstream.tcc
OLD_FILES+=usr/include/c++/3.3/bits/functexcept.h
OLD_FILES+=usr/include/c++/3.3/bits/generic_shadow.h
OLD_FILES+=usr/include/c++/3.3/bits/gslice.h
OLD_FILES+=usr/include/c++/3.3/bits/gslice_array.h
OLD_FILES+=usr/include/c++/3.3/bits/gthr-default.h
OLD_FILES+=usr/include/c++/3.3/bits/gthr-posix.h
OLD_FILES+=usr/include/c++/3.3/bits/gthr-single.h
OLD_FILES+=usr/include/c++/3.3/bits/gthr.h
OLD_FILES+=usr/include/c++/3.3/bits/indirect_array.h
OLD_FILES+=usr/include/c++/3.3/bits/ios_base.h
OLD_FILES+=usr/include/c++/3.3/bits/istream.tcc
OLD_FILES+=usr/include/c++/3.3/bits/list.tcc
OLD_FILES+=usr/include/c++/3.3/bits/locale_classes.h
OLD_FILES+=usr/include/c++/3.3/bits/locale_facets.h
OLD_FILES+=usr/include/c++/3.3/bits/locale_facets.tcc
OLD_FILES+=usr/include/c++/3.3/bits/localefwd.h
OLD_FILES+=usr/include/c++/3.3/bits/mask_array.h
OLD_FILES+=usr/include/c++/3.3/bits/messages_members.h
OLD_FILES+=usr/include/c++/3.3/bits/os_defines.h
OLD_FILES+=usr/include/c++/3.3/bits/ostream.tcc
OLD_FILES+=usr/include/c++/3.3/bits/pthread_allocimpl.h
OLD_FILES+=usr/include/c++/3.3/bits/slice.h
OLD_FILES+=usr/include/c++/3.3/bits/slice_array.h
OLD_FILES+=usr/include/c++/3.3/bits/sstream.tcc
OLD_FILES+=usr/include/c++/3.3/bits/stl_algo.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_algobase.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_alloc.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_bvector.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_construct.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_deque.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_function.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_heap.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_iterator.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_iterator_base_funcs.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_iterator_base_types.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_list.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_map.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_multimap.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_multiset.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_numeric.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_pair.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_pthread_alloc.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_queue.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_raw_storage_iter.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_relops.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_set.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_stack.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_tempbuf.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_threads.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_tree.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_uninitialized.h
OLD_FILES+=usr/include/c++/3.3/bits/stl_vector.h
OLD_FILES+=usr/include/c++/3.3/bits/stream_iterator.h
OLD_FILES+=usr/include/c++/3.3/bits/streambuf.tcc
OLD_FILES+=usr/include/c++/3.3/bits/streambuf_iterator.h
OLD_FILES+=usr/include/c++/3.3/bits/stringfwd.h
OLD_FILES+=usr/include/c++/3.3/bits/time_members.h
OLD_FILES+=usr/include/c++/3.3/bits/type_traits.h
OLD_FILES+=usr/include/c++/3.3/bits/valarray_array.h
OLD_FILES+=usr/include/c++/3.3/bits/valarray_array.tcc
OLD_FILES+=usr/include/c++/3.3/bits/valarray_meta.h
OLD_FILES+=usr/include/c++/3.3/bits/vector.tcc
OLD_DIRS+=usr/include/c++/3.3/bits
OLD_FILES+=usr/include/c++/3.3/bitset
OLD_FILES+=usr/include/c++/3.3/cassert
OLD_FILES+=usr/include/c++/3.3/cctype
OLD_FILES+=usr/include/c++/3.3/cerrno
OLD_FILES+=usr/include/c++/3.3/cfloat
OLD_FILES+=usr/include/c++/3.3/ciso646
OLD_FILES+=usr/include/c++/3.3/climits
OLD_FILES+=usr/include/c++/3.3/clocale
OLD_FILES+=usr/include/c++/3.3/cmath
OLD_FILES+=usr/include/c++/3.3/complex
OLD_FILES+=usr/include/c++/3.3/csetjmp
OLD_FILES+=usr/include/c++/3.3/csignal
OLD_FILES+=usr/include/c++/3.3/cstdarg
OLD_FILES+=usr/include/c++/3.3/cstddef
OLD_FILES+=usr/include/c++/3.3/cstdio
OLD_FILES+=usr/include/c++/3.3/cstdlib
OLD_FILES+=usr/include/c++/3.3/cstring
OLD_FILES+=usr/include/c++/3.3/ctime
OLD_FILES+=usr/include/c++/3.3/cwchar
OLD_FILES+=usr/include/c++/3.3/cwctype
OLD_FILES+=usr/include/c++/3.3/cxxabi.h
OLD_FILES+=usr/include/c++/3.3/deque
OLD_FILES+=usr/include/c++/3.3/exception
OLD_FILES+=usr/include/c++/3.3/exception_defines.h
OLD_FILES+=usr/include/c++/3.3/ext/algorithm
OLD_FILES+=usr/include/c++/3.3/ext/enc_filebuf.h
OLD_FILES+=usr/include/c++/3.3/ext/functional
OLD_FILES+=usr/include/c++/3.3/ext/hash_map
OLD_FILES+=usr/include/c++/3.3/ext/hash_set
OLD_FILES+=usr/include/c++/3.3/ext/iterator
OLD_FILES+=usr/include/c++/3.3/ext/memory
OLD_FILES+=usr/include/c++/3.3/ext/numeric
OLD_FILES+=usr/include/c++/3.3/ext/rb_tree
OLD_FILES+=usr/include/c++/3.3/ext/rope
OLD_FILES+=usr/include/c++/3.3/ext/ropeimpl.h
OLD_FILES+=usr/include/c++/3.3/ext/slist
OLD_FILES+=usr/include/c++/3.3/ext/stdio_filebuf.h
OLD_FILES+=usr/include/c++/3.3/ext/stl_hash_fun.h
OLD_FILES+=usr/include/c++/3.3/ext/stl_hashtable.h
OLD_FILES+=usr/include/c++/3.3/ext/stl_rope.h
OLD_DIRS+=usr/include/c++/3.3/ext
OLD_FILES+=usr/include/c++/3.3/fstream
OLD_FILES+=usr/include/c++/3.3/functional
OLD_FILES+=usr/include/c++/3.3/iomanip
OLD_FILES+=usr/include/c++/3.3/ios
OLD_FILES+=usr/include/c++/3.3/iosfwd
OLD_FILES+=usr/include/c++/3.3/iostream
OLD_FILES+=usr/include/c++/3.3/istream
OLD_FILES+=usr/include/c++/3.3/iterator
OLD_FILES+=usr/include/c++/3.3/limits
OLD_FILES+=usr/include/c++/3.3/list
OLD_FILES+=usr/include/c++/3.3/locale
OLD_FILES+=usr/include/c++/3.3/map
OLD_FILES+=usr/include/c++/3.3/memory
OLD_FILES+=usr/include/c++/3.3/new
OLD_FILES+=usr/include/c++/3.3/numeric
OLD_FILES+=usr/include/c++/3.3/ostream
OLD_FILES+=usr/include/c++/3.3/queue
OLD_FILES+=usr/include/c++/3.3/set
OLD_FILES+=usr/include/c++/3.3/sstream
OLD_FILES+=usr/include/c++/3.3/stack
OLD_FILES+=usr/include/c++/3.3/stdexcept
OLD_FILES+=usr/include/c++/3.3/streambuf
OLD_FILES+=usr/include/c++/3.3/string
OLD_FILES+=usr/include/c++/3.3/typeinfo
OLD_FILES+=usr/include/c++/3.3/utility
OLD_FILES+=usr/include/c++/3.3/valarray
OLD_FILES+=usr/include/c++/3.3/vector
# 20040713: fla(4) removed.
OLD_FILES+=usr/share/man/man4/fla.4.gz
# 200407XX
OLD_FILES+=usr/sbin/kernbb
OLD_FILES+=usr/sbin/ntp-genkeys
OLD_FILES+=usr/sbin/ntptimeset
OLD_FILES+=usr/share/man/man8/kernbb.8.gz
OLD_FILES+=usr/share/man/man8/ntp-genkeys.8.gz
# 20040627: usbdevs.h and usbdevs_data.h removal
OLD_FILES+=usr/include/dev/usb/usbdevs.h
OLD_FILES+=usr/include/dev/usb/usbdevs_data.h
# 200406XX
OLD_FILES+=usr/bin/gasp
OLD_FILES+=usr/bin/gdbreplay
OLD_FILES+=usr/share/man/man1/gasp.1.gz
OLD_FILES+=sbin/mountd
OLD_FILES+=sbin/mount_fdesc
OLD_FILES+=sbin/mount_umap
OLD_FILES+=sbin/mount_union
OLD_FILES+=sbin/mount_msdos
OLD_FILES+=sbin/mount_null
OLD_FILES+=sbin/mount_kernfs
# 200405XX: arl
OLD_FILES+=usr/sbin/arlconfig
OLD_FILES+=usr/share/man/man8/arlconfig.8.gz
# 200403XX
OLD_FILES+=bin/raidctl
OLD_FILES+=sbin/raidctl
OLD_FILES+=usr/bin/sasc
OLD_FILES+=usr/sbin/sgsc
OLD_FILES+=usr/sbin/stlload
OLD_FILES+=usr/sbin/stlstats
OLD_FILES+=usr/share/man/man1/sasc.1.gz
OLD_FILES+=usr/share/man/man1/sgsc.1.gz
OLD_FILES+=usr/share/man/man4/i386/stl.4.gz
OLD_FILES+=usr/share/man/man8/raidctl.8.gz
# 20040229: clean_environment() was removed after 3 days
OLD_FILES+=usr/share/man/man3/clean_environment.3.gz
# 20040119: installed as `isdntel' in newer systems
OLD_FILES+=etc/isdn/isdntel.sh
# 200XYYZZ: /lib transition clitches
OLD_FILES+=lib/libalias.so
OLD_FILES+=lib/libatm.so
OLD_FILES+=lib/libbsdxml.so
OLD_FILES+=lib/libc.so
OLD_FILES+=lib/libcam.so
OLD_FILES+=lib/libcrypt.so
OLD_FILES+=lib/libcrypto.so
OLD_FILES+=lib/libdevstat.so
OLD_FILES+=lib/libedit.so
OLD_FILES+=lib/libgeom.so
OLD_FILES+=lib/libipsec.so
OLD_FILES+=lib/libipx.so
OLD_FILES+=lib/libkvm.so
OLD_FILES+=lib/libm.so
OLD_FILES+=lib/libmd.so
OLD_FILES+=lib/libncurses.so
OLD_FILES+=lib/libreadline.so
OLD_FILES+=lib/libsbuf.so
OLD_FILES+=lib/libufs.so
OLD_FILES+=lib/libz.so
# 200312XX
OLD_FILES+=bin/cxconfig
OLD_FILES+=sbin/cxconfig
OLD_FILES+=usr/share/man/man8/cxconfig.8.gz
# 20031016: MULTI_DRIVER_MODULE macro removed
OLD_FILES+=usr/share/man/man9/MULTI_DRIVER_MODULE.9.gz
# 200309XX
OLD_FILES+=usr/bin/symorder
OLD_FILES+=usr/share/man/man1/symorder.1.gz
# 200308XX
OLD_FILES+=usr/sbin/amldb
OLD_FILES+=usr/share/man/man8/amldb.8.gz
# 200307XX
OLD_FILES+=sbin/mount_nwfs
OLD_FILES+=sbin/mount_portalfs
OLD_FILES+=sbin/mount_smbfs
# 200306XX
OLD_FILES+=usr/sbin/dev_mkdb
OLD_FILES+=usr/share/man/man8/dev_mkdb.8.gz
# 200304XX
OLD_FILES+=usr/lib/libcipher.a
OLD_FILES+=usr/lib/libcipher.so
OLD_FILES+=usr/lib/libcipher_p.a
OLD_FILES+=usr/lib/libgmp.a
OLD_FILES+=usr/lib/libgmp.so
OLD_FILES+=usr/lib/libgmp_p.a
OLD_FILES+=usr/lib/libperl.a
OLD_FILES+=usr/lib/libperl.so
OLD_FILES+=usr/lib/libperl_p.a
OLD_FILES+=usr/lib/libposix1e.a
OLD_FILES+=usr/lib/libposix1e.so
OLD_FILES+=usr/lib/libposix1e_p.a
OLD_FILES+=usr/lib/libskey.a
OLD_FILES+=usr/lib/libskey.so
OLD_FILES+=usr/lib/libskey_p.a
OLD_FILES+=usr/libexec/tradcpp0
OLD_FILES+=usr/libexec/cpp0
# 200304XX: removal of xten
OLD_FILES+=usr/libexec/xtend
OLD_FILES+=usr/sbin/xten
OLD_FILES+=usr/share/man/man1/xten.1.gz
OLD_FILES+=usr/share/man/man8/xtend.8.gz
# 200303XX
OLD_FILES+=usr/lib/libacl.so
OLD_FILES+=usr/lib/libdescrypt.so
OLD_FILES+=usr/lib/libf2c.so
OLD_FILES+=usr/lib/libg++.so
OLD_FILES+=usr/lib/libkdb.so
OLD_FILES+=usr/lib/librsaINTL.so
OLD_FILES+=usr/lib/libscrypt.so
OLD_FILES+=usr/lib/libss.so
# 200302XX
OLD_FILES+=usr/lib/libacl.a
OLD_FILES+=usr/lib/libacl_p.a
OLD_FILES+=usr/lib/libkadm.a
OLD_FILES+=usr/lib/libkadm.so
OLD_FILES+=usr/lib/libkadm_p.a
OLD_FILES+=usr/lib/libkafs.a
OLD_FILES+=usr/lib/libkafs.so
OLD_FILES+=usr/lib/libkafs_p.a
OLD_FILES+=usr/lib/libkdb.a
OLD_FILES+=usr/lib/libkdb_p.a
OLD_FILES+=usr/lib/libkrb.a
OLD_FILES+=usr/lib/libkrb.so
OLD_FILES+=usr/lib/libkrb_p.a
OLD_FILES+=usr/share/man/man3/SSL_CIPHER_get_name.3.gz
OLD_FILES+=usr/share/man/man3/SSL_COMP_add_compression_method.3
OLD_FILES+=usr/share/man/man3/SSL_CTX_add_extra_chain_cert.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_add_session.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_ctrl.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_flush_sessions.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_free.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_get_verify_mode.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_load_verify_locations.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_new.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_sess_number.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_sess_set_cache_size.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_sess_set_get_cb.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_sessions.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_set_cert_store.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_set_cert_verify_callback.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_set_cipher_list.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_set_client_CA_list.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_set_client_cert_cb.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_set_default_passwd_cb.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_set_generate_session_id.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_set_info_callback.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_set_max_cert_list.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_set_mode.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_set_msg_callback.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_set_options.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_set_quiet_shutdown.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_set_session_cache_mode.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_set_session_id_context.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_set_ssl_version.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_set_timeout.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_set_tmp_dh_callback.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_set_tmp_rsa_callback.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_set_verify.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_use_certificate.3.gz
OLD_FILES+=usr/share/man/man3/SSL_SESSION_free.3.gz
OLD_FILES+=usr/share/man/man3/SSL_SESSION_get_ex_new_index.3.gz
OLD_FILES+=usr/share/man/man3/SSL_SESSION_get_time.3.gz
OLD_FILES+=usr/share/man/man3/SSL_accept.3.gz
OLD_FILES+=usr/share/man/man3/SSL_alert_type_string.3.gz
OLD_FILES+=usr/share/man/man3/SSL_clear.3.gz
OLD_FILES+=usr/share/man/man3/SSL_connect.3.gz
OLD_FILES+=usr/share/man/man3/SSL_do_handshake.3.gz
OLD_FILES+=usr/share/man/man3/SSL_free.3.gz
OLD_FILES+=usr/share/man/man3/SSL_get_SSL_CTX.3.gz
OLD_FILES+=usr/share/man/man3/SSL_get_ciphers.3.gz
OLD_FILES+=usr/share/man/man3/SSL_get_client_CA_list.3.gz
OLD_FILES+=usr/share/man/man3/SSL_get_current_cipher.3.gz
OLD_FILES+=usr/share/man/man3/SSL_get_default_timeout.3.gz
OLD_FILES+=usr/share/man/man3/SSL_get_error.3.gz
OLD_FILES+=usr/share/man/man3/SSL_get_ex_data_X509_STORE_CTX_idx.3.gz
OLD_FILES+=usr/share/man/man3/SSL_get_ex_new_index.3.gz
OLD_FILES+=usr/share/man/man3/SSL_get_fd.3.gz
OLD_FILES+=usr/share/man/man3/SSL_get_peer_cert_chain.3.gz
OLD_FILES+=usr/share/man/man3/SSL_get_peer_certificate.3.gz
OLD_FILES+=usr/share/man/man3/SSL_get_rbio.3.gz
OLD_FILES+=usr/share/man/man3/SSL_get_session.3.gz
OLD_FILES+=usr/share/man/man3/SSL_get_verify_result.3.gz
OLD_FILES+=usr/share/man/man3/SSL_get_version.3.gz
OLD_FILES+=usr/share/man/man3/SSL_library_init.3.gz
OLD_FILES+=usr/share/man/man3/SSL_load_client_CA_file.3.gz
OLD_FILES+=usr/share/man/man3/SSL_new.3.gz
OLD_FILES+=usr/share/man/man3/SSL_pending.3.gz
OLD_FILES+=usr/share/man/man3/SSL_read.3.gz
OLD_FILES+=usr/share/man/man3/SSL_rstate_string.3.gz
OLD_FILES+=usr/share/man/man3/SSL_session_reused.3.gz
OLD_FILES+=usr/share/man/man3/SSL_set_bio.3.gz
OLD_FILES+=usr/share/man/man3/SSL_set_connect_state.3.gz
OLD_FILES+=usr/share/man/man3/SSL_set_fd.3.gz
OLD_FILES+=usr/share/man/man3/SSL_set_session.3.gz
OLD_FILES+=usr/share/man/man3/SSL_set_shutdown.3.gz
OLD_FILES+=usr/share/man/man3/SSL_set_verify_result.3.gz
OLD_FILES+=usr/share/man/man3/SSL_shutdown.3.gz
OLD_FILES+=usr/share/man/man3/SSL_state_string.3.gz
OLD_FILES+=usr/share/man/man3/SSL_want.3.gz
OLD_FILES+=usr/share/man/man3/SSL_write.3.gz
OLD_FILES+=usr/share/man/man3/d2i_SSL_SESSION.3.gz
# 200301XX
OLD_FILES+=usr/share/man/man3/des_3cbc_encrypt.3.gz
OLD_FILES+=usr/share/man/man3/des_3ecb_encrypt.3.gz
OLD_FILES+=usr/share/man/man3/des_cbc_cksum.3.gz
OLD_FILES+=usr/share/man/man3/des_cbc_encrypt.3.gz
OLD_FILES+=usr/share/man/man3/des_cfb_encrypt.3.gz
OLD_FILES+=usr/share/man/man3/des_ecb_encrypt.3.gz
OLD_FILES+=usr/share/man/man3/des_enc_read.3.gz
OLD_FILES+=usr/share/man/man3/des_enc_write.3.gz
OLD_FILES+=usr/share/man/man3/des_is_weak_key.3.gz
OLD_FILES+=usr/share/man/man3/des_key_sched.3.gz
OLD_FILES+=usr/share/man/man3/des_ofb_encrypt.3.gz
OLD_FILES+=usr/share/man/man3/des_pcbc_encrypt.3.gz
OLD_FILES+=usr/share/man/man3/des_quad_cksum.3.gz
OLD_FILES+=usr/share/man/man3/des_random_key.3.gz
OLD_FILES+=usr/share/man/man3/des_read_2password.3.gz
OLD_FILES+=usr/share/man/man3/des_read_password.3.gz
OLD_FILES+=usr/share/man/man3/des_read_pw_string.3.gz
OLD_FILES+=usr/share/man/man3/des_set_key.3.gz
OLD_FILES+=usr/share/man/man3/des_set_odd_parity.3.gz
OLD_FILES+=usr/share/man/man3/des_string_to_2key.3.gz
OLD_FILES+=usr/share/man/man3/des_string_to_key.3.gz
# 200212XX
OLD_FILES+=usr/sbin/kenv
OLD_FILES+=usr/bin/kenv
OLD_FILES+=usr/sbin/elf2aout
# 200210XX
OLD_FILES+=usr/include/libusbhid.h
OLD_FILES+=usr/share/man/man3/All_FreeBSD.3.gz
OLD_FILES+=usr/share/man/man3/CheckRules.3.gz
OLD_FILES+=usr/share/man/man3/ChunkCanBeRoot.3.gz
OLD_FILES+=usr/share/man/man3/Clone_Disk.3.gz
OLD_FILES+=usr/share/man/man3/Collapse_Chunk.3.gz
OLD_FILES+=usr/share/man/man3/Collapse_Disk.3.gz
OLD_FILES+=usr/share/man/man3/Create_Chunk.3.gz
OLD_FILES+=usr/share/man/man3/Create_Chunk_DWIM.3.gz
OLD_FILES+=usr/share/man/man3/Cyl_Aligned.3.gz
OLD_FILES+=usr/share/man/man3/Debug_Disk.3.gz
OLD_FILES+=usr/share/man/man3/Delete_Chunk.3.gz
OLD_FILES+=usr/share/man/man3/Disk_Names.3.gz
OLD_FILES+=usr/share/man/man3/Free_Disk.3.gz
OLD_FILES+=usr/share/man/man3/MakeDev.3.gz
OLD_FILES+=usr/share/man/man3/MakeDevDisk.3.gz
OLD_FILES+=usr/share/man/man3/Next_Cyl_Aligned.3.gz
OLD_FILES+=usr/share/man/man3/Next_Track_Aligned.3.gz
OLD_FILES+=usr/share/man/man3/Open_Disk.3.gz
OLD_FILES+=usr/share/man/man3/Prev_Cyl_Aligned.3.gz
OLD_FILES+=usr/share/man/man3/Prev_Track_Aligned.3.gz
OLD_FILES+=usr/share/man/man3/Set_Bios_Geom.3.gz
OLD_FILES+=usr/share/man/man3/Set_Boot_Blocks.3.gz
OLD_FILES+=usr/share/man/man3/Set_Boot_Mgr.3.gz
OLD_FILES+=usr/share/man/man3/ShowChunkFlags.3.gz
OLD_FILES+=usr/share/man/man3/Track_Aligned.3.gz
OLD_FILES+=usr/share/man/man3/Write_Disk.3.gz
OLD_FILES+=usr/share/man/man3/slice_type_name.3.gz
# 200210XX: most games moved to ports
OLD_FILES+=usr/share/man/man6/adventure.6.gz
OLD_FILES+=usr/share/man/man6/arithmetic.6.gz
OLD_FILES+=usr/share/man/man6/atc.6.gz
OLD_FILES+=usr/share/man/man6/backgammon.6.gz
OLD_FILES+=usr/share/man/man6/battlestar.6.gz
OLD_FILES+=usr/share/man/man6/bs.6.gz
OLD_FILES+=usr/share/man/man6/canfield.6.gz
OLD_FILES+=usr/share/man/man6/cfscores.6.gz
OLD_FILES+=usr/share/man/man6/cribbage.6.gz
OLD_FILES+=usr/share/man/man6/fish.6.gz
OLD_FILES+=usr/share/man/man6/hack.6.gz
OLD_FILES+=usr/share/man/man6/hangman.6.gz
OLD_FILES+=usr/share/man/man6/larn.6.gz
OLD_FILES+=usr/share/man/man6/mille.6.gz
OLD_FILES+=usr/share/man/man6/phantasia.6.gz
OLD_FILES+=usr/share/man/man6/piano.6.gz
OLD_FILES+=usr/share/man/man6/pig.6.gz
OLD_FILES+=usr/share/man/man6/quiz.6.gz
OLD_FILES+=usr/share/man/man6/rain.6.gz
OLD_FILES+=usr/share/man/man6/robots.6.gz
OLD_FILES+=usr/share/man/man6/rogue.6.gz
OLD_FILES+=usr/share/man/man6/sail.6.gz
OLD_FILES+=usr/share/man/man6/snake.6.gz
OLD_FILES+=usr/share/man/man6/snscore.6.gz
OLD_FILES+=usr/share/man/man6/trek.6.gz
OLD_FILES+=usr/share/man/man6/wargames.6.gz
OLD_FILES+=usr/share/man/man6/worm.6.gz
OLD_FILES+=usr/share/man/man6/worms.6.gz
OLD_FILES+=usr/share/man/man6/wump.6.gz
# 200207XX
OLD_FILES+=usr/share/man/man1aout/ar.1aout.gz
OLD_FILES+=usr/share/man/man1aout/as.1aout.gz
OLD_FILES+=usr/share/man/man1aout/ld.1aout.gz
OLD_FILES+=usr/share/man/man1aout/nm.1aout.gz
OLD_FILES+=usr/share/man/man1aout/ranlib.1aout.gz
OLD_FILES+=usr/share/man/man1aout/size.1aout.gz
OLD_FILES+=usr/share/man/man1aout/strings.1aout.gz
OLD_FILES+=usr/share/man/man1aout/strip.1aout.gz
OLD_FILES+=bin/mountd
OLD_FILES+=bin/nfsd
# 20020707 sbin/nfsd -> usr.sbin/nfsd
OLD_FILES+=sbin/nfsd
# 200206XX
OLD_FILES+=usr/lib/libpam_ssh.a
OLD_FILES+=usr/lib/libpam_ssh_p.a
OLD_FILES+=usr/bin/help
OLD_FILES+=usr/bin/sccs
.if ${TARGET_ARCH} != "amd64" && ${TARGET} != "arm" && ${TARGET_ARCH} != "i386" && ${TARGET} != "powerpc"
OLD_FILES+=usr/bin/gdbserver
.endif
OLD_FILES+=usr/bin/ssh-keysign
OLD_FILES+=usr/sbin/gifconfig
OLD_FILES+=usr/sbin/prefix
# 200205XX
OLD_FILES+=usr/bin/doscmd
# 200204XX
OLD_FILES+=usr/bin/a2p
OLD_FILES+=usr/bin/ptx
OLD_FILES+=usr/bin/pod2text
OLD_FILES+=usr/bin/pod2man
OLD_FILES+=usr/bin/pod2latex
OLD_FILES+=usr/bin/pod2html
OLD_FILES+=usr/bin/h2ph
OLD_FILES+=usr/bin/dprofpp
OLD_FILES+=usr/bin/c2ph
OLD_FILES+=usr/bin/h2xs
OLD_FILES+=usr/bin/pl2pm
OLD_FILES+=usr/bin/splain
OLD_FILES+=usr/bin/s2p
OLD_FILES+=usr/bin/find2perl
OLD_FILES+=usr/sbin/pkg_update
OLD_FILES+=usr/sbin/scriptdump
# 20020409 GC kget(1), userconfig is long dead.
OLD_FILES+=sbin/kget
OLD_FILES+=usr/share/man/man8/kget.8.gz
# 200203XX
OLD_FILES+=usr/lib/libss.a
OLD_FILES+=usr/lib/libss_p.a
OLD_FILES+=usr/lib/libtelnet.a
OLD_FILES+=usr/lib/libtelnet_p.a
OLD_FILES+=usr/sbin/diskpart
# 200202XX
OLD_FILES+=usr/bin/gprof4
# 200201XX
OLD_FILES+=usr/sbin/linux
# 2001XXXX
OLD_FILES+=usr/bin/joy
OLD_FILES+=usr/sbin/ibcs2
OLD_FILES+=usr/sbin/svr4
OLD_FILES+=usr/bin/chflags
OLD_FILES+=usr/sbin/uuconv
OLD_FILES+=usr/sbin/uuchk
OLD_FILES+=usr/sbin/portmap
OLD_FILES+=usr/sbin/pmap_set
OLD_FILES+=usr/sbin/pmap_dump
OLD_FILES+=usr/sbin/mcon
OLD_FILES+=usr/sbin/stlstty
OLD_FILES+=usr/sbin/ispppcontrol
OLD_FILES+=usr/sbin/rndcontrol
# 20011001: UUCP migration to ports
OLD_FILES+=usr/bin/uucp
OLD_FILES+=usr/bin/uulog
OLD_FILES+=usr/bin/uuname
OLD_FILES+=usr/bin/uupick
OLD_FILES+=usr/bin/uusched
OLD_FILES+=usr/bin/uustat
OLD_FILES+=usr/bin/uuto
OLD_FILES+=usr/bin/uux
OLD_FILES+=usr/libexec/uucp/uucico
OLD_FILES+=usr/libexec/uucp/uuxqt
OLD_FILES+=usr/libexec/uucpd
OLD_FILES+=usr/share/man/man1/uuconv.1.gz
OLD_FILES+=usr/share/man/man1/uucp.1.gz
OLD_FILES+=usr/share/man/man1/uulog.1.gz
OLD_FILES+=usr/share/man/man1/uuname.1.gz
OLD_FILES+=usr/share/man/man1/uupick.1.gz
OLD_FILES+=usr/share/man/man1/uustat.1.gz
OLD_FILES+=usr/share/man/man1/uuto.1.gz
OLD_FILES+=usr/share/man/man1/uux.1.gz
OLD_FILES+=usr/share/man/man8/uuchk.8.gz
OLD_FILES+=usr/share/man/man8/uucico.8.gz
OLD_FILES+=usr/share/man/man8/uucpd.8.gz
OLD_FILES+=usr/share/man/man8/uusched.8.gz
OLD_FILES+=usr/share/man/man8/uuxqt.8.gz
# 20010523 mount_portal -> mount_portalfs
OLD_FILES+=sbin/mount_portal
OLD_FILES+=usr/share/man/man8/mount_portal.8.gz
# 200104XX
OLD_FILES+=usr/lib/libdescrypt.a
OLD_FILES+=usr/lib/libscrypt.a
OLD_FILES+=usr/lib/libscrypt_p.a
OLD_FILES+=usr/sbin/pim6stat
OLD_FILES+=usr/sbin/pim6sd
OLD_FILES+=usr/sbin/pim6dd
# 20010217
OLD_FILES+=usr/share/doc/bind/misc/dns-setup
# 20001200
OLD_FILES+=usr/lib/libgcc_r_pic.a
# 200009XX
OLD_FILES+=usr/lib/libRSAglue.a
OLD_FILES+=usr/lib/libRSAglue.so
OLD_FILES+=usr/lib/librsaINTL.a
OLD_FILES+=usr/lib/librsaUSA.a
OLD_FILES+=usr/lib/librsaUSA.so
# 200002XX ?
OLD_FILES+=usr/lib/libf2c.a
OLD_FILES+=usr/lib/libf2c_p.a
OLD_FILES+=usr/lib/libg++.a
OLD_FILES+=usr/lib/libg++_p.a
# 20001006
OLD_FILES+=usr/bin/miniperl
# 20000810
OLD_FILES+=usr/bin/sperl
# 200001XX
OLD_FILES+=usr/sbin/apmconf
# 199911XX
OLD_FILES+=usr/sbin/ipfstat
OLD_FILES+=usr/sbin/ipmon
OLD_FILES+=usr/sbin/ipnat
OLD_FILES+=usr/sbin/bad144
OLD_FILES+=usr/sbin/wormcontrol
OLD_FILES+=usr/sbin/named-bootconf
OLD_FILES+=usr/sbin/kvm_mkdb
OLD_FILES+=usr/sbin/keyadmin
# 199909XX
OLD_FILES+=usr/lib/libdesrypt_p.a
OLD_FILES+=sbin/ft
# 199903XX
OLD_FILES+=sbin/modload
OLD_FILES+=sbin/modunload
OLD_FILES+=usr/sbin/natd
# 199812XX
OLD_FILES+=sbin/dset
# 199809XX
OLD_FILES+=sbin/scsi
OLD_FILES+=sbin/scsiformat
OLD_FILES+=usr/sbin/ncrcontrol
OLD_FILES+=usr/sbin/tickadj
# 199806XX
OLD_FILES+=usr/sbin/mkdosfs
# 199801XX
OLD_FILES+=sbin/mount_lfs
OLD_FILES+=sbin/newlfs
OLD_FILES+=sbin/dumplfs
OLD_FILES+=usr/sbin/qcamcontrol
OLD_FILES+=usr/sbin/supscan
# 1997XXXX
OLD_FILES+=usr/sbin/sysctl
OLD_FILES+=usr/sbin/ctm_scan
OLD_FILES+=usr/sbin/addgroup
OLD_FILES+=usr/sbin/rmgroup
# 1996XXXX
OLD_FILES+=sbin/rdisc
OLD_FILES+=usr/sbin/cdplay
OLD_FILES+=usr/sbin/supfilesrv
OLD_FILES+=usr/sbin/routed
OLD_FILES+=usr/sbin/lsdev
OLD_FILES+=usr/sbin/yppasswdd
## unsorted
# do we still support aout builds?
#OLD_FILES+=usr/lib/aout/c++rt0.o
#OLD_FILES+=usr/lib/aout/crt0.o
#OLD_FILES+=usr/lib/aout/gcrt0.o
#OLD_FILES+=usr/lib/aout/scrt0.o
#OLD_FILES+=usr/lib/aout/sgcrt0.o
OLD_FILES+=usr/bin/sperl5
OLD_FILES+=usr/bin/perl5.6.0
OLD_FILES+=usr/bin/sperl5.6.0
OLD_FILES+=usr/bin/perlbc
OLD_FILES+=usr/bin/perl5.00503
OLD_FILES+=usr/bin/sperl5.00503
OLD_FILES+=usr/bin/perlbug
OLD_FILES+=usr/bin/perlcc
OLD_FILES+=usr/bin/perldoc
OLD_FILES+=usr/bin/suidperl
OLD_FILES+=usr/lib/pam_ftp.so
OLD_FILES+=usr/libdata/perl/5.00503/CGI/Apache.pm
OLD_FILES+=usr/libdata/perl/5.00503/CGI/Carp.pm
OLD_FILES+=usr/libdata/perl/5.00503/CGI/Cookie.pm
OLD_FILES+=usr/libdata/perl/5.00503/CGI/Fast.pm
OLD_FILES+=usr/libdata/perl/5.00503/CGI/Push.pm
OLD_FILES+=usr/libdata/perl/5.00503/CGI/Switch.pm
OLD_FILES+=usr/libdata/perl/5.00503/CPAN/FirstTime.pm
OLD_FILES+=usr/libdata/perl/5.00503/CPAN/Nox.pm
OLD_FILES+=usr/libdata/perl/5.00503/Class/Struct.pm
OLD_FILES+=usr/libdata/perl/5.00503/Devel/SelfStubber.pm
OLD_FILES+=usr/libdata/perl/5.00503/ExtUtils/Command.pm
OLD_FILES+=usr/libdata/perl/5.00503/ExtUtils/Embed.pm
OLD_FILES+=usr/libdata/perl/5.00503/ExtUtils/Install.pm
OLD_FILES+=usr/libdata/perl/5.00503/ExtUtils/Installed.pm
OLD_FILES+=usr/libdata/perl/5.00503/ExtUtils/Liblist.pm
OLD_FILES+=usr/libdata/perl/5.00503/ExtUtils/MM_OS2.pm
OLD_FILES+=usr/libdata/perl/5.00503/ExtUtils/MM_Unix.pm
OLD_FILES+=usr/libdata/perl/5.00503/ExtUtils/MM_VMS.pm
OLD_FILES+=usr/libdata/perl/5.00503/ExtUtils/MM_Win32.pm
OLD_FILES+=usr/libdata/perl/5.00503/ExtUtils/MakeMaker.pm
OLD_FILES+=usr/libdata/perl/5.00503/ExtUtils/Manifest.pm
OLD_FILES+=usr/libdata/perl/5.00503/ExtUtils/Mkbootstrap.pm
OLD_FILES+=usr/libdata/perl/5.00503/ExtUtils/Mksymlists.pm
OLD_FILES+=usr/libdata/perl/5.00503/ExtUtils/Packlist.pm
OLD_FILES+=usr/libdata/perl/5.00503/ExtUtils/inst
OLD_FILES+=usr/libdata/perl/5.00503/ExtUtils/testlib.pm
OLD_FILES+=usr/libdata/perl/5.00503/ExtUtils/typemap
OLD_FILES+=usr/libdata/perl/5.00503/ExtUtils/xsubpp
OLD_FILES+=usr/libdata/perl/5.00503/File/Spec/Mac.pm
OLD_FILES+=usr/libdata/perl/5.00503/File/Spec/OS2.pm
OLD_FILES+=usr/libdata/perl/5.00503/File/Spec/Unix.pm
OLD_FILES+=usr/libdata/perl/5.00503/File/Spec/VMS.pm
OLD_FILES+=usr/libdata/perl/5.00503/File/Spec/Win32.pm
OLD_FILES+=usr/libdata/perl/5.00503/File/Basename.pm
OLD_FILES+=usr/libdata/perl/5.00503/File/CheckTree.pm
OLD_FILES+=usr/libdata/perl/5.00503/File/Compare.pm
OLD_FILES+=usr/libdata/perl/5.00503/File/Copy.pm
OLD_FILES+=usr/libdata/perl/5.00503/File/DosGlob.pm
OLD_FILES+=usr/libdata/perl/5.00503/File/Find.pm
OLD_FILES+=usr/libdata/perl/5.00503/File/Path.pm
OLD_FILES+=usr/libdata/perl/5.00503/File/Spec.pm
OLD_FILES+=usr/libdata/perl/5.00503/File/stat.pm
OLD_FILES+=usr/libdata/perl/5.00503/Getopt/Long.pm
OLD_FILES+=usr/libdata/perl/5.00503/Getopt/Std.pm
OLD_FILES+=usr/libdata/perl/5.00503/I18N/Collate.pm
OLD_FILES+=usr/libdata/perl/5.00503/IPC/Open2.pm
OLD_FILES+=usr/libdata/perl/5.00503/IPC/Open3.pm
OLD_FILES+=usr/libdata/perl/5.00503/Math/BigFloat.pm
OLD_FILES+=usr/libdata/perl/5.00503/Math/BigInt.pm
OLD_FILES+=usr/libdata/perl/5.00503/Math/Complex.pm
OLD_FILES+=usr/libdata/perl/5.00503/Math/Trig.pm
OLD_FILES+=usr/libdata/perl/5.00503/Net/Ping.pm
OLD_FILES+=usr/libdata/perl/5.00503/Net/hostent.pm
OLD_FILES+=usr/libdata/perl/5.00503/Net/netent.pm
OLD_FILES+=usr/libdata/perl/5.00503/Net/protoent.pm
OLD_FILES+=usr/libdata/perl/5.00503/Net/servent.pm
OLD_FILES+=usr/libdata/perl/5.00503/Pod/Functions.pm
OLD_FILES+=usr/libdata/perl/5.00503/Pod/Html.pm
OLD_FILES+=usr/libdata/perl/5.00503/Pod/Text.pm
OLD_FILES+=usr/libdata/perl/5.00503/Search/Dict.pm
OLD_FILES+=usr/libdata/perl/5.00503/Sys/Hostname.pm
OLD_FILES+=usr/libdata/perl/5.00503/Sys/Syslog.pm
OLD_FILES+=usr/libdata/perl/5.00503/Term/Cap.pm
OLD_FILES+=usr/libdata/perl/5.00503/Term/Complete.pm
OLD_FILES+=usr/libdata/perl/5.00503/Term/ReadLine.pm
OLD_FILES+=usr/libdata/perl/5.00503/Test/Harness.pm
OLD_FILES+=usr/libdata/perl/5.00503/Text/Abbrev.pm
OLD_FILES+=usr/libdata/perl/5.00503/Text/ParseWords.pm
OLD_FILES+=usr/libdata/perl/5.00503/Text/Soundex.pm
OLD_FILES+=usr/libdata/perl/5.00503/Text/Tabs.pm
OLD_FILES+=usr/libdata/perl/5.00503/Text/Wrap.pm
OLD_FILES+=usr/libdata/perl/5.00503/Tie/Array.pm
OLD_FILES+=usr/libdata/perl/5.00503/Tie/Handle.pm
OLD_FILES+=usr/libdata/perl/5.00503/Tie/Hash.pm
OLD_FILES+=usr/libdata/perl/5.00503/Tie/RefHash.pm
OLD_FILES+=usr/libdata/perl/5.00503/Tie/Scalar.pm
OLD_FILES+=usr/libdata/perl/5.00503/Tie/SubstrHash.pm
OLD_FILES+=usr/libdata/perl/5.00503/Time/Local.pm
OLD_FILES+=usr/libdata/perl/5.00503/Time/gmtime.pm
OLD_FILES+=usr/libdata/perl/5.00503/Time/localtime.pm
OLD_FILES+=usr/libdata/perl/5.00503/Time/tm.pm
OLD_FILES+=usr/libdata/perl/5.00503/User/grent.pm
OLD_FILES+=usr/libdata/perl/5.00503/User/pwent.pm
OLD_FILES+=usr/libdata/perl/5.00503/auto/Getopt/Long/GetOptions.al
OLD_FILES+=usr/libdata/perl/5.00503/auto/Getopt/Long/FindOption.al
OLD_FILES+=usr/libdata/perl/5.00503/auto/Getopt/Long/Configure.al
OLD_FILES+=usr/libdata/perl/5.00503/auto/Getopt/Long/config.al
OLD_FILES+=usr/libdata/perl/5.00503/auto/Getopt/Long/Croak.al
OLD_FILES+=usr/libdata/perl/5.00503/auto/Getopt/Long/autosplit.ix
OLD_FILES+=usr/libdata/perl/5.00503/mach/B/Deparse.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/B/CC.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/B/Debug.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/B/Showlex.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/B/makeliblinks
OLD_FILES+=usr/libdata/perl/5.00503/mach/B/Bblock.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/B/cc_harness
OLD_FILES+=usr/libdata/perl/5.00503/mach/B/Bytecode.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/B/Stackobj.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/B/Xref.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/B/Lint.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/B/Asmdata.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/B/Assembler.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/B/Disassembler.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/B/disassemble
OLD_FILES+=usr/libdata/perl/5.00503/mach/B/assemble
OLD_FILES+=usr/libdata/perl/5.00503/mach/B/Terse.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/B/C.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/EXTERN.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/INTERN.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/XSUB.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/XSlock.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/av.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/bytecode.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/byterun.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/cc_runtime.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/config.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/cop.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/cv.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/dosish.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/embed.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/embedvar.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/fakethr.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/form.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/gv.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/handy.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/hv.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/intrpvar.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/iperlsys.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/keywords.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/mg.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/nostdio.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/objXSUB.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/objpp.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/op.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/opcode.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/patchlevel.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/perl.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/perlio.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/perlsdio.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/perlsfio.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/perlvars.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/perly.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/pp.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/pp_proto.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/proto.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/regcomp.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/regexp.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/regnodes.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/scope.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/sv.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/thrdvar.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/thread.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/unixish.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/CORE/util.h
OLD_FILES+=usr/libdata/perl/5.00503/mach/Data/Dumper.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/IO/File.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/IO/Select.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/IO/Socket.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/IO/Handle.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/IO/Seekable.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/IO/Pipe.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/IPC/SysV.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/IPC/Msg.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/IPC/Semaphore.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/B/B.so
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/B/B.bs
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/B/.packlist
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/DB_File/autosplit.ix
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/DB_File/DB_File.so
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/DB_File/DB_File.bs
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/DB_File/.packlist
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/Data/Dumper/Dumper.so
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/Data/Dumper/Dumper.bs
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/Data/Dumper/.packlist
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/DynaLoader/.exists
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/DynaLoader/dl_findfile.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/DynaLoader/dl_expandspec.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/DynaLoader/dl_find_symbol_anywhere.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/DynaLoader/autosplit.ix
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/DynaLoader/DynaLoader.a
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/DynaLoader/extralibs.ld
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/Fcntl/Fcntl.so
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/Fcntl/Fcntl.bs
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/Fcntl/.packlist
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/IO/IO.so
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/IO/IO.bs
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/IO/.packlist
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/IPC/SysV/SysV.so
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/IPC/SysV/SysV.bs
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/IPC/SysV/.packlist
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/NDBM_File/NDBM_File.so
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/NDBM_File/NDBM_File.bs
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/NDBM_File/.packlist
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/Opcode/Opcode.so
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/Opcode/Opcode.bs
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/Opcode/.packlist
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/assert.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/tolower.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/toupper.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/closedir.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/opendir.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/readdir.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/rewinddir.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/errno.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/creat.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/fcntl.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/getgrgid.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/getgrnam.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/atan2.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/cos.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/exp.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/fabs.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/log.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/pow.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/sin.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/sqrt.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/getpwnam.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/getpwuid.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/longjmp.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/setjmp.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/kill.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/feof.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/siglongjmp.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/sigsetjmp.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/raise.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/offsetof.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/clearerr.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/fclose.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/fdopen.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/fgetc.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/fgets.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/fileno.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/fopen.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/fprintf.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/fputc.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/fputs.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/fread.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/freopen.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/fscanf.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/fseek.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/ferror.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/fflush.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/fgetpos.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/fsetpos.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/ftell.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/fwrite.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/getc.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/getchar.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/gets.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/perror.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/printf.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/putc.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/putchar.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/puts.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/remove.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/rename.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/rewind.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/scanf.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/sprintf.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/sscanf.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/tmpfile.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/ungetc.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/vfprintf.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/vprintf.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/vsprintf.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/abs.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/atexit.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/atof.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/atoi.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/atol.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/bsearch.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/calloc.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/div.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/exit.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/free.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/getenv.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/labs.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/ldiv.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/malloc.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/qsort.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/rand.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/realloc.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/srand.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/system.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/memchr.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/memcmp.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/memcpy.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/memmove.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/memset.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/strcat.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/strchr.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/strcmp.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/strcpy.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/strcspn.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/strerror.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/strlen.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/strncat.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/strncmp.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/strncpy.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/strpbrk.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/strrchr.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/strspn.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/strstr.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/strtok.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/chmod.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/fstat.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/mkdir.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/stat.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/umask.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/wait.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/waitpid.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/gmtime.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/localtime.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/time.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/alarm.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/chdir.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/chown.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/execl.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/execle.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/execlp.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/execv.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/execve.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/execvp.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/fork.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/getcwd.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/getegid.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/geteuid.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/getgid.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/getgroups.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/getlogin.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/getpgrp.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/getpid.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/getppid.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/getuid.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/isatty.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/link.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/rmdir.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/setbuf.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/setgid.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/setuid.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/setvbuf.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/sleep.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/unlink.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/utime.al
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/autosplit.ix
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/POSIX.so
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/POSIX.bs
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/POSIX/.packlist
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/SDBM_File/SDBM_File.so
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/SDBM_File/SDBM_File.bs
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/SDBM_File/.packlist
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/Socket/Socket.so
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/Socket/Socket.bs
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/Socket/.packlist
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/attrs/attrs.so
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/attrs/attrs.bs
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/attrs/.packlist
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/re/re.so
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/re/re.bs
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/re/.packlist
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/sdbm/extralibs.ld
OLD_FILES+=usr/libdata/perl/5.00503/mach/auto/Errno/.packlist
OLD_FILES+=usr/libdata/perl/5.00503/mach/Config.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/B.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/O.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/perllocal.pod
OLD_FILES+=usr/libdata/perl/5.00503/mach/DB_File.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/Errno.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/Fcntl.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/IO.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/NDBM_File.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/Safe.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/Opcode.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/ops.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/POSIX.pod
OLD_FILES+=usr/libdata/perl/5.00503/mach/POSIX.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/SDBM_File.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/Socket.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/attrs.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/re.pm
OLD_FILES+=usr/libdata/perl/5.00503/mach/_h2ph_pre.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/a.out.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/cam/cam.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/cam/cam_ccb.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/cam/cam_debug.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/cam/cam_extend.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/cam/cam_periph.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/cam/cam_queue.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/cam/cam_sim.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/cam/cam_xpt.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/cam/cam_xpt_periph.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/cam/cam_xpt_sim.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/aio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/alias.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/ar.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/assert.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/bitstring.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/calendar.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/camlib.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/com_err.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/com_right.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/ctype.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/curses.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/db.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/des.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/devstat.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/dialog.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/dirent.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/disktab.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/dlfcn.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/elf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/err.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/errno.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/eti.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/fcntl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/fetch.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/float.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/floatingpoint.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/fnmatch.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/form.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/fstab.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/ftpio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/fts.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/glob.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/gmp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/gnuregex.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/grp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/histedit.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/ieeefp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/ifaddrs.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/inttypes.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/iso646.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/kvm.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/libatm.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/libdisk.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/libgen.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/libusb.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/libutil.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/limits.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/link.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/linker_set.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/locale.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/login_cap.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/malloc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/FlexLexer.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/PlotFile.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/SFile.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/_G_config.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/algo.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/algobase.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/alloc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/builtinbuf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/bvector.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/complex.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/defalloc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/deque.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/editbuf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/floatio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/fstream.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/function.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/hash_map.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/hash_set.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/hashtable.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/heap.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/indstream.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/iolibio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/iomanip.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/list.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/iostdio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/iostream.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/iostreamP.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/istream.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/iterator.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/libio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/libioP.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/map.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/multimap.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/multiset.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/new.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/ostream.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/pair.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/parsestream.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/pfstream.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/procbuf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/pthread_alloc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/rope.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/ropeimpl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/set.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/slist.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stack.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stdiostream.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_algo.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/tree.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_algobase.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_alloc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_bvector.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_config.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_construct.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_deque.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_function.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_hash_fun.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_hash_map.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_hash_set.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_hashtable.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_heap.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_iterator.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_list.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_map.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_multimap.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_multiset.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_numeric.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_pair.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_queue.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_raw_storage_iter.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_relops.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_rope.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_set.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_slist.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_stack.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_tempbuf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_tree.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_uninitialized.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stl_vector.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/stream.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/streambuf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/strfile.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/strstream.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/tempbuf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/type_traits.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g++/vector.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/math.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/md2.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/md4.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/md5.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/memory.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/menu.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/mp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/mpool.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/mqueue.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/ncurses.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/ndbm.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netdb.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/nl_types.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/nlist.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/objformat.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/opie.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/osreldate.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/panel.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/paths.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/pcap-int.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/pcap-namedb.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/pcap.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/poll.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/pthread.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/pthread_np.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/pwd.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/radlib.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/ranlib.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/regex.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/regexp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/resolv.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/ripemd.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rune.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/runetype.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sched.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/search.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/semaphore.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/setjmp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sgtty.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sha.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/signal.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/skey.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/stab.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/stand.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/stdarg.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/stddef.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/stdio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/stdlib.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/strhash.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/string.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/stringlist.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/strings.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/struct.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sysexits.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/syslog.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/taclib.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/tar.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/tcpd.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/term.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/termcap.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/termios.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/time.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/timers.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/ttyent.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/ucontext.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/unctrl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/unistd.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/utime.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/utmp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/values.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/varargs.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/vgl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/vis.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/zconf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/zlib.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/arpa/ftp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/arpa/inet.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/arpa/nameser.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/arpa/nameser_compat.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/arpa/telnet.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/arpa/tftp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/isc/assertions.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/isc/ctl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/isc/dst.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/isc/eventlib.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/isc/heap.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/isc/irpmarshall.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/isc/logging.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/isc/memcluster.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/isc/misc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/isc/tree.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/isc/list.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/ansi.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/apic.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/apm_bios.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/apm_segments.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/asc_ioctl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/asm.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/asmacros.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/asnames.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/atomic.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/bootinfo.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/bus.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/bus_at386.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/bus_memio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/bus_pc98.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/bus_pio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/bus_pio_ind.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/cdk.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/clock.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/comstats.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/console.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/cpu.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/cpufunc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/cputypes.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/cronyx.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/db_machdep.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/dvcfg.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/elf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/endian.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/exec.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/float.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/floatingpoint.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/frame.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/globaldata.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/globals.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/gsc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/i4b_cause.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/i4b_debug.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/i4b_ioctl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/i4b_rbch_ioctl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/i4b_tel_ioctl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/i4b_trace.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/ieeefp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/if_wavelan_ieee.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/if_wl_wavelan.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/iic.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/in_cksum.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/ioctl_bt848.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/ioctl_ctx.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/ioctl_fd.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/ioctl_meteor.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/ipl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/joystick.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/limits.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/lock.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/md_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/mouse.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/mpapic.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/mtpr.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/bus_dma.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/npx.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/param.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/pcaudioio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/pcb.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/pcb_ext.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/pcvt_ioctl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/perfmon.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/physio_proc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/pmap.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/proc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/profile.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/psl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/ptrace.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/reg.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/reloc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/resource.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/segments.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/setjmp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/sigframe.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/signal.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/smb.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/smp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/smptests.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/soundcard.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/speaker.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/specialreg.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/spigot.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/stdarg.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/sysarch.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/trap.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/tss.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/types.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/uc_device.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/ucontext.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/ultrasound.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/varargs.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/vm86.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/vmparam.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/wtio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/i4b_isppp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/machine/pci_cfgreg.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/msdosfs/bootsect.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/msdosfs/bpb.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/msdosfs/denode.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/msdosfs/direntry.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/msdosfs/fat.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/msdosfs/msdosfsmount.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/bpf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/bpf_compat.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/bpfdesc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/bridge.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/ethernet.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/hostcache.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if_arp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if_atm.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if_dl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if_gif.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if_ieee80211.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if_llc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if_media.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if_mib.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if_ppp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if_pppvar.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if_slvar.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if_sppp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if_stf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if_tap.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if_tapvar.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if_tun.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/slip.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if_tunvar.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if_types.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if_vlan_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/intrq.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/iso88025.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/net_osdep.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/netisr.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/pfkeyv2.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/ppp_comp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/ppp_defs.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/radix.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/raw_cb.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/route.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/slcompress.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/zlib.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if_faith.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if_arc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/net/if_gre.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/nfs/krpc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/nfs/nfs.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/nfs/nfsdiskless.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/nfs/nfsm_subs.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/nfs/nfsmount.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/nfs/nfsnode.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/nfs/nfsproto.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/nfs/nfsrtt.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/nfs/nfsrvcache.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/nfs/nfsv2.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/nfs/nqnfs.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/nfs/rpcv2.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/nfs/xdr_subs.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netatalk/aarp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netatalk/at.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netatalk/at_extern.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netatalk/at_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netatalk/ddp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netatalk/ddp_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netatalk/endian.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netatalk/phase2.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netatm/atm.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netatm/atm_cm.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netatm/atm_if.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netatm/atm_ioctl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netatm/atm_pcb.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netatm/atm_sap.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netatm/atm_sigmgr.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netatm/atm_stack.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netatm/atm_sys.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netatm/atm_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netatm/atm_vc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netatm/kern_include.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netatm/port.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netatm/queue.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/netgraph.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_UI.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_async.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_bpf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_bridge.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_cisco.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_echo.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_ether.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_frame_relay.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_hole.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_iface.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_ksocket.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_lmi.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_message.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_mppc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_one2many.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_parse.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_ppp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_pppoe.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_pptpgre.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_rfc1490.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_sample.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_socket.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_socketvar.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_tee.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_tty.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_vjc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_eiface.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_etf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_device.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_l2tp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netgraph/ng_fec.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/icmp6.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/icmp_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/if_atm.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/if_ether.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/if_fddi.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/igmp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/igmp_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/in.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/in_gif.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/in_hostcache.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/in_pcb.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/in_systm.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/in_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/ip.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/ip6.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/ip_auth.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/ip_compat.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/ip_dummynet.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/ip_ecn.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/ip_encap.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/ip_fil.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/ip_flow.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/ip_frag.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/ip_fw.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/ip_icmp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/ip_mroute.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/ip_nat.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/ip_proxy.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/ip_state.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/ip_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/ipl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/ipprotosw.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/tcp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/tcp_debug.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/tcp_fsm.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/tcp_seq.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/tcp_timer.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/tcp_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/tcpip.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/udp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/udp_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/ip_fw2.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet/ip_gre.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/ah.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/ah6.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/esp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/esp6.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/icmp6.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/in6.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/in6_gif.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/in6_ifattach.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/in6_pcb.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/in6_prefix.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/in6_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/ip6.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/ip6_ecn.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/ip6_fw.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/ip6_mroute.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/ip6_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/ip6protosw.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/ipcomp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/ipcomp6.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/ipsec.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/ipsec6.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/mld6_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/nd6.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/pim6.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/pim6_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/scope6_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/tcp6_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/udp6_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/esp_rijndael.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netinet6/raw_ip6.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipx/ipx.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipx/ipx_if.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipx/ipx_ip.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipx/ipx_pcb.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipx/ipx_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipx/spx.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipx/spx_debug.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipx/spx_timer.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipx/spx_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netkey/key.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netkey/key_debug.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netkey/key_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netkey/keydb.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netkey/keysock.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netnatm/natm.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netncp/ncp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netncp/ncp_cfg.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netncp/ncp_conn.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netncp/ncp_file.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netncp/ncp_lib.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netncp/ncp_ncp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netncp/ncp_nls.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netncp/ncp_rcfile.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netncp/ncp_rq.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netncp/ncp_sock.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netncp/ncp_subr.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netncp/ncp_user.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netncp/nwerror.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netns/idp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netns/idp_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netns/ns.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netns/ns_error.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netns/ns_if.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netns/ns_pcb.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netns/sp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netns/spidp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netns/spp_debug.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netns/spp_timer.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netns/spp_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/ntfs/ntfs.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/ntfs/ntfs_compr.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/ntfs/ntfs_ihash.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/ntfs/ntfs_inode.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/ntfs/ntfs_subr.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/ntfs/ntfs_vfsops.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/ntfs/ntfsmount.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/nwfs/nwfs.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/nwfs/nwfs_mount.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/nwfs/nwfs_node.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/nwfs/nwfs_subr.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/objc/NXConstStr.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/objc/Object.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/objc/Protocol.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/objc/encoding.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/objc/hash.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/objc/objc-api.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/objc/objc-list.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/objc/objc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/objc/runtime.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/objc/sarray.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/objc/thr.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/objc/typedstream.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/asn1.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/asn1_mac.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/bio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/blowfish.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/bn.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/buffer.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/cast.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/comp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/conf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/conf_api.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/crypto.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/des.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/dh.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/dsa.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/dso.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/e_os.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/e_os2.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/ebcdic.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/err.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/evp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/hmac.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/lhash.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/md2.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/md4.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/md5.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/mdc2.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/obj_mac.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/objects.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/opensslconf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/opensslv.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/pem.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/pem2.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/pkcs12.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/pkcs7.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/rand.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/rc2.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/rc4.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/rc5.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/ripemd.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/rsa.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/safestack.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/sha.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/ssl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/ssl2.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/ssl23.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/ssl3.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/ssl_locl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/stack.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/symhacks.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/tls1.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/tmdiff.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/txt_db.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/x509.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/x509_vfy.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/x509v3.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/idea.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/aes.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/asn1t.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/cryptlib.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/des_old.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/ec.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/engine.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/krb5_asn.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/kssl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/ocsp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/ossl_typ.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/ui.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/ui_compat.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/aes_locl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/eng_int.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/hw_4758_cca_err.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/hw_aep_err.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/hw_atalla_err.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/hw_cswift_err.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/hw_ncipher_err.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/hw_nuron_err.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/hw_sureware_err.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/hw_ubsec_err.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/openssl/ui_locl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/pccard/cardinfo.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/pccard/cis.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/pccard/driver.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/pccard/i82365.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/pccard/pccard_nbk.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/pccard/slot.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/pccard/meciareg.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/pccard/pcic_pci.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/pccard/pcicvar.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/posix4/aio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/posix4/mqueue.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/posix4/posix4.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/posix4/sched.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/posix4/semaphore.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/protocols/dumprestore.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/protocols/routed.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/protocols/rwhod.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/protocols/talkd.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/protocols/timed.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/readline/chardefs.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/readline/history.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/readline/keymaps.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/readline/readline.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/readline/rlconf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/readline/rlstdc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/readline/tilde.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpc/auth.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpc/auth_des.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpc/auth_unix.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpc/clnt.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpc/des.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpc/des_crypt.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpc/key_prot.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpc/pmap_clnt.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpc/pmap_prot.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpc/pmap_rmt.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpc/rpc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpc/rpc_com.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpc/rpc_msg.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpc/svc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpc/svc_auth.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpc/types.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpc/xdr.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/bootparam_prot.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/crypt.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/key_prot.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/klm_prot.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/mount.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/nfs_prot.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/nis.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/nis_cache.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/nis_callback.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/nis_db.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/nis_tags.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/nislib.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/nlm_prot.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/rex.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/rnusers.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/rquota.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/rstat.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/rwall.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/sm_inter.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/spray.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/yp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/yp_prot.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/ypclnt.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/yppasswd.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/ypupdate_prot.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/rpcsvc/ypxfrd.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/security/_pam_compat.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/security/_pam_macros.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/security/_pam_types.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/security/pam_appl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/security/pam_malloc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/security/pam_misc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/security/pam_mod_misc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/security/pam_modules.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/ss/mit-sipb-copyright.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/ss/ss.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/ss/ss_err.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/_posix.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/ata.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/acct.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/acl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/agpio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/aio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/assym.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/blist.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/buf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/bus.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/bus_private.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/callout.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/ccdvar.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/cdefs.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/cdio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/cdrio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/chio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/clist.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/endian.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/conf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/cons.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/consio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/copyright.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/ctype.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/dir.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/dataacq.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/link_elf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/device_port.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/devicestat.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/dirent.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/disk.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/disklabel.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/diskslice.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/dkstat.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/dmap.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/domain.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/dvdio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/elf32.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/elf64.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/elf_common.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/elf_generic.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/errno.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/event.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/eventhandler.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/eventvar.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/exec.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/extattr.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/fbio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/fcntl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/file.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/filedesc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/filio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/gmon.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/imgact.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/imgact_aout.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/imgact_elf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/inflate.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/interrupt.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/inttypes.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/ioccom.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/ioctl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/ioctl_compat.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/ipc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/jail.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/joystick.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/kbio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/kernel.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/kthread.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/ktrace.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/libkern.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/linker.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/linker_set.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/lock.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/lockf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/malloc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/mbuf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/md5.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/memrange.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/mman.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/module.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/mount.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/msg.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/msgbuf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/mtio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/namei.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/param.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/pciio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/pioctl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/pipe.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/poll.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/proc.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/procfs.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/protosw.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/ptio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/ptrace.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/queue.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/random.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/reboot.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/resource.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/resourcevar.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/rman.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/rtprio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/sbuf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/select.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/sem.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/shm.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/signal.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/signalvar.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/snoop.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/socket.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/socketvar.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/sockio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/soundcard.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/stat.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/syscall-hide.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/syscall.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/sysctl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/sysent.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/syslimits.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/syslog.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/sysproto.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/systm.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/taskqueue.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/termios.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/time.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/timeb.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/timepps.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/timers.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/times.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/timex.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/tprintf.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/tty.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/ttychars.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/ttycom.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/ttydefaults.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/ttydev.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/types.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/ucontext.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/ucred.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/uio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/un.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/unistd.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/unpcb.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/user.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/utsname.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/vmmeter.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/vnioctl.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/vnode.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/wait.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/wormio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/xrpuio.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/kobj.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/link_aout.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/nlist_aout.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/mchain.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/fnv_hash.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/iconv.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/sys/md4.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/vm/pmap.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/vm/swap_pager.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/vm/vm.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/vm/vm_extern.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/vm/vm_kern.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/vm/vm_map.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/vm/vm_object.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/vm/vm_page.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/vm/vm_pageout.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/vm/vm_pager.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/vm/vm_param.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/vm/vm_zone.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/vm/vnode_pager.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/complex.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/stdbool.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/langinfo.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netsmb/netbios.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netsmb/smb.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netsmb/smb_conn.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netsmb/smb_dev.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netsmb/smb_rq.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netsmb/smb_subr.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netsmb/smb_tran.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netsmb/smb_trantcp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/g2c.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/telnet.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/elf-hints.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/libusbhid.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/radlib_vs.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/readpassphrase.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/wchar.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/wctype.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/crypto/cast.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/crypto/castsb.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/crypto/cryptodev.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/crypto/cryptosoft.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/crypto/deflate.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/crypto/rijndael.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/crypto/rmd160.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/crypto/skipjack.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/crypto/xform.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipsec/ah.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipsec/ah_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipsec/esp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipsec/esp_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipsec/ipcomp.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipsec/ipcomp_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipsec/ipip_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipsec/ipsec.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipsec/ipsec6.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipsec/key.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipsec/key_debug.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipsec/key_var.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipsec/keydb.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipsec/keysock.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/netipsec/xform.ph
OLD_FILES+=usr/libdata/perl/5.00503/mach/bzlib.ph
OLD_FILES+=usr/libdata/perl/5.00503/pod/perl.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perl5004delta.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlapio.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlbook.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlbot.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlcall.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perldata.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perldebug.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perldelta.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perldiag.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perldsc.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlembed.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlfaq.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlfaq1.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlfaq2.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlfaq3.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlfaq4.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlfaq5.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlfaq6.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlfaq7.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlipc.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlfaq8.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlfaq9.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlform.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlfunc.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlguts.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlhist.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perllocale.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perllol.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlmod.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlmodinstall.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlmodlib.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlobj.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlop.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlopentut.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlpod.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlport.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlre.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlref.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlreftut.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlrun.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlsec.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlstyle.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlsub.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlsyn.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlthrtut.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perltie.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perltoc.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perltoot.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perltrap.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlvar.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlxs.pod
OLD_FILES+=usr/libdata/perl/5.00503/pod/perlxstut.pod
OLD_FILES+=usr/libdata/perl/5.00503/AnyDBM_File.pm
OLD_FILES+=usr/libdata/perl/5.00503/AutoLoader.pm
OLD_FILES+=usr/libdata/perl/5.00503/AutoSplit.pm
OLD_FILES+=usr/libdata/perl/5.00503/Benchmark.pm
OLD_FILES+=usr/libdata/perl/5.00503/CGI.pm
OLD_FILES+=usr/libdata/perl/5.00503/CPAN.pm
OLD_FILES+=usr/libdata/perl/5.00503/Carp.pm
OLD_FILES+=usr/libdata/perl/5.00503/Cwd.pm
OLD_FILES+=usr/libdata/perl/5.00503/DirHandle.pm
OLD_FILES+=usr/libdata/perl/5.00503/Dumpvalue.pm
OLD_FILES+=usr/libdata/perl/5.00503/English.pm
OLD_FILES+=usr/libdata/perl/5.00503/Env.pm
OLD_FILES+=usr/libdata/perl/5.00503/Exporter.pm
OLD_FILES+=usr/libdata/perl/5.00503/Fatal.pm
OLD_FILES+=usr/libdata/perl/5.00503/FileCache.pm
OLD_FILES+=usr/libdata/perl/5.00503/FileHandle.pm
OLD_FILES+=usr/libdata/perl/5.00503/FindBin.pm
OLD_FILES+=usr/libdata/perl/5.00503/SelectSaver.pm
OLD_FILES+=usr/libdata/perl/5.00503/SelfLoader.pm
OLD_FILES+=usr/libdata/perl/5.00503/Shell.pm
OLD_FILES+=usr/libdata/perl/5.00503/Symbol.pm
OLD_FILES+=usr/libdata/perl/5.00503/Test.pm
OLD_FILES+=usr/libdata/perl/5.00503/abbrev.pl
OLD_FILES+=usr/libdata/perl/5.00503/UNIVERSAL.pm
OLD_FILES+=usr/libdata/perl/5.00503/assert.pl
OLD_FILES+=usr/libdata/perl/5.00503/autouse.pm
OLD_FILES+=usr/libdata/perl/5.00503/base.pm
OLD_FILES+=usr/libdata/perl/5.00503/bigfloat.pl
OLD_FILES+=usr/libdata/perl/5.00503/bigint.pl
OLD_FILES+=usr/libdata/perl/5.00503/bigrat.pl
OLD_FILES+=usr/libdata/perl/5.00503/blib.pm
OLD_FILES+=usr/libdata/perl/5.00503/cacheout.pl
OLD_FILES+=usr/libdata/perl/5.00503/chat2.pl
OLD_FILES+=usr/libdata/perl/5.00503/complete.pl
OLD_FILES+=usr/libdata/perl/5.00503/constant.pm
OLD_FILES+=usr/libdata/perl/5.00503/ctime.pl
OLD_FILES+=usr/libdata/perl/5.00503/diagnostics.pm
OLD_FILES+=usr/libdata/perl/5.00503/dotsh.pl
OLD_FILES+=usr/libdata/perl/5.00503/dumpvar.pl
OLD_FILES+=usr/libdata/perl/5.00503/exceptions.pl
OLD_FILES+=usr/libdata/perl/5.00503/fastcwd.pl
OLD_FILES+=usr/libdata/perl/5.00503/fields.pm
OLD_FILES+=usr/libdata/perl/5.00503/find.pl
OLD_FILES+=usr/libdata/perl/5.00503/finddepth.pl
OLD_FILES+=usr/libdata/perl/5.00503/flush.pl
OLD_FILES+=usr/libdata/perl/5.00503/ftp.pl
OLD_FILES+=usr/libdata/perl/5.00503/getcwd.pl
OLD_FILES+=usr/libdata/perl/5.00503/getopt.pl
OLD_FILES+=usr/libdata/perl/5.00503/getopts.pl
OLD_FILES+=usr/libdata/perl/5.00503/hostname.pl
OLD_FILES+=usr/libdata/perl/5.00503/importenv.pl
OLD_FILES+=usr/libdata/perl/5.00503/integer.pm
OLD_FILES+=usr/libdata/perl/5.00503/less.pm
OLD_FILES+=usr/libdata/perl/5.00503/lib.pm
OLD_FILES+=usr/libdata/perl/5.00503/locale.pm
OLD_FILES+=usr/libdata/perl/5.00503/look.pl
OLD_FILES+=usr/libdata/perl/5.00503/newgetopt.pl
OLD_FILES+=usr/libdata/perl/5.00503/open2.pl
OLD_FILES+=usr/libdata/perl/5.00503/open3.pl
OLD_FILES+=usr/libdata/perl/5.00503/overload.pm
OLD_FILES+=usr/libdata/perl/5.00503/perl5db.pl
OLD_FILES+=usr/libdata/perl/5.00503/pwd.pl
OLD_FILES+=usr/libdata/perl/5.00503/shellwords.pl
OLD_FILES+=usr/libdata/perl/5.00503/sigtrap.pm
OLD_FILES+=usr/libdata/perl/5.00503/stat.pl
OLD_FILES+=usr/libdata/perl/5.00503/strict.pm
OLD_FILES+=usr/libdata/perl/5.00503/subs.pm
OLD_FILES+=usr/libdata/perl/5.00503/syslog.pl
OLD_FILES+=usr/libdata/perl/5.00503/tainted.pl
OLD_FILES+=usr/libdata/perl/5.00503/termcap.pl
OLD_FILES+=usr/libdata/perl/5.00503/timelocal.pl
OLD_FILES+=usr/libdata/perl/5.00503/validate.pl
OLD_FILES+=usr/libdata/perl/5.00503/vars.pm
OLD_FILES+=usr/libdata/perl/5.00503/re.pm
OLD_FILES+=usr/libdata/perl/5.00503/Config.pm
OLD_FILES+=usr/libdata/perl/5.00503/.exists
OLD_FILES+=usr/libdata/perl/5.00503/DynaLoader.pm
OLD_FILES+=usr/share/perl/man/man3/AnyDBM_File.3.gz
OLD_FILES+=usr/share/perl/man/man3/AutoLoader.3.gz
OLD_FILES+=usr/share/perl/man/man3/AutoSplit.3.gz
OLD_FILES+=usr/share/perl/man/man3/B.3.gz
OLD_FILES+=usr/share/perl/man/man3/B::Asmdata.3.gz
OLD_FILES+=usr/share/perl/man/man3/B::Assembler.3.gz
OLD_FILES+=usr/share/perl/man/man3/B::Bblock.3.gz
OLD_FILES+=usr/share/perl/man/man3/B::Bytecode.3.gz
OLD_FILES+=usr/share/perl/man/man3/B::C.3.gz
OLD_FILES+=usr/share/perl/man/man3/B::CC.3.gz
OLD_FILES+=usr/share/perl/man/man3/B::Debug.3.gz
OLD_FILES+=usr/share/perl/man/man3/B::Deparse.3.gz
OLD_FILES+=usr/share/perl/man/man3/B::Disassembler.3.gz
OLD_FILES+=usr/share/perl/man/man3/B::Lint.3.gz
OLD_FILES+=usr/share/perl/man/man3/B::Showlex.3.gz
OLD_FILES+=usr/share/perl/man/man3/B::Stackobj.3.gz
OLD_FILES+=usr/share/perl/man/man3/B::Terse.3.gz
OLD_FILES+=usr/share/perl/man/man3/B::Xref.3.gz
OLD_FILES+=usr/share/perl/man/man3/Benchmark.3.gz
OLD_FILES+=usr/share/perl/man/man3/CGI.3.gz
OLD_FILES+=usr/share/perl/man/man3/CGI::Apache.3.gz
OLD_FILES+=usr/share/perl/man/man3/CGI::Carp.3.gz
OLD_FILES+=usr/share/perl/man/man3/CGI::Cookie.3.gz
OLD_FILES+=usr/share/perl/man/man3/CGI::Fast.3.gz
OLD_FILES+=usr/share/perl/man/man3/CGI::Push.3.gz
OLD_FILES+=usr/share/perl/man/man3/CGI::Switch.3.gz
OLD_FILES+=usr/share/perl/man/man3/CPAN.3.gz
OLD_FILES+=usr/share/perl/man/man3/CPAN::FirstTime.3.gz
OLD_FILES+=usr/share/perl/man/man3/CPAN::Nox.3.gz
OLD_FILES+=usr/share/perl/man/man3/Carp.3.gz
OLD_FILES+=usr/share/perl/man/man3/Class::Struct.3.gz
OLD_FILES+=usr/share/perl/man/man3/Config.3.gz
OLD_FILES+=usr/share/perl/man/man3/Cwd.3.gz
OLD_FILES+=usr/share/perl/man/man3/DB_File.3.gz
OLD_FILES+=usr/share/perl/man/man3/Data::Dumper.3.gz
OLD_FILES+=usr/share/perl/man/man3/Devel::SelfStubber.3.gz
OLD_FILES+=usr/share/perl/man/man3/DirHandle.3.gz
OLD_FILES+=usr/share/perl/man/man3/Dumpvalue.3.gz
OLD_FILES+=usr/share/perl/man/man3/DynaLoader.3.gz
OLD_FILES+=usr/share/perl/man/man3/English.3.gz
OLD_FILES+=usr/share/perl/man/man3/Env.3.gz
OLD_FILES+=usr/share/perl/man/man3/Exporter.3.gz
OLD_FILES+=usr/share/perl/man/man3/ExtUtils::Command.3.gz
OLD_FILES+=usr/share/perl/man/man3/ExtUtils::Embed.3.gz
OLD_FILES+=usr/share/perl/man/man3/ExtUtils::Install.3.gz
OLD_FILES+=usr/share/perl/man/man3/ExtUtils::Installed.3.gz
OLD_FILES+=usr/share/perl/man/man3/ExtUtils::Liblist.3.gz
OLD_FILES+=usr/share/perl/man/man3/ExtUtils::MM_OS2.3.gz
OLD_FILES+=usr/share/perl/man/man3/ExtUtils::MM_Unix.3.gz
OLD_FILES+=usr/share/perl/man/man3/ExtUtils::MM_VMS.3.gz
OLD_FILES+=usr/share/perl/man/man3/ExtUtils::MM_Win32.3.gz
OLD_FILES+=usr/share/perl/man/man3/ExtUtils::MakeMaker.3.gz
OLD_FILES+=usr/share/perl/man/man3/ExtUtils::Manifest.3.gz
OLD_FILES+=usr/share/perl/man/man3/ExtUtils::Mkbootstrap.3.gz
OLD_FILES+=usr/share/perl/man/man3/ExtUtils::Mksymlists.3.gz
OLD_FILES+=usr/share/perl/man/man3/ExtUtils::Packlist.3.gz
OLD_FILES+=usr/share/perl/man/man3/ExtUtils::testlib.3.gz
OLD_FILES+=usr/share/perl/man/man3/Fatal.3.gz
OLD_FILES+=usr/share/perl/man/man3/Fcntl.3.gz
OLD_FILES+=usr/share/perl/man/man3/File::Basename.3.gz
OLD_FILES+=usr/share/perl/man/man3/File::CheckTree.3.gz
OLD_FILES+=usr/share/perl/man/man3/File::Compare.3.gz
OLD_FILES+=usr/share/perl/man/man3/File::Copy.3.gz
OLD_FILES+=usr/share/perl/man/man3/File::DosGlob.3.gz
OLD_FILES+=usr/share/perl/man/man3/File::Find.3.gz
OLD_FILES+=usr/share/perl/man/man3/File::Path.3.gz
OLD_FILES+=usr/share/perl/man/man3/File::Spec.3.gz
OLD_FILES+=usr/share/perl/man/man3/File::Spec::Mac.3.gz
OLD_FILES+=usr/share/perl/man/man3/File::Spec::OS2.3.gz
OLD_FILES+=usr/share/perl/man/man3/File::Spec::Unix.3.gz
OLD_FILES+=usr/share/perl/man/man3/File::Spec::VMS.3.gz
OLD_FILES+=usr/share/perl/man/man3/File::Spec::Win32.3.gz
OLD_FILES+=usr/share/perl/man/man3/File::stat.3.gz
OLD_FILES+=usr/share/perl/man/man3/FileCache.3.gz
OLD_FILES+=usr/share/perl/man/man3/IO.3.gz
OLD_FILES+=usr/share/perl/man/man3/FileHandle.3.gz
OLD_FILES+=usr/share/perl/man/man3/FindBin.3.gz
OLD_FILES+=usr/share/perl/man/man3/GDBM_File.3.gz
OLD_FILES+=usr/share/perl/man/man3/Getopt::Long.3.gz
OLD_FILES+=usr/share/perl/man/man3/Getopt::Std.3.gz
OLD_FILES+=usr/share/perl/man/man3/I18N::Collate.3.gz
OLD_FILES+=usr/share/perl/man/man3/IO::File.3.gz
OLD_FILES+=usr/share/perl/man/man3/IO::Handle.3.gz
OLD_FILES+=usr/share/perl/man/man3/IO::Pipe.3.gz
OLD_FILES+=usr/share/perl/man/man3/IO::Seekable.3.gz
OLD_FILES+=usr/share/perl/man/man3/IO::Select.3.gz
OLD_FILES+=usr/share/perl/man/man3/IO::Socket.3.gz
OLD_FILES+=usr/share/perl/man/man3/IPC::Msg.3.gz
OLD_FILES+=usr/share/perl/man/man3/IPC::Open2.3.gz
OLD_FILES+=usr/share/perl/man/man3/IPC::Open3.3.gz
OLD_FILES+=usr/share/perl/man/man3/IPC::Semaphore.3.gz
OLD_FILES+=usr/share/perl/man/man3/IPC::SysV.3.gz
OLD_FILES+=usr/share/perl/man/man3/Math::BigFloat.3.gz
OLD_FILES+=usr/share/perl/man/man3/Math::BigInt.3.gz
OLD_FILES+=usr/share/perl/man/man3/Math::Complex.3.gz
OLD_FILES+=usr/share/perl/man/man3/Math::Trig.3.gz
OLD_FILES+=usr/share/perl/man/man3/NDBM_File.3.gz
OLD_FILES+=usr/share/perl/man/man3/Net::Ping.3.gz
OLD_FILES+=usr/share/perl/man/man3/Net::hostent.3.gz
OLD_FILES+=usr/share/perl/man/man3/Net::netent.3.gz
OLD_FILES+=usr/share/perl/man/man3/Net::protoent.3.gz
OLD_FILES+=usr/share/perl/man/man3/Net::servent.3.gz
OLD_FILES+=usr/share/perl/man/man3/O.3.gz
OLD_FILES+=usr/share/perl/man/man3/ODBM_File.3.gz
OLD_FILES+=usr/share/perl/man/man3/Opcode.3.gz
OLD_FILES+=usr/share/perl/man/man3/POSIX.3.gz
OLD_FILES+=usr/share/perl/man/man3/Pod::Html.3.gz
OLD_FILES+=usr/share/perl/man/man3/Pod::Text.3.gz
OLD_FILES+=usr/share/perl/man/man3/SDBM_File.3.gz
OLD_FILES+=usr/share/perl/man/man3/Safe.3.gz
OLD_FILES+=usr/share/perl/man/man3/Search::Dict.3.gz
OLD_FILES+=usr/share/perl/man/man3/SelectSaver.3.gz
OLD_FILES+=usr/share/perl/man/man3/SelfLoader.3.gz
OLD_FILES+=usr/share/perl/man/man3/Shell.3.gz
OLD_FILES+=usr/share/perl/man/man3/Socket.3.gz
OLD_FILES+=usr/share/perl/man/man3/Symbol.3.gz
OLD_FILES+=usr/share/perl/man/man3/re.3.gz
OLD_FILES+=usr/share/perl/man/man3/Sys::Hostname.3.gz
OLD_FILES+=usr/share/perl/man/man3/Sys::Syslog.3.gz
OLD_FILES+=usr/share/perl/man/man3/Term::Cap.3.gz
OLD_FILES+=usr/share/perl/man/man3/Term::Complete.3.gz
OLD_FILES+=usr/share/perl/man/man3/Term::ReadLine.3.gz
OLD_FILES+=usr/share/perl/man/man3/Test.3.gz
OLD_FILES+=usr/share/perl/man/man3/Test::Harness.3.gz
OLD_FILES+=usr/share/perl/man/man3/Text::Abbrev.3.gz
OLD_FILES+=usr/share/perl/man/man3/Text::ParseWords.3.gz
OLD_FILES+=usr/share/perl/man/man3/Text::Soundex.3.gz
OLD_FILES+=usr/share/perl/man/man3/Text::Tabs.3.gz
OLD_FILES+=usr/share/perl/man/man3/Text::Wrap.3.gz
OLD_FILES+=usr/share/perl/man/man3/Thread.3.gz
OLD_FILES+=usr/share/perl/man/man3/Thread::Queue.3.gz
OLD_FILES+=usr/share/perl/man/man3/Thread::Semaphore.3.gz
OLD_FILES+=usr/share/perl/man/man3/Thread::Signal.3.gz
OLD_FILES+=usr/share/perl/man/man3/Thread::Specific.3.gz
OLD_FILES+=usr/share/perl/man/man3/Tie::Array.3.gz
OLD_FILES+=usr/share/perl/man/man3/Tie::Handle.3.gz
OLD_FILES+=usr/share/perl/man/man3/Tie::Hash.3.gz
OLD_FILES+=usr/share/perl/man/man3/Tie::RefHash.3.gz
OLD_FILES+=usr/share/perl/man/man3/Tie::Scalar.3.gz
OLD_FILES+=usr/share/perl/man/man3/Tie::SubstrHash.3.gz
OLD_FILES+=usr/share/perl/man/man3/Time::Local.3.gz
OLD_FILES+=usr/share/perl/man/man3/Time::gmtime.3.gz
OLD_FILES+=usr/share/perl/man/man3/Time::localtime.3.gz
OLD_FILES+=usr/share/perl/man/man3/Time::tm.3.gz
OLD_FILES+=usr/share/perl/man/man3/UNIVERSAL.3.gz
OLD_FILES+=usr/share/perl/man/man3/User::grent.3.gz
OLD_FILES+=usr/share/perl/man/man3/User::pwent.3.gz
OLD_FILES+=usr/share/perl/man/man3/attrs.3.gz
OLD_FILES+=usr/share/perl/man/man3/autouse.3.gz
OLD_FILES+=usr/share/perl/man/man3/base.3.gz
OLD_FILES+=usr/share/perl/man/man3/blib.3.gz
OLD_FILES+=usr/share/perl/man/man3/constant.3.gz
OLD_FILES+=usr/share/perl/man/man3/diagnostics.3.gz
OLD_FILES+=usr/share/perl/man/man3/fields.3.gz
OLD_FILES+=usr/share/perl/man/man3/integer.3.gz
OLD_FILES+=usr/share/perl/man/man3/less.3.gz
OLD_FILES+=usr/share/perl/man/man3/lib.3.gz
OLD_FILES+=usr/share/perl/man/man3/locale.3.gz
OLD_FILES+=usr/share/perl/man/man3/ops.3.gz
OLD_FILES+=usr/share/perl/man/man3/overload.3.gz
OLD_FILES+=usr/share/perl/man/man3/sigtrap.3.gz
OLD_FILES+=usr/share/perl/man/man3/strict.3.gz
OLD_FILES+=usr/share/perl/man/man3/subs.3.gz
OLD_FILES+=usr/share/perl/man/man3/vars.3.gz
OLD_FILES+=usr/share/perl/man/man3/B::Stash.3.gz
OLD_FILES+=usr/share/perl/man/man3/ByteLoader.3.gz
OLD_FILES+=usr/share/perl/man/man3/CGI::Pretty.3.gz
OLD_FILES+=usr/share/perl/man/man3/Carp::Heavy.3.gz
OLD_FILES+=usr/share/perl/man/man3/DB.3.gz
OLD_FILES+=usr/share/perl/man/man3/DProf::DProf.3.gz
OLD_FILES+=usr/share/perl/man/man3/Exporter::Heavy.3.gz
OLD_FILES+=usr/share/perl/man/man3/ExtUtils::MM_Cygwin.3.gz
OLD_FILES+=usr/share/perl/man/man3/File::Glob.3.gz
OLD_FILES+=usr/share/perl/man/man3/Glob::Glob.3.gz
OLD_FILES+=usr/share/perl/man/man3/Hostname::Hostname.3.gz
OLD_FILES+=usr/share/perl/man/man3/IO::Dir.3.gz
OLD_FILES+=usr/share/perl/man/man3/IO::Poll.3.gz
OLD_FILES+=usr/share/perl/man/man3/IO::Socket::INET.3.gz
OLD_FILES+=usr/share/perl/man/man3/IO::Socket::UNIX.3.gz
OLD_FILES+=usr/share/perl/man/man3/Peek::Peek.3.gz
OLD_FILES+=usr/share/perl/man/man3/Pod::Checker.3.gz
OLD_FILES+=usr/share/perl/man/man3/Pod::Find.3.gz
OLD_FILES+=usr/share/perl/man/man3/Pod::InputObjects.3.gz
OLD_FILES+=usr/share/perl/man/man3/Pod::Man.3.gz
OLD_FILES+=usr/share/perl/man/man3/Pod::ParseUtils.3.gz
OLD_FILES+=usr/share/perl/man/man3/Pod::Parser.3.gz
OLD_FILES+=usr/share/perl/man/man3/Pod::Plainer.3.gz
OLD_FILES+=usr/share/perl/man/man3/Pod::Select.3.gz
OLD_FILES+=usr/share/perl/man/man3/Pod::Text::Color.3.gz
OLD_FILES+=usr/share/perl/man/man3/Pod::Text::Termcap.3.gz
OLD_FILES+=usr/share/perl/man/man3/Pod::Usage.3.gz
OLD_FILES+=usr/share/perl/man/man3/Syslog::Syslog.3.gz
OLD_FILES+=usr/share/perl/man/man3/Term::ANSIColor.3.gz
OLD_FILES+=usr/share/perl/man/man3/XSLoader.3.gz
OLD_FILES+=usr/share/perl/man/man3/attributes.3.gz
OLD_FILES+=usr/share/perl/man/man3/bytes.3.gz
OLD_FILES+=usr/share/perl/man/man3/charnames.3.gz
OLD_FILES+=usr/share/perl/man/man3/filetest.3.gz
OLD_FILES+=usr/share/perl/man/man3/open.3.gz
OLD_FILES+=usr/share/perl/man/man3/utf8.3.gz
OLD_FILES+=usr/share/perl/man/man3/warnings.3.gz
OLD_FILES+=usr/share/perl/man/man3/warnings::register.3.gz
OLD_FILES+=usr/share/perl/man/whatis
OLD_FILES+=usr/share/man/man1/CA.pl.1.gz
OLD_FILES+=usr/share/man/man1/asn1parse.1.gz
OLD_FILES+=usr/share/man/man1/ca.1.gz
OLD_FILES+=usr/share/man/man1/ciphers.1.gz
OLD_FILES+=usr/share/man/man1/config.1.gz
OLD_FILES+=usr/share/man/man1/crl.1.gz
OLD_FILES+=usr/share/man/man1/crl2pkcs7.1.gz
OLD_FILES+=usr/share/man/man1/dgst.1.gz
OLD_FILES+=usr/share/man/man1/dhparam.1.gz
OLD_FILES+=usr/share/man/man1/doscmd.1.gz
OLD_FILES+=usr/share/man/man1/dsa.1.gz
OLD_FILES+=usr/share/man/man1/dsaparam.1.gz
OLD_FILES+=usr/share/man/man1/enc.1.gz
OLD_FILES+=usr/share/man/man1/gendsa.1.gz
OLD_FILES+=usr/share/man/man1/genrsa.1.gz
OLD_FILES+=usr/share/man/man1/getNAME.1.gz
OLD_FILES+=usr/share/man/man1/nseq.1.gz
OLD_FILES+=usr/share/man/man1/ocsp.1.gz
OLD_FILES+=usr/share/man/man1/openssl.1.gz
OLD_FILES+=usr/share/man/man1/perl.1.gz
OLD_FILES+=usr/share/man/man1/perl5004delta.1.gz
OLD_FILES+=usr/share/man/man1/perlapio.1.gz
OLD_FILES+=usr/share/man/man1/perlbook.1.gz
OLD_FILES+=usr/share/man/man1/perlbot.1.gz
OLD_FILES+=usr/share/man/man1/perlcall.1.gz
OLD_FILES+=usr/share/man/man1/perldata.1.gz
OLD_FILES+=usr/share/man/man1/perldebug.1.gz
OLD_FILES+=usr/share/man/man1/perldelta.1.gz
OLD_FILES+=usr/share/man/man1/perldiag.1.gz
OLD_FILES+=usr/share/man/man1/perldsc.1.gz
OLD_FILES+=usr/share/man/man1/perlembed.1.gz
OLD_FILES+=usr/share/man/man1/perlfaq.1.gz
OLD_FILES+=usr/share/man/man1/perlfaq1.1.gz
OLD_FILES+=usr/share/man/man1/perlfaq2.1.gz
OLD_FILES+=usr/share/man/man1/perlfaq3.1.gz
OLD_FILES+=usr/share/man/man1/perlfaq4.1.gz
OLD_FILES+=usr/share/man/man1/perlfaq5.1.gz
OLD_FILES+=usr/share/man/man1/perlfaq6.1.gz
OLD_FILES+=usr/share/man/man1/perlfaq7.1.gz
OLD_FILES+=usr/share/man/man1/perlfaq8.1.gz
OLD_FILES+=usr/share/man/man1/perlfaq9.1.gz
OLD_FILES+=usr/share/man/man1/perlform.1.gz
OLD_FILES+=usr/share/man/man1/perlfunc.1.gz
OLD_FILES+=usr/share/man/man1/perlguts.1.gz
OLD_FILES+=usr/share/man/man1/perlhist.1.gz
OLD_FILES+=usr/share/man/man1/perlipc.1.gz
OLD_FILES+=usr/share/man/man1/perllocale.1.gz
OLD_FILES+=usr/share/man/man1/perllol.1.gz
OLD_FILES+=usr/share/man/man1/perlmod.1.gz
OLD_FILES+=usr/share/man/man1/perlmodinstall.1.gz
OLD_FILES+=usr/share/man/man1/perlmodlib.1.gz
OLD_FILES+=usr/share/man/man1/perlobj.1.gz
OLD_FILES+=usr/share/man/man1/perlop.1.gz
OLD_FILES+=usr/share/man/man1/perlopentut.1.gz
OLD_FILES+=usr/share/man/man1/perlpod.1.gz
OLD_FILES+=usr/share/man/man1/perlport.1.gz
OLD_FILES+=usr/share/man/man1/perlre.1.gz
OLD_FILES+=usr/share/man/man1/perlref.1.gz
OLD_FILES+=usr/share/man/man1/perlreftut.1.gz
OLD_FILES+=usr/share/man/man1/perlrun.1.gz
OLD_FILES+=usr/share/man/man1/perlsec.1.gz
OLD_FILES+=usr/share/man/man1/perlstyle.1.gz
OLD_FILES+=usr/share/man/man1/perlsub.1.gz
OLD_FILES+=usr/share/man/man1/perlsyn.1.gz
OLD_FILES+=usr/share/man/man1/perlthrtut.1.gz
OLD_FILES+=usr/share/man/man1/perltie.1.gz
OLD_FILES+=usr/share/man/man1/perltoc.1.gz
OLD_FILES+=usr/share/man/man1/perltoot.1.gz
OLD_FILES+=usr/share/man/man1/perltrap.1.gz
OLD_FILES+=usr/share/man/man1/perlvar.1.gz
OLD_FILES+=usr/share/man/man1/perlxs.1.gz
OLD_FILES+=usr/share/man/man1/perlxstut.1.gz
OLD_FILES+=usr/share/man/man1/perlbug.1.gz
OLD_FILES+=usr/share/man/man1/perlcc.1.gz
OLD_FILES+=usr/share/man/man1/perldoc.1.gz
OLD_FILES+=usr/share/man/man1/perl5005delta.1.gz
OLD_FILES+=usr/share/man/man1/perlfork.1.gz
OLD_FILES+=usr/share/man/man1/perlboot.1.gz
OLD_FILES+=usr/share/man/man1/perltootc.1.gz
OLD_FILES+=usr/share/man/man1/perldbmfilter.1.gz
OLD_FILES+=usr/share/man/man1/perldebguts.1.gz
OLD_FILES+=usr/share/man/man1/perlnumber.1.gz
OLD_FILES+=usr/share/man/man1/perlcompile.1.gz
OLD_FILES+=usr/share/man/man1/perltodo.1.gz
OLD_FILES+=usr/share/man/man1/perlapi.1.gz
OLD_FILES+=usr/share/man/man1/perlintern.1.gz
OLD_FILES+=usr/share/man/man1/perlhack.1.gz
OLD_FILES+=usr/share/man/man1/perlbc.1.gz
OLD_FILES+=usr/share/man/man1/pkcs12.1.gz
OLD_FILES+=usr/share/man/man1/pkcs7.1.gz
OLD_FILES+=usr/share/man/man1/pkcs8.1.gz
OLD_FILES+=usr/share/man/man1/rand.1.gz
OLD_FILES+=usr/share/man/man1/req.1.gz
OLD_FILES+=usr/share/man/man1/rsa.1.gz
OLD_FILES+=usr/share/man/man1/rsautl.1.gz
OLD_FILES+=usr/share/man/man1/s_client.1.gz
OLD_FILES+=usr/share/man/man1/s_server.1.gz
OLD_FILES+=usr/share/man/man1/sess_id.1.gz
OLD_FILES+=usr/share/man/man1/smime.1.gz
OLD_FILES+=usr/share/man/man1/speed.1.gz
OLD_FILES+=usr/share/man/man1/spkac.1.gz
OLD_FILES+=usr/share/man/man1/verify.1.gz
OLD_FILES+=usr/share/man/man1/version.1.gz
OLD_FILES+=usr/share/man/man1/x509.1.gz
OLD_FILES+=usr/share/man/man3/SSL_COMP_add_compression_method.3.gz
OLD_FILES+=usr/share/man/man3/SSL_CTX_get_ex_new_index.3.gz
OLD_FILES+=usr/share/man/man3/archive_entry_dup.3.gz
OLD_FILES+=usr/share/man/man3/archive_entry_set_tartype.3.gz
OLD_FILES+=usr/share/man/man3/archive_entry_tartype.3.gz
OLD_FILES+=usr/share/man/man3/archive_read_data_into_file.3.gz
OLD_FILES+=usr/share/man/man3/archive_read_open_tar.3.gz
OLD_FILES+=usr/share/man/man3/archive_read_support_format_gnutar.3.gz
OLD_FILES+=usr/share/man/man3/cipher.3.gz
OLD_FILES+=usr/share/man/man3/des_cipher.3.gz
OLD_FILES+=usr/share/man/man3/des_setkey.3.gz
OLD_FILES+=usr/share/man/man3/encrypt.3.gz
OLD_FILES+=usr/share/man/man3/endvfsent.3.gz
OLD_FILES+=usr/share/man/man3/getvfsbytype.3.gz
OLD_FILES+=usr/share/man/man3/getvfsent.3.gz
OLD_FILES+=usr/share/man/man3/isnanf.3.gz
OLD_FILES+=usr/share/man/man3/libautofs.3.gz
OLD_FILES+=usr/share/man/man3/pthread_attr_setsstack.3.gz
OLD_FILES+=usr/share/man/man3/pthread_getcancelstate.3.gz
OLD_FILES+=usr/share/man/man3/pthread_mutexattr_getpshared.3.gz
OLD_FILES+=usr/share/man/man3/pthread_mutexattr_setpshared.3.gz
OLD_FILES+=usr/share/man/man3/set_assertion_failure_callback.3.gz
OLD_FILES+=usr/share/man/man3/setkey.3.gz
OLD_FILES+=usr/share/man/man3/setvfsent.3.gz
OLD_FILES+=usr/share/man/man3/ssl.3.gz
OLD_FILES+=usr/share/man/man3/vfsisloadable.3.gz
OLD_FILES+=usr/share/man/man3/vfsload.3.gz
OLD_FILES+=usr/share/man/man4/als4000.4.gz
OLD_FILES+=usr/share/man/man4/csa.4.gz
OLD_FILES+=usr/share/man/man4/emu10k1.4.gz
OLD_FILES+=usr/share/man/man4/euc.4.gz
OLD_FILES+=usr/share/man/man4/gusc.4.gz
OLD_FILES+=usr/share/man/man4/if_fwp.4.gz
OLD_FILES+=usr/share/man/man4/lomac.4.gz
OLD_FILES+=usr/share/man/man4/maestro3.4.gz
OLD_FILES+=usr/share/man/man4/raid.4.gz
OLD_FILES+=usr/share/man/man4/sbc.4.gz
OLD_FILES+=usr/share/man/man4/sd.4.gz
OLD_FILES+=usr/share/man/man4/snc.4.gz
OLD_FILES+=usr/share/man/man4/st.4.gz
OLD_FILES+=usr/share/man/man4/uaudio.4.gz
OLD_FILES+=usr/share/man/man4/utf2.4.gz
OLD_FILES+=usr/share/man/man4/vinumdebug.4.gz
OLD_FILES+=usr/share/man/man5/disklabel.5.gz
OLD_FILES+=usr/share/man/man5/dm.conf.5.gz
OLD_FILES+=usr/share/man/man5/ranlib.5.gz
OLD_FILES+=usr/share/man/man5/utf2.5.gz
OLD_FILES+=usr/share/man/man7/groff_mwww.7.gz
OLD_FILES+=usr/share/man/man7/mmroff.7.gz
OLD_FILES+=usr/share/man/man7/mwww.7.gz
OLD_FILES+=usr/share/man/man7/style.perl.7.gz
OLD_FILES+=usr/share/man/man8/apm.8.gz
OLD_FILES+=usr/share/man/man8/apmconf.8.gz
OLD_FILES+=usr/share/man/man8/apmd.8.gz
OLD_FILES+=usr/share/man/man8/dm.8.gz
OLD_FILES+=usr/share/man/man8/pam_ftp.8.gz
OLD_FILES+=usr/share/man/man8/pam_wheel.8.gz
OLD_FILES+=usr/share/man/man8/sconfig.8.gz
OLD_FILES+=usr/share/man/man8/ssl.8.gz
OLD_FILES+=usr/share/man/man8/wlconfig.8.gz
OLD_FILES+=usr/share/man/man9/CURSIG.9.gz
OLD_FILES+=usr/share/man/man9/VFS_INIT.9.gz
OLD_FILES+=usr/share/man/man9/at_exit.9.gz
OLD_FILES+=usr/share/man/man9/at_fork.9.gz
OLD_FILES+=usr/share/man/man9/cdevsw_add.9.gz
OLD_FILES+=usr/share/man/man9/cdevsw_remove.9.gz
OLD_FILES+=usr/share/man/man9/cv_waitq_empty.9.gz
OLD_FILES+=usr/share/man/man9/cv_waitq_remove.9.gz
OLD_FILES+=usr/share/man/man9/endtsleep.9.gz
OLD_FILES+=usr/share/man/man9/jumbo.9.gz
OLD_FILES+=usr/share/man/man9/jumbo_freem.9.gz
OLD_FILES+=usr/share/man/man9/jumbo_pg_alloc.9.gz
OLD_FILES+=usr/share/man/man9/jumbo_pg_free.9.gz
OLD_FILES+=usr/share/man/man9/jumbo_pg_steal.9.gz
OLD_FILES+=usr/share/man/man9/jumbo_phys_to_kva.9.gz
OLD_FILES+=usr/share/man/man9/jumbo_vm_init.9.gz
OLD_FILES+=usr/share/man/man9/mac_biba.9.gz
OLD_FILES+=usr/share/man/man9/mac_bsdextended.9.gz
OLD_FILES+=usr/share/man/man9/mono_time.9.gz
OLD_FILES+=usr/share/man/man9/p1003_1b.9.gz
OLD_FILES+=usr/share/man/man9/pmap_prefault.9.gz
OLD_FILES+=usr/share/man/man9/posix4.9.gz
OLD_FILES+=usr/share/man/man9/resource_query_name.9.gz
OLD_FILES+=usr/share/man/man9/resource_query_string.9.gz
OLD_FILES+=usr/share/man/man9/resource_query_unit.9.gz
OLD_FILES+=usr/share/man/man9/rm_at_exit.9.gz
OLD_FILES+=usr/share/man/man9/rm_at_fork.9.gz
OLD_FILES+=usr/share/man/man9/runtime.9.gz
OLD_FILES+=usr/share/man/man9/sleepinit.9.gz
OLD_FILES+=usr/share/man/man9/unsleep.9.gz
OLD_FILES+=usr/share/man/ja/man1/perl.1.gz
OLD_FILES+=usr/share/games/atc/Game_List
OLD_FILES+=usr/share/games/atc/Killer
OLD_FILES+=usr/share/games/atc/crossover
OLD_FILES+=usr/share/games/atc/default
OLD_FILES+=usr/share/games/atc/easy
OLD_FILES+=usr/share/games/atc/game_2
OLD_FILES+=usr/share/games/larn/larnmaze
OLD_FILES+=usr/share/games/larn/larnopts
OLD_FILES+=usr/share/games/larn/larn.help
OLD_FILES+=usr/share/games/quiz.db/africa
OLD_FILES+=usr/share/games/quiz.db/america
OLD_FILES+=usr/share/games/quiz.db/areas
OLD_FILES+=usr/share/games/quiz.db/arith
OLD_FILES+=usr/share/games/quiz.db/asia
OLD_FILES+=usr/share/games/quiz.db/babies
OLD_FILES+=usr/share/games/quiz.db/bard
OLD_FILES+=usr/share/games/quiz.db/chinese
OLD_FILES+=usr/share/games/quiz.db/collectives
OLD_FILES+=usr/share/games/quiz.db/ed
OLD_FILES+=usr/share/games/quiz.db/elements
OLD_FILES+=usr/share/games/quiz.db/europe
OLD_FILES+=usr/share/games/quiz.db/flowers
OLD_FILES+=usr/share/games/quiz.db/greek
OLD_FILES+=usr/share/games/quiz.db/inca
OLD_FILES+=usr/share/games/quiz.db/index
OLD_FILES+=usr/share/games/quiz.db/latin
OLD_FILES+=usr/share/games/quiz.db/locomotive
OLD_FILES+=usr/share/games/quiz.db/midearth
OLD_FILES+=usr/share/games/quiz.db/morse
OLD_FILES+=usr/share/games/quiz.db/murders
OLD_FILES+=usr/share/games/quiz.db/poetry
OLD_FILES+=usr/share/games/quiz.db/posneg
OLD_FILES+=usr/share/games/quiz.db/pres
OLD_FILES+=usr/share/games/quiz.db/province
OLD_FILES+=usr/share/games/quiz.db/seq-easy
OLD_FILES+=usr/share/games/quiz.db/seq-hard
OLD_FILES+=usr/share/games/quiz.db/sexes
OLD_FILES+=usr/share/games/quiz.db/sov
OLD_FILES+=usr/share/games/quiz.db/spell
OLD_FILES+=usr/share/games/quiz.db/state
OLD_FILES+=usr/share/games/quiz.db/trek
OLD_FILES+=usr/share/games/quiz.db/ucc
OLD_FILES+=usr/share/games/cribbage.instr
OLD_FILES+=usr/share/games/fish.instr
OLD_FILES+=usr/share/games/wump.info
OLD_FILES+=usr/games/hide/adventure
OLD_FILES+=usr/games/hide/arithmetic
OLD_FILES+=usr/games/hide/atc
OLD_FILES+=usr/games/hide/backgammon
OLD_FILES+=usr/games/hide/teachgammon
OLD_FILES+=usr/games/hide/battlestar
OLD_FILES+=usr/games/hide/bs
OLD_FILES+=usr/games/hide/canfield
OLD_FILES+=usr/games/hide/cribbage
OLD_FILES+=usr/games/hide/fish
OLD_FILES+=usr/games/hide/hack
OLD_FILES+=usr/games/hide/hangman
OLD_FILES+=usr/games/hide/larn
OLD_FILES+=usr/games/hide/mille
OLD_FILES+=usr/games/hide/phantasia
OLD_FILES+=usr/games/hide/quiz
OLD_FILES+=usr/games/hide/robots
OLD_FILES+=usr/games/hide/rogue
OLD_FILES+=usr/games/hide/sail
OLD_FILES+=usr/games/hide/snake
OLD_FILES+=usr/games/hide/trek
OLD_FILES+=usr/games/hide/worm
OLD_FILES+=usr/games/hide/wump
OLD_FILES+=usr/games/adventure
OLD_FILES+=usr/games/arithmetic
OLD_FILES+=usr/games/atc
OLD_FILES+=usr/games/backgammon
OLD_FILES+=usr/games/teachgammon
OLD_FILES+=usr/games/battlestar
OLD_FILES+=usr/games/bs
OLD_FILES+=usr/games/canfield
OLD_FILES+=usr/games/cfscores
OLD_FILES+=usr/games/cribbage
OLD_FILES+=usr/games/dm
OLD_FILES+=usr/games/fish
OLD_FILES+=usr/games/hack
OLD_FILES+=usr/games/hangman
OLD_FILES+=usr/games/larn
OLD_FILES+=usr/games/mille
OLD_FILES+=usr/games/phantasia
OLD_FILES+=usr/games/piano
OLD_FILES+=usr/games/pig
OLD_FILES+=usr/games/quiz
OLD_FILES+=usr/games/rain
OLD_FILES+=usr/games/robots
OLD_FILES+=usr/games/rogue
OLD_FILES+=usr/games/sail
OLD_FILES+=usr/games/snake
OLD_FILES+=usr/games/snscore
OLD_FILES+=usr/games/trek
OLD_FILES+=usr/games/wargames
OLD_FILES+=usr/games/worm
OLD_FILES+=usr/games/worms
OLD_FILES+=usr/games/wump
OLD_FILES+=sbin/mount_reiserfs
OLD_FILES+=usr/include/cam/cam_extend.h
OLD_FILES+=usr/include/dev/wi/wi_hostap.h
OLD_FILES+=usr/include/disktab.h
OLD_FILES+=usr/include/g++/FlexLexer.h
OLD_FILES+=usr/include/g++/PlotFile.h
OLD_FILES+=usr/include/g++/SFile.h
OLD_FILES+=usr/include/g++/_G_config.h
OLD_FILES+=usr/include/g++/algo.h
OLD_FILES+=usr/include/g++/algobase.h
OLD_FILES+=usr/include/g++/algorithm
OLD_FILES+=usr/include/g++/alloc.h
OLD_FILES+=usr/include/g++/bitset
OLD_FILES+=usr/include/g++/builtinbuf.h
OLD_FILES+=usr/include/g++/bvector.h
OLD_FILES+=usr/include/g++/cassert
OLD_FILES+=usr/include/g++/cctype
OLD_FILES+=usr/include/g++/cerrno
OLD_FILES+=usr/include/g++/cfloat
OLD_FILES+=usr/include/g++/ciso646
OLD_FILES+=usr/include/g++/climits
OLD_FILES+=usr/include/g++/clocale
OLD_FILES+=usr/include/g++/cmath
OLD_FILES+=usr/include/g++/complex
OLD_FILES+=usr/include/g++/complex.h
OLD_FILES+=usr/include/g++/csetjmp
OLD_FILES+=usr/include/g++/csignal
OLD_FILES+=usr/include/g++/cstdarg
OLD_FILES+=usr/include/g++/cstddef
OLD_FILES+=usr/include/g++/cstdio
OLD_FILES+=usr/include/g++/cstdlib
OLD_FILES+=usr/include/g++/cstring
OLD_FILES+=usr/include/g++/ctime
OLD_FILES+=usr/include/g++/cwchar
OLD_FILES+=usr/include/g++/cwctype
OLD_FILES+=usr/include/g++/defalloc.h
OLD_FILES+=usr/include/g++/deque
OLD_FILES+=usr/include/g++/deque.h
OLD_FILES+=usr/include/g++/editbuf.h
OLD_FILES+=usr/include/g++/exception
OLD_FILES+=usr/include/g++/floatio.h
OLD_FILES+=usr/include/g++/fstream
OLD_FILES+=usr/include/g++/fstream.h
OLD_FILES+=usr/include/g++/function.h
OLD_FILES+=usr/include/g++/functional
OLD_FILES+=usr/include/g++/hash_map
OLD_FILES+=usr/include/g++/hash_map.h
OLD_FILES+=usr/include/g++/hash_set
OLD_FILES+=usr/include/g++/hash_set.h
OLD_FILES+=usr/include/g++/hashtable.h
OLD_FILES+=usr/include/g++/heap.h
OLD_FILES+=usr/include/g++/indstream.h
OLD_FILES+=usr/include/g++/iolibio.h
OLD_FILES+=usr/include/g++/iomanip
OLD_FILES+=usr/include/g++/iomanip.h
OLD_FILES+=usr/include/g++/iosfwd
OLD_FILES+=usr/include/g++/iostdio.h
OLD_FILES+=usr/include/g++/iostream
OLD_FILES+=usr/include/g++/iostream.h
OLD_FILES+=usr/include/g++/iostreamP.h
OLD_FILES+=usr/include/g++/istream.h
OLD_FILES+=usr/include/g++/iterator
OLD_FILES+=usr/include/g++/iterator.h
OLD_FILES+=usr/include/g++/libio.h
OLD_FILES+=usr/include/g++/libioP.h
OLD_FILES+=usr/include/g++/list
OLD_FILES+=usr/include/g++/list.h
OLD_FILES+=usr/include/g++/map
OLD_FILES+=usr/include/g++/map.h
OLD_FILES+=usr/include/g++/memory
OLD_FILES+=usr/include/g++/multimap.h
OLD_FILES+=usr/include/g++/multiset.h
OLD_FILES+=usr/include/g++/new
OLD_FILES+=usr/include/g++/new.h
OLD_FILES+=usr/include/g++/numeric
OLD_FILES+=usr/include/g++/ostream.h
OLD_FILES+=usr/include/g++/pair.h
OLD_FILES+=usr/include/g++/parsestream.h
OLD_FILES+=usr/include/g++/pfstream.h
OLD_FILES+=usr/include/g++/procbuf.h
OLD_FILES+=usr/include/g++/pthread_alloc
OLD_FILES+=usr/include/g++/pthread_alloc.h
OLD_FILES+=usr/include/g++/queue
OLD_FILES+=usr/include/g++/rope
OLD_FILES+=usr/include/g++/rope.h
OLD_FILES+=usr/include/g++/ropeimpl.h
OLD_FILES+=usr/include/g++/set
OLD_FILES+=usr/include/g++/set.h
OLD_FILES+=usr/include/g++/slist
OLD_FILES+=usr/include/g++/slist.h
OLD_FILES+=usr/include/g++/sstream
OLD_FILES+=usr/include/g++/stack
OLD_FILES+=usr/include/g++/stack.h
OLD_FILES+=usr/include/g++/std/bastring.cc
OLD_FILES+=usr/include/g++/std/bastring.h
OLD_FILES+=usr/include/g++/std/complext.cc
OLD_FILES+=usr/include/g++/std/complext.h
OLD_FILES+=usr/include/g++/std/dcomplex.h
OLD_FILES+=usr/include/g++/std/fcomplex.h
OLD_FILES+=usr/include/g++/std/gslice.h
OLD_FILES+=usr/include/g++/std/gslice_array.h
OLD_FILES+=usr/include/g++/std/indirect_array.h
OLD_FILES+=usr/include/g++/std/ldcomplex.h
OLD_FILES+=usr/include/g++/std/mask_array.h
OLD_FILES+=usr/include/g++/std/slice.h
OLD_FILES+=usr/include/g++/std/slice_array.h
OLD_FILES+=usr/include/g++/std/std_valarray.h
OLD_FILES+=usr/include/g++/std/straits.h
OLD_FILES+=usr/include/g++/std/valarray_array.h
OLD_FILES+=usr/include/g++/std/valarray_array.tcc
OLD_FILES+=usr/include/g++/std/valarray_meta.h
OLD_FILES+=usr/include/g++/stdexcept
OLD_FILES+=usr/include/g++/stdiostream.h
OLD_FILES+=usr/include/g++/stl.h
OLD_FILES+=usr/include/g++/stl_algo.h
OLD_FILES+=usr/include/g++/stl_algobase.h
OLD_FILES+=usr/include/g++/stl_alloc.h
OLD_FILES+=usr/include/g++/stl_bvector.h
OLD_FILES+=usr/include/g++/stl_config.h
OLD_FILES+=usr/include/g++/stl_construct.h
OLD_FILES+=usr/include/g++/stl_deque.h
OLD_FILES+=usr/include/g++/stl_function.h
OLD_FILES+=usr/include/g++/stl_hash_fun.h
OLD_FILES+=usr/include/g++/stl_hash_map.h
OLD_FILES+=usr/include/g++/stl_hash_set.h
OLD_FILES+=usr/include/g++/stl_hashtable.h
OLD_FILES+=usr/include/g++/stl_heap.h
OLD_FILES+=usr/include/g++/stl_iterator.h
OLD_FILES+=usr/include/g++/stl_list.h
OLD_FILES+=usr/include/g++/stl_map.h
OLD_FILES+=usr/include/g++/stl_multimap.h
OLD_FILES+=usr/include/g++/stl_multiset.h
OLD_FILES+=usr/include/g++/stl_numeric.h
OLD_FILES+=usr/include/g++/stl_pair.h
OLD_FILES+=usr/include/g++/stl_queue.h
OLD_FILES+=usr/include/g++/stl_raw_storage_iter.h
OLD_FILES+=usr/include/g++/stl_relops.h
OLD_FILES+=usr/include/g++/stl_rope.h
OLD_FILES+=usr/include/g++/stl_set.h
OLD_FILES+=usr/include/g++/stl_slist.h
OLD_FILES+=usr/include/g++/stl_stack.h
OLD_FILES+=usr/include/g++/stl_tempbuf.h
OLD_FILES+=usr/include/g++/stl_tree.h
OLD_FILES+=usr/include/g++/stl_uninitialized.h
OLD_FILES+=usr/include/g++/stl_vector.h
OLD_FILES+=usr/include/g++/stream.h
OLD_FILES+=usr/include/g++/streambuf.h
OLD_FILES+=usr/include/g++/strfile.h
OLD_FILES+=usr/include/g++/string
OLD_FILES+=usr/include/g++/strstream
OLD_FILES+=usr/include/g++/strstream.h
OLD_FILES+=usr/include/g++/tempbuf.h
OLD_FILES+=usr/include/g++/tree.h
OLD_FILES+=usr/include/g++/type_traits.h
OLD_FILES+=usr/include/g++/typeinfo
OLD_FILES+=usr/include/g++/utility
OLD_FILES+=usr/include/g++/valarray
OLD_FILES+=usr/include/g++/vector
OLD_FILES+=usr/include/g++/vector.h
OLD_FILES+=usr/include/gmp.h
OLD_FILES+=usr/include/isc/assertions.h
OLD_FILES+=usr/include/isc/ctl.h
OLD_FILES+=usr/include/isc/dst.h
OLD_FILES+=usr/include/isc/eventlib.h
OLD_FILES+=usr/include/isc/heap.h
OLD_FILES+=usr/include/isc/irpmarshall.h
OLD_FILES+=usr/include/isc/list.h
OLD_FILES+=usr/include/isc/logging.h
OLD_FILES+=usr/include/isc/memcluster.h
OLD_FILES+=usr/include/isc/misc.h
OLD_FILES+=usr/include/isc/tree.h
OLD_FILES+=usr/include/machine/ansi.h
OLD_FILES+=usr/include/machine/apic.h
OLD_FILES+=usr/include/machine/asc_ioctl.h
OLD_FILES+=usr/include/machine/asnames.h
OLD_FILES+=usr/include/machine/bus_at386.h
OLD_FILES+=usr/include/machine/bus_memio.h
OLD_FILES+=usr/include/machine/bus_pc98.h
OLD_FILES+=usr/include/machine/bus_pio.h
OLD_FILES+=usr/include/machine/cdk.h
OLD_FILES+=usr/include/machine/comstats.h
OLD_FILES+=usr/include/machine/console.h
OLD_FILES+=usr/include/machine/critical.h
OLD_FILES+=usr/include/machine/cronyx.h
OLD_FILES+=usr/include/machine/dvcfg.h
OLD_FILES+=usr/include/machine/globaldata.h
OLD_FILES+=usr/include/machine/globals.h
OLD_FILES+=usr/include/machine/gsc.h
OLD_FILES+=usr/include/machine/i4b_isppp.h
OLD_FILES+=usr/include/machine/if_wavelan_ieee.h
OLD_FILES+=usr/include/machine/iic.h
OLD_FILES+=usr/include/machine/ioctl_ctx.h
OLD_FILES+=usr/include/machine/ioctl_fd.h
OLD_FILES+=usr/include/machine/ipl.h
OLD_FILES+=usr/include/machine/lock.h
OLD_FILES+=usr/include/machine/mouse.h
OLD_FILES+=usr/include/machine/mpapic.h
OLD_FILES+=usr/include/machine/mtpr.h
OLD_FILES+=usr/include/machine/pc/msdos.h
OLD_FILES+=usr/include/machine/physio_proc.h
OLD_FILES+=usr/include/machine/smb.h
OLD_FILES+=usr/include/machine/spigot.h
OLD_FILES+=usr/include/machine/types.h
OLD_FILES+=usr/include/machine/uc_device.h
OLD_FILES+=usr/include/machine/ultrasound.h
OLD_FILES+=usr/include/machine/wtio.h
OLD_FILES+=usr/include/msdosfs/bootsect.h
OLD_FILES+=usr/include/msdosfs/bpb.h
OLD_FILES+=usr/include/msdosfs/denode.h
OLD_FILES+=usr/include/msdosfs/direntry.h
OLD_FILES+=usr/include/msdosfs/fat.h
OLD_FILES+=usr/include/msdosfs/msdosfsmount.h
OLD_FILES+=usr/include/net/hostcache.h
OLD_FILES+=usr/include/net/if_faith.h
OLD_FILES+=usr/include/net/if_ieee80211.h
OLD_FILES+=usr/include/net/if_tunvar.h
OLD_FILES+=usr/include/net/intrq.h
OLD_FILES+=usr/include/netatm/kern_include.h
OLD_FILES+=usr/include/netinet/if_fddi.h
OLD_FILES+=usr/include/netinet/in_hostcache.h
OLD_FILES+=usr/include/netinet/ip_flow.h
OLD_FILES+=usr/include/netinet/ip_fw2.h
OLD_FILES+=usr/include/netinet6/in6_prefix.h
OLD_FILES+=usr/include/netns/idp.h
OLD_FILES+=usr/include/netns/idp_var.h
OLD_FILES+=usr/include/netns/ns.h
OLD_FILES+=usr/include/netns/ns_error.h
OLD_FILES+=usr/include/netns/ns_if.h
OLD_FILES+=usr/include/netns/ns_pcb.h
OLD_FILES+=usr/include/netns/sp.h
OLD_FILES+=usr/include/netns/spidp.h
OLD_FILES+=usr/include/netns/spp_debug.h
OLD_FILES+=usr/include/netns/spp_timer.h
OLD_FILES+=usr/include/netns/spp_var.h
OLD_FILES+=usr/include/nfs/nfs.h
OLD_FILES+=usr/include/nfs/nfsm_subs.h
OLD_FILES+=usr/include/nfs/nfsmount.h
OLD_FILES+=usr/include/nfs/nfsnode.h
OLD_FILES+=usr/include/nfs/nfsrtt.h
OLD_FILES+=usr/include/nfs/nfsrvcache.h
OLD_FILES+=usr/include/nfs/nfsv2.h
OLD_FILES+=usr/include/nfs/nqnfs.h
OLD_FILES+=usr/include/ntfs/ntfs.h
OLD_FILES+=usr/include/ntfs/ntfs_compr.h
OLD_FILES+=usr/include/ntfs/ntfs_ihash.h
OLD_FILES+=usr/include/ntfs/ntfs_inode.h
OLD_FILES+=usr/include/ntfs/ntfs_subr.h
OLD_FILES+=usr/include/ntfs/ntfs_vfsops.h
OLD_FILES+=usr/include/ntfs/ntfsmount.h
OLD_FILES+=usr/include/nwfs/nwfs.h
OLD_FILES+=usr/include/nwfs/nwfs_mount.h
OLD_FILES+=usr/include/nwfs/nwfs_node.h
OLD_FILES+=usr/include/nwfs/nwfs_subr.h
OLD_FILES+=usr/include/posix4/_semaphore.h
OLD_FILES+=usr/include/posix4/aio.h
OLD_FILES+=usr/include/posix4/ksem.h
OLD_FILES+=usr/include/posix4/mqueue.h
OLD_FILES+=usr/include/posix4/posix4.h
OLD_FILES+=usr/include/posix4/sched.h
OLD_FILES+=usr/include/posix4/semaphore.h
OLD_DIRS+=usr/include/posix4
OLD_FILES+=usr/include/security/_pam_compat.h
OLD_FILES+=usr/include/security/_pam_macros.h
OLD_FILES+=usr/include/security/_pam_types.h
OLD_FILES+=usr/include/security/pam_malloc.h
OLD_FILES+=usr/include/security/pam_misc.h
OLD_FILES+=usr/include/skey.h
OLD_FILES+=usr/include/strhash.h
OLD_FILES+=usr/include/struct.h
OLD_FILES+=usr/include/sys/_label.h
OLD_FILES+=usr/include/sys/_posix.h
OLD_FILES+=usr/include/sys/bus_private.h
OLD_FILES+=usr/include/sys/ccdvar.h
OLD_FILES+=usr/include/sys/diskslice.h
OLD_FILES+=usr/include/sys/dmap.h
OLD_FILES+=usr/include/sys/inttypes.h
OLD_FILES+=usr/include/sys/jumbo.h
OLD_FILES+=usr/include/sys/mac_policy.h
OLD_FILES+=usr/include/sys/pbioio.h
OLD_FILES+=usr/include/sys/syscall-hide.h
OLD_FILES+=usr/include/sys/tprintf.h
OLD_FILES+=usr/include/sys/vnioctl.h
OLD_FILES+=usr/include/sys/wormio.h
OLD_FILES+=usr/include/telnet.h
OLD_FILES+=usr/include/ufs/mfs/mfs_extern.h
OLD_FILES+=usr/include/ufs/mfs/mfsnode.h
OLD_FILES+=usr/include/values.h
OLD_FILES+=usr/include/vm/vm_zone.h
OLD_FILES+=usr/share/examples/etc/usbd.conf
OLD_FILES+=usr/share/examples/meteor/README
OLD_FILES+=usr/share/examples/meteor/rgb16.c
OLD_FILES+=usr/share/examples/meteor/rgb24.c
OLD_FILES+=usr/share/examples/meteor/test-n.c
OLD_FILES+=usr/share/examples/meteor/yuvpk.c
OLD_FILES+=usr/share/examples/meteor/yuvpl.c
OLD_FILES+=usr/share/examples/worm/README
OLD_FILES+=usr/share/examples/worm/makecdfs.sh
OLD_FILES+=usr/share/groff_font/devlj4/Makefile
OLD_FILES+=usr/share/groff_font/devlj4/text.map
OLD_FILES+=usr/share/groff_font/devlj4/special.map
OLD_FILES+=usr/share/misc/nslookup.help
OLD_FILES+=usr/share/sendmail/cf/feature/nodns.m4
OLD_FILES+=usr/share/syscons/keymaps/lat-amer.kbd
OLD_FILES+=usr/share/vi/catalog/ru_SU.KOI8-R
OLD_FILES+=usr/share/zoneinfo/Africa/Timbuktu
OLD_FILES+=usr/share/zoneinfo/Africa/Asmera
OLD_FILES+=usr/share/zoneinfo/America/Buenos_Aires
OLD_FILES+=usr/share/zoneinfo/America/Cordoba
OLD_FILES+=usr/share/zoneinfo/America/Jujuy
OLD_FILES+=usr/share/zoneinfo/America/Catamarca
OLD_FILES+=usr/share/zoneinfo/America/Mendoza
OLD_FILES+=usr/share/zoneinfo/America/Indianapolis
OLD_FILES+=usr/share/zoneinfo/America/Louisville
OLD_FILES+=usr/share/zoneinfo/America/Argentina/ComodRivadavia
OLD_FILES+=usr/share/zoneinfo/Atlantic/Faeroe
OLD_FILES+=usr/share/zoneinfo/Europe/Belfast
OLD_FILES+=usr/share/zoneinfo/Pacific/Yap
OLD_FILES+=usr/share/zoneinfo/SystemV/YST9
OLD_FILES+=usr/share/zoneinfo/SystemV/PST8
OLD_FILES+=usr/share/zoneinfo/SystemV/EST5EDT
OLD_FILES+=usr/share/zoneinfo/SystemV/CST6CDT
OLD_FILES+=usr/share/zoneinfo/SystemV/MST7MDT
OLD_FILES+=usr/share/zoneinfo/SystemV/PST8PDT
OLD_FILES+=usr/share/zoneinfo/SystemV/YST9YDT
OLD_FILES+=usr/share/zoneinfo/SystemV/HST10
OLD_FILES+=usr/share/zoneinfo/SystemV/MST7
OLD_FILES+=usr/share/zoneinfo/SystemV/EST5
OLD_FILES+=usr/share/zoneinfo/SystemV/AST4ADT
OLD_FILES+=usr/share/zoneinfo/SystemV/CST6
OLD_FILES+=usr/share/zoneinfo/SystemV/AST4
OLD_FILES+=usr/share/doc/ntp/accopt.htm
OLD_FILES+=usr/share/doc/ntp/assoc.htm
OLD_FILES+=usr/share/doc/ntp/audio.htm
OLD_FILES+=usr/share/doc/ntp/authopt.htm
OLD_FILES+=usr/share/doc/ntp/biblio.htm
OLD_FILES+=usr/share/doc/ntp/build.htm
OLD_FILES+=usr/share/doc/ntp/clockopt.htm
OLD_FILES+=usr/share/doc/ntp/config.htm
OLD_FILES+=usr/share/doc/ntp/confopt.htm
OLD_FILES+=usr/share/doc/ntp/copyright.htm
OLD_FILES+=usr/share/doc/ntp/debug.htm
OLD_FILES+=usr/share/doc/ntp/driver1.htm
OLD_FILES+=usr/share/doc/ntp/driver10.htm
OLD_FILES+=usr/share/doc/ntp/driver11.htm
OLD_FILES+=usr/share/doc/ntp/driver12.htm
OLD_FILES+=usr/share/doc/ntp/driver16.htm
OLD_FILES+=usr/share/doc/ntp/driver18.htm
OLD_FILES+=usr/share/doc/ntp/driver19.htm
OLD_FILES+=usr/share/doc/ntp/driver2.htm
OLD_FILES+=usr/share/doc/ntp/driver20.htm
OLD_FILES+=usr/share/doc/ntp/driver22.htm
OLD_FILES+=usr/share/doc/ntp/driver23.htm
OLD_FILES+=usr/share/doc/ntp/driver24.htm
OLD_FILES+=usr/share/doc/ntp/driver26.htm
OLD_FILES+=usr/share/doc/ntp/driver27.htm
OLD_FILES+=usr/share/doc/ntp/driver28.htm
OLD_FILES+=usr/share/doc/ntp/driver29.htm
OLD_FILES+=usr/share/doc/ntp/driver3.htm
OLD_FILES+=usr/share/doc/ntp/driver30.htm
OLD_FILES+=usr/share/doc/ntp/driver32.htm
OLD_FILES+=usr/share/doc/ntp/driver33.htm
OLD_FILES+=usr/share/doc/ntp/driver34.htm
OLD_FILES+=usr/share/doc/ntp/driver35.htm
OLD_FILES+=usr/share/doc/ntp/driver36.htm
OLD_FILES+=usr/share/doc/ntp/driver37.htm
OLD_FILES+=usr/share/doc/ntp/driver4.htm
OLD_FILES+=usr/share/doc/ntp/driver5.htm
OLD_FILES+=usr/share/doc/ntp/driver6.htm
OLD_FILES+=usr/share/doc/ntp/driver7.htm
OLD_FILES+=usr/share/doc/ntp/driver8.htm
OLD_FILES+=usr/share/doc/ntp/driver9.htm
OLD_FILES+=usr/share/doc/ntp/exec.htm
OLD_FILES+=usr/share/doc/ntp/extern.htm
OLD_FILES+=usr/share/doc/ntp/gadget.htm
OLD_FILES+=usr/share/doc/ntp/hints.htm
OLD_FILES+=usr/share/doc/ntp/howto.htm
OLD_FILES+=usr/share/doc/ntp/htmlprimer.htm
OLD_FILES+=usr/share/doc/ntp/index.htm
OLD_FILES+=usr/share/doc/ntp/kern.htm
OLD_FILES+=usr/share/doc/ntp/kernpps.htm
OLD_FILES+=usr/share/doc/ntp/ldisc.htm
OLD_FILES+=usr/share/doc/ntp/measure.htm
OLD_FILES+=usr/share/doc/ntp/miscopt.htm
OLD_FILES+=usr/share/doc/ntp/monopt.htm
OLD_FILES+=usr/share/doc/ntp/mx4200data.htm
OLD_FILES+=usr/share/doc/ntp/notes.htm
OLD_FILES+=usr/share/doc/ntp/ntpd.htm
OLD_FILES+=usr/share/doc/ntp/ntpdate.htm
OLD_FILES+=usr/share/doc/ntp/ntpdc.htm
OLD_FILES+=usr/share/doc/ntp/ntpq.htm
OLD_FILES+=usr/share/doc/ntp/ntptime.htm
OLD_FILES+=usr/share/doc/ntp/ntptrace.htm
OLD_FILES+=usr/share/doc/ntp/parsedata.htm
OLD_FILES+=usr/share/doc/ntp/parsenew.htm
OLD_FILES+=usr/share/doc/ntp/patches.htm
OLD_FILES+=usr/share/doc/ntp/porting.htm
OLD_FILES+=usr/share/doc/ntp/pps.htm
OLD_FILES+=usr/share/doc/ntp/prefer.htm
OLD_FILES+=usr/share/doc/ntp/qth.htm
OLD_FILES+=usr/share/doc/ntp/quick.htm
OLD_FILES+=usr/share/doc/ntp/rdebug.htm
OLD_FILES+=usr/share/doc/ntp/refclock.htm
OLD_FILES+=usr/share/doc/ntp/release.htm
OLD_FILES+=usr/share/doc/ntp/tickadj.htm
OLD_FILES+=usr/share/doc/papers/nqnfs.ascii.gz
OLD_FILES+=usr/share/doc/papers/px.ascii.gz
OLD_FILES+=usr/share/man/man3/exp10.3.gz
OLD_FILES+=usr/share/man/man3/exp10f.3.gz
OLD_FILES+=usr/share/man/man3/fpsetsticky.3.gz
OLD_FILES+=usr/share/man/man3/gss_krb5_compat_des3_mic.3.gz
OLD_FILES+=usr/share/man/man3/gss_krb5_copy_ccache.3.gz
OLD_FILES+=usr/share/man/man3/mac_is_present_np.3.gz
OLD_FILES+=usr/share/man/man3/mbmb.3.gz
OLD_FILES+=usr/share/man/man3/setrunelocale.3.gz
OLD_FILES+=usr/share/man/man5/usbd.conf.5.gz
.if ${TARGET_ARCH} != "i386" && ${TARGET_ARCH} != "amd64"
OLD_FILES+=usr/share/man/man8/boot_i386.8.gz
.endif
.if ${TARGET_ARCH} != "powerpc" && ${TARGET_ARCH} != "powerpc64" && ${TARGET_ARCH} != "sparc64"
OLD_FILES+=usr/share/man/man8/ofwdump.8.gz
.endif
OLD_FILES+=usr/share/man/man8/mount_reiserfs.8.gz
OLD_FILES+=usr/share/man/man9/VFS_START.9.gz
OLD_FILES+=usr/share/man/man9/cpu_critical_exit.9.gz
OLD_FILES+=usr/share/man/man9/cpu_critical_enter.9.gz
OLD_FILES+=usr/share/info/annotate.info.gz
OLD_FILES+=usr/share/info/tar.info.gz
OLD_FILES+=usr/share/bsnmp/defs/tree.def
OLD_FILES+=usr/share/bsnmp/defs/mibII_tree.def
OLD_FILES+=usr/share/bsnmp/defs/netgraph_tree.def
OLD_FILES+=usr/share/bsnmp/mibs/FOKUS-MIB.txt
OLD_FILES+=usr/share/bsnmp/mibs/BEGEMOT-MIB.txt
OLD_FILES+=usr/share/bsnmp/mibs/BEGEMOT-SNMPD.txt
OLD_FILES+=usr/share/bsnmp/mibs/BEGEMOT-NETGRAPH.txt
OLD_FILES+=usr/libdata/msdosfs/iso22dos
OLD_FILES+=usr/libdata/msdosfs/iso72dos
OLD_FILES+=usr/libdata/msdosfs/koi2dos
OLD_FILES+=usr/libdata/msdosfs/koi8u2dos
# The following files are *not* obsolete, they just don't get touched at
# install, so don't add them:
#  - boot/loader.rc
#  - usr/share/tmac/man.local
#  - usr/share/tmac/mm/locale
#  - usr/share/tmac/mm/se_locale
#  - var/yp/Makefile

# 20071120: shared library version bump
OLD_LIBS+=usr/lib/libasn1.so.8
OLD_LIBS+=usr/lib/libgssapi.so.8
OLD_LIBS+=usr/lib/libgssapi_krb5.so.8
OLD_LIBS+=usr/lib/libhdb.so.8
OLD_LIBS+=usr/lib/libkadm5clnt.so.8
OLD_LIBS+=usr/lib/libkadm5srv.so.8
OLD_LIBS+=usr/lib/libkafs5.so.8
OLD_LIBS+=usr/lib/libkrb5.so.8
OLD_LIBS+=usr/lib/libobjc.so.2
OLD_LIBS+=usr/lib32/libgssapi.so.8
OLD_LIBS+=usr/lib32/libobjc.so.2
# 20070519: GCC 4.2
OLD_LIBS+=usr/lib/libg2c.a
OLD_LIBS+=usr/lib/libg2c.so
OLD_LIBS+=usr/lib/libg2c.so.2
OLD_LIBS+=usr/lib/libg2c_p.a
OLD_LIBS+=usr/lib/libgcc_pic.a
OLD_LIBS+=usr/lib32/libg2c.a
OLD_LIBS+=usr/lib32/libg2c.so
OLD_LIBS+=usr/lib32/libg2c.so.2
OLD_LIBS+=usr/lib32/libg2c_p.a
OLD_LIBS+=usr/lib32/libgcc_pic.a
# 20060729: OpenSSL 0.9.7e -> 0.9.8b upgrade
OLD_LIBS+=lib/libcrypto.so.4
OLD_LIBS+=usr/lib/libssl.so.4
OLD_LIBS+=usr/lib32/libcrypto.so.4
OLD_LIBS+=usr/lib32/libssl.so.4
# 20060521: gethostbyaddr(3) ABI change
OLD_LIBS+=usr/lib/libroken.so.8
OLD_LIBS+=lib/libatm.so.3
OLD_LIBS+=lib/libc.so.6
OLD_LIBS+=lib/libutil.so.5
OLD_LIBS+=usr/lib32/libatm.so.3
OLD_LIBS+=usr/lib32/libc.so.6
OLD_LIBS+=usr/lib32/libutil.so.5
# 20060413: shared library moved to /usr/lib
OLD_LIBS+=lib/libgpib.so.1
# 20060413: libpcap.so.4 moved to /lib/
OLD_LIBS+=usr/lib/libpcap.so.4
# 20060412: libpthread.so.2 moved to /lib/
OLD_LIBS+=usr/lib/libpthread.so.2
# 20060127: revert libdisk to static-only
OLD_LIBS+=usr/lib/libdisk.so.3
# 20051027: libc_r discontinued (removed 20101113)
OLD_LIBS+=usr/lib/libc_r.a
OLD_LIBS+=usr/lib/libc_r.so
OLD_LIBS+=usr/lib/libc_r.so.7
OLD_LIBS+=usr/lib/libc_r_p.a
OLD_LIBS+=usr/lib32/libc_r.a
OLD_LIBS+=usr/lib32/libc_r.so
OLD_LIBS+=usr/lib32/libc_r.so.7
OLD_LIBS+=usr/lib32/libc_r_p.a
# 20050722: bump for 6.0-RELEASE
OLD_LIBS+=lib/libalias.so.4
OLD_LIBS+=lib/libatm.so.2
OLD_LIBS+=lib/libbegemot.so.1
OLD_LIBS+=lib/libbsdxml.so.1
OLD_LIBS+=lib/libbsnmp.so.2
OLD_LIBS+=lib/libc.so.5
OLD_LIBS+=lib/libcam.so.2
OLD_LIBS+=lib/libcrypt.so.2
OLD_LIBS+=lib/libcrypto.so.3
OLD_LIBS+=lib/libdevstat.so.4
OLD_LIBS+=lib/libedit.so.4
OLD_LIBS+=lib/libgeom.so.2
OLD_LIBS+=lib/libgpib.so.0
OLD_LIBS+=lib/libipsec.so.1
OLD_LIBS+=lib/libipx.so.2
OLD_LIBS+=lib/libkiconv.so.1
OLD_LIBS+=lib/libkvm.so.2
OLD_LIBS+=lib/libm.so.3
OLD_LIBS+=lib/libmd.so.2
OLD_LIBS+=lib/libncurses.so.5
OLD_LIBS+=lib/libreadline.so.5
OLD_LIBS+=lib/libsbuf.so.2
OLD_LIBS+=lib/libufs.so.2
OLD_LIBS+=lib/libutil.so.4
OLD_LIBS+=lib/libz.so.2
OLD_LIBS+=usr/lib/libarchive.so.1
OLD_LIBS+=usr/lib/libasn1.so.7
OLD_LIBS+=usr/lib/libbluetooth.so.1
OLD_LIBS+=usr/lib/libbz2.so.1
OLD_LIBS+=usr/lib/libc_r.so.5
OLD_LIBS+=usr/lib/libcalendar.so.2
OLD_LIBS+=usr/lib/libcom_err.so.2
OLD_LIBS+=usr/lib/libdevinfo.so.2
OLD_LIBS+=usr/lib/libdialog.so.4
OLD_LIBS+=usr/lib/libfetch.so.3
OLD_LIBS+=usr/lib/libform.so.2
OLD_LIBS+=usr/lib/libftpio.so.5
OLD_LIBS+=usr/lib/libg2c.so.1
OLD_LIBS+=usr/lib/libgnuregex.so.2
OLD_LIBS+=usr/lib/libgssapi.so.7
OLD_LIBS+=usr/lib/libhdb.so.7
OLD_LIBS+=usr/lib/libhistory.so.5
OLD_LIBS+=usr/lib/libkadm5clnt.so.7
OLD_LIBS+=usr/lib/libkadm5srv.so.7
OLD_LIBS+=usr/lib/libkafs5.so.7
OLD_LIBS+=usr/lib/libkrb5.so.7
OLD_LIBS+=usr/lib/libmagic.so.1
OLD_LIBS+=usr/lib/libmenu.so.2
OLD_LIBS+=usr/lib/libmilter.so.2
OLD_LIBS+=usr/lib/libmp.so.4
OLD_LIBS+=usr/lib/libncp.so.1
OLD_LIBS+=usr/lib/libnetgraph.so.1
OLD_LIBS+=usr/lib/libngatm.so.1
OLD_LIBS+=usr/lib/libobjc.so.1
OLD_LIBS+=usr/lib/libopie.so.3
OLD_LIBS+=usr/lib/libpam.so.2
OLD_LIBS+=usr/lib/libpanel.so.2
OLD_LIBS+=usr/lib/libpcap.so.3
OLD_LIBS+=usr/lib/libpmc.so.2
OLD_LIBS+=usr/lib/libpthread.so.1
OLD_LIBS+=usr/lib/libradius.so.1
OLD_LIBS+=usr/lib/libroken.so.7
OLD_LIBS+=usr/lib/librpcsvc.so.2
OLD_LIBS+=usr/lib/libsdp.so.1
OLD_LIBS+=usr/lib/libsmb.so.1
OLD_LIBS+=usr/lib/libssh.so.2
OLD_LIBS+=usr/lib/libssl.so.3
OLD_LIBS+=usr/lib/libstdc++.so.4
OLD_LIBS+=usr/lib/libtacplus.so.1
OLD_LIBS+=usr/lib/libthr.so.1
OLD_LIBS+=usr/lib/libthread_db.so.1
OLD_LIBS+=usr/lib/libugidfw.so.1
OLD_LIBS+=usr/lib/libusbhid.so.1
OLD_LIBS+=usr/lib/libvgl.so.3
OLD_LIBS+=usr/lib/libwrap.so.3
OLD_LIBS+=usr/lib/libypclnt.so.1
OLD_LIBS+=usr/lib/pam_chroot.so.2
OLD_LIBS+=usr/lib/pam_deny.so.2
OLD_LIBS+=usr/lib/pam_echo.so.2
OLD_LIBS+=usr/lib/pam_exec.so.2
OLD_LIBS+=usr/lib/pam_ftpusers.so.2
OLD_LIBS+=usr/lib/pam_group.so.2
OLD_LIBS+=usr/lib/pam_guest.so.2
OLD_LIBS+=usr/lib/pam_krb5.so.2
OLD_LIBS+=usr/lib/pam_ksu.so.2
OLD_LIBS+=usr/lib/pam_lastlog.so.2
OLD_LIBS+=usr/lib/pam_login_access.so.2
OLD_LIBS+=usr/lib/pam_nologin.so.2
OLD_LIBS+=usr/lib/pam_opie.so.2
OLD_LIBS+=usr/lib/pam_opieaccess.so.2
OLD_LIBS+=usr/lib/pam_passwdqc.so.2
OLD_LIBS+=usr/lib/pam_permit.so.2
OLD_LIBS+=usr/lib/pam_radius.so.2
OLD_LIBS+=usr/lib/pam_rhosts.so.2
OLD_LIBS+=usr/lib/pam_rootok.so.2
OLD_LIBS+=usr/lib/pam_securetty.so.2
OLD_LIBS+=usr/lib/pam_self.so.2
OLD_LIBS+=usr/lib/pam_ssh.so.2
OLD_LIBS+=usr/lib/pam_tacplus.so.2
OLD_LIBS+=usr/lib/pam_unix.so.2
OLD_LIBS+=usr/lib/snmp_atm.so.3
OLD_LIBS+=usr/lib/snmp_mibII.so.3
OLD_LIBS+=usr/lib/snmp_netgraph.so.3
OLD_LIBS+=usr/lib/snmp_pf.so.3
# 200505XX: ?
OLD_LIBS+=usr/lib/snmp_atm.so.2
OLD_LIBS+=usr/lib/snmp_mibII.so.2
OLD_LIBS+=usr/lib/snmp_netgraph.so.2
OLD_LIBS+=usr/lib/snmp_pf.so.2
# 2005XXXX: not ready for primetime yet
OLD_LIBS+=usr/lib/libautofs.so.1
# 200411XX: libxpg4 removal
OLD_LIBS+=usr/lib/libxpg4.so.3
# 200410XX: libm compatibility fix
OLD_LIBS+=lib/libm.so.2
# 20041001: version bump
OLD_LIBS+=lib/libreadline.so.4
OLD_LIBS+=usr/lib/libhistory.so.4
OLD_LIBS+=usr/lib/libopie.so.2
OLD_LIBS+=usr/lib/libpcap.so.2
# 20040925: bind9 import
OLD_LIBS+=usr/lib/libisc.so.1
# 200408XX
OLD_LIBS+=usr/lib/snmp_netgraph.so.1
# 200404XX
OLD_LIBS+=usr/lib/libsnmp.so.1
OLD_LIBS+=usr/lib/snmp_mibII.so.1
# 200309XX
OLD_LIBS+=usr/lib/libasn1.so.6
OLD_LIBS+=usr/lib/libhdb.so.6
OLD_LIBS+=usr/lib/libkadm5clnt.so.6
OLD_LIBS+=usr/lib/libkadm5srv.so.6
OLD_LIBS+=usr/lib/libkrb5.so.6
OLD_LIBS+=usr/lib/libroken.so.6
# 200304XX
OLD_LIBS+=usr/lib/libc.so.4
OLD_LIBS+=usr/lib/libc_r.so.4
OLD_LIBS+=usr/lib/libdevstat.so.2
OLD_LIBS+=usr/lib/libedit.so.3
OLD_LIBS+=usr/lib/libgmp.so.3
OLD_LIBS+=usr/lib/libmp.so.3
OLD_LIBS+=usr/lib/libpam.so.1
OLD_LIBS+=usr/lib/libposix1e.so.2
OLD_LIBS+=usr/lib/libskey.so.2
OLD_LIBS+=usr/lib/libusbhid.so.0
OLD_LIBS+=usr/lib/libvgl.so.2
# 20030218: OpenSSL 0.9.7 import
OLD_FILES+=usr/include/des.h
OLD_FILES+=usr/lib/libdes.a
OLD_FILES+=usr/lib/libdes.so
OLD_LIBS+=usr/lib/libdes.so.3
OLD_FILES+=usr/lib/libdes_p.a
# 200302XX
OLD_LIBS+=usr/lib/libacl.so.3
OLD_LIBS+=usr/lib/libasn1.so.5
OLD_LIBS+=usr/lib/libcrypto.so.2
OLD_LIBS+=usr/lib/libgssapi.so.5
OLD_LIBS+=usr/lib/libhdb.so.5
OLD_LIBS+=usr/lib/libkadm.so.3
OLD_LIBS+=usr/lib/libkadm5clnt.so.5
OLD_LIBS+=usr/lib/libkadm5srv.so.5
OLD_LIBS+=usr/lib/libkafs.so.3
OLD_LIBS+=usr/lib/libkafs5.so.5
OLD_LIBS+=usr/lib/libkdb.so.3
OLD_LIBS+=usr/lib/libkrb.so.3
OLD_LIBS+=usr/lib/libroken.so.
OLD_LIBS+=usr/lib/libssl.so.2
OLD_LIBS+=usr/lib/pam_kerberosIV.so
# 200208XX
OLD_LIBS+=usr/lib/libgssapi.so.4
# 200203XX
OLD_LIBS+=usr/lib/libss.so.3
OLD_LIBS+=usr/lib/libusb.so.0
# 200112XX
OLD_LIBS+=usr/lib/libfetch.so.2
# 200110XX
OLD_LIBS+=usr/lib/libgssapi.so.3
# 200104XX
OLD_LIBS+=usr/lib/libdescrypt.so.2
OLD_LIBS+=usr/lib/libscrypt.so.2
# 200102XX
OLD_LIBS+=usr/lib/libcrypto.so.1
OLD_LIBS+=usr/lib/libssl.so.1
# 200009XX
OLD_LIBS+=usr/lib/libRSAglue.so.1
OLD_LIBS+=usr/lib/librsaINTL.so.1
OLD_LIBS+=usr/lib/librsaUSA.so.1
# 200006XX
OLD_LIBS+=usr/lib/libalias.so.3
OLD_LIBS+=usr/lib/libfetch.so.1
OLD_LIBS+=usr/lib/libipsec.so.0
# 200005XX
OLD_LIBS+=usr/lib/libxpg4.so.2
# 200002XX
OLD_LIBS+=usr/lib/libc.so.3
OLD_LIBS+=usr/lib/libcurses.so.2
OLD_LIBS+=usr/lib/libdialog.so.3
OLD_LIBS+=usr/lib/libedit.so.2
OLD_LIBS+=usr/lib/libf2c.so.2
OLD_LIBS+=usr/lib/libftpio.so.4
OLD_LIBS+=usr/lib/libg++.so.4
OLD_LIBS+=usr/lib/libhistory.so.3
OLD_LIBS+=usr/lib/libmytinfo.so.2
OLD_LIBS+=usr/lib/libncurses.so.3
OLD_LIBS+=usr/lib/libreadline.so.3
OLD_LIBS+=usr/lib/libss.so.2
OLD_LIBS+=usr/lib/libtermcap.so.2
OLD_LIBS+=usr/lib/libutil.so.2
OLD_LIBS+=usr/lib/libvgl.so.1
OLD_LIBS+=usr/lib/libwrap.so.2
# 19991216
OLD_FILES+=usr/sbin/xntpdc
# 199909XX
OLD_LIBS+=usr/lib/libc_r.so.3
# ???
OLD_LIBS+=usr/lib/libarchive.so.2
OLD_LIBS+=usr/lib/libbsnmp.so.1
OLD_LIBS+=usr/lib/libc_r.so.6
OLD_LIBS+=usr/lib32/libarchive.so.2
OLD_LIBS+=usr/lib32/libc_r.so.6
OLD_LIBS+=usr/lib/libcipher.so.2
OLD_LIBS+=usr/lib/libgssapi.so.6
OLD_LIBS+=usr/lib/libkse.so.1
OLD_LIBS+=usr/lib/liblwres.so.3
OLD_LIBS+=usr/lib/pam_ftp.so.2

# 20131013: Removal of the ATF tools
OLD_DIRS+=etc/atf
OLD_DIRS+=usr/share/examples/atf
OLD_DIRS+=usr/share/xml/atf
OLD_DIRS+=usr/share/xml
OLD_DIRS+=usr/share/xsl/atf
OLD_DIRS+=usr/share/xsl
# 20040925: bind9 import
OLD_DIRS+=usr/share/doc/bind/html
OLD_DIRS+=usr/share/doc/bind/misc
OLD_DIRS+=usr/share/doc/bind/
# ???
OLD_DIRS+=usr/include/g++/std
OLD_DIRS+=usr/include/msdosfs
OLD_DIRS+=usr/include/ntfs
OLD_DIRS+=usr/include/nwfs
OLD_DIRS+=usr/include/ufs/mfs
# 20011001: UUCP migration to ports
OLD_DIRS+=usr/libexec/uucp


.include "tools/build/mk/OptionalObsoleteFiles.inc"
