# -*- coding: utf-8 -*-
from setuptools import setup

setup(
    name='ipyparallel',
    version='%%PORTVERSION%%',
    description='Interactive Parallel Computing with IPython',
    long_description='# Interactive Parallel Computing with IPython\n\nIPython Parallel (`ipyparallel`) is a Python package and collection of CLI scripts for controlling clusters of IPython processes, built on the Jupyter protocol.\n\nIPython Parallel provides the following commands:\n\n- ipcluster - start/stop/list clusters\n- ipcontroller - start a controller\n- ipengine - start an engine\n\n## Install\n\nInstall IPython Parallel:\n\n    pip install ipyparallel\n\nThis will install and enable the IPython Parallel extensions\nfor Jupyter Notebook and (as of 7.0) Jupyter Lab 3.0.\n\n## Run\n\nStart a cluster:\n\n    ipcluster start\n\nUse it from Python:\n\n```python\nimport os\nimport ipyparallel as ipp\n\ncluster = ipp.Cluster(n=4)\nwith cluster as rc:\n    ar = rc[:].apply_async(os.getpid)\n    pid_map = ar.get_dict()\n```\n\nSee [the docs](https://ipyparallel.readthedocs.io) for more info.\n',
    author_email='IPython Development Team <ipython-dev@scipy.org>',
    classifiers=[
        'Framework :: Jupyter',
        'Framework :: Jupyter :: JupyterLab',
        'Framework :: Jupyter :: JupyterLab :: 3',
        'Framework :: Jupyter :: JupyterLab :: Extensions',
        'Framework :: Jupyter :: JupyterLab :: Extensions :: Prebuilt',
        'Intended Audience :: Developers',
        'Intended Audience :: Science/Research',
        'Intended Audience :: System Administrators',
        'License :: OSI Approved :: BSD License',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
    ],
    install_requires=[
        'decorator',
        'entrypoints',
        'ipykernel>=4.4',
        'ipython>=4',
        'jupyter-client',
        'psutil',
        'python-dateutil>=2.1',
        'pyzmq>=18',
        'tornado>=5.1',
        'tqdm',
        'traitlets>=4.3',
    ],
    extras_require={
        'benchmark': [
            'asv',
        ],
        'labextension': [
            'jupyter-server',
            'jupyterlab>=3',
        ],
        'nbext': [
            'jupyter-server',
            'notebook',
        ],
        'retroextension': [
            'jupyter-server',
            'retrolab',
        ],
        'serverextension': [
            'jupyter-server',
        ],
        'test': [
            'ipython[test]',
            'pytest',
            'pytest-asyncio',
            'pytest-cov',
            'testpath',
        ],
    },
    entry_points={
        'console_scripts': [
            'ipcluster = ipyparallel.cluster.app:main',
            'ipcontroller = ipyparallel.controller.app:main',
            'ipengine = ipyparallel.engine.app:main',
        ],
        'ipyparallel.controller_launchers': [
            'batch = ipyparallel.cluster.launcher:BatchControllerLauncher',
            'htcondor = ipyparallel.cluster.launcher:HTCondorControllerLauncher',
            'local = ipyparallel.cluster.launcher:LocalControllerLauncher',
            'lsf = ipyparallel.cluster.launcher:LSFControllerLauncher',
            'mpi = ipyparallel.cluster.launcher:MPIControllerLauncher',
            'pbs = ipyparallel.cluster.launcher:PBSControllerLauncher',
            'sge = ipyparallel.cluster.launcher:SGEControllerLauncher',
            'slurm = ipyparallel.cluster.launcher:SlurmControllerLauncher',
            'ssh = ipyparallel.cluster.launcher:SSHControllerLauncher',
            'winhpc = ipyparallel.cluster.launcher:WindowsHPCControllerLauncher',
        ],
        'ipyparallel.engine_launchers': [
            'batch = ipyparallel.cluster.launcher:BatchEngineSetLauncher',
            'htcondor = ipyparallel.cluster.launcher:HTCondorEngineSetLauncher',
            'local = ipyparallel.cluster.launcher:LocalEngineSetLauncher',
            'lsf = ipyparallel.cluster.launcher:LSFEngineSetLauncher',
            'mpi = ipyparallel.cluster.launcher:MPIEngineSetLauncher',
            'pbs = ipyparallel.cluster.launcher:PBSEngineSetLauncher',
            'sge = ipyparallel.cluster.launcher:SGEEngineSetLauncher',
            'slurm = ipyparallel.cluster.launcher:SlurmEngineSetLauncher',
            'ssh = ipyparallel.cluster.launcher:SSHEngineSetLauncher',
            'sshproxy = ipyparallel.cluster.launcher:SSHProxyEngineSetLauncher',
            'winhpc = ipyparallel.cluster.launcher:WindowsHPCEngineSetLauncher',
        ],
    },
    packages=[
        'benchmarks.benchmarks',
        'benchmarks.profiling',
        'ipyparallel',
        'ipyparallel.apps',
        'ipyparallel.client',
        'ipyparallel.cluster',
        'ipyparallel.controller',
        'ipyparallel.engine',
        'ipyparallel.nbextension',
        'ipyparallel.serialize',
        'ipyparallel.tests',
    ],
)
