.TH @PROGRAM@ 1 "15 Mar 1994"
.SH NAME
@PROGRAM@ - Print the @LEAGUE@ schedule
.SH SYNOPSIS
@PROGRAM@
[\-n\fInum\fP] [\-HAhv]
[TEAM|DIV\ [TEAM|DIV]]
[mm/dd\ ...]
.SH DESCRIPTION
.PP
This program produces an on-line schedule for the @LEAGUE@ regular season.
Perfect for that .login -- also makes a great Xmas gift!
.PP
With no teams or divisions specified,
.I @PROGRAM@
prints the league schedule for the given dates. If no dates are given
then today's schedule is printed.
.PP
With one team or division specified,
.I @PROGRAM@
prints upcoming games for that team or for teams in that division,
starting from each of the given dates (or from today if none are
given).
.PP
With two teams or divisions specified,
.I @PROGRAM@
prints upcoming games where the first team (or any team in the first
division) plays the second team (or any team in second division),
starting from each of the given dates (or from today if none are
given).
.PP
Note that to get a listing of upcoming intra-division games you need
to give the division twice (i.e., use two-team mode).  If the division
is only given once, then
.I @PROGRAM@
will list games in which either team was in the division, not
necessarily both.
.SH DIAGNOSTICS
.PP
If no dates are given and today's date isn't during the season, a
warning is issued to stderr and the start of the season is used.
.PP
If a date is explicitly given that isn't during the season, an error
message is printed (to stdout) and
.I @PROGRAM@
exits.
.PP
Errors involving incorrect team or division codes, bad dates, or other
command-line errors cause the help text to be printed and
.I @PROGRAM@
exits with an error indication.
.PP
Any other errors (marked with "YOW!")  indicate that the program was
not properly configured for the season.  You shouldn't see these
unless you try to update
.I @PROGRAM@
for a new season.
.SH OPTIONS
.IP \fB-n\fInum\fR
Set the number of games to display in one-team or two-team mode. The
default is 3.
.IP \fB-t\fIteam\fR
Teams can specified with or without a leading \fB-t\fP. A list of team
codes is printed by running
.I @PROGRAM@
with the "-help" option.

.IP \fB-d\fIdiv\fR
Divisions can specified with or without a leading \fI-d\fP. A list of
division codes is printed by running
.I @PROGRAM@
with the "-help" option.

.IP \fB-H\fR
In one-team (or division) mode, specifies that only games in which the
given team (or team in the given division) is at home are to be
printed.  In two-team (or division) mode, specifies that only games in
which the \fIfirst\fP team (or team in first division) is at home are
to be printed. This option is ignored when the same divison is given
twice (intra-division mode).
.IP \fB-A\fR
Like \fB-H\fP, but only prints away games for the given team (or team
in the given division).
.IP \fB-h\fR
If given,
.I @PROGRAM@
prints the help message and exits.
.IP \fB-v\fR
If given,
.I @PROGRAM@
prints its version information and exits. Please use this information
when reporting bugs.
.SH AUTHOR
.PP
Original program concept by Len Carr, used with permission.
.PP
All other features created by Rob Springall (rgs7077@ultb.isc.rit.edu,
rgs7077@ritvax.bitnet), except for the neutral site games feature,
created by Tom Wilson (twilson@dab.ge.com).
.PP
Maintained through 1992-93 season by: Valerie Hammerl
(hammerl@acsu.buffalo.edu) and Rob Springall.
.PP
Re-constructed for 1993-94 by George Ferguson
(ferguson@cs.rochester.edu), who also added head-to-head modes, wrote
the manpage and put together the distribution kit.
.PP
Generalized from an NHL-only program to one that can be compiled to
provide schedules for multiple leagues by George Ferguson.
.PP
Additional credit goes to the members of the USENET community who
contributed ideas and support for this project.
.SH COPYRIGHT
This program is not copyrighted or registered in any form.  It does,
however, remain the intellectual property of its authors.

