/*
 * nhl.93-94.c : NHL Schedule for 1993-94 season
 *
 * Compiled by George Ferguson, ferguson@cs.rochester.edu, 20 Aug 1993.
 *
 * This file defines the teams, the schedule matrix, and special dates.
 * It is the only file you should have to change for a new season.
 *
 * See the file UPDATING for instructions on updating this for a
 * new season.
 *
 * This file is included directly by schedule.c. Don't bug me about it...
 */
/*
  1993-94 schedule data and beta testing by:
    Joseph Charles Ashkar <jca2@cec1.wustl.edu>
    Michael Collingridge <colling@ann-arbor.applicon.slb.com>
    John P. Curcio <jpc@philabs.philips.com>
    Mike (M.D.) D'Amico <miked77@bnr.ca>
    Valerie S. Hammerl <hammerl@acsu.buffalo.edu>
    Richard Hildebrand <rhh@tarheel.math.ufl.edu>
    Mark Holoubek <af042@Freenet.carleton.ca>
    Lori Iannamico <lli+@cs.cmu.edu>
    Mark Irwin <irwin@galton.uchicago.edu>
    Garry Knox <knox@monster.umd.edu>
    Carl J. Lunenfeld <lunenfcj@duvm.ocs.drexel.edu>
    Patrick MacRoberts <macro@hpcobr30.cup.hp.com>
    Kris Myers <kris@fs2.assist.uci.edu>
    David A. Ondzes <dao@scribe.mitre.org>
    John Michael Santore <jsbh+@andrew.cmu.edu>
    Andrew Scott <andrew@idacom.hp.com>
    Scott Simpson <simpson@bnr.ca>
    <diqman@ufcc.ufl.edu>
    <seth@hos1cad.att.com>
*/

/*
 * Set this to something informative about the league and season
 * represented by this file. It is used for the -v option.
 */
#define VERSION_SEASON  "NHL 93-94"
#define VERSION_ENTERER "ferguson@cs.rochester.edu"

/*
 * Set these to the starting and ending dates of the season.
 * They have to be strings (ie., enclosed in double-quotes) and
 * should be in form MM/DD/YYYY (the year must be all four digits).
 * The START_DOW should be a capitalized string representing the
 * day-of-the-week for the START_DATE. Check weekday[] in nhl.c for spelling.
 */
#define START_DATE		"10/5/1993"
#define START_DOW		"Tuesday"
#define END_DATE		"4/14/1994"

/*
 * The list of teams referenced by the schedule[] array.
 */
#define NUM_TEAMS 26

struct _team_struct {
    char *city;					/* City name for team */
    char *name;					/* Team nickname */
    char *abbrev;				/* Team code for cmd-line */
} teams[NUM_TEAMS] = {
    { "Anaheim",	"Mighty Ducks",	"ana" },
    { "Boston",		"Bruins",	"bos" },
    { "Buffalo",	"Sabres",	"buf" },
    { "Calgary",	"Flames",	"cgy" },
    { "Chicago",	"Blackhawks",	"chi" },
    { "Dallas",		"Stars",	"dal" },
    { "Detroit",	"Red Wings",	"det" },
    { "Edmonton",	"Oilers",	"edm" },
    { "Florida",	"Panthers",	"fla" },
    { "Hartford",	"Whalers",	"hfd" },
    { "Los Angeles",	"Kings",	"los" },
    { "Montreal",	"Canadiens",	"mtl" },
    { "New Jersey",	"Devils",	"njd" },
    { "NY Islanders",	"Islanders",	"nyi" },
    { "NY Rangers",	"Rangers",	"nyr" },
    { "Ottawa",		"Senators",	"ott" },
    { "Philadelphia",	"Flyers",	"phl" },
    { "Pittsburgh",	"Penguins",	"pit" },
    { "Quebec",		"Nordiques",	"que" },
    { "St. Louis",	"Blues",	"stl" },
    { "San Jose",	"Sharks",	"sjs" },
    { "Tampa Bay",	"Lightning",	"tmp" },
    { "Toronto",	"Maple Leafs",	"tor" },
    { "Vancouver",	"Canucks",	"van" },
    { "Washington",	"Capitals",	"wsh" },
    { "Winnipeg",	"Jets",		"wpg" },
};

#define NUM_DIVISIONS 4
#define MAX_TEAMS_PER_DIVISION 7

struct _division_struct {
    char *name;					/* Division name */
    char *teams[MAX_TEAMS_PER_DIVISION];	/* List of team abbrevs */
    char *abbrev;				/* Division abbrev */
    char flags[NUM_TEAMS];			/* Array of flags for teams */
} divisions[NUM_DIVISIONS] = {
    { "Northeast", { "bos","buf","hfd","mtl","ott","pit","que" }, "nea" },
    { "Atlantic",  { "fla","njd","nyi","nyr","phl","tmp","wsh" }, "atl" },
    { "Central",   { "chi","det","dal","stl","tor","wpg",NULL },  "ctl" },
    { "Pacific",   { "ana","cgy","edm","los","sjs","van",NULL },  "pac" },
};

/*
 * Special dates for which there are no games this season:
 */
struct _special_struct {
    int month,day;					/* Date */
    char *text;						/* Message to print */
} special_dates[] = {
    { 12, 24, "Holiday Break" },
    { 12, 25, "Holiday Break" },
    {  1, 20, "All Star Break" },
    {  1, 21, "All Star Break" },
    {  1, 22, "All Star Game in New York City" },
    {  1, 23, "All Star Break" },
    {  0,  0, NULL },
};

/*
 * The list of home team extra info referenced in the schedule[] array
 */
char *extra_info[] = {
    "@ Cleveland, OH",
    "@ Halifax, NS",
    "@ Hamilton, ON",
    "@ Minneapolis, MN",
    "@ Orlando, FL",
    "@ Phoenix, AZ",
    "@ Sacramento, CA",
    "@ Saskatoon, SK",
};

/*
 * Schedule matrix:
 *   Each string represents one day of the season, The Nth character in
 *   the string represents what the Nth team (in the teams[] array) is
 *   doing on that day. The entries are interpreted as follows:
 *	-   : This team is idle
 *	+   : This team is home
 *	a-z : This team is away at the team given by the letter
 *	A-H : Team is the home team and extra_info corresponding to the
 *	      letter applies to the game.
 *
 *   Accessors are defined here for accessing the array. The accessors have
 *   to map from the characters used in schedule[] into the teams[] and
 *   extra_info[] arrays. They needn't be contiguous, but it makes life
 *   easier if they are.
 */

#define ISIDLECODE(C)		((C) == '-')
#define ISHOMECODE(C)		((C) == '+')
#define ISAWAYCODE(C)		((C) >= 'a' && (C) <= 'z')
#define ISINFOCODE(C)		((C) >= 'A' && (C) <= 'H')

#define TEAMCODETOINDEX(C)	((int)((C) - 'a'))
#define INDEXTOTEAMCODE(N)	((char)((N) + 'a'))

#define INFOCODETOINDEX(C)	((int)((C) - 'A'))
#define INDEXTOINFOCODE(N)	((char)((N) + 'A'))

char *schedule[] = {
    "-o-+-+f------d+-+q--------", /* 10/5  */
    "----+--+el+++--+--p-hm-kz+", /* 10/6  */
    "-+b+-w--t--r--+--+-+do+---", /* 10/7  */
    "+-----a+----yh----------+-", /* 10/8  */
    "-+lxw+k-v++++-rtj+b+-+++mf", /* 10/9  */
    "+-+-+----c+--a--+s+-k-q--e", /* 10/10 */
    "-+-----x---b--+--------+o-", /* 10/11 */
    "--q-f+--+-+-+k--+i-------m", /* 10/12 */
    "+-----+a-+-j--+---og--+-w-", /* 10/13 */
    "---u+--k+e+----i-v--++----", /* 10/14 */
    "+a+---w-------c-y-----+-+-", /* 10/15 */
    "-uykz+++-r++n+qv++lf++gh++", /* 10/16 */
    "+--a----+------------i----", /* 10/17 */
    "--+-+ecz---s------+------+", /* 10/18 */
    "ox------+wi--++--n-u+-++--", /* 10/19 */
    "m--h-l-+-+v++-----j--+----", /* 10/20 */
    "---++p+-+----q-++-eGt-id-g", /* 10/21 */
    "-h+----+--y---v--c---+--+-", /* 10/22 */
    "ldj++se-m+-+++-n+++r++vu-q", /* 10/23 */
    "-------+--o---+-----x--+h-", /* 10/24 */
    "p--+-g+--------+--------d-", /* 10/25 */
    "----+--u+-nm++--s-+e+----i", /* 10/26 */
    "--d+-++--fg----+p----+-+xv", /* 10/27 */
    "u+--+---+t-o-i+b-+r++-e---", /* 10/28 */
    "+-h----+--z--v-------+--a+", /* 10/29 */
    "-+x+r+sd++-++-jfm++b+il+u-", /* 10/30 */
    "+--z+-------o-B-e---a----+", /* 10/31 */
    "-----+---+---------j--f---", /* 11/1  */
    "-g----+-+----+--iu+-+s-n--", /* 11/2  */
    "+-Gj-a-+w+++k-+h-c-z-l+o-+", /* 11/3  */
    "-+-b+-+------e--+-q---g---", /* 11/4  */
    "+----u------a--z----+--y++", /* 11/5  */
    "-+-l---t-n++-+s-wk++-b+---", /* 11/6  */
    "+c+-++-es---u---+a+-+--q-f", /* 11/7  */
    "--------------+------o----", /* 11/8  */
    "F--+-a+g--d--+---ty++-u-+n", /* 11/9  */
    "--+-----l+x++m+jc------+-o", /* 11/10 */
    "d+-+++-bp---q--++e-+f+t-v-", /* 11/11 */
    "--------------------------", /* 11/12 */
    "-nq+wzrj-+++++yl++vkm++d++", /* 11/13 */
    "x---+e--+-----+---i-o--+--", /* 11/14 */
    "---+---w---p---+------+--d", /* 11/15 */
    "--------+-----i-r+-xy--++-", /* 11/16 */
    "+jm--+zl-+-++p-+-----fa--+", /* 11/17 */
    "-+-ti---+q+Cpl-+++-+b-k-r-", /* 11/18 */
    "x-+-----------v------+-+-c", /* 11/19 */
    "-+-fv+m+++t++---bl++j+h-is", /* 11/20 */
    "h-+--+t+--f--q--+--+c-----", /* 11/21 */
    "d-p+-----------+------x+--", /* 11/22 */
    "------u-+i-os-+---+-+-----", /* 11/23 */
    "zr++h+x+-v-qcfp+++-y-+d+++", /* 11/24 */
    "----------s-------+-------", /* 11/25 */
    "++++d---b---t--c+y-+aq-z++", /* 11/26 */
    "uws--g++j+l+-+nrv++-+++h--", /* 11/27 */
    "------n------++----+----ot", /* 11/28 */
    "--w-xh-+-p-----+------++--", /* 11/29 */
    "-s-+-d----+-++m---+-----nk", /* 11/30 */
    "+-v---j+-+-+---lh--w-++--a", /* 12/1  */
    "k+i-----+-+-rb--x+-+--t+--", /* 12/2  */
    "------+----y-+-g--n-+---+u", /* 12/3  */
    "-+-+mt---++b+-w+dj++-k+sp-", /* 12/4  */
    "+c+--+zfu---o-+-----+a---+", /* 12/5  */
    "---p--+----+---+-------l-g", /* 12/6  */
    "+--st--nay---+----+++u--+-", /* 12/7  */
    "--p--+-ok+++l-++-f----+j-w", /* 12/8  */
    "-+---D+-----+--f+-mg---bq-", /* 12/9  */
    "--+c----z----------------+", /* 12/10 */
    "-+jwb-+m-+++++-snv+kg++-l-", /* 12/11 */
    "++--++-qfb------+--ae-z--+", /* 12/12 */
    "--o-------p---++--+-----s-", /* 12/13 */
    "g--+--+---rvn+---+---E-d--", /* 12/14 */
    "wm--f+-++o-i+-+v---u+++h--", /* 12/15 */
    "--r-------------++q-------", /* 12/16 */
    "f-++-+++--c--+gy---dh-n++x", /* 12/17 */
    "-v-+q-l--+w+s---+-+--++-jd", /* 12/18 */
    "ei+-+x-++---+r+om++hsc-+--", /* 12/19 */
    "z--+------d--------------+", /* 12/20 */
    "----g-+x-------+++p--r-+q-", /* 12/21 */
    "+--h-a-+++-+jli-----w-+---", /* 12/22 */
    "-++x+kq--p+c+-y++bz+etmH++", /* 12/23 */
    "--------------------------", /* 12/24 */
    "--------------------------", /* 12/25 */
    "+-n-t---v+a-o++j-y-+-E--+-", /* 12/26 */
    "-p+-++f+---t---+c--+--e--h", /* 12/27 */
    "n--u----ym+-++--r++-+s-k+-", /* 12/28 */
    "----z+-+j+-h-st---++--f--+", /* 12/29 */
    "y--+---d-------+-----p--+-", /* 12/30 */
    "-D+++e+---gd--c-b+rzx--+-+", /* 12/31 */
    "i-------+nw-p+-+-----y+-+-", /*  1/1  */
    "v++t++-+-+-x-----jf+hEc+be", /*  1/2  */
    "--------o-----++-p--------", /*  1/3  */
    "----f+t---+u+m----k++wC---", /*  1/4  */
    "---o-----+-s--++--F----p-j", /*  1/5  */
    "e+--++u--A-----wf--j+-+--b", /*  1/6  */
    "--+n---+m---++---ch-------", /*  1/7  */
    "t+-ry-k-b+++-jl+v+-+-++w+p", /*  1/8  */
    "--+-++-e----+------f---cm-", /*  1/9  */
    "++----a----+-p++-----ob--l", /*  1/10 */
    "-re+++-f--u----q++d-+-y-+-", /*  1/11 */
    "+-z---+--k++l-----x-ag-+-+", /*  1/12 */
    "-q--+w-tr-------++-+-e+---", /*  1/13 */
    "+----g+--a-ny++xo------++-", /*  1/14 */
    "-+t+n-brlum+++-d-++++-z-s+", /*  1/15 */
    "+-f-++----q---e-+----z-a-+", /*  1/16 */
    "-+-u--v-nb-+-+------+D--l-", /*  1/17 */
    "w----+-p--f---++-s+o--+---", /*  1/18 */
    "gl+x--+c++-+zv--+--q-+j+i+", /*  1/19 */
    "--------------------------", /*  1/20 */
    "--------------------------", /*  1/21 */
    "--------------------------", /*  1/22 */
    "--------------------------", /*  1/23 */
    "+jvF-+-H++dif------a-E-h--", /*  1/24 */
    "-y--g-+---+---urs++x+--++k", /*  1/25 */
    "+--+-d-+v+-jhw-------++--a", /*  1/26 */
    "--+-+xe--p+---k+-+r----+c-", /*  1/27 */
    "+n-+---++---d+a----hi-----", /*  1/28 */
    "k+l++h++-+++xb-e+wjdv+++qg", /*  1/29 */
    "--+---y-c--+----l-------+-", /*  1/30 */
    "-+--p-----x---++-ob----+--", /*  1/31 */
    "--------rs---+---+++n-t---", /*  2/1  */
    "+-maxzv+plh++o++A----+-+q+", /*  2/2  */
    "-+------------b-+-t+q-----", /*  2/3  */
    "+-i-h-+++z-y+--m-g-----a++", /*  2/4  */
    "-+-k--w---+p+s-+bm++ty+-+-", /*  2/5  */
    "+i+-a+-++x---c------f--+-h", /*  2/6  */
    "---+---d---r--+--+---w+-o-", /*  2/7  */
    "-sn-u-+------+-+p-++G--g-t", /*  2/8  */
    "---hk+-+--++--l----------f", /*  2/9  */
    "-+b-----q---+r-+++-+-p-mt-", /*  2/10 */
    "+-++u-+--dac--+-g-o-+-z--+", /*  2/11 */
    "-+-+-rt+nh++b+p+-+l+-+dvk-", /*  2/12 */
    "h-+-uc-++---v---+q--++-i--", /*  2/13 */
    "-k-+d-----+---s---+-------", /*  2/14 */
    "------wy-----+--u+-++n+t+r", /*  2/15 */
    "+fj--++-g+------a---------", /*  2/16 */
    "----+----r-vw----+u-+++e--", /*  2/17 */
    "+t+fz++gc-+--y+ok-a+----++", /*  2/18 */
    "-------w-+u+++jn-l--+m+---", /*  2/19 */
    "tvyz+-i-+---e------+-+--++", /*  2/20 */
    "--+--u----+q-++-+oc-+-k-n-", /*  2/21 */
    "---x----z--------------+-C", /*  2/22 */
    "co+--k++--++g-+-----l-h---", /*  2/23 */
    "r--++-A-+g--+qm++++spd--ie", /*  2/24 */
    "-z+-c--+--h--+--n--------+", /*  2/25 */
    "s-r+-++-y+dwj-f+-++pgx+++-", /*  2/26 */
    "-e--+--+-+---+----n--h--j-", /*  2/27 */
    "--------+-+k+--+-i-mz-p--+", /*  2/28 */
    "--sg--+x-----+----+n-y-++-", /*  3/1  */
    "+-p--z--++jai-++o--------+", /*  3/2  */
    "-+-e+--u--b-v------+++-t--", /*  3/3  */
    "+-+--++a+i---o+Dyc----gf+p", /*  3/4  */
    "-+-m-----v--++nb--+--+s---", /*  3/5  */
    "u-gy+++---ef----vz--++--++", /*  3/6  */
    "-+----o-x---+z+---mw--++b+", /*  3/7  */
    "eru-Fq---------s+++-+-----", /*  3/8  */
    "+-a+kwd+h+++-xy----l-j++B-", /*  3/9  */
    "-+-------m-s+ubq+++-+-r---", /*  3/10 */
    "+--+a-h+d--------------z-+", /*  3/11 */
    "-mk+-j---++++tr-l+y+d-+-+w", /*  3/12 */
    "+---+m---+--+--a+j---q-e--", /*  3/13 */
    "-l--s---+--+--i---+-------", /*  3/14 */
    "---v--+---+-n+-k-+---+-gr-", /*  3/15 */
    "+--il--v+oa+--+----z-++w-+", /*  3/16 */
    "-++---+--s--cg-u-b+-+-----", /*  3/17 */
    "--n-o+-i+----D+----w--+-f-", /*  3/18 */
    "-+----z--q++b---++l-k--r-+", /*  3/19 */
    "--+w++-s+-u--+-cin+e+E+fv-", /*  3/20 */
    "--------+---i-------------", /*  3/21 */
    "fs-+g++--y---+d-t+++rn--+-", /*  3/22 */
    "--+---p+C-+z--h+---c--ik-+", /*  3/23 */
    "b+--+---q--e+--r++--wm+---", /*  3/24 */
    "--+--t++-ch---x----+z--+g+", /*  3/25 */
    "j+-+----n+-b++--mdw---+---", /*  3/26 */
    "qy+-+ve+--x-Dcz-+hm+t+-+++", /*  3/27 */
    "-----i--+--+---l------x+--", /*  3/28 */
    "------+--g-m+yq-+---+---+u", /*  3/29 */
    "k-+-j---+++----+-xpi-c-+--", /*  3/30 */
    "++-q+b+a--------+-g-+-u-e-", /*  3/31 */
    "-c+--o-----ny++----v-+-++x", /*  4/1  */
    "+-sg--+k+++++lmij-+-+-au--", /*  4/2  */
    "-r-e+y+k--G------A-g----+-", /*  4/3  */
    "--------o-----+-z+---r---+", /*  4/4  */
    "----t+x-s-+--y----++k-f++-", /*  4/5  */
    "d--+---z-+-+rj-+-+---l--p+", /*  4/6  */
    "-+------qst----b+-++x--+--", /*  4/7  */
    "h-+++n-+---c+++--m-ed-o---", /*  4/8  */
    "x+-+--d---z+---y-l---b-+++", /*  4/9  */
    "-q+-+th+++e-i+n-+-c++j+u-w", /*  4/10 */
    "+--a-----+-j---+-p--------", /*  4/11 */
    "--o-w+--+---q-+-+-if--+-+y", /*  4/12 */
    "+p-k--+u--+g-v-+----++-a--", /*  4/13 */
    "-++-++fk+b+-+i+mo-v+-+e-ct", /*  4/14 */
};
