/*
 * schedule.c : This file defines the teams, the schedule matrix,
 *	special dates, and neutral sites for the season. It is the
 *	the only file you should have to change for a new season.
 *
 * This file is for the 1992-93 season. The schedule[] array has been
 * translated from that distributed with the original nhl.c to correspond
 * to the new format as of 93-94.
 *
 * See the README file for instructions on updating this for a
 * new season.
 *
 * This file is included directly in nhl.c. Don't bug me about it...
 */

/*
 * Set these to the starting and ending dates of the season.
 * They have to be strings (ie., enclosed in double-quotes) and
 * should be in form MM/DD/YYYY (the year must be all four digits).
 * The START_DOW should be a capitalized string representing the
 * day-of-the-week for the START_DATE. Check weekday[] in nhl.c for spelling.
 */
#define START_DATE		"10/6/1992"
#define START_DOW		"Tuesday"
#define END_DATE		"4/15/1993"

/*
 * The list of teams referenced by the schedule[] array.
 */
#define NUM_TEAMS 24

struct _team_struct {
    char *city;					/* City name for team */
    char *name;					/* Team nickname */
    char *abbrev;				/* Team code for cmd-line */
} teams[NUM_TEAMS] = {
    { "Boston",		"Bruins",	"bos" },
    { "Buffalo",	"Sabres",	"buf" },
    { "Calgary",	"Flames",	"cgy" },
    { "Chicago",	"Blackhawks",	"chi" },
    { "Detroit",	"Red Wings",	"det" },
    { "Edmonton",	"Oilers",	"edm" },
    { "Hartford",	"Whalers",	"hfd" },
    { "Los Angeles",	"Kings",	"los" },
    { "Minnesota",	"Stars",	"min" },
    { "Montreal",	"Canadiens",	"mtl" },
    { "New Jersey",	"Devils",	"njd" },
    { "NY Islanders",	"Islanders",	"nyi" },
    { "NY Rangers",	"Rangers",	"nyr" },
    { "Ottawa",		"Senators",	"ott" },
    { "Philadelphia",	"Flyers",	"phl" },
    { "Pittsburgh",	"Penguins",	"pit" },
    { "Quebec",		"Nordiques",	"que" },
    { "St. Louis",	"Blues",	"stl" },
    { "San Jose",	"Sharks",	"sjs" },
    { "Tampa Bay",	"Lightning",	"tmp" },
    { "Toronto",	"Maple Leafs",	"tor" },
    { "Vancouver",	"Canucks",	"van" },
    { "Washington",	"Capitals",	"wsh" },
    { "Winnipeg",	"Jets",		"wpg" },
};

#define NUM_DIVISIONS 4
#define MAX_TEAMS_PER_DIVISION 6

struct _division_struct {
    char *name;					/* Division name */
    char *teams[MAX_TEAMS_PER_DIVISION];	/* List of team abbrevs */
    char *abbrev;				/* Division abbrev */
    char flags[NUM_TEAMS];			/* Array of flags for teams */
} divisions[NUM_DIVISIONS] = {
    { "Adams",	 { "bos","buf","hfd","mtl","ott","que" }, "adams" },
    { "Patrick", { "njd","nyi","nyr","phl","pit","wsh" }, "patrick" },
    { "Norris",	 { "chi","det","min","stl","tmp","tor" }, "norris" },
    { "Smythe",	 { "cgy","edm","los","sjs","van","wpg" }, "smythe" },
};

/*
 * Special dates for which there are no games this season:
 */
struct _special_struct {
    int month,day;					/* Date */
    char *text;						/* Message to print */
} special_dates[] = {
    { 12, 24, "Holiday Break" },
    { 12, 25, "Holiday Break" },
    {  2,  4, "All Star Break" },
    {  2,  5, "All Star Break" },
    {  2,  6, "All Star Game in Montreal" },
    {  2,  7, "All Star Break" },
    {  0,  0, NULL },
};

/*
 * The list of neutral sites referenced in the schedule[] array
 */
char *extra_info[] = {
    "Atlanta, GA",
    "Birmingham, AL",
    "Cincinnati, OH",
    "Cleveland, OH",
    "Dallas, TX",
    "Halifax, N.S.",
    "Hamilton, Ont.",
    "Indianapolis, IN",
    "Miami, FL",
    "Milwaukee, WI",
    "Oklahoma City, OK",
    "Phoenix, AZ",
    "Providence, RI",
    "Saskatoon, Sask.",
    "Sacramento, CA",
};

/*
 * Schedule matrix:
 *   Each string represents one day of the season, The Nth character in
 *   the string represents what the Nth team (in the teams[] array) is
 *   doing on that day. The entries are interpreted as follows:
 *	-   : This team is idle
 *	+   : This team is home
 *	a-z : This team is away at the team given by the letter
 *	A-O : This team is the home team at a neutral site given by the letter
 *   Accessors are defined here for accessing the array. This will make
 *   it easier when the day comes that size of the league exceeds the
 *   size of the alphabet. The accessors have to map from the characters
 *   used in schedule[] into the teams[] and extra_info[] arrays.
 */

#define ISIDLECODE(C)		((C) == '-')
#define ISHOMECODE(C)		((C) == '+')
#define ISAWAYCODE(C)		((C) >= 'a' && (C) <= 'z')
#define ISSITECODE(C)		((C) >= 'A' && (C) <= 'O')

#define TEAMCODETOINDEX(C)	((int)((C) - 'a'))
#define INDEXTOTEAMCODE(C)	((char)((C) + 'a'))

#define SITECODETOINDEX(C)	((int)((C) - 'A'))
#define INDEXTOSITECODE(C)	((char)((C) + 'A'))

char *schedule[] = {
    "--+-x++crg+k--p+-+--+fu+", /* 10/6 */
    "---t---------------+----", /* 10/7 */
    "+++-hca++n-p-+-+bi+----s", /* 10/8 */
    "----------o-w-+-------+-", /* 10/9 */
    "+g+rsv+++++akqwj+++ic++h", /* 10/10 */
    "-+-+-+---b---------df---", /* 10/11 */
    "+-----m---+-+a-------+kv", /* 10/12 */
    "-pi----+N-----q+++hr----", /* 10/13 */
    "-----x+---m-+g---------+", /* 10/14 */
    "s-h++d-+rp-o--++e++u+---", /* 10/15 */
    "-+-----------w-----b-x++", /* 10/16 */
    "hwsu+e++j+++l-kg+q+-+-+-", /* 10/17 */
    "---+----u--m+-+-----+d-o", /* 10/18 */
    "---------+-------j------", /* 10/19 */
    "--+-+tkc--++-ul+---+Gp-e", /* 10/20 */
    "-+-b-----+--+---r+j---m-", /* 10/21 */
    "c-++p-n-+-d--+++i--+to--", /* 10/22 */
    "f+---+-x-m-w+-----b---++", /* 10/23 */
    "----r-li+o++n++kt+u++---", /* 10/24 */
    "v-f+d+---------------+--", /* 10/25 */
    "------------+-m--+r---x+", /* 10/26 */
    "-------l---+-+-n+--q----", /* 10/27 */
    "-ux-+++-f+g-------ej++v+", /* 10/28 */
    "+--+---a----+-drm+------", /* 10/29 */
    "-++-+---v-+k-b----t+e+c-", /* 10/30 */
    "+n+au++gc+l+j+r-++--+-fq", /* 10/31 */
    "---+-----------t--d+----", /* 11/1 */
    "-m+------+--+--------c-j", /* 11/2 */
    "---w-++----p-f-+gt-+--H-", /* 11/3 */
    "--v-+----e--+-m------+--", /* 11/4 */
    "+s++---++-hi-c-+ap+-d---", /* 11/5 */
    "----+xe------v-----w-+++", /* 11/6 */
    "+h-qji++++s+a-+u+o+l+-g-", /* 11/7 */
    "--q+---s-------d+-+--+-v", /* 11/8 */
    "--j------+--++-----mn---", /* 11/9 */
    "-----r-x+------i-+v--+-+", /* 11/10 */
    "b+g-t-+--k+-++--n--+--m-", /* 11/11 */
    "+-a+-s-++--o--++pd+--h-i", /* 11/12 */
    "-+--+-b---+--t-e---+--k-", /* 11/13 */
    "+ltigh++++w+q-j-++++as+r", /* 11/14 */
    "---+----d----o+---------", /* 11/15 */
    "j------v-+-------u--++--", /* 11/16 */
    "-p-e+--s-n---+-+G-++q--t", /* 11/17 */
    "-k---++-w-G------g---f+-", /* 11/18 */
    "+-+h+-n+tq-ao++-+-++sc-e", /* 11/19 */
    "----w-----+----k------+-", /* 11/20 */
    "+++s-vq+b+pcxja++++rh+-+", /* 11/21 */
    "-o---+-----f--+-+-----q-", /* 11/22 */
    "n--v+----+--++-m---e-+j-", /* 11/23 */
    "-----------x-------u+--+", /* 11/24 */
    "w++-+++f+gn-p+-+bec--i+-", /* 11/25 */
    "----------------u+--+r--", /* 11/26 */
    "+++f++ae+--oib+w--xc--++", /* 11/27 */
    "g-+cr++u++q+--l+++if+jp-", /* 11/28 */
    "-n-----------+----------", /* 11/29 */
    "qj--+---m+--+---+-----e-", /* 11/30 */
    "---J-srdn-++-+-l-++-k---", /* 12/1 */
    "--+-m-------+----------c", /* 12/2 */
    "+--++vs+ean--++ho-+-d+--", /* 12/3 */
    "-++--------bw----c----+-", /* 12/4 */
    "k--ut+h+qx++-+ns+f+++-l+", /* 12/5 */
    "o+-+-----db-+-+-----m---", /* 12/6 */
    "-q+--c-----t-+--+v-+-+n-", /* 12/7 */
    "--fe++-L-h-----+-------p", /* 12/8 */
    "b+--u-+---+-Ig----vm++k-", /* 12/9 */
    "+--+-i-++--d-a--hs+-----", /* 12/10 */
    "-+u-+-b---+-t-ek---++-+w", /* 12/11 */
    "jgni-t++++p+-+++sh++--ol", /* 12/12 */
    "-----l---m-K+---v----+--", /* 12/13 */
    "+ae-+-------------------", /* 12/14 */
    "--m-n--++-xr++p+-E-hi--+", /* 12/15 */
    "-----++--+------j-+s-fg-", /* 12/16 */
    "---+-----q-+rl+o++-----d", /* 12/17 */
    "e---++wf--t-------v+-++-", /* 12/18 */
    "+j+oi-+c++-pgu++-++-+sar", /* 12/19 */
    "-+-+----d--q--t-+--+b---", /* 12/20 */
    "--+--cj--++-k+-+p-x---n+", /* 12/21 */
    "+---+--++--------i-aeh--", /* 12/22 */
    "-+xn-++--+mj+++o--fg--b+", /* 12/23 */
    "------------------------", /* 12/24 */
    "------------------------", /* 12/25 */
    "g--+u-+s+--+lqw-+d+-+-+i", /* 12/26 */
    "m+f+d+k-xv+-++-bn+--r+-+", /* 12/27 */
    "------------------------", /* 12/28 */
    "x--e++B+-fq+w-h-+gv-l+++", /* 12/29 */
    "--------------s---+-----", /* 12/30 */
    "i++++x+v+c-rbe-+g+-dp+-+", /* 12/31 */
    "----------w-----------+-", /* 1/1 */
    "+n+wq+a+lh++p+c++u+f+s+k", /* 1/2 */
    "-+-+-++-g-----f--b-v-+-d", /* 1/3 */
    "----+----Om-+-----j-e---", /* 1/4 */
    "p-+--r---s-+---+l++----c", /* 1/5 */
    "-g----++k-+-+m-----h+u--", /* 1/6 */
    "+-r+-d--p-----++a+----o-", /* 1/7 */
    "-+--+--x--+b-k----u-+e-+", /* 1/8 */
    "+-pr-w+-++a+o-++g+-ijl+-", /* 1/9 */
    "-+b+-o+d-g---++x--n----+", /* 1/10 */
    "----+-------+----e-u+m--", /* 1/11 */
    "+ali---n+-++-+----x--k-+", /* 1/12 */
    "----++j--+--+----u-e+-mf", /* 1/13 */
    "+-o+---kdq++-++a+n----l-", /* 1/14 */
    "-v--++f-----------e--+--", /* 1/15 */
    "+-iu--v++++kjpa++tq+++-h", /* 1/16 */
    "-f-+o+-----n-++----+d-t-", /* 1/17 */
    "+-----x-----------a----N", /* 1/18 */
    "lc+x++-ft--+e+-vn+-+r+-+", /* 1/19 */
    "---------+j-------------", /* 1/20 */
    "o--++-+++----i+--eg+thd-", /* 1/21 */
    "-++--+---k+----fb------c", /* 1/22 */
    "+q+grx+++ua+hwlc++t++i++", /* 1/23 */
    "---+--o-t-----+----+-d--", /* 1/24 */
    "j--------+--------------", /* 1/25 */
    "qo+-c--+u-l+-r++++h-+-p-", /* 1/26 */
    "-+-vf+j--+--+--------+bm", /* 1/27 */
    "+-h---n++-ip-+++ot-+---a", /* 1/28 */
    "-+-s--------b---w-+---+-", /* 1/29 */
    "l-shv-++++r+ujp+-++i++-g", /* 1/30 */
    "-+---b---+----jw------+-", /* 1/31 */
    "--------v--+l+---++sr+-n", /* 2/1 */
    "+-w--a-q--------+-----+-", /* 2/2 */
    "q+ke+nbjs++u++m-+x+v++-+", /* 2/3 */
    "------------------------", /* 2/4 */
    "------------------------", /* 2/5 */
    "------------------------", /* 2/6 */
    "------------------------", /* 2/7 */
    "pn--------+-k+-A--------", /* 2/8 */
    "r---+h-++le+-o+-++-+tqi-", /* 2/9 */
    "-x+---------+--m--c----+", /* 2/10 */
    "d--+h--+to----+--+-++ur-", /* 2/11 */
    "-++--+x----m+---c-f--b-+", /* 2/12 */
    "--+pr-c+un++l+k+-+--+-h-", /* 2/13 */
    "t+-+d+--+-o---+bf-x+i--+", /* 2/14 */
    "-------+----+----m---h--", /* 2/15 */
    "--C--l-----+--c---+---s-", /* 2/16 */
    "jgu-+-+i+++--q--+k-e+---", /* 2/17 */
    "---+-p-d---+--v+-l+--+-s", /* 2/18 */
    "-ke-+-----+--------u+---", /* 2/19 */
    "u----g+w++-+sjilt-+F+++v", /* 2/20 */
    "--d+ij+-+++----gkw----+-", /* 2/21 */
    "----o--t----sxD---O+v+-+", /* 2/22 */
    "--s--q---rp+-N-++++---ln", /* 2/23 */
    "-+--b-+-----v-g------+--", /* 2/24 */
    "+--t---ra-oq-++n++++s---", /* 2/25 */
    "-++------b--c--------x-+", /* 2/26 */
    "+j+e++q+r++ofk++++cph-a-", /* 2/27 */
    "---+k++-x-+g-+-wndf---++", /* 2/28 */
    "+G-------a-----------b--", /* 3/1 */
    "--h-l--+---+-s+ox-+--w++", /* 3/2 */
    "-m----+-utg-+------++---", /* 3/3 */
    "+-r+-+-+-----h--d+---a-f", /* 3/4 */
    "-+-k+-b---+-+-wm----e-+-", /* 3/5 */
    "+-t--h+++i--q---+a-++g-u", /* 3/6 */
    "-+-+is--+-+w-dk---+---+b", /* 3/7 */
    "------q---------+-------", /* 3/8 */
    "p------m+-v++-l+--i+w++t", /* 3/9 */
    "-q--f+u--+-j----+---+---", /* 3/10 */
    "+-++c--pva--d-++-+r--No-", /* 3/11 */
    "-----+----f--------u+x-+", /* 3/12 */
    "+g+---+or+c+wa+lj+----+-", /* 3/13 */
    "-++fs++b+--+--g--i+x-cl+", /* 3/14 */
    "m-----------+---+---q---", /* 3/15 */
    "Mr+cJ-t+o-as--+--+++--eh", /* 3/16 */
    "-----m------+-----------", /* 3/17 */
    "n---+k-+eq+h-+p++--+t+-v", /* 3/18 */
    "------w-----+-----m---+-", /* 3/19 */
    "+t-jau-+-++v-p-+kh-+++--", /* 3/20 */
    "--x+iD--+-o---+f--wd--++", /* 3/21 */
    "+j----a--+--n+---v---+--", /* 3/22 */
    "----+-----+e---+w-pkx-++", /* 3/23 */
    "b++---+v-g--+-m--c---+--", /* 3/24 */
    "+d-+----+al+-+++--oni-p-", /* 3/25 */
    "--vm-+-f----+----x---+-+", /* 3/26 */
    "+---t+i-++w+-jqa+-l+f-+-", /* 3/27 */
    "-+++--dx----+b-wm---c-++", /* 3/28 */
    "----+--e--+-------k-----", /* 3/29 */
    "gw+---+----+--l--+---r+c", /* 3/30 */
    "-+---+-uf+b-----j---+---", /* 3/31 */
    "--++d-p-c----+++n-++ot-s", /* 4/1 */
    "---------w-m+---------+-", /* 4/2 */
    "+asr++++hlu+-g+q+++o+e-f", /* 4/3 */
    "b+s+------+-w+-k-d+--n+-", /* 4/4 */
    "------m-----+-----------", /* 4/5 */
    "qih--s-++--w--x-+t++--++", /* 4/6 */
    "-----vn--p+-k+-+-----+--", /* 4/7 */
    "+--lt--+---+--+-a-h+x-o+", /* 4/8 */
    "--+---------+--m-----c--", /* 4/9 */
    "je-t+-qs++w+plu++i+++-+-", /* 4/10 */
    "++v+-++-r-+k-a--b+-dg+-f", /* 4/11 */
    "---------+--o-+-------j-", /* 4/12 */
    "-+fi-+-v+b---q--+u-x++-+", /* 4/13 */
    "n-----+---+g++-k------m-", /* 4/14 */
    "-++++xl+e-p+--b+-+crdh-+", /* 4/15 */
};
