/*
 * mlb.94.c: Major League Baseball 1994 Season
 *
 * Compiled by George Ferguson, ferguson@cs.rochester.edu, 15 Mar 1994.
 *
 * This file defines the teams, the schedule matrix, and special dates.
 * It is the only file you should have to change for a new season.
 *
 * See the file UPDATING for instructions on updating this for a
 * new season.
 *
 * This file is included directly by schedule.c. Don't bug me about it...
 */

/*
 * Set this to something informative about the league and season
 * represented by this file. It is used for the -v option.
 */
#define VERSION_SEASON  "MLB 94"
#define VERSION_ENTERER "ferguson@cs.rochester.edu and marti@django.Colorado.EDU"

/*
 * Set these to the starting and ending dates of the season.
 * They have to be strings (ie., enclosed in double-quotes) and
 * should be in form MM/DD/YYYY (the year must be all four digits).
 * The START_DOW should be a capitalized string representing the
 * day-of-the-week for the START_DATE. Check weekday[] in schedule.c for
 * spelling.
 */
#define START_DATE		"4/3/1994"
#define START_DOW		"Sunday"
#define END_DATE		"10/2/1994"

/*
 * The list of teams referenced by the schedule[] array.
 */
#define NUM_TEAMS 28

struct _team_struct {
    char *city;					/* City name for team */
    char *name;					/* Team nickname */
    char *abbrev;				/* Team code for cmd-line */
} teams[NUM_TEAMS] = {
    { "Atlanta",	"Braves",	"atl" },
    { "Baltimore",	"Orioles",	"bal" },
    { "Boston",		"Red Sox",	"bos" },
    { "California",	"Angels",	"cal" },
    { "Chicago",	"Cubs",		"cub" },
    { "Chicago",	"White Sox",	"chi" },
    { "Cincinnati",	"Reds",		"cin" },
    { "Cleveland",	"Indians",	"cle" },
    { "Colorado",	"Rockies",	"col" },
    { "Detroit",	"Tigers",	"det" },
    { "Florida",	"Marlins",	"fla" },
    { "Houston",	"Astros",	"hou" },
    { "Kansas City",	"Royals",	"kc"  },
    { "Los Angeles",	"Dodgers",	"la"  },
    { "Milwaukee",	"Brewers",	"mil" },
    { "Minnesota",	"Twins",	"min" },
    { "Montreal",	"Expos",	"mtl" },
    { "New York",	"Mets",		"nym" },
    { "New York",	"Yankees",	"nyy" },
    { "Oakland",	"A's",		"oak" },
    { "Philadelphia",	"Phillies",	"phl" },
    { "Pittsburgh",	"Pirates",	"pit" },
    { "St. Louis",	"Cardinals",	"stl" },
    { "San Diego",	"Padres",	"sd"  },
    { "San Francisco",	"Giants",	"sf"  },
    { "Seattle",	"Mariners",	"sea" },
    { "Texas",		"Rangers",	"tex" },
    { "Toronto",	"Blue Jays",	"tor" },
};

#define NUM_DIVISIONS 6
#define MAX_TEAMS_PER_DIVISION 5

struct _division_struct {
    char *name;					/* Division name */
    char *teams[MAX_TEAMS_PER_DIVISION];	/* List of team abbrevs */
    char *abbrev;				/* Division abbrev */
    char flags[NUM_TEAMS];			/* Array of flags for teams */
} divisions[NUM_DIVISIONS] = {
    { "AL East",    { "bal","bos","det","nyy","tor" }, "ale" },
    { "AL Central", { "chi","cle","kc", "mil","min" }, "alc" },
    { "AL West",    { "cal","oak","sea","tex" },       "alw" },
    { "NL East",    { "atl","fla","mtl","nym","phl" }, "nle" },
    { "NL Central", { "chi","cin","hou","pit","stl" }, "nlc" },
    { "NL West",    { "col","la", "sd", "sf" },        "nlw" },

};

/*
 * Special dates for which there are no games this season:
 */
struct _special_struct {
    int month,day;					/* Date */
    char *text;						/* Message to print */
} special_dates[] = {
    {  7, 11, "All Star Break" },
    {  7, 12, "All Star Game in Pittsburgh" },
    {  7, 13, "All Star Break" },
    {  0,  0, NULL },
};

/*
 * The list of home team extra info referenced in the schedule[] array
 */
char *extra_info[] = {
    "(DH)",
};

/*
 * Schedule matrix:
 *   Each string represents one day of the season, The Nth character in
 *   the string represents what the Nth team (in the teams[] array) is
 *   doing on that day. The entries are interpreted as follows:
 *	-   : This team is idle
 *	+   : This team is home
 *	_`a-z : This team is away at the team given by the letter
 *	*     : Team is the home team and extra_info corresponding to the
 *		letter applies to the game.
 *
 *   Accessors are defined here for accessing the array. The accessors have
 *   to map from the characters used in schedule[] into the teams[] and
 *   extra_info[] arrays. They needn't be contiguous, but it makes life
 *   easier if they are.
 */

#define ISIDLECODE(C)		((C) == '-')
#define ISHOMECODE(C)		((C) == '+')
#define ISAWAYCODE(C)		((C) >= '_' && (C) <= 'z')
#define ISINFOCODE(C)		((C) == '*')

#define TEAMCODETOINDEX(C)	((int)((C) - '_'))
#define INDEXTOTEAMCODE(N)	((char)((N) + '_'))

#define INFOCODETOINDEX(C)	((int)((C) - '*'))
#define INDEXTOINFOCODE(N)	((char)((N) + '*'))

char *schedule[] = {
    "------+---------------e-----", /*  4/3  */
    "v++-+z+++a-+`---jc+-gwe++fq+", /*  4/4  */
    "v--n+z----l+-+++jc-m-w-++--+", /*  4/5  */
    "v++n+z+++al+`+-+jc+-gwe++fq+", /*  4/6  */
    "v-+n---++al--+++---mg--+-f--", /*  4/7  */
    "l+dmo++ktqv++++++j+ne+w++z`+", /*  4/8  */
    "l+dmo++ktqv++++++j+ne+w++z`+", /*  4/9  */
    "l+dmo++ktqv++++++j+ne+w++z`+", /*  4/10 */
    "-hk+p-obs+--+uyx++-++-+--++r", /*  4/11 */
    "+-k+-+ob--+i+--x+-d+-+-t_+-r", /*  4/12 */
    "+hk+p+obs++i+uyx++d++++t_++r", /*  4/13 */
    "+h-+p+--s++i-uyr-+d++++t_-+b", /*  4/14 */
    "cy+++as++++pftxrg+h++++ui++b", /*  4/15 */
    "cy+++as++++pftxrg+h++++ui++b", /*  4/16 */
    "cy+++as++++pftxrg+h++++ui++b", /*  4/17 */
    "+-+--a--++g-hs--wv--+-_++---", /*  4/18 */
    "+++`+m+n++gchs++wv+a+e_++qz+", /*  4/19 */
    "+++`+m+n++gch+++vl+awe_++qz+", /*  4/20 */
    "-++`-m-n-----+++vl+aw--++q--", /*  4/21 */
    "+++ag++y+deum++zlw+qv_+++`++", /*  4/22 */
    "+++ag++y+deum++zlw+qv_+++`++", /*  4/23 */
    "+++ag++y+deum++zlw+qv_+++`++", /*  4/24 */
    "i+xqe+++uy+++-df--+`-j+--++k", /*  4/25 */
    "i+xqe+++uy++++df+++`lj+po++k", /*  4/26 */
    "ubr+jft+ik++++n+++x+l++po++y", /*  4/27 */
    "ubr+jft+ik+++-n+--x+-++--++y", /*  4/28 */
    "txb++hi+c++++pk+++r+++jos+fn", /*  4/29 */
    "txb++hi+c++++pk+++r+++jos+fn", /*  4/30 */
    "txb++hi+c++++pk+++r+++jos+fn", /*  5/1  */
    "----+-c--+---o--++--+--sp-h-", /*  5/2  */
    "+r++++cd++_tzo+m++b+++gspah+", /*  5/3  */
    "+r++++cd++_tzo+m++b+++gspah+", /*  5/4  */
    "---+--+---+ezw---u-bi-+-+--+", /*  5/5  */
    "++q+t++`v++edwzy_u+bi++++h++", /*  5/6  */
    "++q+t++`v++edwzy_u+bi++++h++", /*  5/7  */
    "++q+t++`v++edwzy_u+bi++++h++", /*  5/8  */
    "+++yu+vqw-+l++ak+o+-_i+++d+`", /*  5/9  */
    "+++yu+vqw++l++ak+o+h_i+++d+`", /*  5/10 */
    "+++yu+vqw++l++ak+o+h_i+++d+`", /*  5/11 */
    "--+-u--q-+----a---+h+s+-----", /*  5/12 */
    "pn+x+yw+jfc+++++++mk+sol+++a", /*  5/13 */
    "pn+x+yw+jfc+++++++mk+sol+++a", /*  5/14 */
    "pn+x+yw+jfc+++++++mk+sol+++a", /*  5/15 */
    "---++b--+zp+xg--s+-+++tcj+r+", /*  5/16 */
    "e+`++b+++zp+xgf+s+n+++tcj+r+", /*  5/17 */
    "e+`++b+++zp+xgf+s+n+++tcj+r+", /*  5/18 */
    "e+`+--+++--+bgf--------j-+x-", /*  5/19 */
    "gqn++r+z++++beh+ts++++ijc+x+", /*  5/20 */
    "gqn++r+z++++beh+ts++++ijc+x+", /*  5/21 */
    "gqn++r+z++++beh+ts++++ijc+x+", /*  5/22 */
    "-m--l-gz+-+--++-i--+u-++vr-+", /*  5/23 */
    "+m+hl+ga+++_+++dit++u+++vrkq", /*  5/24 */
    "+m+hl+ga+++_+++dit++u+++vrkq", /*  5/25 */
    "+-+h--ga++-_+----t---+-+v-k-", /*  5/26 */
    "+dyz_+p+onws++++++kf+lv++m++", /*  5/27 */
    "+dyz_+p+onws++++++kf+lv++m++", /*  5/28 */
    "+dyz_+p+onws++++++kf+lv++m++", /*  5/29 */
    "w++f+q++p`j+a+++e++zcvl++nm+", /*  5/30 */
    "w++f+q++p`j+a+++e++zcvl++nm+", /*  5/31 */
    "w++f+q++p`j+a+++e++zcvl++nm+", /*  6/1  */
    "-+--+----`----------c-------", /*  6/2  */
    "+++++`+r++++q_bhce++jg+iu+ax", /*  6/3  */
    "+++++`+r++++q_bhce++jg+iu+ax", /*  6/4  */
    "+++++`+r++++q_bhce++jg+iu+ax", /*  6/5  */
    "+kh+s--x+++o+irb+gy+++-_t++-", /*  6/6  */
    "+kh+s+ux+++o+irb+gy++++_t++d", /*  6/7  */
    "+kh+s+ux+++o+irb+gy++++_t++d", /*  6/8  */
    "---+-n+mebt-y-++p+z-++s---++", /*  6/9  */
    "ja+++n+mebt+yc++p+zx++sw++++", /*  6/10 */
    "ja+++n+mebt+yc++p+zx++sw++++", /*  6/11 */
    "ja+++n+mebt+yc++p+zx++sw++++", /*  6/12 */
    "+++k-+l+_-uw++-a++`dpo+-+y+f", /*  6/13 */
    "+++kv+l+_muw+++a++`dpo+++y+f", /*  6/14 */
    "+++kv+l+_muw+++a++`dpo+++y+f", /*  6/15 */
    "++fdv+-+_m+w+-+--i`y-u+++k+-", /*  6/16 */
    "++fdw+_+l++v++q`+i+you+++k+h", /*  6/17 */
    "++fdw+_+l++v++q`+i+you+++k+h", /*  6/18 */
    "++fdw+_+l++v++q`+i+you+++k+h", /*  6/19 */
    "++z+-+-h++-g-v`qu_+-t+++-bd+", /*  6/20 */
    "++z+i++h+++grv`qu_++t+++ebd+", /*  6/21 */
    "++z+i++h+++grv`qu_++t+++ebd+", /*  6/22 */
    "----ix+---+-r------+----e+--", /*  6/23 */
    "szm++x+++ro+nj++++f++pceg+b+", /*  6/24 */
    "szm++x+++ro+nj++++f++pceg+b+", /*  6/25 */
    "szm++x+++ro+nj++++f++pceg+b+", /*  6/26 */
    "of+r+-j++xs+n+++++a++cpgl+-m", /*  6/27 */
    "of+r++j+*xs+d+++++a++cpgl+nm", /*  6/28 */
    "of+r++j++xs+d+++++a++cpgl+nm", /*  6/29 */
    "if+-j+t+u-++d+++wva-l++++-nm", /*  6/30 */
    "i++`j+t+uy++++dfwv+al++++q+k", /*  7/1  */
    "i++`j+t+uy++++dfwv+al++++q+k", /*  7/2  */
    "i++`j+t+uy++++dfwv+al++++q+k", /*  7/3  */
    "+++a++i+cy+u++dflw+qv_+++`+k", /*  7/4  */
    "+++a+hiyc++u++k+lw+qv_+++`+n", /*  7/5  */
    "+++a+hiyc++u++k+lw+qv_+++`+n", /*  7/6  */
    "-++q+h+yi++c++k+vl+`we-++a+n", /*  7/7  */
    "+++q+m+ni++cz+++vl+`we_++ah+", /*  7/8  */
    "+++q+m+ni++cz+++vl+`we_++ah+", /*  7/9  */
    "+++q+m+ni++cz+++vl+`we_++ah+", /*  7/10 */
    "----------------------------", /*  7/11 */
    "----------------------------", /*  7/12 */
    "----------------------------", /*  7/13 */
    "+br+e++d+k_t+sn+++x+++gpo++y", /*  7/14 */
    "+br+e++d+k_t+sn+++x+++gpo++y", /*  7/15 */
    "+br+e++d+k_t+sn+++x+++gpo++y", /*  7/16 */
    "+br+e++d+k_t+sn+++x+++gpo++y", /*  7/17 */
    "txb+g++++de+mp+z++r+++jos+f+", /*  7/18 */
    "txb+g++++de+mp+z++r+++jos+f+", /*  7/19 */
    "txb+g++++de+mp+z++r+++jos+f+", /*  7/20 */
    "urx+-f-+---+--+m--b+-j+--+z+", /*  7/21 */
    "urx++fc+++g+ho+m++b++j+sp+z+", /*  7/22 */
    "urx++fc+++g+ho+m++b++j+sp+z+", /*  7/23 */
    "urx++fc+++g+ho+m++b++j+sp+z+", /*  7/24 */
    "+---tk+-v-+e+w-y_u--i++++-+-", /*  7/25 */
    "++q+tk+`v++e+wzy_u+bi++++h++", /*  7/26 */
    "++q+tk+`v++e+wzy_u+bi++++h++", /*  7/27 */
    "-+qytkv`w+--+-z---+--+-++h++", /*  7/28 */
    "+++yu+vqw++l++akit+h_++++d+`", /*  7/29 */
    "+++yu+vqw++l++akit+h_++++d+`", /*  7/30 */
    "+++yu+vqw++l++akit+h_++++d+`", /*  7/31 */
    "pn+-+-w+jfc+++++++mk--ol+--a", /*  8/1  */
    "pn+x+yw+jfc+++++++mk+sol+++a", /*  8/2  */
    "pn+x+yw+jfc+++++++mk+sol+++a", /*  8/3  */
    "-m+x+y-+jfc++++++-nk+sol-++a", /*  8/4  */
    "em+++b+a+zp+xg++s+n+++tcj+r+", /*  8/5  */
    "em+++b+a-zp+x-++s+n+++tcj+r+", /*  8/6  */
    "em+++b+a+zp+xg++s+n+++tcj+r+", /*  8/7  */
    "eqn++r+z+++-bgh+ts++++i-c+x+", /*  8/8  */
    "gqn++r+z++++beh+ts++++ijc+x+", /*  8/9  */
    "gqn++r+z++++beh+ts++++ijc+x+", /*  8/10 */
    "g+`---+-++++-eh-ts++++ij-r-q", /*  8/11 */
    "++`hl+g++++_++fd+o++ui++vrkq", /*  8/12 */
    "++`hl+g++++_++fd+o++ui++vrkq", /*  8/13 */
    "++`hl+g++++_++fd+o++ui++vrkq", /*  8/14 */
    "+----+--o--_---d+-----v+----", /*  8/15 */
    "+ydm_+s+o+wp+++h++kf+lv++z++", /*  8/16 */
    "+ydm_+s+o+wp+++h++kf+lv++z++", /*  8/17 */
    "+ydm_+s+-+wp+++h-+kf+l--+z++", /*  8/18 */
    "+k+npz+++al+++++j+ymgwe_+f++", /*  8/19 */
    "+k+npz+++al+++++j+ymgwe_+f++", /*  8/20 */
    "+k+npz+++al+++++j+ymgwe_+f++", /*  8/21 */
    "-++-p`+-+n--q-++g++me-+-u+ax", /*  8/22 */
    "c++++`+r+n++qtb+gj++e++iu+ax", /*  8/23 */
    "c++++`+r+n++qtb+gj++e++iu+ax", /*  8/24 */
    "c+h+++ur-+++`tbx-j++-++i-+qd", /*  8/25 */
    "v+h+++ubs++o`irx+c++++++t+qd", /*  8/26 */
    "v+h+++ubs++o`irx+c++++++t+qd", /*  8/27 */
    "v+h+++ubs++o`irx+c++++++t+qd", /*  8/28 */
    "l-y-o-p-tqvs-+--+++-++-+--+-", /*  8/29 */
    "ldyzo+p+tqvsf++++++n++w++m++", /*  8/30 */
    "ldyzo+p+tqvsf++++++n++w++m++", /*  8/31 */
    "ld-z-+-+-q--f+++--+n-vw++m-+", /*  9/1  */
    "w+kfs+o+p`j+++++++dz+vl++nm+", /*  9/2  */
    "w+kfs+o+p`j+++++++dz+-l-+nm+", /*  9/3  */
    "w+kfs+o+p`j+++++++dz+vl++nm+", /*  9/4  */
    "++--+-+k+-+++_-rce-+jg+ui-`-", /*  9/5  */
    "+++++a+k+++++_xrceh+jg+ui+`b", /*  9/6  */
    "+++++a+k+++++_xrceh+jg+ui+`b", /*  9/7  */
    "+--++----+----xbc-h-----_+--", /*  9/8  */
    "+h+++q+x+++iauybeg++c++t_++r", /*  9/9  */
    "+h+++q+x+++iauybeg++c++t_++r", /*  9/10 */
    "+h+++q+x+++iauybeg++c++t_++r", /*  9/11 */
    "-a+-+n------yc-+p+-x---w+++-", /*  9/12 */
    "ja+++n+mebt+yc++p+zx++sw++++", /*  9/13 */
    "ja+++n+mebt+yc++p+zx++sw++++", /*  9/14 */
    "j----+lm--t+-++---zd++s----+", /*  9/15 */
    "+++kv+l+_muw+++a++`dpo+++y+f", /*  9/16 */
    "+++kv+l+_muw+++a++`dpo+++y+f", /*  9/17 */
    "+++kv+l+_muw+++a++`dpo+++y+f", /*  9/18 */
    "-+-dw+--l++v++q`+i+you+++k+h", /*  9/19 */
    "++fdw+_+l++v++q`+i+you+++k+h", /*  9/20 */
    "++fdw+_+l++v++q`+i+you+++k+h", /*  9/21 */
    "+-f+-+_+-+----q-+-+-o----bdh", /*  9/22 */
    "++z+i++h+++grv`qu_++t+++ebd+", /*  9/23 */
    "++z+i++h+++grv`qu_++t+++ebd+", /*  9/24 */
    "++z+i++h+++grv`qu_++t+++ebd+", /*  9/25 */
    "szm++-++-ro+nj++++f++pc-e-b+", /*  9/26 */
    "szm++x+++ro+nj++++f++pceg+b+", /*  9/27 */
    "szm++x+++ro+nj++++f++pceg+b+", /*  9/28 */
    "-z-r-x+-+-o+-j-+++-+-p-eg+n+", /*  9/29 */
    "of+r+kj++xs+++++++a++cpgl+nm", /*  9/30 */
    "of+r+kj++xs+++++++a++cpgl+nm", /* 10/1  */
    "of+r+kj++xs+++++++a++cpgl+nm", /* 10/2  */
};
