// NOTE: File has been autogenerated by utils/aarch64_builtins_test_generator.py
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sme-f16f16 -target-feature +sve -verify=streaming-guard

// REQUIRES: aarch64-registered-target

#include <arm_sve.h>

// Properties: guard="" streaming_guard="sme,sme-f16f16" flags="streaming-only"

void test(void) {
  svfloat16_t svfloat16_t_val;

  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svcvt_f32(svfloat16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svcvt_f32_f16_x2(svfloat16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svcvtl_f32(svfloat16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svcvtl_f32_f16_x2(svfloat16_t_val);
}

void test_streaming(void) __arm_streaming{
  svfloat16_t svfloat16_t_val;

  svcvt_f32(svfloat16_t_val);
  svcvt_f32_f16_x2(svfloat16_t_val);
  svcvtl_f32(svfloat16_t_val);
  svcvtl_f32_f16_x2(svfloat16_t_val);
}

void test_streaming_compatible(void) __arm_streaming_compatible{
  svfloat16_t svfloat16_t_val;

  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svcvt_f32(svfloat16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svcvt_f32_f16_x2(svfloat16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svcvtl_f32(svfloat16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svcvtl_f32_f16_x2(svfloat16_t_val);
}
