// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// REQUIRES: riscv-registered-target
// RUN: %clang_cc1 -triple riscv64 -target-feature +zve64x \
// RUN:   -target-feature +xandesvdot -disable-O0-optnone  \
// RUN:   -emit-llvm %s -o - | opt -S -passes=mem2reg | \
// RUN:   FileCheck --check-prefix=CHECK-RV64 %s

#include <andes_vector.h>

// CHECK-RV64-LABEL: @test_nds_vd4dotsu_vv_i32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.nds.vd4dotsu.nxv1i32.nxv4i8.nxv4i8.i64(<vscale x 1 x i32> [[VD:%.*]], <vscale x 4 x i8> [[VS1:%.*]], <vscale x 4 x i8> [[VS2:%.*]], i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vint32mf2_t test_nds_vd4dotsu_vv_i32mf2(vint32mf2_t vd, vint8mf2_t vs1, vuint8mf2_t vs2, size_t vl) {
  return __riscv_nds_vd4dotsu_vv_i32mf2(vd, vs1, vs2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vd4dotsu_vv_i32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.nds.vd4dotsu.nxv2i32.nxv8i8.nxv8i8.i64(<vscale x 2 x i32> [[VD:%.*]], <vscale x 8 x i8> [[VS1:%.*]], <vscale x 8 x i8> [[VS2:%.*]], i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vint32m1_t test_nds_vd4dotsu_vv_i32m1(vint32m1_t vd, vint8m1_t vs1, vuint8m1_t vs2, size_t vl) {
  return __riscv_nds_vd4dotsu_vv_i32m1(vd, vs1, vs2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vd4dotsu_vv_i32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.nds.vd4dotsu.nxv4i32.nxv16i8.nxv16i8.i64(<vscale x 4 x i32> [[VD:%.*]], <vscale x 16 x i8> [[VS1:%.*]], <vscale x 16 x i8> [[VS2:%.*]], i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vint32m2_t test_nds_vd4dotsu_vv_i32m2(vint32m2_t vd, vint8m2_t vs1, vuint8m2_t vs2, size_t vl) {
  return __riscv_nds_vd4dotsu_vv_i32m2(vd, vs1, vs2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vd4dotsu_vv_i32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.nds.vd4dotsu.nxv8i32.nxv32i8.nxv32i8.i64(<vscale x 8 x i32> [[VD:%.*]], <vscale x 32 x i8> [[VS1:%.*]], <vscale x 32 x i8> [[VS2:%.*]], i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vint32m4_t test_nds_vd4dotsu_vv_i32m4(vint32m4_t vd, vint8m4_t vs1, vuint8m4_t vs2, size_t vl) {
  return __riscv_nds_vd4dotsu_vv_i32m4(vd, vs1, vs2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vd4dotsu_vv_i32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.nds.vd4dotsu.nxv16i32.nxv64i8.nxv64i8.i64(<vscale x 16 x i32> [[VD:%.*]], <vscale x 64 x i8> [[VS1:%.*]], <vscale x 64 x i8> [[VS2:%.*]], i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vint32m8_t test_nds_vd4dotsu_vv_i32m8(vint32m8_t vd, vint8m8_t vs1, vuint8m8_t vs2, size_t vl) {
  return __riscv_nds_vd4dotsu_vv_i32m8(vd, vs1, vs2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vd4dotsu_vv_i64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.nds.vd4dotsu.nxv1i64.nxv4i16.nxv4i16.i64(<vscale x 1 x i64> [[VD:%.*]], <vscale x 4 x i16> [[VS1:%.*]], <vscale x 4 x i16> [[VS2:%.*]], i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vint64m1_t test_nds_vd4dotsu_vv_i64m1(vint64m1_t vd, vint16m1_t vs1, vuint16m1_t vs2, size_t vl) {
  return __riscv_nds_vd4dotsu_vv_i64m1(vd, vs1, vs2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vd4dotsu_vv_i64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.nds.vd4dotsu.nxv2i64.nxv8i16.nxv8i16.i64(<vscale x 2 x i64> [[VD:%.*]], <vscale x 8 x i16> [[VS1:%.*]], <vscale x 8 x i16> [[VS2:%.*]], i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vint64m2_t test_nds_vd4dotsu_vv_i64m2(vint64m2_t vd, vint16m2_t vs1, vuint16m2_t vs2, size_t vl) {
  return __riscv_nds_vd4dotsu_vv_i64m2(vd, vs1, vs2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vd4dotsu_vv_i64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.nds.vd4dotsu.nxv4i64.nxv16i16.nxv16i16.i64(<vscale x 4 x i64> [[VD:%.*]], <vscale x 16 x i16> [[VS1:%.*]], <vscale x 16 x i16> [[VS2:%.*]], i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vint64m4_t test_nds_vd4dotsu_vv_i64m4(vint64m4_t vd, vint16m4_t vs1, vuint16m4_t vs2, size_t vl) {
  return __riscv_nds_vd4dotsu_vv_i64m4(vd, vs1, vs2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vd4dotsu_vv_i64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.nds.vd4dotsu.nxv8i64.nxv32i16.nxv32i16.i64(<vscale x 8 x i64> [[VD:%.*]], <vscale x 32 x i16> [[VS1:%.*]], <vscale x 32 x i16> [[VS2:%.*]], i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vint64m8_t test_nds_vd4dotsu_vv_i64m8(vint64m8_t vd, vint16m8_t vs1, vuint16m8_t vs2, size_t vl) {
  return __riscv_nds_vd4dotsu_vv_i64m8(vd, vs1, vs2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vd4dotsu_vv_i32mf2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.nds.vd4dotsu.mask.nxv1i32.nxv4i8.nxv4i8.i64(<vscale x 1 x i32> [[VD:%.*]], <vscale x 4 x i8> [[VS1:%.*]], <vscale x 4 x i8> [[VS2:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vint32mf2_t test_nds_vd4dotsu_vv_i32mf2_m(vbool64_t mask, vint32mf2_t vd, vint8mf2_t vs1, vuint8mf2_t vs2, size_t vl) {
  return __riscv_nds_vd4dotsu_vv_i32mf2_m(mask, vd, vs1, vs2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vd4dotsu_vv_i32m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.nds.vd4dotsu.mask.nxv2i32.nxv8i8.nxv8i8.i64(<vscale x 2 x i32> [[VD:%.*]], <vscale x 8 x i8> [[VS1:%.*]], <vscale x 8 x i8> [[VS2:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vint32m1_t test_nds_vd4dotsu_vv_i32m1_m(vbool32_t mask, vint32m1_t vd, vint8m1_t vs1, vuint8m1_t vs2, size_t vl) {
  return __riscv_nds_vd4dotsu_vv_i32m1_m(mask, vd, vs1, vs2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vd4dotsu_vv_i32m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.nds.vd4dotsu.mask.nxv4i32.nxv16i8.nxv16i8.i64(<vscale x 4 x i32> [[VD:%.*]], <vscale x 16 x i8> [[VS1:%.*]], <vscale x 16 x i8> [[VS2:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vint32m2_t test_nds_vd4dotsu_vv_i32m2_m(vbool16_t mask, vint32m2_t vd, vint8m2_t vs1, vuint8m2_t vs2, size_t vl) {
  return __riscv_nds_vd4dotsu_vv_i32m2_m(mask, vd, vs1, vs2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vd4dotsu_vv_i32m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.nds.vd4dotsu.mask.nxv8i32.nxv32i8.nxv32i8.i64(<vscale x 8 x i32> [[VD:%.*]], <vscale x 32 x i8> [[VS1:%.*]], <vscale x 32 x i8> [[VS2:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vint32m4_t test_nds_vd4dotsu_vv_i32m4_m(vbool8_t mask, vint32m4_t vd, vint8m4_t vs1, vuint8m4_t vs2, size_t vl) {
  return __riscv_nds_vd4dotsu_vv_i32m4_m(mask, vd, vs1, vs2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vd4dotsu_vv_i32m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.nds.vd4dotsu.mask.nxv16i32.nxv64i8.nxv64i8.i64(<vscale x 16 x i32> [[VD:%.*]], <vscale x 64 x i8> [[VS1:%.*]], <vscale x 64 x i8> [[VS2:%.*]], <vscale x 16 x i1> [[MASK:%.*]], i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vint32m8_t test_nds_vd4dotsu_vv_i32m8_m(vbool4_t mask, vint32m8_t vd, vint8m8_t vs1, vuint8m8_t vs2, size_t vl) {
  return __riscv_nds_vd4dotsu_vv_i32m8_m(mask, vd, vs1, vs2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vd4dotsu_vv_i64m1_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.nds.vd4dotsu.mask.nxv1i64.nxv4i16.nxv4i16.i64(<vscale x 1 x i64> [[VD:%.*]], <vscale x 4 x i16> [[VS1:%.*]], <vscale x 4 x i16> [[VS2:%.*]], <vscale x 1 x i1> [[MASK:%.*]], i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vint64m1_t test_nds_vd4dotsu_vv_i64m1_m(vbool64_t mask, vint64m1_t vd, vint16m1_t vs1, vuint16m1_t vs2, size_t vl) {
  return __riscv_nds_vd4dotsu_vv_i64m1_m(mask, vd, vs1, vs2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vd4dotsu_vv_i64m2_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.nds.vd4dotsu.mask.nxv2i64.nxv8i16.nxv8i16.i64(<vscale x 2 x i64> [[VD:%.*]], <vscale x 8 x i16> [[VS1:%.*]], <vscale x 8 x i16> [[VS2:%.*]], <vscale x 2 x i1> [[MASK:%.*]], i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vint64m2_t test_nds_vd4dotsu_vv_i64m2_m(vbool32_t mask, vint64m2_t vd, vint16m2_t vs1, vuint16m2_t vs2, size_t vl) {
  return __riscv_nds_vd4dotsu_vv_i64m2_m(mask, vd, vs1, vs2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vd4dotsu_vv_i64m4_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.nds.vd4dotsu.mask.nxv4i64.nxv16i16.nxv16i16.i64(<vscale x 4 x i64> [[VD:%.*]], <vscale x 16 x i16> [[VS1:%.*]], <vscale x 16 x i16> [[VS2:%.*]], <vscale x 4 x i1> [[MASK:%.*]], i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vint64m4_t test_nds_vd4dotsu_vv_i64m4_m(vbool16_t mask, vint64m4_t vd, vint16m4_t vs1, vuint16m4_t vs2, size_t vl) {
  return __riscv_nds_vd4dotsu_vv_i64m4_m(mask, vd, vs1, vs2, vl);
}

// CHECK-RV64-LABEL: @test_nds_vd4dotsu_vv_i64m8_m(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.nds.vd4dotsu.mask.nxv8i64.nxv32i16.nxv32i16.i64(<vscale x 8 x i64> [[VD:%.*]], <vscale x 32 x i16> [[VS1:%.*]], <vscale x 32 x i16> [[VS2:%.*]], <vscale x 8 x i1> [[MASK:%.*]], i64 [[VL:%.*]], i64 3)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vint64m8_t test_nds_vd4dotsu_vv_i64m8_m(vbool8_t mask, vint64m8_t vd, vint16m8_t vs1, vuint16m8_t vs2, size_t vl) {
  return __riscv_nds_vd4dotsu_vv_i64m8_m(mask, vd, vs1, vs2, vl);
}
