.\"
.\" Copyright (c) Mark J. Kilgard, 1998.
.\"
.\" See the file "man/LICENSE" for information on usage and redistribution
.\"
.TH glutEnterGameMode 3 "April 2025" "freeglut" "freeglut"
.SH NAME
glutEnterGameMode, glutLeaveGameMode - enters and leaves GLUT's game mode.
.SH SYNTAX
.nf
.LP
int glutEnterGameMode(void);
void glutLeaveGameMode(void);
.fi
.SH DESCRIPTION

glutEnterGameMode is designed to enable high-performance fullscreen GLUT rendering, possibly
at a different screen display format.  Calling glutEnterGameMode creates a
special fullscreen GLUT window (with its own callbacks and OpenGL rendering context
state).  If the game mode string describes a possible screen display format,
GLUT also changes the screen display format to the one described by the
game mode string.  glutLeaveGameMode leaves the GLUT game mode and returns the
screen display format to its default format.

When game mode is entered, certain GLUT functionality is disable to facilitate
high-performance fullscreen rendering.  GLUT pop-up menus are not available
while in game mode.  Other created windows and subwindows are not displayed
in GLUT game mode.  Game mode will also hide all other applications running
on the computer's display screen.
The intent of these restrictions is to eliminate window
clipping issues, permit screen display format changes,
and permit fullscreen
rendering optimization such as page flipping for fullscreen buffer swaps.

The value returned by glutEnterGameMode is a unique small integer identifier for the fullscreen window.
The range of allocated identifiers starts at one. This window identifier
can be used when calling glutSetWindow.

After leaving game mode, the GLUT functionality disabled in game mode is
available again.  The game mode window (and its OpenGL rendering state) is
destroyed when leaving game mode.  Any windows and subwindows created before
entering the game mode are displayed in their previous locations.  The OpenGL
state of normal GLUT windows and subwindows is not disturbed by entering
and/or leaving game mode.

The following GLUT routines are ignored in game mode:  glutFullScreen,
glutSetWindowTitle, glutSetIconTitle, glutPositionWindow, glutReshapeWindow,
glutPopWindow, glutPushWindow, glutIconifyWindow, glutShowWindow,
glutHideWindow.

glutEnterGameMode can be called when already in game mode.  This will destroy
the previous game mode window (including any OpenGL rendering state) and
create a new game mode window with a new OpenGL rendering context.
Also if glutEnterGameMode is called when already in game mode and if the game mode
string has changed and describes a possible screen display format, the new
screen display format takes effect.  A reshape callback is generated if the
game mode window changes size due to a screen display format change.

Re-entering game mode provides a mechanism for changing the screen display
format while already in game mode.  Note though that the game mode window's
OpenGL state is lost in this process and the application is responsible for
re-initializing the newly created game mode window OpenGL state when
re-entering game mode.

Game mode cannot be entered while pop-up menus are in use.

Note that the glutEnterGameMode and glutFullScreen routines operate differently.
glutFullScreen simply makes the current window match the size of the screen.
glutFullScreen does not change the screen display format and does not disable
any GLUT features such as pop-up menus; glutFullScreen continues to operate
in a "windowed" mode of operation.  glutEnterGameMode creates a new window
style, possibly changes the screen display mode, limits GLUT functionality,
and hides other applications.

.SH SEE ALSO
glutGameModeGet, glutGameModeString, glutInitDisplayString
.SH AUTHOR
Mark J. Kilgard (mjk@nvidia.com)
