; RUN: opt %loadNPMPolly -polly-pattern-matching-based-opts=true '-passes=polly-custom<optree;delicm;simplify;opt-isl>' -polly-tc-opt=true -debug -disable-output < %s 2>&1 | FileCheck %s
; REQUIRES: asserts

; Check that the pattern matching detects the matrix multiplication pattern
; after a full run of -polly-optree and -polly-delicm, where the write access
; is not through the original memory access, but through a PHI node that was
; delicmed. This test covers the polybench 2mm and 3mm cases.
;
; This test case generates the following schedule, which contains filters:
;
; domain: "{ Stmt_for_body8[i0, i1, i2]  : 0 <= i0 <= 1599 and
;                                          0 <= i1 <= 1799 and
;                                          0 <= i2 <= 2199;
;            Stmt_for_body3[i0, i1] :      0 <= i0 <= 1599 and
;                                          0 <= i1 <= 1799;
;            Stmt_for_body3_last[i0, i1] : 0 <= i0 <= 1599 and
;                                          0 <= i1 <= 1799 }"
; child:
;  sequence:
;  - filter: "{ Stmt_for_body3[i0, i1] }"
;    child:
;      schedule: "[{ Stmt_for_body3[i0, i1] -> [(i0)] }, { Stmt_for_body3[i0, i1] -> [(i1)] }]"
;      permutable: 1
;      coincident: [ 1, 1 ]
;  - filter: "{ Stmt_for_body3_last[i0, i1] }"
;    child:
;      schedule: "[{ Stmt_for_body3_last[i0, i1] -> [(i0)] }, { Stmt_for_body3_last[i0, i1] -> [(i1)] }]"
;      permutable: 1
;      coincident: [ 1, 1 ]
;  - filter: "{ Stmt_for_body8[i0, i1, i2] }"
;    child:
;      schedule: "[{ Stmt_for_body8[i0, i1, i2] -> [(i0)] },
;                  { Stmt_for_body8[i0, i1, i2] -> [(i1)] },
;                  { Stmt_for_body8[i0, i1, i2] -> [(i2)] }]"
;      permutable: 1
;      coincident: [ 1, 1, 0 ]
;
; CHECK: The tensor contraction pattern was detected
; CHECK: The matrix multiplication pattern was detected
;

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

; Function Attrs: norecurse nounwind uwtable
define void @kernel_2mm(i32 %ni, i32 %nj, i32 %nk, i32 %nl, double %alpha, double %beta, ptr nocapture %tmp, ptr nocapture readonly %A, ptr nocapture readonly %B, ptr nocapture readnone %C, ptr nocapture readnone %D) local_unnamed_addr {
entry:
  br label %entry.split

entry.split:                                      ; preds = %entry
  br label %for.body

for.body:                                         ; preds = %for.inc25, %entry.split
  %indvars.iv50 = phi i64 [ 0, %entry.split ], [ %indvars.iv.next51, %for.inc25 ]
  br label %for.body3

for.body3:                                        ; preds = %for.inc22, %for.body
  %indvars.iv46 = phi i64 [ 0, %for.body ], [ %indvars.iv.next47, %for.inc22 ]
  %arrayidx5 = getelementptr inbounds [1800 x double], ptr %tmp, i64 %indvars.iv50, i64 %indvars.iv46
  store double 0.000000e+00, ptr %arrayidx5, align 8, !tbaa !2
  br label %for.body8

for.body8:                                        ; preds = %for.body8, %for.body3
  %0 = phi double [ 0.000000e+00, %for.body3 ], [ %add, %for.body8 ]
  %indvars.iv = phi i64 [ 0, %for.body3 ], [ %indvars.iv.next, %for.body8 ]
  %arrayidx12 = getelementptr inbounds [2200 x double], ptr %A, i64 %indvars.iv50, i64 %indvars.iv
  %1 = load double, ptr %arrayidx12, align 8, !tbaa !2
  %mul = fmul double %1, %alpha
  %arrayidx16 = getelementptr inbounds [1800 x double], ptr %B, i64 %indvars.iv, i64 %indvars.iv46
  %2 = load double, ptr %arrayidx16, align 8, !tbaa !2
  %mul17 = fmul double %mul, %2
  %add = fadd double %0, %mul17
  store double %add, ptr %arrayidx5, align 8, !tbaa !2
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %exitcond = icmp eq i64 %indvars.iv.next, 2200
  br i1 %exitcond, label %for.inc22, label %for.body8

for.inc22:                                        ; preds = %for.body8
  %indvars.iv.next47 = add nuw nsw i64 %indvars.iv46, 1
  %exitcond48 = icmp eq i64 %indvars.iv.next47, 1800
  br i1 %exitcond48, label %for.inc25, label %for.body3

for.inc25:                                        ; preds = %for.inc22
  %indvars.iv.next51 = add nuw nsw i64 %indvars.iv50, 1
  %exitcond52 = icmp eq i64 %indvars.iv.next51, 1600
  br i1 %exitcond52, label %for.end27, label %for.body

for.end27:                                        ; preds = %for.inc25
  ret void
}

!llvm.module.flags = !{!0}
!llvm.ident = !{!1}

!0 = !{i32 1, !"wchar_size", i32 4}
!1 = !{!"clang version 6.0.0 (trunk 309912) (llvm/trunk 309933)"}
!2 = !{!3, !3, i64 0}
!3 = !{!"double", !4, i64 0}
!4 = !{!"omnipotent char", !5, i64 0}
!5 = !{!"Simple C/C++ TBAA"}
