#!/bin/sh
# $Id: run_test.sh,v 1.4 2026/01/05 08:45:24 tom Exp $
##############################################################################
# Copyright (c) 2020-2022,2026 Thomas E. Dickey                              #
#                                                                            #
# Permission is hereby granted, free of charge, to any person obtaining a    #
# copy of this software and associated documentation files (the "Software"), #
# to deal in the Software without restriction, including without limitation  #
# the rights to use, copy, modify, merge, publish, distribute, distribute    #
# with modifications, sublicense, and/or sell copies of the Software, and to #
# permit persons to whom the Software is furnished to do so, subject to the  #
# following conditions:                                                      #
#                                                                            #
# The above copyright notice and this permission notice shall be included in #
# all copies or substantial portions of the Software.                        #
#                                                                            #
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR #
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   #
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    #
# THE ABOVE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER      #
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    #
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        #
# DEALINGS IN THE SOFTWARE.                                                  #
#                                                                            #
# Except as contained in this notice, the name(s) of the above copyright     #
# holders shall not be used in advertising or otherwise to promote the sale, #
# use or other dealings in this Software without prior written               #
# authorization.                                                             #
##############################################################################

failed() {
	echo "? $*" >&2
	exit 1
}

: "${DIALOG=./dialog}"
CONFIG=samples
INPUTS=inputs.rc
OUTPUT=output.rc

[ $# != 0 ] && CONFIG="$1"

[ -f "$DIALOG" ] || failed "no such file: $DIALOG"
[ -d "$CONFIG" ] || failed "no such directory: $CONFIG"

# Expect to find dialog's shared library in the directory where it was linked.
case "$DIALOG" in
*/*)
	THIS_DIR=`echo "$DIALOG" | sed -e 's,/[^/]*$,,'`
	THIS_DIR=`unset CDPATH; cd "$THIS_DIR" && pwd`
	;;
*)
	THIS_DIR=`pwd`
	;;
esac

# Help linker to load dialog's shared library from the build-directory.
if [ -n "$LD_LIBRARY_PATH" ]
then
	LD_LIBRARY_PATH="$THIS_DIR:$LD_LIBRARY_PATH"
else
	LD_LIBRARY_PATH="$THIS_DIR"
fi
export LD_LIBRARY_PATH

create_rc="`$DIALOG --help | grep create-rc`"
if [ -z "$create_rc" ]
then
	echo "This version of dialog does not support --create-rc"
	exit
fi

for rcfile in "$CONFIG"/*.rc
do
	echo "** $rcfile"
	DIALOGRC="$rcfile" $DIALOG --create-rc $OUTPUT
	sed -e '/^#/d' "$OUTPUT" >"$INPUTS"
	mv -f $INPUTS $OUTPUT
	sed -e '/^#/d' "$rcfile" >"$INPUTS"
	diff -u $INPUTS $OUTPUT | \
		sed	-e "s,$INPUTS,$rcfile," \
			-e "s,$OUTPUT,$rcfile-test,"
done

rm -f $INPUTS $OUTPUT
