// NOTE: File has been autogenerated by utils/aarch64_builtins_test_generator.py
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sve -target-feature +sve-aes -verify=guard
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +ssve-aes -target-feature +sve -verify=streaming-guard
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +ssve-aes -target-feature +sve -target-feature +sve-aes -verify
// expected-no-diagnostics

// REQUIRES: aarch64-registered-target

#include <arm_sve.h>

// Properties: guard="sve,sve-aes" streaming_guard="sme,ssve-aes" flags="feature-dependent"

void test(void) {
  svuint8_t svuint8_t_val;
  svuint64_t svuint64_t_val;
  uint64_t uint64_t_val;

  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svaesd(svuint8_t_val, svuint8_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svaesd_u8(svuint8_t_val, svuint8_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svaese(svuint8_t_val, svuint8_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svaese_u8(svuint8_t_val, svuint8_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svaesimc(svuint8_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svaesimc_u8(svuint8_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svaesmc(svuint8_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svaesmc_u8(svuint8_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svpmullb_pair(svuint64_t_val, svuint64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svpmullb_pair(svuint64_t_val, uint64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svpmullb_pair_n_u64(svuint64_t_val, uint64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svpmullb_pair_u64(svuint64_t_val, svuint64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svpmullt_pair(svuint64_t_val, svuint64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svpmullt_pair(svuint64_t_val, uint64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svpmullt_pair_n_u64(svuint64_t_val, uint64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svpmullt_pair_u64(svuint64_t_val, svuint64_t_val);
}

void test_streaming(void) __arm_streaming{
  svuint8_t svuint8_t_val;
  svuint64_t svuint64_t_val;
  uint64_t uint64_t_val;

  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svaesd(svuint8_t_val, svuint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svaesd_u8(svuint8_t_val, svuint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svaese(svuint8_t_val, svuint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svaese_u8(svuint8_t_val, svuint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svaesimc(svuint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svaesimc_u8(svuint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svaesmc(svuint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svaesmc_u8(svuint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svpmullb_pair(svuint64_t_val, svuint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svpmullb_pair(svuint64_t_val, uint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svpmullb_pair_n_u64(svuint64_t_val, uint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svpmullb_pair_u64(svuint64_t_val, svuint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svpmullt_pair(svuint64_t_val, svuint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svpmullt_pair(svuint64_t_val, uint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svpmullt_pair_n_u64(svuint64_t_val, uint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svpmullt_pair_u64(svuint64_t_val, svuint64_t_val);
}

void test_streaming_compatible(void) __arm_streaming_compatible{
  svuint8_t svuint8_t_val;
  svuint64_t svuint64_t_val;
  uint64_t uint64_t_val;

  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svaesd(svuint8_t_val, svuint8_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svaesd_u8(svuint8_t_val, svuint8_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svaese(svuint8_t_val, svuint8_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svaese_u8(svuint8_t_val, svuint8_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svaesimc(svuint8_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svaesimc_u8(svuint8_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svaesmc(svuint8_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svaesmc_u8(svuint8_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svpmullb_pair(svuint64_t_val, svuint64_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svpmullb_pair(svuint64_t_val, uint64_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svpmullb_pair_n_u64(svuint64_t_val, uint64_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svpmullb_pair_u64(svuint64_t_val, svuint64_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svpmullt_pair(svuint64_t_val, svuint64_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svpmullt_pair(svuint64_t_val, uint64_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svpmullt_pair_n_u64(svuint64_t_val, uint64_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svpmullt_pair_u64(svuint64_t_val, svuint64_t_val);
}
