'\" t
.\"     Title: xchangekeyboarddevice
.\"    Author: [FIXME: author] [see http://docbook.sf.net/el/author]
.\" Generator: DocBook XSL Stylesheets v1.77.1 <http://docbook.sf.net/>
.\"      Date: 03/09/2013
.\"    Manual: \ \&
.\"    Source: \ \&
.\"  Language: English
.\"
.TH "XCHANGEKEYBOARDDEVIC" "libmansuffix" "03/09/2013" "\ \&" "\ \&"
.\" -----------------------------------------------------------------
.\" * Define some portability stuff
.\" -----------------------------------------------------------------
.\" ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.\" http://bugs.debian.org/507673
.\" http://lists.gnu.org/archive/html/groff/2009-02/msg00013.html
.\" ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\" -----------------------------------------------------------------
.\" * set default formatting
.\" -----------------------------------------------------------------
.\" disable hyphenation
.nh
.\" disable justification (adjust text to left margin only)
.ad l
.\" -----------------------------------------------------------------
.\" * MAIN CONTENT STARTS HERE *
.\" -----------------------------------------------------------------
.SH "NAME"
XChangeKeyboardDevice \- change which device is used as the X keyboard
.SH "SYNOPSIS"
.sp
.nf
#include <X11/extensions/XInput\&.h>
.fi
.sp
.nf
Status XChangeKeyboardDevice( Display *display,
                              XDevice *device);
.fi
.sp
.nf
display
       Specifies the connection to the X server\&.
.fi
.sp
.nf
device
       Specifies the device to be used as the X keyboard\&.
.fi
.SH "DESCRIPTION"
.sp
.if n \{\
.RS 4
.\}
.nf
The XChangeKeyboardDevice request causes the server to use the
specified device as the X keyboard\&. The device must have been
previously opened by the requesting client via XOpenDevice or a
BadDevice error will result\&. The device must support input
class Keys, or a BadMatch error will result\&. If the server
implementation does not support using the requested device as
the X keyboard, a BadDevice error will result\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
If the specified device is grabbed by another client,
AlreadyGrabbed is returned\&. If the specified device is frozen
by a grab on another device, GrabFrozen is returned\&. If the
request is successful, Success is returned\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
If the request succeeds, a ChangeDeviceNotify event is sent to
all clients that have selected that event\&. A MappingNotify
event with request = MappingKeyboard is sent to all clients\&.
The specified device becomes the X keyboard and the old X
keyboard becomes accessible through the input extension
protocol requests\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XChangeKeyboardDevice can generate a BadDevice or a BadMatch
error\&.
.fi
.if n \{\
.RE
.\}
.SH "DIAGNOSTICS"
.sp
.if n \{\
.RS 4
.\}
.nf
BadDevice
       An invalid device was specified\&. The specified device
       does not exist, has not been opened by this client via
       XOpenInputDevice, or is already one of the core X device
       (pointer or keyboard)\&. This error may also occur if the
       server implementation does not support using the
       specified device as the X keyboard\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadMatch
       This error may occur if an XChangeKeyboardDevice request
       was made specifying a device that has no keys\&.
.fi
.if n \{\
.RE
.\}
.SH "SEE ALSO"
.sp
.if n \{\
.RS 4
.\}
.nf
XChangePointerDevice(libmansuffix)
.fi
.if n \{\
.RE
.\}
