/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.concurrent.locks;

import info.aduna.concurrent.locks.AbstractLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractDebugLock
extends AbstractLock {
    private Logger logger = null;
    private Throwable creatorTrace;

    public AbstractDebugLock() {
        this(null);
    }

    public AbstractDebugLock(boolean enableTrace) {
        this(null, enableTrace);
    }

    public AbstractDebugLock(Logger logger) {
        this(logger, false);
    }

    public AbstractDebugLock(Logger logger, boolean enableTrace) {
        this.logger = logger;
        if (enableTrace) {
            this.creatorTrace = new Throwable();
        }
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(this.getClass());
        }
        return this.logger;
    }

    protected void finalize() throws Throwable {
        if (this.isActive()) {
            if (this.creatorTrace == null) {
                this.getLogger().warn("Releasing active lock due to object destruction; consider setting the {} system property", (Object)"info.aduna.concurrent.locks.trackLocks");
            } else {
                this.getLogger().warn("Releasing active lock due to object destruction; lock was acquired in", this.creatorTrace);
            }
            this.release();
        }
        super.finalize();
    }
}

