//
// This file is part of the Marble Desktop Globe.
//
// This program is free software licensed under the GNU LGPL. You can
// find a copy of this license in LICENSE.txt in the top directory of
// the source code.
//
// Copyright 2008-2009    Torsten Rahn <tackat@kde.org>"
//

//
// Description: AbstractTile contains the base class for a single quadtile 
//


#ifndef __MARBLE__ABSTRACTTILE_P_H
#define __MARBLE__ABSTRACTTILE_P_H

#include "TileId.h"


namespace Marble
{


class AbstractTilePrivate {
 public:
    AbstractTilePrivate( const TileId& id );
    virtual ~AbstractTilePrivate();

    TileId    m_id;
    bool      m_used;
    AbstractTile::TileState m_state;

    QDateTime m_created;

    AbstractTile * q_ptr;
};

}

#endif // __MARBLE__ABSTRACTTILE_P_H
