//Auto-generated by kalyptus. DO NOT EDIT.
namespace Plasma {
    using Plasma;
    using System;
    using Kimono;
    using Qyoto;
    using System.Text;
    using System.Collections.Generic;
    /// <remarks>
    ///  @class AbstractRunner plasma/abstractrunner.h <Plasma/AbstractRunner>
    ///  Be aware that runners have to be thread-safe. This is due to the fact that
    ///  each runner is executed in its own thread for each new term. Thus, a runner
    ///  may be executed more than once at the same time. See match() for details.
    ///  </remarks>        <short> An abstract base class for Plasma Runner plugins. </short>
    [SmokeClass("Plasma::AbstractRunner")]
    public abstract class AbstractRunner : QObject {
        protected AbstractRunner(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(AbstractRunner), this);
        }
        /// <remarks> Specifies a nominal speed for the runner </remarks>        <short>   Specifies a nominal speed for the runner </short>
        public enum Speed {
            SlowSpeed = 0,
            NormalSpeed = 1,
        }
        /// <remarks> Specifies a priority for the runner </remarks>        <short>   Specifies a priority for the runner </short>
        public enum Priority {
            LowestPriority = 0,
            LowPriority = 1,
            NormalPriority = 2,
            HighPriority = 3,
            HighestPriority = 4,
        }
        // QMutex* bigLock(); >>>> NOT CONVERTED
        /// <remarks>
        ///  This is the main query method. It should trigger creation of
        ///  QueryMatch instances through RunnerContext.AddMatch and 
        ///  RunnerContext.AddMatches. It is called internally by performMatch().
        ///  If the runner can run precisely the requested term (RunnerContext.Query()),
        ///  it should create an exact match by setting the type to RunnerContext.ExactMatch.
        ///  The first runner that creates a QueryMatch will be the
        ///  default runner. Other runner's matches will be suggested in the
        ///  interface. Non-exact matches should be offered via RunnerContext.PossibleMatch.
        ///  The match will be activated via run() if the user selects it.
        ///  Each runner is executed in its own thread. Whenever the user input changes this
        ///  method is called again. Thus, it needs to be thread-safe. Also, all matches need
        ///  to be reported once this method returns. Asyncroneous runners therefore need
        ///  to make use of a local event loop to wait for all matches.
        ///  It is recommended to use local status data in async runners. The simplest way is 
        ///  to have a separate class doing all the work like so:
        ///  <pre>
        ///  void MyFancyAsyncRunner.Match( RunnerContext& context )
        ///  {
        ///      QEventLoop loop;
        ///      MyAsyncWorker worker( context );
        ///      connect( &worker, SIGNAL("finished()"),
        ///               &loop, SLOT("quit()") );
        ///      worker.work();
        ///      loop.exec();
        ///  }
        ///  </pre>
        ///  Here MyAsyncWorker creates all the matches and calls RunnerContext.AddMatch
        ///  in some internal slot. It emits the finished() signal once done which will
        ///  quit the loop and make the match() method return. The local status is kept
        ///  entirely in MyAsyncWorker which makes match() trivially thread-safe.
        ///  If a particular match supports multiple actions, set up the corresponding
        ///  actions in the actionsForMatch method. Do not call any of the action methods
        ///  within this method!
        ///  Execution of the correct action should be handled in the run method.
        ///  @caution This method needs to be thread-safe since KRunner will simply
        ///  start a new thread for each new term.
        ///  @warning Returning from this method means to end execution of the runner.
        ///  @sa run(), RunnerContext.AddMatch, RunnerContext.AddMatches, QueryMatch
        ///          </remarks>        <short>    This is the main query method.</short>
        [SmokeMethod("match(Plasma::RunnerContext&)")]
        public virtual void Match(Plasma.RunnerContext context) {
            interceptor.Invoke("match#", "match(Plasma::RunnerContext&)", typeof(void), typeof(Plasma.RunnerContext), context);
        }
        /// <remarks>
        ///  Triggers a call to match. This will call match() internally.
        ///  @arg context the search context used in executing this match.
        ///          </remarks>        <short>    Triggers a call to match.</short>
        public void PerformMatch(Plasma.RunnerContext context) {
            interceptor.Invoke("performMatch#", "performMatch(Plasma::RunnerContext&)", typeof(void), typeof(Plasma.RunnerContext), context);
        }
        /// <remarks>
        ///  If the runner has options that the user can interact with to modify
        ///  what happens when run or one of the actions created in fillMatches
        ///  is called, the runner should return true
        ///          </remarks>        <short>    If the runner has options that the user can interact with to modify  what happens when run or one of the actions created in fillMatches  is called, the runner should return true          </short>
        public bool HasRunOptions() {
            return (bool) interceptor.Invoke("hasRunOptions", "hasRunOptions()", typeof(bool));
        }
        /// <remarks>
        ///  If hasRunOptions() returns true, this method may be called to get
        ///  a widget displaying the options the user can interact with to modify
        ///  the behaviour of what happens when a given match is selected.
        /// <param> name="widget" the parent of the options widgets.
        ///          </param></remarks>        <short>    If hasRunOptions() returns true, this method may be called to get  a widget displaying the options the user can interact with to modify  the behaviour of what happens when a given match is selected.</short>
        [SmokeMethod("createRunOptions(QWidget*)")]
        public virtual void CreateRunOptions(QWidget widget) {
            interceptor.Invoke("createRunOptions#", "createRunOptions(QWidget*)", typeof(void), typeof(QWidget), widget);
        }
        /// <remarks>
        ///  Called whenever an exact or possible match associated with this
        ///  runner is triggered.
        /// <param> name="context" The context in which the match is triggered, i.e. for which
        ///                 the match was created.
        /// </param><param> name="match" The actual match to run/execute.
        ///          </param></remarks>        <short>    Called whenever an exact or possible match associated with this  runner is triggered.</short>
        [SmokeMethod("run(const Plasma::RunnerContext&, const Plasma::QueryMatch&)")]
        public virtual void Run(Plasma.RunnerContext context, Plasma.QueryMatch match) {
            interceptor.Invoke("run##", "run(const Plasma::RunnerContext&, const Plasma::QueryMatch&)", typeof(void), typeof(Plasma.RunnerContext), context, typeof(Plasma.QueryMatch), match);
        }
        /// <remarks>
        ///  The nominal speed of the runner.
        /// </remarks>        <short>    The nominal speed of the runner.</short>
        ///         <see> setSpeed</see>
        public Plasma.AbstractRunner.Speed speed() {
            return (Plasma.AbstractRunner.Speed) interceptor.Invoke("speed", "speed() const", typeof(Plasma.AbstractRunner.Speed));
        }
        /// <remarks>
        ///  The priority of the runner.
        /// </remarks>        <short>    The priority of the runner.</short>
        ///         <see> setPriority</see>
        public Plasma.AbstractRunner.Priority priority() {
            return (Plasma.AbstractRunner.Priority) interceptor.Invoke("priority", "priority() const", typeof(Plasma.AbstractRunner.Priority));
        }
        /// <remarks>
        ///  Returns the OR'ed value of all the Information types (as defined in RunnerContext.Type)
        ///  this runner is not interested in.
        /// </remarks>        <return> OR'ed value of black listed types
        ///          </return>
        ///         <short>    Returns the OR'ed value of all the Information types (as defined in RunnerContext.Type)  this runner is not interested in.</short>
        public uint IgnoredTypes() {
            return (uint) interceptor.Invoke("ignoredTypes", "ignoredTypes() const", typeof(uint));
        }
        /// <remarks>
        ///  Sets the types this runner will ignore
        /// <param> name="types" OR'ed listed of ignored types
        ///          </param></remarks>        <short>    Sets the types this runner will ignore </short>
        public void SetIgnoredTypes(uint types) {
            interceptor.Invoke("setIgnoredTypes$", "setIgnoredTypes(Plasma::RunnerContext::Types)", typeof(void), typeof(uint), types);
        }
        /// <remarks>
        ///  Returns the user visible engine name for the Runner
        ///           </remarks>        <short>    Returns the user visible engine name for the Runner           </short>
        public string Name() {
            return (string) interceptor.Invoke("name", "name() const", typeof(string));
        }
        /// <remarks>
        ///  Returns an id string for the Runner
        ///           </remarks>        <short>    Returns an id string for the Runner           </short>
        public string Id() {
            return (string) interceptor.Invoke("id", "id() const", typeof(string));
        }
        /// <remarks>
        ///  Returns the description of this Runner
        ///           </remarks>        <short>    Returns the description of this Runner           </short>
        public string Description() {
            return (string) interceptor.Invoke("description", "description() const", typeof(string));
        }
        /// <remarks>
        ///  Accessor for the associated Package object if any.
        ///  Note that the returned pointer is only valid for the lifetime of
        ///  the runner.
        /// </remarks>        <return> the Package object, or 0 if none
        /// </return>
        ///         <short>    Accessor for the associated Package object if any.</short>
        public Plasma.Package Package() {
            return (Plasma.Package) interceptor.Invoke("package", "package() const", typeof(Plasma.Package));
        }
        /// <remarks>
        ///  Signal runner to reload its configuration.
        ///          </remarks>        <short>    Signal runner to reload its configuration.</short>
        [SmokeMethod("reloadConfiguration()")]
        public virtual void ReloadConfiguration() {
            interceptor.Invoke("reloadConfiguration", "reloadConfiguration()", typeof(void));
        }
        /// <remarks>
        ///  Constructs a Runner object. Since AbstractRunner has pure virtuals,
        ///  this constructor can not be called directly. Rather a subclass must
        ///  be created
        ///          </remarks>        <short>    Constructs a Runner object.</short>
        public AbstractRunner(QObject parent, string serviceId) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("AbstractRunner#$", "AbstractRunner(QObject*, const QString&)", typeof(void), typeof(QObject), parent, typeof(string), serviceId);
        }
        public AbstractRunner(QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("AbstractRunner#", "AbstractRunner(QObject*)", typeof(void), typeof(QObject), parent);
        }
        public AbstractRunner() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("AbstractRunner", "AbstractRunner()", typeof(void));
        }
        public AbstractRunner(QObject parent, List<QVariant> args) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("AbstractRunner#?", "AbstractRunner(QObject*, const QList<QVariant>&)", typeof(void), typeof(QObject), parent, typeof(List<QVariant>), args);
        }
        /// <remarks>
        ///  Provides access to the runner's configuration object.
        ///          </remarks>        <short>    Provides access to the runner's configuration object.</short>
        protected KConfigGroup Config() {
            return (KConfigGroup) interceptor.Invoke("config", "config() const", typeof(KConfigGroup));
        }
        /// <remarks>
        ///  Sets whether or not the runner has options for matches
        ///          </remarks>        <short>    Sets whether or not the runner has options for matches          </short>
        protected void SetHasRunOptions(bool hasRunOptions) {
            interceptor.Invoke("setHasRunOptions$", "setHasRunOptions(bool)", typeof(void), typeof(bool), hasRunOptions);
        }
        /// <remarks>
        ///  Sets the nominal speed of the runner. Only slow runners need
        ///  to call this within their constructor because the default
        ///  speed is NormalSpeed. Runners that use DBUS should call
        ///  this within their constructors.
        ///          </remarks>        <short>    Sets the nominal speed of the runner.</short>
        protected void SetSpeed(Plasma.AbstractRunner.Speed newSpeed) {
            interceptor.Invoke("setSpeed$", "setSpeed(Plasma::AbstractRunner::Speed)", typeof(void), typeof(Plasma.AbstractRunner.Speed), newSpeed);
        }
        /// <remarks>
        ///  Sets the priority of the runner. Lower priority runners are executed
        ///  only after higher priority runners.
        ///          </remarks>        <short>    Sets the priority of the runner.</short>
        protected void SetPriority(Plasma.AbstractRunner.Priority newPriority) {
            interceptor.Invoke("setPriority$", "setPriority(Plasma::AbstractRunner::Priority)", typeof(void), typeof(Plasma.AbstractRunner.Priority), newPriority);
        }
        /// <remarks>
        ///  A blocking method to do queries of installed Services which can provide
        ///  a measure of safety for runners running their own threads. This should
        ///  be used instead of calling KServiceTypeTrader.Query(..) directly.
        ///  @arg serviceType a service type like "Plasma/Applet" or "KFilePlugin"
        ///  @arg constraint a constraint to limit the choices returned.
        /// </remarks>        <return> a list of services that satisfy the query.
        ///          </return>
        ///         <short>    A blocking method to do queries of installed Services which can provide  a measure of safety for runners running their own threads.</short>
        ///         <see> KServiceTypeTrader.Query(const</see>
        ///         <see> const</see>
        protected List<KService> ServiceQuery(string serviceType, string constraint) {
            return (List<KService>) interceptor.Invoke("serviceQuery$$", "serviceQuery(const QString&, const QString&) const", typeof(List<KService>), typeof(string), serviceType, typeof(string), constraint);
        }
        protected List<KService> ServiceQuery(string serviceType) {
            return (List<KService>) interceptor.Invoke("serviceQuery$", "serviceQuery(const QString&) const", typeof(List<KService>), typeof(string), serviceType);
        }
        /// <remarks>
        ///  A given match can have more than action that can be performed on it.
        ///  For example, a song match returned by a music player runner can be queued,
        ///  added to the playlist, or played.
        ///  Call this method to add actions that can be performed by the runner.
        ///  Actions must first be added to the runner's action registry.
        ///  Note: execution of correct action is left up to the runner.
        ///          </remarks>        <short>    A given match can have more than action that can be performed on it.</short>
        [SmokeMethod("actionsForMatch(const Plasma::QueryMatch&)")]
        protected virtual List<QAction> ActionsForMatch(Plasma.QueryMatch match) {
            return (List<QAction>) interceptor.Invoke("actionsForMatch#", "actionsForMatch(const Plasma::QueryMatch&)", typeof(List<QAction>), typeof(Plasma.QueryMatch), match);
        }
        /// <remarks>
        ///  Creates and then adds an action to the action registry.
        ///  AbstractRunner assumes ownership of the created action.
        /// <param> name="id" A unique identifier string
        /// </param><param> name="icon" The icon to display
        /// </param><param> name="text" The text to display
        /// </param></remarks>        <return> the created QAction
        ///          </return>
        ///         <short>    Creates and then adds an action to the action registry.</short>
        protected QAction AddAction(string id, QIcon icon, string text) {
            return (QAction) interceptor.Invoke("addAction$#$", "addAction(const QString&, const QIcon&, const QString&)", typeof(QAction), typeof(string), id, typeof(QIcon), icon, typeof(string), text);
        }
        /// <remarks>
        ///  Adds an action to the runner's action registry.
        ///  The QAction must be created within the GUI thread;
        ///  do not create it within the match method of AbstractRunner.
        /// <param> name="id" A unique identifier string
        /// </param><param> name="action" The QAction to be stored
        ///          </param></remarks>        <short>    Adds an action to the runner's action registry.</short>
        protected void AddAction(string id, QAction action) {
            interceptor.Invoke("addAction$#", "addAction(const QString&, QAction*)", typeof(void), typeof(string), id, typeof(QAction), action);
        }
        /// <remarks>
        ///  Removes the action from the action registry.
        ///  AbstractRunner deletes the action once removed.
        /// <param> name="id" The id of the action to be removed
        ///          </param></remarks>        <short>    Removes the action from the action registry.</short>
        protected void RemoveAction(string id) {
            interceptor.Invoke("removeAction$", "removeAction(const QString&)", typeof(void), typeof(string), id);
        }
        /// <remarks>
        ///  Returns the action associated with the id
        ///          </remarks>        <short>    Returns the action associated with the id          </short>
        protected QAction Action(string id) {
            return (QAction) interceptor.Invoke("action$", "action(const QString&) const", typeof(QAction), typeof(string), id);
        }
        /// <remarks>
        ///  Returns all registered actions
        ///          </remarks>        <short>    Returns all registered actions          </short>
        protected string Actions() {
            return (string) interceptor.Invoke("actions", "actions() const", typeof(string));
        }
        /// <remarks>
        ///  Clears the action registry.
        ///  The action pool deletes the actions.
        ///          </remarks>        <short>    Clears the action registry.</short>
        protected void ClearActions() {
            interceptor.Invoke("clearActions", "clearActions()", typeof(void));
        }
        [Q_SLOT("void init()")]
        protected void Init() {
            interceptor.Invoke("init", "init()", typeof(void));
        }
        /// <remarks>
        ///  Access to a shared lock that all runners (and code that manages/interacts with them)
        ///  can share to protect access to non-thread-safe shared code or data.
        ///  Access of KSycoca records, for instance, is one place this lock should be used.
        ///  Common usage:
        ///  {
        ///      QMutexLocker lock(bigLock());
        ///      .. do something that isn't thread safe ..
        ///  }
        ///          </remarks>        <short>    Access to a shared lock that all runners (and code that manages/interacts with them)  can share to protect access to non-thread-safe shared code or data.</short>
        protected new IAbstractRunnerSignals Emit {
            get { return (IAbstractRunnerSignals) Q_EMIT; }
        }
    }

    public interface IAbstractRunnerSignals : IQObjectSignals {
    }
}
