//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    /// <remarks>
    ///  A basic message object used for exchanging filtering
    ///  information between the filter plugins and the application
    ///  requesting the filtering service.
    ///  Use this object if you require a more detailed information
    ///  about the URI you want to filter. Any application can create
    ///  an instance of this class and send it to KUriFilter to
    ///  have the plugins fill out all possible information about the
    ///  URI.
    ///  <b></b>xample
    ///  <pre>
    ///    string text = "kde.org";
    ///    KUriFilterData d = text;
    ///    bool filtered = KUriFilter.Self().Filter( d );
    ///    cout << "URL: " << text.toLatin1() << endl
    ///         << "Filtered URL: " << d.uri().url().toLatin1() << endl
    ///         << "URI Type: " << d.uriType() << endl
    ///         << "Was Filtered: " << filtered << endl;
    ///  </pre>
    ///  The above code should yield the following output:
    ///  <pre>
    ///    URI: kde.org
    ///    Filtered URI: http://kde.org
    ///    URI Type: 0            <== means NET_PROTOCOL
    ///    Was Filtered: 1        <== means the URL was successfully filtered
    ///  </pre>
    /// </remarks>        <author> Dawit Alemayehu <adawit at kde.org>
    /// </author>
    ///         <short> A message object for exchanging filtering URI info. </short>
    [SmokeClass("KUriFilterData")]
    public class KUriFilterData : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected KUriFilterData(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KUriFilterData), this);
        }
        /// <remarks>
        ///  Describes the type of the URI that was filtered.
        ///  Here is a brief description of the types:
        /// 
        /// <li>
        /// NetProtocol  - Any network protocol: http, ftp, nttp, pop3, etc...
        /// </li>
        /// 
        /// <li>
        /// LocalFile    - A local file whose executable flag is not set
        /// </li>
        /// 
        /// <li>
        /// LocalDir     - A local directory
        /// </li>
        /// 
        /// <li>
        /// Executable   - A local file whose executable flag is set
        /// </li>
        /// 
        /// <li>
        /// Help         - A man or info page
        /// </li>
        /// 
        /// <li>
        /// Shell        - A shell executable (ex: echo "Test..." >> ~/testfile)
        /// </li>
        /// 
        /// <li>
        /// Blocked      - A URI that should be blocked/filtered (ex: ad filtering)
        /// </li>
        /// 
        /// <li>
        /// Error        - An incorrect URI (ex: "~johndoe" when user johndoe
        ///                     does not exist in that system )
        /// </li>
        /// 
        /// <li>
        /// Unknown      - A URI that is not identified. Default value when
        ///                     a KUriFilterData is first created.
        ///      
        /// </li></remarks>        <short>    Describes the type of the URI that was filtered.</short>
        public enum UriTypes {
            NetProtocol = 0,
            LocalFile = 1,
            LocalDir = 2,
            Executable = 3,
            Help = 4,
            Shell = 5,
            Blocked = 6,
            Error = 7,
            Unknown = 8,
        }
        /// <remarks>
        ///  Default constructor.
        ///  Creates a UriFilterData object.
        ///      </remarks>        <short>    Default constructor.</short>
        public KUriFilterData() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KUriFilterData", "KUriFilterData()", typeof(void));
        }
        /// <remarks>
        ///  Creates a UriFilterData object from the given URL.
        /// <param> name="url" is the URL to be filtered.
        ///      </param></remarks>        <short>    Creates a UriFilterData object from the given URL.</short>
        public KUriFilterData(KUrl url) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KUriFilterData#", "KUriFilterData(const KUrl&)", typeof(void), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Creates a UriFilterData object from the given string.
        /// <param> name="url" is the string to be filtered.
        ///      </param></remarks>        <short>    Creates a UriFilterData object from the given string.</short>
        public KUriFilterData(string url) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KUriFilterData$", "KUriFilterData(const QString&)", typeof(void), typeof(string), url);
        }
        /// <remarks>
        ///  Copy constructor.
        ///  Creates a UriFilterData object from another
        ///  URI filter data object.
        /// <param> name="data" the uri filter data to be copied.
        ///      </param></remarks>        <short>    Copy constructor.</short>
        public KUriFilterData(KUriFilterData data) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KUriFilterData#", "KUriFilterData(const KUriFilterData&)", typeof(void), typeof(KUriFilterData), data);
        }
        /// <remarks>
        ///  Returns the filtered or the original URL.
        ///  This function returns the filtered url if one
        ///  of the plugins successfully filtered the original
        ///  URL.  Otherwise, it returns the original URL.
        ///  See hasBeenFiltered() and
        /// </remarks>        <return> the filtered or original url.
        ///      </return>
        ///         <short>    Returns the filtered or the original URL.</short>
        public KUrl Uri() {
            return (KUrl) interceptor.Invoke("uri", "uri() const", typeof(KUrl));
        }
        /// <remarks>
        ///  Returns an error message.
        ///  This functions returns the error message set
        ///  by the plugin whenever the uri type is set to
        ///  KUriFilterData.ERROR.  Otherwise, it returns
        ///  a string().
        /// </remarks>        <return> the error message or a NULL when there is none.
        ///      </return>
        ///         <short>    Returns an error message.</short>
        public string ErrorMsg() {
            return (string) interceptor.Invoke("errorMsg", "errorMsg() const", typeof(string));
        }
        /// <remarks>
        ///  Returns the URI type.
        ///  This method always returns KUriFilterData.UNKNOWN
        ///  if the given URL was not filtered.
        /// </remarks>        <return> the type of the URI
        ///      </return>
        ///         <short>    Returns the URI type.</short>
        public KUriFilterData.UriTypes UriType() {
            return (KUriFilterData.UriTypes) interceptor.Invoke("uriType", "uriType() const", typeof(KUriFilterData.UriTypes));
        }
        /// <remarks>
        ///  Same as above except the argument is a URL.
        ///  Use this function to set the string to be
        ///  filtered when you construct an empty filter
        ///  object.
        /// <param> name="url" the URL to be filtered.
        ///      </param></remarks>        <short>    Same as above except the argument is a URL.</short>
        public void SetData(KUrl url) {
            interceptor.Invoke("setData#", "setData(const KUrl&)", typeof(void), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Sets the URL to be filtered.
        ///  Use this function to set the string to be
        ///  filtered when you construct an empty filter
        ///  object.
        /// <param> name="url" the string to be filtered.
        ///      </param></remarks>        <short>    Sets the URL to be filtered.</short>
        public void SetData(string url) {
            interceptor.Invoke("setData$", "setData(const QString&)", typeof(void), typeof(string), url);
        }
        /// <remarks>
        ///  Sets the absolute path to be used whenever the supplied
        ///  data is a relative local URL.
        ///  NOTE: This function should only be used for local resources,
        ///  i.e. the "file:/" protocol. It is useful for specifying the
        ///  absolute path in cases where the actual URL might be relative.
        ///  meta object.  If deriving the path from a KUrl, make sure you
        ///  set the argument for this function to the result of calling
        ///  path () instead of url ().
        /// <param> name="abs_path" the abolute path to the local resource.
        /// </param></remarks>        <return> true if absolute path is successfully set. Otherwise, false.
        ///      </return>
        ///         <short>    Sets the absolute path to be used whenever the supplied  data is a relative local URL.</short>
        public bool SetAbsolutePath(string abs_path) {
            return (bool) interceptor.Invoke("setAbsolutePath$", "setAbsolutePath(const QString&)", typeof(bool), typeof(string), abs_path);
        }
        /// <remarks>
        ///  Returns the absolute path if one has already been set.
        /// </remarks>        <return> the absolute path, or string()
        /// </return>
        ///         <short>    Returns the absolute path if one has already been set.</short>
        ///         <see> hasAbsolutePath</see>
        public string AbsolutePath() {
            return (string) interceptor.Invoke("absolutePath", "absolutePath() const", typeof(string));
        }
        /// <remarks>
        ///  Checks whether the supplied data had an absolute path.
        /// </remarks>        <return> true if the supplied data has an absolute path
        /// </return>
        ///         <short>    Checks whether the supplied data had an absolute path.</short>
        ///         <see> absolutePath</see>
        public bool HasAbsolutePath() {
            return (bool) interceptor.Invoke("hasAbsolutePath", "hasAbsolutePath() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns the command line options and arguments for a
        ///  local resource when present.
        /// </remarks>        <return> options and arguments when present, otherwise string()
        ///      </return>
        ///         <short>    Returns the command line options and arguments for a  local resource when present.</short>
        public string ArgsAndOptions() {
            return (string) interceptor.Invoke("argsAndOptions", "argsAndOptions() const", typeof(string));
        }
        /// <remarks>
        ///  Checks whether the current data is a local resource with
        ///  command line options and arguments.
        /// </remarks>        <return> true if the current data has command line options and arguments
        ///      </return>
        ///         <short>    Checks whether the current data is a local resource with  command line options and arguments.</short>
        public bool HasArgsAndOptions() {
            return (bool) interceptor.Invoke("hasArgsAndOptions", "hasArgsAndOptions() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns the name of the icon that matches
        ///  the current filtered URL.
        ///  NOTE that this function will return a NULL
        ///  string by default and when no associated icon
        ///  is found.
        /// </remarks>        <return> the name of the icon associated with the resource,
        ///          or string() if not found
        ///      </return>
        ///         <short>    Returns the name of the icon that matches  the current filtered URL.</short>
        public string IconName() {
            return (string) interceptor.Invoke("iconName", "iconName()", typeof(string));
        }
        /// <remarks>
        ///  Check whether the provided uri is executable or not.
        ///  Setting this to false ensures that typing the name of
        ///  an executable does not start that application. This is
        ///  useful in the location bar of a browser. The default
        ///  value is true.
        ///      </remarks>        <short>    Check whether the provided uri is executable or not.</short>
        public void SetCheckForExecutables(bool check) {
            interceptor.Invoke("setCheckForExecutables$", "setCheckForExecutables(bool)", typeof(void), typeof(bool), check);
        }
        /// <remarks>
        /// </remarks>        <return> true if the filters should attempt to check whether the
        ///  supplied uri is an executable. False otherwise.
        ///      </return>
        ///         <short>   </short>
        public bool CheckForExecutables() {
            return (bool) interceptor.Invoke("checkForExecutables", "checkForExecutables() const", typeof(bool));
        }
        /// <remarks>
        /// </remarks>        <return> the string as typed by the user, before any URL processing is done
        ///      </return>
        ///         <short>   </short>
        public string TypedString() {
            return (string) interceptor.Invoke("typedString", "typedString() const", typeof(string));
        }
        ~KUriFilterData() {
            interceptor.Invoke("~KUriFilterData", "~KUriFilterData()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~KUriFilterData", "~KUriFilterData()", typeof(void));
        }
    }
}
