/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import java.math.BigInteger;
import java.security.SecureRandom;

public final class DHKeyExchange {
    public BigInteger a;
    public BigInteger b;
    public BigInteger c;
    public BigInteger d;
    public static final byte[] e = new byte[]{-12, -120, -3, 88, 78, 73, -37, -51, 32, -76, -99, -28, -111, 7, 54, 107, 51, 108, 56, 13, 69, 29, 15, 124, -120, -77, 28, 124, 91, 45, -114, -10, -13, -55, 35, -64, 67, -16, -91, 91, 24, -115, -114, -69, 85, -116, -72, 93, 56, -45, 52, -3, 124, 23, 87, 67, -93, 29, 24, 108, -34, 51, 33, 44, -75, 42, -1, 60, -31, -79, 41, 64, 24, 17, -115, 124, -124, -89, 10, 114, -42, -122, -60, 3, 25, -56, 7, 41, 122, -54, -107, 12, -39, -106, -97, -85, -48, 10, 80, -101, 2, 70, -45, 8, 61, 102, -92, 93, 65, -97, -100, 124, -67, -119, 75, 34, 25, 38, -70, -85, -94, 94, -61, 85, -23, 47, 120, -57};
    public static final BigInteger skip1024Modulus = new BigInteger(1, e);
    public static final BigInteger skip1024Base = BigInteger.valueOf(2L);
    public static final byte[] f = new byte[]{-84, -56, 20, -98, -122, 43, -77, 43, 30, -10, -71, 114, 84, -8, 67, -70, 71, -8, -111, 80, 119, 34, -95, 107, 89, 124, 64, 127, 37, 118, 76, -60, -15, -95, -48, 105, 2, -123, -35, 16, -65, -27, 117, -124, -107, 111, 37, -87, -40, -127, -99, -94, 51, -112, 37, -92, -97, -97, 56, 83, 103, -20, 21, 5};
    public static final BigInteger export512Modulus = new BigInteger(1, f);
    public static final BigInteger export512Base = BigInteger.valueOf(2L);

    public DHKeyExchange() {
        this.a = skip1024Modulus;
        this.b = skip1024Base;
    }

    public DHKeyExchange(BigInteger bigInteger, BigInteger bigInteger2) {
        this.a = bigInteger;
        this.b = bigInteger2;
    }

    public DHKeyExchange(SecureRandom secureRandom, int n2, int n3) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3 = BigInteger.valueOf(1L);
        do {
            bigInteger = new BigInteger(n2, n3, secureRandom);
            bigInteger2 = bigInteger.subtract(bigInteger3);
        } while (!(bigInteger2 = bigInteger2.shiftRight(1)).isProbablePrime(n3));
        this.a = bigInteger;
        this.b = skip1024Base;
    }

    public void generateKeyPair(SecureRandom secureRandom, int n2) {
        this.d = new BigInteger(n2, secureRandom);
        this.c = this.b.modPow(this.d, this.a);
    }

    public byte[] getAgreedSecret(BigInteger bigInteger) {
        byte[] byArray = bigInteger.modPow(this.d, this.a).toByteArray();
        if (byArray.length << 3 != this.a.bitLength()) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    public BigInteger getBase() {
        return this.b;
    }

    public BigInteger getModulus() {
        return this.a;
    }

    public BigInteger getPrivateKey() {
        return this.d;
    }

    public BigInteger getPublicKey() {
        if (this.c == null) {
            this.c = this.b.modPow(this.d, this.a);
        }
        return this.c;
    }

    public void setPrivateKey(BigInteger bigInteger) {
        this.d = bigInteger;
    }
}

