/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _BCACHEFS_SYSFS_H_
#define _BCACHEFS_SYSFS_H_

#include <linux/sysfs.h>

struct attribute;
struct sysfs_ops;

extern struct attribute *bch2_fs_files[];
extern struct attribute *bch2_fs_counters_files[];
extern struct attribute *bch2_fs_internal_files[];
extern struct attribute *bch2_fs_opts_dir_files[];
extern struct attribute *bch2_fs_time_stats_files[];
extern struct attribute *bch2_fs_time_stats_json_files[];
extern struct attribute *bch2_dev_files[];

extern const struct sysfs_ops bch2_fs_sysfs_ops;
extern const struct sysfs_ops bch2_fs_counters_sysfs_ops;
extern const struct sysfs_ops bch2_fs_internal_sysfs_ops;
extern const struct sysfs_ops bch2_fs_opts_dir_sysfs_ops;
extern const struct sysfs_ops bch2_fs_time_stats_sysfs_ops;
extern const struct sysfs_ops bch2_fs_time_stats_json_sysfs_ops;
extern const struct sysfs_ops bch2_dev_sysfs_ops;

extern struct bin_attribute bin_attr_btree_trans_stats_json;

int bch2_opts_create_sysfs_files(struct kobject *, unsigned);

#endif  /* _BCACHEFS_SYSFS_H_ */
