/*#define DEBUG*/
/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_callbacks.h"
#include "glade_gui.h"
#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "apps.h"
#include "add_file.h"
#include "add_folder.h"
#include "add_node_contents.h"
#include "aux.h"
#include "bookmarks.h"
#include "dummies.h"
#include "entry.h"
#include "filter.h"
#include "goto.h"
#include "icons.h"
#include "input.h"
#include "menu.h"
#include "misc.h"
#include "monitor.h"
#include "reg.h"
#include "run.h"
#include "smb_misc.h"
#include "smb_open.h"
#include "trash.h"
#include "treeview.h"
#include "treestore.h"
#include "widgets.h"
#include "xfstab.h"


/* bug workaround (double click signals click first)*/
static gboolean skip = FALSE;
static GtkTreeRowReference *title_reference=NULL;

extern int stop;
/*XXX for gtk bug workaround with flashing treeview on expand/collapse
 * ater scroll if root not visible: */
extern GtkTreeViewColumn *name_column;

static gboolean valid_iter(GtkTreeView * treeview,GtkTreeIter * iter){
    tree_entry_t *en;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    gtk_tree_model_get(GTK_TREE_MODEL(treemodel), iter, ENTRY_COLUMN, &en, -1);
    if (!en) return FALSE;
    if (IS_PATH(en->type) && access(en->path,F_OK)!=0) return FALSE;
    return TRUE;
}

void open_dir(GtkTreeView * treeview, GtkTreeIter * iter, GtkTreePath * treepath, gpointer user_data)
{
    tree_entry_t *en;
    struct stat st;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    tree_details_t *tree_details = get_tree_details(treeview);
    char *filter = get_filter(tree_details->window);
    GtkTreeIter child;
    static gchar **window_title=NULL;
    static gboolean red_light=FALSE;

#ifdef DEBUG
	printf("DBG: open_dir ...\n");
#endif
    if (!valid_iter(treeview,iter)){
	    local_monitor(treeview,TRUE);
	    return;
    }
   if (!window_title) {
	    window_title=(gchar **)malloc(sizeof(gchar *));
	    *window_title=NULL;
    }
  
    if(!set_load_wait(&tree_details))
    {
	gtk_tree_view_collapse_row(treeview, treepath);
	return;
    }
    if (red_light){
#ifdef DEBUG
	printf("DBG: open_dir red_light return...\n");
#endif
	return;
    }
    red_light=TRUE;	    
    cursor_wait(treeview);
    gtk_tree_model_get(GTK_TREE_MODEL(treemodel), iter, ENTRY_COLUMN, &en, -1);
#ifdef DEBUG
	printf("DBG: open_dir callback...\n");
#endif
    if(!en || !en->path) goto time2return;
    if (!IS_FSTAB_TYPE(en->type) && 
	!IS_APP_TYPE(en->type) && 
	!IS_TRASH_TYPE(en->type) && 
	!IS_NETWORK_TYPE(en->type) && 
	!IS_BOOKMARK_TYPE(en->type) && 
	!en->st
       ) goto time2return;

    if(en->filter && strcmp(en->filter, get_filter(tree_details->window))){
	/*printf("DBG: UNSET_LOADED filter && strcmp(filter, get_filter)\n");*/
	UNSET_LOADED(en->type);
    }

    if(stat(en->path, &st) >= 0)
    {
	if(st.st_mtime != en->st->st_mtime)
	{
	    /*printf("DBG: UNSET_LOADED st.st_mtime != en->st->st_mtime\n");*/
	    memcpy(en->st, &st, sizeof(struct stat));
	    UNSET_LOADED(en->type);
	}
    }
    else if(IS_PATH(en->type) && lstat(en->path, &st) < 0)
    {
	/* bye bye */
	GtkTreePath *path = gtk_tree_model_get_path(treemodel, iter);
	GtkTreeRowReference *ref = gtk_tree_row_reference_new(treemodel, path);
	    /*printf("DBG: bye bye remove_it\n");*/
	remove_it(treeview, ref);
	gtk_tree_path_free(path);
	gtk_tree_row_reference_free(ref);
	goto time2return;

    }
    SET_EXPANDED(en->type);
    if(IS_ROOT_TYPE(en->type) && 
       (IS_BOOKMARK_TYPE(en->type) || 
	IS_TRASH_TYPE(en->type) || 
	IS_APP_TYPE(en->type) || 
	IS_FSTAB_TYPE(en->type)
       )
      )
    {
	if(!IS_LOADED(en->type))
	{
	    if(IS_APP_TYPE(en->type))
	    {
		/*while(gtk_events_pending()) gtk_main_iteration();*/
		if(open_apps(treeview, iter, treepath, user_data) <= 0)
		{
		    print_status(treeview, "xf_ERROR_ICON", 
				    strerror(errno),NULL);
		    reset_dummy(treeview, iter, -8);
		}
    		/*hide_stop(tree_details->window);*/
	        goto time2return;
	    }
            if(IS_FSTAB_TYPE(en->type))
	    {
		/*while(gtk_events_pending()) gtk_main_iteration();*/
		if(open_fstab(treeview, iter, treepath, user_data) < 0)
		{
		    print_status(treeview, "xf_ERROR_ICON", 
				    strerror(errno),NULL);
		}
    		/*hide_stop(tree_details->window);*/
	        goto time2return;
	    }
	    if(IS_BOOKMARK_TYPE(en->type))
	    {
		print_status(treeview, "xf_WARNING_ICON", 
				_("Loading bookmarks"), NULL);
		/*while(gtk_events_pending()) gtk_main_iteration();*/
		if(open_bookmarks(treeview, iter, treepath, user_data) < 0)
		{
		    print_status_tmp(treeview, resolve_icon_small(en), 
				    _("No bookmarks have been collected."), 
				    NULL);
		    reset_dummy(treeview, iter, 3);
		}
		if (en->tag && strchr(en->tag,'%'))
		   print_status(treeview,  "xf_BOOKMARKS_ICON",
			       	" ", NULL);
		else
		   print_status(treeview, "xf_BOOKMARKS_ICON", 
				   en->tag, NULL);
	        goto time2return;
	    }
	    if(IS_TRASH_TYPE(en->type))
	    {
		int result;
		gtk_tree_view_collapse_row(treeview, treepath);
		print_status(treeview, "xf_WARNING_ICON", 
				"Loading trash bin", NULL);
		/*while(gtk_events_pending()) gtk_main_iteration();*/
		if((result = open_trash(treeview, iter, treepath, user_data)) < 0)
		{

		    print_status_tmp(treeview, resolve_icon_small(en), 
				    (result == -1) ?
				    _("No trash has been collected.") :
				    _("Trash load aborted."), NULL);
		    /*reset_dummy (treeview, iter, 1); */
		    /*hide_stop(tree_details->window);*/
		}
		else
		{
		    /*while(gtk_events_pending()) gtk_main_iteration();*/
		    unset_load_wait(&tree_details);
		    hide_stop(tree_details->window);
		    print_status(treeview, "xf_WARNING_ICON", "Expanding trash bin", NULL);
		    gtk_tree_view_expand_row(treeview, treepath, FALSE);
		}
	    }
	    goto time2return;
	}
	if (en->tag && strchr(en->tag,'%'))
		print_status_tmp(treeview, resolve_icon_small(en),
			       	FILENAME(en), NULL);
	else
		print_status_tmp(treeview, resolve_icon_small(en),
			       	en->tag, NULL);
	/*set_select_path(treemodel,iter,tree_details); */
	/* when expand icon is different: set_icon(treeview,iter); */

    }
    if(!IS_LOADED(en->type) && 
	(IS_NETWORK_TYPE(en->type) ||
	IS_XF_NETWS(en->subtype) ||     /* will enable bookmarks */
	IS_XF_NETSHARE(en->subtype) ||
	IS_NETDIR(en->subtype) )
      )
    {
	    /*printf("DBG: network...\n");*/
    process_pending_gtk();

	if(!open_smb(treeview, iter, treepath, user_data))
	{
	    /*print_status(treeview, "xf_ERROR_ICON", strerror(errno),NULL);*/
	}
    	/*hide_stop(tree_details->window);*/
        goto time2return;
    }
    if(IS_NETWORK_TYPE(en->type) && IS_LOADED(en->type)){
	SET_EXPANDED(en->type);
	set_icon(treeview, iter);
    }
    if(IS_APP_TYPE(en->type)){
	    reset_dummy(treeview, iter, 1);	    
    }
    if(IS_DIR(en->type))
    {
	/*printf("DBG:opening %s\n",en->path); */
	/* if filterchanged reload as well */
	if(!IS_LOADED(en->type) || IS_INCOMPLETE(en->type) ||
	   (IS_LOADED(en->type) &&
    	    ((!filter && en->filter)  || 
	      (filter && !en->filter) || 
	      strcmp(en->filter, filter)
	     )
	    )
	   )
	{
	    /*printf("DBG: loaded=%d, filter=%s,en->filter=%s\n",
			    IS_LOADED(en->type),
			    (filter)?filter:"NULL",
			    (en->filter)?en->filter:"NULL");*/
	    remove_folder(treeview, iter);
	    UNSET_INCOMPLETE(en->type);
	    print_status(treeview, "xf_WARNING_ICON", "Loading", " : ", FILENAME(en), NULL);
    process_pending_gtk();

	    if(access(en->path, X_OK))
	    {
		goto time2return;
	    }
	    add_folder(treeview, iter);
	    gtk_tree_store_set((GtkTreeStore *) treemodel, iter, SIZE_COLUMN, sizetag(-1, en->count), -1);

	    unset_load_wait(&tree_details);
	    hide_stop(tree_details->window);
	    if (IS_INCOMPLETE(en->type))
		    print_status(treeview,"xf_WARNING_ICON",
				    _("Load is incomplete"),NULL);
	    else SET_LOADED(en->type);
	    /*printf("DBG: callback expanding\n");*/
	    gtk_tree_view_expand_row(treeview, treepath, FALSE);
	}
	if(!tree_details->window)  exit(1);
	/*bug causer here : while(gtk_events_pending())  gtk_main_iteration();*/
        /*this might not cause a bug because a race condition with
	 * gtk treeview operations, but YMMV */
	/*process_pending_gtk();*/

	/*set_select_path(treemodel,iter,tree_details); */
	set_icon(treeview, iter);

	    /*printf("DBG: tag writing %s\n",en->path);*/
	if (en->tag && strchr(en->tag,'%'))
		print_status_tmp(treeview, resolve_icon_small(en),
			       	FILENAME(en), NULL);
	else
		print_status_tmp(treeview, resolve_icon_small(en),
			       	en->tag, NULL);

    }
  time2return:
#ifdef DEBUG
	printf("DBG: opendir time2return.\n"); 
#endif
    set_icon(treeview,iter);
	
#if 10
    if(gtk_tree_model_iter_children(treemodel, &child, iter)){
#ifdef DEBUG
	printf("DBG: doing children\n"); 
#endif
      do {
	tree_entry_t *c_en;    
        gtk_tree_model_get(treemodel, &child, ENTRY_COLUMN, &c_en, -1);
	if (c_en && IS_DIR(c_en->type)) {
#ifdef DEBUG
	      printf("DBG: icon setting for %s\n",c_en->path); 
#endif
		set_icon(treeview, &child);
	}
      } while(gtk_tree_model_iter_next(treemodel, &child));
    }
#endif
    hide_stop(tree_details->window);
    if(!tree_details->window) exit(1);

#ifdef DEBUG
	printf("DBG: open_dir, unsetting load wait\n"); 
#endif
    unset_load_wait(&tree_details);
   /* bug causer here : while(gtk_events_pending())gtk_main_iteration();*/
   /* and even this will ocasional do a crash: process_pending_gtk(); 
    * it is cause by a race condition with gtk internals...*/
#ifdef DEBUG
	printf("DBG: open_dir, setting title\n"); 
#endif
    if(en && en->path){
	g_free(*window_title);
	*window_title=NULL;
	 /* ascii readable conversion for smb items are here */
	if (title_reference) gtk_tree_row_reference_free(title_reference);
       	title_reference = gtk_tree_row_reference_new(treemodel, treepath);
	
        *window_title=g_strdup((en&&en->path)?en->path:"xffm");
	if (IS_NETTHING(en->subtype) && !IS_SAMBA_SERVER(en->subtype)){
	    ascii_readable(*window_title);
	} 
	set_title(treeview,window_title);
    }

    if(tree_details->preferences & AUTOSCROLL){
	gdk_flush();
	/*XXX gtk bug, scrolling does not always occur...
	 * bugzilla bug report 120269
	 * printf("DBG-a:scrolling...\n");*/
	gtk_tree_view_scroll_to_cell(treeview, treepath, NULL, TRUE, 0.0, 0.0);
    }

    cursor_reset(treeview);
    
    /*XXX gtk bug workaround */
    if (!IS_ROOT_TYPE(en->type)){
        gtk_tree_view_column_set_resizable(name_column, TRUE);
    }
   
    red_light=FALSE;
#ifdef DEBUG
	printf("DBG: open_dir, all done!\n"); 
#endif
   
}


void close_dir(GtkTreeView * treeview, GtkTreeIter * iter, GtkTreePath * path, gpointer user_data)
{
    tree_entry_t *en, *p_en;
    GtkTreeIter parent,child;
    static gchar **window_title=NULL;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    tree_details_t *tree_details = get_tree_details(treeview);

    if (!valid_iter(treeview,iter)){
	    local_monitor(treeview,TRUE);
	    return;
    }
    if(tree_details->loading)
    {
	/* this creates an endless loop: 
	 * gtk_tree_view_expand_row (treeview,treepath,FALSE);*/
	return;			/* Hey, push the stop button man! */
    }
    if (!window_title) {
	    window_title=(gchar **)malloc(sizeof(gchar *));
	    *window_title=NULL;
    }

    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if(!en) goto time2return;
    /*XXX gtk bug workaround */
    if (IS_ROOT_TYPE(en->type)){
        gtk_tree_view_column_set_resizable(name_column, TRUE);
    	gtk_tree_view_column_set_sizing(name_column, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
    }
    UNSET_EXPANDED(en->type);
    if(gtk_tree_model_iter_children(treemodel, &child, iter)){
      do {
	tree_entry_t *c_en;    
        gtk_tree_model_get(treemodel, &child, ENTRY_COLUMN, &c_en, -1);
	if (en && IS_DIR(en->type)) UNSET_EXPANDED(c_en->type);
      } while(gtk_tree_model_iter_next(treemodel, &child));
    }

    set_icon(treeview, iter);
    
#if 0
    if (IS_ROOT_TYPE(en->type) &&
	(IS_APP_TYPE(en->type)||IS_BOOKMARK_TYPE(en->type))
       )
    {
      remove_folder(treeview, iter);
    }
#endif
    
   if(IS_TRASH_TYPE(en->type))
    {
#if 0
	if(en->count > 512)
	{
	    remove_folder(treeview, iter);
	}
#endif
	/*set_select_path(treemodel,iter,tree_details); */
	print_status_tmp(treeview, resolve_icon_small(en), en->tag, NULL);

    }
    /*if(IS_LOCAL_TYPE(en->type))*/
    if(en->path)
    {
	g_free(*window_title);
	*window_title=NULL;
#if 0
	if(en->count > 512)
	{
	    /*printf("removing %s count=%u\n",en->path,en->count); */
	    remove_folder(treeview, iter);
	}
#endif
	if(gtk_tree_model_iter_parent(treemodel, &parent, iter))
	{
	    GtkTreePath *tpath=gtk_tree_path_copy(path);
	    gtk_tree_path_up(tpath);
	    gtk_tree_model_get(treemodel, &parent, ENTRY_COLUMN, &p_en, -1);
	    /*set_select_path(treemodel,&parent,tree_details); */
	    *window_title=g_strdup(p_en->path);
    	    if (title_reference) gtk_tree_row_reference_free(title_reference);
       	    title_reference = gtk_tree_row_reference_new(treemodel, tpath);
	    /*FIXME This might segv on race condition: */
	    print_status(treeview, resolve_folder_icon(p_en), p_en->tag, NULL);
	    set_path_reference(treeview,tpath);
	    gtk_tree_path_free(tpath);
	}
	else
	{
	    /*set_select_path(treemodel,iter,tree_details); */
	    *window_title=g_strdup(en->path);
    	    if (title_reference) gtk_tree_row_reference_free(title_reference);
       	    title_reference = gtk_tree_row_reference_new(treemodel, path);
	    print_status(treeview, resolve_folder_icon(en), en->tag, NULL);
	}
	set_title(treeview,window_title);
    }
  time2return:
    turn_on(treeview);
    tree_details->loading = FALSE;
}


/********************* callbacks **************************/

gboolean button_releaseF(GtkWidget * widget, GdkEventButton * event, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    tree_details_t *tree_details = get_tree_details(treeview);
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreePath *treepath;
    tree_entry_t *en;
    GtkTreeIter iter;

    
    if(tree_details->loading)	return FALSE;

   if(event->button == 1 && skip) 
    {
	skip = FALSE;
	return FALSE;
    }
    switch (event->button)
    {
	default:
	    break;
	case 4:
	case 5: /* these don't work ... */
	    break;
	case 3:
	    break;		/* not working for button 3, because of popup AFAICG */
	case 1:
	    if(gtk_tree_view_get_path_at_pos(treeview, event->x, event->y, 
				    &treepath, NULL, NULL, NULL))
	    {
		gchar *readable_path;
		gtk_tree_model_get_iter(treemodel, &iter, treepath);

		gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
		readable_path=g_strdup(FILENAME(en));
		if (IS_NETWORK_TYPE(en->type)&&!IS_SAMBA_SERVER(en->subtype))
			ascii_readable(readable_path);
		print_status_tmp(treeview, resolve_icon_small(en), 
				readable_path,
				NULL);
		g_free(readable_path);
		readable_path=NULL;
		set_path_reference(treeview,treepath);
		
		gtk_tree_path_free(treepath);
		turn_on(treeview);
	    }
	    
	    break;
	case 2:
	    if(gtk_tree_view_get_path_at_pos(treeview, event->x, event->y, &treepath, NULL, NULL, NULL))
	    {
		gtk_tree_model_get_iter(treemodel, &iter, treepath);
		gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
		/* trash and find entries always printout full path somewhere */
		if( en->path && 
		    (IS_LOCAL_TYPE(en->type) || !IS_ROOT_TYPE(en->type)) )
		{
		    gchar *readable_path;
		    char *icono = NULL;
		    if(IS_APP_TYPE(en->type) && en->filter){
			    readable_path=(gchar *)malloc(strlen(en->path)+strlen(en->filter)+2);
			    sprintf(readable_path,"%s %s",en->path,en->filter);
		    }
		    else readable_path=g_strdup(en->path);
		    if(IS_FIND_TYPE(en->type))
			icono = "xf_FIND_RESULT_ICON";
		    else if(IS_TRASH_TYPE(en->type))
			icono = "xf_TRASH_OPEN_ICON";
		    if (IS_NETWORK_TYPE(en->type)&&!IS_SAMBA_SERVER(en->subtype)){
			ascii_readable(readable_path);
		    } 
		    print_diagnostics(treeview, icono, 
				readable_path, "\n", NULL);
		    g_free(readable_path);
		    readable_path=NULL;
		}

		gtk_tree_path_free(treepath);
	    }
	    break;
    }
    return FALSE;
}

extern gboolean double_treeview;


gboolean treeclick(GtkWidget * widget, GdkEventButton * event, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    tree_details_t *tree_details = get_tree_details(treeview);
    tree_entry_t *en;
    GtkTreePath *treepath;
    GtkTreeIter iter,child;
    gchar *newpath=NULL;
    int type;

    if(tree_details->loading)
	return TRUE;

    if(tree_details->input)
    {
	cancel_input(treeview);
    }


    if (double_treeview ){
      static gboolean unsel(GtkTreeModel *,GtkTreePath *, GtkTreeIter *, gpointer);
      if (treeview == tree_details->treeview){
        /* unselect all in auxiliary treeview */
	GtkTreeView *treeview2=(GtkTreeView *)lookup_widget(tree_details->window,"treeview2");
        GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview2);
	gtk_tree_model_foreach(treemodel,unsel,selection);
      } else {
        /* unselect all in main treeview */
        GtkTreeSelection *selection = gtk_tree_view_get_selection(tree_details->treeview);
        gtk_tree_model_foreach(treemodel,unsel,selection);
      }
    }
    
    /*//if(event->state==GDK_CONTROL_MASK &&(event->button == 4 || event->button == 5)){
    if((event->button == 4 || event->button == 5)){
      printf("DBG:ctr button %d, state=%d\n",event->button,event->state);
	return TRUE;
    }*/
    
    if((event->type == GDK_2BUTTON_PRESS) && (event->button == 1))
    {				/* this works because item is selected at first click of double click */
	gtk_tree_selection_set_mode(selection, GTK_SELECTION_BROWSE);
	if(gtk_tree_selection_get_selected(selection, &treemodel, &iter))
	{
	    gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
	    newpath = g_strdup(en->path);
	    type = en->type;
	    if (IS_APP_TYPE(en->type) && !IS_ROOT_TYPE(en->type)){
		double_click_run(tree_details,en);
    		skip = TRUE;
		goto done;
	    }
	    if (IS_FSTAB_TYPE(en->type) && IS_XF_FSTAB(en->type)){
		    fstab_mount(treeview,en->path,IS_MOUNTED(en->type));	
		    goto done;
	    }
	    if(IS_DUMMY_TYPE(en->type) && en->path && strcmp(en->path, "..") == 0)
	    {
		/*tree_details->gogo = pushgo(treeview, newpath, tree_details->gogo);*/
		tb_go_up((GtkButton *) tree_details->window, NULL);
		goto done;
	    }
	    if (IS_DUMMY_TYPE(en->type)) goto done;

	    if(IS_PATH(en->type))
	    {
		if (IS_DIR(en->type))
		{
		    tree_details->gogo = pushgo(treeview, newpath, tree_details->gogo);
		    if (!IS_LOCAL_TYPE(en->type)){
    			GtkTreePath *treepath;
			treepath = gtk_tree_model_get_path(treemodel, &iter);
		    	gtk_tree_selection_unselect_path (selection,treepath);
		    	gtk_tree_path_free(treepath);
		    }
		    go_to(treeview, newpath);
		    /*go_to(tree_details->treeview, newpath);*/
		}

		else if(IS_EXE(en->type) )
		{	/* run it (if not registered)*/
			reg_t *prg = reg_prog_by_file (en->path);
			if (prg) double_click_open_with(tree_details,en);
			else {
    				/*  assume in_term to be safe */
    				SET_IN_TERM(en->subtype);
				double_click_run(tree_details,en);
			}
    			skip = TRUE;
		} else 
		{      /* open with */
			double_click_open_with(tree_details,en);
    			skip = TRUE;
		}
	    }
       	    else if(gtk_tree_model_iter_children(treemodel, &child, &iter)){
       		GtkTreePath *treepath;
       		treepath = gtk_tree_model_get_path(treemodel, &iter);
		gtk_tree_view_expand_row(treeview, treepath, FALSE);
       		gtk_tree_path_free(treepath);
	    }
done:
	    g_free(newpath);
	    newpath=NULL;
	}
	gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);
	return TRUE;
    }

    switch (event->button)
    {
	default:
	    break;
	case 3:
	    if(gtk_tree_view_get_path_at_pos(treeview, event->x, 
				    event->y, &treepath, 
				    NULL, NULL, NULL)){
		gtk_tree_selection_select_path(selection,treepath);    
       		gtk_tree_view_set_cursor (treeview,treepath,NULL,FALSE);
		gtk_tree_path_free(treepath);
	    }
	    do_popup(treeview, event);
	    return TRUE;
	case 2:		
	    return TRUE;	
	    /* this disables dnd (wrong), but also selection (right)*/
#if 0
	       return FALSE; 
	    /* this enables dnd(right), but also selection(wrong)*/
#endif
	case 1:
	    return FALSE;
    }
    return FALSE;
}

void on_double_click_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GdkEventButton event;
    event.button = 1;
    event.type = GDK_2BUTTON_PRESS;
    treeclick((GtkWidget *) menuitem, &event, user_data);
}

/**** callbacks ********/

static gboolean unsel(GtkTreeModel * treemodel, 
		GtkTreePath * treepath, 
		GtkTreeIter * iter, 
		gpointer data)
{
    GtkTreeSelection *selection = (GtkTreeSelection *)data;
    gtk_tree_selection_unselect_path (selection,treepath);
    return FALSE;
}
#if 0
static gboolean selall(GtkTreeModel * treemodel, 
		GtkTreePath * treepath, 
		GtkTreeIter * iter, 
		gpointer data)
{
    tree_entry_t *en;
    gboolean *result=data;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (title_en == en){
	    GtkTreePath *tpath;
	    /*printf("DBG: found!!!!!!\n");*/
	    *result=TRUE;
    	    if (title_reference) gtk_tree_row_reference_free(title_reference);
       	    title_reference = gtk_tree_row_reference_new(treemodel, treepath);
	    return TRUE;
    } 
    /*else {printf (".");fflush(NULL);}*/
    *result=FALSE;    
    return FALSE;
}
#endif


void on_unselect_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GtkTreeView *treeview = get_selected_treeview((GtkWidget *) menuitem);
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    gtk_tree_model_foreach(treemodel,unsel,selection);

}

void on_select_all_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GtkTreeView *treeview = get_selected_treeview((GtkWidget *) menuitem);
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreeIter child,parent;
    tree_entry_t *en;
    /*gboolean result;

    	gtk_tree_model_foreach(treemodel,selall,&result);
    	if (!result) return;*/
    
    	if (!title_reference) return;
	if(!gtk_tree_row_reference_valid(title_reference))
	   return ;
        if(!get_entry_from_reference(treeview, title_reference, &child, &en))
	   return ;
	
    	on_unselect_activate(menuitem,user_data);
	
	if (!IS_EXPANDED(en->type)){
	    if (!gtk_tree_model_iter_parent(treemodel,&parent,&child))
	         return;
	} else {
	    get_entry_from_reference(treeview, title_reference, &parent, &en);
	}
    
    
    	if (!gtk_tree_model_iter_children(treemodel,&child,&parent)) return;
    	do {
      	  gtk_tree_model_get(treemodel, &child, ENTRY_COLUMN, &en, -1);
      	  if (!IS_DUMMY_TYPE(en->type))
   		gtk_tree_selection_select_iter (selection,&child);
    	}
    	while (gtk_tree_model_iter_next(treemodel,&child));
}



