/*
 * Copyright (C) 2003 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>


#include <errno.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_gui.h"
#include "glade_support.h"
#include "glade_callbacks.h"

#include "constants.h"
#include "types.h"

#include "misc.h"
#include "run.h"

static char *diff_file[2];
static int diff_selected;

static void tag_select(GtkTreeModel * treemodel, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    tree_entry_t *en;
    /*GtkTreeView *treeview = (GtkTreeView *)data; */

    if(diff_selected >= 2)
	return;
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    diff_file[diff_selected++] = en->path;
    return;
}

static void do_diff(GtkTreeView * treeview)
{
    char *argv[4];
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    diff_selected = 0;
    diff_file[0] = diff_file[1] = NULL;
    gtk_tree_selection_selected_foreach(selection, tag_select, (gpointer) treeview);
    argv[0] = "xfdiff4";
    argv[1] = diff_file[0];
    argv[2] = diff_file[1];
    argv[3] = NULL;
    runv(treeview, argv);

}



void on_differences_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GtkTreeView *treeview = get_selected_treeview((GtkWidget *) menuitem);
    do_diff(treeview);

}


void tb_diff(GtkButton * button, gpointer user_data)
{
    GtkTreeView *treeview = get_selected_treeview((GtkWidget *) button);
    do_diff(treeview);

}
