/* ascii table for ksirc - Robbie Ward <linuxphreak@gmx.co.uk>*/

#include "charSelector.h"
#include "charSelector.moc"

#include <qlayout.h>
#include <qpushbutton.h>

#include <klocale.h>

charSelector::charSelector(QWidget *parent, const char* name)
           : KDialog(parent, name, false)
{
  testLayout = new QVBoxLayout(this);
  testLayout->setSpacing( spacingHint() );
  testLayout->setMargin( marginHint() );

  charSelect = new KCharSelect(this, QString::null, "", 0);
  testLayout->addWidget(charSelect);

  connect(charSelect, SIGNAL(doubleClicked()), SLOT(insertText()));

  QHBoxLayout *buttonLayout = new QHBoxLayout;
  buttonLayout->setSpacing( spacingHint() );

  insertButton = new QPushButton(i18n("&Insert Char"), this);
  connect(insertButton, SIGNAL(clicked()), SLOT(insertText()));
  buttonLayout->addWidget(insertButton);

  QSpacerItem *spacer = new QSpacerItem(50, 20, QSizePolicy::Expanding, QSizePolicy::Expanding);
  buttonLayout->addItem(spacer);

  testLayout->addLayout(buttonLayout);
}

void charSelector::insertText()
{
  emit clicked();
}
