/*
  Copyright (c) 2000 Caldera Systems

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __toplevel_h__
#define __toplevel_h__

#include <qmap.h>
#include <kmainwindow.h>

class ListView;
class ListViewItem;
class QWidgetStack;
class Wizard;
class QFrame;
class QuickHelp;
class QStatusBar;
class KXData;
class KXPageHandler;
class KXFreeConfig;
class QPushButton;

enum ConfigItem { iVideoCard = 0, iMonitor, iKeyboard, iPointerDevice, iScreen, iGeneral };

class TopLevel : public KMainWindow
{
    Q_OBJECT

public:
    TopLevel( KXFreeConfig *mConfig, bool ownX, QWidget* parent = 0, const char* name = 0, WFlags flags = 0);
    ~TopLevel();

    QStatusBar *myStatusBar() const { return m_statusBar; }

public slots:
    void updateItems();

private slots:
    void itemSelected(ListViewItem *item);
    void slotWizardRejected();
    void slotWizardAccepted();
    void help();
    void saveAndQuit();

private:
    void setupQuitButton( bool saveAndQuit );

    QWidgetStack *m_mainWidget;
    ListView *listview;
    Wizard *m_wizard;
    QFrame *m_introView;
    QuickHelp *quickHelp;
    QMap<ConfigItem, QString> m_names, m_icons;
    QStatusBar *m_statusBar;
    KXData *m_data;
    KXPageHandler *m_pageHandler;
    ListViewItem *m_videoCardItem;
    ListViewItem *m_monitorItem;
    ListViewItem *m_keyboardItem;
    ListViewItem *m_pointerItem;
    ListViewItem *m_screenItem;
    ListViewItem *m_generalItem;
    QPushButton *m_quitButton;

    KXFreeConfig *mConfig;
};

#endif
