/*
  Copyright (c) 2000 Caldera Systems

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __listview_h__
#define __listview_h__

#include <qscrollview.h>
#include <qptrlist.h>
#include <qframe.h>
#include <qpushbutton.h>

class QLabel;
class ListView;

class ListViewItem : public QFrame
{
    Q_OBJECT
    friend class ListView;
public:
    ListViewItem(int id, const QString& text, const QString& icon,
                 const QString& comment, ListView *listView,
                 QWidget* parent = 0, const char* name = 0);

    virtual ~ListViewItem() {}

    int id() const { return _id; }
    int heightForWidth(int w);

    QString text() const { return m_text; }
    QString icon() const { return m_icon; }
    QString comment() const { return m_comment; }

    void setComment( const QString &comment );

    bool eventFilter(QObject*, QEvent*);

signals:
    void selected(int id);
    void selected( ListViewItem *item );

protected:
    virtual void enterEvent(QEvent*ev);
    virtual void leaveEvent(QEvent*ev);
    virtual void focusInEvent( QFocusEvent *ev );
    virtual void focusOutEvent( QFocusEvent *ev );
    virtual void keyPressEvent( QKeyEvent *ev );
    virtual void keyReleaseEvent( QKeyEvent *ev );

    void setHighlighted(bool);

private:
    int _id;
    QLabel *namel, *commentl, *iconl;
    QString m_text, m_comment, m_icon;
    ListView *m_listView;
    bool m_doubleClicked;
};

class ListView : public QScrollView
{
    Q_OBJECT
    friend class ListViewItem;
public:
    ListView(QWidget* parent = 0, const char* name = 0);
    ~ListView();

    ListViewItem *insertItem(int id, const QString& name, const QString& comment, const QString& icon);

signals:
    void itemSelected(int id);
    void itemSelected( ListViewItem *item );

protected:
    void relayout();
    virtual void resizeEvent(QResizeEvent*);
    virtual void keyReleaseEvent( QKeyEvent *ev );

    void setCurrentItem( ListViewItem *item );

private:
    QPtrList<ListViewItem> items;
};

#endif
